/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.asm.ASMMode;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.cmdtools.OSDBAGRPUtil;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.common.VerboseListener;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSNeedForceException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.crs.VersionMismatchException;
import oracle.cluster.database.AlreadyInOptionException;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseOptionalArgs;
import oracle.cluster.database.DatabaseStopArgs;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.FailoverRestore;
import oracle.cluster.database.IncompatibleOptionException;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.MoveDatabaseException;
import oracle.cluster.database.OSDBAGroup;
import oracle.cluster.database.SIDBType;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceCardinality;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceStopArgs;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.ServiceType;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.deployment.DBServiceOperationInfo;
import oracle.cluster.home.HomeException;
import oracle.cluster.home.HomeFactory;
import oracle.cluster.home.OracleHome;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.ASMImpl;
import oracle.cluster.impl.asm.AsmClusterFileSystemImpl;
import oracle.cluster.impl.asm.DiskGroupImpl;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.CRSServerGroupEntity;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSCompositeOperationException;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.crs.cops.RTEArg;
import oracle.cluster.impl.crs.cops.RTENativeException;
import oracle.cluster.impl.crs.cops.RTENativeResult;
import oracle.cluster.impl.database.CardinalDatabaseImpl;
import oracle.cluster.impl.database.CardinalServiceImpl;
import oracle.cluster.impl.database.Common;
import oracle.cluster.impl.database.CompositeDatabaseActionStatus;
import oracle.cluster.impl.database.DBFilterFactory;
import oracle.cluster.impl.database.DBServicesSelectionImpl;
import oracle.cluster.impl.database.DatabaseAction;
import oracle.cluster.impl.database.DatabaseActionStatus;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.database.DatabaseInstanceImpl;
import oracle.cluster.impl.database.HAServiceImpl;
import oracle.cluster.impl.database.MutableMoveDatabaseException;
import oracle.cluster.impl.database.RACOneNodeDatabaseImpl;
import oracle.cluster.impl.database.RACOneNodeServiceImpl;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.impl.database.SingleInstanceDatabaseImpl;
import oracle.cluster.impl.database.SingleInstanceServiceImpl;
import oracle.cluster.impl.gns.GNSImpl;
import oracle.cluster.impl.nodeapps.ListenerImpl;
import oracle.cluster.impl.nodeapps.ONSImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.nfs.NFS;
import oracle.cluster.nfs.NFSFactory;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyDowngradedException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.AlreadyUpgradedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class DatabaseImpl
extends SoftwareModuleImpl
implements Database {
    static final int MAX_INSTANCE_LEN = 12;
    static final int DRAIN_ACTION_INTERVAL = 20;
    protected static final int RAC_ONE_NODE_DB_FT = 2;
    protected ResourceAttribute m_nameAttr;
    private MessageBundle m_msgBndl = MessageBundle.getMessageBundle(PrCdMsgID.facility);
    protected DatabaseAction m_DbAction = null;
    private static final String INST_PREFIX_CHARSET = "[a-zA-Z0-9]*";
    public static final String STATE_DETAILS_HOME_KEY = "HOME=";

    DatabaseImpl(ResourceAttribute nameAttr) throws DatabaseException {
        this(nameAttr, new Version());
    }

    DatabaseImpl(ResourceAttribute nameAttr, Version version) throws DatabaseException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.Database.NAME.name())) {
                throw new DatabaseException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.Database.NAME.name());
            }
            String[] value = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            if (!(value.length == 3 && "ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) && ResourceLiterals.DB.toString().equalsIgnoreCase(value[2]) || value.length == 2 && "ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) && ResourceLiterals.MGMTDB.toString().equalsIgnoreCase(value[1]))) {
                throw new DatabaseException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.Database.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_version = version;
            this.m_DbAction = new DatabaseAction(this);
            this.m_displayName = value[1];
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().getRegisteredOrNot(this.m_nameAttr);
            try {
                this.m_displayName = this.getDBUniqueName();
            }
            catch (DatabaseException databaseException) {}
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    DatabaseImpl(String resourceName, SnapshotImpl snapshot) throws DatabaseException {
        this.m_nameAttr = new ResourceAttribute(ResourceType.Database.NAME.name(), resourceName);
        this.m_name = resourceName;
        this.m_version = snapshot.getResourceVersion(resourceName);
        this.m_DbAction = new DatabaseAction(this);
        this.m_displayName = snapshot.getDBUniqueName(resourceName);
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().getSnapshotResource(this.m_nameAttr, snapshot);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    DatabaseImpl(String resourceName, EntityOperations.EntityOpsMode mode, DatabaseOptionalArgs dbArgs) throws DatabaseException {
        this.m_name = resourceName;
        this.m_nameAttr = new ResourceAttribute(ResourceType.Database.NAME.name(), resourceName);
        this.m_version = new Version();
        this.m_DbAction = new DatabaseAction(this);
        this.m_displayName = DatabaseImpl.getUserAssignedName(resourceName);
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().getResource(this.m_nameAttr, mode);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    void create(String dbUniqueName, List<ServerGroup> serverGroupList, boolean isClusterDB, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        this.create(dbUniqueName, serverGroupList, isClusterDB ? DatabaseType.RAC : DatabaseType.SIDB, oracleHome, databaseOptions, version);
    }

    void create(String dbUniqueName, List<ServerGroup> serverGroupList, DatabaseType dbType, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        this.create(dbUniqueName, serverGroupList, dbType, oracleHome, databaseOptions, version, false);
    }

    void create(String dbUniqueName, String nodeName, String oracleHome, boolean isFixed) throws AlreadyExistsException, DatabaseException {
        DatabaseOptionalArgs databaseOptions = new DatabaseOptionalArgs();
        this.create(dbUniqueName, nodeName, oracleHome, isFixed, databaseOptions);
    }

    void create(String dbUniqueName, String nodeName, String oracleHome, boolean isFixed, DatabaseOptionalArgs databaseOptions) throws AlreadyExistsException, DatabaseException {
        ArrayList<ServerGroup> sglist = new ArrayList<ServerGroup>(1);
        String dbResName = DatabaseFactory.getDatabaseResourceName(dbUniqueName);
        try {
            if (nodeName == null || nodeName.trim().length() == 0) {
                throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
            }
            if (!isFixed) {
                ServerFactory sf = ServerFactory.getInstance();
                Node node = ServerFactory.getInstance().getNode(nodeName);
                sglist.add(sf.getServerGroup(ServerFactory.BuiltinServerGroup.LEGACY_SERVER_GROUP.toString()));
                ServerGroup newsg = sf.createServerGroup(dbUniqueName, 0, 1, sglist);
                newsg.setImportance(1);
                Server newserv = sf.createServer(node);
                ArrayList<Server> newslist = new ArrayList<Server>(1);
                newslist.add(newserv);
                newsg.addServers(newslist);
                sglist.remove(0);
                sglist.add(newsg);
            }
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, dbResName, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, dbResName, this.getUserAssignedName());
        }
        catch (ServerGroupException e) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, dbResName, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, dbResName, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, dbResName, this.getUserAssignedName());
        }
        catch (CompositeOperationException e) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, dbResName, this.getUserAssignedName());
        }
        Trace.out("Creating SIDB resource");
        if (isFixed) {
            this.create(dbUniqueName, null, nodeName, DatabaseType.SIDB, oracleHome, databaseOptions, new Version(), false);
        } else {
            this.create(dbUniqueName, sglist, null, DatabaseType.SIDB, oracleHome, databaseOptions, new Version(), false);
        }
    }

    void create(String dbUniqueName, List<ServerGroup> serverGroupList, DatabaseType dbType, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version, boolean onlyUpdate) throws AlreadyExistsException, DatabaseException {
        this.create(dbUniqueName, serverGroupList, null, dbType, oracleHome, databaseOptions, version, onlyUpdate);
    }

    private void create(String dbUniqueName, List<ServerGroup> serverGroupList, String nodeName, DatabaseType dbType, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version, boolean onlyUpdate) throws AlreadyExistsException, DatabaseException {
        block133: {
            boolean isCluster = Cluster.isCluster();
            boolean dbCentric = true;
            List<ServerGroup> pqpools = null;
            boolean isInSG = false;
            boolean isFixed = nodeName != null;
            DBRole dbRole = null;
            StartOptions startMode = null;
            try {
                if (serverGroupList != null && nodeName != null && dbType != DatabaseType.MGMTDB) {
                    throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
                }
                if (serverGroupList != null) {
                    for (ServerGroup sg : serverGroupList) {
                        Common.checkPrimaryServerCategory(sg);
                    }
                }
                if (onlyUpdate && serverGroupList == null) {
                    if (nodeName == null) {
                        serverGroupList = new ArrayList<ServerGroup>();
                    } else {
                        throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
                    }
                }
                Trace.out("databaseOptions is " + databaseOptions);
                if (databaseOptions != null) {
                    dbRole = databaseOptions.getDBRole();
                    pqpools = databaseOptions.getPQPools();
                    startMode = databaseOptions.getStartMode();
                    if (dbRole == DBRole.FAR_SYNC) {
                        if (dbType == DatabaseType.RACOneNode) {
                            Trace.out("Far sync database " + dbUniqueName + " cannot be created in RACONENODE configuration");
                            throw new DatabaseException((MessageKey)PrCdMsgID.FARSYNC_NO_RACONENODE, dbUniqueName);
                        }
                        if (pqpools != null) {
                            Trace.out("Far sync database " + dbUniqueName + " cannot be created with PQ pools");
                            throw new DatabaseException((MessageKey)PrCdMsgID.FARSYNC_NO_PQPOOLS, dbUniqueName, DatabaseImpl.getServerGroupString(pqpools, String.valueOf(","), true));
                        }
                        if (startMode != null) {
                            if (startMode == StartOptions.OPEN) {
                                Trace.out("Far sync database " + dbUniqueName + " cannot be created OPEN start option");
                                throw new DatabaseException((MessageKey)PrCdMsgID.FARSYNC_CANNOT_OPEN, dbUniqueName);
                            }
                        } else {
                            startMode = StartOptions.MOUNT;
                        }
                    }
                    if (pqpools != null && pqpools.size() > 0 && dbType != DatabaseType.MGMTDB) {
                        for (ServerGroup pqg : pqpools) {
                            Common.checkPQServerCategory(pqg);
                            isInSG = false;
                            if (serverGroupList != null) {
                                for (ServerGroup sg : serverGroupList) {
                                    if (sg == null || !sg.getName().equals(pqg.getName())) continue;
                                    isInSG = true;
                                }
                            }
                            if (isInSG) continue;
                            serverGroupList.add(pqg);
                        }
                    }
                }
                if (isCluster && !isFixed) {
                    if ((dbType == DatabaseType.RACOneNode || dbType == DatabaseType.SIDB) && serverGroupList.size() != 1) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_SINGLEDB_SP_LIST, DatabaseImpl.getServerGroupString(serverGroupList, String.valueOf(","), true), dbUniqueName);
                    }
                    if (dbType == DatabaseType.SIDB) {
                        ServerGroup sg;
                        ServerFactory sf = ServerFactory.getInstance();
                        sg = serverGroupList.get(0);
                        List<Server> servers = sg.configuredServers();
                        int serversSize = servers.size();
                        if (serversSize == 0) {
                            throw new DatabaseException((MessageKey)PrCdMsgID.NO_SERVER_FOR_SI_DB, true, new Object[]{sg.getUserAssignedName(), dbUniqueName});
                        }
                        if (serversSize > 1) {
                            throw new DatabaseException((MessageKey)PrCdMsgID.TOO_MANY_SERVERS_FOR_SI_DB, true, new Object[]{sg.getUserAssignedName()});
                        }
                        int sgMaxSize = sg.getMaxSize();
                        if (sgMaxSize != 1) {
                            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_SG_SIZE_FOR_SI_DB, true, new Object[]{sg.getUserAssignedName(), sgMaxSize, dbUniqueName});
                        }
                    }
                    if (dbType != DatabaseType.MGMTDB && !onlyUpdate) {
                        Trace.out("Checking server group configuration");
                        for (ServerGroup sg : serverGroupList) {
                            if (!(dbCentric &= !sg.isServerPool())) continue;
                            if (serverGroupList.size() > 1) {
                                throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_DB_CENTRIC_CONFIG, dbUniqueName, DatabaseImpl.getServerGroupString(serverGroupList, String.valueOf(","), true));
                            }
                            List<Database> dbList = sg.databases();
                            List<Service> svcList = sg.services();
                            StringBuilder dbSb = new StringBuilder();
                            StringBuilder svcSb = new StringBuilder();
                            for (Database db : dbList) {
                                if (dbSb.length() > 0) {
                                    dbSb.append("," + db.getUserAssignedName());
                                    continue;
                                }
                                dbSb.append(db.getUserAssignedName());
                            }
                            for (Service svc : svcList) {
                                if (svcSb.length() > 0) {
                                    svcSb.append("," + svc.getUserAssignedName());
                                    continue;
                                }
                                svcSb.append(svc.getUserAssignedName());
                            }
                            if (dbSb.length() > 0 && svcSb.length() > 0) {
                                throw new DatabaseException((MessageKey)PrCdMsgID.EXISTING_DB_CENTRIC_CONFIG, sg.getUserAssignedName(), dbUniqueName, dbSb.toString(), svcSb.toString());
                            }
                            if (dbSb.length() > 0) {
                                throw new DatabaseException((MessageKey)PrCdMsgID.EXISTING_DB_CENTRIC_CONFIG_DB, sg.getUserAssignedName(), dbUniqueName, dbSb.toString());
                            }
                            if (svcSb.length() > 0) {
                                throw new DatabaseException((MessageKey)PrCdMsgID.EXISTING_DB_CENTRIC_CONFIG_SERV, sg.getUserAssignedName(), dbUniqueName, svcSb.toString());
                            }
                            Trace.out("no existing db or service hosted by server group, " + sg.getUserAssignedName());
                        }
                    }
                }
                Trace.out("Done with server group check: AdminManaged=" + dbCentric);
                String dbName = null;
                String dbDomain = null;
                String instName = null;
                String spfile = null;
                String pwfile = null;
                StopOptions stopMode = null;
                ManagementPolicy mgmtPolicy = null;
                List<DiskGroup> diskGroupList = null;
                List<String> acfsPaths = null;
                Map<String, Node> instNodeMap = null;
                int omTimeout = 0;
                int startConcurrency = 0;
                int stopConcurrency = 0;
                ResourceAttribute aclAttr = null;
                CRSResource.CSSCritical cssCritical = null;
                Integer cpuCount = null;
                Integer memTarget = null;
                Integer maxMemory = null;
                Integer cpuCap = null;
                Network defaultNetwork = null;
                Trace.out("databaseOptions is " + databaseOptions);
                if (databaseOptions != null) {
                    mgmtPolicy = databaseOptions.getMgmtPolicy();
                    if (dbType == DatabaseType.RACOneNode) {
                        if (ManagementPolicy.MANUAL == mgmtPolicy || ManagementPolicy.NORESTART == mgmtPolicy) {
                            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_MGMT_POLICY_FOR_RACONE, mgmtPolicy.toString(), dbUniqueName);
                        }
                        omTimeout = databaseOptions.getOnlineRelocationTimeout();
                        if (omTimeout <= 0) {
                            omTimeout = 30;
                        }
                    }
                    dbName = databaseOptions.getDBName();
                    dbDomain = databaseOptions.getDBDomain();
                    instName = databaseOptions.getInstanceName();
                    spfile = databaseOptions.getSPFile();
                    pwfile = databaseOptions.getPWFile();
                    stopMode = databaseOptions.getStopMode();
                    diskGroupList = databaseOptions.getDiskGroupList();
                    acfsPaths = databaseOptions.getACFSPaths();
                    instNodeMap = databaseOptions.getInstNodeMap();
                    startConcurrency = databaseOptions.getStartConcurrency();
                    stopConcurrency = databaseOptions.getStopConcurrency();
                    cssCritical = databaseOptions.getCSSCriticalOption();
                    defaultNetwork = databaseOptions.getDefaultNetwork();
                    if (!dbCentric && cssCritical != null) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.CSS_CRITICAL_NA, dbUniqueName);
                    }
                    cpuCount = databaseOptions.getCPUCount();
                    memTarget = databaseOptions.getMemoryTarget();
                    maxMemory = databaseOptions.getMaxMemory();
                    cpuCap = databaseOptions.getCPUCap();
                }
                List<AsmClusterFileSystem> acfsList = null;
                NFS nfs = null;
                if (dbType != DatabaseType.MGMTDB) {
                    if (!onlyUpdate) {
                        acfsList = this.validateACFSPaths(acfsPaths, oracleHome);
                    }
                    if (!onlyUpdate) {
                        nfs = this.validateNFSPath(oracleHome);
                    }
                }
                if (instName == null && (dbType == DatabaseType.RACOneNode || dbType == DatabaseType.SIDB)) {
                    int len = 0;
                    int nameLen = Math.min(dbUniqueName.length(), 12);
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < dbUniqueName.length(); ++i) {
                        char c = dbUniqueName.charAt(i);
                        if (!Character.isLetterOrDigit(c)) continue;
                        sb.append(c);
                        if (++len == nameLen) break;
                    }
                    instName = sb.toString();
                    Trace.out("instName = " + instName);
                } else if (dbType == DatabaseType.RACOneNode && !instName.matches(INST_PREFIX_CHARSET)) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_INSTANCE_PREFIX, instName);
                }
                if (dbType != DatabaseType.MGMTDB) {
                    DatabaseImpl.validateName(dbUniqueName, false);
                    if (dbName != null && dbName.trim().length() > 0) {
                        DatabaseImpl.validateName(dbName, false);
                    }
                    if (instName != null && instName.trim().length() > 0) {
                        DatabaseImpl.validateName(instName, true);
                    }
                }
                if (instNodeMap != null && dbType != DatabaseType.MGMTDB) {
                    for (String iName : instNodeMap.keySet()) {
                        if (iName == null || iName.trim().length() <= 0) continue;
                        Trace.out("instance Name = " + iName);
                        DatabaseImpl.validateName(iName, true);
                    }
                }
                if (dbType == DatabaseType.RACOneNode && !instName.endsWith("_1")) {
                    instName = instName + '_' + "1";
                }
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                ResourceAttribute dbTypeAttr = null;
                dbTypeAttr = dbType == DatabaseType.MGMTDB ? crsFactory.create(ResourceType.MgmtDatabase.NAME.name(), ResourceType.MgmtDatabase.NAME.toString()) : crsFactory.create(ResourceType.Database.NAME.name(), ResourceType.Database.NAME.toString());
                if (!onlyUpdate && dbType != DatabaseType.MGMTDB) {
                    aclAttr = this.getACLAttr(oracleHome, version);
                }
                if (!crsFactory.isRegistered(dbTypeAttr.getValue(), CRSEntity.Type.ResourceType)) {
                    if (dbType == DatabaseType.MGMTDB) {
                        if (!crsFactory.isRegistered(ResourceType.ClusterResource.NAME.toString(), CRSEntity.Type.ResourceType)) {
                            Trace.out("ora.cluster_resource.type does not exist, create it");
                            List<ResourceAttribute> attrList = ResourceType.getAttributes(ResourceType.ClusterResource.class);
                            crsFactory.create(CRSEntity.Type.ResourceType, attrList);
                        } else {
                            Trace.out("ora.cluster_resource.type exists");
                        }
                        Trace.out("ora.mgmtdb.type does not exist, create it");
                        List<ResourceAttribute> attrList = ResourceType.getAttributes(ResourceType.MgmtDatabase.class);
                        crsFactory.create(CRSEntity.Type.ResourceType, attrList);
                    } else {
                        Trace.out("Calling createResourceTypes when creating database");
                        crsFactory.createResourceTypes();
                    }
                }
                List<ResourceAttribute> dgAttrList = this.getDiskGroupAttrList(diskGroupList);
                List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(dbTypeAttr).getAttributes(new String[0]);
                attrList = ResourceType.getProfile(attrList);
                Trace.out("Updating database attributes");
                for (ResourceAttribute attr : attrList) {
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.NAME.name())) {
                        attr.setValue(this.m_nameAttr.getValue());
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.DESCRIPTION.name())) {
                        attr.setValue(ResourceLiterals.DB_RES_DESC.toString());
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.DB_UNIQUE_NAME.name())) {
                        Trace.out("dbUniqueName = " + dbUniqueName);
                        attr.setValue(dbUniqueName);
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.CLUSTER_DATABASE.name()) && dbType == DatabaseType.SIDB) {
                        attr.setValue(Boolean.valueOf(false).toString().toLowerCase());
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.ORACLE_HOME.name())) {
                        if (dbType == DatabaseType.MGMTDB || onlyUpdate) continue;
                        attr.setValue(oracleHome);
                        continue;
                    }
                    if (isCluster && attr.getName().equalsIgnoreCase(ResourceType.Database.SERVER_POOLS.name())) {
                        if (dbType == DatabaseType.MGMTDB || isFixed) {
                            attr.setValue(ResourceLiterals.STAR.toString());
                            continue;
                        }
                        if (onlyUpdate && (!onlyUpdate || serverGroupList == null)) continue;
                        attr.setValue(DatabaseImpl.getServerGroupString(serverGroupList, String.valueOf(" "), false));
                        continue;
                    }
                    if (spfile != null && attr.getName().equalsIgnoreCase(ResourceType.Database.SPFILE.name())) {
                        attr.setValue(spfile);
                        continue;
                    }
                    if (pwfile != null && attr.getName().equalsIgnoreCase(ResourceType.Database.PWFILE.name())) {
                        if (pwfile.length() > 0 && pwfile.startsWith(ResourceLiterals.PLUS.toString())) {
                            DiskGroup pwFileDg;
                            int slashIndex;
                            int n = slashIndex = pwfile.indexOf("/") == -1 ? pwfile.indexOf(92) : pwfile.indexOf("/");
                            if (slashIndex == -1) {
                                throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_PWFILE, pwfile);
                            }
                            String dgName = pwfile.substring(1, slashIndex);
                            ASMFactory af = ASMFactory.getInstance();
                            if (!ASMFactory.isClientMode() && (pwFileDg = af.getDiskGroup(dgName)) != null) {
                                pwFileDg.setASMPullUp();
                            }
                        }
                        attr.setValue(pwfile);
                        continue;
                    }
                    if (dbName != null && dbType != DatabaseType.MGMTDB && attr.getName().equalsIgnoreCase(ResourceType.Database.USR_ORA_DB_NAME.name())) {
                        attr.setValue(dbName);
                        continue;
                    }
                    if (dbDomain != null && attr.getName().equalsIgnoreCase(ResourceType.Database.USR_ORA_DOMAIN.name())) {
                        attr.setValue(dbDomain);
                        continue;
                    }
                    if (instName != null && attr.getName().equalsIgnoreCase(ResourceType.Database.USR_ORA_INST_NAME.name())) {
                        attr.setValue(instName);
                        continue;
                    }
                    if (dbRole != null && attr.getName().equalsIgnoreCase(ResourceType.Database.ROLE.name())) {
                        attr.setValue(dbRole.toString());
                        continue;
                    }
                    if (mgmtPolicy != null && attr.getName().equalsIgnoreCase(ResourceType.Database.MANAGEMENT_POLICY.name())) {
                        attr.setValue(mgmtPolicy.toString());
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.RESTART_ATTEMPTS.name())) {
                        if (dbType == DatabaseType.RACOneNode) {
                            attr.setValue(ResourceLiterals.RESTART_ATTEMPTS_RACONE.toString());
                            continue;
                        }
                        if (mgmtPolicy != null && ManagementPolicy.MANUAL == mgmtPolicy) {
                            attr.setValue(ResourceLiterals.MANUAL_MGMT_RA.toString());
                            continue;
                        }
                        if (mgmtPolicy == null || ManagementPolicy.NORESTART != mgmtPolicy) continue;
                        attr.setValue(ResourceLiterals.NORESTART_MGMT_RA.toString());
                        continue;
                    }
                    if (startMode != null && attr.getName().equalsIgnoreCase(ResourceType.Database.USR_ORA_OPEN_MODE.name())) {
                        attr.setValue(startMode.toString());
                        continue;
                    }
                    if (stopMode != null && attr.getName().equalsIgnoreCase(ResourceType.Database.USR_ORA_STOP_MODE.name())) {
                        attr.setValue(stopMode.toString());
                        continue;
                    }
                    if (dbCentric && attr.getName().equalsIgnoreCase(ResourceType.Database.INSTANCE_FAILOVER.name()) && dbType == DatabaseType.RAC) {
                        attr.setValue(ResourceLiterals.DISABLED_VALUE.toString());
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.ONLINE_RELOCATION_TIMEOUT.name()) && dbType == DatabaseType.RACOneNode) {
                        attr.setValue(String.valueOf(omTimeout));
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.DATABASE_TYPE.name())) {
                        if (onlyUpdate && (!onlyUpdate || dbType == null)) continue;
                        attr.setValue(dbType.toString());
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.DEFAULT_TEMPLATE.name())) {
                        attr.setValue(DatabaseImpl.getEvtTemplate(version));
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.FAILURE_THRESHOLD.name()) && dbType == DatabaseType.RACOneNode) {
                        attr.setValue(String.valueOf(2));
                        continue;
                    }
                    if (pqpools != null && dbType != DatabaseType.MGMTDB && attr.getName().equalsIgnoreCase(ResourceType.Database.SERVER_POOLS_PQ.name())) {
                        String pqpoolStr = DatabaseImpl.getServerGroupString(pqpools, String.valueOf(" "), false);
                        Trace.out("Set pq pools for database resource: " + pqpoolStr);
                        attr.setValue(String.valueOf(pqpoolStr));
                        continue;
                    }
                    if (attr.getName().equalsIgnoreCase(ResourceType.Database.ACTIONS.name())) {
                        if (aclAttr != null) {
                            attr.setValue(Common.createActionsAttr(aclAttr.getValue(), ResourceType.Database.NAME.toString(), this.m_nameAttr.getValue()));
                        } else {
                            attr.setValue(Common.createActionsAttr(null, ResourceType.Database.NAME.toString(), this.m_nameAttr.getValue()));
                        }
                        Trace.out("Created ACTIONS attribute");
                        continue;
                    }
                    if (defaultNetwork == null || !attr.getName().equalsIgnoreCase(ResourceType.Database.DEFAULT_NETNUM.name())) continue;
                    attr.setValue(String.valueOf(defaultNetwork.getNumber()));
                }
                if (isFixed) {
                    attrList.add(crsFactory.create(ResourceType.ClusterVIP.HOSTING_MEMBERS.name(), nodeName));
                    Trace.out("Setting HOSTING_MEMBERS = " + nodeName);
                }
                if (mgmtPolicy != null || dbType == DatabaseType.MGMTDB) {
                    if (mgmtPolicy == ManagementPolicy.AUTOMATIC || dbType == DatabaseType.MGMTDB) {
                        attrList.add(crsFactory.create(ResourceType.ClusterResource.AUTO_START.name(), CRSResource.AutoStart.RESTORE.toString()));
                    } else if (mgmtPolicy == ManagementPolicy.MANUAL || mgmtPolicy == ManagementPolicy.NORESTART) {
                        attrList.add(crsFactory.create(ResourceType.ClusterResource.AUTO_START.name(), CRSResource.AutoStart.NEVER.toString()));
                    }
                }
                attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
                if (!isCluster) {
                    attrList.add(crsFactory.create(ResourceType.ClusterResource.PLACEMENT.name(), "balanced"));
                    attrList.add(aclAttr);
                }
                if (instNodeMap != null && dbType == DatabaseType.RAC) {
                    Trace.out("Creating USR_ORA_INST_NAME@NODENAME....");
                    for (String iName : instNodeMap.keySet()) {
                        Node node = instNodeMap.get(iName);
                        String nodename = node.getName();
                        Trace.out("nodeName = " + nodename + ", instanceName = " + iName);
                        attrList.add(crsFactory.create(ResourceType.getPerXName(ResourceType.Database.USR_ORA_INST_NAME.name(), nodename), iName));
                    }
                }
                if (dbType == DatabaseType.RACOneNode || dbType == DatabaseType.SIDB || dbType == DatabaseType.MGMTDB) {
                    attrList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), String.valueOf(1)));
                } else if (dbType == DatabaseType.RAC) {
                    if (dbCentric && instNodeMap != null && instNodeMap.size() > 0) {
                        Trace.out("adding cardinality of size " + instNodeMap.size() + " to the admin managed db");
                        attrList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), String.valueOf(instNodeMap.size())));
                    } else {
                        attrList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), ResourceLiterals.CRS_SERVER_POOL_SIZE_CARDINALITY.toString()));
                    }
                }
                if (startConcurrency > 0) {
                    attrList.add(crsFactory.create(ResourceType.ClusterResource.START_CONCURRENCY.name(), String.valueOf(startConcurrency)));
                }
                if (stopConcurrency > 0) {
                    attrList.add(crsFactory.create(ResourceType.ClusterResource.STOP_CONCURRENCY.name(), String.valueOf(stopConcurrency)));
                }
                attrList.add(crsFactory.create(ResourceType.Database.CSS_CRITICAL.name(), cssCritical != null ? cssCritical.toString() : ResourceType.Database.CSS_CRITICAL.toString()));
                if (cpuCount != null) {
                    attrList.add(crsFactory.create(ResourceType.Database.WORKLOAD_CPU.name(), cpuCount.toString()));
                }
                if (memTarget != null) {
                    attrList.add(crsFactory.create(ResourceType.Database.WORKLOAD_MEMORY_TARGET.name(), memTarget.toString()));
                }
                if (maxMemory != null) {
                    attrList.add(crsFactory.create(ResourceType.Database.WORKLOAD_MEMORY_MAX.name(), maxMemory.toString()));
                }
                Trace.out("Creating dependencies");
                ManagementPolicy mp = mgmtPolicy;
                if (mgmtPolicy == null || dbType == DatabaseType.MGMTDB) {
                    mp = ManagementPolicy.AUTOMATIC;
                }
                if (!onlyUpdate) {
                    ResourceAttribute[] startDep = this.createStartDepRTE(dgAttrList, acfsList, nfs, mp, dbType, oracleHome, dbCentric);
                    ResourceAttribute[] stopDep = this.createStopDepRTE(dgAttrList, acfsList, nfs, oracleHome, dbType);
                    attrList.addAll(Arrays.asList(startDep));
                    attrList.addAll(Arrays.asList(stopDep));
                }
                if (!onlyUpdate) {
                    if (aclAttr != null) {
                        attrList.add(aclAttr);
                    } else if (dbType == DatabaseType.MGMTDB) {
                        ResourcePermissionsImpl per = CRSFactoryImpl.getInstance().createPerm(ResourceType.ACL_CREATOR.CRS_USER);
                        if (new SystemFactory().CreateSystem().isUnixSystem()) {
                            try {
                                Util utl = new Util();
                                String owner = per.getOwner();
                                String pGroup = utl.getPrimaryGroup(owner);
                                per.setPerm(ResourceType.ACL.PGROUP, pGroup, ResourceType.ACL_PERM.READ);
                                String crsHome = utl.getCRSHome();
                                String group = utl.getOracleGroup(crsHome);
                                per.setPerm(ResourceType.ACL.GROUP, group, ResourceType.ACL_PERM.READ);
                            }
                            catch (UtilException e) {
                                Trace.out((Exception)((Object)e));
                                throw new ListenerException(e);
                            }
                        }
                        per.setPerm(ResourceType.ACL.OTHER, "", ResourceType.ACL_PERM.READ);
                        String acl = ResourceLiterals.ACL_ATTR.toString();
                        ResourceAttribute acMgmtDBlAttr = new ResourceAttribute(acl, per.getAclString());
                        Trace.out("ACL string[" + per.getAclString() + "]");
                        attrList.add(acMgmtDBlAttr);
                    }
                    this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
                    this.m_displayName = dbUniqueName;
                    Trace.out("Successfully creating database resource");
                    this.m_DbAction = new DatabaseAction(this);
                } else {
                    this.m_crsResource.update(attrList);
                }
                if (onlyUpdate) break block133;
                if (dbType != DatabaseType.MGMTDB && !new SystemFactory().CreateSystem().isUnixSystem()) {
                    ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                    perm.ntGrantHomeUserPermissions(oracleHome, version, true);
                    perm.ntGrantOraInstallPermissions();
                    this.m_crsResource.setPermissions(perm);
                    break block133;
                }
                if (Version.isPre12c(version)) break block133;
                if (dbType == DatabaseType.MGMTDB) {
                    try {
                        Util util = new Util();
                        oracleHome = util.getCRSHome();
                    }
                    catch (UtilException e) {
                        Trace.out("util exception : " + e.getMessage());
                        throw new DatabaseException(e);
                    }
                    Trace.out("got " + oracleHome + " as mgmt db home");
                }
                this.ntGrantAclsForTransparentHA(oracleHome, this.m_crsResource, version);
            }
            catch (AlreadyExistsException e) {
                throw new AlreadyExistsException((MessageKey)PrCdMsgID.DB_ALREADY_EXISTS, (Throwable)e, this.getUserAssignedName());
            }
            catch (CRSException e) {
                if (onlyUpdate) {
                    throw new DatabaseException((MessageKey)PrCrMsgID.WHATIF_RETURNED_ERROR, e.getMessage());
                }
                throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            catch (NodeException e) {
                if (onlyUpdate) {
                    throw new DatabaseException((MessageKey)PrCrMsgID.WHATIF_RETURNED_ERROR, e.getMessage());
                }
                throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            catch (ServerException e) {
                if (onlyUpdate) {
                    throw new DatabaseException((MessageKey)PrCrMsgID.WHATIF_RETURNED_ERROR, e.getMessage());
                }
                throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            catch (SoftwareModuleException e) {
                if (onlyUpdate) {
                    throw new DatabaseException((MessageKey)PrCrMsgID.WHATIF_RETURNED_ERROR, e.getMessage());
                }
                throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
            catch (NotExistsException e) {
                if (onlyUpdate) {
                    throw new DatabaseException((MessageKey)PrCrMsgID.WHATIF_RETURNED_ERROR, e.getMessage());
                }
                throw new DatabaseException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
            }
        }
    }

    private ResourceAttribute getACLAttr(String oracleHome, Version version) throws DatabaseException {
        try {
            if (!Cluster.isCluster()) {
                return CRSFactoryImpl.getInstance().createSIHAResourceACL();
            }
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                return this.createACLAttr(oracleHome, version);
            }
            return null;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    private ResourceAttribute createACLAttr(String oracleHome, Version version) throws DatabaseException {
        return this.createACLAttr(oracleHome, version, null);
    }

    private ResourceAttribute createACLAttr(String oracleHome, Version version, String oracleUser) throws DatabaseException {
        try {
            ResourcePermissionsImpl perm = CRSFactoryImpl.getInstance().createPerm(ResourceType.ACL_CREATOR.DB_USER);
            return this.createACLAttr(oracleHome, version, perm, oracleUser);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public ResourceAttribute createACLAttr() throws DatabaseException {
        try {
            return this.createACLAttr(this.getOracleHome(), this.version());
        }
        catch (NoVersionAvailableException e) {
            throw new DatabaseException(e);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException(e);
        }
    }

    private ResourceAttribute createACLAttr(String oracleHome, Version version, ResourcePermissionsImpl perm, String oracleUser) throws DatabaseException {
        ResourceAttribute attr;
        try {
            Util util = new Util();
            OSDBAGRPUtil grpUtil = new OSDBAGRPUtil(oracleHome + File.separator + "bin", version);
            if (oracleUser != null) {
                if (Cluster.isCluster()) {
                    perm.setOwner(oracleUser);
                } else {
                    perm.setPerm(ResourceType.ACL.USER, perm.getUsers().get(0), new ResourceType.ACL_PERM[0]);
                    perm.setPerm(ResourceType.ACL.USER, oracleUser, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
                }
                String pgroup = util.getPrimaryGroup(oracleUser);
                perm.setPerm(ResourceType.ACL.PGROUP, pgroup, ResourceType.ACL_PERM.READ);
            }
            HashMap<String, String> groups = grpUtil.getAdminGroups();
            String dbaGroup = (String)groups.get(OSDBAGroup.SYSDBA.toString());
            String operGroup = (String)groups.get(OSDBAGroup.SYSOPER.toString());
            String racGroup = (String)groups.get(OSDBAGroup.SYSRAC.toString());
            String giUser = util.getCRSUser();
            Trace.out("SYSDBA GROUP: " + dbaGroup);
            Trace.out("SYSOPER GROUP: " + operGroup);
            Trace.out("SYSRAC GROUP: " + racGroup);
            perm.setPerm(ResourceType.ACL.USER, giUser, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
            if (!dbaGroup.trim().isEmpty()) {
                perm.setPerm(ResourceType.ACL.GROUP, dbaGroup, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
            }
            if (operGroup != null && !operGroup.trim().isEmpty() && !dbaGroup.equals(operGroup)) {
                perm.setPerm(ResourceType.ACL.GROUP, operGroup, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
            }
            if (!(racGroup == null || racGroup.isEmpty() || dbaGroup.equals(racGroup) || operGroup.equals(racGroup))) {
                perm.setPerm(ResourceType.ACL.GROUP, racGroup, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
            }
            String aclString = perm.getAclString();
            Trace.out("Generated ACL String: " + aclString);
            attr = CRSFactoryImpl.getInstance().create(ResourceLiterals.ACL_ATTR.toString(), aclString);
        }
        catch (UtilException e) {
            throw new DatabaseException(e);
        }
        catch (CmdToolUtilException e) {
            throw new DatabaseException(e);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
        return attr;
    }

    @Override
    public void checkOracleUser() throws DatabaseException {
        try {
            String oracleHome = this.getOracleHome();
            Trace.out("checking for oracle user");
            new Util().checkOracleUser(oracleHome, new SystemFactory().CreateSystem().isUnixSystem());
        }
        catch (UtilException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Map<String, String> getGroups() throws DatabaseException {
        HashMap<String, String> groupMap = new HashMap<String, String>();
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return groupMap;
        }
        try {
            String oracleBin = this.getOracleHome() + File.separator + "bin";
            Trace.out("Creating OSDBAGRPUtil with path: " + oracleBin);
            OSDBAGRPUtil grpUtil = new OSDBAGRPUtil(oracleBin, this.version());
            HashMap<String, String> groups = grpUtil.getAdminGroups();
            ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
            List<String> acl_groups = perm.getGroups();
            String dba = (String)groups.get(OSDBAGroup.SYSDBA.toString());
            String oper = (String)groups.get(OSDBAGroup.SYSOPER.toString());
            if (!dba.isEmpty() && acl_groups.contains(dba.toLowerCase())) {
                groupMap.put("OSDBA", dba);
            }
            if (!oper.isEmpty() && acl_groups.contains(oper.toLowerCase())) {
                groupMap.put("OSOPER", oper);
            }
            return groupMap;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
        catch (CmdToolUtilException e) {
            throw new DatabaseException(e);
        }
        catch (NoVersionAvailableException e) {
            throw new DatabaseException(e);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean isCardinal() throws DatabaseException {
        boolean isCard = false;
        if (this.isClusterDatabase()) {
            try {
                String version = this.m_crsResource.getAttribute(ResourceType.LocalResource.VERSION.name()).getValue();
                if (!Version.isPre11i(Version.getVersion(version))) {
                    isCard = true;
                }
            }
            catch (ConfigurationException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.IS_CARDINAL_FAILED, (Throwable)e, this.getUserAssignedName());
            }
            catch (CRSException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.IS_CARDINAL_FAILED, (Throwable)e, this.getUserAssignedName());
            }
        }
        return isCard;
    }

    @Override
    public boolean isClusterDatabase() throws DatabaseException {
        try {
            String isClusterDB = this.m_crsResource.getAttribute(ResourceType.Database.CLUSTER_DATABASE.name()).getValue();
            return Boolean.parseBoolean(isClusterDB);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_IS_CLUSTERDB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    boolean isDBCentric() throws DatabaseException {
        return this.isAdminManaged();
    }

    private String getDBUniqueName() throws DatabaseException {
        try {
            String dbUniqueName = this.m_crsResource.getAttribute(ResourceType.Database.DB_UNIQUE_NAME.name()).getValue();
            return dbUniqueName;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_UNIQUE_NAME_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public String getDBName() throws DatabaseException {
        try {
            String dbName = this.m_crsResource.getAttribute(ResourceType.Database.USR_ORA_DB_NAME.name()).getValue();
            return dbName;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DBNAME_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setDBName(String dbName) throws DatabaseException {
        if (dbName == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbName", dbName);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_DB_NAME.name(), dbName));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_DBNAME_FAILED, (Throwable)e, dbName, this.getUserAssignedName());
        }
    }

    @Override
    public String getDomain() throws DatabaseException {
        try {
            String domain = this.m_crsResource.getAttribute(ResourceType.Database.USR_ORA_DOMAIN.name()).getValue();
            return domain;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DBDOMAIN_FAILED, this.getUserAssignedName(), e);
        }
    }

    @Override
    public void setDomain(String domain) throws DatabaseException {
        if (domain == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "domain", domain);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_DOMAIN.name(), domain.trim()));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_DBDOMAIN_FAILED, (Throwable)e, domain, this.getUserAssignedName());
        }
    }

    @Override
    public String getDefaultServiceName() throws DatabaseException {
        String dbUniqueName = this.getUserAssignedName();
        try {
            String dbDomain = this.m_crsResource.getAttribute(ResourceType.Database.USR_ORA_DOMAIN.name()).getValue();
            if (dbDomain == null || dbDomain.trim().length() == 0) {
                return dbUniqueName;
            }
            return dbUniqueName + '.' + dbDomain;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DBDOMAIN_FAILED, dbUniqueName, e);
        }
    }

    @Override
    public DatabaseType databaseType() throws DatabaseException {
        try {
            return this.databaseTypeHelper(this.m_crsResource.getAttribute(ResourceType.Database.DATABASE_TYPE.name()).getValue());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_TYPE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    private DatabaseType databaseTypeHelper(String attrValue) throws DatabaseException {
        if (attrValue == null || attrValue.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_TYPE_FAILED, this.getUserAssignedName());
        }
        try {
            return DatabaseType.getEnumMember(attrValue);
        }
        catch (EnumConstNotFoundException e) {
            Trace.out(e);
            throw new DatabaseException(e);
        }
    }

    @Override
    public String getPWFile() throws NotExistsException, DatabaseException {
        try {
            String pwfile = this.m_crsResource.getAttribute(ResourceType.Database.PWFILE.name()).getValue();
            if (pwfile == null || pwfile.trim().length() == 0) {
                throw new NotExistsException((MessageKey)PrCdMsgID.PWFILE_NOT_EXIST, this.getUserAssignedName());
            }
            return pwfile;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_PWFILE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setPWFile(String pwfile) throws DatabaseException {
        if (pwfile == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "pwfile", pwfile);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.PWFILE.name(), pwfile));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_PWFILE_FAILED, (Throwable)e, pwfile, this.getUserAssignedName());
        }
    }

    @Override
    public String getSPFile() throws NotExistsException, DatabaseException {
        try {
            String spfile = this.m_crsResource.getAttribute(ResourceType.Database.SPFILE.name()).getValue();
            if (spfile == null || spfile.trim().length() == 0) {
                throw new NotExistsException((MessageKey)PrCdMsgID.SPFILE_NOT_EXIST, this.getUserAssignedName());
            }
            return spfile;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_SPFILE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setSPFile(String spfile) throws DatabaseException {
        if (spfile == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "spfile", spfile);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.SPFILE.name(), spfile));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_SPFILE_FAILED, (Throwable)e, spfile, this.getUserAssignedName());
        }
    }

    @Override
    public List<DatabaseInstance> instances() throws DatabaseException {
        return this.getDBInstances(true, true);
    }

    public List<DatabaseInstance> getGeneratedInstances() throws DatabaseException {
        return this.getDBInstances(true, false);
    }

    @Override
    public List<DatabaseInstance> configuredInstances() throws DatabaseException {
        return this.getDBInstances(false, true);
    }

    /*
     * WARNING - void declaration
     */
    private List<DatabaseInstance> getDBInstances(boolean bGenInst, boolean bConfigInst) throws DatabaseException {
        if (!bGenInst && !bConfigInst) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "bGenInst=bConfigInst", false);
        }
        HashMap<String, String> dbInfo = new HashMap<String, String>();
        boolean isPre11202 = Version.isPre11202(this.m_version);
        boolean isPolicyDB = false;
        ArrayList<String> asList = new ArrayList<String>();
        try {
            for (ResourceAttribute ra : this.m_crsResource.getAttributes(new String[0])) {
                Trace.out("name=%s, value=%s", ra.getName(), ra.getValue());
                dbInfo.put(ra.getName(), ra.getValue());
            }
            ServerFactoryImpl serverFactory = ServerFactoryImpl.getInstance();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
            Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.Database.NAME.name(), this.getName());
            Filter finalFilter = crsFactory.getFilter(Filter.Operator.AND, typeFilter, nameFilter);
            boolean bl = isPolicyDB = !this.isAdminManaged();
            if (bGenInst && isPolicyDB) {
                String[] spList;
                Filter poolsFilter = null;
                for (String sp : spList = this.serverPoolsHelper()) {
                    Filter filter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ServerPool.NAME.name(), sp);
                    poolsFilter = poolsFilter == null ? filter : crsFactory.getFilter(Filter.Operator.OR, poolsFilter, filter);
                }
                Map<String, Map<String, String>> resultData = crsFactory.searchEntities((CRSEntity)((Object)this.crsResource()), CRSEntity.Type.ServerPool, false, poolsFilter, ResourceLiterals.ACTIVE_SERVERS.toString());
                for (String string : resultData.keySet()) {
                    String[] activeServers;
                    Map<String, String> result = resultData.get(string);
                    for (String as : activeServers = result.get(ResourceLiterals.ACTIVE_SERVERS.toString()).split(" ")) {
                        asList.add(as);
                    }
                }
                List<Node> runNodes = this.m_crsResource.fetchRunningNodes();
                for (Node rnode : runNodes) {
                    String rnodename = rnode.getName();
                    if (asList.contains(rnodename)) continue;
                    Trace.out("Adding running node " + rnodename);
                    asList.add(rnodename);
                }
                Trace.out("asList=" + asList);
            }
            Map<String, Map<String, String>> resultData = crsFactory.searchEntities((CRSEntity)((Object)this.crsResource()), CRSEntity.Type.ResourceInstance, false, finalFilter, ResourceLiterals.CRS_LAST_SERVER.toString(), ResourceLiterals.STATE_ATTR_NAME.toString());
            Trace.out("size of resultData = " + resultData.size());
            String instanceName = null;
            String serverName = null;
            String configInstPattern = ResourceType.Database.USR_ORA_INST_NAME.name() + ResourceLiterals.AT.toString() + ResourceLiterals.SERVERNAME.toString() + '(';
            int lenConfigInstPattern = configInstPattern.length() - 1;
            String genInstPattern = ResourceType.Database.GEN_USR_ORA_INST_NAME.name() + ResourceLiterals.AT.toString() + ResourceLiterals.SERVERNAME.toString() + '(';
            int lenGenInstPattern = genInstPattern.length() - 1;
            LinkedHashMap<String, void> usrInst2Server = new LinkedHashMap<String, void>();
            LinkedHashMap genInst2Server = new LinkedHashMap();
            ArrayList<String> dupInstList = new ArrayList<String>();
            ArrayList<String> runningNodesList = new ArrayList<String>();
            ArrayList<DatabaseInstance> dbInstList = new ArrayList<DatabaseInstance>();
            StringBuilder sb = new StringBuilder("Got instances: ");
            if (resultData.keySet().size() > 0) {
                Object dbInst;
                String riID = resultData.keySet().iterator().next();
                String state = null;
                Map<String, String> result = resultData.get(riID);
                Trace.out("riID=" + riID + " result=" + result);
                serverName = result.get(ResourceLiterals.CRS_LAST_SERVER.toString());
                state = resultData.get(riID).get(ResourceLiterals.STATE_ATTR_NAME.toString());
                Trace.out("Got database instance state " + state);
                DatabaseType dbType = null;
                if (!isPre11202) {
                    dbType = this.databaseTypeHelper((String)dbInfo.get(ResourceType.Database.DATABASE_TYPE.name()));
                } else {
                    DatabaseType databaseType = dbType = Boolean.valueOf((String)dbInfo.get(ResourceType.Database.CLUSTER_DATABASE.name())) != false ? DatabaseType.RAC : DatabaseType.SIDB;
                }
                if (dbType == DatabaseType.SIDB || dbType == DatabaseType.RACOneNode && bConfigInst) {
                    Node node;
                    String genInstAttrName = genInstPattern + serverName.trim() + ')';
                    if (bGenInst && bConfigInst) {
                        instanceName = (String)dbInfo.get(genInstAttrName);
                        if (instanceName == null || instanceName.length() == 0) {
                            Trace.out("not getting any value from GEN");
                            instanceName = (String)dbInfo.get(ResourceType.Database.USR_ORA_INST_NAME.name());
                        }
                        Trace.out("both gen and config, instance name = " + instanceName);
                    } else if (bConfigInst) {
                        instanceName = (String)dbInfo.get(ResourceType.Database.USR_ORA_INST_NAME.name());
                    } else if (bGenInst) {
                        instanceName = (String)dbInfo.get(genInstAttrName);
                    }
                    if (instanceName == null || instanceName.length() == 0) {
                        Trace.out("No instance has been added yet");
                        return new ArrayList<DatabaseInstance>(0);
                    }
                    if (dbType != DatabaseType.SIDB && serverName.length() > 0) {
                        node = serverFactory.getNode(serverName, false);
                    } else if (this.getSIDBType() == SIDBType.FIXED) {
                        ResourceAttribute resourceAttribute = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.HOSTING_MEMBERS.name());
                        node = serverFactory.getNode(resourceAttribute.getValue().trim());
                    } else if (Cluster.isCluster() && (dbType == DatabaseType.SIDB || dbType == DatabaseType.RACOneNode)) {
                        List<Server> servers;
                        ServerGroup serverGroup = this.serverGroup();
                        List<Server> list = servers = dbType == DatabaseType.RACOneNode && isPolicyDB ? serverGroup.servers() : serverGroup.configuredServers();
                        if (servers.size() > 0) {
                            node = servers.get(0).node();
                        } else {
                            Trace.out("server size is zero, should not happen");
                            node = serverFactory.getNode(Cluster.getHostName(), false);
                        }
                    } else {
                        node = serverFactory.getNode(Cluster.getHostName(), false);
                    }
                    Trace.out("instName=" + instanceName + " nodeName=" + node.getName());
                    dbInstList.add(new DatabaseInstanceImpl(this, instanceName, node));
                    if (dbType == DatabaseType.SIDB) {
                        return dbInstList;
                    }
                }
                Trace.out("looking for per-X attributes like %s and %s", genInstPattern, configInstPattern);
                for (Object attrName : dbInfo.keySet()) {
                    void var34_63;
                    boolean bl2;
                    int index1 = -1;
                    serverName = null;
                    instanceName = null;
                    boolean bl3 = false;
                    if (((String)attrName).startsWith(genInstPattern)) {
                        bl2 = true;
                        index1 = lenGenInstPattern;
                    }
                    if (index1 < 0 && ((String)attrName).startsWith(configInstPattern)) {
                        index1 = lenConfigInstPattern;
                    }
                    if (index1 < 0) continue;
                    Trace.out((Object)"found per-X attribute : %s", (String)attrName);
                    int index2 = ((String)attrName).indexOf(41, index1);
                    if (index2 < 0) {
                        Trace.out("Wrong attr name: " + (String)attrName);
                        continue;
                    }
                    serverName = ((String)attrName).substring(index1 + 1, index2);
                    Trace.out((Object)"per-X server name : %s", serverName);
                    instanceName = (String)dbInfo.get(attrName);
                    Trace.out((Object)"per-X instance name : %s", instanceName);
                    if (bGenInst && isPolicyDB && !asList.contains(serverName)) {
                        Trace.out("Ignoring generated instanceName %s on not active node %s", instanceName, serverName);
                        continue;
                    }
                    if (bl2) {
                        Trace.out("is a generated instance");
                        if (!bGenInst) {
                            Trace.out("ignoring generated instance ...");
                            continue;
                        }
                        List list = (List)genInst2Server.get(instanceName);
                        if (list == null) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            arrayList.add(serverName);
                            Trace.out("putting %s and %s into genInst2Server Map", instanceName, ((Object)arrayList).toString());
                            genInst2Server.put(instanceName, arrayList);
                            continue;
                        }
                        Trace.out((Object)"instance %s has duplicate GEN per-X mapping", instanceName);
                        dupInstList.add(instanceName);
                        ((List)genInst2Server.get(instanceName)).add(serverName);
                        continue;
                    }
                    Trace.out("configured instance");
                    List list = (List)usrInst2Server.get(instanceName);
                    if (list == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var34_63.add(serverName);
                    Trace.out("putting %s and %s into usrInst2Server Map", instanceName, var34_63.toString());
                    usrInst2Server.put(instanceName, var34_63);
                }
                if (bGenInst && dupInstList.size() > 0) {
                    Trace.out((Object)"instances %s have duplicate GEN per-X mapping ... getting running nodes ...", dupInstList.toString());
                    String server = null;
                    for (String string : resultData.keySet()) {
                        server = resultData.get(string).get(ResourceLiterals.CRS_LAST_SERVER.toString());
                        state = resultData.get(string).get(ResourceLiterals.STATE_ATTR_NAME.toString());
                        Trace.out((Object)"checking if database is running on %s ...", server);
                        if (server == null || server.length() <= 0 || !CRSFactoryImpl.isRunningState(state)) continue;
                        Trace.out((Object)"database is running on %s", server);
                        runningNodesList.add(server);
                    }
                    Trace.out((Object)"running nodes : %s", ((Object)runningNodesList).toString());
                    ArrayList<String> serversToRemove = null;
                    for (String curInstance : dupInstList) {
                        List serverList2 = (List)genInst2Server.get(curInstance);
                        Trace.out("instance %s has duplicate per-X mapping on nodes %s ...", curInstance, serverList2.toString());
                        serversToRemove = new ArrayList<String>();
                        for (String curServer : serverList2) {
                            if (runningNodesList.contains(curServer)) continue;
                            serversToRemove.add(curServer);
                        }
                        Trace.out("removing nodes %s on which instance %s is not running ...", ((Object)serversToRemove).toString(), curInstance);
                        if (serversToRemove.size() <= 0) continue;
                        serverList2.removeAll(serversToRemove);
                    }
                }
                if (bConfigInst) {
                    Trace.out("creating DatabaseInstance objects for configured instances ...");
                    for (String curInstName : usrInst2Server.keySet()) {
                        Trace.out((Object)"creating DatabaseInstance object for instance %s ...", curInstName);
                        List list = (List)usrInst2Server.get(curInstName);
                        if (list == null) continue;
                        for (String curServer : list) {
                            Trace.out("instance %s is mapped to node %s", curInstName, curServer);
                            for (String id : resultData.keySet()) {
                                if (!curServer.equals(resultData.get(id).get(ResourceLiterals.CRS_LAST_SERVER.toString()))) continue;
                                state = resultData.get(id).get(ResourceLiterals.STATE_ATTR_NAME.toString());
                            }
                            dbInst = new DatabaseInstanceImpl(this, curInstName, serverFactory.getNode(curServer, false), state);
                            if (dbInstList.contains(dbInst)) {
                                Trace.out("Already accounted for config instance " + curInstName + " on server " + curServer);
                                continue;
                            }
                            dbInstList.add((DatabaseInstance)dbInst);
                            sb.append(String.format("<%s,%s, %s>", curInstName, curServer, state));
                        }
                    }
                }
                if (bGenInst) {
                    Trace.out("creating DatabaseInstance objects for generated instances ...");
                    sb.append("; GEN: ");
                    for (String curInstName : genInst2Server.keySet()) {
                        Trace.out((Object)"creating DatabaseInstance object for instance %s ...", curInstName);
                        if (usrInst2Server.get(curInstName) != null) {
                            Trace.out("ignoring gen instance " + curInstName);
                            continue;
                        }
                        List list = (List)genInst2Server.get(curInstName);
                        if (list == null) continue;
                        for (String curServer : list) {
                            Trace.out("instance %s is mapped to node %s", curInstName, curServer);
                            for (String id : resultData.keySet()) {
                                if (!curServer.equals(resultData.get(id).get(ResourceLiterals.CRS_LAST_SERVER.toString()))) continue;
                                state = resultData.get(id).get(ResourceLiterals.STATE_ATTR_NAME.toString());
                            }
                            dbInst = new DatabaseInstanceImpl(this, curInstName, serverFactory.getNode(curServer, false), state);
                            if (dbInstList.contains(dbInst)) {
                                Trace.out("Ignoring gen instance " + curInstName + " on server " + curServer);
                                continue;
                            }
                            dbInstList.add((DatabaseInstance)dbInst);
                            sb.append(String.format("<%s,%s,%s>", curInstName, curServer, state));
                        }
                    }
                }
            }
            Trace.out(sb.toString());
            Collections.sort(dbInstList, new DBIComparator());
            return dbInstList;
        }
        catch (ClusterException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public List<Node> nodes() throws DatabaseException {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        try {
            if (!Cluster.isCluster()) {
                nodeList.add(ServerFactoryImpl.getInstance().getNode(Cluster.getHostName(), false));
            } else if (!this.isClusterDatabase()) {
                Trace.out("Getting node for single instance db in cluster mode");
                nodeList.add(this.configuredInstances().get(0).node());
            } else {
                Trace.out("Getting nodes on which this database has instances configured");
                for (DatabaseInstance inst : this.configuredInstances()) {
                    nodeList.add(inst.node());
                }
                List<ServerGroup> sgList = this.serverGroups();
                if (sgList.size() != 1 || sgList.get(0).isServerPool()) {
                    for (ServerGroup sg : sgList) {
                        for (Server s : sg.servers()) {
                            if (nodeList.contains(s.node())) continue;
                            nodeList.add(s.node());
                        }
                    }
                }
            }
            return nodeList;
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_NODELIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_NODELIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_NODELIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ClusterException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_NODELIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void addInstance(DatabaseInstance instance) throws AlreadyExistsException, InstanceException {
        try {
            this.addInstance(instance, false);
        }
        catch (CRSNeedForceException e) {
            throw new InstanceException(e);
        }
    }

    @Override
    public void addInstance(DatabaseInstance instance, boolean force) throws AlreadyExistsException, CRSNeedForceException, InstanceException {
        try {
            int cardinality;
            if (!this.isClusterDatabase()) {
                throw new AlreadyExistsException((MessageKey)PrCdMsgID.SINGLE_INST_ALREADY_EXISTS, new Object[0]);
            }
            if (instance == null) {
                throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "instance", instance);
            }
            Node node = instance.node();
            String nodename = node.getName();
            String instanceName = instance.getUserAssignedName();
            List<DatabaseInstance> cfgInstList = this.configuredInstances();
            for (DatabaseInstance cinst : cfgInstList) {
                if (cinst.getUserAssignedName().equals(instanceName)) {
                    throw new InstanceException((MessageKey)PrCdMsgID.INSTANCE_WITH_SAME_NAME_ALREADY_EXISTS, instanceName, cinst.node().getName());
                }
                if (!node.equals(cinst.node())) continue;
                throw new InstanceException((MessageKey)PrCdMsgID.INST_ALREADY_EXISTS, nodename, this.getUserAssignedName());
            }
            List<ServerGroup> sgList = this.serverGroups();
            ServerGroup sg = sgList.get(0);
            if (sgList.size() == 1 && !sg.isServerPool()) {
                Trace.out("db centric configuration for server group, " + sg.getUserAssignedName());
                Trace.out("node name = " + nodename);
                String card = this.m_crsResource.getAttribute(ResourceType.ClusterResource.CARDINALITY.name()).getValue();
                Trace.out("cardinality=" + card);
                if (card.equals(ResourceLiterals.CRS_SERVER_POOL_SIZE_CARDINALITY.toString())) {
                    Server[] serverArr = new Server[]{ServerFactoryImpl.getInstance().createServer(node)};
                    sg.setServers(force, serverArr);
                } else {
                    ArrayList<Server> serverList = new ArrayList<Server>(1);
                    serverList.add(ServerFactoryImpl.getInstance().createServer(node));
                    sg.addServers(force, serverList);
                }
                cardinality = 1;
                if (!card.equals(ResourceLiterals.CRS_SERVER_POOL_SIZE_CARDINALITY.toString())) {
                    cardinality = Integer.parseInt(card) + 1;
                }
            } else {
                throw new InstanceException((MessageKey)PrCdMsgID.ADD_INST_NOT_SUPPORTED_DB_OPT, this.getUserAssignedName());
            }
            Trace.out("creating per-x USR_ORA_INST_NAME for %s on %s and update cardinality=%s", instance.getUserAssignedName(), nodename, cardinality);
            ResourceAttribute[] resAttrs = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.getPerXName(ResourceType.Database.USR_ORA_INST_NAME.name(), nodename), instance.getUserAssignedName()), CRSFactoryImpl.getInstance().create(ResourceType.ClusterResource.CARDINALITY.name(), String.valueOf(cardinality))};
            this.m_crsResource.update(resAttrs);
        }
        catch (CRSException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.ADD_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CompositeOperationException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.ADD_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.ADD_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.ADD_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            if (e.getCause() instanceof CRSNeedForceException) {
                throw new CRSNeedForceException((MessageKey)PrCdMsgID.ADD_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
            }
            throw new InstanceException((MessageKey)PrCdMsgID.ADD_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.ADD_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void removeInstance(DatabaseInstance instance) throws InstanceException {
        try {
            if (!this.isClusterDatabase()) {
                throw new InstanceException((MessageKey)PrCdMsgID.SINGLE_INST_NOT_REMOVED, this.getUserAssignedName());
            }
            if (instance == null) {
                throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "instance", instance);
            }
            if (instance.isRunning()) {
                throw new InstanceException((MessageKey)PrCdMsgID.REMOVE_RUNNING_INST_FAILED, instance.getUserAssignedName(), this.getUserAssignedName());
            }
            if (this.databaseType() == DatabaseType.RACOneNode || !this.isAdminManaged()) {
                this.m_crsResource.purgePerXbyValue(instance.getUserAssignedName(), ResourceType.Database.USR_ORA_INST_NAME.name(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
                return;
            }
            Node node = instance.node();
            Trace.out("node name = " + node.getName());
            boolean isDBCentric = this.isAdminManaged();
            List<ServerGroup> sgList = this.serverGroups();
            ServerGroup sg = sgList.get(0);
            if (isDBCentric) {
                try {
                    HAServiceImpl.canRemoveInstance(this, instance, DBFilterFactory.getServices4DB(this.getName()));
                }
                catch (ServiceException e) {
                    throw new InstanceException((MessageKey)PrCdMsgID.REMOVE_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
                }
            }
            try {
                this.m_crsResource.purgePerX(node.getName(), ResourceType.Database.USR_ORA_INST_NAME.name());
            }
            catch (NotExistsException e) {
                Trace.out(e.getMessage());
            }
            if (isDBCentric) {
                String card = this.m_crsResource.getAttribute(ResourceType.ClusterResource.CARDINALITY.name()).getValue();
                Trace.out("cardinality=" + card);
                int cardinality = Integer.parseInt(card) - 1;
                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.ClusterResource.CARDINALITY.name(), cardinality == 0 ? ResourceLiterals.CRS_SERVER_POOL_SIZE_CARDINALITY.toString() : String.valueOf(cardinality)));
            }
            try {
                this.m_crsResource.purgePerX(node.getName(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
            }
            catch (NotExistsException e) {
                Trace.out("NotExistsException encountered when purging per-X gen: " + e.getMessage());
            }
            if (isDBCentric) {
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                HAServiceImpl haServ = null;
                for (Service s : this.services()) {
                    haServ = new HAServiceImpl(crsFactory.create(ResourceType.Service.NAME.name(), s.getName()));
                    haServ.handleDBInstRemoved(this, instance);
                }
                ArrayList<Server> serverList = new ArrayList<Server>(1);
                serverList.add(ServerFactoryImpl.getInstance().createServer(node));
                sg.removeServers(serverList);
            }
        }
        catch (CompositeOperationException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.REMOVE_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.REMOVE_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.REMOVE_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.REMOVE_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.REMOVE_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.REMOVE_INSTANCE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void modifyInstance(DatabaseInstance instance) throws InstanceException {
        block22: {
            if (instance == null) {
                throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "instance", instance);
            }
            String nodename = "";
            try {
                nodename = instance.node().getName();
                DatabaseType dbType = this.databaseType();
                if (dbType == DatabaseType.RACOneNode) {
                    Trace.out("checking if an instance-node association already exists ...");
                    for (DatabaseInstance databaseInstance : this.instances()) {
                        if (!databaseInstance.getUserAssignedName().equalsIgnoreCase(instance.getUserAssignedName())) continue;
                        Trace.out("instance name %s is already associated with node %s", databaseInstance.getUserAssignedName(), databaseInstance.node().getName());
                        throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_RACONE_FAILED, instance.getUserAssignedName(), databaseInstance.node().getName(), this.getUserAssignedName());
                    }
                }
                if (dbType == DatabaseType.RACOneNode || !this.isAdminManaged()) {
                    try {
                        this.m_crsResource.purgePerXbyValue(instance.getUserAssignedName(), ResourceType.Database.USR_ORA_INST_NAME.name(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
                        String perXName = ResourceType.getPerXName(ResourceType.Database.USR_ORA_INST_NAME.name(), nodename);
                        this.m_crsResource.update(CRSFactoryImpl.getInstance().create(perXName, instance.getUserAssignedName()));
                        break block22;
                    }
                    catch (CRSException ce) {
                        throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_FAILED, (Throwable)ce, instance.getUserAssignedName(), nodename, this.getUserAssignedName());
                    }
                }
                DatabaseInstance oldDBInst = null;
                for (DatabaseInstance inst : this.configuredInstances()) {
                    if (!inst.getUserAssignedName().equalsIgnoreCase(instance.getUserAssignedName())) continue;
                    oldDBInst = inst;
                    break;
                }
                if (oldDBInst == null) {
                    Trace.out("no instance has been configured for this admin managed database");
                    throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_DB_CENTRIC_FAILED, instance.getUserAssignedName(), nodename, this.getUserAssignedName());
                }
                try {
                    Trace.out("modifying instance information for this admin managed database");
                    this.removeInstance(oldDBInst);
                    this.addInstance(instance);
                    List<Node> list = this.m_crsResource.fetchEnabledNodes();
                    List<Node> disabledNodes = this.m_crsResource.fetchDisabledNodes();
                    Trace.out("check if instance has been enabled/disabled on old node");
                    if (list.contains(oldDBInst.node())) {
                        Trace.out("instance has been enabled on the old node");
                        this.m_crsResource.purgePerX(oldDBInst.node().getName(), ResourceType.LocalResource.ENABLED.name());
                        this.m_crsResource.enable(instance.node());
                    } else if (disabledNodes.contains(oldDBInst.node())) {
                        Trace.out("instance has been disabled on the old node");
                        this.m_crsResource.purgePerX(oldDBInst.node().getName(), ResourceType.LocalResource.ENABLED.name());
                        this.m_crsResource.disable(instance.node());
                    } else {
                        Trace.out("instance has not been enabled/disabled on the old node");
                    }
                }
                catch (AlreadyDisabledException alreadyDisabledException) {
                    throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_FAILED, (Throwable)alreadyDisabledException, instance.getUserAssignedName(), nodename, this.getUserAssignedName());
                }
                catch (AlreadyEnabledException alreadyEnabledException) {
                    throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_FAILED, (Throwable)alreadyEnabledException, instance.getUserAssignedName(), nodename, this.getUserAssignedName());
                }
                catch (NotExistsException notExistsException) {
                    throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_FAILED, (Throwable)notExistsException, instance.getUserAssignedName(), nodename, this.getUserAssignedName());
                }
                catch (AlreadyExistsException alreadyExistsException) {
                    throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_FAILED, (Throwable)alreadyExistsException, instance.getUserAssignedName(), nodename, this.getUserAssignedName());
                }
                catch (SoftwareModuleException softwareModuleException) {
                    throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_FAILED, (Throwable)softwareModuleException, instance.getUserAssignedName(), nodename, this.getUserAssignedName());
                }
            }
            catch (CRSException e) {
                throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_FAILED, (Throwable)e, instance.getUserAssignedName(), nodename, this.getUserAssignedName());
            }
            catch (DatabaseException e) {
                throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_FAILED, (Throwable)e, instance.getUserAssignedName(), nodename, this.getUserAssignedName());
            }
            catch (NodeException e) {
                throw new InstanceException((MessageKey)PrCdMsgID.MODIFY_INST_FAILED, (Throwable)e, instance.getUserAssignedName(), nodename, this.getUserAssignedName());
            }
        }
    }

    @Override
    public List<Service> services() throws DatabaseException {
        return this.services(true, false, true, null);
    }

    @Override
    public List<Service> services(boolean includePQ) throws DatabaseException {
        return this.services(true, false, includePQ, null);
    }

    List<Service> services(boolean userOnly, boolean downgradeCtx) throws DatabaseException {
        return this.services(userOnly, downgradeCtx, false, null);
    }

    List<Service> services(boolean userOnly, boolean downgradeCtx, boolean includePQ, String pdb) throws DatabaseException {
        try {
            List<ResourceAttribute> resList = this.getServiceNameAttrList(userOnly, pdb);
            if (resList.size() == 0) {
                return new ArrayList<Service>(0);
            }
            DatabaseType dbType = !downgradeCtx && !Version.isPre11202(this.m_version) ? this.databaseType() : (this.isClusterDatabase() ? DatabaseType.RAC : DatabaseType.SIDB);
            ArrayList<Service> serviceList = new ArrayList<Service>(resList.size());
            for (ResourceAttribute attr : resList) {
                if (dbType == DatabaseType.RAC) {
                    CardinalServiceImpl svc = new CardinalServiceImpl(this.m_crsResource, attr);
                    if (svc.getServiceType() != ServiceType.PQ) {
                        serviceList.add(svc);
                        continue;
                    }
                    if (!includePQ) continue;
                    serviceList.add(svc);
                    continue;
                }
                if (dbType == DatabaseType.RACOneNode) {
                    serviceList.add(new RACOneNodeServiceImpl(attr));
                    continue;
                }
                serviceList.add(new SingleInstanceServiceImpl(attr));
            }
            return serviceList;
        }
        catch (ServiceException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_SERVICES_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    List<ResourceAttribute> getServiceNameAttrList(boolean userOnly, String pdb) throws DatabaseException {
        try {
            Filter filter = DBFilterFactory.getServices4DB(this.getName());
            if (pdb != null) {
                Filter pdbFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQI, ResourceType.Service.PLUGGABLE_DATABASE.name(), pdb);
                filter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, pdbFilter, filter);
            }
            List<ResourceAttribute> resList = CRSFactoryImpl.getInstance().searchResources((CRSResourceImpl)this.crsResource(), CRSEntity.Type.Resource, filter);
            if (userOnly) {
                return ServiceImpl.filterOutInternalServiceNames(resList);
            }
            return resList;
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_SERVICES_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_SERVICES_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void removeServices(boolean force) throws DatabaseException {
        try {
            Exception firstException = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            boolean removeSG = this.isAdminManaged();
            List<ResourceAttribute> allServices = crsFactory.searchResources((CRSResourceImpl)this.crsResource(), CRSEntity.Type.Resource, DBFilterFactory.getServices4DB(this.getName()));
            ArrayList<ResourceAttribute> sg2remove = new ArrayList<ResourceAttribute>();
            SWHelper swh = null;
            for (ResourceAttribute ra : allServices) {
                swh = new SWHelper(ra);
                if (removeSG) {
                    sg2remove.add(swh.serverGroup());
                }
                try {
                    Trace.out("remove service: " + swh.getName());
                    swh.remove(force);
                }
                catch (Exception e) {
                    firstException = e;
                    break;
                }
            }
            for (ResourceAttribute sgAttr : sg2remove) {
                CRSServerGroupEntity sg = crsFactory.getServerGroup(sgAttr.getValue());
                try {
                    Trace.out("remove sg: " + sgAttr.getValue());
                    sg.unregister(true);
                }
                catch (Exception exception) {}
            }
            if (firstException != null) {
                throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_SERVICES_FAILED, (Throwable)firstException, this.getUserAssignedName());
            }
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_SERVICES_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
    }

    public void modifyDatabase(ServerPool serverPool) throws DatabaseException {
        this.modifyDatabase(serverPool, false);
    }

    public void modifyDatabase(ServerPool serverPool, boolean force) throws DatabaseException {
        if (serverPool == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverPool");
        }
        boolean isAdminMgd = false;
        PrCdMsgID msgID = PrCdMsgID.UPDATE_DBSP_FAILED;
        try {
            isAdminMgd = this.isAdminManaged();
            if (isAdminMgd) {
                msgID = PrCdMsgID.CONVERT_DB_FAILED;
            }
            DatabaseType dbType = this.databaseType();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            DatabaseFactoryImpl dbFactory = DatabaseFactoryImpl.getInstance();
            List<Service> allServices = this.services();
            CRSServerGroupEntity sgEntity = null;
            ServiceArgs args = null;
            String newCardinality = null;
            for (Service service : allServices) {
                if (isAdminMgd && dbType == DatabaseType.RAC && service.getTAF() == ServiceTAF.PRECONNECT) {
                    String preconName = ServiceImpl.getPreconnectServiceName(service.getUserAssignedName());
                    Service preconService = dbFactory.getService(this.getDBUniqueName(), preconName);
                    try {
                        SWHelper swh = new SWHelper(crsFactory.create(ResourceType.LocalResource.NAME.name(), preconService.getName()));
                        swh.remove(true);
                    }
                    catch (CRSException e) {
                        Trace.out("Failed to remove precon service " + preconName + e.getMessage());
                    }
                    service.setTAF(ServiceTAF.BASIC);
                }
                args = ((ServiceImpl)service).getArgs();
                sgEntity = crsFactory.getServerGroup(args.getServerGroup().getName());
                ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
                attrList.add(crsFactory.create(ResourceType.Service.SERVER_POOLS.name(), serverPool.getName()));
                if (isAdminMgd && dbType == DatabaseType.RAC) {
                    newCardinality = args.getServiceCardinality().getCount() == 1 ? ServiceCardinality.SINGLETON.toString() : ServiceCardinality.UNIFORM.toString();
                    attrList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), newCardinality));
                }
                ResourceAttribute[] resAttrs = attrList.toArray(new ResourceAttribute[attrList.size()]);
                CRSResourceImpl serviceRes = (CRSResourceImpl)service.crsResource();
                serviceRes.update(force, resAttrs);
                if (!isAdminMgd || dbType != DatabaseType.RAC) continue;
                Trace.out("remove service sgEntity: " + args.getServerGroup().getName());
                sgEntity.unregister(true);
            }
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            if (!isAdminMgd && dbType == DatabaseType.RACOneNode) {
                Trace.out("Update the start dependency");
                List<DiskGroup> dglist = this.diskGroups();
                List<ResourceAttribute> dgAttrList = this.getDiskGroupAttrList(dglist);
                attrList.addAll(Arrays.asList(this.createStartDepRTE(dgAttrList, this.asmClusterFileSystems(), this.getMgmtPolicy(), dbType, this.isAdminManaged())));
            }
            attrList.add(crsFactory.create(ResourceType.Database.SERVER_POOLS.name(), serverPool.getName()));
            if (isAdminMgd) {
                sgEntity = crsFactory.getServerGroup(this.serverGroup().getName());
                if (dbType == DatabaseType.RAC) {
                    attrList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), ResourceLiterals.CRS_SERVER_POOL_SIZE_CARDINALITY.toString()));
                    attrList.add(crsFactory.create(ResourceType.Database.INSTANCE_FAILOVER.name(), ResourceLiterals.ENABLED_VALUE.toString()));
                }
            }
            this.m_crsResource.update(force, attrList.toArray(new ResourceAttribute[attrList.size()]));
            try {
                if (!this.isRunning()) {
                    this.m_crsResource.purgePerX(new String[]{ResourceType.Database.USR_ORA_INST_NAME.name(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name()});
                } else {
                    this.m_crsResource.purgePerX(new String[]{ResourceType.Database.USR_ORA_INST_NAME.name()});
                }
            }
            catch (NotExistsException e) {
                Trace.out("IGNORED: " + e.getMessage());
            }
            if (isAdminMgd) {
                Trace.out("remove db sgEntity: " + sgEntity.entityName());
                sgEntity.unregister(true);
            }
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)msgID, (Throwable)e, this.getUserAssignedName(), serverPool.getUserAssignedName());
        }
        catch (InstanceException e) {
            throw new DatabaseException((MessageKey)msgID, (Throwable)e, this.getUserAssignedName(), serverPool.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)msgID, (Throwable)e, this.getUserAssignedName(), serverPool.getUserAssignedName());
        }
        catch (ServerGroupException e) {
            throw new DatabaseException((MessageKey)msgID, (Throwable)e, this.getUserAssignedName(), serverPool.getUserAssignedName());
        }
        catch (ServiceException e) {
            throw new DatabaseException((MessageKey)msgID, (Throwable)e, this.getUserAssignedName(), serverPool.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)msgID, (Throwable)e, this.getUserAssignedName(), serverPool.getUserAssignedName());
        }
    }

    void modifyDatabase(DatabaseOptionalArgs args) throws DatabaseException {
        if (args == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args", args);
        }
        this.internalModifyDatabase(args, null, false, false, true);
    }

    void modifyDatabase(DatabaseOptionalArgs args, boolean force) throws DatabaseException {
        if (args == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args", args);
        }
        this.internalModifyDatabase(args, null, force, false, true);
    }

    void modifyDatabase(DatabaseOptionalArgs args, boolean force, boolean internal) throws DatabaseException {
        if (args == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args", args);
        }
        this.internalModifyDatabase(args, null, force, internal, true);
    }

    void modifyDatabase(DatabaseOptionalArgs args, String oracleHome) throws DatabaseException {
        if (args == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args", args);
        }
        DatabaseImpl.assertOracleHome(oracleHome);
        this.internalModifyDatabase(args, oracleHome, false, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private void internalModifyDatabase(DatabaseOptionalArgs args, String oracleHome, boolean force, boolean internal, boolean doVersionCheck) throws DatabaseException {
        try {
            Network defaultNetwork;
            Integer maxMemory;
            Integer memTarget;
            Integer cpuCount;
            CRSResource.CSSCritical cssCritical;
            int timeout;
            String instName;
            int stopConcurrency;
            int startConcurrency;
            Enum[] stopOpts;
            Enum[] startOpts;
            DBRole dbRole;
            String pwfile;
            String spfile;
            String domain;
            String dbName;
            if (doVersionCheck) {
                Common.versionCheck(this.version(), new Version());
            }
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ArrayList<ResourceAttribute> ral = new ArrayList<ResourceAttribute>();
            List<Service> myServices = null;
            boolean pqModified = false;
            boolean rfModified = false;
            ResourceAttribute acl = null;
            DBRole databaseRole = this.getDBRole();
            List<ServerGroup> sgpools = args.getServerGroupList();
            List<ServerGroup> pqpools = args.getPQPools();
            List<ServerGroup> rfPools = args.getRFPools();
            List<ServerGroup> oldPqpools = this.getPQPools();
            List<ServerGroup> oldRFpools = this.getRFPools();
            ArrayList<ServerGroup> sgList = new ArrayList<ServerGroup>();
            if (pqpools != null) {
                if (databaseRole == DBRole.FAR_SYNC) {
                    Trace.out("Far sync database " + this.getUserAssignedName() + "cannot be modified to have PQ pools");
                    throw new DatabaseException((MessageKey)PrCdMsgID.FARSYNC_NO_PQPOOLS, this.getUserAssignedName(), DatabaseImpl.getServerGroupString(pqpools, String.valueOf(","), true));
                }
                if (pqpools.size() > 0) {
                    for (ServerGroup serverGroup : pqpools) {
                        Common.checkPQServerCategory(serverGroup);
                    }
                }
                String pqpoolStr = DatabaseImpl.getServerGroupString(pqpools, String.valueOf(" "), false);
                Trace.out("Modify pqpools with new value: " + (String)pqpoolStr);
                ral.add(cf.create(ResourceType.Database.SERVER_POOLS_PQ.name(), pqpoolStr));
                pqModified = true;
            }
            if (rfPools != null) {
                if (rfPools.size() > 0) {
                    for (ServerGroup serverGroup : rfPools) {
                        Common.checkRFServerCategory(serverGroup);
                    }
                }
                String rfPoolStr = DatabaseImpl.getServerGroupString(rfPools, String.valueOf(" "), false);
                Trace.out("Modifying rf pools with new value, " + (String)rfPoolStr);
                ral.add(cf.create(ResourceType.Database.SERVER_POOLS_RF.name(), rfPoolStr));
                rfModified = true;
            }
            if (sgpools != null && sgpools.size() > 0 || pqModified || rfModified) {
                void var20_39;
                if (sgpools == null) {
                    sgpools = this.serverGroups();
                    internal = true;
                }
                if (sgpools != null) {
                    for (ServerGroup serverGroup : sgpools) {
                        if (!internal) {
                            Common.checkPrimaryServerCategory(serverGroup);
                        }
                        if (!(oldPqpools != null && oldPqpools.contains(serverGroup) || pqpools != null && pqpools.contains(serverGroup))) {
                            sgList.add(serverGroup);
                            continue;
                        }
                        if (pqModified) {
                            if (pqpools == null || !pqpools.contains(serverGroup)) continue;
                            sgList.add(serverGroup);
                            continue;
                        }
                        sgList.add(serverGroup);
                    }
                }
                ArrayList<ServerGroup> addPQpools = null;
                addPQpools = pqModified ? new ArrayList<ServerGroup>(pqpools) : new ArrayList<ServerGroup>(oldPqpools);
                if (addPQpools != null) {
                    for (ServerGroup pq : addPQpools) {
                        if (sgList.contains(pq)) continue;
                        sgList.add(pq);
                    }
                }
                Object var20_36 = null;
                ArrayList<ServerGroup> removeRFpools = null;
                Trace.out("RF modified: " + rfModified);
                if (rfModified) {
                    Trace.out("RF pools list was modified");
                    ArrayList<ServerGroup> arrayList = new ArrayList<ServerGroup>(rfPools);
                    removeRFpools = new ArrayList<ServerGroup>();
                    for (ServerGroup sv : oldRFpools) {
                        Trace.out("Old pool " + sv.getUserAssignedName() + "...");
                        if (arrayList.contains(sv)) continue;
                        removeRFpools.add(sv);
                        Trace.out("is not in the old list, add to removeRFPools");
                    }
                } else {
                    ArrayList<ServerGroup> arrayList = new ArrayList<ServerGroup>(oldRFpools);
                }
                if (var20_39 != null) {
                    for (ServerGroup rf : var20_39) {
                        if (sgList.contains(rf)) continue;
                        Trace.out("SG list does not contain " + rf.getUserAssignedName());
                        sgList.add(rf);
                    }
                }
                if (removeRFpools != null && !removeRFpools.isEmpty()) {
                    for (ServerGroup rf : removeRFpools) {
                        if (!sgList.contains(rf)) continue;
                        sgList.remove(rf);
                    }
                }
                String sgStr = DatabaseImpl.getServerGroupString(sgList, String.valueOf(","), true);
                Trace.out("server pool list = " + sgStr);
                if (sgList.size() == 1) {
                    if (!((ServerGroup)sgList.get(0)).isServerPool()) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.CANNOT_UPDATE_ADMINSP_OF_ADMIN_DB, this.getUserAssignedName(), sgStr);
                    }
                    this.modifyDatabase(ServerFactoryImpl.getInstance().getServerPool(((ServerGroup)sgList.get(0)).getName()), force);
                }
                if (this.isAdminManaged()) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_DB_CENTRIC_CONFIG, this.getUserAssignedName(), sgStr);
                }
                myServices = this.services();
                if (myServices.size() == 0) {
                    ral.add(cf.create(ResourceType.Database.SERVER_POOLS.name(), DatabaseImpl.getServerGroupString(sgList, String.valueOf(" "), false)));
                } else {
                    boolean isSuperset = true;
                    for (Service svc : myServices) {
                        if (isSuperset &= sgList.contains(((ServiceImpl)svc).serverGroup())) continue;
                        throw new DatabaseException((MessageKey)PrCdMsgID.CANNOT_UPDATE_POOLS_OF_DB_WITH_SVCS, this.getUserAssignedName(), sgStr, ((ServiceImpl)svc).serverGroup(), svc.getUserAssignedName());
                    }
                    if (isSuperset) {
                        ral.add(cf.create(ResourceType.Database.SERVER_POOLS.name(), DatabaseImpl.getServerGroupString(sgList, String.valueOf(" "), false)));
                    }
                }
            }
            if ((dbName = args.getDBName()) != null) {
                if (dbName.trim().length() > 0) {
                    DatabaseImpl.validateName(dbName, false);
                }
                Trace.out("Modifying db name with new value, " + dbName);
                ral.add(cf.create(ResourceType.Database.USR_ORA_DB_NAME.name(), dbName));
            }
            String string = args.getOracleUser();
            boolean userSet = false;
            if (string != null) {
                if (new SystemFactory().CreateSystem().isUnixSystem()) {
                    NodeAppsFactory.getInstance().assertRoot();
                    userSet = true;
                } else {
                    throw new DatabaseException((MessageKey)PrCdMsgID.MODIFY_USER_NOT_WIN, new Object[0]);
                }
            }
            String oh = oracleHome;
            boolean ohReset = false;
            if (oh != null) {
                Trace.out("Modifying oracle home with new value =" + oh);
                String oldOH = this.m_crsResource.getAttribute(ResourceType.Database.ORACLE_HOME.name()).getValue();
                Trace.out("Old oracle home = " + (String)oldOH);
                if (!oh.equals(oldOH)) {
                    if (doVersionCheck) {
                        Common.versionCheck(oh, new Version());
                    }
                    if (new SystemFactory().CreateSystem().isUnixSystem()) {
                        String user = new Util().getOracleUser(oh, null);
                        String oldUser = this.m_crsResource.getPermissions().getOwner();
                        if (string == null && !user.equals(oldUser)) {
                            throw new DatabaseException((MessageKey)PrCdMsgID.ORACLE_USER_MISMATCH, oldUser, this.getUserAssignedName(), user, oh);
                        }
                        if (string == null) {
                            boolean isRoot = false;
                            try {
                                NodeAppsFactory.getInstance().assertRoot();
                                isRoot = true;
                            }
                            catch (SoftwareModuleException e) {
                                Trace.out("Current user is not root " + e.getMessage());
                            }
                            if (isRoot) {
                                throw new DatabaseException((MessageKey)PrCdMsgID.ROOT_NOT_ALLOWED, this.getUserAssignedName());
                            }
                        }
                    } else {
                        WinSecurityFactory wsecFac = WinSecurityFactory.getInstance();
                        HomeFactory hf = HomeFactory.getInstance();
                        Version version = hf.getHome(oh).getVersion(oh);
                        Home home = wsecFac.getHome(oh, version);
                        Credentials newCred = home.getServiceUserFromHomePath();
                        User newUser = wsecFac.getUser(newCred, version);
                        NtUserTypeEnum newUserType = home.isServiceUserVirtualAccount() ? NtUserTypeEnum.VIRTUALACCOUNT : (newUser.isBuiltinAccount() ? NtUserTypeEnum.BUILTINACCOUNT : (newUser.isUserDomainUser() ? NtUserTypeEnum.LOWPRIVDOMAINUSER : NtUserTypeEnum.LOWPRIVLOCALUSER));
                        home = wsecFac.getHome(oldOH, this.version());
                        Credentials oldCred = home.getServiceUserFromHomePath();
                        User oldUser = wsecFac.getUser(oldCred, this.version());
                        NtUserTypeEnum oldUserType = home.isServiceUserVirtualAccount() ? NtUserTypeEnum.VIRTUALACCOUNT : (oldUser.isBuiltinAccount() ? NtUserTypeEnum.BUILTINACCOUNT : (oldUser.isUserDomainUser() ? NtUserTypeEnum.LOWPRIVDOMAINUSER : NtUserTypeEnum.LOWPRIVLOCALUSER));
                        if (myServices == null) {
                            myServices = this.services();
                        }
                        this.ntRemoveOldAclEntries(oh, oldOH, newCred, oldCred, newUserType, oldUserType, this.m_crsResource, this.version());
                        if (myServices != null) {
                            for (Service svc : myServices) {
                                CRSResourceImpl svcResource = (CRSResourceImpl)svc.crsResource();
                                this.ntRemoveOldAclEntries(oh, oldOH, newCred, oldCred, newUserType, oldUserType, svcResource, this.version());
                            }
                        }
                        if (newUserType == NtUserTypeEnum.VIRTUALACCOUNT || newUserType == NtUserTypeEnum.BUILTINACCOUNT) {
                            this.ntGrantAclsForTransparentHA(oh, this.m_crsResource, this.version());
                            this.ntGrantAclsForServices(myServices, oh);
                        } else if (!(oldUserType != NtUserTypeEnum.LOWPRIVDOMAINUSER && oldUserType != NtUserTypeEnum.LOWPRIVLOCALUSER || newUserType != NtUserTypeEnum.LOWPRIVDOMAINUSER && newUserType != NtUserTypeEnum.LOWPRIVLOCALUSER)) {
                            if (!newCred.equals(oldCred)) {
                                throw new DatabaseException((MessageKey)PrCdMsgID.ORACLE_USER_MISMATCH_WIN, oldOH, oh);
                            }
                        } else if (oldUserType == NtUserTypeEnum.BUILTINACCOUNT && (newUserType == NtUserTypeEnum.LOWPRIVDOMAINUSER || newUserType == NtUserTypeEnum.LOWPRIVLOCALUSER)) {
                            Trace.out("old user was builtin account and new user is LP local/domain user");
                            this.ntGrantAclsForTransparentHA(oh, this.m_crsResource, this.version());
                            this.ntGrantAclsForServices(myServices, oh);
                        }
                    }
                    Trace.out("Updating ORACLE_HOME and ORACLE_HOME_OLD attribute values");
                    ral.add(cf.create(ResourceType.Database.ORACLE_HOME.name(), oh));
                    ral.add(cf.create(ResourceType.Database.ORACLE_HOME_OLD.name(), oldOH));
                    ohReset = true;
                }
            }
            if (oh != null && ohReset) {
                if (new SystemFactory().CreateSystem().isUnixSystem()) {
                    acl = string != null && userSet ? this.createACLAttr(oh, this.version(), string) : this.createACLAttr(oh, this.version());
                    ral.add(acl);
                }
            } else if (string != null && userSet) {
                acl = this.createACLAttr(this.getOracleHome(), this.version(), (ResourcePermissionsImpl)this.m_crsResource.getPermissions(), string);
                ral.add(acl);
            }
            if (acl != null) {
                if (myServices == null) {
                    myServices = this.services();
                }
                for (Service svc : myServices) {
                    ((CRSResourceImpl)svc.crsResource()).update(acl);
                }
            }
            if ((domain = args.getDBDomain()) != null) {
                Trace.out("Modifying domain with new value, " + domain);
                ral.add(cf.create(ResourceType.Database.USR_ORA_DOMAIN.name(), domain));
            }
            if ((spfile = args.getSPFile()) != null) {
                Trace.out("Modifying spfile with new value, " + spfile);
                ral.add(cf.create(ResourceType.Database.SPFILE.name(), spfile));
            }
            if ((pwfile = args.getPWFile()) != null) {
                if (pwfile.length() > 0 && pwfile.startsWith(ResourceLiterals.PLUS.toString())) {
                    int slashIndex;
                    int n = slashIndex = pwfile.indexOf("/") == -1 ? pwfile.indexOf(92) : pwfile.indexOf("/");
                    if (slashIndex == -1) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_PWFILE, pwfile);
                    }
                    String dgName = pwfile.substring(1, slashIndex);
                    ASMFactory af = ASMFactory.getInstance();
                    DiskGroup pwFileDg = af.getDiskGroup(dgName);
                    if (pwFileDg != null && !ASMFactory.isClientMode()) {
                        pwFileDg.setASMPullUp();
                    }
                }
                Trace.out("Modifying pwfile with new value, " + pwfile);
                ral.add(cf.create(ResourceType.Database.PWFILE.name(), pwfile));
            }
            if ((dbRole = args.getDBRole()) != null) {
                if (this.getDBRole() == DBRole.FAR_SYNC || dbRole == DBRole.FAR_SYNC) {
                    Trace.out("The role of far sync can be specified only during database creationOnce specified it cannot be modified again. Failed to modifyrole of the database " + this.getUserAssignedName());
                    throw new DatabaseException((MessageKey)PrCdMsgID.MODIFY_ROLE_FARSYNC, this.getUserAssignedName());
                }
                Trace.out("Modifying dbrole with new value, " + dbRole.toString());
                ral.add(cf.create(ResourceType.Database.ROLE.name(), dbRole.toString()));
            }
            if ((startOpts = args.getStartModes()) != null) {
                String startStr = oracle.cluster.impl.util.Utils.getEnumString(startOpts, String.valueOf(" "));
                if (databaseRole == DBRole.FAR_SYNC && startStr.contains(StartOptions.OPEN.toString())) {
                    Trace.out("Database " + this.getUserAssignedName() + " cannot be modified to" + "include OPEN start option");
                    throw new DatabaseException((MessageKey)PrCdMsgID.FARSYNC_CANNOT_OPEN, this.getUserAssignedName());
                }
                Trace.out("Modifying start options with new value, " + startStr);
                ral.add(cf.create(ResourceType.Database.USR_ORA_OPEN_MODE.name(), startStr));
            }
            if ((stopOpts = args.getStopModes()) != null) {
                String stopStr = oracle.cluster.impl.util.Utils.getEnumString(stopOpts, String.valueOf(" "));
                Trace.out("Modifying stop options with new value, " + stopStr);
                ral.add(cf.create(ResourceType.Database.USR_ORA_STOP_MODE.name(), stopStr));
            }
            if ((startConcurrency = args.getStartConcurrency()) >= 0) {
                Trace.out("Modifying start concurrency with new value, " + startConcurrency);
                ral.add(cf.create(ResourceType.ClusterResource.START_CONCURRENCY.name(), String.valueOf(startConcurrency)));
            }
            if ((stopConcurrency = args.getStopConcurrency()) >= 0) {
                Trace.out("Modifying stop concurrency with new value, " + stopConcurrency);
                ral.add(cf.create(ResourceType.ClusterResource.STOP_CONCURRENCY.name(), String.valueOf(stopConcurrency)));
            }
            DatabaseType dbType = this.databaseType();
            List<DiskGroup> dglist = args.getDiskGroupList();
            List<String> acfsPaths = args.getACFSPaths();
            ManagementPolicy mgmtPolicy = args.getMgmtPolicy();
            if ((oracleHome != null || mgmtPolicy != null || acfsPaths != null) && dglist == null) {
                dglist = this.diskGroups();
            }
            if (dglist != null) {
                List<ResourceAttribute> dgAttrList = this.getDiskGroupAttrList(dglist);
                if (oracleHome == null) {
                    oh = this.getOracleHome();
                }
                ManagementPolicy policy = mgmtPolicy == null ? this.getMgmtPolicy() : mgmtPolicy;
                Trace.out("policy = " + (Object)((Object)policy));
                List<AsmClusterFileSystem> acfsList = null;
                if (acfsPaths != null || oracleHome != null) {
                    if (acfsPaths != null) {
                        Trace.out("number of acfsPaths = " + acfsPaths.size());
                        acfsList = this.validateACFSPaths(acfsPaths, oh);
                    } else {
                        acfsList = this.asmClusterFileSystems();
                        AsmClusterFileSystem acfs = null;
                        if (Cluster.isCluster()) {
                            acfs = this.getACFS(oracleHome, oracleHome, true);
                        }
                        if (acfs != null && !acfsList.contains(acfs)) {
                            Trace.out("Adding " + acfs.getName() + " to the ACFS list");
                            acfsList.add(acfs);
                        }
                    }
                } else {
                    acfsList = this.asmClusterFileSystems();
                }
                ral.addAll(Arrays.asList(this.createStartDepRTE(dgAttrList, acfsList, policy, dbType, this.isDBCentric())));
                ral.addAll(Arrays.asList(this.createStopDepRTE(dgAttrList, acfsList, oracleHome)));
            }
            if (mgmtPolicy != null) {
                Trace.out("Modifying management policy with new value, " + (Object)((Object)mgmtPolicy));
                ral.add(cf.create(ResourceType.Database.MANAGEMENT_POLICY.name(), mgmtPolicy.toString()));
                if (dbType == DatabaseType.RACOneNode) {
                    ral.add(cf.create(ResourceType.ClusterResource.AUTO_START.name(), CRSResource.AutoStart.RESTORE.toString()));
                    ral.add(cf.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceLiterals.RESTART_ATTEMPTS_RACONE.toString()));
                } else if (mgmtPolicy == ManagementPolicy.AUTOMATIC) {
                    ral.add(cf.create(ResourceType.ClusterResource.AUTO_START.name(), CRSResource.AutoStart.RESTORE.toString()));
                    ral.add(cf.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceType.Database.RESTART_ATTEMPTS.toString()));
                } else if (mgmtPolicy == ManagementPolicy.MANUAL) {
                    ral.add(cf.create(ResourceType.ClusterResource.AUTO_START.name(), CRSResource.AutoStart.NEVER.toString()));
                    ral.add(cf.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceLiterals.MANUAL_MGMT_RA.toString()));
                } else if (mgmtPolicy == ManagementPolicy.NORESTART) {
                    ral.add(cf.create(ResourceType.ClusterResource.AUTO_START.name(), CRSResource.AutoStart.NEVER.toString()));
                    ral.add(cf.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceLiterals.NORESTART_MGMT_RA.toString()));
                }
            }
            if ((dbType == DatabaseType.RACOneNode || dbType == DatabaseType.SIDB) && (instName = args.getInstanceName()) != null) {
                if (dbType == DatabaseType.RACOneNode && !instName.matches(INST_PREFIX_CHARSET)) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_INSTANCE_PREFIX, instName);
                }
                DatabaseImpl.validateName(instName, true);
                if (dbType == DatabaseType.RACOneNode && !instName.endsWith("_1")) {
                    instName = instName + '_' + "1";
                }
                ral.add(cf.create(ResourceType.Database.USR_ORA_INST_NAME.name(), instName));
            }
            if (dbType == DatabaseType.RACOneNode && (timeout = args.getOnlineRelocationTimeout()) != 0) {
                ral.add(cf.create(ResourceType.Database.ONLINE_RELOCATION_TIMEOUT.name(), String.valueOf(timeout)));
            }
            if ((cssCritical = args.getCSSCriticalOption()) != null) {
                if (!this.isAdminManaged()) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.CSS_CRITICAL_NA, this.getUserAssignedName());
                }
                ral.add(cf.create(ResourceType.Database.CSS_CRITICAL.name(), cssCritical.toString()));
            }
            if ((cpuCount = args.getCPUCount()) != null) {
                ral.add(cf.create(ResourceType.Database.WORKLOAD_CPU.name(), cpuCount.toString()));
            }
            if ((memTarget = args.getMemoryTarget()) != null) {
                ral.add(cf.create(ResourceType.Database.WORKLOAD_MEMORY_TARGET.name(), memTarget.toString()));
            }
            if ((maxMemory = args.getMaxMemory()) != null) {
                ral.add(cf.create(ResourceType.Database.WORKLOAD_MEMORY_MAX.name(), maxMemory.toString()));
            }
            if ((defaultNetwork = args.getDefaultNetwork()) != null) {
                ral.add(cf.create(ResourceType.Database.DEFAULT_NETNUM.name(), String.valueOf(defaultNetwork.getNumber())));
            }
            if (ral.size() > 0) {
                ManagementPolicy oldPolicy = null;
                if (mgmtPolicy != null) {
                    oldPolicy = this.getMgmtPolicy();
                }
                this.m_crsResource.update(force, ral.toArray(new ResourceAttribute[ral.size()]));
                if (dbRole != null) {
                    if (myServices == null) {
                        myServices = this.services();
                    }
                    for (Service service : myServices) {
                        ((ServiceImpl)service).handleDbChanges(this, ResourceType.Database.ROLE);
                    }
                }
                if (mgmtPolicy != null) {
                    if (myServices == null) {
                        myServices = this.services();
                    }
                    if (mgmtPolicy == ManagementPolicy.MANUAL || mgmtPolicy == ManagementPolicy.NORESTART) {
                        ServiceArgs svcArgs = new ServiceArgs();
                        svcArgs.setMgmtPolicy(ManagementPolicy.MANUAL);
                        for (Service srv : myServices) {
                            ((ServiceImpl)srv).modify(svcArgs);
                        }
                    }
                    if (oldPolicy == ManagementPolicy.NORESTART || mgmtPolicy == ManagementPolicy.NORESTART) {
                        for (Service service : myServices) {
                            ((ServiceImpl)service).handleDbChanges(this, ResourceType.Database.MANAGEMENT_POLICY);
                        }
                    }
                }
                if (string != null) {
                    if (myServices == null) {
                        myServices = this.services();
                    }
                    for (Service service : myServices) {
                        CRSResource res = service.crsResource();
                        ResourcePermissions rp = res.getPermissions();
                        rp.setOwner(string);
                        res.setPermissions(rp);
                    }
                }
            }
        }
        catch (CRSException e) {
            String eMsg = e.getMessage();
            if (eMsg.contains("CRS-0215:") || eMsg.contains("CRS-2674:") || eMsg.contains("CRS-5017:")) {
                throw new DatabaseException(e);
            }
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NoVersionAvailableException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServiceException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (UtilException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (WindowsSecurityException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void start(StartOptions[] startupOptions) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (startupOptions == null || startupOptions.length == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"startupOptions", startupOptions});
        }
        this.startHelper(null, startupOptions, null);
    }

    @Override
    public void start(StartOptions[] startupOptions, int concurrency) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (concurrency < 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_VALUE_FOR_PARAM, "startconcurrency", concurrency);
        }
        this.startHelper(null, startupOptions, concurrency);
    }

    void startHelper(List<ServerPool> spList, StartOptions[] startupOptions, Integer concurrency) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        try {
            if (startupOptions != null && this.getDBRole() == DBRole.FAR_SYNC && Arrays.asList(startupOptions).contains((Object)StartOptions.OPEN)) {
                Trace.out("Database " + this.getUserAssignedName() + " cannot be started with OPEN option");
                throw new DatabaseException((MessageKey)PrCdMsgID.FARSYNC_CANNOT_OPEN, this.getUserAssignedName());
            }
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ArrayList<ResourceAttribute> startAttrs = new ArrayList<ResourceAttribute>();
            if (startupOptions != null && startupOptions.length != 0) {
                startAttrs.add(cf.create(ResourceType.Database.USR_ORA_OPEN_MODE.name(), oracle.cluster.impl.util.Utils.getEnumString(startupOptions, String.valueOf(" "))));
            }
            if (concurrency != null && concurrency != 0) {
                startAttrs.add(cf.create(ResourceType.ClusterResource.START_CONCURRENCY.name(), concurrency.toString()));
            }
            ResourceAttribute[] resAttrArr = startAttrs.toArray(new ResourceAttribute[startAttrs.size()]);
            if (spList == null) {
                if (resAttrArr.length != 0) {
                    this.m_crsResource.start(resAttrArr);
                } else {
                    this.m_crsResource.start();
                }
            } else {
                this.m_crsResource.start(spList, true, startAttrs);
            }
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.FAILED_TO_START_DB, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.FAILED_TO_START_DB, (Throwable)e, this.getUserAssignedName());
        }
        catch (InvalidArgsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.FAILED_TO_START_DB, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void startServices(List<Service> services) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        this.startServices(services, false);
    }

    @Override
    public void startServices(List<Service> services, boolean global) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (services == null || services.size() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "services", services);
        }
        ServiceArgs args = new ServiceArgs();
        try {
            args.setGlobal(global);
        }
        catch (ServiceException e) {
            throw new DatabaseException(e);
        }
        this.internalStartServices(services, null, null, args);
    }

    @Override
    public void startServices(List<Service> services, DatabaseInstance instance) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        this.startServices(services, instance, false);
    }

    @Override
    public void startServices(List<Service> services, DatabaseInstance instance, boolean global) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (services == null || services.size() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "services", services);
        }
        if (instance == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "instance", instance);
        }
        try {
            ServiceArgs args = new ServiceArgs();
            args.setGlobal(global);
            this.internalStartServices(services, instance.node(), null, args);
        }
        catch (InstanceException ne) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_SERVICES_FAILED, (Throwable)ne, this.getUserAssignedName());
        }
        catch (ServiceException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void startServices(List<Service> services, StartOptions[] startupOptions) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        this.startServices(services, startupOptions, false);
    }

    @Override
    public void startServices(List<Service> services, StartOptions[] startupOptions, boolean global) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (services == null || services.size() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "startupOptions", services);
        }
        if (startupOptions == null || startupOptions.length == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"startupOptions", startupOptions});
        }
        try {
            ServiceArgs args = new ServiceArgs();
            args.setGlobal(global);
            args.setStartOptions(startupOptions);
            this.internalStartServices(services, null, null, args);
        }
        catch (ServiceException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void startServices(List<Service> services, StartOptions[] startupOptions, DatabaseInstance instance) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        this.startServices(services, startupOptions, instance, false);
    }

    @Override
    public void startServices(List<Service> services, StartOptions[] startupOptions, DatabaseInstance instance, boolean global) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (services == null || services.size() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "startupOptions", services);
        }
        if (startupOptions == null || startupOptions.length == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"startupOptions", startupOptions});
        }
        if (instance == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "instance", instance);
        }
        try {
            ServiceArgs args = new ServiceArgs();
            args.setGlobal(global);
            args.setStartOptions(startupOptions);
            this.internalStartServices(services, instance.node(), null, args);
        }
        catch (InstanceException ne) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_SERVICES_FAILED, (Throwable)ne, this.getUserAssignedName());
        }
        catch (ServiceException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void startServices(ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-startServices01");
        }
        this.internalStartServices(null, null, null, args);
    }

    @Override
    public void startServices(List<Service> services, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (services == null || services.size() == 0 || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-startServices02");
        }
        this.internalStartServices(services, null, null, args);
    }

    @Override
    public void startServices(List<Service> services, DatabaseInstance instance, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (services == null || services.size() == 0 || instance == null || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-startServices03");
        }
        try {
            this.internalStartServices(services, instance.node(), null, args);
        }
        catch (InstanceException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_SERVICES_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void startServices(DatabaseInstance instance, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (instance == null || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-startServices03");
        }
        try {
            this.internalStartServices(null, instance.node(), null, args);
        }
        catch (InstanceException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_SERVICES_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    void internalStartServices(List<Service> services, Node node, ServerPool sg, ServiceArgs args) throws AlreadyRunningException, DatabaseException {
        HashMap<String, String> nodeSvcMap;
        ResourceAttribute[] optionalAttr = null;
        ArrayList<String> svcList = new ArrayList<String>();
        StringBuilder allSvcs = new StringBuilder();
        try {
            Filter svcFilter;
            boolean forceFlag;
            boolean isSvcSpecified;
            Enum[] startupOptions = args.getStartOptions();
            Boolean globalB = args.getGlobal();
            boolean global = globalB != null ? globalB : false;
            String pdb = args.getPDB();
            List<String> startSvcList = args.getServiceNames();
            Trace.out((Object)"names on CLI = %s", startSvcList != null ? startSvcList.toString() : null);
            boolean bl = isSvcSpecified = services != null && services.size() > 0 || startSvcList != null;
            if (pdb != null && isSvcSpecified) {
                throw new DatabaseException((MessageKey)PrCdMsgID.BOTH_PARAMS_NOT_NULL, "pluggable database", "services");
            }
            if (node != null && sg != null) {
                throw new DatabaseException((MessageKey)PrCdMsgID.BOTH_PARAMS_NOT_NULL, "node", "server group");
            }
            if (startupOptions != null && startupOptions.length > 0 && !this.isRunning()) {
                boolean badOptionFound = false;
                StringBuffer badOpt = new StringBuffer();
                for (Enum opt : startupOptions) {
                    if (((StartOptions)opt).isValidForService()) continue;
                    if (badOptionFound) {
                        badOpt.append(',');
                    }
                    badOpt.append(((StartOptions)opt).toString());
                    badOptionFound = true;
                }
                if (badOptionFound) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.SERV_BAD_STARTOPT2, this.getUserAssignedName(), badOpt.toString());
                }
            }
            Filter startFilter = null;
            if (pdb != null) {
                Trace.out("pdb specified = " + pdb);
                startFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQI, ResourceType.Service.PLUGGABLE_DATABASE.name(), pdb);
            }
            if (startupOptions != null && startupOptions.length > 0) {
                optionalAttr = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_OPEN_MODE.name(), oracle.cluster.impl.util.Utils.getEnumString(startupOptions, String.valueOf(" ")))};
            }
            Filter mainFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceType.Service.SERVICE_TYPE.name(), ServiceType.MAIN.toString());
            Filter pqFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceType.Service.SERVICE_TYPE.name(), ServiceType.PQ.toString());
            if (args.getServiceType() == ServiceType.PQ) {
                startFilter = startFilter != null ? FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, startFilter, pqFilter) : pqFilter;
            }
            boolean bl2 = forceFlag = this.databaseType() == DatabaseType.RAC;
            if (sg != null) {
                String name = sg.getName();
                Trace.out("Starting services configured on serverpool " + name);
                if (startFilter != null) {
                    Trace.out("filter is this " + startFilter.toString());
                    startFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, startFilter, DBFilterFactory.getSvc4DBOnSrvPool(this.getName(), name));
                } else {
                    startFilter = DBFilterFactory.getSvc4DBOnSrvPool(this.getName(), name);
                }
                CRSFactoryImpl.startResources(startFilter, forceFlag, null, optionalAttr);
                return;
            }
            if (services != null && !services.isEmpty()) {
                List<ResourceAttribute> resList = CRSFactoryImpl.getInstance().searchResources((CRSResourceImpl)this.crsResource(), CRSEntity.Type.Resource, DBFilterFactory.getServices4DB(this.getName()));
                ArrayList<String> confSvcList = new ArrayList<String>(resList.size());
                Iterator iterator = resList.iterator();
                while (iterator.hasNext()) {
                    ResourceAttribute ra = (ResourceAttribute)iterator.next();
                    confSvcList.add(ra.getValue());
                }
                StringBuilder sb = new StringBuilder();
                for (Service srv : services) {
                    if (srv.isGlobal() && !global) {
                        throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, srv.getUserAssignedName());
                    }
                    if (confSvcList.contains(srv.getName())) {
                        svcList.add(srv.getName());
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(srv.getUserAssignedName());
                }
                if (sb.length() > 0) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_WRONG_SERVICES, this.getUserAssignedName(), sb.toString());
                }
                svcFilter = this.getSvcFilter(services);
            } else if (startSvcList != null) {
                Trace.out((Object)"svcs = %s", startSvcList.toString());
                Trace.out("Svc Names Lower cased..");
                for (String svc : startSvcList) {
                    svcList.add(svc.toLowerCase());
                    if (allSvcs.length() > 0) {
                        allSvcs.append(",");
                    }
                    allSvcs.append(svc);
                }
                svcFilter = DBFilterFactory.getSvcList4DB(this.getName(), svcList);
                this.validateSvcNames(svcFilter, startSvcList, false);
                if (args.getServiceType() != ServiceType.PQ) {
                    this.validateSvcNames(svcFilter, startSvcList, true);
                }
            } else {
                svcFilter = DBFilterFactory.getServices4DB(this.getName());
                if (node == null && args.getServiceType() != ServiceType.PQ) {
                    svcFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, svcFilter, mainFilter);
                }
            }
            if (startFilter != null) {
                svcFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, startFilter, svcFilter);
            }
            this.checkGlobalServices(services, svcFilter, global);
            String nodeName = node != null ? node.getName() : null;
            Trace.out("Trying to start on the node " + nodeName + " for the database " + this.getUserAssignedName());
            Trace.out("start filter = " + svcFilter.toString());
            nodeSvcMap = new HashMap<String, String>();
            CRSFactoryImpl.startResources(svcFilter, forceFlag, nodeName, optionalAttr, nodeSvcMap);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_SERVICES_FAILED, (Throwable)e, allSvcs.length() > 0 ? allSvcs.toString() : "", this.getUserAssignedName());
        }
        catch (NodeException ne) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_SERVICES_FAILED, (Throwable)ne, allSvcs.length() > 0 ? allSvcs.toString() : "", this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_SERVICES_FAILED, (Throwable)e, allSvcs.length() > 0 ? allSvcs.toString() : "", this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
        catch (CompositeOperationException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_SERVICES_FAILED, (Throwable)e, this.getFailedSvcs(svcList.toArray(new String[svcList.size()]), e.getCompositeMessages()), this.getUserAssignedName());
        }
        if (nodeSvcMap.size() == 0) {
            throw new AlreadyRunningException((MessageKey)PrCrMsgID.RESOURCES_ALREADY_RUNNING, "");
        }
    }

    @Override
    public void stopServices() throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        ServiceArgs args = new ServiceArgs();
        this.stopServices(args);
    }

    @Override
    public void stopServices(ServiceArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        if (args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-stopServices02");
        }
        this.internalStopServices(null, null, null, args);
    }

    @Override
    public void stopServices(String nodeName, ServiceArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        if (nodeName == null || nodeName.trim().isEmpty() || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-stopServices03");
        }
        this.internalStopServices(null, nodeName, null, args);
    }

    @Override
    public void stopServices(List<Service> services) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        ServiceArgs args = new ServiceArgs();
        this.stopServices(services, args);
    }

    @Override
    public void stopServices(List<Service> services, ServiceArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        if (services == null || services.isEmpty() || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-stopServices05");
        }
        this.internalStopServices(services, null, null, args);
    }

    @Override
    public void stopServices(List<Service> services, String nodeName, ServiceArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        if (services == null || services.isEmpty() || nodeName == null || nodeName.trim().isEmpty() || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-stopServices06");
        }
        this.internalStopServices(services, nodeName, null, args);
    }

    @Override
    public List<Service> getServices(String pdb) throws DatabaseException {
        return this.services(true, false, false, pdb);
    }

    void internalStopServices(List<Service> services, String node, ServerPool sg, ServiceArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        StringBuilder svcNames = new StringBuilder();
        Filter stopFilter = null;
        boolean isPdb = false;
        String resName = null;
        ManageableEntityException ex = null;
        if (args == null) {
            args = new ServiceArgs();
        }
        String pdb = args.getPDB();
        Boolean waitVal = args.getWait();
        try {
            boolean isSvcSpecified;
            List<String> stopSvcList = args.getServiceNames();
            boolean wait = waitVal != null ? waitVal : false;
            boolean bl = isSvcSpecified = services != null && services.size() > 0 || stopSvcList != null;
            if (stopSvcList != null) {
                Trace.out((Object)"names on CLI = %s", stopSvcList.toString());
            }
            if (pdb != null && isSvcSpecified) {
                throw new DatabaseException((MessageKey)PrCdMsgID.BOTH_PARAMS_NOT_NULL, "pluggable database", "services");
            }
            if (node != null && sg != null) {
                throw new DatabaseException((MessageKey)PrCdMsgID.BOTH_PARAMS_NOT_NULL, "node", "server group");
            }
            ResourceAttribute[] options = null;
            boolean global = args.getGlobal() == null ? false : args.getGlobal();
            boolean disconnect = args.getDisconnectOpt() == null ? false : args.getDisconnectOpt();
            boolean noreplay = args.getNoreplay() == null ? false : args.getNoreplay();
            VerboseListener vlsnr = args.getVerboseListener();
            Enum[] stopOptions = args.getStopOptions();
            Integer drainTimeout = args.getDrainTimeout();
            ServiceType svcType = args.getServiceType();
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ArrayList<ResourceAttribute> optionsList = new ArrayList<ResourceAttribute>();
            optionsList.add(cf.create(ResourceType.Service.USR_ORA_DISCONNECT.name(), String.valueOf(disconnect)));
            optionsList.add(cf.create(ResourceType.Service.SESSION_NOREPLAY.name(), String.valueOf(noreplay)));
            String stopOpt = null;
            if (stopOptions != null && stopOptions.length > 0) {
                stopOpt = oracle.cluster.impl.util.Utils.getEnumString(stopOptions, String.valueOf(" "));
                Common.checkDrainStopOpt(drainTimeout, stopOpt);
                optionsList.add(cf.create(ResourceType.Database.USR_ORA_STOP_MODE.name(), stopOpt));
            }
            if (drainTimeout != null) {
                String drainStr = drainTimeout > -1 ? drainTimeout.toString() : "";
                optionsList.add(cf.create(ResourceType.Service.DRAIN_TIMEOUT.name(), drainStr));
            }
            String drainID = Common.getDrainID();
            optionsList.add(cf.create(ResourceType.Service.DRAIN_ID.name(), drainID));
            options = new ResourceAttribute[optionsList.size()];
            optionsList.toArray(options);
            Filter argsFilter = null;
            if (pdb != null) {
                isPdb = true;
                argsFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQI, ResourceType.Service.PLUGGABLE_DATABASE.name(), pdb);
            }
            if (svcType != null && svcType == ServiceType.PQ) {
                Filter svcTypeF = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceType.Service.SERVICE_TYPE.name(), svcType.toString());
                argsFilter = argsFilter != null ? FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, argsFilter, svcTypeF) : svcTypeF;
                Trace.out("Adding filter for Service of type : " + svcType.toString() + " Filter: " + argsFilter.toString());
            }
            Map<String, Map<String, String>> resources = cf.searchEntities((CRSEntity)((Object)this.crsResource()), CRSEntity.Type.Resource, false, DBFilterFactory.getServices4DB(this.getName()), ResourceType.Service.NAME.name(), ResourceType.Service.TAF_POLICY.name());
            ArrayList<String> configSvcNames = new ArrayList<String>(resources.size());
            boolean containsPreconnSvc = false;
            for (String resID : resources.keySet()) {
                Map<String, String> attrs = resources.get(resID);
                configSvcNames.add(attrs.get(ResourceType.Service.NAME.name()));
                if (!ServiceTAF.PRECONNECT.toString().equalsIgnoreCase(attrs.get(ResourceType.Service.TAF_POLICY.name()))) continue;
                containsPreconnSvc = true;
            }
            resName = isPdb ? pdb : (stopSvcList != null ? oracle.cluster.impl.util.Utils.strListToList2(stopSvcList) : null);
            Filter svcFilter = null;
            if (services != null) {
                Trace.out("services are not null");
                StringBuilder sb = new StringBuilder();
                StringBuilder sb2 = new StringBuilder();
                for (Service svc : services) {
                    if (!configSvcNames.contains(svc.getName())) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(svc.getUserAssignedName());
                        continue;
                    }
                    if (svc.isGlobal() && !global) {
                        if (sb2.length() > 0) {
                            sb2.append(",");
                        }
                        sb2.append(svc.getUserAssignedName());
                        continue;
                    }
                    if (svcNames.length() > 0) {
                        svcNames.append(",");
                    }
                    svcNames.append(svc.getUserAssignedName());
                }
                if (sb.length() > 0) {
                    resName = sb.toString();
                    throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_WRONG_SERVICES, this.getUserAssignedName(), sb.toString());
                }
                if (sb2.length() > 0) {
                    resName = sb2.toString();
                    throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, resName);
                }
                resName = isPdb ? pdb : svcNames.toString();
                svcFilter = this.getSvcFilter(services);
            } else if (stopSvcList != null) {
                ArrayList<String> svcList = new ArrayList<String>();
                Trace.out((Object)"svc = %s", stopSvcList.toString());
                Trace.out("Svc Names Lower cased..");
                for (String svc : stopSvcList) {
                    svcList.add(svc.toLowerCase());
                }
                svcFilter = DBFilterFactory.getSvcList4DB(this.getName(), svcList);
                this.validateSvcNames(svcFilter, stopSvcList, false);
                if (args.getServiceType() != ServiceType.PQ) {
                    this.validateSvcNames(svcFilter, stopSvcList, true);
                }
            } else {
                svcFilter = DBFilterFactory.getServices4DB(this.getName());
            }
            if (noreplay && !disconnect) {
                throw new DatabaseException((MessageKey)PrCdMsgID.NOREPLAY_NOT_ALLOWED, this.getUserAssignedName());
            }
            if (argsFilter != null) {
                svcFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, svcFilter, argsFilter);
            }
            this.checkGlobalServices(services, svcFilter, global);
            HashMap<String, String> nodeSvcMap = new HashMap<String, String>();
            if (sg != null) {
                String name = sg.getName();
                Trace.out("Stopping services configured on serverpool " + name);
                stopFilter = DBFilterFactory.getSvc4DBOnSrvPool(this.getName(), name);
                if (stopFilter != null) {
                    Trace.out("Stop Filter 1: " + stopFilter.toString());
                }
                if (isPdb) {
                    argsFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQI, ResourceType.Service.PLUGGABLE_DATABASE.name(), pdb);
                    stopFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, stopFilter, argsFilter);
                    Trace.out("Stop Filter 2: " + stopFilter.toString());
                }
                CRSFactoryImpl.stopResources(stopFilter, false, true, options, nodeSvcMap);
            } else if (node != null) {
                Filter nodeFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQI, ResourceLiterals.CRS_LAST_SERVER.toString(), node);
                stopFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, svcFilter, nodeFilter);
                Trace.out("Trying to stop services on node " + node + "for database " + this.getUserAssignedName());
                Trace.out("Stop Filter :" + (stopFilter == null ? null : stopFilter.toString()));
                CRSFactoryImpl.stopResources(stopFilter, false, false, options, nodeSvcMap);
            } else {
                Filter preconnectFilter = null;
                stopFilter = null;
                if (containsPreconnSvc) {
                    preconnectFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQI, ResourceType.Service.TAF_POLICY.name(), ServiceTAF.PRECONNECT.toString());
                    stopFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, svcFilter, preconnectFilter);
                    Trace.out("Stopping preconnect services on all nodes");
                    Trace.out("Stop Filter :" + (stopFilter == null ? null : stopFilter.toString()));
                    CRSFactoryImpl.stopResources(stopFilter, true, false, options, nodeSvcMap);
                }
                preconnectFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.NOT_EQ, ResourceType.Service.TAF_POLICY.name(), ServiceTAF.PRECONNECT.toString());
                stopFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, svcFilter, preconnectFilter);
                Trace.out("Stopping non-preconnect services on all nodes");
                Trace.out("Stop Filter :" + (stopFilter == null ? null : stopFilter.toString()));
                CRSFactoryImpl.stopResources(stopFilter, false, true, options, nodeSvcMap);
            }
            if (nodeSvcMap.size() == 0) {
                Trace.out("No service was stopped");
                if (configSvcNames.size() == 0) {
                    throw new AlreadyStoppedException((MessageKey)PrCdMsgID.NO_OPERATION, new Object[0]);
                }
                throw new AlreadyStoppedException((MessageKey)PrCrMsgID.RESOURCES_ALREADY_STOPPED, new Object[0]);
            }
            if (wait) {
                int waitTime = 0;
                waitTime = drainTimeout != null ? (drainTimeout == -1 ? 0 : drainTimeout) : Common.calculateMaxDrain(stopFilter);
                Trace.out("wait time = " + waitTime);
                if (waitTime > 0) {
                    try {
                        this.waitForDrainCompletion(drainID, waitTime, nodeSvcMap, vlsnr);
                    }
                    catch (DatabaseException e) {
                        ex = e;
                    }
                }
            }
        }
        catch (CRSException e) {
            this.checkDatabaseException(resName, isPdb, e);
        }
        catch (NotExistsException e) {
            this.checkDatabaseException(resName, isPdb, e);
        }
        catch (AlreadyStoppedException e) {
            String noOpMsg = MessageBundle.getMessageBundle(PrCdMsgID.facility).getMessage(PrCdMsgID.NO_OPERATION, true);
            if (noOpMsg.equalsIgnoreCase(e.getMessage())) {
                throw e;
            }
            this.checkAlreadyStoppedException(resName, isPdb, e);
        }
        catch (CRSCompositeOperationException e) {
            if (resName != null && resName.contains(",")) {
                resName = this.getFailedSvcs(resName.split(","), e.getCompositeMessages());
            }
            boolean alreadyStopped = true;
            for (Object id : e.getOperationIdentifier()) {
                try {
                    if (e.getErrorMessage(id).contains("CRS-2500:")) continue;
                    alreadyStopped = false;
                }
                catch (NoSuchIdentifierException nsie) {
                    alreadyStopped = false;
                }
            }
            if (alreadyStopped) {
                this.checkAlreadyStoppedException(resName, isPdb, e);
            } else {
                this.checkCompOpException(resName, isPdb, e);
            }
        }
        catch (ServiceException e) {
            throw new DatabaseException(e);
        }
        catch (SoftwareModuleException e) {
            this.checkDatabaseException(resName, isPdb, e);
        }
        if (ex != null) {
            Trace.out("Exception during drain action : \n" + ex.getMessage());
            throw ex;
        }
    }

    private String getFailedSvcs(String[] resArr, String compErrMsg) {
        String startsWith = this.getStartsWith();
        String endsWith = '.' + ResourceLiterals.SVC.toString();
        StringBuilder failedSvcs = new StringBuilder();
        for (String svc : resArr) {
            if (!compErrMsg.contains(startsWith + svc + endsWith)) continue;
            if (failedSvcs.length() > 0) {
                failedSvcs.append(",");
            }
            failedSvcs.append(svc);
        }
        if (failedSvcs.length() > 0) {
            return failedSvcs.toString();
        }
        return "";
    }

    private void checkDatabaseException(String name, boolean isPdb, Throwable e) throws DatabaseException {
        if (isPdb) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_STOP_SERV4PDB_FAILED, e, this.getUserAssignedName(), name);
        }
        throw new DatabaseException((MessageKey)PrCdMsgID.DB_STOP_SERVICES_FAILED, e, name == null ? "" : name, this.getUserAssignedName());
    }

    private void checkAlreadyStoppedException(String name, boolean isPdb, Throwable e) throws AlreadyStoppedException {
        if (isPdb) {
            throw new AlreadyStoppedException((MessageKey)PrCdMsgID.DB_STOP_SERV4PDB_FAILED, e, this.getUserAssignedName(), name);
        }
        throw new AlreadyStoppedException((MessageKey)PrCdMsgID.DB_STOP_SERVICES_FAILED, e, name == null ? "" : name, this.getUserAssignedName());
    }

    private void checkCompOpException(String name, boolean isPdb, Throwable e) throws CompositeOperationException {
        if (isPdb) {
            throw new CompositeOperationException((MessageKey)PrCdMsgID.DB_STOP_SERV4PDB_FAILED, e, new HashMap<Object, NativeResult>(), this.getUserAssignedName(), name);
        }
        throw new CompositeOperationException((MessageKey)PrCdMsgID.DB_STOP_SERVICES_FAILED, e, new HashMap<Object, NativeResult>(), name == null ? "" : name, this.getUserAssignedName());
    }

    @Override
    public void stop(StopOptions[] stopOptions, boolean forceFlag) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        if (stopOptions == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"stopOptions", stopOptions});
        }
        this.stop(stopOptions, 0, forceFlag);
    }

    @Override
    public void stop(StopOptions[] stopOptions, int concurrency, boolean forceFlag) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        if (stopOptions == null || Arrays.asList(stopOptions).contains(null) || concurrency < 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-stop04");
        }
        DatabaseOptionalArgs args = new DatabaseOptionalArgs();
        args.setStopModes(stopOptions);
        args.setStopConcurrency(concurrency);
        args.setForceFlag(forceFlag);
        this.stopHelper(null, args);
    }

    @Override
    public void stop(DatabaseOptionalArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        this.stopHelper(null, args);
    }

    void stopHelper(List<ServerPool> spList, DatabaseOptionalArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        block20: {
            try {
                Enum[] stopOptions = args.getStopModes();
                Integer concurrency = args.getStopConcurrency();
                Integer drainTimeout = args.getDrainTimeout();
                Boolean forceVal = args.getForceFlag();
                boolean forceFlag = forceVal != null ? forceVal : false;
                CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
                ArrayList<ResourceAttribute> stopAttrs = new ArrayList<ResourceAttribute>();
                if (stopOptions != null && stopOptions.length > 0) {
                    stopAttrs.add(cf.create(ResourceType.Database.USR_ORA_STOP_MODE.name(), oracle.cluster.impl.util.Utils.getEnumString(stopOptions, String.valueOf(" "))));
                }
                if (concurrency != null && concurrency != 0) {
                    stopAttrs.add(cf.create(ResourceType.ClusterResource.STOP_CONCURRENCY.name(), String.valueOf(concurrency)));
                }
                ResourceAttribute[] resAttrArr = stopAttrs.toArray(new ResourceAttribute[stopAttrs.size()]);
                if (spList == null) {
                    if (forceFlag && this.databaseType() != DatabaseType.MGMTDB) {
                        Filter stopFilter;
                        if ((drainTimeout == null || drainTimeout != null && drainTimeout == 0) && (stopFilter = DBFilterFactory.getServices4DB(this.getName())) != null) {
                            Trace.out("Database Stop Filter: " + stopFilter.toString());
                            try {
                                drainTimeout = Common.calculateMaxDrain(stopFilter);
                            }
                            catch (ServiceException se) {
                                throw new DatabaseException(se);
                            }
                            args.setDrainTimeout(drainTimeout);
                        }
                        if (drainTimeout == null) {
                            if (resAttrArr != null) {
                                this.m_crsResource.stop(forceFlag, false, resAttrArr);
                            } else {
                                this.m_crsResource.stop(forceFlag, false);
                            }
                        } else {
                            this.stopDatabaseAndServices(args);
                        }
                        break block20;
                    }
                    if (this.databaseType() == DatabaseType.MGMTDB) {
                        this.assertIsRunning();
                        if (resAttrArr != null) {
                            this.m_crsResource.stop(forceFlag, true, resAttrArr);
                        } else {
                            this.m_crsResource.stop(forceFlag, true);
                        }
                    } else {
                        this.stopDatabaseAndServices(args);
                    }
                    break block20;
                }
                this.m_crsResource.stop(spList, stopAttrs, forceFlag, false);
            }
            catch (DatabaseException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.FAILED_TO_STOP_DB, (Throwable)e, this.getUserAssignedName());
            }
            catch (CRSException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.FAILED_TO_STOP_DB, (Throwable)e, this.getUserAssignedName());
            }
            catch (InvalidArgsException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.FAILED_TO_STOP_DB, (Throwable)e, this.getUserAssignedName());
            }
            catch (NotRunningException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.FAILED_TO_STOP_DB, (Throwable)e, this.getUserAssignedName());
            }
        }
    }

    @Override
    public void stop(boolean forceFlag) throws AlreadyStoppedException, SoftwareModuleException {
        try {
            if (forceFlag) {
                this.m_crsResource.stop(forceFlag, false);
            } else if (this.databaseType() == DatabaseType.MGMTDB) {
                this.assertIsRunning();
                this.m_crsResource.stop(forceFlag, false);
            } else {
                this.stopDatabaseAndServices(new DatabaseOptionalArgs());
            }
        }
        catch (CRSException exp) {
            throw new SoftwareModuleException((MessageKey)PrCdMsgID.STOP_DB_FAILED, (Throwable)exp, this.getUserAssignedName());
        }
        catch (CompositeOperationException exp) {
            throw new SoftwareModuleException((MessageKey)PrCdMsgID.STOP_DB_FAILED, (Throwable)exp, this.getUserAssignedName());
        }
    }

    void stopDatabaseAndServices(DatabaseOptionalArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        try {
            this.internalSvcAndDBStopHelper(null, false, false, args);
        }
        catch (InstanceException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.STOP_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    protected DatabaseInstance getCriticalInstance(List<DatabaseInstance> instList) throws DatabaseException {
        if (!Cluster.isCluster()) {
            Trace.out("Oracle Restart env: no critical instance");
            return null;
        }
        try {
            String criticalStandbyGroupName = "DM" + this.getUserAssignedName().toUpperCase();
            ClusterUtil util = new ClusterUtil();
            for (DatabaseInstance inst : instList) {
                if (!util.checkInstance(criticalStandbyGroupName, inst.getUserAssignedName(), false)) continue;
                Trace.out("Critical instance name=" + inst.getUserAssignedName());
                return inst;
            }
            Trace.out("No critical instance found");
            return null;
        }
        catch (ClusterUtilException exp) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CRITICAL_INST_CHK_FAILED, (Throwable)exp, this.getUserAssignedName());
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, DatabaseException {
        try {
            Trace.out("calling parent's crsResource");
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, DatabaseException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(boolean force, boolean isMgmtDB) throws AlreadyRunningException, DatabaseException {
        try {
            if (isMgmtDB) {
                Trace.out("Removing management database resource");
                ResourceAttribute nameAttr = new ResourceAttribute(ResourceType.MgmtDatabase.NAME.name(), "ora." + ResourceLiterals.MGMTDB.toString());
                CRSResourceImpl mdb_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().getRegisteredOrNot(nameAttr);
                if (mdb_crsResource == null) throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_MGMTDB_FAILED, new Object[0]);
                mdb_crsResource.remove(force);
                return;
            } else {
                Trace.out("Removing the database resource");
                super.remove(force);
            }
            return;
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    public List<DiskGroup> diskGroups() throws DatabaseException {
        try {
            ArrayList<Object> dgList = null;
            ResourceAttribute startDepAttr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            Trace.out("start value = " + startDepAttr.getValue());
            String[] resNames = ResourceDependency.getResourceNames(startDepAttr, ResourceDependency.DepType.HARD_DEP);
            if (resNames.length == 0) {
                dgList = new ArrayList<DiskGroup>(0);
            } else {
                Trace.out("resNames length is " + resNames.length);
                ASMFactoryImpl asmFactory = ASMFactoryImpl.getInstance();
                dgList = new ArrayList(resNames.length);
                for (String resourceName : resNames) {
                    Trace.out("resourceName = " + resourceName);
                    try {
                        String dgName = null;
                        try {
                            dgName = DiskGroupImpl.getUserAssignedName((String)resourceName);
                        }
                        catch (ASMException e) {
                            continue;
                        }
                        Trace.out("disk group name = " + dgName);
                        dgList.add(asmFactory.getDiskGroup(dgName));
                    }
                    catch (NotExistsException ne) {
                        throw new DatabaseException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)ne, resourceName, this.getUserAssignedName());
                    }
                }
            }
            return dgList;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DISKGROUP_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DISKGROUP_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    public void setDiskGroups(List<DiskGroup> dgResList) throws DatabaseException {
        if (dgResList == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dgResList", dgResList);
        }
        try {
            if (ASMFactory.isClientMode()) {
                return;
            }
            DatabaseType dbType = this.databaseType();
            List<ResourceAttribute> dgAttrList = this.getDiskGroupAttrList(dgResList);
            String oracleHome = this.getOracleHome();
            ManagementPolicy mgmtPolicy = this.getMgmtPolicy();
            List<AsmClusterFileSystem> acfsList = this.asmClusterFileSystems();
            ResourceAttribute[] startDep = this.createStartDepRTE(dgAttrList, acfsList, mgmtPolicy, dbType, this.isDBCentric());
            ResourceAttribute[] stopDep = this.createStopDepRTE(dgAttrList, acfsList, oracleHome);
            this.m_crsResource.update(startDep[0], startDep[1], stopDep[0], stopDep[1]);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
        catch (ASMException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public List<AsmClusterFileSystem> asmClusterFileSystems() throws DatabaseException {
        try {
            if (!Cluster.isCluster() || ASMFactory.isClientMode()) {
                return new ArrayList<AsmClusterFileSystem>(0);
            }
            ArrayList<Object> acfsList = null;
            ResourceAttribute startDepAttr = this.m_crsResource.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
            String[] resNames = ResourceDependency.getResourceNames(startDepAttr, ResourceDependency.DepType.HARD_DEP);
            if (resNames.length == 0) {
                acfsList = new ArrayList<AsmClusterFileSystem>(0);
            } else {
                ASMFactoryImpl asmFactory = ASMFactoryImpl.getInstance();
                acfsList = new ArrayList(resNames.length);
                List fslist = null;
                try {
                    fslist = asmFactory.getAsmClusterFileSystems();
                }
                catch (NotExistsException e) {
                    return new ArrayList<AsmClusterFileSystem>(0);
                }
                boolean exist = false;
                for (String resourceName : resNames) {
                    Trace.out("resourceName = " + resourceName);
                    String[] acfsInfos = null;
                    try {
                        acfsInfos = AsmClusterFileSystemImpl.getUserAssignedNames((String)resourceName);
                    }
                    catch (AsmClusterFileSystemException e) {
                        continue;
                    }
                    Trace.out("disk group = %s, volume name = %s", acfsInfos[0], acfsInfos[1]);
                    exist = false;
                    for (AsmClusterFileSystem fs : fslist) {
                        if (!acfsInfos[0].equals(fs.getDiskGroup()) || !acfsInfos[1].equals(fs.getVolumeName())) continue;
                        acfsList.add(fs);
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    throw new DatabaseException((MessageKey)PrCdMsgID.GET_ACFS_RES_FAILED, resourceName, this.getUserAssignedName());
                }
            }
            return acfsList;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_ACFS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_ACFS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsmClusterFileSystem getACFS(String oracleHome, String acfsPath, boolean isOracleHome) throws DatabaseException {
        OFSUtil ofsutil = null;
        String mtpoint = null;
        AsmClusterFileSystem acfs = null;
        DatabaseException dbExp = null;
        try {
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            ofsutil = nativeSystem.isUnixSystem() ? new OFSUtil() : new OFSUtil(new Util().getCRSHome() + File.separator + "bin");
            mtpoint = ofsutil.getMountpoint(acfsPath);
            if (mtpoint == null) {
                dbExp = new DatabaseException((MessageKey)PrCdMsgID.CREATE_STARTDEP_NOT_ACFS_FAILED, this.getUserAssignedName(), acfsPath);
            }
        }
        catch (CmdToolUtilException e) {
            dbExp = new DatabaseException((MessageKey)PrCdMsgID.OFS_CREATE_STARTDEP_FAILED, (Throwable)e, this.getUserAssignedName(), acfsPath);
        }
        catch (UtilException e) {
            dbExp = new DatabaseException((MessageKey)PrCdMsgID.OFS_CREATE_STARTDEP_FAILED, (Throwable)e, this.getUserAssignedName(), acfsPath);
        }
        finally {
            if (dbExp != null) {
                if (isOracleHome) {
                    Trace.out("non fatal, exception encountered when getting mountpoint for oracle home");
                } else {
                    throw dbExp;
                }
            }
        }
        if (mtpoint != null) {
            String volDevice = "";
            try {
                volDevice = ofsutil.getVolumeDevice(mtpoint);
                ASMFactoryImpl asmfactImpl = ASMFactoryImpl.getInstance();
                acfs = asmfactImpl.getAsmClusterFileSystem(volDevice, oracleHome);
                Trace.out("resourceName=" + acfs.getName());
            }
            catch (AsmClusterFileSystemException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.OFS_CREATE_STARTDEP_FAILED, (Throwable)e, this.getUserAssignedName(), acfsPath);
            }
            catch (CmdToolUtilException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.OFS_CREATE_STARTDEP_FAILED, (Throwable)e, this.getUserAssignedName(), acfsPath);
            }
            catch (NotExistsException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.DB_ACFS_RESOURCE_NOT_EXIST, (Throwable)e, volDevice, acfsPath);
            }
            catch (SoftwareModuleException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.OFS_CREATE_STARTDEP_FAILED, (Throwable)e, this.getUserAssignedName(), acfsPath);
            }
        }
        return acfs;
    }

    private List<AsmClusterFileSystem> validateACFSPaths(List<String> acfsPaths, String oracleHome) throws DatabaseException {
        ArrayList<AsmClusterFileSystem> acfsList = new ArrayList<AsmClusterFileSystem>(0);
        if (Cluster.isCluster()) {
            AsmClusterFileSystem acfs = this.getACFS(oracleHome, oracleHome, true);
            if (acfs != null) {
                Trace.out("oracle home is on ACFS, adding oracle home ACFS resource");
                acfsList.add(acfs);
            }
            if (acfsPaths != null) {
                for (String acfsPath : acfsPaths) {
                    Trace.out("acfsPath = " + acfsPath);
                    acfs = this.getACFS(oracleHome, acfsPath, false);
                    if (acfsList.contains(acfs)) continue;
                    Trace.out("adding acfs " + acfs.getName());
                    acfsList.add(acfs);
                }
            }
        }
        return acfsList;
    }

    private NFS validateNFSPath(String oracleHome) throws DatabaseException {
        NFS nfs = null;
        try {
            if (Cluster.isCluster()) {
                NFSFactory nfsFactory = NFSFactory.getInstance();
                Trace.out("Looking for NFS resource with oracle home " + oracleHome + " as mount point");
                nfs = nfsFactory.getNFS(oracleHome);
            }
            return nfs;
        }
        catch (NotExistsException nee) {
            Trace.out("NFS resource not found with mount path" + oracleHome + "");
            return null;
        }
        catch (SoftwareModuleException sme) {
            Trace.out("Error while looking for NFS resources");
            throw new DatabaseException(sme);
        }
    }

    @Override
    public List<ServerGroup> getPQPools() throws ServerGroupException {
        String pqpools = null;
        try {
            pqpools = this.m_crsResource.getAttribute(ResourceType.Database.SERVER_POOLS_PQ.name()).getValue();
            String[] pqpoolArr = pqpools.trim().split(Pattern.quote(String.valueOf(" ")));
            ServerFactoryImpl serverFac = ServerFactoryImpl.getInstance();
            List<ServerGroup> sgList = serverFac.getServerGrpList(pqpools, String.valueOf(" "));
            return sgList;
        }
        catch (ServerException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.GET_PQPOOLS_FAILED, (Throwable)e, pqpools, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.GET_PQPOOLS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setPQPools(List<ServerGroup> pqPoolList) throws ServerGroupException {
        this.setPQPools(pqPoolList, false);
    }

    @Override
    public void setPQPools(List<ServerGroup> pqPoolList, boolean force) throws ServerGroupException {
        if (this.getSIDBType() == SIDBType.FIXED) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SIDB_FIXED_SET_SP_FAILED, this.getUserAssignedName());
        }
        String pqpools = DatabaseImpl.getServerGroupString(pqPoolList, String.valueOf(" "), false);
        try {
            DatabaseOptionalArgs dbArgs = new DatabaseOptionalArgs();
            dbArgs.setPQPools(pqPoolList);
            this.modifyDatabase(dbArgs, force);
        }
        catch (DatabaseException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SET_PQPOOLS_FAILED, (Throwable)e, pqpools, this.getUserAssignedName());
        }
    }

    @Override
    public List<ServerGroup> getRFPools() throws ServerGroupException {
        String rfpools = null;
        try {
            rfpools = this.m_crsResource.getAttribute(ResourceType.Database.SERVER_POOLS_RF.name()).getValue();
            ServerFactoryImpl serverFac = ServerFactoryImpl.getInstance();
            List<ServerGroup> sgList = serverFac.getServerGrpList(rfpools, String.valueOf(" "));
            return sgList;
        }
        catch (ServerException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.GET_RFPOOLS_FAILED, (Throwable)e, rfpools, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.GET_RFPOOLS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setRFPools(List<ServerGroup> rfPoolList) throws ServerGroupException {
        this.setRFPools(rfPoolList, false);
    }

    @Override
    public void setRFPools(List<ServerGroup> rfPoolList, boolean force) throws ServerGroupException {
        String rfpools = DatabaseImpl.getServerGroupString(rfPoolList, String.valueOf(" "), false);
        try {
            DatabaseOptionalArgs dbArgs = new DatabaseOptionalArgs();
            dbArgs.setRFPools(rfPoolList);
            this.modifyDatabase(dbArgs, force);
        }
        catch (DatabaseException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SET_RFPOOLS_FAILED, (Throwable)e, rfpools, this.getUserAssignedName());
        }
    }

    public ServerGroup serverGroup() throws ServerGroupException {
        try {
            return this.internalServerGroup();
        }
        catch (NotExistsException e) {
            throw new ServerGroupException(e);
        }
    }

    protected ServerGroup internalServerGroup() throws NotExistsException, ServerGroupException {
        String sgName = "";
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Database.SERVER_POOLS.name());
            sgName = attr.getValue().trim();
            Trace.out("server group name =" + sgName);
            if (sgName.length() > 0) {
                return ServerFactoryImpl.getInstance().getServerGroup(sgName);
            }
            throw new NotExistsException((MessageKey)PrCdMsgID.DB_NOT_HOSTED_BY_SP, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, sgName, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, sgName, this.getUserAssignedName());
        }
        catch (ServerGroupException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, sgName, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, sgName, this.getUserAssignedName());
        }
    }

    @Override
    public List<ServerGroup> serverGroups() throws ServerGroupException {
        String sgNameList = "";
        try {
            if (this.getSIDBType() == SIDBType.FIXED) {
                return new ArrayList<ServerGroup>();
            }
            String[] sgNameArr = this.serverPoolsHelper();
            sgNameList = Utils.getString(sgNameArr, String.valueOf(" "));
            ArrayList<ServerGroup> sgList = new ArrayList<ServerGroup>(sgNameArr.length);
            ServerFactoryImpl serverFac = ServerFactoryImpl.getInstance();
            for (String sgName : sgNameArr) {
                sgList.add(serverFac.getServerGroup(sgName, (CRSEntity)((Object)this.crsResource())));
            }
            return sgList;
        }
        catch (NotExistsException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, sgNameList, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, sgNameList, this.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, sgNameList, this.getUserAssignedName());
        }
    }

    protected String[] serverPoolsHelper() throws ServerGroupException {
        String sgNameList = "";
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Database.SERVER_POOLS.name());
            sgNameList = attr.getValue().trim();
            Trace.out("list of server pool names =" + sgNameList);
            return sgNameList.split(Pattern.quote(String.valueOf(" ")));
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, sgNameList, this.getUserAssignedName());
        }
    }

    protected String[] pqServerPoolsHelper() throws ServerGroupException {
        String sgNameList = "";
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Database.SERVER_POOLS_PQ.name());
            sgNameList = attr.getValue().trim();
            Trace.out("list of server pool names =" + sgNameList);
            return sgNameList.split(Pattern.quote(String.valueOf(" ")));
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, sgNameList, this.getUserAssignedName());
        }
    }

    @Override
    public void setServerGroups(List<ServerGroup> sgList) throws ServerGroupException {
        this.setServerGroups(sgList, false);
    }

    @Override
    public void setServerGroups(List<ServerGroup> sgList, boolean force) throws ServerGroupException {
        this.setServerGroups(sgList, force, false);
    }

    @Override
    public void setServerGroups(List<ServerGroup> sgList, boolean force, boolean internal) throws ServerGroupException {
        if (sgList == null || sgList.size() == 0) {
            throw new ServerGroupException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sgList", sgList);
        }
        if (this.getSIDBType() == SIDBType.FIXED) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SIDB_FIXED_SET_SP_FAILED, this.getUserAssignedName());
        }
        try {
            DatabaseOptionalArgs dbArgs = new DatabaseOptionalArgs();
            dbArgs.setServerGroupList(sgList);
            this.modifyDatabase(dbArgs, force, internal);
        }
        catch (DatabaseException e) {
            throw new ServerGroupException(e);
        }
    }

    @Override
    public String getOracleHome() throws DatabaseException {
        String oHome2 = null;
        if (this.databaseType() == DatabaseType.MGMTDB) {
            Map<String, String> res = this.getDBHomeNodesMap();
            for (String oHome2 : res.keySet()) {
            }
        } else {
            try {
                oHome2 = this.m_crsResource.getAttribute(ResourceType.Database.ORACLE_HOME.name()).getValue();
            }
            catch (CRSException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.GET_ORACLE_HOME_FAILED, (Throwable)e, this.getUserAssignedName());
            }
        }
        return oHome2;
    }

    @Override
    public String getOracleHome(Node node) throws NotExistsException, DatabaseException {
        String oracleHome = null;
        if (node == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", node);
        }
        String nodeName = "";
        try {
            nodeName = node.getName();
            try {
                oracleHome = this.m_crsResource.getAttribute(ResourceType.getPerXName(ResourceType.Database.ORACLE_HOME.name(), nodeName)).getValue();
            }
            catch (CRSException e) {
                oracleHome = this.getOracleHome();
            }
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_PERX_ORACLE_HOME_FAILED, (Throwable)e, this.getUserAssignedName(), nodeName);
        }
        return oracleHome;
    }

    public String getOracleHome(String nodeName) throws DatabaseException {
        if (nodeName == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node name", nodeName);
        }
        List<ResourceAttribute> attrlist = null;
        try {
            attrlist = this.m_crsResource.getCurrentAttributes(nodeName, ResourceType.Database.ORACLE_HOME.name());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_ORACLE_HOME_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        return attrlist.get(0).getValue();
    }

    @Override
    public Map<String, String> getDBHomeNodesMap() throws DatabaseException {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> instMap = this.getRunningInstances();
        if (instMap.size() > 0) {
            for (String inst : instMap.keySet()) {
                String nodeName = instMap.get(inst);
                String tmphome = this.getOracleHome(nodeName);
                Trace.out("For %s, oracle home is %s", nodeName, tmphome);
                if (tmphome == null) continue;
                StringBuilder nodes = new StringBuilder(nodeName);
                String tmpnode = (String)result.get(tmphome);
                if (tmpnode != null) {
                    nodes.append("," + tmpnode);
                    result.put(tmphome, nodes.toString());
                    continue;
                }
                result.put(tmphome, nodeName);
            }
        } else {
            String nodeName;
            try {
                nodeName = Utils.isDevelopmentEnv() ? Cluster.getLocalNode() : Cluster.getHostName();
            }
            catch (ClusterException e) {
                throw new DatabaseException((MessageKey)PrCtMsgID.FAILED_TO_GET_LOCAL_NODE_NAME, (Throwable)e, new Object[0]);
            }
            result.put(this.getOracleHome(nodeName), nodeName);
        }
        return result;
    }

    @Override
    public void setOracleHome(String oracleHome) throws DatabaseException {
        DatabaseImpl.assertOracleHome(oracleHome);
        this.internalModifyDatabase(new DatabaseOptionalArgs(), oracleHome, false, false, true);
    }

    public void setOracleHome(String oracleHome, boolean doVersionCheck) throws DatabaseException {
        DatabaseImpl.assertOracleHome(oracleHome);
        this.internalModifyDatabase(new DatabaseOptionalArgs(), oracleHome, false, false, doVersionCheck);
    }

    @Override
    public void setOracleHome(Node node, String oracleHome) throws DatabaseException {
        String nodeName;
        if (node == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", node);
        }
        DatabaseImpl.assertOracleHome(oracleHome);
        try {
            nodeName = node.getName();
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_ORACLE_HOME_FAILED, (Throwable)e, oracleHome, this.getUserAssignedName());
        }
        try {
            String attrName = ResourceType.getPerXName(ResourceType.Database.ORACLE_HOME.name(), nodeName);
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(attrName, oracleHome));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_PERX_ORACLE_HOME_FAILED, (Throwable)e, oracleHome, this.getUserAssignedName(), nodeName);
        }
    }

    @Override
    public List<StartOptions> getStartOptions() throws DatabaseException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Database.USR_ORA_OPEN_MODE.name());
            String options = attr.getValue();
            Trace.out("list of start options = " + options);
            return StartOptions.getEnumMemberList(options);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_START_OPTION_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setStartOptions(List<StartOptions> startupOptions) throws DatabaseException {
        if (startupOptions == null || startupOptions.size() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "startupOptions", startupOptions);
        }
        try {
            Enum[] soarr = startupOptions.toArray(new StartOptions[startupOptions.size()]);
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_OPEN_MODE.name(), oracle.cluster.impl.util.Utils.getEnumString(soarr, String.valueOf(" "))));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_START_OPTION_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public List<StopOptions> getStopOptions() throws DatabaseException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Database.USR_ORA_STOP_MODE.name());
            String options = attr.getValue().trim();
            Trace.out("list of stop options = " + options);
            String[] optionsArr = options.split(Pattern.quote(String.valueOf(" ")));
            ArrayList<StopOptions> optList = new ArrayList<StopOptions>(optionsArr.length);
            for (String opt : optionsArr) {
                optList.add(StopOptions.getEnumMember(opt));
            }
            return optList;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_STOP_OPTION_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setStopOptions(List<StopOptions> stopOptions) throws DatabaseException {
        if (stopOptions == null || stopOptions.size() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "stopOptions", stopOptions);
        }
        try {
            Enum[] soarr = stopOptions.toArray(new StopOptions[stopOptions.size()]);
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_STOP_MODE.name(), oracle.cluster.impl.util.Utils.getEnumString(soarr, String.valueOf(" "))));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_STOP_OPTION_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public int getStartConcurrency() throws DatabaseException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterResource.START_CONCURRENCY.name());
            String concurStr = attr.getValue().trim();
            return Integer.valueOf(concurStr);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int getStopConcurrency() throws DatabaseException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.ClusterResource.STOP_CONCURRENCY.name());
            String concurStr = attr.getValue().trim();
            return Integer.valueOf(concurStr);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public DBRole getDBRole() throws DatabaseException {
        try {
            String dbRole = this.m_crsResource.getAttribute(ResourceType.Database.ROLE.name()).getValue();
            if (dbRole.trim().equals("")) {
                return null;
            }
            return DBRole.getEnumMember(dbRole);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DBROLE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setDBRole(DBRole dbRole) throws DatabaseException {
        if (dbRole == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"dbRole", dbRole});
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.ROLE.name(), dbRole.toString()));
            List<Service> srvList = this.services();
            for (Service srv : srvList) {
                ((ServiceImpl)srv).handleDbChanges(this, ResourceType.Database.ROLE);
            }
        }
        catch (ServiceException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_DBROLE_FAILED, (Throwable)e, new Object[]{this.getUserAssignedName(), dbRole});
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_DBROLE_FAILED, (Throwable)e, new Object[]{this.getUserAssignedName(), dbRole});
        }
    }

    @Override
    public ManagementPolicy getMgmtPolicy() throws DatabaseException {
        try {
            String policy = this.m_crsResource.getAttribute(ResourceType.Database.MANAGEMENT_POLICY.name()).getValue();
            return ManagementPolicy.getEnumMember(policy);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_MGMT_POLICY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setMgmtPolicy(ManagementPolicy mgmtPolicy) throws DatabaseException {
        if (mgmtPolicy == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"mgmtPolicy", mgmtPolicy});
        }
        try {
            ManagementPolicy oldPolicy = this.getMgmtPolicy();
            if (mgmtPolicy == oldPolicy) {
                return;
            }
            List<DiskGroup> dglist = this.diskGroups();
            ResourceAttribute[] attrList = new ResourceAttribute[dglist.size() == 0 ? 3 : 5];
            CRSFactoryImpl crsFactoryImpl = CRSFactoryImpl.getInstance();
            attrList[0] = crsFactoryImpl.create(ResourceType.Database.MANAGEMENT_POLICY.name(), mgmtPolicy.toString());
            if (this.databaseType() == DatabaseType.RACOneNode) {
                attrList[1] = crsFactoryImpl.create(ResourceType.ClusterResource.AUTO_START.name(), CRSResource.AutoStart.RESTORE.toString());
                attrList[2] = crsFactoryImpl.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceLiterals.RESTART_ATTEMPTS_RACONE.toString());
            } else if (mgmtPolicy == ManagementPolicy.AUTOMATIC) {
                attrList[1] = crsFactoryImpl.create(ResourceType.ClusterResource.AUTO_START.name(), CRSResource.AutoStart.RESTORE.toString());
                attrList[2] = crsFactoryImpl.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceType.Database.RESTART_ATTEMPTS.toString());
            } else if (mgmtPolicy == ManagementPolicy.MANUAL) {
                attrList[1] = crsFactoryImpl.create(ResourceType.ClusterResource.AUTO_START.name(), CRSResource.AutoStart.NEVER.toString());
                attrList[2] = crsFactoryImpl.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceLiterals.MANUAL_MGMT_RA.toString());
            } else if (mgmtPolicy == ManagementPolicy.NORESTART) {
                attrList[1] = crsFactoryImpl.create(ResourceType.ClusterResource.AUTO_START.name(), CRSResource.AutoStart.NEVER.toString());
                attrList[2] = crsFactoryImpl.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceLiterals.NORESTART_MGMT_RA.toString());
            }
            if (dglist.size() != 0) {
                List<ResourceAttribute> dgAttrList = this.getDiskGroupAttrList(dglist);
                String oracleHome = this.getOracleHome();
                boolean isClusterDB = this.isClusterDatabase();
                List<AsmClusterFileSystem> acfsList = this.asmClusterFileSystems();
                ResourceAttribute[] startDep = this.createStartDepRTE(dgAttrList, acfsList, mgmtPolicy, this.databaseType(), this.isDBCentric());
                attrList[3] = startDep[0];
                attrList[4] = startDep[1];
            }
            this.m_crsResource.update(attrList);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_MGMT_POLICY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    public static String getResourceName(String dbUniqueName) {
        return DatabaseImpl.getResourceName(dbUniqueName, false);
    }

    public static String getResourceName(String dbUniqueName, boolean preserveCase) {
        return DatabaseFactory.getDatabaseResourceName(dbUniqueName, preserveCase, dbUniqueName.equals(ResourceLiterals.MGMTDB_UNIQUE_NAME.toString()));
    }

    public static String getUserAssignedName(String dbResName) throws DatabaseException {
        return DatabaseFactory.getDatabaseUniqueName(dbResName);
    }

    protected List<ResourceAttribute> getDiskGroupAttrList(List<DiskGroup> dgList) throws DatabaseException {
        if (dgList == null || dgList.isEmpty()) {
            return null;
        }
        String dgName = "";
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ArrayList<ResourceAttribute> dgAttrList = new ArrayList<ResourceAttribute>(dgList.size());
            CRSResource dgResource = null;
            for (DiskGroup dg : dgList) {
                dgName = dg.getUserAssignedName();
                dgResource = dg.crsResource();
                dgAttrList.add(crsFactory.create(ResourceType.DiskGroup.NAME.name(), dgResource.getName()));
            }
            return dgAttrList;
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DISKGROUP_FAILED, (Throwable)e, dgName, this.getUserAssignedName());
        }
        catch (ASMException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DISKGROUP_NOT_EXIST, (Throwable)e, dgName, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DISKGROUP_NOT_EXIST, (Throwable)e, dgName, this.getUserAssignedName());
        }
    }

    protected ResourceAttribute createStartDep(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, ManagementPolicy mgmtPolicy, DatabaseType dbType) throws DatabaseException {
        return this.createStartDep(dgAttrList, acfsList, null, mgmtPolicy, dbType, true);
    }

    protected ResourceAttribute createStartDep(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, ManagementPolicy mgmtPolicy, DatabaseType dbType, boolean isDBCentric) throws DatabaseException {
        return this.createStartDep(dgAttrList, acfsList, null, mgmtPolicy, dbType, isDBCentric);
    }

    protected ResourceAttribute createStartDep(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, NFS nfs, ManagementPolicy mgmtPolicy, DatabaseType dbType, boolean isDBCentric) throws DatabaseException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            if (dbType == DatabaseType.MGMTDB) {
                ResourceDependency mgmtHardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.MgmtListener.NAME.name(), ListenerImpl.getResourceName(ResourceLiterals.MGMTLSNR.toString())), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                ResourceAttribute scanlsnrTypeAttr = crsFactory.create(ResourceType.ScanListener.NAME.name(), ResourceType.ScanListener.NAME.toString());
                ResourceDependency weakDep2 = crsFactory.createResourceDependency(scanlsnrTypeAttr, ResourceDependency.DepType.WEAK_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
                ResourceDependency weakDep3 = crsFactory.createResourceDependency(crsFactory.create(ResourceType.ONS.NAME.name(), ONSImpl.getResourceName()), ResourceDependency.DepType.WEAK_DEP, ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP);
                ResourceDependency mgmtPullup = crsFactory.createResourceDependency(crsFactory.create(ResourceType.MgmtListener.NAME.name(), ListenerImpl.getResourceName(ResourceLiterals.MGMTLSNR.toString())), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
                Trace.out("Mgmt database pullDep = " + ResourceDependency.toString(mgmtPullup));
                Trace.out("start dependencies of management database = " + ResourceDependency.toString(mgmtHardDep, weakDep2, weakDep3, mgmtPullup));
                return crsFactory.create(ResourceType.MgmtDatabase.START_DEPENDENCIES.name(), ResourceDependency.toString(mgmtHardDep, weakDep2, weakDep3, mgmtPullup));
            }
            ResourceAttribute lsnrTypeAttr = crsFactory.create(ResourceType.Listener.NAME.name(), ResourceType.Listener.NAME.toString());
            ResourceDependency weakDep1 = crsFactory.createResourceDependency(lsnrTypeAttr, ResourceDependency.DepType.WEAK_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP);
            ResourceAttribute scanlsnrTypeAttr = crsFactory.create(ResourceType.ScanListener.NAME.name(), ResourceType.ScanListener.NAME.toString());
            ResourceDependency weakDep2 = crsFactory.createResourceDependency(scanlsnrTypeAttr, ResourceDependency.DepType.WEAK_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
            ResourceDependency weakDep3 = crsFactory.createResourceDependency(crsFactory.create(ResourceType.ONS.NAME.name(), ONSImpl.getResourceName()), ResourceDependency.DepType.WEAK_DEP, ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP);
            ResourceDependency weakDep4 = crsFactory.createResourceDependency(crsFactory.create(ResourceType.GNS.NAME.name(), GNSImpl.getResourceName()), ResourceDependency.DepType.WEAK_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
            ResourceAttribute dbTypeAttr = dbType == DatabaseType.RACOneNode && !isDBCentric ? crsFactory.create(ResourceType.Database.NAME.name(), ResourceType.Database.NAME.toString()) : null;
            Trace.out("Check for DBCentric and racone");
            ResourceDependency dbTypeDisperseDep = dbType == DatabaseType.RACOneNode && !isDBCentric ? crsFactory.createResourceDependency(dbTypeAttr, ResourceDependency.DepType.DISPERSION_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP) : null;
            ResourceDependency ofsHardDep = null;
            ResourceDependency acfsPullup = null;
            if (acfsList != null && acfsList.size() > 0 && !ASMFactory.isClientMode()) {
                StringBuilder acfsSB = null;
                for (AsmClusterFileSystem acfs : acfsList) {
                    if (acfsSB != null) {
                        acfsSB.append("," + acfs.getName());
                        continue;
                    }
                    acfsSB = new StringBuilder(acfs.getName());
                }
                ofsHardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), acfsSB.toString()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                Trace.out("ofsHardDep = " + ResourceDependency.toString(ofsHardDep));
                acfsPullup = crsFactory.createResourceDependency(crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), acfsSB.toString()), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
                Trace.out("ACFS pullDep = " + ResourceDependency.toString(acfsPullup));
            }
            ResourceDependency nfsPullup = null;
            if (nfs != null) {
                ofsHardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.MountFS.NAME.name(), nfs.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                Trace.out("ofsHardDep = " + ResourceDependency.toString(ofsHardDep));
                nfsPullup = crsFactory.createResourceDependency(crsFactory.create(ResourceType.MountFS.NAME.name(), nfs.getName()), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
                Trace.out("NFS pullDep = " + ResourceDependency.toString(nfsPullup));
            }
            if (dgAttrList != null && dgAttrList.size() > 0 && !ASMFactory.isClientMode()) {
                StringBuilder diskgroupSB = null;
                for (ResourceAttribute ra : dgAttrList) {
                    if (diskgroupSB != null) {
                        diskgroupSB.append("," + ra.getValue());
                        continue;
                    }
                    diskgroupSB = new StringBuilder(ra.getValue());
                }
                boolean isCluster = Cluster.isCluster();
                ASMMode asmm = null;
                try {
                    asmm = isCluster ? ASMFactoryImpl.getInstance().getASMMode() : null;
                }
                catch (ASMException ae) {
                    throw new DatabaseException(ae);
                }
                catch (SoftwareModuleException se) {
                    throw new DatabaseException(se);
                }
                ArrayList<ResourceDependency> hardDep = new ArrayList<ResourceDependency>();
                if (asmm == ASMMode.NONE) {
                    Trace.out("Diskgroup - " + diskgroupSB.toString() + ", m_name=" + this.m_name);
                    throw new DatabaseException((MessageKey)PrCdMsgID.CLIENT_CLUSTER_NO_DEP_ON_DG, diskgroupSB.toString(), this.m_name);
                }
                if (asmm == ASMMode.REMOTE) {
                    for (ResourceAttribute ra : dgAttrList) {
                        hardDep.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.DiskGroup.NAME.name(), ra.getValue()), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP, ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP));
                    }
                } else if (asmm == ASMMode.CLIENT) {
                    Trace.out("No DG res dependency on ASM Client cluster");
                } else {
                    hardDep.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.DiskGroup.NAME.name(), diskgroupSB.toString()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]));
                }
                ArrayList<ResourceDependency> startDep = new ArrayList<ResourceDependency>();
                startDep.addAll(hardDep);
                if (mgmtPolicy == ManagementPolicy.MANUAL || mgmtPolicy == ManagementPolicy.NORESTART) {
                    if (dbType == DatabaseType.RAC || dbType == DatabaseType.RACOneNode) {
                        startDep.addAll(Arrays.asList(weakDep1, weakDep2, weakDep3, weakDep4));
                        if (dbType == DatabaseType.RACOneNode && !isDBCentric) {
                            startDep.add(dbTypeDisperseDep);
                        }
                        if (ofsHardDep == null) {
                            Trace.out("start dependencies with diskgroup for either RAC or RACOneNode database with manual policy = " + ResourceDependency.toString(startDep));
                        } else {
                            startDep.addAll(Arrays.asList(ofsHardDep, acfsPullup, nfsPullup));
                            Trace.out("start dependencies with diskgroup for either RAC or RACOneNode database with ofs with manual policy = " + ResourceDependency.toString(startDep));
                        }
                    } else {
                        startDep.addAll(Arrays.asList(weakDep1, weakDep3));
                        if (ofsHardDep == null) {
                            Trace.out("start dependencies with diskgroup for single instance database with manual policy = " + ResourceDependency.toString(startDep));
                        } else {
                            startDep.addAll(Arrays.asList(ofsHardDep, acfsPullup, nfsPullup));
                            Trace.out("start dependencies with diskgroup for single instance database with ofs with manual policy = " + ResourceDependency.toString(startDep));
                        }
                    }
                    return crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(startDep));
                }
                ArrayList<ResourceDependency> pullDep = new ArrayList<ResourceDependency>();
                if (asmm == ASMMode.NONE) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.CLIENT_CLUSTER_NO_DEP_ON_DG, diskgroupSB);
                }
                if (asmm == ASMMode.REMOTE) {
                    for (ResourceAttribute ra : dgAttrList) {
                        pullDep.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.DiskGroup.NAME.name(), ra.getValue()), ResourceDependency.DepType.PULLUP_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP));
                    }
                } else if (asmm == ASMMode.CLIENT) {
                    Trace.out("No DG res dependency on ASM Client cluster");
                } else {
                    pullDep.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.DiskGroup.NAME.name(), diskgroupSB.toString()), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]));
                }
                startDep.addAll(pullDep);
                if (dbType == DatabaseType.RAC || dbType == DatabaseType.RACOneNode) {
                    startDep.addAll(Arrays.asList(weakDep1, weakDep2, weakDep3, weakDep4));
                    if (dbType == DatabaseType.RACOneNode && !isDBCentric) {
                        startDep.add(dbTypeDisperseDep);
                    }
                    if (ofsHardDep == null) {
                        Trace.out("start dependencies with diskgroup for cluster database = " + ResourceDependency.toString(startDep));
                    } else {
                        startDep.addAll(Arrays.asList(ofsHardDep, acfsPullup, nfsPullup));
                        Trace.out("start dependencies with diskgroup for cluster database with ofs = " + ResourceDependency.toString(startDep));
                    }
                } else {
                    startDep.addAll(Arrays.asList(weakDep1, weakDep3));
                    if (ofsHardDep == null) {
                        Trace.out("start dependencies with diskgroup for single instance database = " + ResourceDependency.toString(startDep));
                    } else {
                        startDep.addAll(Arrays.asList(ofsHardDep, acfsPullup, nfsPullup));
                        Trace.out("start dependencies with diskgroup for single instance database with ofs = " + ResourceDependency.toString(startDep));
                    }
                }
                return crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(startDep));
            }
            if (dbType == DatabaseType.RAC || dbType == DatabaseType.RACOneNode) {
                if (ofsHardDep == null) {
                    Trace.out("start dependencies with no diskgroup for cluster database = " + ResourceDependency.toString(weakDep1, weakDep2, weakDep3, weakDep4));
                    return crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), dbType == DatabaseType.RACOneNode && !isDBCentric ? ResourceDependency.toString(dbTypeDisperseDep, weakDep1, weakDep2, weakDep3, weakDep4) : ResourceDependency.toString(weakDep1, weakDep2, weakDep3, weakDep4));
                }
                Trace.out("start dependencies with no diskgroup for cluster database with ofs = " + ResourceDependency.toString(ofsHardDep, weakDep1, weakDep2, weakDep3, weakDep4));
                return crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), dbType == DatabaseType.RACOneNode && !isDBCentric ? ResourceDependency.toString(ofsHardDep, dbTypeDisperseDep, weakDep1, weakDep2, weakDep3, weakDep4, acfsPullup, nfsPullup) : ResourceDependency.toString(ofsHardDep, weakDep1, weakDep2, weakDep3, weakDep4, acfsPullup, nfsPullup));
            }
            if (ofsHardDep == null) {
                Trace.out("start dependencies with no diskgroup for single instance database = " + ResourceDependency.toString(weakDep1, weakDep3));
                return crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(weakDep1, weakDep3));
            }
            Trace.out("start dependencies with no diskgroup for single instance database with ofs = " + ResourceDependency.toString(ofsHardDep, weakDep1, weakDep3, acfsPullup, nfsPullup));
            return crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(ofsHardDep, weakDep1, weakDep3, acfsPullup, nfsPullup));
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
        catch (ASMException e) {
            throw new DatabaseException(e);
        }
    }

    protected ResourceAttribute[] createStartDepRTE(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, ManagementPolicy mgmtPolicy, DatabaseType dbType) throws DatabaseException {
        return this.createStartDepRTE(dgAttrList, acfsList, null, mgmtPolicy, dbType, true);
    }

    protected ResourceAttribute[] createStartDepRTE(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, ManagementPolicy mgmtPolicy, DatabaseType dbType, boolean isDBCentric) throws DatabaseException {
        return this.createStartDepRTE(dgAttrList, acfsList, null, mgmtPolicy, dbType, isDBCentric);
    }

    protected ResourceAttribute[] createStartDepRTE(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, NFS nfs, ManagementPolicy mgmtPolicy, DatabaseType dbType, boolean isDBCentric) throws DatabaseException {
        return this.createStartDepRTE(dgAttrList, acfsList, nfs, mgmtPolicy, dbType, null, isDBCentric);
    }

    protected ResourceAttribute[] createStartDepRTE(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, NFS nfs, ManagementPolicy mgmtPolicy, DatabaseType dbType, String oracleHome, boolean isDBCentric) throws DatabaseException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            if (dbType == DatabaseType.MGMTDB) {
                HashMap<String, RTEArg> argMap = new HashMap<String, RTEArg>();
                HashMap<String, String> condMap = new HashMap<String, String>();
                try {
                    String template = ResourceType.MgmtDatabase.START_DEPENDENCIES_TEMPLATE.toString();
                    RTENativeResult result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template, argMap, null, condMap, this.m_nameAttr.getValue());
                    String dep = result.getAttrValue();
                    String depHint = result.getAttrValueHint();
                    Trace.out("start dependencies of management database = " + dep);
                    return new ResourceAttribute[]{crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), dep), crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), depHint)};
                }
                catch (CRSException e) {
                    throw new DatabaseException(e);
                }
            }
            HashMap<String, RTEArg> argMap = new HashMap<String, RTEArg>();
            HashMap<String, String> condMap = new HashMap<String, String>();
            boolean isCluster = Cluster.isCluster();
            ASMMode asmm = null;
            try {
                asmm = isCluster ? ASMFactoryImpl.getInstance().getASMMode() : ASMMode.NONE;
            }
            catch (ASMException ae) {
                throw new DatabaseException(ae);
            }
            catch (SoftwareModuleException se) {
                throw new DatabaseException(se);
            }
            boolean isClientMode = isCluster ? asmm == ASMMode.CLIENT : false;
            Trace.out("asm mode = " + asmm.toString());
            StringBuilder acfsSB = null;
            for (AsmClusterFileSystem acfs : acfsList) {
                if (acfsSB != null) {
                    acfsSB.append("," + acfs.getName());
                    continue;
                }
                acfsSB = new StringBuilder(acfs.getName());
            }
            String acfsString = null != acfsSB ? acfsSB.toString() : "";
            String nfsString = null != nfs ? nfs.getName() : "";
            String acfs_and_nfs = "";
            if (!isClientMode && null != acfsList) {
                acfs_and_nfs = acfs_and_nfs + acfsString;
            }
            if (!acfs_and_nfs.equals("")) {
                acfs_and_nfs = acfs_and_nfs + ",";
            }
            acfs_and_nfs = acfs_and_nfs + nfsString;
            String acfs_or_nfs = "";
            if (!isClientMode && null != acfsList) {
                acfs_or_nfs = acfsString;
            }
            if (null != nfs) {
                acfs_or_nfs = nfsString;
            }
            StringBuilder diskgroupSB = null;
            if (null != dgAttrList) {
                for (ResourceAttribute ra : dgAttrList) {
                    if (diskgroupSB != null) {
                        diskgroupSB.append("," + ra.getValue());
                        continue;
                    }
                    diskgroupSB = new StringBuilder(ra.getValue());
                }
            }
            String dg = diskgroupSB != null && asmm != ASMMode.CLIENT ? diskgroupSB.toString() : "";
            String ohResName = "";
            boolean isHomeResourceRegistered = false;
            Trace.out("Oracle home: " + (oracleHome == null ? "null" : oracleHome));
            if (oracleHome != null) {
                try {
                    Trace.out("Checking for Oracle home resource existance for path " + oracleHome);
                    OracleHome oh = HomeFactory.getInstance().getOracleHomeByPath(oracleHome);
                    ohResName = oh.getName();
                    isHomeResourceRegistered = true;
                }
                catch (NotExistsException nee) {
                    Trace.out("No Oracle home resource for ORACLE_HOME " + oracleHome + ", do not create dependencies");
                }
                catch (HomeException he) {
                    throw new DatabaseException(he);
                }
            }
            try {
                argMap.put("acfs_and_nfs", new RTEArg("acfs_and_nfs", RTEArg.RTEArgType.ResList, acfs_and_nfs));
                argMap.put("acfs_or_nfs", new RTEArg("acfs_or_nfs", RTEArg.RTEArgType.ResList, acfs_or_nfs));
                argMap.put("oraclehome", new RTEArg("oraclehome", RTEArg.RTEArgType.Res, ohResName));
                argMap.put("dg", new RTEArg("dg", RTEArg.RTEArgType.ResList, dg));
            }
            catch (RTENativeException e) {
                throw new DatabaseException(e);
            }
            condMap.put("ASMClientMode", isClientMode ? "True" : "False");
            if (isCluster) {
                condMap.put("ASMmode", asmm.toString());
            } else {
                condMap.put("ASMmode", ASMMode.NONE.toString());
            }
            condMap.put("DATABASE_TYPE", dbType.toString());
            condMap.put("DB_CENTRIC", isDBCentric ? "True" : "False");
            condMap.put("MANAGEMENT_POLICY", mgmtPolicy.toString());
            condMap.put("OHResExist", isHomeResourceRegistered ? "True" : "False");
            try {
                String template = ResourceType.Database.START_DEPENDENCIES_TEMPLATE.toString();
                RTENativeResult result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template, argMap, null, condMap, this.m_nameAttr.getValue());
                String dep = result.getAttrValue();
                String depHint = result.getAttrValueHint();
                return new ResourceAttribute[]{crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), dep), crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name(), depHint)};
            }
            catch (CRSException e) {
                throw new DatabaseException(e);
            }
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    protected ResourceAttribute createStopDep(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, String oracleHome) throws CRSException, DatabaseException {
        return this.createStopDep(dgAttrList, acfsList, null, oracleHome, null);
    }

    protected ResourceAttribute createStopDep(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, NFS nfs, String oracleHome, DatabaseType dbType) throws CRSException, DatabaseException {
        Trace.out("creating stop dependencies");
        if (dbType != null && dbType == DatabaseType.MGMTDB) {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceDependency mgmtHardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.MgmtListener.NAME.name(), ListenerImpl.getResourceName(ResourceLiterals.MGMTLSNR.toString())), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            Trace.out("mgmtdb stop dependencies = " + mgmtHardDep);
            return crsFactory.create(ResourceType.MgmtDatabase.STOP_DEPENDENCIES.name(), ResourceDependency.toString(mgmtHardDep));
        }
        boolean isClientMode = false;
        try {
            isClientMode = ASMFactory.isClientMode();
        }
        catch (ASMException e) {
            throw new DatabaseException(e);
        }
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        ResourceDependency[] acfsHardDep = null;
        if (acfsList != null && acfsList.size() > 0 && !isClientMode) {
            String oHome = oracleHome;
            if (oHome == null) {
                oHome = this.getOracleHome();
            }
            Trace.out("oracle Home = " + oracleHome);
            AsmClusterFileSystem acfsOH = null;
            if (Cluster.isCluster()) {
                acfsOH = this.getACFS(oHome, oHome, true);
            }
            int acfsIndex = 0;
            acfsHardDep = new ResourceDependency[acfsList.size()];
            for (AsmClusterFileSystem acfs : acfsList) {
                if (acfsOH != null && acfs.equals(acfsOH)) {
                    acfsHardDep[acfsIndex++] = crsFactory.createResourceDependency(crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), acfs.getName()), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                    continue;
                }
                acfsHardDep[acfsIndex++] = crsFactory.createResourceDependency(crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), acfs.getName()), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            }
            Trace.out("acfsHardDep = " + ResourceDependency.toString(acfsHardDep));
        }
        ResourceDependency nfsHardDep = null;
        if (nfs != null) {
            nfsHardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.MountFS.NAME.name(), nfs.getName()), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            Trace.out("nfsHardDep = " + ResourceDependency.toString(nfsHardDep));
        }
        boolean isCluster = Cluster.isCluster();
        ASMMode asmm = null;
        try {
            asmm = isCluster ? ASMFactoryImpl.getInstance().getASMMode() : null;
        }
        catch (ASMException ae) {
            throw new DatabaseException(ae);
        }
        catch (SoftwareModuleException se) {
            throw new DatabaseException(se);
        }
        String stopDepValue = "";
        if (dgAttrList != null && dgAttrList.size() > 0 && !isClientMode) {
            ArrayList<ResourceDependency> harddep = new ArrayList<ResourceDependency>(dgAttrList.size() + 1 + (acfsHardDep == null ? 0 : acfsHardDep.length));
            if (asmm == ASMMode.REMOTE) {
                harddep.add(crsFactory.createResourceDependency(crsFactory.create(ResourceLiterals.NAME.toString(), ASMImpl.getResourceName()), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP));
            } else if (asmm == ASMMode.CLIENT) {
                Trace.out("No DG res dependency on ASM Client cluster");
            } else {
                harddep.add(crsFactory.createResourceDependency(crsFactory.create(ResourceType.LocalASM.NAME.name(), ASMImpl.getResourceName()), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP));
            }
            for (ResourceAttribute ra : dgAttrList) {
                if (asmm == ASMMode.NONE) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.CLIENT_CLUSTER_NO_DEP_ON_DG, ra.getName(), this.m_name);
                }
                if (asmm == ASMMode.REMOTE) {
                    harddep.add(crsFactory.createResourceDependency(ra, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.SHUTDOWN_MODIFIER_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP));
                    continue;
                }
                if (asmm == ASMMode.CLIENT) {
                    Trace.out("No DG res dependency on ASM Client cluster");
                    continue;
                }
                harddep.add(crsFactory.createResourceDependency(ra, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.SHUTDOWN_MODIFIER_DEP));
            }
            if (acfsHardDep != null) {
                harddep.addAll(Arrays.asList(acfsHardDep));
            }
            if (harddep != null) {
                stopDepValue = ResourceDependency.toString(harddep.toArray(new ResourceDependency[harddep.size()]));
            }
        } else if (acfsHardDep != null) {
            stopDepValue = ResourceDependency.toString(acfsHardDep);
        } else if (nfsHardDep != null) {
            stopDepValue = ResourceDependency.toString(nfsHardDep);
        }
        Trace.out("stop dependencies = " + stopDepValue);
        return crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), stopDepValue);
    }

    protected ResourceAttribute[] createStopDepRTE(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, String oracleHome) throws CRSException, DatabaseException {
        return this.createStopDepRTE(dgAttrList, acfsList, null, oracleHome, null);
    }

    protected ResourceAttribute[] createStopDepRTE(List<ResourceAttribute> dgAttrList, List<AsmClusterFileSystem> acfsList, NFS nfs, String oracleHome, DatabaseType dbType) throws CRSException, DatabaseException {
        Trace.out("creating stop dependencies");
        if (dbType != null && dbType == DatabaseType.MGMTDB) {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            HashMap<String, RTEArg> argMap = new HashMap<String, RTEArg>();
            HashMap<String, String> condMap = new HashMap<String, String>();
            String template = ResourceType.MgmtDatabase.STOP_DEPENDENCIES_TEMPLATE.toString();
            try {
                RTENativeResult result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template, argMap, null, condMap, this.m_nameAttr.getValue());
                String dep = result.getAttrValue();
                String depHint = result.getAttrValueHint();
                return new ResourceAttribute[]{crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), dep), crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES_RTE_INTERNAL.name(), depHint)};
            }
            catch (CRSException e) {
                throw new DatabaseException(e);
            }
        }
        ASMMode asmm = null;
        boolean isCluster = Cluster.isCluster();
        try {
            asmm = isCluster ? ASMFactoryImpl.getInstance().getASMMode() : null;
        }
        catch (ASMException ae) {
            throw new DatabaseException(ae);
        }
        catch (SoftwareModuleException se) {
            throw new DatabaseException(se);
        }
        boolean isClientMode = isCluster ? asmm == ASMMode.CLIENT : false;
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        HashMap<String, RTEArg> argMap = new HashMap<String, RTEArg>();
        HashMap<String, String> condMap = new HashMap<String, String>();
        String template = ResourceType.Database.STOP_DEPENDENCIES_TEMPLATE.toString();
        boolean dgExist = null != dgAttrList && dgAttrList.size() > 0;
        condMap.put("ASMClientMode", isClientMode ? "True" : "False");
        if (isCluster) {
            condMap.put("ASMmode", asmm.toString());
        } else {
            condMap.put("ASMmode", ASMMode.NONE.toString());
        }
        condMap.put("DGExist", dgExist ? "True" : "False");
        String acfsString = "";
        String acfsOHString = "";
        if (acfsList != null && acfsList.size() > 0 && !isClientMode) {
            AsmClusterFileSystem acfsOH = null;
            if (Cluster.isCluster()) {
                String oHome = oracleHome;
                if (oHome == null) {
                    oHome = this.getOracleHome();
                }
                Trace.out("oracle Home = " + oracleHome);
                acfsOH = this.getACFS(oHome, oHome, true);
            }
            StringBuilder acfsSB = null;
            for (AsmClusterFileSystem acfs : acfsList) {
                if (acfsOH != null && acfs.equals(acfsOH)) {
                    acfsOHString = acfs.getName();
                    continue;
                }
                if (null == acfsSB) {
                    acfsSB = new StringBuilder(acfs.getName());
                    continue;
                }
                acfsSB.append("," + acfs.getName());
            }
            acfsString = null != acfsSB ? acfsSB.toString() : "";
        }
        String nfsString = null != nfs ? nfs.getName() : "";
        StringBuilder diskgroupSB = null;
        if (dgExist) {
            for (ResourceAttribute ra : dgAttrList) {
                if (asmm == ASMMode.NONE) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.CLIENT_CLUSTER_NO_DEP_ON_DG, ra.getName(), this.m_name);
                }
                if (null == diskgroupSB) {
                    diskgroupSB = new StringBuilder(ra.getValue());
                    continue;
                }
                diskgroupSB.append("," + ra.getValue());
            }
        }
        String dg = null != diskgroupSB ? diskgroupSB.toString() : "";
        String ohResName = "";
        boolean isHomeResourceRegistered = false;
        try {
            if (oracleHome != null && !oracleHome.isEmpty()) {
                Trace.out("Checking for Oracle home resource existance for path " + oracleHome);
                OracleHome oh = HomeFactory.getInstance().getOracleHomeByPath(oracleHome);
                ohResName = oh.getName();
                isHomeResourceRegistered = true;
            }
        }
        catch (NotExistsException nee) {
            Trace.out("No Oracle home resource for ORACLE_HOME " + oracleHome + ", do not create dependencies");
        }
        catch (HomeException he) {
            throw new DatabaseException(he);
        }
        condMap.put("OHResExist", isHomeResourceRegistered ? "True" : "False");
        try {
            argMap.put("acfs", new RTEArg("acfs", RTEArg.RTEArgType.ResList, acfsString));
            argMap.put("acfs_same_as_oh", new RTEArg("acfs_same_as_oh", RTEArg.RTEArgType.Res, acfsOHString));
            argMap.put("nfs", new RTEArg("nfs", RTEArg.RTEArgType.Res, nfsString));
            argMap.put("dg", new RTEArg("dg", RTEArg.RTEArgType.ResList, dg));
            argMap.put("oraclehome", new RTEArg("oraclehome", RTEArg.RTEArgType.Res, ohResName));
        }
        catch (RTENativeException e) {
            throw new DatabaseException(e);
        }
        try {
            RTENativeResult result = CRSFactoryImpl.getInstance().rteEvalAttrValue(template, argMap, null, condMap, this.m_nameAttr.getValue());
            String dep = result.getAttrValue();
            String depHint = result.getAttrValueHint();
            return new ResourceAttribute[]{crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), dep), crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES_RTE_INTERNAL.name(), depHint)};
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    static String getServerGroupString(List<ServerGroup> sgList, String separator, boolean userAssigned) {
        String sb = null;
        try {
            ServerFactoryImpl sf = ServerFactoryImpl.getInstance();
            sb = sf.getServerGrpString(sgList, separator, userAssigned);
        }
        catch (ServerException e) {
            Trace.out("Get ServerException " + e.getMessage());
        }
        return sb;
    }

    public static void validateName(String name, boolean isInstance) throws DatabaseException {
        if (name == null || name.trim().length() == 0) {
            throw new DatabaseException((MessageKey)(isInstance ? PrCdMsgID.NULL_INSTANCE_NAME : PrCdMsgID.NULL_DB_NAME), new Object[0]);
        }
        char c0 = name.charAt(0);
        if (!isInstance) {
            if (!Character.isLetter(c0) || !name.matches("[a-zA-Z0-9$#_]*")) {
                throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_DB_NAME, name);
            }
        } else if (c0 == '_' || c0 == '-' || !name.matches("[a-zA-Z0-9_-]*")) {
            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_INSTANCE_NAME, name);
        }
    }

    Filter getStopFilter(List<Node> nodeList) throws CRSException, NodeException {
        String startsWith = this.getStartsWith();
        String endsWith = '.' + ResourceLiterals.SVC.toString();
        Filter stopServices = FilterFactoryImpl.getFilter2StopResources(ResourceType.Service.NAME.toString(), startsWith, endsWith);
        Trace.out("stop services filter: " + stopServices.toString());
        Filter dbFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceType.Database.NAME.name(), this.getName());
        Filter dbType = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
        Filter stateNotOfflineFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.NOT_EQ, ResourceLiterals.STATE_ATTR_NAME.toString(), "OFFLINE".toString());
        Filter targetNotOfflineFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.NOT_EQ, ResourceLiterals.TARGET_ATTR_NAME.toString(), "OFFLINE".toString());
        Filter targetStateFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.OR, stateNotOfflineFilter, targetNotOfflineFilter);
        dbFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, dbFilter, dbType);
        dbFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, dbFilter, targetStateFilter);
        Filter theFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.OR, stopServices, dbFilter);
        if (nodeList != null && nodeList.size() > 0) {
            Filter nodeFilter = null;
            Filter wrkFilter = null;
            for (Node node : nodeList) {
                wrkFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.CRS_LAST_SERVER.toString(), node.getName());
                nodeFilter = nodeFilter == null ? wrkFilter : FilterFactoryImpl.getExpressionFilter(Filter.Operator.OR, nodeFilter, wrkFilter);
            }
            theFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, theFilter, nodeFilter);
        }
        return theFilter;
    }

    protected List<String> getServices(ManagementPolicy mgmtPolicy) throws ServiceException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter svcFilter = DBFilterFactory.getServices4DB(this.getName());
            String attrName = ResourceType.Service.MANAGEMENT_POLICY.name();
            Map<String, Map<String, String>> resultData = crsFactory.searchEntities(CRSEntity.Type.Resource, false, svcFilter, attrName);
            String refPolicy = mgmtPolicy.toString();
            ArrayList<String> svcList = new ArrayList<String>();
            for (String riID : resultData.keySet()) {
                Map<String, String> valueMap = resultData.get(riID);
                if (!refPolicy.equalsIgnoreCase(valueMap.get(attrName))) continue;
                svcList.add(riID);
            }
            Trace.out("svcList=" + ((Object)svcList).toString());
            return svcList;
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e);
        }
    }

    private String getStartsWith() {
        String myName = this.getName();
        int len = myName.length() - ResourceLiterals.DB.toString().length();
        myName = myName.substring(0, len);
        return myName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DatabaseImpl)) {
            return false;
        }
        DatabaseImpl other = (DatabaseImpl)obj;
        return this.m_name != null && this.m_name.equalsIgnoreCase(other.m_name);
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : super.hashCode();
    }

    static void assertOracleHome(String oHome) throws DatabaseException {
        if (oHome == null || oHome.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oHome");
        }
        File f = new File(oHome);
        if (!f.exists()) {
            throw new DatabaseException((MessageKey)PrCcMsgID.PATH_NOT_EXISTS, oHome);
        }
        if (!f.isDirectory()) {
            throw new DatabaseException((MessageKey)PrCcMsgID.PATH_IS_NOT_DIR, oHome);
        }
    }

    @Override
    public Database upgrade(String oHome) throws DatabaseException, AlreadyUpgradedException, CompositeOperationException {
        DatabaseImpl.assertOracleHome(oHome);
        Version swVersion = new Version();
        Trace.out("software version = " + swVersion);
        try {
            DatabaseType dbType;
            ArrayList<ResourceAttribute> ral;
            Common.versionCheck(oHome, swVersion);
            Version resVersion = this.version();
            Trace.out("attr version = " + resVersion.toString());
            if (swVersion.equals(resVersion)) {
                throw new AlreadyUpgradedException((MessageKey)PrCdMsgID.DATABASE_UPGRADED, this.getUserAssignedName(), swVersion.toString());
            }
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Database.ORACLE_HOME.name());
            String oldOracleHome = attr.getValue().trim();
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ResourceAttribute acl = null;
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                acl = this.getACLAttr(oHome, swVersion);
                ral = new ArrayList(5);
                ral.add(acl);
            } else {
                ral = new ArrayList<ResourceAttribute>(4);
            }
            ral.add(cf.create(ResourceType.Database.ORACLE_HOME.name(), oHome));
            if (resVersion.equals(Version.get11201Version())) {
                dbType = this.isClusterDatabase() ? DatabaseType.RAC : DatabaseType.SIDB;
                ral.add(cf.create(ResourceType.Database.DATABASE_TYPE.name(), dbType.toString()));
            } else {
                dbType = this.databaseType();
            }
            ral.add(cf.create(ResourceType.Database.DEFAULT_TEMPLATE.name(), DatabaseImpl.getEvtTemplate(swVersion)));
            ral.add(cf.create(ResourceType.LocalResource.VERSION.name(), swVersion.toString()));
            List<DiskGroup> dglist = this.diskGroups();
            List<ResourceAttribute> dgAttrList = this.getDiskGroupAttrList(dglist);
            List<AsmClusterFileSystem> acfsList = this.asmClusterFileSystems();
            AsmClusterFileSystem acfs = null;
            if (Cluster.isCluster()) {
                acfs = this.getACFS(oHome, oHome, true);
            }
            if (acfs != null && !acfsList.contains(acfs)) {
                Trace.out("Adding oracle home ACFS resource " + acfs.getName() + " to ACFS list");
                acfsList.add(acfs);
            }
            ral.addAll(Arrays.asList(this.createStartDepRTE(dgAttrList, acfsList, this.getMgmtPolicy(), dbType)));
            ral.addAll(Arrays.asList(this.createStopDepRTE(dgAttrList, acfsList, oHome)));
            if (dbType == DatabaseType.RACOneNode) {
                ral.add(cf.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceLiterals.RESTART_ATTEMPTS_RACONE.toString()));
            }
            if (Version.isPre12102(resVersion)) {
                ral.add(cf.create(ResourceType.Database.ACTION_TIMEOUT.name(), ResourceType.Database.ACTION_TIMEOUT.toString()));
                ral.add(cf.create(ResourceType.Database.ACTION_START_OPTION.name(), ResourceType.Database.ACTION_START_OPTION.toString()));
            }
            ral.add(cf.create(ResourceType.Database.ACTIONS.name(), Common.createActionsAttr(acl != null ? acl.getValue() : null, ResourceType.Database.NAME.toString(), this.m_nameAttr.getValue())));
            ral.add(cf.create(ResourceType.Database.CSS_CRITICAL.name(), ResourceType.Database.CSS_CRITICAL.toString()));
            ral.add(cf.create(ResourceType.Database.WORKLOAD_CPU.name(), ResourceType.Database.WORKLOAD_CPU.toString()));
            ral.add(cf.create(ResourceType.Database.WORKLOAD_MEMORY_TARGET.name(), ResourceType.Database.WORKLOAD_MEMORY_TARGET.toString()));
            ral.add(cf.create(ResourceType.Database.WORKLOAD_MEMORY_MAX.name(), ResourceType.Database.WORKLOAD_MEMORY_MAX.toString()));
            ral.add(cf.create(ResourceType.Database.WORKLOAD_CPU_CAP.name(), ResourceType.Database.WORKLOAD_CPU_CAP.toString()));
            ral.add(cf.create(ResourceType.Database.JAVA_SERVICES.name(), ResourceType.Database.JAVA_SERVICES.toString()));
            ral.add(cf.create(ResourceType.Database.PATCH_IN_PROGRESS.name(), ResourceType.Database.PATCH_IN_PROGRESS.toString()));
            this.m_crsResource.update(ral.toArray(new ResourceAttribute[ral.size()]));
            List<Service> svclist = this.services(false, false, true, null);
            if (svclist.size() > 0) {
                boolean gotResult = true;
                HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(svclist.size());
                StringBuilder sb = null;
                ResourceAttribute svcTypeAttr = cf.create(ResourceType.Service.NAME.name(), ResourceType.Service.NAME.toString());
                List<ResourceAttribute> svcResAttrs = cf.getResourceTypeEntity(svcTypeAttr).getAttributes(new String[0]);
                svcResAttrs = ResourceType.getProfile(svcResAttrs);
                for (Service elem : svclist) {
                    ServiceImpl svc = (ServiceImpl)elem;
                    Trace.out((Object)"creating new attribute values for service %s ...", svc.getName());
                    ArrayList<ResourceAttribute> ra = new ArrayList<ResourceAttribute>();
                    ra.add(cf.create(ResourceType.LocalResource.VERSION.name(), swVersion.toString()));
                    if (new SystemFactory().CreateSystem().isUnixSystem()) {
                        ra.add(acl);
                    }
                    ManageableEntityException excp = null;
                    try {
                        CRSResourceImpl svcCRSResource = (CRSResourceImpl)svc.crsResource();
                        for (ResourceAttribute svcAttr : svcResAttrs) {
                            String attrName = svcAttr.getName();
                            Trace.out("processing attribute %s with current value %s ...", attrName, svcAttr.getValue());
                            if (attrName.equalsIgnoreCase(ResourceLiterals.FAILOVER_DELAY.toString())) {
                                String failoverDelay = svcCRSResource.getAttribute(ResourceLiterals.FAILOVER_DELAY.toString()).getValue();
                                if (failoverDelay.equals(String.valueOf(0))) continue;
                                ra.add(cf.create(ResourceLiterals.TAF_FAILOVER_DELAY.toString(), failoverDelay));
                                continue;
                            }
                            if (attrName.equalsIgnoreCase(ResourceType.Service.RELOCATE_KIND.name())) {
                                ra.add(cf.create(ResourceType.Service.RELOCATE_KIND.name(), ResourceLiterals.RELOCATE_KIND_ONLINE.toString()));
                                continue;
                            }
                            if (attrName.equalsIgnoreCase(ResourceType.Service.FAILOVER_RESTORE.name())) {
                                ra.add(cf.create(ResourceType.Service.FAILOVER_RESTORE.name(), FailoverRestore.NONE.toString()));
                                continue;
                            }
                            if (attrName.equalsIgnoreCase(ResourceType.Service.CSS_CRITICAL.name())) {
                                ra.add(cf.create(ResourceType.Service.CSS_CRITICAL.name(), ResourceType.Service.CSS_CRITICAL.toString()));
                                continue;
                            }
                            if (attrName.equalsIgnoreCase(ResourceType.Service.ACTIONS.name())) {
                                ra.add(cf.create(ResourceType.Service.ACTIONS.name(), Common.createActionsAttr(acl != null ? acl.getValue() : null, ResourceType.Service.NAME.toString(), svc.getName())));
                                continue;
                            }
                            if (attrName.equalsIgnoreCase(ResourceType.Service.START_DEPENDENCIES_TEMPLATE.name())) {
                                ra.add(cf.create(ResourceType.Service.START_DEPENDENCIES_TEMPLATE.name(), ResourceType.Service.START_DEPENDENCIES_TEMPLATE.toString()));
                                continue;
                            }
                            if (attrName.equalsIgnoreCase(ResourceType.Service.STOP_DEPENDENCIES_TEMPLATE.name())) {
                                ra.add(cf.create(ResourceType.Service.STOP_DEPENDENCIES_TEMPLATE.name(), ResourceType.Service.STOP_DEPENDENCIES_TEMPLATE.toString()));
                                continue;
                            }
                            if (attrName.equalsIgnoreCase(ResourceType.LocalResource.VERSION.name()) || attrName.equalsIgnoreCase(ResourceLiterals.ACL_ATTR.toString()) || attrName.equalsIgnoreCase(ResourceType.LocalResource.START_DEPENDENCIES.name()) || attrName.equalsIgnoreCase(ResourceType.LocalResource.START_DEPENDENCIES_RTE_INTERNAL.name()) || attrName.equalsIgnoreCase(ResourceType.LocalResource.STOP_DEPENDENCIES.name()) || attrName.equalsIgnoreCase(ResourceType.LocalResource.STOP_DEPENDENCIES_RTE_INTERNAL.name())) continue;
                            ra.add(svcCRSResource.getAttribute(attrName));
                        }
                        int netNum = -1;
                        try {
                            netNum = svc.getNetwork().getNumber();
                        }
                        catch (ServiceException | NetworkException ne) {
                            Trace.out("failed to get network number due to %s : %s", ne.getClass().getName(), ne.getMessage());
                        }
                        ra.addAll(svc.createStartStopDep(svc.getUserAssignedName(), svc.getMainService(), this, svc.getServiceType(), svc.getServiceCardinality(), svc.getTAF() == ServiceTAF.PRECONNECT, svc.getManagementPolicy(), netNum, swVersion, ra));
                        Trace.out((Object)"updating service %s with new attributes ...", svc.getName());
                        svcCRSResource.update(ra);
                    }
                    catch (CRSException e) {
                        excp = e;
                    }
                    catch (NotExistsException e) {
                        excp = e;
                    }
                    catch (ServiceException e) {
                        excp = e;
                    }
                    if (excp == null) continue;
                    resultMap.put(svc, (NativeResult)((Object)excp));
                    gotResult = false;
                    if (sb != null) {
                        sb.append(" " + svc.getUserAssignedName());
                        continue;
                    }
                    sb = new StringBuilder(svc.getUserAssignedName());
                }
                if (!gotResult) {
                    throw new CompositeOperationException((MessageKey)PrCdMsgID.SERVICES_UPGRADE_FAILED, resultMap, sb.toString(), swVersion.toString());
                }
            }
            if (!Version.isPre12c(swVersion)) {
                this.removeEmptyGroupsPre12NT(this.m_crsResource);
                this.ntGrantAclsForTransparentHA(oHome, this.m_crsResource, swVersion);
                List<Service> myServices = this.services();
                if (myServices != null) {
                    for (Service svc : myServices) {
                        try {
                            CRSResourceImpl svcResource = (CRSResourceImpl)svc.crsResource();
                            this.removeEmptyGroupsPre12NT(svcResource);
                            this.ntGrantAclsForTransparentHA(oHome, svcResource, this.version());
                        }
                        catch (NotExistsException notExistsException) {}
                    }
                }
            }
            if (dbType == DatabaseType.RAC) {
                return new CardinalDatabaseImpl(this.m_nameAttr, this.m_version);
            }
            if (dbType == DatabaseType.RACOneNode) {
                return new RACOneNodeDatabaseImpl(this.m_nameAttr, this.m_version);
            }
            return new SingleInstanceDatabaseImpl(this.m_nameAttr, this.m_version);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DATABASE_UPGRADE_FAILED, (Throwable)e, this.getUserAssignedName(), swVersion.toString());
        }
        catch (NoVersionAvailableException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DATABASE_UPGRADE_FAILED, (Throwable)e, this.getUserAssignedName(), swVersion.toString());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DATABASE_UPGRADE_FAILED, (Throwable)e, this.getUserAssignedName(), swVersion.toString());
        }
        catch (AlreadyExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DATABASE_UPGRADE_FAILED, (Throwable)e, this.getUserAssignedName(), swVersion.toString());
        }
    }

    @Override
    public Database downgrade(String oHome, Version oldVersion) throws AlreadyDowngradedException, CompositeOperationException, DatabaseException {
        DatabaseImpl.assertOracleHome(oHome);
        if (oldVersion == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oldVersion");
        }
        try {
            Common.versionCheck(oHome, oldVersion);
            String oldVersion4 = oldVersion.toString4();
            Version currVersion = this.version();
            if (Version.isPre112(oldVersion)) {
                throw new DatabaseException((MessageKey)PrCdMsgID.UNSUPPORTED_VERSION_FOR_DB_DOWNGRADE, currVersion.toString(), oldVersion.toString(), this.getUserAssignedName());
            }
            String tmpVersion = currVersion.toString();
            int index = tmpVersion.lastIndexOf(46);
            String attrVersion = tmpVersion.substring(0, index);
            Trace.out("attr version = " + attrVersion);
            Trace.out("old version = " + oldVersion4);
            if (oldVersion4.equals(attrVersion)) {
                throw new AlreadyDowngradedException((MessageKey)PrCdMsgID.DATABASE_DOWNGRADED, this.getUserAssignedName(), oldVersion.toString(), this.getUserAssignedName());
            }
            if (attrVersion.compareTo(oldVersion4) < 0) {
                throw new DatabaseException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_TO_NEWER, this.getUserAssignedName(), attrVersion, oldVersion.toString());
            }
            boolean isTo11201Version = oldVersion.equals(Version.get11201Version());
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ArrayList<ResourceAttribute> ral = new ArrayList<ResourceAttribute>();
            boolean isUnix = new SystemFactory().CreateSystem().isUnixSystem();
            ResourceAttribute acl = null;
            if (isUnix) {
                acl = this.getACLAttr(oHome, oldVersion);
                ral.add(acl);
            }
            if (Version.isPre12102(oldVersion) && !Version.isPre12102(currVersion)) {
                ral.add(cf.create(ResourceType.Database.ACTIONS.name(), Common.createActionsAttr(null, ResourceType.Database.NAME.toString(), this.m_nameAttr.getValue())));
                ral.add(cf.create(ResourceType.Database.ACTION_TIMEOUT.name(), ""));
                ral.add(cf.create(ResourceType.Database.ACTION_START_OPTION.name(), ""));
            }
            ral.add(cf.create(ResourceType.Database.ORACLE_HOME.name(), oHome));
            ral.add(cf.create(ResourceType.LocalResource.VERSION.name(), oldVersion.toString()));
            DatabaseType dbType = this.isClusterDatabase() ? DatabaseType.RAC : DatabaseType.SIDB;
            List<DiskGroup> dglist = this.diskGroups();
            List<ResourceAttribute> dgAttrList = this.getDiskGroupAttrList(dglist);
            List<AsmClusterFileSystem> acfsList = this.asmClusterFileSystems();
            AsmClusterFileSystem acfs = null;
            if (Cluster.isCluster()) {
                acfs = this.getACFS(oHome, oHome, true);
            }
            if (acfs != null && !acfsList.contains(acfs)) {
                Trace.out("adding acfs " + acfs.getName());
                acfsList.add(acfs);
            }
            ral.addAll(Arrays.asList(this.createStartDepRTE(dgAttrList, acfsList, this.getMgmtPolicy(), dbType)));
            ral.addAll(Arrays.asList(this.createStopDep(dgAttrList, acfsList, oHome)));
            if (isTo11201Version) {
                ral.add(cf.create(ResourceType.Database.DATABASE_TYPE.name(), ResourceType.Database.DATABASE_TYPE.toString()));
                ral.add(cf.create(ResourceType.Database.DEFAULT_TEMPLATE.name(), DatabaseImpl.getEvtTemplate(oldVersion)));
                ral.add(cf.create(ResourceType.Database.ONLINE_RELOCATION_TIMEOUT.name(), ResourceType.Database.ONLINE_RELOCATION_TIMEOUT.toString()));
            }
            if (Version.isPre122(oldVersion) && !Version.isPre122(currVersion)) {
                ral.add(cf.create(ResourceType.Database.CSS_CRITICAL.name(), CRSResource.CSSCritical.NO.toString()));
                ral.add(cf.create(ResourceType.Database.WORKLOAD_CPU.name(), ResourceType.Database.WORKLOAD_CPU.toString()));
                ral.add(cf.create(ResourceType.Database.WORKLOAD_MEMORY_TARGET.name(), ResourceType.Database.WORKLOAD_MEMORY_TARGET.toString()));
                ral.add(cf.create(ResourceType.Database.WORKLOAD_MEMORY_MAX.name(), ResourceType.Database.WORKLOAD_MEMORY_MAX.toString()));
                ral.add(cf.create(ResourceType.Database.WORKLOAD_CPU_CAP.name(), ResourceType.Database.WORKLOAD_CPU_CAP.toString()));
                ral.add(cf.create(ResourceType.Database.JAVA_SERVICES.name(), ResourceType.Database.JAVA_SERVICES.toString()));
                ral.add(cf.create(ResourceType.Database.PATCH_IN_PROGRESS.name(), ResourceType.Database.PATCH_IN_PROGRESS.toString()));
            }
            this.m_crsResource.update(ral.toArray(new ResourceAttribute[ral.size()]));
            List<Service> svclist = this.services(false, true);
            if (svclist.size() > 0) {
                ral = new ArrayList();
                ral.add(cf.create(ResourceType.LocalResource.VERSION.name(), oldVersion.toString()));
                if (isTo11201Version) {
                    ral.add(cf.create(ResourceType.Service.EDITION.name(), ResourceType.Service.EDITION.toString()));
                }
                boolean gotResult = true;
                HashMap<Object, NativeResult> resultMap = new HashMap<Object, NativeResult>(svclist.size());
                StringBuilder sb = null;
                for (Service svc : svclist) {
                    ManageableEntityException excp = null;
                    try {
                        CRSResourceImpl svcCRSResource = (CRSResourceImpl)svc.crsResource();
                        String failoverDelay = svcCRSResource.getAttribute(ResourceLiterals.TAF_FAILOVER_DELAY.toString()).getValue();
                        Trace.out("failover delay=" + failoverDelay);
                        if (failoverDelay.trim().length() > 0) {
                            ral.add(cf.create(ResourceLiterals.FAILOVER_DELAY.toString(), failoverDelay));
                        }
                        String failoverType = svcCRSResource.getAttribute(ResourceType.Service.FAILOVER_TYPE.name()).getValue();
                        String failoverMethod = svcCRSResource.getAttribute(ResourceType.Service.FAILOVER_METHOD.name()).getValue();
                        String failoverRetries = svcCRSResource.getAttribute(ResourceType.Service.FAILOVER_RETRIES.name()).getValue();
                        if (!Version.isPre112(oldVersion) && Version.isPre12c(oldVersion)) {
                            if (failoverType == null || failoverType.trim().isEmpty()) {
                                ral.add(cf.create(ResourceType.Service.FAILOVER_TYPE.name(), ResourceType.Service.FAILOVER_TYPE.toString()));
                            }
                            if (failoverMethod == null || failoverMethod.trim().isEmpty()) {
                                ral.add(cf.create(ResourceType.Service.FAILOVER_METHOD.name(), ResourceType.Service.FAILOVER_METHOD.toString()));
                            }
                            if (failoverRetries == null || failoverRetries.trim().isEmpty()) {
                                ral.add(cf.create(ResourceType.Service.FAILOVER_RETRIES.name(), ResourceType.Service.FAILOVER_RETRIES.toString()));
                            }
                        }
                        if (Version.isPre122(oldVersion)) {
                            ral.add(cf.create(ResourceType.Service.FAILOVER_RESTORE.name(), FailoverRestore.NONE.toString()));
                            ral.add(cf.create(ResourceType.Service.ACTIONS.name(), ""));
                        }
                        if (acl != null) {
                            ral.add(acl);
                        }
                        if (Version.isPre122(oldVersion)) {
                            ral.add(cf.create(ResourceType.Service.RELOCATE_KIND.name(), ResourceLiterals.RELOCATE_KIND_OFFLINE.toString()));
                        }
                        if (Version.isPre122(oldVersion) && !Version.isPre122(currVersion)) {
                            ral.add(cf.create(ResourceType.Database.CSS_CRITICAL.name(), CRSResource.CSSCritical.NO.toString()));
                        }
                        svcCRSResource.update(ral.toArray(new ResourceAttribute[ral.size()]));
                    }
                    catch (CRSException e) {
                        excp = e;
                    }
                    catch (NotExistsException e) {
                        excp = e;
                    }
                    catch (ServiceException e) {
                        excp = e;
                    }
                    if (excp == null) continue;
                    resultMap.put(svc, (NativeResult)((Object)excp));
                    gotResult = false;
                    if (sb != null) {
                        sb.append(" " + svc.getUserAssignedName());
                        continue;
                    }
                    sb = new StringBuilder(svc.getUserAssignedName());
                }
                if (!gotResult) {
                    throw new CompositeOperationException((MessageKey)PrCdMsgID.SERVICES_DOWNGRADE_FAILED, resultMap, sb.toString(), oldVersion.toString());
                }
            }
            if (dbType == DatabaseType.RAC) {
                return new CardinalDatabaseImpl(this.m_nameAttr, oldVersion);
            }
            if (dbType == DatabaseType.RACOneNode) {
                return new RACOneNodeDatabaseImpl(this.m_nameAttr, oldVersion);
            }
            return new SingleInstanceDatabaseImpl(this.m_nameAttr, oldVersion);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DATABASE_DOWNGRADE_FAILED, (Throwable)e, this.getUserAssignedName(), oldVersion.toString());
        }
        catch (NoVersionAvailableException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DATABASE_DOWNGRADE_FAILED, (Throwable)e, this.getUserAssignedName(), oldVersion.toString());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DATABASE_DOWNGRADE_FAILED, (Throwable)e, this.getUserAssignedName(), oldVersion.toString());
        }
    }

    DatabaseOptionalArgs getArgs() throws DatabaseException {
        try {
            int i;
            Enum[] soArr;
            List<ResourceAttribute> raL = this.m_crsResource.getAttributes(ResourceType.Database.SERVER_POOLS.name(), ResourceType.Database.SERVER_POOLS_PQ.name(), ResourceType.Database.USR_ORA_DB_NAME.name(), ResourceType.Database.USR_ORA_DOMAIN.name(), ResourceType.Database.USR_ORA_INST_NAME.name(), ResourceType.Database.SPFILE.name(), ResourceType.Database.USR_ORA_OPEN_MODE.name(), ResourceType.Database.USR_ORA_STOP_MODE.name(), ResourceType.Database.ROLE.name(), ResourceType.Database.MANAGEMENT_POLICY.name(), ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceType.Database.CSS_CRITICAL.name(), ResourceType.Database.WORKLOAD_CPU.name(), ResourceType.Database.WORKLOAD_MEMORY_TARGET.name(), ResourceType.Database.WORKLOAD_MEMORY_MAX.name(), ResourceType.Database.WORKLOAD_CPU_CAP.name());
            DatabaseOptionalArgs args = new DatabaseOptionalArgs();
            ServerFactoryImpl serverFac = ServerFactoryImpl.getInstance();
            Hashtable<String, String> attrs = new Hashtable<String, String>();
            for (ResourceAttribute ra : raL) {
                attrs.put(ra.getName(), ra.getValue());
            }
            String val = null;
            String[] values = null;
            val = (String)attrs.get(ResourceType.Database.SERVER_POOLS.name());
            if (val.length() > 0) {
                args.setServerGroupList(serverFac.getServerGrpList(val, String.valueOf(" ")));
            }
            if ((val = (String)attrs.get(ResourceType.Database.SERVER_POOLS_PQ.name())).length() > 0) {
                args.setPQPools(serverFac.getServerGrpList(val, String.valueOf(" ")));
            }
            val = (String)attrs.get(ResourceType.Database.USR_ORA_DB_NAME.name());
            args.setDBName(val);
            val = (String)attrs.get(ResourceType.Database.USR_ORA_DOMAIN.name());
            args.setDBDomain(val);
            val = (String)attrs.get(ResourceType.Database.USR_ORA_INST_NAME.name());
            args.setInstanceName(val);
            val = (String)attrs.get(ResourceType.Database.SPFILE.name());
            args.setSPFile(val);
            val = (String)attrs.get(ResourceType.Database.USR_ORA_OPEN_MODE.name());
            if (val.length() > 0) {
                values = val.split(" ");
                soArr = new StartOptions[values.length];
                for (i = 0; i < values.length; ++i) {
                    soArr[i] = StartOptions.getEnumMember(values[i].trim());
                }
                args.setStartModes((StartOptions[])soArr);
            }
            if ((val = (String)attrs.get(ResourceType.Database.USR_ORA_STOP_MODE.name())).length() > 0) {
                values = val.split(" ");
                soArr = new StopOptions[values.length];
                for (i = 0; i < values.length; ++i) {
                    soArr[i] = StopOptions.getEnumMember(values[i].trim());
                }
                args.setStopModes((StopOptions[])soArr);
            }
            val = (String)attrs.get(ResourceType.Database.ROLE.name());
            args.setDBRole(DBRole.getEnumMember(val));
            val = (String)attrs.get(ResourceType.Database.MANAGEMENT_POLICY.name());
            args.setMgmtPolicy(ManagementPolicy.getEnumMember(val));
            ArrayList<Object> dgList = null;
            ArrayList<Object> acfsList = null;
            val = (String)attrs.get(ResourceType.LocalResource.START_DEPENDENCIES.name());
            ResourceAttribute startDepAttr = CRSFactoryImpl.getInstance().create(ResourceType.LocalResource.START_DEPENDENCIES.name(), val);
            Trace.out("start value = " + startDepAttr.getValue());
            String[] resNames = ResourceDependency.getResourceNames(startDepAttr, ResourceDependency.DepType.HARD_DEP);
            if (resNames.length == 0) {
                Trace.out("no resource names found");
                dgList = new ArrayList<DiskGroup>(0);
                acfsList = new ArrayList<AsmClusterFileSystem>(0);
            } else {
                Trace.out("resNames length is " + resNames.length);
                dgList = new ArrayList(resNames.length);
                ASMFactoryImpl asmFactory = ASMFactoryImpl.getInstance();
                List fslist = null;
                try {
                    fslist = asmFactory.getAsmClusterFileSystems();
                }
                catch (NotExistsException e) {
                    acfsList = new ArrayList(0);
                }
                acfsList = new ArrayList(resNames.length);
                boolean exist = false;
                for (String resourceName : resNames) {
                    Trace.out("resourceName = " + resourceName);
                    try {
                        String dgName = null;
                        try {
                            dgName = DiskGroupImpl.getUserAssignedName((String)resourceName);
                        }
                        catch (ASMException e) {
                            String[] acfsInfos = null;
                            try {
                                acfsInfos = AsmClusterFileSystemImpl.getUserAssignedNames((String)resourceName);
                            }
                            catch (AsmClusterFileSystemException fe) {
                                continue;
                            }
                            Trace.out("disk group = %s, volume name = %s", acfsInfos[0], acfsInfos[1]);
                            exist = false;
                            for (AsmClusterFileSystem fs : fslist) {
                                if (!acfsInfos[0].equals(fs.getDiskGroup()) || !acfsInfos[1].equals(fs.getVolumeName())) continue;
                                acfsList.add(fs);
                                exist = true;
                                break;
                            }
                            if (exist) continue;
                            throw new DatabaseException((MessageKey)PrCdMsgID.GET_ACFS_RES_FAILED, resourceName, this.getUserAssignedName());
                        }
                        Trace.out("disk group name = " + dgName);
                        dgList.add(asmFactory.getDiskGroup(dgName));
                    }
                    catch (NotExistsException ne) {
                        throw new DatabaseException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)ne, resourceName, this.getUserAssignedName());
                    }
                }
            }
            args.setDiskGroupList(dgList);
            args.setACFS(acfsList);
            val = (String)attrs.get(ResourceType.Database.CSS_CRITICAL.name());
            if (val != null && !val.trim().isEmpty()) {
                args.setCSSCriticalOption(CRSResource.CSSCritical.getEnumMember(val));
            }
            if ((val = (String)attrs.get(ResourceType.Database.WORKLOAD_CPU.name())) != null && !val.trim().isEmpty()) {
                args.setCPUCount(Integer.parseInt(val));
            }
            if ((val = (String)attrs.get(ResourceType.Database.WORKLOAD_MEMORY_TARGET.name())) != null && !val.trim().isEmpty()) {
                args.setMemoryTarget(Integer.parseInt(val));
            }
            if ((val = (String)attrs.get(ResourceType.Database.WORKLOAD_MEMORY_MAX.name())) != null && !val.trim().isEmpty()) {
                args.setMaxMemory(Integer.parseInt(val));
            }
            if ((val = (String)attrs.get(ResourceType.Database.WORKLOAD_CPU_CAP.name())) != null && !val.trim().isEmpty()) {
                args.setCPUCap(Integer.parseInt(val));
            }
            return args;
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_ARGS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (EnumConstNotFoundException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_ARGS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_ARGS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ASMException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_ARGS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (AsmClusterFileSystemException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_ARGS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_ARGS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_ARGS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NumberFormatException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_ARGS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    protected static String getEvtTemplate(Version version) {
        String defTemplate = ResourceType.Database.DEFAULT_TEMPLATE.toString();
        if (!Version.isPre11202(version)) {
            defTemplate = defTemplate + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + ResourceType.Database.DATABASE_TYPE.name() + "= %" + ResourceType.Database.DATABASE_TYPE.name() + "%)";
        }
        return defTemplate;
    }

    protected Map<String, String> getRunningInstances() throws DatabaseException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter dbTypeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
            Filter dbNameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.Database.NAME.name(), this.getName());
            Filter stateOnlineFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.STATE_ATTR_NAME.toString(), "ONLINE");
            Filter stateIntermediateFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.STATE_ATTR_NAME.toString(), "INTERMEDIATE");
            Filter tgtOnlineFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TARGET_ATTR_NAME.toString(), "ONLINE");
            Filter filter = crsFactory.getFilter(Filter.Operator.AND, dbTypeFilter, dbNameFilter);
            Filter stateAndTgtFilter = crsFactory.getFilter(Filter.Operator.OR, stateOnlineFilter, stateIntermediateFilter);
            stateAndTgtFilter = crsFactory.getFilter(Filter.Operator.AND, tgtOnlineFilter, stateAndTgtFilter);
            filter = crsFactory.getFilter(Filter.Operator.AND, filter, stateAndTgtFilter);
            Map<String, Map<String, String>> resultData = crsFactory.searchEntities((CRSEntity)((Object)this.crsResource()), CRSEntity.Type.ResourceInstance, true, filter, ResourceType.Database.GEN_USR_ORA_INST_NAME.name(), ResourceLiterals.CRS_LAST_SERVER.toString());
            HashMap<String, String> resultMap = new HashMap<String, String>();
            String instName = null;
            String serverName = null;
            for (String riID : resultData.keySet()) {
                Map<String, String> valueMap = resultData.get(riID);
                instName = valueMap.get(ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
                serverName = valueMap.get(ResourceLiterals.CRS_LAST_SERVER.toString());
                resultMap.put(instName, serverName);
            }
            return resultMap;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    protected void assertIsRunning() throws AlreadyStoppedException {
        this.assertIsRunning(null);
    }

    protected void assertIsRunning(Node node) throws AlreadyStoppedException {
        try {
            if (node == null && !this.isRunning()) {
                throw new AlreadyStoppedException((MessageKey)PrCcMsgID.ALREADY_STOPPED, this.getUserAssignedName());
            }
            if (node != null && !this.isRunning(node)) {
                throw new AlreadyStoppedException((MessageKey)PrCcMsgID.ALREADY_STOPPED_PERX, this.getUserAssignedName(), node.getName());
            }
        }
        catch (SoftwareModuleException softwareModuleException) {
        }
        catch (NodeException nodeException) {
            // empty catch block
        }
    }

    private void removeEmptyGroupsPre12NT(CRSResourceImpl resource) throws CRSException {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            Trace.out("Windows env, remove any empty group from upgraded resource");
            ResourcePermissionsImpl perms = (ResourcePermissionsImpl)resource.getPermissions();
            perms.setPerm(ResourceType.ACL.GROUP, "", new ResourceType.ACL_PERM[0]);
            resource.setPermissions(perms);
        }
    }

    private void ntGrantAclsForServices(List<Service> myServices, String oracleHome) throws DatabaseException, NotExistsException, NoVersionAvailableException, SoftwareModuleException, ServiceException {
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            return;
        }
        if (myServices == null) {
            myServices = this.services();
        }
        if (myServices != null) {
            for (Service svc : myServices) {
                CRSResourceImpl svcResource = (CRSResourceImpl)svc.crsResource();
                this.ntGrantAclsForTransparentHA(oracleHome, svcResource, this.version());
            }
        }
    }

    private void ntGrantAclsForTransparentHA(String oracleHome, CRSResourceImpl crsResource, Version version) throws DatabaseException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)crsResource.getPermissions();
                perm.ntGrantHomeUserPermissions(oracleHome, version, true);
                perm.ntGrantOraInstallPermissions();
                crsResource.setPermissions(perm);
            } else {
                Trace.out("grant ACLs called with null resource or on wrong platform");
            }
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    private void ntRemoveOldAclEntries(String oracleHome, String oldOracleHome, Credentials newCred, Credentials oldCred, NtUserTypeEnum newUserType, NtUserTypeEnum oldUserType, CRSResourceImpl crsResource, Version version) throws DatabaseException {
        if (new SystemFactory().CreateSystem().isUnixSystem() || crsResource == null) {
            return;
        }
        try {
            ResourcePermissionsImpl perm = (ResourcePermissionsImpl)crsResource.getPermissions();
            String oldUsername = oldCred.getUsername();
            if (newUserType == NtUserTypeEnum.VIRTUALACCOUNT || newUserType == NtUserTypeEnum.BUILTINACCOUNT) {
                Trace.out("new user is virtual or builtin");
                switch (oldUserType) {
                    case VIRTUALACCOUNT: {
                        Trace.out("removing old virtual user permissions");
                        perm.ntRemoveVirtualUserPermissions(oldUsername);
                        break;
                    }
                    case BUILTINACCOUNT: {
                        return;
                    }
                    case LOWPRIVLOCALUSER: 
                    case LOWPRIVDOMAINUSER: {
                        Trace.out("removing old LP user permissions");
                        perm.setPerm(ResourceType.ACL.USER, oldUsername, new ResourceType.ACL_PERM[0]);
                    }
                }
            } else {
                switch (oldUserType) {
                    case VIRTUALACCOUNT: {
                        throw new DatabaseException((MessageKey)PrCdMsgID.ORACLE_USER_MISMATCH_WIN, oldOracleHome, oracleHome);
                    }
                    case LOWPRIVLOCALUSER: 
                    case LOWPRIVDOMAINUSER: {
                        if (!newCred.equals(oldCred)) {
                            throw new DatabaseException((MessageKey)PrCdMsgID.ORACLE_USER_MISMATCH_WIN, oldOracleHome, oracleHome);
                        }
                    }
                    case BUILTINACCOUNT: {
                        Trace.out("removing old LP user permissions");
                        perm.setPerm(ResourceType.ACL.USER, oldUsername, new ResourceType.ACL_PERM[0]);
                    }
                }
            }
            crsResource.setPermissions(perm);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean isAdminManaged() throws DatabaseException {
        try {
            List<ServerGroup> sglist;
            boolean isAdminManaged = false;
            if (this.getSIDBType() == SIDBType.FIXED) {
                isAdminManaged = true;
            } else if (Cluster.isCluster() && (sglist = this.serverGroups()).size() == 1 && !sglist.get(0).isServerPool()) {
                isAdminManaged = true;
            }
            return isAdminManaged;
        }
        catch (ServerGroupException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.IS_DBCETRIC_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public List<String> getAdminDBConfiguredNodes() throws DatabaseException {
        try {
            if (!this.isAdminManaged()) {
                throw new DatabaseException((MessageKey)PrCdMsgID.DB_NOT_ADMIN_MANAGED, this.getUserAssignedName());
            }
            ArrayList<String> nodes = new ArrayList<String>();
            List<DatabaseInstance> configInstances = this.configuredInstances();
            for (DatabaseInstance di : configInstances) {
                nodes.add(di.node().getName());
            }
            return nodes;
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_ADMIN_DB_NODES_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (InstanceException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_ADMIN_DB_NODES_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_ADMIN_DB_NODES_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public final SIDBType getSIDBType() {
        try {
            if (this.databaseType() != DatabaseType.SIDB) {
                return SIDBType.INVALID;
            }
            String host = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.HOSTING_MEMBERS.name()).getValue().trim();
            if (host != null && !host.isEmpty()) {
                return SIDBType.FIXED;
            }
            String sgName = this.m_crsResource.getAttribute(ResourceType.Database.SERVER_POOLS.name()).getValue().trim();
            ServerGroup sg = ServerFactory.getInstance().getServerGroup(sgName);
            if (!sg.isServerPool()) {
                return SIDBType.ADMIN;
            }
            return SIDBType.POLICY;
        }
        catch (CRSException e) {
            return SIDBType.INVALID;
        }
        catch (ServerGroupException e) {
            return SIDBType.INVALID;
        }
        catch (ServerException e) {
            return SIDBType.INVALID;
        }
        catch (NotExistsException e) {
            return SIDBType.INVALID;
        }
        catch (DatabaseException e) {
            return SIDBType.INVALID;
        }
    }

    @Override
    public void updateStartMode(StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, DatabaseException {
        this.m_DbAction.startAction(soArr);
    }

    @Override
    public void updateStartMode(String nodeName, StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, NotRunningException, DatabaseException {
        this.m_DbAction.startAction(nodeName, soArr);
    }

    @Override
    public void updateInstanceStartMode(String instName, StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, DatabaseException {
        this.m_DbAction.startAction(soArr, instName);
    }

    private Filter getSvcFilter(List<Service> srvList) throws CRSException {
        Filter result = null;
        Filter wrk = null;
        if (srvList != null && !srvList.isEmpty()) {
            for (Service srv : srvList) {
                wrk = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceType.Service.NAME.name(), srv.getName());
                if (result == null) {
                    result = wrk;
                    continue;
                }
                result = FilterFactoryImpl.getExpressionFilter(Filter.Operator.OR, result, wrk);
            }
            wrk = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Service.NAME.toString());
            return FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, result, wrk);
        }
        result = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Service.NAME.toString());
        wrk = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.COI, ResourceType.Service.NAME.name(), '.' + this.getUserAssignedName() + '.');
        return FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, result, wrk);
    }

    @Override
    public void move(String oraHome) throws HomeException, VersionMismatchException, MoveDatabaseException {
        this.move(oraHome, true);
    }

    @Override
    public void move(String oraHome, boolean rolling) throws HomeException, VersionMismatchException, MoveDatabaseException {
        String dbName = this.getUserAssignedName();
        try {
            DatabaseImpl.assertOracleHome(oraHome);
            Common.homeVersionCheck(oraHome, this.getOracleHome());
        }
        catch (HomeException de) {
            throw new HomeException((MessageKey)PrCdMsgID.MOVE_DB_FAILED, (Throwable)de, dbName, oraHome);
        }
        catch (VersionMismatchException de) {
            throw new VersionMismatchException((MessageKey)PrCdMsgID.MOVE_DB_FAILED, (Throwable)de, dbName, oraHome);
        }
        catch (DatabaseException de) {
            throw new HomeException((MessageKey)PrCdMsgID.MOVE_DB_FAILED, (Throwable)de, dbName, oraHome);
        }
        String oldOraHome = "";
        try {
            Map<String, String> instances = this.getRunningInstances();
            oldOraHome = this.getOracleHome();
            this.setOracleHome(oraHome, false);
            if (instances.isEmpty()) {
                Trace.out("No instances need to be restarted");
                return;
            }
            CRSResourceImpl crsRes = (CRSResourceImpl)this.crsResource();
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ResourceAttribute[] stopOptions = new ResourceAttribute[]{cf.create(ResourceType.Database.USR_ORA_STOP_MODE.name(), StopOptions.IMMEDIATE.toString())};
            if (rolling) {
                MutableMoveDatabaseException mde = null;
                for (String inst : instances.keySet()) {
                    String nodeName = instances.get(inst);
                    Node node = ServerFactory.getInstance().getNode(nodeName);
                    Trace.out("Stopping db " + dbName + " on node " + nodeName);
                    try {
                        crsRes.stop(node, true, true, stopOptions);
                        Trace.out("Stopped db " + dbName + " on node " + nodeName);
                    }
                    catch (AlreadyStoppedException alreadyStoppedException) {
                    }
                    catch (NodeException e) {
                        Trace.out("MDB-node : " + e);
                        if (mde == null) {
                            mde = MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, e, dbName, oraHome);
                        }
                        mde.setFailure(nodeName, dbName, MoveDatabaseException.Operation.STOP, e);
                    }
                    catch (CRSException e) {
                        Trace.out("MDB-crs : " + e);
                        if (mde == null) {
                            mde = MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, e, dbName, oraHome);
                        }
                        mde.setFailure(nodeName, dbName, MoveDatabaseException.Operation.STOP, e);
                    }
                    Trace.out("Restarting db " + dbName + " on node " + nodeName);
                    try {
                        crsRes.start(node);
                        Trace.out("Restarted db " + dbName + " on node " + nodeName);
                    }
                    catch (AlreadyRunningException e) {
                    }
                    catch (NodeException e) {
                        Trace.out("MDB-node : " + e);
                        if (mde == null) {
                            mde = MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, e, dbName, oraHome);
                        }
                        mde.setFailure(nodeName, dbName, MoveDatabaseException.Operation.START, e);
                    }
                    catch (CRSException e) {
                        Trace.out("MDB-crs : " + e);
                        if (mde == null) {
                            mde = MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, e, dbName, oraHome);
                        }
                        mde.setFailure(nodeName, dbName, MoveDatabaseException.Operation.START, e);
                    }
                }
                if (mde != null) {
                    throw mde;
                }
                return;
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (String inst : instances.keySet()) {
                String nodeName = instances.get(inst);
                nodes.add(ServerFactory.getInstance().getNode(nodeName));
            }
            Trace.out("Stopping only those db instances that are currently running");
            try {
                crsRes.stop(nodes, true);
            }
            catch (AlreadyStoppedException alreadyStoppedException) {
            }
            catch (CompositeOperationException coe) {
                Trace.out("MDB-COE : " + coe);
                throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, coe, dbName, oraHome);
            }
            Trace.out("Restarting only those db instances that were previously running");
            try {
                crsRes.start(nodes);
            }
            catch (AlreadyRunningException coe) {
            }
            catch (CompositeOperationException coe) {
                Trace.out("MDB-COE : " + coe);
                throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, coe, dbName, oraHome);
            }
        }
        catch (NodeException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, e, dbName, oraHome);
        }
        catch (ServerException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, e, dbName, oraHome);
        }
        catch (NotExistsException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, e, dbName, oraHome);
        }
        catch (DatabaseException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, e, dbName, oraHome);
        }
        catch (CRSException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, e, dbName, oraHome);
        }
        catch (SoftwareModuleException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DB_FAILED, e, dbName, oraHome);
        }
    }

    protected void internalSvcAndDBStopHelper(List<Node> nodeList, boolean keepDepTgt, boolean chkCriticalInst, DatabaseOptionalArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException, InstanceException {
        DatabaseStopArgs stopArgs = new DatabaseStopArgs();
        if (args != null) {
            try {
                stopArgs = DatabaseImpl.createDBStopArgs(args);
            }
            catch (InvalidArgsException invalidArgsException) {
                // empty catch block
            }
        }
        stopArgs.setForceFlag(true);
        this.internalSvcAndDBStopHelper(nodeList, keepDepTgt, chkCriticalInst, stopArgs);
    }

    void internalSvcAndDBStopHelper(List<Node> nodeList, boolean keepDepTgt, boolean chkCriticalInst, DatabaseStopArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException, InstanceException {
        StringBuilder nodeNames = new StringBuilder();
        String dbName = this.getUserAssignedName();
        boolean force = false;
        boolean failover = false;
        boolean nodesSpecified = false;
        Enum[] stopOptions = null;
        ManageableEntityException ex = null;
        Integer drainTimeout = null;
        Integer stopTimeout = null;
        Integer concurrency = null;
        Boolean disconnect = null;
        Boolean noreplay = null;
        VerboseListener vlsnr = null;
        if (args != null) {
            Boolean forceFlag = args.getForceFlag();
            force = forceFlag != null && forceFlag != false;
            Boolean bl = args.getFailoverFlag();
            failover = bl != null && bl != false;
            stopOptions = args.getStopModes();
            drainTimeout = args.getDrainTimeout();
            stopTimeout = args.getStopTimeout();
            disconnect = args.getDisconnectOpt();
            noreplay = args.getNoreplay();
            vlsnr = args.getVerboseListener();
            concurrency = args.getStopConcurrency();
        }
        try {
            if (nodeList != null && nodeList.size() > 0) {
                for (Node node : nodeList) {
                    if (nodeNames.length() > 0) {
                        nodeNames.append(",");
                    }
                    nodeNames.append(node.getName());
                }
                boolean runningFlag = false;
                for (Node n : nodeList) {
                    if (!this.m_crsResource.isRunning(n.getName())) continue;
                    runningFlag = true;
                    break;
                }
                if (!runningFlag) {
                    throw new AlreadyStoppedException((MessageKey)PrCrMsgID.CRS_NO_RES_RUNNING_ON_NODE, nodeNames.toString());
                }
            } else {
                this.assertIsRunning();
            }
            DBServicesSelectionImpl svcsColl = null;
            List<DatabaseInstance> list = this.getGeneratedInstances();
            DatabaseInstance cInst = this.getCriticalInstance(list);
            ArrayList<Object> ncNodeList = new ArrayList<Node>();
            if (cInst != null) {
                if (nodeList != null && nodeList.size() > 0) {
                    Trace.out("database will be stopped on all the specified nodes excluding critical instance ...");
                    if (this.databaseType() == DatabaseType.RACOneNode) {
                        if (chkCriticalInst) {
                            throw new InstanceException((MessageKey)PrCdMsgID.CRITICAL_INST_STOP_REJECTED, cInst.getUserAssignedName(), dbName);
                        }
                        ncNodeList.add(nodeList.get(0));
                    } else {
                        ncNodeList = new ArrayList<Node>(nodeList);
                        Node cInstNode = cInst.node();
                        if (ncNodeList.contains(cInstNode)) {
                            ncNodeList.remove(cInst.node());
                        }
                    }
                } else {
                    Trace.out("database will be stopped on all nodes excluding critical instance ...");
                    ncNodeList = new ArrayList();
                    for (DatabaseInstance inst : list) {
                        ncNodeList.add(inst.node());
                    }
                    ncNodeList.remove(cInst.node());
                }
                if (ncNodeList.isEmpty()) {
                    Trace.out("cannot stop the critical instance");
                    throw new InstanceException((MessageKey)PrCdMsgID.CRITICAL_INST_STOP_REJECTED, cInst.getUserAssignedName(), dbName);
                }
            }
            if (this.databaseType() == DatabaseType.RAC && nodeList != null && !nodeList.isEmpty()) {
                this.processDB4OJVMPatching(Arrays.asList(oracle.cluster.impl.util.Utils.nodeList2StringArr(nodeList)), true);
            }
            if (!ncNodeList.isEmpty()) {
                Trace.out("non-critical nodes list is not empty ...");
                nodesSpecified = true;
                svcsColl = new DBServicesSelectionImpl(Arrays.asList(dbName), Arrays.asList(oracle.cluster.impl.util.Utils.nodeList2StringArr(ncNodeList)));
            } else if (nodeList != null && !nodeList.isEmpty()) {
                Trace.out("nodes list is not empty ...");
                nodesSpecified = true;
                svcsColl = new DBServicesSelectionImpl(Arrays.asList(dbName), Arrays.asList(oracle.cluster.impl.util.Utils.nodeList2StringArr(nodeList)));
            } else {
                Trace.out("stopping database on all nodes ...");
                svcsColl = new DBServicesSelectionImpl(Arrays.asList(dbName), false);
            }
            try {
                CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
                if (svcsColl != null) {
                    int waitTime;
                    ServiceStopArgs svcArgs = new ServiceStopArgs();
                    svcArgs.setForceFlag(force);
                    if (vlsnr != null) {
                        svcArgs.setVerboseListener(vlsnr);
                    }
                    if (stopOptions != null && stopOptions.length > 0) {
                        svcArgs.setStopModes((StopOptions[])(this.databaseType() == DatabaseType.RACOneNode ? stopOptions : Common.getSvcStopOptions((StopOptions[])stopOptions)));
                    }
                    if (disconnect != null) {
                        svcArgs.setDisconnectOpt(disconnect);
                    }
                    if (noreplay != null) {
                        svcArgs.setNoreplay(noreplay);
                    }
                    if (this.databaseType() == DatabaseType.RACOneNode && stopTimeout != null && stopTimeout != -1) {
                        svcArgs.setStopTimeout(stopTimeout);
                    }
                    int n = waitTime = drainTimeout != null ? drainTimeout.intValue() : svcsColl.calculateMaxDrain();
                    if (waitTime > 0) {
                        svcArgs.setDrainTimeout(waitTime);
                    }
                    String drainID = Common.getDrainID();
                    List<DBServiceOperationInfo> affectedSvcs = new ArrayList<DBServiceOperationInfo>();
                    if (nodesSpecified && failover) {
                        Trace.out("relocating services ...");
                        List<String> avoidNodes = Arrays.asList(oracle.cluster.impl.util.Utils.nodeList2StringArr(!ncNodeList.isEmpty() ? ncNodeList : nodeList));
                        affectedSvcs = svcsColl.internalRelocate(svcArgs, avoidNodes, null, drainID);
                        Trace.out("relocated services");
                    }
                    if (force) {
                        Trace.out("stopping services ...");
                        affectedSvcs.addAll(svcsColl.internalStop(svcArgs, drainID));
                        Trace.out("stopped services");
                    }
                    if (waitTime > 0 && !affectedSvcs.isEmpty()) {
                        Trace.out("waiting for sessions to drain ...");
                        Map<String, String> nodeSvcMap = Common.getNodeSvcMap(affectedSvcs);
                        try {
                            this.waitForDrainCompletion(drainID, waitTime, nodeSvcMap, vlsnr);
                        }
                        catch (DatabaseException e) {
                            Trace.out("Ignore this exception during drain action : \n" + e.getMessage());
                            ex = e;
                        }
                        Trace.out("completed waiting for sessions to drain");
                    }
                }
                ArrayList<ResourceAttribute> stopAttrs = new ArrayList<ResourceAttribute>();
                if (stopOptions != null && stopOptions.length > 0) {
                    stopAttrs.add(cf.create(ResourceType.Database.USR_ORA_STOP_MODE.name(), oracle.cluster.impl.util.Utils.getEnumString(stopOptions, String.valueOf(" "))));
                }
                if (nodeList == null && concurrency != null && concurrency != 0) {
                    stopAttrs.add(cf.create(ResourceType.ClusterResource.STOP_CONCURRENCY.name(), String.valueOf(concurrency)));
                }
                ResourceAttribute[] optionsArr = stopAttrs.toArray(new ResourceAttribute[stopAttrs.size()]);
                Filter stopFilter = DBFilterFactory.getStopFilter(this.getName(), ResourceType.Database.NAME.toString(), ncNodeList != null && !ncNodeList.isEmpty() ? ncNodeList : nodeList);
                Trace.out("Stopping database...");
                CRSFactoryImpl.stopResources(stopFilter, force, keepDepTgt, optionsArr);
            }
            catch (CompositeOperationException coe) {
                if (nodeList != null && nodeList.size() > 0) {
                    if (this.databaseType() == DatabaseType.RACOneNode) {
                        throw new InstanceException((MessageKey)PrCrMsgID.DB_AND_SERV_STOP_ON_NODE_FAILED, (Throwable)coe, dbName, nodeList.get(0).getName());
                    }
                    if (ncNodeList != null && ncNodeList.size() > 0) {
                        String names = null;
                        try {
                            names = oracle.cluster.impl.util.Utils.nodeList2String(ncNodeList, ",");
                        }
                        catch (NodeException nodeException) {
                            // empty catch block
                        }
                        throw new InstanceException((MessageKey)PrCrMsgID.DB_AND_SERV_STOP_ON_NODE_FAILED, (Throwable)coe, dbName, names);
                    }
                    throw new InstanceException((MessageKey)PrCrMsgID.DB_AND_SERV_STOP_FAILED, (Throwable)coe, dbName);
                }
                this.assertIsRunning();
                throw new DatabaseException((MessageKey)PrCrMsgID.DB_AND_SERV_STOP_FAILED, (Throwable)coe, dbName);
            }
            catch (SoftwareModuleException exp) {
                if (exp instanceof DatabaseException) {
                    throw (DatabaseException)exp;
                }
                throw new DatabaseException((MessageKey)PrCdMsgID.STOP_DB_FAILED, (Throwable)exp, dbName);
            }
            catch (CRSException exp) {
                throw new DatabaseException((MessageKey)PrCdMsgID.STOP_DB_FAILED, (Throwable)exp, dbName);
            }
            catch (NotRunningException exp) {
                throw new DatabaseException((MessageKey)PrCdMsgID.STOP_DB_FAILED, (Throwable)exp, dbName);
            }
            if (cInst != null && (nodeList != null && nodeList.contains(cInst.node()) || nodeList == null)) {
                throw new InstanceException((MessageKey)PrCdMsgID.CRITICAL_INST_STOP_REJECTED, cInst.getUserAssignedName(), dbName);
            }
        }
        catch (InvalidArgsException | CRSException | DatabaseException | NodeException e) {
            Trace.out("attempt to stop database on specified nodes failed with exception %s : %s", e.getClass().getName(), e);
            throw new InstanceException((MessageKey)PrCdMsgID.STOP_DB_ON_NODES_FAILED, (Throwable)e, this.getUserAssignedName(), nodeNames.toString());
        }
        catch (SoftwareModuleException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.STOP_DB_ON_NODES_FAILED, (Throwable)e, this.getUserAssignedName(), nodeNames.toString());
        }
        if (ex != null) {
            Trace.out("Exception during drain action thrown after stopping db " + ex.getMessage());
            throw ex;
        }
    }

    public void processDB4OJVMPatching(List<String> nodes, boolean isStop) throws InvalidArgsException, DatabaseException {
        if (this.databaseType() != DatabaseType.RAC) {
            Trace.out("database is not RAC ...");
            return;
        }
        boolean isFirstNode = this.isFirstNodetoPatch();
        boolean isPatchInProgress = this.isPatchInProgress();
        if (!isFirstNode && !isPatchInProgress) {
            Trace.out("out-of-place patching is not being performed for this database");
            return;
        }
        try {
            if (nodes == null || nodes.isEmpty()) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBImpl-prep4JavaPatch-nodes");
            }
            Trace.out("database %s is being %s on nodes %s", this.getUserAssignedName(), isStop ? "stopped" : "started", nodes.toString());
            boolean isLastNode = false;
            if (isPatchInProgress) {
                ArrayList<String> attrList = new ArrayList<String>(Arrays.asList(ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceLiterals.CRS_LAST_SERVER.toString(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name()));
                Map<String, Map<String, String>> instsInOldHome = this.getInstancesRunningFromOldHome(attrList);
                if (isStop) {
                    ArrayList<String> nodes4InstsInOldHome = new ArrayList<String>();
                    for (String inst : instsInOldHome.keySet()) {
                        Trace.out((Object)"getting details of instance %s ...", inst);
                        Map<String, String> val = instsInOldHome.get(inst);
                        nodes4InstsInOldHome.add(val.get(ResourceLiterals.CRS_LAST_SERVER.toString()));
                    }
                    isLastNode = !nodes4InstsInOldHome.isEmpty() && nodes.containsAll(nodes4InstsInOldHome);
                } else if (!isStop && isPatchInProgress) {
                    isLastNode = instsInOldHome.isEmpty();
                }
            }
            if (isStop && isFirstNode) {
                Trace.out("database is being stopped on the first node");
                this.performFirstNodeStopActions(nodes);
            } else if (isStop && isLastNode) {
                Trace.out("database is being stopped on the last node");
                this.performLastNodeStopActions();
            } else if (isStop && isPatchInProgress) {
                Trace.out("database is being stopped as part of rolling patch op");
                this.performEveryNodeStopActions(nodes);
            } else if (!isStop && isLastNode) {
                Trace.out("database is being started on the last node");
                this.performLastNodeStartActions();
            }
        }
        catch (InvalidArgsException | DatabaseException e) {
            Trace.out("attempt to process database for OJVM patching failed with exception %s : %s", e.getClass().getName(), e);
            throw new DatabaseException((MessageKey)PrCdMsgID.OJVM_PATCH_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    boolean isPatchInProgress() throws DatabaseException {
        try {
            return Boolean.valueOf(this.m_crsResource.getAttribute(ResourceType.Database.PATCH_IN_PROGRESS.name()).getValue());
        }
        catch (CRSException e) {
            Trace.out("attempt to retrieve value of PATCH_IN_PROGRESS failed with CRSException : %s", e);
            throw new DatabaseException(e);
        }
    }

    boolean isFirstNodetoPatch() throws DatabaseException {
        try {
            if (this.databaseType() != DatabaseType.RAC || this.isPatchInProgress()) {
                return false;
            }
            String oldHome = this.m_crsResource.getAttribute(ResourceType.Database.ORACLE_HOME_OLD.name()).getValue();
            Map<String, String> instStateDetails = this.getInstanceStateDetails();
            for (String stateDetails : instStateDetails.values()) {
                if (stateDetails.endsWith(STATE_DETAILS_HOME_KEY + oldHome)) continue;
                return false;
            }
            return true;
        }
        catch (CRSException e) {
            Trace.out("attempt to determine if all instances are running from old home failed with CRSException : %s", e);
            throw new DatabaseException(e);
        }
        catch (SoftwareModuleException e) {
            Trace.out("attempt to determine if all instances are running from old home failed with SoftwareModuleException : %s", e);
            throw new DatabaseException(e);
        }
    }

    void performFirstNodeStopActions(List<String> nodes) throws InvalidArgsException, DatabaseException {
        if (this.databaseType() != DatabaseType.RAC) {
            Trace.out("database is not RAC ...");
            return;
        }
        List<Service> services = this.services();
        if (services == null || services.isEmpty()) {
            Trace.out("database doesn't have services ...");
            return;
        }
        if (nodes == null || nodes.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBImpl-firstNodeStop-nodes");
        }
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            DBServicesSelectionImpl svcsColl = new DBServicesSelectionImpl(services);
            ArrayList<String> javaSvcNames = new ArrayList<String>();
            for (Service svc : svcsColl.getJavaServices()) {
                javaSvcNames.add(svc.getUserAssignedName());
            }
            Trace.out((Object)"Java services are : %s", ((Object)javaSvcNames).toString());
            if (!javaSvcNames.isEmpty()) {
                this.m_crsResource.update(cf.create(ResourceType.Database.JAVA_SERVICES.name(), oracle.cluster.impl.util.Utils.strListToList2(javaSvcNames)));
                this.m_crsResource.update(cf.create(ResourceType.Database.PATCH_IN_PROGRESS.name(), Boolean.TRUE.toString()));
                this.performEveryNodeStopActions(nodes);
            }
        }
        catch (InvalidArgsException | CRSException | DatabaseException | ServiceException e) {
            Trace.out("attempt to perform first node stop actions for OJVM patching failed with exception %s : %s", e.getClass().getName(), e);
            throw new DatabaseException(e);
        }
    }

    void performEveryNodeStopActions(List<String> nodes) throws InvalidArgsException, DatabaseException {
        block6: {
            if (nodes == null || nodes.isEmpty()) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBImpl-everyNodeStop-nodes");
            }
            try {
                String javaSvcAttr = this.m_crsResource.getAttribute(ResourceType.Database.JAVA_SERVICES.name()).getValue();
                Trace.out((Object)"Java services are : %s", javaSvcAttr);
                if (javaSvcAttr == null || javaSvcAttr.trim().isEmpty()) break block6;
                CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
                ArrayList<Service> javaSvcs = new ArrayList<Service>();
                for (String javaSvcName : javaSvcAttr.split(",")) {
                    javaSvcs.add(new CardinalServiceImpl(cf.create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(this.getUserAssignedName(), javaSvcName, false))));
                }
                Trace.out((Object)"disabling Java services on nodes %s ...", nodes.toString());
                DBServicesSelectionImpl svcsColl = new DBServicesSelectionImpl(javaSvcs, nodes, false);
                try {
                    svcsColl.disable();
                }
                catch (AlreadyDisabledException ade) {
                    Trace.out("ignoring already disabled Java services : %s", ade);
                }
                Trace.out((Object)"disabled Java services on nodes %s ...", nodes.toString());
            }
            catch (InvalidArgsException | CRSException | ServiceException | CompositeOperationException e) {
                Trace.out("attempt to perform every node stop actions for OJVM patching failed with exception %s : %s", e.getClass().getName(), e);
                throw new DatabaseException(e);
            }
        }
    }

    void performLastNodeStopActions() throws DatabaseException {
        block7: {
            try {
                String javaSvcAttr = this.m_crsResource.getAttribute(ResourceType.Database.JAVA_SERVICES.name()).getValue();
                Trace.out((Object)"Java services are : %s", javaSvcAttr);
                if (javaSvcAttr == null || javaSvcAttr.trim().isEmpty()) break block7;
                CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
                ArrayList<Service> javaSvcs = new ArrayList<Service>();
                for (String javaSvcName : javaSvcAttr.split(",")) {
                    javaSvcs.add(new CardinalServiceImpl(cf.create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(this.getUserAssignedName(), javaSvcName, false))));
                }
                DBServicesSelectionImpl svcsColl = new DBServicesSelectionImpl(javaSvcs);
                Trace.out("globally disabling Java services to clear out the PerX settings ...");
                try {
                    svcsColl.disable();
                }
                catch (AlreadyDisabledException ade) {
                    Trace.out("ignoring already disabled Java services : %s", ade);
                }
                Trace.out("globally disabled Java services");
                try {
                    svcsColl.enable();
                }
                catch (AlreadyEnabledException aee) {
                    Trace.out("ignoring already enabled Java services : %s", aee);
                }
                Trace.out("globally enabled Java services");
            }
            catch (InvalidArgsException | CRSException | ServiceException | CompositeOperationException e) {
                Trace.out("attempt to perform last node stop actions for OJVM patching failed with exception %s : %s", e.getClass().getName(), e);
                throw new DatabaseException(e);
            }
        }
    }

    void performLastNodeStartActions() throws DatabaseException {
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            String javaSvcAttr = this.m_crsResource.getAttribute(ResourceType.Database.JAVA_SERVICES.name()).getValue();
            Trace.out((Object)"Java services are : %s", javaSvcAttr);
            if (javaSvcAttr != null && !javaSvcAttr.trim().isEmpty()) {
                ArrayList<Service> javaSvcs = new ArrayList<Service>();
                for (String javaSvcName : javaSvcAttr.split(",")) {
                    javaSvcs.add(new CardinalServiceImpl(cf.create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(this.getUserAssignedName(), javaSvcName, false))));
                }
                DBServicesSelectionImpl svcsColl = new DBServicesSelectionImpl(javaSvcs);
                Trace.out("starting previously disabled Java services ...");
                try {
                    svcsColl.start();
                }
                catch (ServiceException | AlreadyRunningException | CompositeOperationException ie) {
                    Trace.out("ignoring already running Java services : %s", ie);
                }
                Trace.out("started Java services");
            }
            this.m_crsResource.update(cf.create(ResourceType.Database.JAVA_SERVICES.name(), ""));
            this.m_crsResource.update(cf.create(ResourceType.Database.PATCH_IN_PROGRESS.name(), Boolean.FALSE.toString()));
        }
        catch (InvalidArgsException | CRSException | ServiceException e) {
            Trace.out("attempt to perform last node start actions for OJVM patching failed with exception %s : %s", e.getClass().getName(), e);
            throw new DatabaseException(e);
        }
    }

    Map<String, String> getInstanceStateDetails() throws DatabaseException {
        try {
            HashMap<String, String> retval = new HashMap<String, String>();
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Filter nameFilter = FilterFactoryImpl.getFilter4ResourceName(this.getName());
            Filter searchFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, nameFilter, FilterFactoryImpl.getFilter4RunningState());
            Trace.out((Object)"searching for instances using filter : %s ...", searchFilter.toString());
            Map<String, Map<String, String>> result = cf.searchEntities(CRSEntity.Type.ResourceInstance, false, searchFilter, ResourceLiterals.STATE_DETAILS.name(), ResourceLiterals.CRS_LAST_SERVER.toString());
            Trace.out((Object)"online instances are : %s", result.toString());
            for (String inst : result.keySet()) {
                Trace.out((Object)"getting details of instance %s ...", inst);
                Map<String, String> val = result.get(inst);
                retval.put(val.get(ResourceLiterals.CRS_LAST_SERVER.toString()), val.get(ResourceLiterals.STATE_DETAILS.toString()));
            }
            return retval;
        }
        catch (CRSException e) {
            Trace.out("attempt to retrieve STATE_DETAILS of instances failed with exception %s : %s", e.getClass().getName(), e);
            throw new DatabaseException(e);
        }
    }

    Map<String, Map<String, String>> getInstancesRunningFromOldHome(List<String> attrList) throws InvalidArgsException, DatabaseException {
        if (attrList == null || attrList.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBImpl-getInstFromOldHome-attrs");
        }
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Filter nameFilter = FilterFactoryImpl.getFilter4ResourceName(this.getName());
            String oldHome = this.m_crsResource.getAttribute(ResourceType.Database.ORACLE_HOME_OLD.name()).getValue();
            Filter oldHomeFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.STATE_DETAILS.name(), STATE_DETAILS_HOME_KEY + oldHome);
            Filter searchFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, nameFilter, FilterFactoryImpl.getFilter4RunningState());
            searchFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, searchFilter, oldHomeFilter);
            Trace.out((Object)"searching for instances using filter : %s ...", searchFilter.toString());
            Map<String, Map<String, String>> result = cf.searchEntities(CRSEntity.Type.ResourceInstance, false, searchFilter, attrList.toArray(new String[0]));
            Trace.out((Object)"instances running from old Oracle home are : %s", result.toString());
            return result;
        }
        catch (CRSException e) {
            Trace.out("attempt to retrieve instances running from old home failed with exception %s : %s", e.getClass().getName(), e);
            throw new DatabaseException(e);
        }
    }

    Map<String, Map<String, String>> getOnlineInstances(List<String> nodes, List<String> attrList) throws InvalidArgsException, DatabaseException {
        if (attrList == null || attrList.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBImpl-getOnlineInsts-attrs");
        }
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Filter nameFilter = FilterFactoryImpl.getFilter4ResourceName(this.getName());
            Filter searchFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, nameFilter, FilterFactoryImpl.getFilter4RunningState());
            if (nodes != null && !nodes.isEmpty()) {
                searchFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, searchFilter, DBFilterFactory.getFilter4Nodes(nodes));
            }
            Trace.out((Object)"searching for instances using filter : %s ...", searchFilter.toString());
            Map<String, Map<String, String>> result = cf.searchEntities(CRSEntity.Type.ResourceInstance, false, searchFilter, attrList.toArray(new String[0]));
            Trace.out((Object)"online instances are : %s", result.toString());
            return result;
        }
        catch (CRSException e) {
            Trace.out("attempt to retrieve online instances failed with exception %s : %s", e.getClass().getName(), e);
            throw new DatabaseException(e);
        }
    }

    protected void waitForDrainCompletion(String drainID, int waitTime, Map<String, String> nodeSvcMap, VerboseListener vlsnr) throws DatabaseException {
        if (nodeSvcMap != null && nodeSvcMap.size() > 0) {
            ArrayList<Node> dnodeList = new ArrayList<Node>();
            ArrayList<String> svcNames = new ArrayList<String>();
            try {
                ServerFactory sf = ServerFactory.getInstance();
                for (Map.Entry<String, String> entry : nodeSvcMap.entrySet()) {
                    String nodeName = entry.getKey();
                    dnodeList.add(sf.getNode(nodeName));
                    String svc = entry.getValue();
                    if (svcNames.contains(svc)) continue;
                    svcNames.add(svc);
                }
            }
            catch (NodeException e) {
                throw new DatabaseException(e);
            }
            catch (ServerException e) {
                throw new DatabaseException(e);
            }
            Trace.out("Maximum waiting time allowed = " + waitTime + " seconds. Proceed to drain action");
            CompositeDatabaseActionStatus compResult = null;
            int wIntvl = waitTime < 20 ? waitTime : 20;
            for (int i = 0; i <= waitTime; ++i) {
                if (i % wIntvl == 0 || i == waitTime) {
                    if (dnodeList.size() > 0) {
                        Trace.out("Size of node list not 0=" + dnodeList.size());
                        try {
                            Trace.out("Initiating drain action trial at " + i + " seconds");
                            compResult = this.m_DbAction.drainAction(dnodeList, svcNames, drainID);
                        }
                        catch (DatabaseException e) {
                            Trace.out("Report error obtained during drain action " + e.getMessage());
                            throw e;
                        }
                    }
                    if (compResult != null) {
                        Map<Node, DatabaseActionStatus> result = compResult.getAllDatabaseActionStatus();
                        for (Map.Entry<Node, DatabaseActionStatus> pairs : result.entrySet()) {
                            DatabaseActionStatus nodeRes = pairs.getValue();
                            String nodeName = null;
                            try {
                                nodeName = pairs.getKey().getName();
                            }
                            catch (NodeException e) {
                                Trace.out("Ignoring as it might lead to command failure on  other nodes " + e.getMessage());
                                continue;
                            }
                            Integer count = nodeRes.getSessionCount();
                            if (count == 0) {
                                if (vlsnr != null) {
                                    vlsnr.write(MessageBundle.getMessage(PrCdMsgID.DRAIN_COMPLETE, false, nodeName, nodeSvcMap.get(nodeName)));
                                }
                                dnodeList.remove(pairs.getKey());
                                Trace.out("Removed node " + nodeName + " from node list");
                                continue;
                            }
                            if (vlsnr == null) continue;
                            vlsnr.write(MessageBundle.getMessage(PrCdMsgID.DRAIN_IN_PROGRESS, false, nodeName, nodeSvcMap.get(nodeName), count));
                        }
                    }
                    if (dnodeList.size() == 0) {
                        Trace.out("Drain completed before wait timeout, proceed to db stop");
                        break;
                    }
                }
                if (i == waitTime) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new DatabaseException(e);
                }
            }
        }
    }

    @Override
    public void startMonitor() throws DatabaseException, CompositeActionException {
        this.m_DbAction.monitorAction();
    }

    @Override
    public void stopMonitor() throws DatabaseException, CompositeActionException {
        this.m_DbAction.unmonitorAction();
    }

    @Override
    public void updateCSSCritical(CRSResource.CSSCritical option) throws InvalidArgsException, DatabaseException {
        if (option == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-updateCSSCritical-01");
        }
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-updateCSSCritical-02");
        }
        if (!this.isAdminManaged()) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CSS_CRITICAL_NA, this.getUserAssignedName());
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.CSS_CRITICAL.name(), option.toString()));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_CSS_CRITICAL_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public boolean isCSSCritical() throws DatabaseException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-isCSSCritical-01");
        }
        try {
            String val = this.m_crsResource.getAttribute(ResourceType.Database.CSS_CRITICAL.name()).getValue();
            Trace.out((Object)"CSS_CRITICAL's value is %s", val);
            return CRSResource.CSSCritical.getEnumMember(val) == CRSResource.CSSCritical.YES;
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_CSS_CRITICAL_FAILED, (Throwable)e, this.getName());
        }
        catch (EnumConstNotFoundException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_CSS_CRITICAL_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public void setCPUCount(int count) throws DatabaseException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-setCPUCount-01");
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.WORKLOAD_CPU.name(), Integer.toString(count)));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_CPU_COUNT_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public int getCPUCount() throws DatabaseException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-getCPUCount-01");
        }
        try {
            String val = this.m_crsResource.getAttribute(ResourceType.Database.WORKLOAD_CPU.name()).getValue();
            Trace.out((Object)"WORKLOAD_CPU's value is %s", val);
            return Integer.parseInt(val);
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_CPU_COUNT_FAILED, (Throwable)e, this.getName());
        }
        catch (NumberFormatException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_CPU_COUNT_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public void setDefaultNetwork(Network defaultNetwork) throws DatabaseException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-setDefNetNum-01");
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.DEFAULT_NETNUM.name(), Integer.toString(defaultNetwork.getNumber())));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_DEF_NETNUM_FAILED, (Throwable)e, this.getName());
        }
        catch (NetworkException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_DEF_NETNUM_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public Network getDefaultNetwork() throws DatabaseException, NotExistsException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-getDefNetNum-01");
        }
        try {
            String val = this.m_crsResource.getAttribute(ResourceType.Database.DEFAULT_NETNUM.name()).getValue();
            Trace.out((Object)"Default netnum for services value is %s", val);
            if (val == null || val.isEmpty()) {
                throw new NotExistsException((MessageKey)PrCdMsgID.GET_DEF_NETNUM_FAILED, this.getName());
            }
            NodeAppsFactory nFact = NodeAppsFactory.getInstance();
            return nFact.getNetwork(Integer.parseInt(val));
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DEF_NETNUM_FAILED, (Throwable)e, this.getName());
        }
        catch (NumberFormatException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DEF_NETNUM_FAILED, (Throwable)e, this.getName());
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DEF_NETNUM_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public void setMemoryTarget(int target) throws DatabaseException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-setMemTgt-01");
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.WORKLOAD_MEMORY_TARGET.name(), Integer.toString(target)));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_MEM_TARGET_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public int getMemoryTarget() throws DatabaseException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-getMemTgt-01");
        }
        try {
            String val = this.m_crsResource.getAttribute(ResourceType.Database.WORKLOAD_MEMORY_TARGET.name()).getValue();
            Trace.out((Object)"WORKLOAD_MEMORY_TARGET's value is %s", val);
            return Integer.parseInt(val);
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_MEM_TARGET_FAILED, (Throwable)e, this.getName());
        }
        catch (NumberFormatException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_MEM_TARGET_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public void setMaxMemory(int maxMem) throws DatabaseException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-setMaxMem-01");
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.WORKLOAD_MEMORY_MAX.name(), Integer.toString(maxMem)));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_MAX_MEM_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public int getMaxMemory() throws DatabaseException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-getMaxMem-01");
        }
        try {
            String val = this.m_crsResource.getAttribute(ResourceType.Database.WORKLOAD_MEMORY_MAX.name()).getValue();
            Trace.out((Object)"WORKLOAD_MEMORY_MAX's value is %s", val);
            return Integer.parseInt(val);
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_MAX_MEM_FAILED, (Throwable)e, this.getName());
        }
        catch (NumberFormatException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_MAX_MEM_FAILED, (Throwable)e, this.getName());
        }
    }

    @Override
    public void setCPUCap(int cpuCap) throws DatabaseException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-setCPUCap-01");
        }
    }

    @Override
    public int getCPUCap() throws DatabaseException {
        if (this.m_crsResource == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-getCPUCap-01");
        }
        try {
            String val = this.m_crsResource.getAttribute(ResourceType.Database.WORKLOAD_CPU_CAP.name()).getValue();
            Trace.out((Object)"WORKLOAD_CPU_CAP's value is %s", val);
            return Integer.parseInt(val);
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_CPU_CAP_FAILED, (Throwable)e, this.getName());
        }
        catch (NumberFormatException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_CPU_CAP_FAILED, (Throwable)e, this.getName());
        }
    }

    static DatabaseStopArgs createDBStopArgs(DatabaseOptionalArgs args) throws InvalidArgsException {
        if (args == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-createDBStopArgs-1");
        }
        Boolean force = args.getForceFlag();
        Integer drainTime = args.getDrainTimeout();
        Integer stopTime = args.getStopTimeout();
        Integer concurrency = args.getStopConcurrency();
        DatabaseStopArgs stopArgs = new DatabaseStopArgs();
        stopArgs.setStopModes(args.getStopModes());
        stopArgs.setVerboseListener(args.getVerboseListener());
        if (concurrency != null) {
            stopArgs.setStopConcurrency(concurrency);
        }
        if (force != null) {
            stopArgs.setForceFlag(force);
        }
        if (drainTime != null) {
            stopArgs.setDrainTimeout(drainTime);
        }
        if (stopTime != null) {
            stopArgs.setStopTimeout(stopTime);
        }
        return stopArgs;
    }

    protected DatabaseAction getDBAction() {
        return this.m_DbAction;
    }

    private void checkGlobalServices(List<Service> services, Filter svcFilter, boolean global) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        try {
            if (services != null) {
                for (Service svc : services) {
                    if (svc.isGlobal() && !global) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(svc.getUserAssignedName());
                    }
                    Trace.out("Droppping Service :" + svc.getUserAssignedName());
                }
            } else if (svcFilter != null) {
                Filter globalF = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQI, ResourceType.Service.GLOBAL.name(), "true");
                Filter filter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, svcFilter, globalF);
                List<ResourceAttribute> resList = CRSFactoryImpl.getInstance().searchResources((CRSResourceImpl)this.crsResource(), CRSEntity.Type.Resource, filter);
                if (!global && resList.size() > 0) {
                    for (ResourceAttribute res : resList) {
                        String[] values = res.getValue().split(Pattern.quote(String.valueOf('.')));
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(values[2]);
                        Trace.out("Considering service as global: " + values[2]);
                    }
                }
            }
            if (sb.length() > 0) {
                throw new DatabaseException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, sb.toString());
            }
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.IS_SVC_GLOBAL_FAILED, (Throwable)e, sb.length() > 0 ? sb.toString() : "");
        }
        catch (NotExistsException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.IS_SVC_GLOBAL_FAILED, (Throwable)e, sb.length() > 0 ? sb.toString() : "");
        }
        catch (ServiceException e) {
            Trace.out(e);
            throw new DatabaseException((MessageKey)PrCdMsgID.IS_SVC_GLOBAL_FAILED, (Throwable)e, sb.length() > 0 ? sb.toString() : "");
        }
    }

    private void validateSvcNames(Filter filter, List<String> services, boolean checkPQ) throws DatabaseException {
        if (filter == null || services == null) {
            Trace.out("Null args received");
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseImpl-valSvcNamesiforPQ-1");
        }
        StringBuilder resInvalid = new StringBuilder();
        String startsWith = this.getStartsWith();
        String endsWith = '.' + ResourceLiterals.SVC.toString();
        ArrayList<String> resPresentList = new ArrayList<String>();
        Filter svcFilter = filter;
        try {
            String resNeeded;
            List<ResourceAttribute> resList;
            if (checkPQ) {
                Filter pqFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceType.Service.SERVICE_TYPE.name(), ServiceType.PQ.toString());
                svcFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, filter, pqFilter);
            }
            if ((resList = CRSFactoryImpl.getInstance().searchResources((CRSResourceImpl)this.crsResource(), CRSEntity.Type.Resource, svcFilter)).size() > 0) {
                StringBuilder resNames = new StringBuilder();
                for (ResourceAttribute res : resList) {
                    resPresentList.add(res.getValue());
                }
                Trace.out("Resources identified :" + Arrays.toString(resPresentList.toArray()));
            }
            if (checkPQ) {
                if (resList.size() > 0) {
                    for (String svc : services) {
                        resNeeded = startsWith + svc + endsWith;
                        Trace.out("Searching for resource " + resNeeded);
                        if (!resPresentList.contains(resNeeded.toLowerCase())) continue;
                        if (resInvalid.length() > 0) {
                            resInvalid.append(",");
                        }
                        resInvalid.append(svc);
                    }
                    if (resInvalid.length() > 0) {
                        Trace.out("PQ resource in input : " + resInvalid.toString());
                        throw new DatabaseException((MessageKey)PrCdMsgID.PQ_SERVICE_NOT_ALLOWED, resInvalid.toString());
                    }
                }
                return;
            }
            for (String svc : services) {
                resNeeded = startsWith + svc + endsWith;
                Trace.out("Searching for resource " + resNeeded);
                if (resPresentList.contains(resNeeded.toLowerCase())) continue;
                if (resInvalid.length() > 0) {
                    resInvalid.append(",");
                }
                resInvalid.append(svc);
            }
            if (resInvalid.length() > 0) {
                Trace.out("Invalid resource in input : " + resInvalid.toString());
                throw new DatabaseException((MessageKey)PrCdMsgID.DB_START_WRONG_SERVICES, this.getUserAssignedName(), resInvalid.toString());
            }
            return;
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new DatabaseException(e);
        }
        catch (NotExistsException e) {
            Trace.out(e);
            throw new DatabaseException(e);
        }
    }

    private static final class DBIComparator
    implements Comparator<DatabaseInstance> {
        private DBIComparator() {
        }

        @Override
        public int compare(DatabaseInstance o1, DatabaseInstance o2) {
            DatabaseInstanceImpl dbi1 = (DatabaseInstanceImpl)o1;
            DatabaseInstanceImpl dbi2 = (DatabaseInstanceImpl)o2;
            return dbi1.getUserAssignedName().compareTo(dbi2.getUserAssignedName());
        }
    }

    private class SWHelper {
        CRSResourceImpl sw_crsResource;
        String sw_name;

        SWHelper(ResourceAttribute attr) throws CRSException {
            this.sw_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().getRegisteredOrNot(attr);
            this.sw_name = attr.getValue();
        }

        ResourceAttribute serverGroup() throws CRSException {
            return this.sw_crsResource.getAttribute(ResourceType.Service.SERVER_POOLS.name());
        }

        void remove(boolean force) throws CRSException {
            this.sw_crsResource.remove(force);
        }

        String getName() {
            return this.sw_name;
        }
    }

    private static enum NtUserTypeEnum {
        VIRTUALACCOUNT,
        BUILTINACCOUNT,
        LOWPRIVLOCALUSER,
        LOWPRIVDOMAINUSER;

    }
}

