/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import oracle.cluster.crs.ActionListener;
import oracle.cluster.crs.ActionMessage;
import oracle.cluster.crs.ActionResult;
import oracle.cluster.impl.database.CompositeDatabaseActionStatus;
import oracle.cluster.impl.database.DatabaseActionStatus;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.trace.Trace;

public class DatabaseActionListener
implements ActionListener {
    private CompositeDatabaseActionStatus m_compStat;
    private static final String STAT_MONITORING = "MONITORING";
    private static final String STAT_UNMONITOR = "STOPPED";

    public DatabaseActionListener(CompositeDatabaseActionStatus compStat) {
        this.m_compStat = compStat;
    }

    @Override
    public void notifyActionResult(ActionResult ar) {
    }

    @Override
    public void notifyActionMessage(Node node, ActionMessage am) {
        boolean isError = false;
        ActionMessage.Type msgtype = am.getType();
        String msg = am.getMessage();
        Trace.out("msg = " + msg);
        DatabaseActionStatus das = this.m_compStat.getDatabaseActionStatus(node);
        if (das == null) {
            Trace.out("add DB status for node " + node);
            das = new DatabaseActionStatus();
            this.m_compStat.addDatabaseActionStatus(node, das);
        }
        if (msgtype == ActionMessage.Type.ACTION_MESSAGE_INFO) {
            String[] targets;
            for (String target : targets = msg.split(":")) {
                String[] contents = target.split("#");
                if (contents.length != 3) {
                    Trace.out("Contents format of progress msg is wrong. Discarding it.");
                    continue;
                }
                String name = contents[1];
                String stat = contents[2];
                if (!stat.equals(STAT_MONITORING) && !stat.equals(STAT_UNMONITOR)) continue;
                Trace.out("Action %s for instance %s was executedproperly", stat, name);
            }
            das.setMessage(msg);
        } else if (msgtype == ActionMessage.Type.ACTION_MESSAGE_WARNING) {
            das.setWarning(msg);
        } else if (msgtype == ActionMessage.Type.ACTION_MESSAGE_ERROR) {
            if (msg.contains("CRS-5033")) {
                das.setError(101, msg);
            } else {
                das.setError(100, msg);
            }
        }
    }
}

