/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.common.NotSupportedException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.ActionAttribute;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.database.AlreadyInOptionException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.IncompatibleOptionException;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.Service;
import oracle.cluster.database.StartOptions;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.CardinalDatabaseImpl;
import oracle.cluster.impl.database.CompositeDatabaseActionStatus;
import oracle.cluster.impl.database.DatabaseActionListener;
import oracle.cluster.impl.database.DatabaseActionStatus;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class DatabaseAction {
    private Database m_db = null;
    private CompositeDatabaseActionStatus m_cdas;
    private String m_resName = "";
    private static final String ACTION_START_OPTION = "startoption";
    private static final String ACTION_START_TARGET = "start_target";
    private static final String ACTION_DRAIN = "serviceDrain";
    private static final String ACTION_ISJAVA = "isJavaService";
    private static final String TARGET_DATABASE = "database";
    private static final String TARGET_INSTANCE = "instance";
    private static final String TARGET_ALL = "all";
    static final String ACTIONS_USER = "user:";
    static final String ACTIONS_GROUP = "group:";
    static final String ACTION_MONITOR = "monitor";
    static final String ACTION_UNMONITOR = "unmonitor";
    static final String ACTION_RELOCATE_CLIENT = ResourceLiterals.RELOCATE_CLIENT.toString();

    DatabaseAction(Database db) throws DatabaseException {
        this.m_db = db;
        this.m_resName = db.getName();
        this.m_cdas = new CompositeDatabaseActionStatus();
        Trace.out("Created Database Action");
    }

    public void startAction(StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, DatabaseException {
        try {
            this.innerStartAction(soArr, null);
        }
        catch (NotRunningException e) {
            throw new DatabaseException(e);
        }
    }

    public void startAction(String nodeName, StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, NotRunningException, DatabaseException {
        Node node = null;
        try {
            node = ServerFactory.getInstance().getNode(nodeName);
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(node);
        this.innerStartAction(soArr, nodes);
    }

    public void startAction(Node node, StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, NotRunningException, DatabaseException {
        if (node == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseaction-start01");
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(node);
        this.innerStartAction(soArr, nodes);
    }

    public void startAction(StartOptions[] soArr, String instName) throws IncompatibleOptionException, AlreadyInOptionException, DatabaseException {
        if (instName == null || instName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseaction-start02");
        }
        try {
            List<DatabaseInstance> insts = this.m_db.instances();
            for (DatabaseInstance inst : insts) {
                if (!inst.getUserAssignedName().equalsIgnoreCase(instName)) continue;
                ArrayList<Node> nodes = new ArrayList<Node>();
                nodes.add(inst.node());
                this.innerStartAction(soArr, nodes);
                return;
            }
            throw new DatabaseException((MessageKey)PrCdMsgID.NO_INSTANCES_FOUND, this.m_resName, instName);
        }
        catch (InstanceException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        catch (NotRunningException e) {
            throw new DatabaseException(e);
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
    }

    public void startAction(List<ServerPool> spList, StartOptions[] soArr) throws InvalidArgsException, IncompatibleOptionException, AlreadyInOptionException, NotRunningException, NotSupportedException, DatabaseException {
        if (spList == null || spList.isEmpty() || spList.contains(null) || soArr == null || Arrays.asList(soArr).contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseAction-startAction05");
        }
        DatabaseType dbType = this.m_db.databaseType();
        if (this.m_db.isAdminManaged() || !Cluster.isCluster()) {
            throw new NotSupportedException((MessageKey)PrCdMsgID.SP_OPERATION_NOT_SUPPORTED, this.m_db.getUserAssignedName());
        }
        List<Node> nodes = ((CardinalDatabaseImpl)this.m_db).validateServerPools(spList);
        this.innerStartAction(soArr, nodes);
    }

    private void innerStartAction(StartOptions[] soArr, List<Node> nodes) throws IncompatibleOptionException, AlreadyInOptionException, NotRunningException, DatabaseException {
        if (soArr == null || soArr.length == 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseaction-start03");
        }
        String nodeName = "";
        try {
            String actionName = ACTION_START_OPTION;
            ActionAttribute attrStartOpt = new ActionAttribute(ResourceType.Database.ACTION_START_OPTION.name(), soArr[0].toString());
            ActionAttribute[] attrs = new ActionAttribute[]{attrStartOpt};
            CRSResourceImpl crsRes = (CRSResourceImpl)this.m_db.crsResource();
            DatabaseActionListener daLsnr = new DatabaseActionListener(this.m_cdas);
            if (nodes == null) {
                if (!this.m_db.isRunning()) {
                    throw new NotRunningException((MessageKey)PrCrMsgID.RES_NOT_RUNNING, this.m_resName);
                }
                crsRes.requestAction(actionName, attrs, daLsnr);
            } else {
                List<Node> onlineNodes = crsRes.fetchRunningNodes();
                StringBuilder sb = new StringBuilder();
                for (Node node : nodes) {
                    if (onlineNodes.contains(node)) continue;
                    if (sb.length() == 0) {
                        sb.append(node.getName());
                        continue;
                    }
                    sb.append("," + node.getName());
                }
                if (sb.length() > 0) {
                    throw new NotRunningException((MessageKey)PrCrMsgID.CRS_RES_NOT_RUNNING_NODE, this.m_resName, sb.toString());
                }
                Node[] nodesArr = new Node[nodes.size()];
                nodes.toArray(nodesArr);
                crsRes.requestAction(actionName, attrs, nodesArr, daLsnr);
            }
            Trace.out("Start action completed");
            if (this.m_cdas.isSuccess()) {
                return;
            }
            if (this.m_cdas.isWarning()) {
                throw new AlreadyInOptionException((MessageKey)PrCdMsgID.ALREADY_IN_DESIRED_START_MODE, this.m_cdas.getWarningMessage());
            }
            if (this.m_cdas.isError(101)) {
                throw new IncompatibleOptionException((MessageKey)PrCdMsgID.INCOMPATIBLE_START_OPTION, this.m_cdas.getErrorMessage(101));
            }
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED_DETAILS, this.m_resName, this.m_cdas.getErrorMessage(100));
        }
        catch (NotRunningException e) {
            throw new NotRunningException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        catch (NodeException e) {
            throw new NotRunningException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        catch (AlreadyInOptionException e) {
            throw new AlreadyInOptionException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        catch (IncompatibleOptionException e) {
            throw new IncompatibleOptionException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        catch (CompositeActionException e) {
            if (this.m_cdas.isError()) {
                throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED_DETAILS, (Throwable)e, this.m_resName, this.m_cdas.getErrorMessage(100));
            }
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, this.m_resName);
        }
    }

    protected boolean isJavaServiceAction(List<Node> nodes, Service svc) throws DatabaseException {
        if (svc == null) {
            Trace.out("Invalid argument : svc null");
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DA-isJavaService001");
        }
        if (nodes == null || nodes.size() == 0) {
            Trace.out("Invalid argument : nodes null or empty");
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DA-isJavaService002");
        }
        String serviceStr = svc.getUserAssignedName();
        if (serviceStr == null) {
            Trace.out("Failed to operate on service resource..");
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DA-isJavaService003");
        }
        Trace.out("Performing isJavaService action on service: " + serviceStr);
        try {
            ActionAttribute[] attrs = new ActionAttribute[]{new ActionAttribute(ResourceType.Service.NAME.name(), serviceStr)};
            Node[] nodesArr = new Node[nodes.size()];
            nodes.toArray(nodesArr);
            CRSResourceImpl crsRes = (CRSResourceImpl)svc.crsResource();
            DatabaseActionListener daLsnr = new DatabaseActionListener(this.m_cdas);
            Trace.out("Requesting Action..");
            crsRes.requestAction(ACTION_ISJAVA, attrs, nodesArr, daLsnr);
            Trace.out("Request Action completed");
        }
        catch (NotExistsException e) {
            Trace.out("Exception: NotExistsException " + e.getMessage());
            throw new DatabaseException((MessageKey)PrCdMsgID.ISJAVASERVICE_ACTION_NOT_RUN, (Throwable)e, serviceStr);
        }
        catch (CompositeActionException e) {
            Trace.out("Exception: CompositeActionException " + e.getMessage());
            throw new DatabaseException((MessageKey)PrCdMsgID.ISJAVASERVICE_ACTION_NOT_RUN, (Throwable)e, serviceStr);
        }
        catch (SoftwareModuleException e) {
            Trace.out("Exception: SoftwareModuleException" + e.getMessage());
            throw new DatabaseException((MessageKey)PrCdMsgID.ISJAVASERVICE_ACTION_NOT_RUN, (Throwable)e, serviceStr);
        }
        if (this.m_cdas.isError()) {
            Trace.out("Requested action isJavaService ressulted in exception..");
            throw new DatabaseException((MessageKey)PrCdMsgID.ISJAVASERVICE_ACTION_FAILED, serviceStr, this.m_resName, this.m_cdas.getErrorMessage());
        }
        Map<Node, DatabaseActionStatus> result = this.m_cdas.getAllDatabaseActionStatus();
        if (result.isEmpty()) {
            Trace.out("The result set obtained from service action checkJavaService is empty");
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DA-isJavaService005");
        }
        boolean isJava = false;
        ManageableEntityException dbe = null;
        for (Map.Entry<Node, DatabaseActionStatus> pairs : result.entrySet()) {
            DatabaseActionStatus nodeRes = pairs.getValue();
            Trace.out("Processing result: \n" + nodeRes.getMessage());
            try {
                isJava = nodeRes.getIsJavaServiceStatus();
            }
            catch (DatabaseException de) {
                Trace.out("Ignoring Exception during result processing ");
                dbe = de;
            }
            if (!isJava) continue;
            break;
        }
        if (!isJava && dbe != null) {
            Trace.out("Ignoring Exception during result processing: " + dbe.getMessage());
            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_ACTION_RESULT, (Throwable)dbe, ACTION_ISJAVA);
        }
        return isJava;
    }

    protected CompositeDatabaseActionStatus drainAction(List<Node> nodeList, List<String> svcNames, String drainID) throws DatabaseException {
        if (nodeList.size() == 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseaction-drainAction");
        }
        try {
            String actionName = ACTION_DRAIN;
            ActionAttribute[] attrs = new ActionAttribute[]{new ActionAttribute(ResourceType.Database.DRAIN_ID.name(), drainID), new ActionAttribute(ResourceType.Database.SERVICE_NAMES.name(), Utils.getString(svcNames, ","))};
            CRSResourceImpl crsRes = (CRSResourceImpl)this.m_db.crsResource();
            DatabaseActionListener daLsnr = new DatabaseActionListener(this.m_cdas);
            Node[] nodes = new Node[nodeList.size()];
            crsRes.requestAction(actionName, attrs, nodeList.toArray(nodes), daLsnr);
            return this.m_cdas;
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED, (Throwable)e, Utils.getString(svcNames, ","), this.m_resName);
        }
        catch (CompositeActionException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED, (Throwable)e, Utils.getString(svcNames, ","), this.m_resName);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED, (Throwable)e, svcNames, this.m_resName);
        }
    }

    public void monitorAction() throws DatabaseException, CompositeActionException {
        this.internalMonitor(true);
    }

    public void unmonitorAction() throws DatabaseException, CompositeActionException {
        this.internalMonitor(false);
    }

    private void internalMonitor(boolean isMonitorAction) throws DatabaseException, CompositeActionException {
        try {
            String actionName = isMonitorAction ? ACTION_MONITOR : ACTION_UNMONITOR;
            ActionAttribute[] attrs = new ActionAttribute[]{new ActionAttribute(ResourceType.Database.NAME.name(), this.m_resName)};
            CRSResourceImpl crsRes = (CRSResourceImpl)this.m_db.crsResource();
            DatabaseActionListener daLsnr = new DatabaseActionListener(this.m_cdas);
            crsRes.requestAction(actionName, attrs, daLsnr);
            Trace.out("Action " + actionName + " was successful. Message:" + this.m_cdas.getSuccessMessage());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)(isMonitorAction ? PrCdMsgID.MONITOR_ACTION_FAILED : PrCdMsgID.UNMONITOR_ACTION_FAILED), (Throwable)e, this.m_resName);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)(isMonitorAction ? PrCdMsgID.MONITOR_ACTION_FAILED : PrCdMsgID.UNMONITOR_ACTION_FAILED), (Throwable)e, this.m_resName);
        }
    }
}

