/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.common.VerboseListener;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.database.DBServicesSelection;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceStopArgs;
import oracle.cluster.deployment.DBServiceOperationInfo;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.ExpressionFilter;
import oracle.cluster.impl.crs.cops.SimpleFilter;
import oracle.cluster.impl.database.Common;
import oracle.cluster.impl.database.CompositeDatabaseActionStatus;
import oracle.cluster.impl.database.DBFilterFactory;
import oracle.cluster.impl.database.DatabaseActionStatus;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class DBServicesSelectionImpl
implements DBServicesSelection {
    private List<String> m_dbNames = null;
    private List<Service> m_services = null;
    private List<String> m_nodes = null;
    private MessageBundle m_msgBndl = null;

    public DBServicesSelectionImpl(List<String> dbNames, List<String> nodes) throws InvalidArgsException {
        this.setDBNames(dbNames);
        this.setNodes(nodes);
        this.m_msgBndl = MessageBundle.getMessageBundle(PrCdMsgID.facility);
    }

    public DBServicesSelectionImpl(List<String> strList, boolean isNodes) throws InvalidArgsException {
        if (isNodes) {
            this.setNodes(strList);
        } else {
            this.setDBNames(strList);
        }
        this.m_msgBndl = MessageBundle.getMessageBundle(PrCdMsgID.facility);
    }

    public DBServicesSelectionImpl(List<Service> svcs) throws InvalidArgsException {
        this.setServices(svcs);
        this.m_msgBndl = MessageBundle.getMessageBundle(PrCdMsgID.facility);
    }

    public DBServicesSelectionImpl(List<Service> svcs, List<String> nodes, boolean dummy) throws InvalidArgsException {
        this.setServices(svcs);
        this.setNodes(nodes);
        this.m_msgBndl = MessageBundle.getMessageBundle(PrCdMsgID.facility);
    }

    private void setDBNames(List<String> dbNames) throws InvalidArgsException {
        if (dbNames == null || dbNames.isEmpty() || dbNames.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-setDBNames-1");
        }
        this.m_dbNames = dbNames;
    }

    private void setNodes(List<String> nodes) throws InvalidArgsException {
        Common.validateNodes(nodes);
        this.m_nodes = nodes;
    }

    private void setServices(List<Service> svcs) throws InvalidArgsException {
        if (svcs == null || svcs.isEmpty() || svcs.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-setServices-1");
        }
        this.m_services = svcs;
    }

    @Override
    public List<DBServiceOperationInfo> relocate(ServiceStopArgs args) throws InvalidArgsException, CompositeOperationException, NotRunningException, ServiceException {
        return this.internalRelocate(args, null, null, null);
    }

    @Override
    public List<DBServiceOperationInfo> relocate(String tgtNode, ServiceStopArgs args) throws InvalidArgsException, CompositeOperationException, NotRunningException, ServiceException {
        return this.internalRelocate(args, null, tgtNode, null);
    }

    @Override
    public List<DBServiceOperationInfo> relocate(List<String> avoidNodes, ServiceStopArgs args) throws InvalidArgsException, CompositeOperationException, NotRunningException, ServiceException {
        return this.internalRelocate(args, avoidNodes, null, null);
    }

    List<DBServiceOperationInfo> internalRelocate(ServiceStopArgs args, List<String> avoidNodes, String tgtNode, String drainID) throws InvalidArgsException, CompositeOperationException, NotRunningException, ServiceException {
        VerboseListener vlsnr;
        Integer drainTime;
        boolean isWait;
        ArrayList<DBServiceOperationInfo> retval;
        block57: {
            if (this.m_nodes == null) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-intenalrelocate-0");
            }
            if (args == null) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-intenalrelocate-1");
            }
            if (tgtNode != null && tgtNode.trim().isEmpty()) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-intenalrelocate-2");
            }
            if (avoidNodes != null && (avoidNodes.isEmpty() || avoidNodes.contains(null))) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-intenalrelocate-3");
            }
            if (tgtNode != null && avoidNodes != null) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-intenalrelocate-4");
            }
            retval = new ArrayList<DBServiceOperationInfo>();
            Boolean forceFlag = args.getForceFlag();
            boolean force = forceFlag != null && forceFlag != false;
            boolean ignorePreChecks = true;
            isWait = args.getWait() != null && args.getWait() != false;
            drainTime = args.getDrainTimeout();
            vlsnr = args.getVerboseListener();
            try {
                CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
                Filter svcsFilter = this.getFilter();
                svcsFilter = new ExpressionFilter(Filter.Operator.AND, svcsFilter, FilterFactoryImpl.getFilter4RunningState());
                if (this.m_nodes.size() == 1 && tgtNode != null) {
                    Trace.out("no need to determine target node");
                    if (drainTime == null) {
                        drainTime = Common.calculateMaxDrain(svcsFilter);
                    }
                    if (drainTime > 0) {
                        args.setDrainTimeout(drainTime);
                        if (drainID == null) {
                            drainID = Common.getDrainID();
                        }
                    }
                    List<ResourceAttribute> optionsList = ServiceImpl.getSvcStopOptions(args, drainID);
                    ResourceAttribute[] options = new ResourceAttribute[optionsList.size()];
                    optionsList.toArray(options);
                    HashMap<String, String> nodeResMap = new HashMap<String, String>();
                    Trace.out("relocating svcs to %s using filter %s", tgtNode, svcsFilter.toString());
                    CRSFactoryImpl.relocateResources(svcsFilter, tgtNode, force, options, nodeResMap);
                    for (String n : nodeResMap.keySet()) {
                        Trace.out((Object)"processing node %s ...", n);
                        String val = ((String)nodeResMap.get(n)).trim();
                        if (vlsnr != null) {
                            vlsnr.write(MessageBundle.getMessage(PrCdMsgID.RELOCATE_RES_NODE, false, val, n));
                        }
                        val = val.replaceAll("\\s+", "");
                        for (String resName : val.split(",")) {
                            Trace.out((Object)"processing service %s ...", resName);
                            String dbName = ServiceImpl.getDbNameFromSvcName(resName);
                            String svcName = ServiceImpl.getSvcNameFromResName(resName);
                            Trace.out("db unqiue name : %s ; service name : %s", dbName, svcName);
                            retval.add(new DBServiceOperationInfo(svcName, dbName, n, tgtNode));
                        }
                    }
                    Trace.out("relocated svcs");
                    break block57;
                }
                Trace.out("determining target nodes for relocating services ...");
                HashMap<String, Filter> tgtNodes = new HashMap<String, Filter>();
                List<Service> svcs = this.m_services != null ? this.m_services : this.getServices(svcsFilter);
                ServerFactory srvFact = ServerFactory.getInstance();
                Filter relocateFilter = null;
                block10: for (Service svc : svcs) {
                    String[] stringArray;
                    String resName = svc.getName();
                    Trace.out((Object)"determining target nodes for relocating service %s ...", resName);
                    if (!svc.isEnabled()) {
                        Trace.out((Object)"Service %s is globally disabled and cannot be relocated", resName);
                        continue;
                    }
                    Database db = svc.database();
                    if (db.databaseType() != DatabaseType.RAC) {
                        Trace.out((Object)"Service %s doesn't belong to a RAC database and will not be relocated", resName);
                        if (ignorePreChecks) {
                            Trace.out("ignoring error ...");
                            continue;
                        }
                        throw new ServiceException((MessageKey)PrCdMsgID.RELOCATE_SVC_SIDB, svc.getUserAssignedName(), db.getUserAssignedName());
                    }
                    ArrayList<String> runningNodes = new ArrayList<String>(Arrays.asList(Utils.nodeList2String(svc.crsResource().fetchRunningNodes(), ",").split(",")));
                    if (runningNodes == null || runningNodes.isEmpty()) {
                        Trace.out((Object)"Service %s is not running and will not be relocated", resName);
                        if (ignorePreChecks) {
                            Trace.out("ignoring error ...");
                            continue;
                        }
                        throw new NotRunningException((MessageKey)PrCrMsgID.CRS_RELOCATE_NOT_RUNNING, resName);
                    }
                    Trace.out("Service %s is running on nodes %s ...", resName, ((Object)runningNodes).toString());
                    ArrayList<String> srcNodes = new ArrayList<String>();
                    for (String onlineNode : runningNodes) {
                        if (!this.m_nodes.contains(onlineNode)) continue;
                        srcNodes.add(onlineNode);
                    }
                    Trace.out((Object)"source nodes are : %s ...", ((Object)srcNodes).toString());
                    if (srcNodes.isEmpty()) {
                        Trace.out((Object)"Svc %s is not running on any of the specified nodes and will not be relocated", resName);
                        if (ignorePreChecks) {
                            Trace.out("ignoring error ...");
                            continue;
                        }
                        throw new NotRunningException((MessageKey)PrCrMsgID.CRS_RES_NOT_RUNNING_NODE, resName, Utils.strListToList2(this.m_nodes));
                    }
                    if (!svc.isEnabled()) {
                        Trace.out((Object)"Service %s is globally disabled and will not be relocated", resName);
                        continue;
                    }
                    ArrayList<String> disabledNodes = new ArrayList<String>(Arrays.asList(Utils.nodeList2String(svc.getDisabledNodes(), ",").split(",")));
                    Trace.out("service %s is disabled on nodes %s ...", resName, ((Object)disabledNodes).toString());
                    ArrayList<String> dbDisabledNodes = new ArrayList<String>(Arrays.asList(Utils.nodeList2String(db.getDisabledNodes(), ",").split(",")));
                    Trace.out((Object)"database is disabled on nodes %s ...", ((Object)dbDisabledNodes).toString());
                    ServerGroup sg = svc.getServerGroup();
                    if (tgtNode != null) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = tgtNode;
                    } else {
                        stringArray = Utils.list2String(sg.servers(), ",").split(",");
                    }
                    ArrayList<String> potentialTgts = new ArrayList<String>(Arrays.asList(stringArray));
                    Trace.out((Object)"potential target nodes : %s ...", ((Object)potentialTgts).toString());
                    potentialTgts.removeAll(srcNodes);
                    potentialTgts.removeAll(runningNodes);
                    potentialTgts.removeAll(disabledNodes);
                    if (avoidNodes != null) {
                        potentialTgts.removeAll(avoidNodes);
                    }
                    for (String tgt : new ArrayList<String>(potentialTgts)) {
                        if (!dbDisabledNodes.contains(tgt)) continue;
                        Trace.out("Database %s is disabled on node %s ... checking if it is online on node %s ...", db.getName(), tgt, tgt);
                        if (db.isRunning(srvFact.getNode(tgt))) continue;
                        Trace.out("Database %s is disabled on node %s and is not running on the node ...Service %s cannot be relocated to node %s", db.getName(), tgt, resName, tgt);
                        potentialTgts.remove(tgt);
                    }
                    if (potentialTgts.isEmpty()) {
                        Trace.out((Object)"No servers are available for relocation of svc %s", resName);
                        if (ignorePreChecks) {
                            Trace.out("ignoring error ...");
                            continue;
                        }
                        throw new ServiceException((MessageKey)PrCdMsgID.RELOCATE_SVC_NO_TGT, resName);
                    }
                    Trace.out("Potential targets for svc %s are %s", resName, ((Object)potentialTgts).toString());
                    for (String srcNode : srcNodes) {
                        Filter svcFilter = FilterFactoryImpl.getFilter4ResourceName(resName);
                        svcFilter = new ExpressionFilter(Filter.Operator.AND, svcFilter, DBFilterFactory.getFilter4Nodes(Arrays.asList(srcNode)));
                        relocateFilter = relocateFilter == null ? svcFilter : new ExpressionFilter(Filter.Operator.OR, relocateFilter, svcFilter);
                        String tgt = (String)potentialTgts.get(0);
                        for (String key : potentialTgts) {
                            if (!tgtNodes.containsKey(key)) continue;
                            tgt = key;
                            break;
                        }
                        potentialTgts.remove(tgt);
                        Trace.out("Service %s will be relocated from %s to %s", resName, srcNode, tgt);
                        int cardinality = -1;
                        String cardAttr = ((CRSResourceImpl)svc.crsResource()).getAttribute(ResourceType.ClusterResource.CARDINALITY.name()).getValue().trim();
                        if (cardAttr.contains(ResourceLiterals.CRS_SERVER_POOL_SIZE_CARDINALITY.toString())) {
                            Trace.out("service is a policy-managed uniform service ... cardinality equals server pool size");
                            cardinality = sg.servers().size();
                        } else {
                            cardinality = Integer.parseInt(cardAttr);
                        }
                        Trace.out("cardinality of service %s : %d", resName, cardinality);
                        if (cardinality > 1 && runningNodes.size() < cardinality && !db.isRunning(srvFact.getNode(tgt))) {
                            Trace.out("Service %s is not a singleton service and db is not running on target node %s", resName, tgt);
                            svcFilter = new ExpressionFilter(Filter.Operator.AND, svcFilter, FilterFactoryImpl.getFilter4RunningState());
                            if (drainTime == null) {
                                String drainStr = svc.getDrainTimeout();
                                if (drainStr != null && !drainStr.trim().isEmpty() && Integer.parseInt(drainStr) > 0) {
                                    args.setDrainTimeout(Integer.parseInt(drainStr));
                                    drainID = drainID == null ? Common.getDrainID() : drainID;
                                }
                            } else if (drainTime > 0 && drainID == null) {
                                drainID = Common.getDrainID();
                            }
                            List<ResourceAttribute> optionsList = ServiceImpl.getSvcStopOptions(args, drainID);
                            ResourceAttribute[] options = new ResourceAttribute[optionsList.size()];
                            Trace.out("relocating service %s to %s using filter %s ...", resName, tgt, svcFilter.toString());
                            try {
                                CRSFactoryImpl.relocateResources(svcFilter, tgt, force, optionsList.toArray(options));
                            }
                            catch (CompositeOperationException e) {
                                Trace.out("attempt to relocate service %s to %s using filter %s failed with CompositeOperationException : %s", resName, tgt, svcFilter.toString(), e);
                                throw e;
                            }
                            if (vlsnr != null) {
                                vlsnr.write(MessageBundle.getMessage(PrCdMsgID.RELOCATE_RES_NODE, false, resName, srcNode));
                            }
                            String dbName = ServiceImpl.getDbNameFromSvcName(resName);
                            String svcName = ServiceImpl.getSvcNameFromResName(resName);
                            Trace.out("db unqiue name : %s ; service name : %s", dbName, svcName);
                            retval.add(new DBServiceOperationInfo(svcName, dbName, srcNode, tgt));
                            Trace.out("relocated service %s to %s using filter %s", resName, tgt, svcFilter.toString());
                        } else {
                            if (tgtNodes.containsKey(tgt)) {
                                svcFilter = new ExpressionFilter(Filter.Operator.OR, svcFilter, (Filter)tgtNodes.get(tgt));
                            }
                            tgtNodes.put(tgt, svcFilter);
                        }
                        Trace.out("remaining potential targets for svc %s are %s", resName, ((Object)potentialTgts).toString());
                        if (!potentialTgts.isEmpty()) continue;
                        continue block10;
                    }
                }
                if (relocateFilter == null) {
                    Trace.out("No services have to be relocated");
                    return retval;
                }
                relocateFilter = new ExpressionFilter(Filter.Operator.AND, relocateFilter, FilterFactoryImpl.getFilter4RunningState());
                Trace.out((Object)"created filter %s for relocating svcs", ((Object)relocateFilter).toString());
                if (drainTime == null) {
                    drainTime = Common.calculateMaxDrain(relocateFilter);
                }
                if (drainTime > 0) {
                    args.setDrainTimeout(drainTime);
                    if (drainID == null) {
                        drainID = Common.getDrainID();
                    }
                }
                List<ResourceAttribute> optionsList = ServiceImpl.getSvcStopOptions(args, drainID);
                ResourceAttribute[] options = new ResourceAttribute[optionsList.size()];
                optionsList.toArray(options);
                for (String tgt : tgtNodes.keySet()) {
                    HashMap<String, String> nodeResMap = new HashMap<String, String>();
                    Filter srcFilter = (Filter)tgtNodes.get(tgt);
                    Trace.out("relocating svcs to %s using filter %s", tgt, srcFilter.toString());
                    try {
                        CRSFactoryImpl.relocateResources(srcFilter, tgt, force, options, nodeResMap);
                    }
                    catch (CompositeOperationException e) {
                        Trace.out(e);
                        throw e;
                    }
                    for (String n : nodeResMap.keySet()) {
                        Trace.out((Object)"processing node %s ...", n);
                        String val = ((String)nodeResMap.get(n)).trim();
                        if (vlsnr != null) {
                            vlsnr.write(MessageBundle.getMessage(PrCdMsgID.RELOCATE_RES_NODE, false, val, n));
                        }
                        val = val.replaceAll("\\s+", "");
                        for (String resName : val.split(",")) {
                            Trace.out((Object)"processing service %s ...", resName);
                            String dbName = ServiceImpl.getDbNameFromSvcName(resName);
                            String svcName = ServiceImpl.getSvcNameFromResName(resName);
                            Trace.out("db unqiue name : %s ; service name : %s", dbName, svcName);
                            retval.add(new DBServiceOperationInfo(svcName, dbName, n, tgt));
                        }
                    }
                }
                Trace.out("relocated svcs");
            }
            catch (CRSException | DatabaseException | ServerGroupException | NotExistsException | NotRunningException | ClusterException | NodeException e) {
                Trace.out("attempt to relocate selection of services failed with %s : %s", e.getClass().getName(), e);
                throw new NotRunningException(this.getExpnMsgKey4Relocate(), (Throwable)e, this.getExpnMsgArgs());
            }
            catch (ServerException e) {
                Trace.out("attempt to relocate selection of services failed with ServerException : %s", e);
                throw new ServiceException(this.getExpnMsgKey4Relocate(), (Throwable)e, this.getExpnMsgArgs());
            }
            catch (SoftwareModuleException e) {
                Trace.out("attempt to relocate selection of services failed with SoftwareModuleException : %s", e);
                throw new ServiceException(this.getExpnMsgKey4Relocate(), (Throwable)e, this.getExpnMsgArgs());
            }
        }
        if (isWait && !retval.isEmpty() && drainTime != null && drainTime > 0 && drainID != null) {
            Trace.out("waiting for sessions to drain ...");
            this.waitForDrainCompletion(retval, drainID, drainTime, vlsnr);
            Trace.out("sessions have drained");
        }
        return retval;
    }

    @Override
    public List<DBServiceOperationInfo> stop() throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        try {
            return this.internalStop(new ServiceStopArgs(), null);
        }
        catch (InvalidArgsException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<DBServiceOperationInfo> stop(ServiceStopArgs args) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, ServiceException {
        return this.internalStop(args, null);
    }

    List<DBServiceOperationInfo> internalStop(ServiceStopArgs args, String drainID) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, ServiceException {
        if (args == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-stop3-1");
        }
        ArrayList<DBServiceOperationInfo> retval = new ArrayList<DBServiceOperationInfo>();
        Boolean forceFlag = args.getForceFlag();
        boolean force = forceFlag != null && forceFlag != false;
        Boolean keepDepTgtFlag = args.getKeepDepTargetFlag();
        boolean keepDepTarget = keepDepTgtFlag != null && keepDepTgtFlag != false;
        boolean isWait = args.getWait() != null && args.getWait() != false;
        Integer drainTime = args.getDrainTimeout();
        VerboseListener vlsnr = args.getVerboseListener();
        try {
            Trace.out("stopping svcs ...");
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Filter svcsFilter = this.getFilter();
            svcsFilter = new ExpressionFilter(Filter.Operator.AND, svcsFilter, FilterFactoryImpl.getFilter4RunningState());
            Trace.out((Object)"created filter for stopping svcs %s", svcsFilter.toString());
            if (drainTime == null) {
                drainTime = Common.calculateMaxDrain(svcsFilter);
            }
            if (drainTime > 0) {
                args.setDrainTimeout(drainTime);
                if (drainID == null) {
                    drainID = Common.getDrainID();
                }
            }
            List<ResourceAttribute> optionsList = ServiceImpl.getSvcStopOptions(args, drainID);
            ResourceAttribute[] options = new ResourceAttribute[optionsList.size()];
            optionsList.toArray(options);
            Trace.out("stopping services ...");
            HashMap<String, String> nodeResMap = new HashMap<String, String>();
            CRSFactoryImpl.stopResources(svcsFilter, force, keepDepTarget, options, nodeResMap);
            for (String node : nodeResMap.keySet()) {
                Trace.out((Object)"processing node %s ...", node);
                String val = ((String)nodeResMap.get(node)).trim();
                if (vlsnr != null) {
                    vlsnr.write(MessageBundle.getMessage(PrCdMsgID.STOP_RES_NODE, false, val, node));
                }
                val = val.replaceAll("\\s+", "");
                for (String resName : val.split(",")) {
                    Trace.out((Object)"processing service %s", resName);
                    String dbName = ServiceImpl.getDbNameFromSvcName(resName);
                    String svcName = ServiceImpl.getSvcNameFromResName(resName);
                    Trace.out("db unqiue name : %s ; service name : %s", dbName, svcName);
                    retval.add(new DBServiceOperationInfo(svcName, dbName, Arrays.asList(node), true));
                }
            }
            Trace.out("stopped services");
        }
        catch (AlreadyStoppedException e) {
            Trace.out(e);
            throw new ServiceException(this.getExpnMsgKey4Stop(), (Throwable)e, this.getExpnMsgArgs());
        }
        catch (CompositeOperationException e) {
            Trace.out(e);
            throw e;
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new ServiceException(this.getExpnMsgKey4Stop(), (Throwable)e, this.getExpnMsgArgs());
        }
        catch (DatabaseException e) {
            Trace.out(e);
            throw new ServiceException(this.getExpnMsgKey4Stop(), (Throwable)e, this.getExpnMsgArgs());
        }
        if (isWait && !retval.isEmpty() && drainTime != null && drainTime > 0 && drainID != null) {
            Trace.out("waiting for sessions to drain ...");
            this.waitForDrainCompletion(retval, drainID, drainTime, vlsnr);
            Trace.out("sessions have drained");
        }
        return retval;
    }

    @Override
    public List<DBServiceOperationInfo> start() throws AlreadyRunningException, CompositeOperationException, ServiceException {
        try {
            ArrayList<DBServiceOperationInfo> retval = new ArrayList<DBServiceOperationInfo>();
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Filter svcsFilter = this.getFilter();
            Trace.out((Object)"starting svcs using filter %s ...", svcsFilter.toString());
            CRSFactoryImpl.startResources(svcsFilter, null, null);
            Trace.out("started svcs");
            return retval;
        }
        catch (AlreadyRunningException e) {
            Trace.out(e);
            throw new AlreadyRunningException(this.getExpnMsgKey4Start(), (Throwable)e, this.getExpnMsgArgs());
        }
        catch (CompositeOperationException e) {
            Trace.out(e);
            throw e;
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new ServiceException(this.getExpnMsgKey4Start(), (Throwable)e, this.getExpnMsgArgs());
        }
    }

    @Override
    public List<DBServiceOperationInfo> relocateAndStopServices(List<String> avoidNodes) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, ServiceException {
        if (this.m_nodes == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-relocateStopSvcs-0");
        }
        if (avoidNodes == null || avoidNodes.isEmpty() || avoidNodes.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-relocateStopSvcs-1");
        }
        ArrayList retval = new ArrayList();
        VerboseListener vlsnr = new VerboseListener();
        ServiceStopArgs stopArgs = new ServiceStopArgs();
        Filter svcsFilter = this.getFilter();
        try {
            svcsFilter = new ExpressionFilter(Filter.Operator.AND, svcsFilter, FilterFactoryImpl.getFilter4RunningState());
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)e, "DBSvcsColl-relocateStopSvcs-2");
        }
        Integer drainTime = Common.calculateMaxDrain(svcsFilter);
        if (drainTime > 0) {
            stopArgs.setDrainTimeout(drainTime);
        }
        stopArgs.setVerboseListener(vlsnr);
        stopArgs.setForceFlag(true);
        return this.relocateAndStop(avoidNodes, stopArgs);
    }

    @Override
    public List<DBServiceOperationInfo> relocateAndStop(List<String> avoidNodes, ServiceStopArgs args) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, ServiceException {
        if (this.m_nodes == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-relocateStopSvcs2-0");
        }
        if (avoidNodes == null || avoidNodes.isEmpty() || avoidNodes.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-relocateStopSvcs2-1");
        }
        Integer drainTime = args.getDrainTimeout();
        String drainID = Common.getDrainID();
        List<Object> retval = new ArrayList();
        Trace.out("relocating services ...");
        try {
            retval = this.internalRelocate(args, avoidNodes, null, drainID);
        }
        catch (NotRunningException e) {
            Trace.out("ignoring NotRunningException ...");
            Trace.out(e);
        }
        Trace.out("stopping services ...");
        retval.addAll(this.internalStop(args, drainID));
        if (drainTime != null && drainTime > 0 && !retval.isEmpty()) {
            Trace.out("waiting for sessions to drain ...");
            VerboseListener vlsnr = args.getVerboseListener();
            this.waitForDrainCompletion(retval, drainID, drainTime, vlsnr);
            Trace.out("services have drained");
        }
        return retval;
    }

    @Override
    public List<Service> getServices() throws ServiceException {
        try {
            return this.getServices(this.getFilter());
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new ServiceException(e);
        }
    }

    @Override
    public List<Service> getJavaServices() throws ServiceException {
        try {
            ArrayList<Service> javaSvcs = new ArrayList<Service>();
            List<Service> svcs = this.getServices(this.getFilter());
            for (Service svc : svcs) {
                try {
                    if (!svc.isJavaService()) continue;
                    javaSvcs.add(svc);
                }
                catch (NotRunningException nee) {
                    Trace.out("couldn't determine if %s was a Java service as it wasn't running : %s", svc.getName(), nee);
                }
            }
            return javaSvcs;
        }
        catch (InvalidArgsException e) {
            Trace.out("attempt to identify Java services failed with InvalidArgsException : %s", e);
            throw new ServiceException(e);
        }
    }

    @Override
    public List<DBServiceOperationInfo> disable() throws AlreadyDisabledException, CompositeOperationException, ServiceException {
        try {
            return this.internalEnableDisable(false);
        }
        catch (AlreadyEnabledException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public List<DBServiceOperationInfo> enable() throws AlreadyEnabledException, CompositeOperationException, ServiceException {
        try {
            return this.internalEnableDisable(true);
        }
        catch (AlreadyDisabledException e) {
            throw new ServiceException(e);
        }
    }

    public List<DBServiceOperationInfo> internalEnableDisable(boolean isEnable) throws AlreadyEnabledException, AlreadyDisabledException, CompositeOperationException, ServiceException {
        String op = isEnable ? "enabling" : "disabling";
        Trace.out((Object)"%s services ...", op);
        try {
            ArrayList<DBServiceOperationInfo> retVal = new ArrayList<DBServiceOperationInfo>();
            List<Service> svcs = this.m_services != null ? this.m_services : this.getServices();
            StringBuilder alreadyOperatedSvcs = new StringBuilder();
            for (Service svc : svcs) {
                String resName = svc.getName();
                Trace.out("%s service %s ...", op, resName);
                String dbName = ServiceImpl.getDbNameFromSvcName(resName);
                String svcName = ServiceImpl.getSvcNameFromResName(resName);
                Trace.out("db unqiue name : %s ; service name : %s", dbName, svcName);
                ServerGroup sg = svc.getServerGroup();
                if (this.m_nodes == null) {
                    if (isEnable) {
                        Trace.out((Object)"enabling service %s globally ...", resName);
                        try {
                            svc.enable();
                            Trace.out((Object)"enabled service %s globally ...", resName);
                            retVal.add(new DBServiceOperationInfo(svcName, dbName, DBServiceOperationInfo.ServiceOperation.ENABLE));
                        }
                        catch (AlreadyEnabledException aee) {
                            Trace.out("%s is already enabled : %s", resName, aee.getMessage());
                            alreadyOperatedSvcs.append(aee.getMessage() + "\\n");
                        }
                    } else {
                        Trace.out((Object)"disabling service %s globally ...", resName);
                        try {
                            svc.disable();
                            Trace.out((Object)"disabled service %s globally ...", resName);
                            retVal.add(new DBServiceOperationInfo(svcName, dbName, DBServiceOperationInfo.ServiceOperation.DISABLE));
                        }
                        catch (AlreadyDisabledException ade) {
                            Trace.out("%s is already disabled : %s", resName, ade.getMessage());
                            alreadyOperatedSvcs.append(ade.getMessage() + "\\n");
                        }
                    }
                } else {
                    ServerFactory sf = ServerFactory.getInstance();
                    ArrayList<String> allNodes = new ArrayList<String>(Arrays.asList(Utils.list2String(sg.servers(), ",").split(",")));
                    Trace.out("%s service %s on specific nodes ...", op, resName);
                    ArrayList<String> opNodes = new ArrayList<String>();
                    for (String node : this.m_nodes) {
                        if (!allNodes.contains(node)) continue;
                        if (isEnable) {
                            Trace.out("enabling service %s on node %s ...", resName, node);
                            try {
                                svc.enable(new ArrayList<Node>(Arrays.asList(sf.getNode(node))));
                                opNodes.add(node);
                            }
                            catch (AlreadyEnabledException aee) {
                                Trace.out("%s is already enabled on node %s : %s", resName, node, aee.getMessage());
                                alreadyOperatedSvcs.append(aee.getMessage() + "\\n");
                            }
                            continue;
                        }
                        Trace.out("disabling service %s on node %s ...", resName, node);
                        try {
                            svc.disable(new ArrayList<Node>(Arrays.asList(sf.getNode(node))));
                            opNodes.add(node);
                        }
                        catch (AlreadyDisabledException ade) {
                            Trace.out("%s is already disabled on node %s : %s", resName, node, ade.getMessage());
                            alreadyOperatedSvcs.append(ade.getMessage() + "\\n");
                        }
                    }
                    if (!opNodes.isEmpty()) {
                        Trace.out("disabled service %s on nodes %s", resName, ((Object)opNodes).toString());
                        retVal.add(new DBServiceOperationInfo(svcName, dbName, opNodes, isEnable ? DBServiceOperationInfo.ServiceOperation.ENABLE : DBServiceOperationInfo.ServiceOperation.DISABLE));
                    }
                }
                Trace.out((Object)"disabled service", resName);
            }
            if (alreadyOperatedSvcs.length() > 0) {
                if (isEnable) {
                    Trace.out("already enabled services : %s", alreadyOperatedSvcs);
                    throw new AlreadyEnabledException(this.getExpnMsgKey4Enable(), (Throwable)new Exception(alreadyOperatedSvcs.toString()), this.getExpnMsgArgs());
                }
                Trace.out("already disabled services : %s", alreadyOperatedSvcs);
                throw new AlreadyDisabledException(this.getExpnMsgKey4Disable(), (Throwable)new Exception(alreadyOperatedSvcs.toString()), this.getExpnMsgArgs());
            }
            return retVal;
        }
        catch (CompositeOperationException e) {
            Trace.out("%s services failed with CompositeOperationException : %s", op, e.getMessage());
            throw e;
        }
        catch (InvalidArgsException | DatabaseException | ServerGroupException | NodeException e) {
            Trace.out("%s services failed with exception %s : %s", op, e.getClass().getName(), e);
            throw new ServiceException(isEnable ? this.getExpnMsgKey4Enable() : this.getExpnMsgKey4Disable(), (Throwable)e, this.getExpnMsgArgs());
        }
        catch (SoftwareModuleException | ServerException e) {
            Trace.out("%s services failed with exception %s : %s", op, e.getClass().getName(), e);
            throw new ServiceException(isEnable ? this.getExpnMsgKey4Enable() : this.getExpnMsgKey4Disable(), (Throwable)e, this.getExpnMsgArgs());
        }
    }

    List<Service> getServices(Filter filter) throws InvalidArgsException, ServiceException {
        if (filter == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-getServices-1");
        }
        try {
            HashMap<String, Service> retval = new HashMap<String, Service>();
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            DatabaseFactory df = DatabaseFactory.getInstance();
            Trace.out((Object)"Querying for services using filter %s ...", filter.toString());
            Map<String, Map<String, String>> resultData = cf.searchEntities(CRSEntity.Type.ResourceInstance, false, filter, ResourceType.Service.SERVICE_NAME.name(), ResourceType.Service.NAME.name());
            for (String riID : resultData.keySet()) {
                Map<String, String> valueMap = resultData.get(riID);
                String resName = valueMap.get(ResourceType.Service.NAME.name());
                String svcName = valueMap.get(ResourceType.Service.SERVICE_NAME.name());
                String dbName = ServiceImpl.getDbNameFromSvcName(resName);
                retval.put(svcName, df.getService(dbName, svcName, df.getDatabaseVersion(dbName)));
            }
            return new ArrayList<Service>(retval.values());
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new ServiceException(e);
        }
        catch (NotExistsException e) {
            Trace.out(e);
            throw new ServiceException(e);
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            throw new ServiceException(e);
        }
    }

    int calculateMaxDrain() throws ServiceException {
        try {
            return Common.calculateMaxDrain(this.getFilter());
        }
        catch (InvalidArgsException e) {
            throw new ServiceException(e);
        }
    }

    void waitForDrainCompletion(List<DBServiceOperationInfo> svcs, String drainID, int waitTime, VerboseListener vlsnr) throws InvalidArgsException, ServiceException {
        if (svcs == null || svcs.isEmpty() || svcs.contains(null) || drainID == null || drainID.trim().isEmpty() || waitTime <= 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-waitForDrainCompletion-1");
        }
        HashMap<Object, Database> dbMap = new HashMap<Object, Database>();
        HashMap svcs4db = new HashMap();
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<String> resNames = new ArrayList<String>();
        int wIntvl = waitTime < 20 ? waitTime : 20;
        try {
            DatabaseFactory df = DatabaseFactory.getInstance();
            for (DBServiceOperationInfo svc : svcs) {
                String dbName = svc.getDatabaseName();
                String svcName = svc.getServiceName();
                Trace.out("processing service %s of database %s ...", svcName, dbName);
                if (!dbMap.containsKey(dbName)) {
                    dbMap.put(dbName, df.getDatabase(dbName, df.getDatabaseVersion(dbName)));
                }
                String resName = ServiceImpl.getResourceName(dbName, svcName, false);
                Trace.out((Object)"service resource name is %s", resName);
                if (svcs4db.containsKey(dbName)) {
                    if (!((List)svcs4db.get(dbName)).contains(resName)) {
                        ((List)svcs4db.get(dbName)).add(resName);
                    }
                } else {
                    ArrayList<String> val = new ArrayList<String>();
                    val.add(resName);
                    svcs4db.put(dbName, val);
                }
                if (!resNames.contains(resName)) {
                    resNames.add(resName);
                }
                boolean isRelocated = svc.isRelocated();
                boolean isStopped = svc.isStopped();
                List<String> svcNodes = null;
                if (isRelocated) {
                    svcNodes = Arrays.asList(svc.getSourceNode());
                } else if (isStopped) {
                    svcNodes = svc.getStopNodes();
                } else {
                    throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-waitForDrainCompletion-2");
                }
                Trace.out("service %s was %s %s", resName, isRelocated ? "relocated from" : "stopped on", svcNodes.toString());
                for (String node : svcNodes) {
                    Trace.out((Object)"processing node %s ...", node);
                    if (nodes.contains(node)) continue;
                    nodes.add(node);
                }
            }
            ArrayList<Node> nodeObjs = new ArrayList<Node>();
            ServerFactory sf = ServerFactory.getInstance();
            for (String nodeName : nodes) {
                nodeObjs.add(sf.getNode(nodeName));
            }
            ArrayList dbs = new ArrayList(dbMap.values());
            CompositeDatabaseActionStatus compResult = null;
            int count = 0;
            block15: for (Database db : dbs) {
                if (count > waitTime) {
                    Trace.out((Object)"Waited for specified wait time. Skipping db %s", db.getName());
                    continue;
                }
                Version dbVer = db.version();
                if (Version.isPre122(dbVer)) {
                    Trace.out("Not submitting drain action for database %s of version %s", db.getName(), dbVer.toString());
                    continue;
                }
                List<Node> nodes2check = db.crsResource().fetchRunningNodes();
                nodes2check.retainAll(nodeObjs);
                if (nodes2check.isEmpty()) continue;
                String dbName = db.getUserAssignedName();
                List svcs2check = (List)svcs4db.get(dbName);
                for (int i = 0; i <= waitTime; ++i) {
                    boolean isCheck = true;
                    if (i % wIntvl == 0 || i == waitTime) {
                        Map<Node, DatabaseActionStatus> result;
                        Trace.out("Submitting drain action for services %s of db %s with drain id %s on nodes %s", svcs2check.toString(), dbName, drainID, nodes2check.toString());
                        compResult = ((DatabaseImpl)db).m_DbAction.drainAction(nodes2check, svcs2check, drainID);
                        if (compResult == null || (result = compResult.getAllDatabaseActionStatus()) == null || result.isEmpty()) continue block15;
                        for (Map.Entry<Node, DatabaseActionStatus> pairs : result.entrySet()) {
                            DatabaseActionStatus status = pairs.getValue();
                            String nodeName = null;
                            try {
                                nodeName = pairs.getKey().getName();
                            }
                            catch (NodeException e) {
                                Trace.out("Ignoring NodeException : " + e);
                                continue;
                            }
                            boolean bl = isCheck = status.getSessionCount() != 0;
                            if (isCheck) break;
                            Trace.out("Drain completed for services %s of db %s on node %s", svcs2check.toString(), dbName, nodeName);
                            if (vlsnr == null) continue;
                            vlsnr.write(MessageBundle.getMessage(PrCdMsgID.DRAIN_COMPLETE, false, nodeName, Utils.strListToList2(svcs2check)));
                        }
                    }
                    if (isCheck) {
                        ++count;
                        Trace.out("still draining ...");
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new DatabaseException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED2, (Throwable)e, Utils.strListToList(resNames));
                        }
                    }
                    Trace.out("Drain completed for services %s of db %s", svcs2check.toString(), dbName);
                    continue block15;
                }
            }
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new ServiceException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED2, (Throwable)e, Utils.strListToList(resNames));
        }
        catch (NodeException e) {
            Trace.out(e);
            throw new ServiceException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED2, (Throwable)e, Utils.strListToList(resNames));
        }
        catch (NotExistsException e) {
            Trace.out(e);
            throw new ServiceException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED2, (Throwable)e, Utils.strListToList(resNames));
        }
        catch (NoVersionAvailableException e) {
            Trace.out(e);
            throw new ServiceException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED2, (Throwable)e, Utils.strListToList(resNames));
        }
        catch (ServerException e) {
            Trace.out(e);
            throw new ServiceException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED2, (Throwable)e, Utils.strListToList(resNames));
        }
        catch (ServiceException e) {
            Trace.out(e);
            throw new ServiceException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED2, (Throwable)e, Utils.strListToList(resNames));
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            throw new ServiceException((MessageKey)PrCdMsgID.DRAIN_ACTION_FAILED2, (Throwable)e, Utils.strListToList(resNames));
        }
    }

    private Filter getFilter() throws ServiceException {
        try {
            if (this.m_services != null && this.m_dbNames != null) {
                throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBSvcsColl-getFilter-1");
            }
            Filter filter = FilterFactoryImpl.getFilter4ResourceType(ResourceType.Service.NAME.toString());
            if (this.m_nodes != null) {
                filter = new ExpressionFilter(Filter.Operator.AND, filter, DBFilterFactory.getFilter4Nodes(this.m_nodes));
            }
            if (this.m_services != null) {
                filter = new ExpressionFilter(Filter.Operator.AND, filter, FilterFactoryImpl.getFilter4ResourceNames(this.m_services));
            } else if (this.m_dbNames != null) {
                Filter dbsFilter = null;
                for (String dbName : this.m_dbNames) {
                    SimpleFilter dbFilter = new SimpleFilter(Filter.Comparator.STARTS_WITH, ResourceType.Service.NAME.name(), "ora." + dbName + ".");
                    dbsFilter = dbsFilter == null ? dbFilter : new ExpressionFilter(Filter.Operator.OR, dbsFilter, dbFilter);
                }
                filter = new ExpressionFilter(Filter.Operator.AND, filter, dbsFilter);
            }
            return filter;
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new ServiceException(e);
        }
        catch (DatabaseException e) {
            Trace.out(e);
            throw new ServiceException(e);
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new ServiceException(e);
        }
    }

    private Object[] getExpnMsgArgs() {
        Object[] retval = new String[]{"DBSvcsColl-error"};
        if (this.m_services != null && this.m_nodes != null) {
            retval = new String[]{Utils.list2String(this.m_services, ","), Utils.strListToList2(this.m_nodes)};
        } else if (this.m_dbNames != null && this.m_nodes != null) {
            retval = new String[]{Utils.strListToList2(this.m_dbNames), Utils.strListToList2(this.m_nodes)};
        } else if (this.m_services != null) {
            retval = new String[]{Utils.list2String(this.m_services, ",")};
        } else if (this.m_dbNames != null) {
            retval = new String[]{Utils.strListToList2(this.m_dbNames)};
        } else if (this.m_nodes != null) {
            retval = new String[]{Utils.strListToList2(this.m_nodes)};
        }
        return retval;
    }

    private MessageKey getExpnMsgKey4Stop() {
        Enum retval = PrCtMsgID.UNEXPECTED_INTERNAL_ERROR;
        if (this.m_services != null && this.m_nodes != null) {
            retval = PrCdMsgID.STOP_SERVICES_FAILED3;
        } else if (this.m_dbNames != null && this.m_nodes != null) {
            retval = PrCdMsgID.STOP_SERVICES_FAILED4;
        } else if (this.m_services != null) {
            retval = PrCdMsgID.STOP_SERVICES_FAILED;
        } else if (this.m_dbNames != null) {
            retval = PrCdMsgID.STOP_SERVICES_FAILED5;
        } else if (this.m_nodes != null) {
            retval = PrCdMsgID.STOP_SERVICES_FAILED2;
        }
        return retval;
    }

    private MessageKey getExpnMsgKey4Start() {
        Enum retval = PrCtMsgID.UNEXPECTED_INTERNAL_ERROR;
        if (this.m_services != null && this.m_nodes != null) {
            retval = PrCdMsgID.START_SERVICES_FAILED3;
        } else if (this.m_dbNames != null && this.m_nodes != null) {
            retval = PrCdMsgID.START_SERVICES_FAILED4;
        } else if (this.m_services != null) {
            retval = PrCdMsgID.START_SERVICES_FAILED;
        } else if (this.m_dbNames != null) {
            retval = PrCdMsgID.START_SERVICES_FAILED5;
        } else if (this.m_nodes != null) {
            retval = PrCdMsgID.START_SERVICES_FAILED2;
        }
        return retval;
    }

    private MessageKey getExpnMsgKey4Relocate() {
        Enum retval = PrCtMsgID.UNEXPECTED_INTERNAL_ERROR;
        if (this.m_services != null && this.m_nodes != null) {
            retval = PrCdMsgID.RELOCATE_SERVICES_FAILED3;
        } else if (this.m_dbNames != null && this.m_nodes != null) {
            retval = PrCdMsgID.RELOCATE_SERVICES_FAILED4;
        } else if (this.m_services != null) {
            retval = PrCdMsgID.RELOCATE_SERVICES_FAILED;
        } else if (this.m_dbNames != null) {
            retval = PrCdMsgID.RELOCATE_SERVICES_FAILED5;
        } else if (this.m_nodes != null) {
            retval = PrCdMsgID.RELOCATE_SERVICES_FAILED2;
        }
        return retval;
    }

    private MessageKey getExpnMsgKey4Disable() {
        Enum retval = PrCtMsgID.UNEXPECTED_INTERNAL_ERROR;
        if (this.m_services != null && this.m_nodes != null) {
            retval = PrCdMsgID.DISABLE_SERVICES_FAILED3;
        } else if (this.m_dbNames != null && this.m_nodes != null) {
            retval = PrCdMsgID.DISABLE_SERVICES_FAILED4;
        } else if (this.m_services != null) {
            retval = PrCdMsgID.DISABLE_SERVICES_FAILED;
        } else if (this.m_dbNames != null) {
            retval = PrCdMsgID.DISABLE_SERVICES_FAILED5;
        } else if (this.m_nodes != null) {
            retval = PrCdMsgID.DISABLE_SERVICES_FAILED2;
        }
        return retval;
    }

    private MessageKey getExpnMsgKey4Enable() {
        Enum retval = PrCtMsgID.UNEXPECTED_INTERNAL_ERROR;
        if (this.m_services != null && this.m_nodes != null) {
            retval = PrCdMsgID.ENABLE_SERVICES_FAILED3;
        } else if (this.m_dbNames != null && this.m_nodes != null) {
            retval = PrCdMsgID.ENABLE_SERVICES_FAILED4;
        } else if (this.m_services != null) {
            retval = PrCdMsgID.ENABLE_SERVICES_FAILED;
        } else if (this.m_dbNames != null) {
            retval = PrCdMsgID.ENABLE_SERVICES_FAILED5;
        } else if (this.m_nodes != null) {
            retval = PrCdMsgID.ENABLE_SERVICES_FAILED2;
        }
        return retval;
    }
}

