/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.ExpressionFilter;
import oracle.cluster.impl.crs.cops.SimpleFilter;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class DBFilterFactory {
    public static Filter getFilter4OracleHome(String oracleHome) throws InvalidArgsException, DatabaseException {
        if (oracleHome == null || oracleHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4OracleHome");
        }
        try {
            SimpleFilter homeFilter = new SimpleFilter(new SystemFactory().CreateSystem().isUnixSystem() ? Filter.Comparator.EQ : Filter.Comparator.EQI, ResourceType.Database.ORACLE_HOME.name(), oracleHome.trim());
            return homeFilter;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getFilter4OldOracleHome(String oldOracleHome) throws InvalidArgsException, DatabaseException {
        if (oldOracleHome == null || oldOracleHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4OldOracleHome");
        }
        try {
            SimpleFilter homeFilter = new SimpleFilter(new SystemFactory().CreateSystem().isUnixSystem() ? Filter.Comparator.EQ : Filter.Comparator.EQI, ResourceType.Database.ORACLE_HOME_OLD.name(), oldOracleHome.trim());
            return homeFilter;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getFilter4DatabasesInHome(String oracleHome) throws InvalidArgsException, DatabaseException {
        if (oracleHome == null || oracleHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4DatabasesInHome");
        }
        try {
            Filter dbTypeFilter = FilterFactoryImpl.getFilter4ResourceType(ResourceType.Database.NAME.toString());
            Filter homeFilter = DBFilterFactory.getFilter4OracleHome(oracleHome);
            ExpressionFilter ret = new ExpressionFilter(Filter.Operator.AND, dbTypeFilter, homeFilter);
            return ret;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getFilter4DatabasesRunningInHome(String oracleHome) throws InvalidArgsException, DatabaseException {
        if (oracleHome == null || oracleHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4DatabasesRunningInHome");
        }
        try {
            Filter dbInHomeFilter = DBFilterFactory.getFilter4DatabasesInHome(oracleHome);
            Filter stateFilter = FilterFactoryImpl.getFilter4RunningState();
            SimpleFilter stateDetailsFilter = new SimpleFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.STATE_DETAILS.name(), "HOME=" + oracleHome);
            ExpressionFilter ret = new ExpressionFilter(Filter.Operator.AND, dbInHomeFilter, stateFilter);
            ret = new ExpressionFilter(Filter.Operator.AND, ret, stateDetailsFilter);
            return ret;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getFilter4DatabasesRunningFromOldHome(String oldHome) throws InvalidArgsException, DatabaseException {
        if (oldHome == null || oldHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4DatabasesRunningFromOldHome");
        }
        try {
            Filter dbTypeFilter = FilterFactoryImpl.getFilter4ResourceType(ResourceType.Database.NAME.toString());
            Filter dbOldHomeFilter = DBFilterFactory.getFilter4OldOracleHome(oldHome);
            Filter stateFilter = FilterFactoryImpl.getFilter4RunningState();
            SimpleFilter stateDetailsFilter = new SimpleFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.STATE_DETAILS.name(), "HOME=" + oldHome);
            ExpressionFilter ret = new ExpressionFilter(Filter.Operator.AND, dbOldHomeFilter, stateFilter);
            ret = new ExpressionFilter(Filter.Operator.AND, ret, stateDetailsFilter);
            ret = new ExpressionFilter(Filter.Operator.AND, ret, dbTypeFilter);
            return ret;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getFilter2ValidateDatabasesInSameHome(String oracleHome, List<String> dbNames) throws InvalidArgsException, DatabaseException {
        if (oracleHome == null || oracleHome.trim().isEmpty() || dbNames == null || dbNames.isEmpty() || dbNames.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4ValidatingMoveDatabasesInput");
        }
        try {
            Filter prevHomeFilter = DBFilterFactory.getFilter4OldOracleHome(oracleHome.trim());
            Filter currHomeFilter = DBFilterFactory.getFilter4OracleHome(oracleHome.trim());
            Filter dbTypeFilter = FilterFactoryImpl.getFilter4ResourceType(ResourceType.Database.NAME.toString());
            Filter dbNamesFilter = DBFilterFactory.getFilter4DatabaseNames(dbNames);
            ExpressionFilter ret = new ExpressionFilter(Filter.Operator.OR, currHomeFilter, prevHomeFilter);
            ret = new ExpressionFilter(Filter.Operator.AND, ret, dbTypeFilter);
            ret = new ExpressionFilter(Filter.Operator.AND, ret, dbNamesFilter);
            return ret;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getFilter4DatabasesOfVersion(String version) throws InvalidArgsException, DatabaseException {
        if (version == null || version.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4DatabasesOfVersion");
        }
        try {
            Filter dbTypeFilter = FilterFactoryImpl.getFilter4ResourceType(ResourceType.Database.NAME.toString());
            Filter verFilter = FilterFactoryImpl.getFilter4Version(version);
            ExpressionFilter ret = new ExpressionFilter(Filter.Operator.AND, dbTypeFilter, verFilter);
            return ret;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getFilter4DatabasesOnNodes(Map<String, List<DatabaseFactoryImpl.DBInstanceDetails>> dbs) throws InvalidArgsException, DatabaseException {
        if (dbs == null || dbs.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4DatabasesOnNodes");
        }
        try {
            Object ret = null;
            for (String nodeName : dbs.keySet()) {
                Trace.out("getFilter4DatabasesOnNodes-node = " + nodeName);
                Filter nodeFilter = FilterFactoryImpl.getFilter4InstancesOnNode(ResourceType.Database.NAME.toString(), nodeName);
                List<DatabaseFactoryImpl.DBInstanceDetails> insts = dbs.get(nodeName);
                Filter wrk = null;
                for (DatabaseFactoryImpl.DBInstanceDetails inst : insts) {
                    String dbName = inst.getDatabaseName();
                    Trace.out("getFilter4DatabasesOnNodes-dbName = " + dbName);
                    SimpleFilter dbNameFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceType.Database.NAME.name(), DatabaseFactory.getDatabaseResourceName(dbName));
                    wrk = wrk == null ? dbNameFilter : new ExpressionFilter(Filter.Operator.OR, dbNameFilter, wrk);
                }
                wrk = new ExpressionFilter(Filter.Operator.AND, wrk, nodeFilter);
                ret = ret == null ? wrk : new ExpressionFilter(Filter.Operator.OR, (Filter)ret, wrk);
            }
            Trace.out("getFilter4DatabasesOnNodes-Filter = " + ret.toString());
            return ret;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getFilter4OnlineSvcs(List<String> dbNames) throws InvalidArgsException, DatabaseException {
        if (dbNames == null || dbNames.isEmpty() || dbNames.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4OnlineSvcs2-error1");
        }
        return DBFilterFactory.internalGetFilter4OnlineSvcs(dbNames, null);
    }

    public static Filter getFilter4OnlineSvcs(List<String> dbNames, List<String> nodes) throws InvalidArgsException, DatabaseException {
        if (dbNames == null || dbNames.isEmpty() || dbNames.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4OnlineSvcs3-error1");
        }
        if (nodes == null || nodes.isEmpty() || nodes.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4OnlineSvcs3-error2");
        }
        return DBFilterFactory.internalGetFilter4OnlineSvcs(dbNames, nodes);
    }

    static Filter internalGetFilter4OnlineSvcs(List<String> dbNames, List<String> nodes) throws InvalidArgsException, DatabaseException {
        if (dbNames != null && (dbNames.isEmpty() || dbNames.contains(null))) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4OnlineSvcs3-error1");
        }
        if (nodes != null && (nodes.isEmpty() || nodes.contains(null))) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4OnlineSvcs3-error2");
        }
        try {
            Filter svcsFilter = null;
            if (dbNames != null) {
                for (String dbName : dbNames) {
                    SimpleFilter nameFilter = new SimpleFilter(Filter.Comparator.STARTS_WITH, ResourceType.Service.NAME.name(), "ora." + dbName.toLowerCase() + '.');
                    svcsFilter = svcsFilter == null ? nameFilter : new ExpressionFilter(Filter.Operator.OR, svcsFilter, nameFilter);
                }
            }
            svcsFilter = svcsFilter == null ? FilterFactoryImpl.getFilter4RunningState() : new ExpressionFilter(Filter.Operator.AND, svcsFilter, FilterFactoryImpl.getFilter4RunningState());
            Filter typeFilter = FilterFactoryImpl.getFilter4ResourceType(ResourceType.Service.NAME.toString());
            svcsFilter = new ExpressionFilter(Filter.Operator.AND, svcsFilter, typeFilter);
            if (nodes != null) {
                svcsFilter = new ExpressionFilter(Filter.Operator.AND, svcsFilter, DBFilterFactory.getFilter4Nodes(nodes));
            }
            Trace.out("getFilter4OnlineSvcs3-Filter = " + svcsFilter.toString());
            return svcsFilter;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getServices4DB(String dbName) throws DatabaseException {
        return DBFilterFactory.getServicesOnDatabase(dbName, null);
    }

    public static Filter getSvcList4DB(String dbName, List<String> svcNames) throws DatabaseException {
        return DBFilterFactory.getServicesOnDatabase(dbName, svcNames);
    }

    private static Filter getServicesOnDatabase(String dbName, List<String> svcNames) throws DatabaseException {
        try {
            int len = dbName.length() - ResourceLiterals.DB.toString().length();
            String databaseName = dbName.substring(0, len);
            String endsWith = '.' + ResourceLiterals.SVC.toString();
            Filter enF = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.ENDS_WITH, ResourceType.Service.NAME.name(), endsWith);
            Filter typeF = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Service.NAME.toString());
            if (svcNames != null && svcNames.size() > 0) {
                ArrayList<String> resNames = new ArrayList<String>();
                for (String sName : svcNames) {
                    resNames.add(databaseName + sName + ".svc");
                }
                Filter stF = FilterFactoryImpl.getORFilter(ResourceType.Service.NAME.name(), Filter.Comparator.EQ, resNames.toArray(new String[resNames.size()]));
                return FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, stF, typeF);
            }
            Filter stF = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.STARTS_WITH, ResourceType.Service.NAME.name(), databaseName);
            Filter svcF = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, stF, enF);
            return FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, svcF, typeF);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getSvc4DBOnSrvPool(String dbName, String pool) throws DatabaseException {
        try {
            Filter poolFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceType.Service.SERVER_POOLS.name(), pool);
            Filter svcFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, DBFilterFactory.getServices4DB(dbName), poolFilter);
            return svcFilter;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getFilter4OnlineDatabases(List<String> dbNames) throws InvalidArgsException, DatabaseException {
        Filter dbsFilter = DBFilterFactory.getFilter4DatabaseNames(dbNames);
        ExpressionFilter ret = null;
        try {
            ret = new ExpressionFilter(Filter.Operator.AND, dbsFilter, FilterFactoryImpl.getFilter4RunningState());
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
        return ret;
    }

    public static Filter getFilter4DatabaseNames(List<String> dbNames) throws InvalidArgsException, DatabaseException {
        if (dbNames == null || dbNames.isEmpty() || dbNames.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4DatabaseNames");
        }
        try {
            Filter result = null;
            Filter wrk = null;
            for (String name : dbNames) {
                wrk = new SimpleFilter(Filter.Comparator.EQ, ResourceType.Database.NAME.name(), DatabaseFactory.getDatabaseResourceName(name));
                if (result == null) {
                    result = wrk;
                    continue;
                }
                result = new ExpressionFilter(Filter.Operator.OR, result, wrk);
            }
            wrk = FilterFactoryImpl.getFilter4ResourceType(ResourceType.Database.NAME.toString());
            return new ExpressionFilter(Filter.Operator.AND, result, wrk);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getStopFilter(String dbName, String resType, List<Node> nodeList) throws DatabaseException {
        Filter theFilter = null;
        int len = dbName.length() - ResourceLiterals.DB.toString().length();
        String startsWith = dbName.substring(0, len);
        String endsWith = "";
        try {
            if (resType.equals(ResourceType.Database.NAME.toString())) {
                endsWith = '.' + ResourceLiterals.DB.toString();
                theFilter = FilterFactoryImpl.getFilter2StopResources(ResourceType.Database.NAME.toString(), startsWith, endsWith);
            } else if (resType.equals(ResourceType.Service.NAME.toString())) {
                endsWith = '.' + ResourceLiterals.SVC.toString();
                theFilter = FilterFactoryImpl.getFilter2StopResources(ResourceType.Service.NAME.toString(), startsWith, endsWith);
            }
            if (nodeList != null && nodeList.size() > 0) {
                Filter nodeFilter = DBFilterFactory.getNodeFilter(nodeList);
                theFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, theFilter, nodeFilter);
            }
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
        return theFilter;
    }

    public static Filter getNodeFilter(List<Node> nodeList) throws DatabaseException {
        ArrayList<String> nodes = new ArrayList<String>();
        try {
            if (nodeList != null && nodeList.size() > 0) {
                for (Node node : nodeList) {
                    nodes.add(node.getName());
                }
            }
            return DBFilterFactory.getFilter4Nodes(nodes);
        }
        catch (InvalidArgsException e) {
            throw new DatabaseException(e);
        }
        catch (NodeException e) {
            throw new DatabaseException(e);
        }
    }

    public static Filter getFilter4Nodes(List<String> nodes) throws InvalidArgsException, DatabaseException {
        if (nodes == null || nodes.isEmpty() || nodes.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "dbFilterFactory-getFilter4Nodes-2");
        }
        Filter nodeFilter = null;
        try {
            SimpleFilter wrkFilter = null;
            for (String node : nodes) {
                node = Utils.convertToCSSNodeName(node);
                wrkFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceLiterals.CRS_LAST_SERVER.toString(), node);
                nodeFilter = nodeFilter == null ? wrkFilter : new ExpressionFilter(Filter.Operator.OR, nodeFilter, wrkFilter);
            }
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
        return nodeFilter;
    }
}

