/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.HashMap;
import java.util.Map;
import oracle.cluster.impl.database.DatabaseActionStatus;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class CompositeDatabaseActionStatus {
    private static final String LSEP = System.getProperty("line.separator");
    private Map<Node, DatabaseActionStatus> m_statMap = new HashMap<Node, DatabaseActionStatus>();

    public CompositeDatabaseActionStatus() {
    }

    public CompositeDatabaseActionStatus(Node[] nodes) {
        this.setNodes(nodes);
    }

    public void setNodes(Node[] nodes) {
        if (null != nodes) {
            for (Node node : nodes) {
                this.m_statMap.put(node, new DatabaseActionStatus());
            }
        }
    }

    public DatabaseActionStatus getDatabaseActionStatus(Node node) {
        return this.m_statMap.get(node);
    }

    public Map<Node, DatabaseActionStatus> getAllDatabaseActionStatus() {
        return this.m_statMap;
    }

    void addDatabaseActionStatus(Node node, DatabaseActionStatus stat) {
        this.m_statMap.put(node, stat);
    }

    public boolean isError() {
        for (Node node : this.m_statMap.keySet()) {
            DatabaseActionStatus das = this.getDatabaseActionStatus(node);
            if (!das.isError()) continue;
            return true;
        }
        return false;
    }

    public boolean isSuccess() {
        boolean anySuccess = false;
        boolean anyError = false;
        for (Node node : this.m_statMap.keySet()) {
            DatabaseActionStatus das = this.getDatabaseActionStatus(node);
            if (!das.isWarning() && !das.isError()) {
                anySuccess = true;
                continue;
            }
            if (!das.isError()) continue;
            anyError = true;
        }
        Trace.out(String.valueOf(!anyError && anySuccess));
        return !anyError && anySuccess;
    }

    public boolean isWarning() {
        boolean isWarn = false;
        for (Node node : this.m_statMap.keySet()) {
            DatabaseActionStatus das = this.getDatabaseActionStatus(node);
            if (das.isError()) {
                return false;
            }
            if (das.isWarning()) {
                isWarn = true;
                continue;
            }
            return false;
        }
        return isWarn;
    }

    public boolean isError(int errorID) {
        for (Node node : this.m_statMap.keySet()) {
            DatabaseActionStatus das = this.getDatabaseActionStatus(node);
            if (!das.isError(errorID)) continue;
            return true;
        }
        return false;
    }

    String getWarningMessage() {
        if (!this.isWarning()) {
            return "";
        }
        StringBuilder warnMsg = new StringBuilder();
        for (Node node : this.m_statMap.keySet()) {
            try {
                DatabaseActionStatus das = this.getDatabaseActionStatus(node);
                if (!das.isWarning()) continue;
                String nodeName = node.getName();
                warnMsg.append(nodeName);
                warnMsg.append(" : ");
                warnMsg.append(das.getWarningMessage());
                warnMsg.append(LSEP);
            }
            catch (NodeException e) {
                Trace.out("WARNING: node name could not be found.");
            }
        }
        return warnMsg.toString();
    }

    String getErrorMessage(int errorID) {
        StringBuilder failedMsg = new StringBuilder();
        for (Node node : this.m_statMap.keySet()) {
            try {
                DatabaseActionStatus das = this.getDatabaseActionStatus(node);
                if (!das.isError(errorID)) continue;
                String nodeName = node.getName();
                failedMsg.append(nodeName);
                failedMsg.append(":");
                failedMsg.append(das.getErrorMessage(errorID));
                failedMsg.append(LSEP);
            }
            catch (NodeException e) {
                Trace.out("WARNING: node name could not be found.");
            }
        }
        return failedMsg.toString();
    }

    String getSuccessMessage() {
        StringBuilder sucMsg = new StringBuilder();
        for (Node node : this.m_statMap.keySet()) {
            try {
                DatabaseActionStatus das = this.getDatabaseActionStatus(node);
                if (das.isError() || das.isWarning()) continue;
                String nodeName = node.getName();
                sucMsg.append(nodeName);
                sucMsg.append(":");
                for (String msg : das.getMessage()) {
                    sucMsg.append(msg);
                }
                sucMsg.append(LSEP);
            }
            catch (NodeException e) {
                Trace.out("WARNING: node name could not be found.");
            }
        }
        return sucMsg.toString();
    }

    public String getErrorMessage() {
        StringBuilder failedMsg = new StringBuilder();
        for (Node node : this.m_statMap.keySet()) {
            try {
                DatabaseActionStatus das = this.getDatabaseActionStatus(node);
                String nodeName = node.getName();
                failedMsg.append(nodeName);
                failedMsg.append(":");
                failedMsg.append(das.getErrorMessage());
            }
            catch (NodeException e) {
                Trace.out("WARNING: node name could not be found.");
            }
        }
        return failedMsg.toString();
    }
}

