/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.NodeRole;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.VersionMismatchException;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceType;
import oracle.cluster.database.StopOptions;
import oracle.cluster.deployment.DBServiceOperationInfo;
import oracle.cluster.home.Home;
import oracle.cluster.home.HomeException;
import oracle.cluster.home.HomeFactory;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.ExpressionFilter;
import oracle.cluster.impl.crs.cops.SimpleFilter;
import oracle.cluster.impl.database.DatabaseAction;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerCategoryException;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

class Common {
    Common() {
    }

    public void Common() {
    }

    protected static void versionCheck(Version resVersion, Version swVersion) throws DatabaseException {
        if (!resVersion.equals(swVersion)) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SRVM_GEN_VERSION_MISMATCH, resVersion.toString(), swVersion.toString());
        }
    }

    protected static void versionCheck(String oracleHome, Version version) throws DatabaseException {
        Version srvmversion = null;
        try {
            HomeFactory hf = HomeFactory.getInstance();
            Home home = hf.getHome(oracleHome);
            srvmversion = home.getVersion(oracleHome, true);
            Common.versionCheck(srvmversion, version);
        }
        catch (HomeException e) {
            Trace.out("Exception caught while retrieving version of srvm");
            throw new DatabaseException(e);
        }
    }

    protected static void homeVersionCheck(String oracleHome1, String oracleHome2) throws HomeException, VersionMismatchException {
        Version home1Version = null;
        Version home2Version = null;
        HomeFactory hf = HomeFactory.getInstance();
        Home home1 = hf.getHome(oracleHome1);
        Home home2 = hf.getHome(oracleHome2);
        home1Version = home1.getVersion(oracleHome1, true);
        home2Version = home2.getVersion(oracleHome2, true);
        Trace.out("Retrieved versions");
        if (!home1Version.equals(home2Version)) {
            throw new VersionMismatchException((MessageKey)PrCdMsgID.HOMES_VERSION_MISMATCH, home1Version.toString(), oracleHome1, home2Version.toString(), oracleHome2);
        }
        Trace.out("versions are same");
        if (Version.isPre112(home1Version)) {
            throw new VersionMismatchException((MessageKey)PrCdMsgID.PRE112_HOME_NOT_SUPPORTED, oracleHome1, home1Version.toString());
        }
        Trace.out("version check successful");
    }

    protected static Version getHomeVersion(String oracleHome) throws HomeException, VersionMismatchException {
        HomeFactory hf = HomeFactory.getInstance();
        Home home = hf.getHome(oracleHome);
        return home.getVersion(oracleHome, true);
    }

    protected static void checkPrimaryServerCategory(ServerGroup serverGroup) throws DatabaseException {
        if (null == serverGroup) {
            throw new DatabaseException((MessageKey)PrCsMsgID.INVALID_NAME, serverGroup);
        }
        try {
            if (!Cluster.isCluster()) {
                return;
            }
            if (!serverGroup.isServerPool()) {
                return;
            }
            CSSMode cssMode = new ClusterUtil().getCSSMode();
            if (cssMode == CSSMode.cssBCCLUSTERED) {
                ServerPool serverPool = ServerFactory.getInstance().getServerPool(serverGroup.getName());
                ServerCategory spCategory = ServerFactory.getInstance().getServerCategory(serverGroup);
                if (spCategory != null) {
                    if (spCategory.activeCSSRole() != NodeRole.HUB) {
                        throw new ServerGroupException((MessageKey)PrCsMsgID.PRIMARY_SERVICE_REQUIRE_HUB_POOL, spCategory.getName(), serverPool.getUserAssignedName(), spCategory.activeCSSRole().getRoleStr());
                    }
                } else {
                    List<Server> servers = serverPool.candidateServers();
                    String snames = "";
                    for (Server s : servers) {
                        Server.ServerRole srole = s.role();
                        if (srole == Server.ServerRole.HUB) continue;
                        if (snames.trim().length() > 0) {
                            snames = snames + String.valueOf(",");
                        }
                        snames = snames + s.node().getName();
                    }
                    if (snames != null && snames.trim().length() > 0) {
                        throw new ServerGroupException((MessageKey)PrCsMsgID.NON_CORE_MAIN_SGRP, snames, serverPool.getUserAssignedName());
                    }
                }
            }
        }
        catch (ServerCategoryException e) {
            throw new DatabaseException(e);
        }
        catch (ClusterUtilException e) {
            throw new DatabaseException(e);
        }
        catch (ServerException e) {
            throw new DatabaseException(e);
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
        catch (NodeException e) {
            throw new DatabaseException(e);
        }
    }

    protected static void checkPQServerCategory(ServerGroup pqServerGroup) throws DatabaseException {
        Common.checkLEAFServerCategory(pqServerGroup, ServiceType.PQ);
    }

    protected static void checkRFServerCategory(ServerGroup rfServerGroup) throws DatabaseException {
        Common.checkLEAFServerCategory(rfServerGroup, ServiceType.RF);
    }

    private static void checkLEAFServerCategory(ServerGroup serverGroup, ServiceType serviceType) throws DatabaseException {
        if (null == serverGroup) {
            throw new DatabaseException((MessageKey)PrCsMsgID.INVALID_NAME, serverGroup);
        }
        try {
            if (!Cluster.isCluster()) {
                return;
            }
            if (!serverGroup.isServerPool()) {
                return;
            }
            CSSMode cssMode = new ClusterUtil().getCSSMode();
            Trace.out("CSS mode: " + cssMode.toString());
            if (cssMode == CSSMode.cssBCCLUSTERED) {
                ServerPool serverPool = ServerFactory.getInstance().getServerPool(serverGroup.getName());
                ServerCategory spCategory = ServerFactory.getInstance().getServerCategory(serverGroup);
                if (spCategory != null) {
                    if (spCategory.activeCSSRole() == null) {
                        throw new ServerGroupException((MessageKey)PrCsMsgID.CATEGORY_MISSING_CSS_ROLE, spCategory.getName(), serverPool.getUserAssignedName());
                    }
                    if (serviceType == ServiceType.RF && spCategory.activeCSSRole() == NodeRole.HUB) {
                        throw new ServerGroupException((MessageKey)PrCsMsgID.RF_HUB_POOL_ERROR, spCategory.getName(), serverPool.getUserAssignedName(), spCategory.activeCSSRole().getRoleStr());
                    }
                } else {
                    List<Server> servers = serverPool.candidateServers();
                    String snames = "";
                    for (Server s : servers) {
                        Server.ServerRole srole = s.role();
                        if (srole == Server.ServerRole.RIM) continue;
                        if (snames.trim().length() > 0) {
                            snames = snames + String.valueOf(",");
                        }
                        snames = snames + s.node().getName();
                    }
                    if (snames != null && snames.trim().length() > 0) {
                        if (serviceType == ServiceType.PQ) {
                            throw new ServerGroupException((MessageKey)PrCsMsgID.NON_LEAF_PQ_SGRP, snames, serverPool.getUserAssignedName());
                        }
                        if (serviceType == ServiceType.RF) {
                            throw new ServerGroupException((MessageKey)PrCsMsgID.NON_LEAF_RF_SGRP, snames, serverPool.getUserAssignedName());
                        }
                    }
                }
            }
        }
        catch (ServerCategoryException e) {
            throw new DatabaseException(e);
        }
        catch (ClusterUtilException e) {
            throw new DatabaseException(e);
        }
        catch (ServerException e) {
            throw new DatabaseException(e);
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
        catch (NodeException e) {
            throw new DatabaseException(e);
        }
    }

    protected static StopOptions[] getSvcStopOptions(StopOptions[] dbOpts) {
        ArrayList<StopOptions> svcOpts = new ArrayList<StopOptions>();
        block6: for (StopOptions opt : dbOpts) {
            switch (opt) {
                case NORMAL: {
                    svcOpts.add(StopOptions.NONE);
                    continue block6;
                }
                case TRANSACTIONAL: 
                case IMMEDIATE: {
                    svcOpts.add(opt);
                    continue block6;
                }
                case TRANSACTIONAL_LOCAL: {
                    svcOpts.add(StopOptions.TRANSACTIONAL);
                    continue block6;
                }
                case ABORT: {
                    svcOpts.add(StopOptions.IMMEDIATE);
                    continue block6;
                }
            }
        }
        return svcOpts.toArray(new StopOptions[svcOpts.size()]);
    }

    protected static String getDrainID() {
        long rand = Math.round(Math.random() * 1.0E10);
        String randStr = ResourceLiterals.DRAIN_ID.toString() + String.valueOf(rand);
        return randStr;
    }

    static int calculateMaxDrain(Filter svcFilter) throws InvalidArgsException, ServiceException {
        if (svcFilter == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "Common-calculateMaxDrain2-1");
        }
        int maxDrain = 0;
        try {
            ExpressionFilter dtFilter = new ExpressionFilter(Filter.Operator.AND, svcFilter, new SimpleFilter(Filter.Comparator.GT, ResourceLiterals.DRAIN_TIMEOUT.toString(), "0"));
            Trace.out(" calculate max drain filter : " + dtFilter);
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Map<String, Map<String, String>> resultData = cf.searchEntities(CRSEntity.Type.ResourceInstance, false, dtFilter, ResourceType.Service.DRAIN_TIMEOUT.name());
            for (String riID : resultData.keySet()) {
                int timeout;
                Map<String, String> valueMap = resultData.get(riID);
                String drainStr = valueMap.get(ResourceType.Service.DRAIN_TIMEOUT.name());
                if (drainStr.trim().isEmpty() || (timeout = Integer.parseInt(drainStr)) <= maxDrain) continue;
                maxDrain = timeout;
            }
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new ServiceException(e);
        }
        return maxDrain;
    }

    protected static void checkDrainStopOpt(Integer drainTimeout, String stopOpt) throws ServiceException {
        if (drainTimeout != null && drainTimeout == 0 && stopOpt != null && stopOpt.equalsIgnoreCase(StopOptions.TRANSACTIONAL.toString())) {
            throw new ServiceException((MessageKey)PrCdMsgID.DRAIN_TIMEOUT_INVALID, drainTimeout);
        }
    }

    static Map<String, String> getNodeSvcMap(List<DBServiceOperationInfo> svcs) throws InvalidArgsException {
        if (svcs == null || svcs.isEmpty() || svcs.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "Common-getNodeSvcMap-1");
        }
        HashMap<String, String> nodeSvcMap = new HashMap<String, String>();
        for (DBServiceOperationInfo svcInfo : svcs) {
            List<String> nodes;
            boolean isRelocated;
            String resName;
            block8: {
                String svcName = svcInfo.getServiceName();
                String dbName = svcInfo.getDatabaseName();
                resName = ServiceImpl.getResourceName(dbName, svcName, false);
                Trace.out((Object)"processing service %s ", resName);
                isRelocated = svcInfo.isRelocated();
                boolean isStopped = svcInfo.isStopped();
                nodes = null;
                try {
                    if (isRelocated) {
                        nodes = Arrays.asList(svcInfo.getSourceNode());
                        break block8;
                    }
                    if (isStopped) {
                        nodes = svcInfo.getStopNodes();
                        break block8;
                    }
                    throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "Common-getNodeSvcMap-2");
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            Trace.out("service %s was %s %s", resName, isRelocated ? "relocated from" : "stopped on", nodes.toString());
            for (String node : nodes) {
                if (nodeSvcMap.containsKey(node)) {
                    StringBuilder sb = new StringBuilder((String)nodeSvcMap.get(node));
                    sb.append("," + resName);
                    nodeSvcMap.put(node, sb.toString());
                    continue;
                }
                nodeSvcMap.put(node, resName);
            }
        }
        return nodeSvcMap;
    }

    static String createActionsAttr(String acl, String resType, String resName) throws DatabaseException {
        if (!resType.equals(ResourceType.Database.NAME.toString()) && !resType.equals(ResourceType.Service.NAME.toString())) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "createActionsAttr001");
        }
        if (resName == null || resName.length() == 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "createActionsAttr002");
        }
        try {
            Trace.out("Creating ACTIONS attribute for resource " + resType);
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            List<String> users = new ArrayList<String>();
            List<String> groups = new ArrayList<String>();
            if (acl != null && acl.trim().length() != 0) {
                Trace.out((Object)"ACL of this resource : %s", acl);
                ResourcePermissionsImpl resPerm = cf.getPermissions(resName, acl);
                users = resPerm.getUsers();
                String owner = resPerm.getOwner();
                if (!users.contains(owner)) {
                    Trace.out("Add owner to users: " + owner);
                    users.add(owner);
                }
                groups = resPerm.getGroups();
            }
            ResourcePermissionsImpl actionPerm = cf.createPerm4ActionOp(users, groups);
            Trace.out("Created ResourcePermissionsImpl object for actions other than relocate_client, monitor and unmonitor");
            Util util = new Util();
            String crsUser = util.getOracleUser(util.getCRSHome(), null);
            String[] actions = resType.equals(ResourceType.Database.NAME.toString()) ? ResourceLiterals.DATABASE_ACTIONS.toString().split(",") : ResourceLiterals.SERVICE_ACTIONS.toString().split(",");
            HashMap<String, ResourcePermissionsImpl> perms = new HashMap<String, ResourcePermissionsImpl>();
            for (String action : actions) {
                Trace.out((Object)"action : %s", action);
                if (action.trim().equals(DatabaseAction.ACTION_RELOCATE_CLIENT)) {
                    if (!users.contains(crsUser)) {
                        Trace.out("Add crsuser to users: " + crsUser);
                        users.add(crsUser);
                    }
                    ResourcePermissionsImpl relocateClientActionPerm = cf.createPerm4ActionOp(users, groups);
                    Trace.out("Created permission object for relocate client actions: " + relocateClientActionPerm.getAclString());
                    perms.put(action, relocateClientActionPerm);
                    continue;
                }
                if (action.trim().equals("monitor") || action.trim().equals("unmonitor")) {
                    users.clear();
                    groups.clear();
                    Trace.out((Object)"CRS user : %s", crsUser);
                    users.add(crsUser);
                    ResourcePermissionsImpl monUnmonActionPerm = cf.createPerm4ActionOp(users, groups);
                    Trace.out("Created permission object for monitor and unmonitor actions: " + monUnmonActionPerm.getAclString());
                    perms.put(action, monUnmonActionPerm);
                    continue;
                }
                perms.put(action, actionPerm);
            }
            return ResourcePermissionsImpl.createActionsAttrValue(perms);
        }
        catch (CRSException e) {
            Trace.out("CRSException : " + e);
            throw new DatabaseException(e);
        }
        catch (UtilException e) {
            Trace.out("UtilException : " + (Object)((Object)e));
            throw new DatabaseException(e);
        }
        catch (InvalidArgsException e) {
            Trace.out("InvalidArgsException : " + e);
            throw new DatabaseException(e);
        }
    }

    static void validateNodes(List<String> nodes) throws InvalidArgsException {
        if (nodes == null || nodes.isEmpty() || nodes.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "Common-validateNodes-1");
        }
        try {
            ServerFactory sf = ServerFactory.getInstance();
            for (String node : nodes) {
                sf.getNode(node);
            }
        }
        catch (ServerException e) {
            Trace.out(e);
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)e, "Common-validateNodes-2");
        }
        catch (NodeException e) {
            Trace.out(e);
            throw new InvalidArgsException(e);
        }
    }
}

