/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.NotSupportedException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CardinalityException;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.database.AlreadyInOptionException;
import oracle.cluster.database.CardinalDatabase;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseOptionalArgs;
import oracle.cluster.database.DatabaseStopArgs;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.IncompatibleOptionException;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.RACOneNodeDatabase;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceCardinality;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ClusterResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.CardinalServiceImpl;
import oracle.cluster.impl.database.Common;
import oracle.cluster.impl.database.DBFilterFactory;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.RACOneNodeDatabaseImpl;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class CardinalDatabaseImpl
extends DatabaseImpl
implements CardinalDatabase {
    protected ClusterResourceImpl m_clusterResource;

    CardinalDatabaseImpl(ResourceAttribute nameAttr) throws DatabaseException {
        this(nameAttr, new Version());
    }

    CardinalDatabaseImpl(ResourceAttribute nameAttr, Version version) throws DatabaseException {
        super(nameAttr, version);
        try {
            this.m_clusterResource = (ClusterResourceImpl)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr, false);
        }
        catch (NotExistsException notExistsException) {
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    void create(String dbUniqueName, List<ServerGroup> serverGroupList, boolean isClusterDB, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        super.create(dbUniqueName, serverGroupList, isClusterDB, oracleHome, databaseOptions, version);
        try {
            this.m_clusterResource = (ClusterResourceImpl)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr);
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    void create(String dbUniqueName, List<ServerGroup> serverGroupList, DatabaseType dbType, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        super.create(dbUniqueName, serverGroupList, dbType, oracleHome, databaseOptions, version);
        try {
            this.m_clusterResource = (ClusterResourceImpl)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr);
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void start(List<Node> nodeList, List<StartOptions> startupOptions) throws AlreadyRunningException, CompositeOperationException, InstanceException {
        if (nodeList == null || nodeList.size() == 0) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList", nodeList);
        }
        if (startupOptions == null || startupOptions.size() == 0) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "startupOptions", startupOptions);
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            Enum[] soarr = startupOptions.toArray(new StartOptions[startupOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_OPEN_MODE.name(), Utils.getEnumString(soarr, String.valueOf(" ")));
            this.m_crsResource.start(nodeList, options);
            this.processDB4OJVMPatching(Arrays.asList(Utils.nodeList2StringArr(nodeList)), false);
        }
        catch (InvalidArgsException | CRSException | DatabaseException | NodeException e) {
            Trace.out("failed to start database on the specified nodes with the specified options. %s : %s", e.getClass(), this.getName(), e);
            throw new InstanceException(e);
        }
    }

    @Override
    public void start(List<Node> nodeList) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        if (nodeList == null || nodeList.isEmpty()) {
            throw new SoftwareModuleException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "racDatabaseImpl-start-nodes");
        }
        try {
            super.start(nodeList);
            this.processDB4OJVMPatching(Arrays.asList(Utils.nodeList2StringArr(nodeList)), false);
        }
        catch (InvalidArgsException | DatabaseException | NodeException e) {
            Trace.out("attempt to start database on the specified nodes failed with exception %s : %s", e.getClass(), this.getName(), e);
            throw new InstanceException(e);
        }
    }

    @Override
    public void start(DatabaseInstance instance) throws AlreadyRunningException, InstanceException {
        this.startNamedInstance(instance, DatabaseType.RAC, null);
    }

    @Override
    public void start(DatabaseInstance instance, List<StartOptions> startupOptions) throws AlreadyRunningException, InstanceException {
        if (startupOptions == null || startupOptions.size() == 0) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "startupOptions", startupOptions);
        }
        try {
            ArrayList<ResourceAttribute> options = new ArrayList<ResourceAttribute>();
            Enum[] soarr = startupOptions.toArray(new StartOptions[startupOptions.size()]);
            options.add(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_OPEN_MODE.name(), Utils.getEnumString(soarr, String.valueOf(" "))));
            this.startNamedInstance(instance, DatabaseType.RAC, options);
        }
        catch (CRSException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.START_NAMED_INST_FAILED, (Throwable)e, instance.getUserAssignedName(), this.getUserAssignedName());
        }
    }

    protected void startNamedInstance(DatabaseInstance instance, DatabaseType dbType, List<ResourceAttribute> overrideAttrs) throws AlreadyRunningException, InstanceException {
        if (instance == null) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "instance", instance);
        }
        String instName = instance.getUserAssignedName();
        try {
            String nodeName;
            if (dbType == DatabaseType.RAC && (nodeName = this.getRunningInstances().get(instName)) != null && !instance.node().getName().equalsIgnoreCase(nodeName)) {
                throw new InstanceException((MessageKey)PrCdMsgID.UP_INSTANCE_WITH_SAME_NAME_ALREADY_EXISTS, instName, this.getUserAssignedName(), nodeName);
            }
            ArrayList<ResourceAttribute> optionsList = new ArrayList<ResourceAttribute>();
            if (overrideAttrs != null) {
                optionsList.addAll(overrideAttrs);
            }
            optionsList.add(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), instName));
            this.m_crsResource.start(instance.node(), optionsList.toArray(new ResourceAttribute[optionsList.size()]));
            this.processDB4OJVMPatching(Arrays.asList(instance.node().getName()), false);
        }
        catch (CRSException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.START_NAMED_INST_FAILED, (Throwable)e, instName, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.START_NAMED_INST_FAILED, (Throwable)e, instName, this.getUserAssignedName());
        }
        catch (InvalidArgsException | DatabaseException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.START_NAMED_INST_FAILED, (Throwable)e, instName, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.START_NAMED_INST_FAILED, (Throwable)e, instName, this.getUserAssignedName());
        }
    }

    @Override
    public void startOnServerPools(List<ServerPool> spList) throws InvalidArgsException, AlreadyRunningException, CompositeOperationException, NotSupportedException, DatabaseException {
        this.start(new StartOptions[0], spList);
    }

    @Override
    public void start(StartOptions[] startupOptions, List<ServerPool> spList) throws InvalidArgsException, AlreadyRunningException, CompositeOperationException, NotSupportedException, DatabaseException {
        this.start(spList, startupOptions, 0);
    }

    @Override
    public void start(List<ServerPool> spList, StartOptions[] startupOptions, int concurrency) throws InvalidArgsException, AlreadyRunningException, CompositeOperationException, NotSupportedException, DatabaseException {
        if (spList == null || spList.isEmpty() || spList.contains(null) || startupOptions == null || Arrays.asList(startupOptions).contains(null) || concurrency < 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-start04");
        }
        DatabaseType dbType = this.databaseType();
        if (this.isAdminManaged() || !Cluster.isCluster()) {
            throw new NotSupportedException((MessageKey)PrCdMsgID.SP_OPERATION_NOT_SUPPORTED, this.getUserAssignedName());
        }
        try {
            this.validateServerPools(spList);
        }
        catch (NotRunningException e) {
            throw new DatabaseException(e);
        }
        this.startHelper(spList, startupOptions, concurrency);
    }

    @Override
    public void startServices(List<Service> services, Node node) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        this.startServices(services, node, false);
    }

    @Override
    public void startServices(List<Service> services, Node node, boolean global) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (services == null || services.size() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "services", services);
        }
        if (node == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", node);
        }
        try {
            ServiceArgs args = new ServiceArgs();
            args.setGlobal(global);
            this.internalStartServices(services, node, null, args);
        }
        catch (ServiceException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void startServices(List<Service> services, StartOptions[] startupOptions, Node node) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        this.startServices(services, startupOptions, node, false);
    }

    @Override
    public void startServices(List<Service> services, StartOptions[] startupOptions, Node node, boolean global) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (services == null || services.size() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "services", services);
        }
        if (startupOptions == null || startupOptions.length == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"startupOptions", startupOptions});
        }
        if (node == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", node);
        }
        try {
            ServiceArgs args = new ServiceArgs();
            args.setGlobal(global);
            args.setStartOptions(startupOptions);
            this.internalStartServices(services, node, null, args);
        }
        catch (ServiceException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void startServices(ServerPool sg, boolean global) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (sg == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverpool", sg);
        }
        try {
            ServiceArgs args = new ServiceArgs();
            args.setGlobal(global);
            this.internalStartServices(null, null, sg, args);
        }
        catch (ServiceException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void startServices(ServerPool sg, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (sg == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverpool", sg);
        }
        this.internalStartServices(null, null, sg, args);
    }

    @Override
    public void startServices(ServerPool sg, StartOptions[] startupOptions, boolean global) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (sg == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverpool", sg);
        }
        if (startupOptions == null || startupOptions.length == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"startupOptions", startupOptions});
        }
        try {
            ServiceArgs args = new ServiceArgs();
            args.setGlobal(global);
            args.setStartOptions(startupOptions);
            this.internalStartServices(null, null, sg, args);
        }
        catch (ServiceException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void startServices(List<Service> services, Node node, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (services == null || services.size() == 0 || node == null || args == null) {
            String extra = services == null ? "services" : (node == null ? "node" : (args == null ? "args" : "serv size"));
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "cardinalDatabaseImpl-startServices01 " + extra);
        }
        this.internalStartServices(services, node, null, args);
    }

    @Override
    public void startServices(Node node, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (node == null || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "cardinalDatabaseImpl-startServices02");
        }
        this.internalStartServices(null, node, null, args);
    }

    @Override
    public void stop(List<Node> nodeList, List<StopOptions> stopOptions, boolean force) throws AlreadyStoppedException, CompositeOperationException, InstanceException {
        try {
            this.stop(nodeList, stopOptions, force, false);
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            throw new InstanceException(e);
        }
    }

    @Override
    public void stop(List<Node> nodes, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        this.stop(nodes, force, false, new DatabaseOptionalArgs());
    }

    @Override
    public void stop(List<Node> nodes, boolean force, boolean allowServices2Restart) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        Trace.out("stop: force %b, allowServices2Restart: %b", force, allowServices2Restart);
        this.stop(nodes, force, allowServices2Restart, new DatabaseOptionalArgs());
    }

    @Override
    public void stop(List<Node> nodes, List<StopOptions> stopOptions, boolean force, boolean allowServices2Restart) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (stopOptions == null) {
            throw new SoftwareModuleException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-stop04-1");
        }
        DatabaseOptionalArgs args = new DatabaseOptionalArgs();
        try {
            args.setStopModes(stopOptions.toArray(new StopOptions[stopOptions.size()]));
        }
        catch (DatabaseException e) {
            throw new SoftwareModuleException(e);
        }
        this.stop(nodes, force, allowServices2Restart, args);
    }

    @Override
    public void stop(List<Node> nodes, boolean force, boolean allowServices2Restart, DatabaseOptionalArgs args) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (args == null) {
            throw new SoftwareModuleException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-stop05-1");
        }
        DatabaseStopArgs stopArgs = DatabaseImpl.createDBStopArgs(args);
        stopArgs.setForceFlag(force);
        stopArgs.setFailoverFlag(allowServices2Restart);
        this.stop(nodes, stopArgs);
    }

    @Override
    public void stop(List<Node> nodes, DatabaseStopArgs args) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, DatabaseException {
        if (nodes == null || nodes.isEmpty() || nodes.contains(null)) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-stop06-1");
        }
        if (args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-stop06-2");
        }
        boolean failover = args.getFailoverFlag() != null && args.getFailoverFlag() != false;
        try {
            this.internalSvcAndDBStopHelper(nodes, failover, false, args);
        }
        catch (InstanceException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void stop(List<ServerPool> spList) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, NotRunningException, NotSupportedException, DatabaseException {
        this.stopOnServerPools(spList, false);
    }

    @Override
    public void stopOnServerPools(List<ServerPool> spList, boolean force) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, NotRunningException, NotSupportedException, DatabaseException {
        this.stop(spList, new StopOptions[0], force);
    }

    @Override
    public void stop(List<ServerPool> spList, StopOptions[] stopOptions, boolean forceFlag) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, NotRunningException, NotSupportedException, DatabaseException {
        this.stop(spList, stopOptions, 0, forceFlag);
    }

    @Override
    public void stop(List<ServerPool> spList, StopOptions[] stopOptions, int concurrency, boolean forceFlag) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, NotRunningException, NotSupportedException, DatabaseException {
        if (spList == null || spList.isEmpty() || spList.contains(null) || stopOptions == null || Arrays.asList(stopOptions).contains(null) || concurrency < 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-stop08");
        }
        DatabaseOptionalArgs args = new DatabaseOptionalArgs();
        args.setStopModes(stopOptions);
        args.setStopConcurrency(concurrency);
        args.setForceFlag(forceFlag);
        this.stop(spList, args);
    }

    @Override
    public void stop(List<ServerPool> spList, DatabaseOptionalArgs args) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, NotRunningException, NotSupportedException, DatabaseException {
        if (spList == null || spList.size() == 0 || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-stop09");
        }
        if (this.isAdminManaged() || !Cluster.isCluster()) {
            throw new NotSupportedException((MessageKey)PrCdMsgID.SP_OPERATION_NOT_SUPPORTED, this.getUserAssignedName());
        }
        this.validateServerPools(spList);
        this.stopHelper(spList, args);
    }

    @Override
    public void stopServices(ServerPool sg, ServiceArgs args) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        if (sg == null || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-stopServices01");
        }
        this.internalStopServices(null, null, sg, args);
    }

    @Override
    public void remove(Node node, boolean force) throws AlreadyRunningException, InstanceException {
        if (node == null) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", node);
        }
        try {
            ArrayList<Node> nodelist = new ArrayList<Node>(1);
            nodelist.add(node);
            this.m_crsResource.remove(nodelist, force);
        }
        catch (CompositeOperationException e) {
            throw new InstanceException(e);
        }
        catch (CRSException e) {
            throw new InstanceException(e);
        }
        catch (NotExistsException e) {
            throw new InstanceException(e);
        }
    }

    @Override
    public int getCardinality() throws CardinalityException {
        return this.m_clusterResource.getCardinality();
    }

    @Override
    public int getMaxCardinality() throws CardinalityException {
        return this.m_clusterResource.getMaxCardinality();
    }

    @Override
    public void setMaxCardinality(int maxCard) throws CardinalityException {
        throw new RuntimeException("FIXME: NOT IMPLEMENTED YET");
    }

    @Override
    public void start(int count) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        this.m_clusterResource.start(count);
    }

    public void start(int count, List<StartOptions> startupOptions) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        if (startupOptions == null || startupOptions.size() == 0) {
            throw new CardinalityException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "startupOptions", startupOptions);
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[1];
            Enum[] soarr = startupOptions.toArray(new StartOptions[startupOptions.size()]);
            options[0] = CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_OPEN_MODE.name(), Utils.getEnumString(soarr, String.valueOf(" ")));
            this.m_clusterResource.start(count, options);
        }
        catch (CRSException e) {
            throw new CardinalityException(e);
        }
    }

    @Override
    public void stop(int count, boolean force) throws CompositeOperationException, CardinalityException {
        try {
            this.m_clusterResource.stop(count, force);
        }
        catch (AlreadyStoppedException e) {
            throw new CardinalityException(e);
        }
    }

    @Override
    public void remove(int count, boolean force) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        this.m_clusterResource.remove(count, force);
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            if (this.isClusterDatabase()) {
                throw new RelocateException((MessageKey)PrCdMsgID.CANNOT_RELOCATE_UNIFORM_DB, this.getUserAssignedName());
            }
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
        catch (DatabaseException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            if (this.isClusterDatabase()) {
                throw new RelocateException((MessageKey)PrCdMsgID.CANNOT_RELOCATE_UNIFORM_DB, this.getUserAssignedName());
            }
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
        catch (DatabaseException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    private void stopDbAndServicesOnNodes(List<Node> nodeList, boolean keepDepTgt, DatabaseOptionalArgs args) throws AlreadyStoppedException, CompositeOperationException, InstanceException {
        try {
            this.internalSvcAndDBStopHelper(nodeList, keepDepTgt, false, args);
        }
        catch (DatabaseException e) {
            throw new InstanceException(e);
        }
    }

    protected RACOneNodeDatabase convertToRACOneNodeDB(DatabaseOptionalArgs dbOptArgs) throws DatabaseException {
        DatabaseOptionalArgs dbArgs = dbOptArgs;
        if (dbArgs == null) {
            dbArgs = new DatabaseOptionalArgs();
        }
        try {
            ResourceAttribute resAttr;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ServerFactory serverFactory = ServerFactory.getInstance();
            String instName = dbArgs.getInstanceName();
            boolean isAdminMgd = this.isDBCentric();
            if (isAdminMgd) {
                new Util().checkOracleUser(this.getOracleHome(), new SystemFactory().CreateSystem().isUnixSystem());
                int numInsts = this.configuredInstances().size();
                if (numInsts != 1) {
                    throw new DatabaseException((MessageKey)(numInsts > 1 ? PrCdMsgID.RAC2RAC1_CONVERT_ADMIN_NOT_ONE_INST : PrCdMsgID.RAC2RAC1_CONVERT_ADMIN_NO_INST), this.getUserAssignedName());
                }
                CardinalDatabaseImpl.validateName(instName, true);
                if (!instName.endsWith("_1") && !instName.endsWith("_2")) {
                    instName = instName + "_1";
                }
            } else {
                String dbName = this.getDBName();
                if (dbName.length() == 0) {
                    dbName = this.getUserAssignedName();
                }
                int nameLen = dbName.length();
                instName = dbName.substring(0, nameLen > 12 ? 12 : nameLen) + '_' + "1";
            }
            if (this.services().size() == 0) {
                throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_NO_SERVICE, this.getUserAssignedName());
            }
            List<ServerGroup> sgList = this.serverGroups();
            if (sgList.size() > 1) {
                throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED_GT1_POOLS, this.getUserAssignedName(), sgList.toString());
            }
            ServerGroup dbServerPool = sgList.get(0);
            List<Node> rnList = this.m_crsResource.fetchRunningNodes();
            if (rnList.size() > 1) {
                throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED_GT1_UP, this.getUserAssignedName(), rnList.toString());
            }
            List<Service> svcList = this.services();
            if (svcList.size() > 0) {
                ManagementPolicy mgmtPolicy = ManagementPolicy.AUTOMATIC;
                if (this.getServices(mgmtPolicy).size() == 0) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED_MANUAL_MGMT, this.getUserAssignedName(), mgmtPolicy.toString());
                }
                StringBuilder sbTAF = new StringBuilder();
                for (Service svc : svcList) {
                    if (!isAdminMgd || svc.getTAF() != ServiceTAF.PRECONNECT) continue;
                    if (sbTAF.length() > 0) {
                        sbTAF.append(",");
                    }
                    sbTAF.append(svc.getUserAssignedName());
                }
                if (sbTAF.length() > 0) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED_TAF_PRE, this.getUserAssignedName(), sbTAF.toString(), ServiceTAF.PRECONNECT.toString());
                }
                ResourceAttribute svcTypeAttr = crsFactory.create(ResourceType.Service.NAME.name(), ResourceType.Service.NAME.toString());
                ArrayList<ResourceAttribute> raList = new ArrayList<ResourceAttribute>();
                raList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), ServiceCardinality.SINGLETON.toString()));
                raList.add(crsFactory.create(ResourceType.Service.SERVER_POOLS.name(), dbServerPool.getName()));
                ServerGroup svcPool = null;
                for (Service svc : svcList) {
                    if (isAdminMgd) {
                        svcPool = ((ServiceImpl)svc).serverGroup();
                    }
                    CRSResourceImpl crsResource = (CRSResourceImpl)svc.crsResource();
                    if (!isAdminMgd) {
                        resAttr = crsResource.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name()).get(0);
                        ResourceDependency.updateDependencyAttrModifier(true, resAttr, svcTypeAttr, ResourceDependency.DepType.DISPERSION_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP);
                        raList.add(resAttr);
                    }
                    if (raList.size() > 0) {
                        crsResource.update(raList);
                    }
                    if (!isAdminMgd) continue;
                    try {
                        svcPool.remove();
                    }
                    catch (CompositeOperationException e) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
                    }
                }
            }
            ResourceAttribute dbTypeAttr = crsFactory.create(ResourceType.Database.NAME.name(), ResourceType.Database.NAME.toString());
            int timeout = dbArgs.getOnlineRelocationTimeout();
            if (timeout <= 0) {
                timeout = 30;
            }
            ArrayList<ResourceAttribute> raList = new ArrayList<ResourceAttribute>();
            raList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), String.valueOf(1)));
            raList.add(crsFactory.create(ResourceType.Database.DATABASE_TYPE.name(), DatabaseType.RACOneNode.toString()));
            raList.add(crsFactory.create(ResourceType.Database.ONLINE_RELOCATION_TIMEOUT.name(), String.valueOf(timeout)));
            raList.add(crsFactory.create(ResourceType.Database.FAILURE_THRESHOLD.name(), String.valueOf(2)));
            raList.add(crsFactory.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceLiterals.RESTART_ATTEMPTS_RACONE.toString()));
            if (!isAdminMgd) {
                resAttr = this.m_crsResource.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name()).get(0);
                ResourceDependency.updateDependencyAttrModifier(true, resAttr, dbTypeAttr, ResourceDependency.DepType.DISPERSION_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP);
                raList.add(resAttr);
            }
            raList.add(crsFactory.create(ResourceType.Database.USR_ORA_INST_NAME.name(), instName));
            if (isAdminMgd) {
                raList.add(crsFactory.create(ResourceType.Database.INSTANCE_FAILOVER.name(), ResourceLiterals.ENABLED_VALUE.toString()));
            }
            this.m_crsResource.update(raList.toArray(new ResourceAttribute[raList.size()]));
            try {
                if (!this.isRunning()) {
                    this.m_crsResource.purgePerX(new String[]{ResourceType.Database.USR_ORA_INST_NAME.name(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name()});
                } else {
                    this.m_crsResource.purgePerX(new String[]{ResourceType.Database.USR_ORA_INST_NAME.name()});
                }
            }
            catch (NotExistsException e) {
                Trace.out("IGNORED:" + e.getMessage());
            }
            return new RACOneNodeDatabaseImpl(this.m_nameAttr);
        }
        catch (UtilException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (AlreadyExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RAC2RAC1_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void updateStartMode(List<ServerPool> spList, StartOptions[] soArr) throws InvalidArgsException, IncompatibleOptionException, AlreadyInOptionException, NotRunningException, NotSupportedException, DatabaseException {
        this.m_DbAction.startAction(spList, soArr);
    }

    protected List<Node> validateServerPools(List<ServerPool> spList) throws InvalidArgsException, NotSupportedException, NotRunningException, DatabaseException {
        if (spList == null || spList.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "databaseImpl-validateServerPools");
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            String[] poolsArr = this.serverPoolsHelper();
            String[] pqPoolsArr = this.pqServerPoolsHelper();
            if (poolsArr == null || poolsArr.length == 0) {
                throw new NotRunningException((MessageKey)PrCrMsgID.RES_NOT_HOSTED_BY_SRVPOOL, this.getUserAssignedName(), Utils.list2String(spList, ","));
            }
            List<String> pools = Arrays.asList(poolsArr);
            List<String> pqPools = Arrays.asList(pqPoolsArr);
            boolean containsHubPool = false;
            StringBuilder pqPoolNames = null;
            for (ServerPool sp : spList) {
                String resName = sp.getName();
                String name = sp.getUserAssignedName();
                if (!pools.contains(resName)) {
                    throw new NotRunningException((MessageKey)PrCrMsgID.RES_NOT_HOSTED_BY_SRVPOOL, this.getUserAssignedName(), name);
                }
                if (pqPools.contains(resName)) {
                    if (pqPoolNames == null) {
                        pqPoolNames = new StringBuilder(name);
                    } else {
                        pqPoolNames.append(",").append(name);
                    }
                } else {
                    containsHubPool = true;
                }
                List<Server> servers = sp.servers();
                if (servers == null || servers.isEmpty()) {
                    throw new NotRunningException((MessageKey)PrCdMsgID.NO_ACTIVE_SERVERS_IN_SP, name);
                }
                for (Server server : servers) {
                    nodes.add(server.node());
                }
            }
            if (!containsHubPool) {
                Trace.out("No hub pool was specified. Checking for hub instances ...");
                List<Node> runningNodes = this.crsResource().fetchRunningNodes();
                boolean isHubInstance = false;
                for (Node node : runningNodes) {
                    if (node.server().role() != Server.ServerRole.HUB) continue;
                    isHubInstance = true;
                    break;
                }
                if (!isHubInstance) {
                    throw new NotSupportedException((MessageKey)PrCdMsgID.PQPOOL_OPERATION_NOT_SUPPORTED, pqPoolNames.toString());
                }
            }
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
        catch (NodeException e) {
            throw new DatabaseException(e);
        }
        catch (ServerGroupException e) {
            throw new DatabaseException(e);
        }
        catch (ServerException e) {
            throw new DatabaseException(e);
        }
        return nodes;
    }

    @Override
    public void relocateServices(Node srcNode, ServiceArgs args) throws DatabaseException {
        if (srcNode == null || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-relocateServices01");
        }
        this.relocateServicesHelper(null, srcNode, null, args);
    }

    @Override
    public void relocateServices(Node srcNode, Node tgtNode, ServiceArgs args) throws DatabaseException {
        if (srcNode == null || tgtNode == null || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-relocateServices02");
        }
        this.relocateServicesHelper(null, srcNode, tgtNode, args);
    }

    @Override
    public void relocateServices(List<String> svcNames, Node srcNode, ServiceArgs args) throws DatabaseException {
        if (svcNames == null || srcNode == null || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-relocateServices03");
        }
        this.relocateServicesHelper(svcNames, srcNode, null, args);
    }

    @Override
    public void relocateServices(List<String> svcNames, Node srcNode, Node tgtNode, ServiceArgs args) throws DatabaseException {
        if (svcNames == null || srcNode == null || tgtNode == null || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalDatabaseImpl-relocateServices04");
        }
        this.relocateServicesHelper(svcNames, srcNode, tgtNode, args);
    }

    void relocateServicesHelper(List<String> svcNames, Node srcNode, Node tgtNode, ServiceArgs args) throws DatabaseException {
        try {
            Filter svcFilter;
            int waitTime;
            String tgtNodeName;
            Boolean waitVal;
            Integer drainTimeout;
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ServiceArgs.RelocateOption[] relocOptions = args.getRelocateOptions();
            boolean force = true;
            boolean disconnect = false;
            boolean noreplay = false;
            if (relocOptions != null) {
                block21: for (ServiceArgs.RelocateOption opt : relocOptions) {
                    switch (opt) {
                        case DISCONNECT: {
                            attrList.add(cf.create(ResourceType.Service.USR_ORA_DISCONNECT.name(), Boolean.toString(true)));
                            force = true;
                            disconnect = true;
                            continue block21;
                        }
                        case NOREPLAY: {
                            attrList.add(cf.create(ResourceType.Service.SESSION_NOREPLAY.name(), Boolean.toString(true)));
                            noreplay = true;
                            continue block21;
                        }
                        default: {
                            throw new RelocateException((MessageKey)PrCrMsgID.UNSUPPORTED_RELOCATE_OPTION, opt.toString());
                        }
                    }
                }
                if (noreplay && !disconnect) {
                    throw new RelocateException((MessageKey)PrCdMsgID.NOREPLAY_NOT_ALLOWED, new Object[0]);
                }
            }
            Enum[] stopOptions = args.getStopOptions();
            String stopOpt = null;
            if (stopOptions != null && stopOptions.length > 0) {
                stopOpt = Utils.getEnumString(stopOptions, String.valueOf(" "));
                attrList.add(cf.create(ResourceType.Service.USR_ORA_STOP_MODE.name(), stopOpt));
            }
            if ((drainTimeout = args.getDrainTimeout()) != null) {
                try {
                    Common.checkDrainStopOpt(drainTimeout, stopOpt);
                }
                catch (ServiceException e) {
                    throw new DatabaseException(e);
                }
                String timeout = drainTimeout > -1 ? drainTimeout.toString() : "";
                attrList.add(cf.create(ResourceType.Service.DRAIN_TIMEOUT.name(), timeout));
            }
            boolean wait = (waitVal = args.getWait()) != null ? waitVal : false;
            String drainID = null;
            if (wait) {
                drainID = Common.getDrainID();
                attrList.add(cf.create(ResourceType.Service.DRAIN_ID.name(), drainID));
            }
            String pdb = args.getPDB();
            try {
                tgtNodeName = tgtNode != null ? tgtNode.getName() : null;
            }
            catch (NodeException e) {
                throw new RelocateException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
            }
            HashMap<String, String> nodeSvcMap = new HashMap<String, String>();
            int n = waitTime = drainTimeout != null && drainTimeout != -1 ? drainTimeout : 0;
            if (svcNames != null) {
                if (svcNames.size() == 1) {
                    try {
                        CardinalServiceImpl service = new CardinalServiceImpl(cf.create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(this.getUserAssignedName(), svcNames.get(0), false)));
                        CRSFactoryImpl.relocateResources(service.crsResource(), srcNode.getName(), tgtNodeName, force, attrList.toArray(new ResourceAttribute[attrList.size()]), nodeSvcMap);
                        if (wait) {
                            String drainT;
                            if (drainTimeout == null && (drainT = service.getDrainTimeout()) != null && !drainT.trim().isEmpty()) {
                                waitTime = Integer.parseInt(drainT);
                            }
                            if (waitTime > 0) {
                                this.waitForDrainCompletion(drainID, waitTime, nodeSvcMap, args.getVerboseListener());
                            } else {
                                Trace.out("User opted wait for drain, but neither drainTimeout nor res attr is set");
                            }
                        }
                        return;
                    }
                    catch (NotExistsException e) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
                    }
                    catch (ServiceException e) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
                    }
                }
                svcFilter = DBFilterFactory.getSvcList4DB(this.getName(), svcNames);
            } else {
                svcFilter = DBFilterFactory.getServices4DB(this.getName());
            }
            if (pdb != null) {
                Filter pdbFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQI, ResourceType.Service.PLUGGABLE_DATABASE.name(), pdb);
                svcFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, svcFilter, pdbFilter);
            }
            try {
                Filter nodeFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.CRS_LAST_SERVER.toString(), srcNode.getName());
                Filter onlineFilter = FilterFactoryImpl.getFilter4RunningState();
                nodeFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, nodeFilter, onlineFilter);
                svcFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, svcFilter, nodeFilter);
            }
            catch (NodeException e) {
                throw new DatabaseException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
            }
            if (drainTimeout == null) {
                waitTime = Common.calculateMaxDrain(svcFilter);
            }
            CRSFactoryImpl.relocateResources(svcFilter, tgtNodeName, force, attrList.toArray(new ResourceAttribute[attrList.size()]), nodeSvcMap);
            if (wait) {
                if (waitTime > 0) {
                    this.waitForDrainCompletion(drainID, waitTime, nodeSvcMap, args.getVerboseListener());
                } else {
                    Trace.out("User opted wait for drain, but neither drainTimeout nor res attr is set");
                }
            }
        }
        catch (CompositeOperationException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotRunningException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (RelocateException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (InvalidArgsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServiceException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SERV_RELOCATE_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }
}

