/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.cvu;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.cvu.CVU;
import oracle.cluster.cvu.CVUConstants;
import oracle.cluster.cvu.CVUException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.nodeapps.NetworkImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.InstallException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.opsctl.OptEnum;

public class CVUImpl
extends SoftwareModuleImpl
implements CVU,
CVUConstants {
    private ResourceAttribute m_nameAttr;
    private static CVUImpl s_instance = null;
    private static boolean s_cvuInitialized = false;

    private CVUImpl() throws CVUException {
        Trace.out("Getting CRS resource.");
        try {
            this.getCRSResource();
        }
        catch (NotExistsException notExistsException) {
        }
        catch (CRSException e) {
            Trace.out("Caught CRS exception \"%s\": %s", this.m_nameAttr.getValue(), e.getMessage());
            throw new CVUException(e);
        }
        Trace.out("Initializing CVUimpl");
        Trace.out("CVU impl initialized: " + s_cvuInitialized);
        if (s_cvuInitialized) {
            Trace.out("CVU impl already initialized.");
            return;
        }
        CVUImpl.initializeCVU();
        Trace.out("CVU implementation is initialized.");
    }

    private static void initializeCVU() {
        s_cvuInitialized = true;
    }

    private void getCRSResource() throws NotExistsException, CRSException, CVUException {
        if (this.m_crsResource != null) {
            return;
        }
        CRSFactoryImpl crsFactoryImpl = CRSFactoryImpl.getInstance();
        String resourceName = CVUImpl.getResourceName();
        Trace.out("Creating CVU resource type: " + resourceName);
        this.m_nameAttr = crsFactoryImpl.create(ResourceType.CVU.NAME.name(), resourceName);
        Trace.out("Created CVU resource type: " + resourceName);
        this.m_name = this.m_nameAttr.getValue();
        String[] values = this.m_name.split(Pattern.quote(String.valueOf('.')));
        this.m_displayName = values[1];
        Trace.out("Getting CRS resource : " + this.m_nameAttr.getValue());
        this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
        Trace.out("Got CRS resource \"%s\"", this.m_nameAttr.getValue());
    }

    void create(Version version, int checkInterval, String destLoc) throws AlreadyExistsException, CVUException {
        if (checkInterval < 10) {
            throw new CVUException((MessageKey)PrCnMsgID.BELOW_MIN_CVU_CHECK_INTERVAL, checkInterval, 10);
        }
        if (checkInterval > 0x2222222) {
            throw new CVUException((MessageKey)PrCnMsgID.ABOVE_MAX_CVU_CHECK_INTERVAL, checkInterval, 0x2222222);
        }
        boolean isSetDestLoc = false;
        if (destLoc != null && !destLoc.equals("")) {
            isSetDestLoc = true;
            this.validateDestLoc(destLoc);
        }
        int intervalSeconds = checkInterval * 60;
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        boolean isApplicationCluster = false;
        try {
            isApplicationCluster = clustInfo.isApplicationCluster();
        }
        catch (InstallException e) {
            throw new CVUException(e);
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute netAttr = crsFactory.create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(String.valueOf(NodeAppsFactory.getInstance().getDefaultNetworkNumber())));
            if (!crsFactory.isRegistered(netAttr.getValue(), CRSEntity.Type.Resource) && !isApplicationCluster) {
                throw new CVUException((MessageKey)PrCrMsgID.CVU_NETWORK_RES_NOT_EXISTS, new Object[0]);
            }
            ResourceAttribute cvuTypeAttr = crsFactory.create(ResourceType.CVU.NAME.name(), ResourceType.CVU.NAME.toString());
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(cvuTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.CVU.NAME.name())) {
                    attr.setValue(CVUImpl.getResourceName());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.CVU.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.CVU_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.CVU.RUN_INTERVAL.name())) {
                    attr.setValue(String.valueOf(intervalSeconds));
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.CVU.SCRIPT_TIMEOUT.name())) {
                    attr.setValue(ResourceLiterals.CVU_SCRIPT_TIMEOUT.toString());
                    continue;
                }
                if (!isSetDestLoc || !attr.getName().equalsIgnoreCase(ResourceType.CVU.CV_DESTLOC.name())) continue;
                attr.setValue(destLoc);
            }
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            if (!isApplicationCluster) {
                ResourceDependency hardDep = crsFactory.createResourceDependency(netAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                ResourceDependency pullupDep = crsFactory.createResourceDependency(netAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
                String startDependencyString = ResourceDependency.toString(hardDep, pullupDep);
                attrList.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), startDependencyString));
                attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), crsFactory.createResourceDependency(netAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP).toString()));
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
        }
        catch (CRSException e) {
            throw new CVUException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new CVUException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    static synchronized CVUImpl getInstance() throws CVUException {
        if (null == s_instance) {
            s_instance = new CVUImpl();
        }
        return s_instance;
    }

    @Override
    public int getCheckTime() throws CVUException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.CVU.RUN_INTERVAL.name());
            int checkInterval = Integer.parseInt(attr.getValue().trim()) / 60;
            return checkInterval;
        }
        catch (CRSException e) {
            throw new CVUException((MessageKey)PrCnMsgID.GET_CVU_CHECK_INTERVAL_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NumberFormatException ne) {
            throw new CVUException((MessageKey)PrCnMsgID.GET_CVU_CHECK_INTERVAL_FAILED, (Throwable)ne, this.getUserAssignedName());
        }
    }

    @Override
    public void setCheckTime(int checkInterval) throws CVUException {
        if (checkInterval < 10) {
            throw new CVUException((MessageKey)PrCnMsgID.BELOW_MIN_CVU_CHECK_INTERVAL, checkInterval, 10);
        }
        if (checkInterval > 0x2222222) {
            throw new CVUException((MessageKey)PrCnMsgID.ABOVE_MAX_CVU_CHECK_INTERVAL, checkInterval, 0x2222222);
        }
        int intervalSeconds = checkInterval * 60;
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.CVU.RUN_INTERVAL.name(), String.valueOf(intervalSeconds)));
        }
        catch (CRSException e) {
            throw new CVUException((MessageKey)PrCnMsgID.SET_CVU_CHECK_INTERVAL_FAILED, (Throwable)e, checkInterval);
        }
    }

    private void validateDestLoc(String destLoc) throws CVUException {
        if (destLoc.equals("")) {
            return;
        }
        File destDirFile = new File(destLoc);
        if (!destDirFile.isAbsolute()) {
            throw new CVUException((MessageKey)PrCnMsgID.DEST_LOC_NOT_ABSOLUTE_PATH, destLoc, OptEnum.CV_DESTLOC.getKeyword());
        }
        if (destDirFile.isFile()) {
            throw new CVUException((MessageKey)PrCnMsgID.DEST_LOC_IS_FILE, destLoc, OptEnum.CV_DESTLOC.getKeyword());
        }
        String nodeStr = null;
        try {
            ClusterwareInfo clusterInfo = new ClusterwareInfo();
            String crsHome = clusterInfo.getCRSHome(new Version());
            List<String> nodeList = clusterInfo.getActiveClusterNodes(crsHome);
            String[] nodeArr = nodeList.toArray(new String[0]);
            nodeStr = Utils.strListToList(nodeList);
            ClusterCmd cmd = new ClusterCmd();
            if (!destDirFile.exists()) {
                cmd.createDirWithModeOnNodes(nodeArr, destLoc);
            }
            if (nodeArr.length > 1 && Cluster.isSharedPath(destLoc, nodeArr)) {
                throw new CVUException((MessageKey)PrCnMsgID.DEST_LOC_IS_SHARED, destLoc, OptEnum.CV_DESTLOC.getKeyword());
            }
            if (!cmd.isDirWritable(nodeArr, destLoc)) {
                throw new CVUException((MessageKey)PrCnMsgID.DEST_LOC_NO_PERMISSION, destLoc, OptEnum.CV_DESTLOC.getKeyword());
            }
        }
        catch (ClusterException e) {
            Trace.out("ce occurred when trying to create CV_DESTLOC:" + e.getMessage());
            throw new CVUException((MessageKey)PrCnMsgID.DEST_LOC_NOT_CREATED, (Throwable)e, destLoc, nodeStr);
        }
        catch (InstallException e) {
            Trace.out("ie occurred when trying to create CV_DESTLOC:" + e.getMessage());
            throw new CVUException((MessageKey)PrCnMsgID.DEST_LOC_NOT_CREATED, (Throwable)e, destLoc, nodeStr);
        }
        catch (SharedDeviceException e) {
            Trace.out("sde occurred when trying to create CV_DESTLOC:" + e.getMessage());
            throw new CVUException((MessageKey)PrCnMsgID.DEST_LOC_NOT_CREATED, (Throwable)e, destLoc, nodeStr);
        }
        catch (ClusterOperationException e) {
            Trace.out("coe occurred when trying to create CV_DESTLOC:" + e.getMessage());
            throw new CVUException((MessageKey)PrCnMsgID.DEST_LOC_NOT_CREATED, (Throwable)e, destLoc, nodeStr);
        }
        catch (InvalidNodeListException e) {
            Trace.out("ine occurred when trying to create CV_DESTLOC:" + e.getMessage());
            throw new CVUException((MessageKey)PrCnMsgID.DEST_LOC_NOT_CREATED, (Throwable)e, destLoc, nodeStr);
        }
    }

    @Override
    public void setDestLoc(String destLoc) throws CVUException {
        this.validateDestLoc(destLoc);
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.CVU.CV_DESTLOC.name(), destLoc));
        }
        catch (CRSException e) {
            throw new CVUException((MessageKey)PrCnMsgID.SET_CV_DESTLOC_FAILED, (Throwable)e, destLoc);
        }
    }

    @Override
    public String getDestLoc() throws CVUException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.CVU.CV_DESTLOC.name());
            String attrValue = attr.getValue().trim();
            Trace.out("got " + attrValue + " from resource");
            return attrValue;
        }
        catch (CRSException e) {
            throw new CVUException((MessageKey)PrCnMsgID.GET_CV_DESTLOC_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public String getCheckResults() throws CVUException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.CVU.CHECK_RESULTS.name());
            return attr.getValue().trim();
        }
        catch (CRSException e) {
            throw new CVUException((MessageKey)PrCnMsgID.GET_CVU_CHECK_RESULTS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setCheckResults(String errorString) throws CVUException {
        try {
            if (errorString == null) {
                errorString = "";
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.CVU.CHECK_RESULTS.name(), errorString));
        }
        catch (CRSException e) {
            throw new CVUException((MessageKey)PrCnMsgID.SET_CVU_CHECK_RESULTS_FAILED, (Throwable)e, errorString);
        }
    }

    @Override
    public CVU.SpaceAlertState getSpaceAlertState() throws CVUException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.CVU.CRSHOME_SPACE_ALERT_STATE.name());
            String attrValue = attr.getValue().trim();
            Trace.out("got " + attrValue + " from resource");
            return CVU.SpaceAlertState.valueOf(attrValue);
        }
        catch (CRSException e) {
            throw new CVUException((MessageKey)PrCnMsgID.GET_CRSHOME_SPACE_ALERT_STATE_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setSpaceAlertState(CVU.SpaceAlertState mode) throws CVUException {
        try {
            if (mode == null) {
                throw new CVUException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "mode");
            }
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.CVU.CRSHOME_SPACE_ALERT_STATE.name(), mode.toString()));
        }
        catch (CRSException e) {
            throw new CVUException((MessageKey)PrCnMsgID.SET_CRSHOME_SPACE_ALERT_STATE_FAILED, (Throwable)e, mode.toString());
        }
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode, tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate(srcNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.CVU.toString();
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, CVUException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new CVUException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void enable(Node node) throws CVUException, AlreadyEnabledException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            super.enable(nodeList);
        }
        catch (CompositeOperationException e) {
            throw new CVUException(e);
        }
        catch (SoftwareModuleException e) {
            throw new CVUException(e);
        }
    }

    @Override
    public void disable(Node node) throws CVUException, AlreadyDisabledException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            super.disable(nodeList);
        }
        catch (CompositeOperationException e) {
            throw new CVUException(e);
        }
        catch (SoftwareModuleException e) {
            throw new CVUException(e);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, CVUException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new CVUException(e);
        }
    }

    protected void finalize() {
        if (s_cvuInitialized) {
            Trace.out("terminating CVU impl");
        }
        s_cvuInitialized = false;
    }
}

