/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;

class sSkgxn {
    private static final String LIB_VC_PATH = "/etc/ORCLcluster/lib/";
    private static final String LIB_CM_PATH = "/etc/ORCLcluster/oracm/lib/";
    private static final String LIB_NAME = "libskgxn2.so";
    static final String LOCAL_NODE = "localhost";
    private String m_nodeName;

    sSkgxn() {
        this(sSkgxn.localHostName());
    }

    sSkgxn(String nodeName) {
        this.m_nodeName = nodeName;
    }

    boolean hasVendorClusterLib() throws ClusterException {
        String file = "/etc/ORCLcluster/lib/libskgxn2.so";
        ClusterCmd cmd = new ClusterCmd();
        return cmd.fileExists(this.nodeName(), file);
    }

    boolean hasOracleCMClusterLib() throws ClusterException {
        String file = "/etc/ORCLcluster/oracm/lib/libskgxn2.so";
        ClusterCmd cmd = new ClusterCmd();
        return cmd.fileExists(this.nodeName(), file);
    }

    String nodeName() {
        return this.m_nodeName;
    }

    private static String localHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Trace.out("Cannot get local host name ");
            return LOCAL_NODE;
        }
    }
}

