/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.whatif.WhatIfResultImpl;
import oracle.cluster.whatif.WhatIfResult;

public class WhatIf {
    Operation m_operation;
    String m_firstEntityName;
    String m_secondEntityName;
    List<ResourceAttribute> m_attributes = new ArrayList<ResourceAttribute>();
    List<ResourceAttribute> m_overAttributes = new ArrayList<ResourceAttribute>();
    boolean m_flag = false;
    WhatIfResult resultSet;

    public WhatIf() {
    }

    public WhatIf(String firstEntityName, Operation op, String secondEntityName, boolean force, List<ResourceAttribute> attributes, WhatIfResult result) {
        this(firstEntityName, op, secondEntityName, force, attributes, result, null);
    }

    public WhatIf(String firstEntityName, Operation op, String secondEntityName, boolean force, List<ResourceAttribute> attributes, WhatIfResult result, List<ResourceAttribute> overAttributes) {
        this.m_firstEntityName = firstEntityName;
        this.m_operation = op;
        this.m_secondEntityName = secondEntityName;
        this.m_flag = force;
        this.resultSet = result;
        this.m_attributes = attributes;
        if (null != overAttributes) {
            this.m_overAttributes = overAttributes;
        }
    }

    public void setOperation(Operation op) {
        this.m_operation = op;
    }

    public void setFirstEntityName(String entity) {
        this.m_firstEntityName = entity;
    }

    public void setSecondEntityName(String entity) {
        this.m_secondEntityName = entity;
    }

    private void addAttribute(String name, String value) {
        this.m_attributes.add(new ResourceAttribute(name, value));
    }

    private int attrCount() {
        return this.m_attributes.size();
    }

    private int getOverAttributeCount() {
        return this.m_overAttributes.size();
    }

    public void setFlag() {
        this.m_flag = true;
    }

    private int getOperation() {
        return this.m_operation.ordinal();
    }

    private String getFirstEntityName() {
        return this.m_firstEntityName;
    }

    private String getSecondEntityName() {
        return this.m_secondEntityName;
    }

    private boolean getFlag() {
        return this.m_flag;
    }

    private String getAttributeName(int index) {
        return this.m_attributes.get(index).getName();
    }

    private String getAttributeValue(int index) {
        return this.m_attributes.get(index).getValue();
    }

    private String getOverAttributeName(int index) {
        return this.m_overAttributes.get(index).getName();
    }

    private String getOverAttributeValue(int index) {
        return this.m_overAttributes.get(index).getValue();
    }

    private void setActionListCount(int count) {
        ((WhatIfResultImpl)this.resultSet).setCount(count);
    }

    private void setActionListSeqId(int id) {
        ((WhatIfResultImpl)this.resultSet).setSeqId(id);
    }

    private void addActiontoList() {
        ((WhatIfResultImpl)this.resultSet).addAction();
    }

    private void setActionTypetoActionList(int pos, int actiontype) {
        ((WhatIfResultImpl)this.resultSet).setActionTypetoAction(pos, actiontype);
    }

    private void addParametertoActionList(int pos, String name, String value) {
        ((WhatIfResultImpl)this.resultSet).addParametertoAction(pos, name, value);
    }

    public static enum Operation {
        RES_ADD,
        RES_MOD,
        RES_START,
        RES_STOP,
        RES_FAIL,
        RES_RELOCATE,
        SRVPOOL_ADD,
        SRVPOOL_MOD,
        SRVPOOL_REMOVE,
        SRVR_ADD,
        SRVR_RELOCATE,
        SRVR_REMOVE,
        SRVCAT_MOD,
        ACTPOLICY_SET;

    }
}

