/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.impl.crs.cops.RTENativeException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public class RTEArg {
    private String m_argName;
    private RTEArgType m_argType;
    private List<String> m_argValueList = null;

    public RTEArg(String argName, RTEArgType argType, String ... argValues) throws RTENativeException {
        if ((RTEArgType.Res == argType || RTEArgType.ResType == argType) && argValues.length > 1) {
            throw new RTENativeException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "RTEArg-RTEArg");
        }
        this.m_argName = argName;
        this.m_argType = argType;
        this.m_argValueList = new ArrayList<String>();
        for (String argValue : argValues) {
            this.m_argValueList.add(null == argValue ? "" : argValue);
        }
    }

    public String getName() {
        return this.m_argName;
    }

    public RTEArgType getType() {
        return this.m_argType;
    }

    public List<String> getValues() {
        return this.m_argValueList;
    }

    public static enum RTEArgType {
        Unknown(-1),
        Res(0),
        ResList(1),
        ResType(2),
        ResTypeList(3);

        private final int typeCode;

        private RTEArgType(int typeCode) {
            this.typeCode = typeCode;
        }

        static RTEArgType get(int typeCode) {
            switch (typeCode) {
                case 0: {
                    return Res;
                }
                case 1: {
                    return ResList;
                }
                case 2: {
                    return ResType;
                }
                case 3: {
                    return ResTypeList;
                }
            }
            return Unknown;
        }

        public int getCode() {
            return this.typeCode;
        }
    }
}

