/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.ArrayList;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;

public class PolicySetter {
    private String m_poolNames = "";
    private String m_policyToActivate = "";
    private List<InternalPolicy> m_policyList = new ArrayList<InternalPolicy>();
    private boolean m_keepPools;
    private boolean m_force;
    private boolean m_ignoreLastActivatedPol;

    public void setServerPoolNames(String poolNames) {
        this.m_poolNames = poolNames;
    }

    public String getServerPoolNames() {
        return this.m_poolNames;
    }

    public void setPolicyToActivate(String curPolicy) {
        this.m_policyToActivate = curPolicy;
    }

    public String getPolicyToActivate() {
        return this.m_policyToActivate;
    }

    public InternalPolicy createInternalPolicy(String name) {
        return new InternalPolicy(name);
    }

    public InternalPolicy[] getPolicyArray() {
        return this.m_policyList.toArray(new InternalPolicy[this.m_policyList.size()]);
    }

    public void addPolicy2PolicyList(InternalPolicy policy) {
        this.m_policyList.add(policy);
    }

    public void setPolicyList(List<InternalPolicy> policyList) {
        this.m_policyList = policyList;
    }

    public void setKeepPoolsFlag(boolean keepPools) {
        this.m_keepPools = keepPools;
    }

    public void setForceFlag(boolean force) {
        this.m_force = force;
    }

    public void setIgnoreLastActivatedPol(boolean ignoreLastActivatedPol) {
        this.m_ignoreLastActivatedPol = ignoreLastActivatedPol;
    }

    public boolean getKeepPoolsFlag() {
        return this.m_keepPools;
    }

    public boolean getForceFlag() {
        return this.m_force;
    }

    public boolean getIgnoreLastActivatedPol() {
        return this.m_ignoreLastActivatedPol;
    }

    public class InternalPolicy {
        private List<InternalSP> m_spList = new ArrayList<InternalSP>();
        private List<InternalRes> m_resList = new ArrayList<InternalRes>();
        private String m_name;
        private String m_description;

        public InternalPolicy(String name) {
            this.m_name = name;
        }

        public InternalRes createInternalRes(String name, int rank) {
            return new InternalRes(name, rank);
        }

        public InternalSP createInternalSP(String name) {
            return new InternalSP(name);
        }

        public InternalRes[] getResArray() {
            return this.m_resList.toArray(new InternalRes[this.m_resList.size()]);
        }

        public InternalSP[] getSPArray() {
            return this.m_spList.toArray(new InternalSP[this.m_spList.size()]);
        }

        public void addRes2ResList(InternalRes res) {
            this.m_resList.add(res);
        }

        public void addPool2SPList(InternalSP spool) {
            this.m_spList.add(spool);
        }

        public void setResList(List<InternalRes> resList) {
            this.m_resList = resList;
        }

        public void setSPList(List<InternalSP> spList) {
            this.m_spList = spList;
        }

        public void setPolicyName(String pName) {
            this.m_name = pName;
        }

        public String getPolicyName() {
            return this.m_name;
        }

        public void setDescription(String dsc) {
            this.m_description = dsc;
        }

        public String getDescription() {
            return this.m_description;
        }

        public class InternalRes {
            private String m_name;
            private int m_rank;

            InternalRes(String name, int rank) {
                this.m_name = name;
                this.m_rank = rank;
            }

            public String getResName() {
                return this.m_name;
            }

            public String getRank() {
                return Integer.toString(this.m_rank);
            }
        }

        public class InternalSP {
            private String m_name;
            private int m_maxsz;
            private int m_minsz;
            private int m_imp;

            InternalSP(String name) {
                this.m_name = name;
            }

            public void setSpoolName(String sName) {
                this.m_name = sName;
            }

            public String getSpoolName() {
                Trace.out("PS " + this.m_name);
                return this.m_name;
            }

            public void setSpoolMax(int max) {
                this.m_maxsz = max;
            }

            public String getSpoolMax() {
                return Integer.toString(this.m_maxsz);
            }

            public void setSpoolMin(int min) {
                this.m_minsz = min;
            }

            public String getSpoolMin() {
                return Integer.toString(this.m_minsz);
            }

            public void setSpoolImp(int imprtnc) {
                this.m_imp = imprtnc;
            }

            public String getSpoolImp() {
                return Integer.toString(this.m_imp);
            }
        }
    }
}

