/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.Map;
import java.util.Set;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.CRSNativeResult;
import oracle.cluster.resources.PrCrMsgID;
import oracle.ops.mgmt.has.CRSContext;
import oracle.ops.mgmt.has.CRSContextException;
import oracle.ops.mgmt.nls.MessageKey;

public class ExpressionFilter
implements Filter {
    private Filter.Operator m_op;
    private Filter m_filter1;
    private Filter m_filter2;
    private long m_clscrsRef;
    private CRSContext m_ctx;

    public ExpressionFilter(Filter.Operator o, Filter f1, Filter f2) throws CRSException {
        if (f1 == null || f2 == null) {
            throw new IllegalArgumentException("f1/f2 cannot be null");
        }
        this.m_op = o;
        this.m_filter1 = f1;
        this.m_filter2 = f2;
        try {
            this.m_ctx = new CRSContext();
        }
        catch (CRSContextException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_FILTER_CREATE_FAILED, (Throwable)e, new Object[0]);
        }
        try {
            this.m_clscrsRef = CRSNative.createExpFilter(new CRSNativeResult(), this.m_op.getV(), this.m_filter1.getRef(), this.m_filter2.getRef());
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_FILTER_CREATE_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public String toString() {
        return String.format("(%s %s %s)", this.m_filter1.toString(), this.m_op.toString(), this.m_filter2.toString());
    }

    @Override
    public long getRef() {
        return this.m_clscrsRef;
    }

    protected void finalize() throws Throwable {
        this.m_ctx = null;
        if (this.m_clscrsRef != 0L) {
            CRSNative.destroyFilter(new CRSNativeResult(), this.m_clscrsRef);
        }
        this.m_ctx = null;
    }

    @Override
    public Set<String> apply(Map<String, Map<String, String>> entities) {
        Set<String> f1Result = this.m_filter1.apply(entities);
        Set<String> f2Result = this.m_filter2.apply(entities);
        switch (this.m_op) {
            case AND: {
                f1Result.retainAll(f2Result);
                break;
            }
            case OR: {
                f1Result.addAll(f2Result);
            }
        }
        return f1Result;
    }
}

