/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cluster.crs.ActionAttribute;
import oracle.cluster.crs.ActionListener;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSLocalEntityException;
import oracle.cluster.crs.CRSNotRegisteredException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CardinalityException;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.crs.CompositeActionResult;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceException;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSCache;
import oracle.cluster.impl.crs.cops.CRSCompositeOperationException;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.CRSNativeResult;
import oracle.cluster.impl.crs.cops.CompositeActionResultImpl;
import oracle.cluster.impl.crs.cops.EntityOperationsCRS;
import oracle.cluster.impl.crs.cops.EntityOperationsLocal;
import oracle.cluster.impl.crs.cops.EntityOperationsSnap;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.policy.ConfigPolicy;
import oracle.cluster.policy.ConfigPolicySet;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.snapshot.SnapshotNotSupportedException;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public abstract class EntityOperations {
    static boolean debugEnabled = Trace.isLevelEnabled(5);
    EntityOpsMode m_mode;
    static final int entityNotFound = -559038737;

    public static EntityOperations getInstance(EntityOpsMode mode) {
        EntityOperations result = null;
        switch (mode) {
            case CRS: {
                result = new EntityOperationsCRS();
                break;
            }
            case Local: {
                result = new EntityOperationsLocal();
                break;
            }
            case Snapshot: {
                throw new IllegalArgumentException("Snapshot object to be passesd to constructor");
            }
            default: {
                throw new IllegalArgumentException("unsupported mode: " + (Object)((Object)mode));
            }
        }
        return result;
    }

    public static EntityOperations getInstance(SnapshotImpl snap) {
        return new EntityOperationsSnap(snap);
    }

    public String[] checkResource(CRSResource resource) throws CRSException {
        return this.checkResource(resource, null);
    }

    public String[] checkResource(CRSResource resource, String nodeName) throws CRSException {
        if (debugEnabled) {
            Trace.out("about to check resource %s, node %s", resource.getName(), nodeName != null ? nodeName : "");
        }
        return this.internalCheckResource(resource, nodeName);
    }

    public List<ResourceAttribute> getResourceStat(CRSResource resource, String nodeName, String ... attrNames) throws CRSException {
        String resName = resource.getName();
        Exception ex = null;
        List<ResourceAttribute> raList = null;
        if (attrNames == null) {
            attrNames = new String[]{};
        }
        try {
            raList = this.internalGetStat(CRSEntity.Type.Resource.getValue(), resName, nodeName, attrNames);
            return raList;
        }
        catch (CRSAttributeNotFoundException e) {
            throw e;
        }
        catch (CRSNotRegisteredException e) {
            throw e;
        }
        catch (CRSNativeException e) {
            ex = e;
        }
        catch (CRSException e) {
            ex = e;
        }
        Trace.out(ex);
        if (nodeName == null) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_GET_ATTRS_FAILED_NO_HOST, (Throwable)ex, resName);
        }
        throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_GET_ATTRS_FAILED, (Throwable)ex, resName, nodeName);
    }

    public List<ResourceAttribute> getProcessedStat(CRSResource resource, String nodeName, String ... attrNames) throws CRSException {
        String[] riOnHost;
        try {
            this.checkIfActionPermitted("getProcessedStat");
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_PROCESSED_ATTRS_FAILED, (Throwable)e, resource.getName(), nodeName);
        }
        String riId = null;
        String[] allRis = this.internalResInstancesAll(resource);
        if (allRis.length == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_PROCESSED_ATTRS_NO_RI, resource.getName(), nodeName);
        }
        riId = allRis.length == 1 ? allRis[0] : ((riOnHost = this.internalResInstancesLastServer(resource, nodeName)).length > 0 ? riOnHost[0] : allRis[0]);
        try {
            return this.internalGetStat(CRSEntity.Type.ResourceInstance.getValue(), riId, nodeName, attrNames);
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_PROCESSED_ATTRS_FAILED, (Throwable)e, resource.getName(), nodeName);
        }
    }

    public List<ResourceAttribute> getEntityStat(CRSEntity entity, String[] attrNames) throws CRSException {
        String name = entity.entityName();
        try {
            return this.internalGetStat(entity.getType().getValue(), name, null, attrNames);
        }
        catch (CRSNotRegisteredException e) {
            throw e;
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_ENT_STAT_FAILED, (Throwable)e, entity.typeAsString(), name);
        }
    }

    public boolean isEntityRegistered(CRSEntity entity) throws CRSException {
        return this.internalIsRegistered(entity);
    }

    boolean isEntityRegisteredCRSD(CRSEntity entity) throws CRSException {
        String name = entity.entityName();
        CRSNativeResult nr = new CRSNativeResult(name, null, null);
        try {
            boolean result = EntityOperations.doIsRegistered(nr, entity.getType().getValue());
            if (debugEnabled) {
                Trace.out("entity: %s, type: %d, registered: %b", name, entity.getType().getValue(), result);
            }
            return result;
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_IS_ENT_REGISTERED_FAILED, (Throwable)e, entity.typeAsString(), name);
        }
    }

    public void unregisterEntity(CRSEntity entity, boolean force) throws CRSException {
        String name = entity.entityName();
        Exception ex = null;
        CRSNativeResult nr = new CRSNativeResult(name, null, null);
        Trace.out(true, "About to unregister Entity: name: %s, force: %b, type: %d", name, force, entity.getType().getValue());
        try {
            this.checkIfActionPermitted("unregister");
            EntityOperations.doUnregister(nr, entity.getType().getValue(), force);
            CRSCache.clearEntity(entity.entityName());
            Trace.out(true, "Succesfully unregistered Entity: name: %s, force: %b, type: %d", name, force, entity.getType().getValue());
            return;
        }
        catch (CRSNativeException e) {
            ex = e;
        }
        catch (CRSException e) {
            ex = e;
        }
        throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_UNREGISTER_ENT_FAILED, (Throwable)ex, entity.typeAsString(), name);
    }

    public void purgePerX(CRSResource resource, String attrName) throws CRSException {
        try {
            this.purgePerX(resource, new String[]{attrName});
        }
        catch (NotExistsException notExistsException) {
            // empty catch block
        }
    }

    public void purgePerX(CRSResource resource, String[] attrList) throws NotExistsException, CRSException {
        String resName = resource.getName();
        try {
            this.checkIfActionPermitted("purgePerX");
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(attrList));
        }
        String[] perXNames = null;
        try {
            List<ResourceAttribute> allAttrs = this.internalGetStat(CRSEntity.Type.Resource.getValue(), resName, null, null);
            ArrayList<String> perXAttrs = new ArrayList<String>();
            String suffix = ResourceLiterals.AT.toString() + ResourceLiterals.SERVERNAME.toString() + '(';
            for (String attrName : attrList) {
                String perXName = attrName + suffix;
                for (ResourceAttribute a : allAttrs) {
                    if (!a.getName().startsWith(perXName)) continue;
                    perXAttrs.add(a.getName());
                }
            }
            int len = perXAttrs.size();
            if (len == 0) {
                throw new NotExistsException((MessageKey)PrCrMsgID.PURGE_PERX_NOT_EXISTS, resName, Arrays.toString(attrList));
            }
            perXNames = new String[len];
            perXAttrs.toArray(perXNames);
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(perXNames));
        }
        this.purgeHelper(resName, perXNames);
    }

    public void purgePerX(CRSResource resource, String nodeName, String ... attrNames) throws NotExistsException, CRSException {
        String resName = resource.getName();
        try {
            this.checkIfActionPermitted("purgePerX");
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(attrNames));
        }
        int len = attrNames.length;
        Object[] perXNames = new String[len];
        for (int i = 0; i < len; ++i) {
            perXNames[i] = ResourceType.getPerXName(attrNames[i], nodeName);
        }
        try {
            List<ResourceAttribute> perXAttrs = this.internalGetStat(CRSEntity.Type.Resource.getValue(), resName, null, (String[])perXNames);
            if (perXAttrs.size() == 0) {
                throw new NotExistsException((MessageKey)PrCrMsgID.PURGE_NODE_PERX_NOT_EXISTS, resName, Arrays.toString(attrNames), nodeName);
            }
        }
        catch (CRSAttributeNotFoundException e) {
            throw new NotExistsException((MessageKey)PrCrMsgID.PURGE_NODE_PERX_NOT_EXISTS, resName, Arrays.toString(attrNames), nodeName);
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(perXNames));
        }
        this.purgeHelper(resName, (String[])perXNames);
    }

    public void purgePerXbyValue(CRSResource resource, String attrValue, String ... attrNamesArr) throws CRSException {
        String resName = resource.getName();
        try {
            this.checkIfActionPermitted("purgePerX");
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(attrNamesArr));
        }
        String[] perXNames = null;
        String perXName = null;
        try {
            List<ResourceAttribute> allAttrs = this.internalGetStat(CRSEntity.Type.Resource.getValue(), resName, null, null);
            ArrayList<String> perXAttrs = new ArrayList<String>();
            String suffix = ResourceLiterals.AT.toString() + ResourceLiterals.SERVERNAME.toString() + '(';
            for (String attrName : attrNamesArr) {
                perXName = attrName + suffix;
                for (ResourceAttribute a : allAttrs) {
                    if (!a.getName().startsWith(perXName) || !a.getValue().equalsIgnoreCase(attrValue)) continue;
                    perXAttrs.add(a.getName());
                }
            }
            int len = perXAttrs.size();
            if (len > 0) {
                perXNames = new String[len];
                perXAttrs.toArray(perXNames);
            }
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(perXNames));
        }
        this.purgeHelper(resName, perXNames);
    }

    public void purgePerXCardinality(CRSResource resource, String cardinalityID, String ... attrNames) throws NotExistsException, CRSException {
        String resName = resource.getName();
        try {
            this.checkIfActionPermitted("purgePerX");
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(attrNames));
        }
        int len = attrNames.length;
        Object[] perXNames = new String[len];
        for (int i = 0; i < len; ++i) {
            perXNames[i] = ResourceType.getPerXCardinalityName(attrNames[i], cardinalityID);
        }
        try {
            List<ResourceAttribute> perXAttrs = this.internalGetStat(CRSEntity.Type.Resource.getValue(), resName, null, (String[])perXNames);
            if (perXAttrs.size() == 0) {
                throw new NotExistsException((MessageKey)PrCrMsgID.PURGE_CARDINALITY_PERX_NOT_EXISTS, resName, Arrays.toString(attrNames), cardinalityID);
            }
        }
        catch (CRSAttributeNotFoundException e) {
            throw new NotExistsException((MessageKey)PrCrMsgID.PURGE_CARDINALITY_PERX_NOT_EXISTS, resName, Arrays.toString(attrNames), cardinalityID);
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(perXNames));
        }
        this.purgeHelper(resName, (String[])perXNames);
    }

    public void purgeListPerXCardinality(CRSResource resource, List<String> cardinalityIDList, String ... attrNames) throws NotExistsException, CRSException {
        String resName = resource.getName();
        try {
            this.checkIfActionPermitted("purgePerX");
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(attrNames));
        }
        int len = attrNames.length;
        Object[] perXNames = new String[len * cardinalityIDList.size()];
        int count = 0;
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < cardinalityIDList.size(); ++j) {
                perXNames[count] = ResourceType.getPerXCardinalityName(attrNames[i], cardinalityIDList.get(j));
                ++count;
            }
        }
        try {
            List<ResourceAttribute> perXAttrs = this.internalGetStat(CRSEntity.Type.Resource.getValue(), resName, null, (String[])perXNames);
            if (perXAttrs.size() == 0) {
                throw new NotExistsException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, resName, Arrays.toString(perXNames));
            }
        }
        catch (CRSAttributeNotFoundException e) {
            throw new NotExistsException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(perXNames));
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(perXNames));
        }
        this.purgeHelper(resName, (String[])perXNames);
    }

    public void evaluateRegisterEntity(CRSEntity entity, ResourceAttribute[] attributes) throws CRSException {
        Exception ex = null;
        String name = entity.entityName();
        try {
            this.checkIfActionPermitted("evaluateRegisterEntity");
            EntityOperations.registerHelper(entity.getType().getValue(), new ResourceAttribute[0], false, false, true, name, attributes);
        }
        catch (CRSNativeException e) {
            ex = e;
        }
        catch (CRSException e) {
            ex = e;
        }
        if (ex != null) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_EVAL_REGISTER_FAILED, (Throwable)ex, entity.typeAsString(), name);
        }
    }

    public String[] startResource(CRSResource resource, boolean forceFlag, String nodeName, ResourceAttribute[] optionalAttr) throws CRSException {
        try {
            this.checkIfActionPermitted("start resource");
        }
        catch (CRSException e) {
            if (nodeName == null) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_START_FAILED_NO_HOST, (Throwable)e, resource.getName());
            }
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_START_FAILED, (Throwable)e, resource.getName(), nodeName);
        }
        try {
            return CRSNative.genericStartResource(resource, forceFlag, null, nodeName, optionalAttr, null);
        }
        catch (CRSCompositeOperationException e) {
            Trace.out("startResource: Got CRSCompositeOperationException:: " + e.getMessage());
            throw e.getCRSException();
        }
    }

    public String[] startResource(CRSResource resource, List<ServerPool> serverpools, boolean forceFlag, ResourceAttribute[] optionalAttr) throws AlreadyRunningException, CompositeOperationException, CRSException {
        try {
            this.checkIfActionPermitted("start resource");
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_START_FAILED_NO_HOST, (Throwable)e, resource.getName());
        }
        return CRSNative.startResourceInPools(resource, serverpools, forceFlag, optionalAttr);
    }

    public String[] stopResource(CRSResource resource, List<ServerPool> serverpools, boolean forceFlag, boolean keepDepTgt, ResourceAttribute[] optionalAttr) throws AlreadyStoppedException, CompositeOperationException, CRSException {
        return CRSNative.stopResourceInPools(resource, serverpools, forceFlag, keepDepTgt, optionalAttr);
    }

    public String[] startResource(CRSResource resource, int count, ResourceAttribute[] optionalAttr) throws CRSException, CardinalityException, AlreadyRunningException, CompositeOperationException {
        try {
            this.checkIfActionPermitted("start resource");
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_START_FAILED_NO_HOST, (Throwable)e, resource.getName());
        }
        String[] stoppedRI = this.internalResInstancesNotRunning(resource);
        if (stoppedRI.length < count) {
            String[] allRI = this.internalResInstancesAll(resource);
            String[] runRI = this.internalResInstancesRunning(resource);
            if (stoppedRI.length == 0) {
                throw new AlreadyRunningException((MessageKey)PrCrMsgID.CRS_JNI_START_COUNT_FAILED, resource.getName(), count, allRI.length, runRI.length);
            }
            if (runRI.length == 0) {
                throw new CardinalityException((MessageKey)PrCrMsgID.CRS_JNI_START_COUNT_FAILED_CARD, resource.getName(), count, allRI.length);
            }
            throw new CardinalityException((MessageKey)PrCrMsgID.CRS_JNI_START_COUNT_FAILED, resource.getName(), count, allRI.length, runRI.length);
        }
        String[] ri2run = new String[count];
        System.arraycopy(stoppedRI, 0, ri2run, 0, count);
        Trace.out(true, "About to start %d RIs of resource %s", count, resource);
        for (String id : ri2run) {
            Trace.out(true, "\t" + id);
        }
        Filter filter = FilterFactoryImpl.getFilter4RIbyNames(ri2run);
        return CRSNative.startResources(filter, true, null, optionalAttr);
    }

    public String[] startInstance(CRSResource resource, String instanceID, ResourceAttribute[] optionalAttr) throws CRSException, AlreadyRunningException, CompositeOperationException {
        return this.startInstance(resource, instanceID, null, optionalAttr);
    }

    public String[] startInstance(CRSResource resource, String instanceID, String nodeName, ResourceAttribute[] optionalAttr) throws CRSException, AlreadyRunningException, CompositeOperationException {
        try {
            this.checkIfActionPermitted("start resource");
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_START_FAILED_NO_HOST, (Throwable)e, resource.getName());
        }
        String[] ri2run = new String[]{instanceID};
        Trace.out(true, "About to start %s RI of resource %s", instanceID, resource);
        for (String id : ri2run) {
            Trace.out(true, "\t" + id);
        }
        Filter filter = FilterFactoryImpl.getFilter4RIbyNames(ri2run);
        return CRSNative.startResources(filter, true, nodeName, optionalAttr);
    }

    public void requestAction(CRSResource resource, String actionName, ActionAttribute[] attrs, Node[] nodes, boolean async, boolean queue, ActionListener lsnr) throws CompositeActionException {
        CompositeActionResultImpl car = new CompositeActionResultImpl(nodes);
        int len = attrs.length;
        String[] attrNames = new String[len];
        String[] attrValues = new String[len];
        String resName = "";
        for (int i = 0; i < len; ++i) {
            attrNames[i] = attrs[i].getName().trim();
            attrValues[i] = attrs[i].getValue().trim();
        }
        try {
            resName = resource.getName();
            Filter filter = FilterFactoryImpl.getFilterFromResourceAndNodes(resource, nodes);
            HashMap<String, String> c2n = new HashMap<String, String>();
            String cardinalityID = ResourceLiterals.CARDINALITY_ID.toString();
            String lastServer = ResourceLiterals.CRS_LAST_SERVER.toString();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.LocalResource.NAME.name(), resource.getName());
            Map<String, Map<String, String>> riData = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, false, nameFilter, cardinalityID, lastServer);
            for (String riId : riData.keySet()) {
                Map<String, String> tmp = riData.get(riId);
                String idName = tmp.get(cardinalityID);
                String serverName = tmp.get(lastServer);
                Trace.out("LAST_SERVER: %s, CARDINALITY_ID: %s", serverName, idName);
                if (idName == null || idName.equals("") || serverName == null || serverName.equals("")) continue;
                c2n.put(idName, serverName);
            }
            CRSNativeResult nr = new CRSNativeResult(null, attrNames, attrValues, filter, lsnr, car, c2n);
            CRSNative.doRequestAction(actionName, nr, async, queue);
            Trace.out("actionName is " + actionName);
            if (!actionName.equals(ResourceLiterals.STATUS_TARGET.toString()) && !car.isSuccess()) {
                if (nodes == null) {
                    throw new CompositeActionException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_FAILED, car, actionName, resName);
                }
                throw new CompositeActionException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_FAILED_ON_NODES, car, actionName, resName, this.getCommaSepNodenames(nodes));
            }
        }
        catch (CRSNativeException e) {
            Trace.out(e);
            if (nodes == null) {
                throw new CompositeActionException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_FAILED, (Throwable)e, (CompositeActionResult)car, e.getStatus(), new Object[]{actionName, resName});
            }
            throw new CompositeActionException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_FAILED_ON_NODES, (Throwable)e, (CompositeActionResult)car, e.getStatus(), new Object[]{actionName, resName, this.getCommaSepNodenames(nodes)});
        }
        catch (CRSException e) {
            Trace.out(e);
            if (nodes == null) {
                throw new CompositeActionException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_FAILED, (Throwable)e, (CompositeActionResult)car, actionName, resName);
            }
            throw new CompositeActionException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_FAILED_ON_NODES, (Throwable)e, (CompositeActionResult)car, actionName, resName, this.getCommaSepNodenames(nodes));
        }
    }

    public String[] stopResource(CRSResource resource, boolean force, ResourceAttribute[] optionalAttr) throws CRSException, AlreadyStoppedException {
        return this.stopResource(resource, force, true, optionalAttr);
    }

    public String[] stopResource(CRSResource resource, boolean force, boolean keepDepTgt, ResourceAttribute[] optionalAttr) throws CRSException, AlreadyStoppedException {
        try {
            return this.stopHelper(resource, null, force, keepDepTgt, null, optionalAttr);
        }
        catch (CRSCompositeOperationException e) {
            Trace.out("startResource: Got CRSCompositeOperationException:: " + e.getMessage());
            throw e.getCRSException();
        }
    }

    public String[] stopResource(CRSResource resource, String nodeName, boolean force, boolean keepDepTgt, ResourceAttribute[] optionalAttr) throws CRSException, AlreadyStoppedException {
        try {
            return this.stopHelper(resource, null, force, keepDepTgt, nodeName, optionalAttr);
        }
        catch (CRSCompositeOperationException e) {
            throw e.getCRSException();
        }
    }

    public String[] stopResource(CRSResource resource, int count, boolean force, ResourceAttribute[] optionalAttr) throws CRSException, AlreadyStoppedException, CardinalityException, CompositeOperationException {
        String[] riID = this.internalResInstancesRunning(resource);
        if (riID.length == 0) {
            throw new AlreadyStoppedException((MessageKey)PrCrMsgID.CRS_JNI_STOP_COUNT_FAILED, resource.getName(), count, riID.length);
        }
        if (riID.length < count) {
            throw new CardinalityException((MessageKey)PrCrMsgID.CRS_JNI_STOP_COUNT_FAILED, resource.getName(), count, riID.length);
        }
        String[] ri2run = new String[count];
        System.arraycopy(riID, 0, ri2run, 0, count);
        Trace.out(true, "About to stop %d RIs of resource %s", count, resource);
        for (String id : ri2run) {
            Trace.out(true, "\t" + id);
        }
        Filter filter = FilterFactoryImpl.getFilter4RIbyNames(ri2run);
        return this.stopHelper(resource, filter, force, true, null, optionalAttr);
    }

    public String[] stopInstance(CRSResource resource, String instanceID, boolean force, ResourceAttribute[] optionalAttr) throws CRSException, AlreadyStoppedException, CompositeOperationException {
        String[] ri2run = new String[]{instanceID};
        Trace.out(true, "About to stop %s RI of resource %s", instanceID, resource);
        for (String id : ri2run) {
            Trace.out(true, "\t" + id);
        }
        Filter filter = FilterFactoryImpl.getFilter4RIbyNames(ri2run);
        return this.stopHelper(resource, filter, force, true, null, optionalAttr);
    }

    public boolean isResourceRunning(CRSResource resource) throws CRSException {
        return this.isResourceRunning(resource, null);
    }

    public boolean isResourceRunning(CRSResource resource, String nodeName) throws CRSException {
        return this.internalResInstancesRunning(resource, nodeName).length != 0;
    }

    public String[] relocate(CRSResource res, String fromNode, String toNode, ResourceAttribute[] env) throws NotRunningException, CRSException {
        try {
            return this.relocateHelper(res, null, fromNode, toNode, true, env);
        }
        catch (CRSCompositeOperationException e) {
            throw new CRSException(e);
        }
    }

    public String[] relocate(CRSResource res, String fromNode, String toNode, boolean force, ResourceAttribute[] env) throws NotRunningException, CRSException {
        try {
            return this.relocateHelper(res, null, fromNode, toNode, force, env);
        }
        catch (CRSCompositeOperationException e) {
            throw new CRSException(e);
        }
    }

    public void relocate(CRSResource res, String fromNode, String toNode, boolean force, ResourceAttribute[] env, Map<String, String> nodeResMap) throws NotRunningException, CRSException {
        try {
            String[] callbackMsgs = this.relocateHelper(res, null, fromNode, toNode, force, env);
            CRSNative.updateNodeResMap(callbackMsgs, nodeResMap, "CRS-2677");
        }
        catch (CRSCompositeOperationException e) {
            throw new CRSException(e);
        }
    }

    public String[] relocate(Filter filter, String toNode, boolean force, ResourceAttribute[] env) throws NotRunningException, CRSException, CRSCompositeOperationException {
        return this.relocateHelper(null, filter, null, toNode, force, env);
    }

    public void relocate(Filter filter, String toNode, boolean force, ResourceAttribute[] env, Map<String, String> nodeResMap) throws NotRunningException, CRSException, CRSCompositeOperationException {
        String[] callbackMsgs = this.relocateHelper(null, filter, null, toNode, force, env);
        CRSNative.updateNodeResMap(callbackMsgs, nodeResMap, "CRS-2677");
    }

    private String[] relocateHelper(CRSResource res, Filter filter, String fromNode, String toNode, boolean force, ResourceAttribute[] env) throws NotRunningException, CRSException, CRSCompositeOperationException {
        Object ex = null;
        try {
            this.checkIfActionPermitted("relocate");
        }
        catch (CRSException e) {
            if (res != null) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_RELOCATE_FAILED, (Throwable)e, res.getName());
            }
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCES_RELOCATE_FAILED, (Throwable)e, new Object[0]);
        }
        ResourceAttribute[] myEnv = env;
        if (myEnv == null) {
            myEnv = new ResourceAttribute[]{};
        }
        int len = myEnv.length;
        String[] envKeys = new String[len];
        String[] envValues = new String[len];
        for (int i = 0; i < len; ++i) {
            envKeys[i] = myEnv[i].getName().trim();
            envValues[i] = myEnv[i].getValue().trim();
            if (!debugEnabled) continue;
            Trace.out("\tName[%d]: '%s', Value: '%s'", i, envKeys[i], envValues[i]);
        }
        CRSNativeResult nr = null;
        if (res != null) {
            String useId = this.relocateInstanceId(res, fromNode, toNode);
            nr = new CRSNativeResult(useId, envKeys, envValues);
            Trace.out(true, "About to relocate RI '%s', fromHost '%s', toHost '%s'", useId, fromNode, toNode);
        } else if (filter != null) {
            nr = new CRSNativeResult(null, envKeys, envValues, filter);
            Trace.out(true, "About to relocate RI specified by filter '%s'", filter.toString());
        }
        try {
            EntityOperations.doRelocate(nr, toNode, force);
            return nr.getCmdOutput();
        }
        catch (CRSNativeException e) {
            if (res != null) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_RELOCATE_FAILED, (Throwable)e, res.getName());
            }
            Trace.out("Failed to stop resources: filter %s, msg %s", filter.toString(), e.getMessage());
            throw new CRSCompositeOperationException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCES_RELOCATE_FAILED, (Throwable)e, nr, new Object[0]);
        }
    }

    public String relocateInstanceId(CRSResource res, String fromNode, String toNode) throws NotRunningException, CRSException {
        String useId = null;
        String[] runners = this.resourceInstanceIds(res, fromNode);
        if (fromNode != null) {
            if (runners.length == 0) {
                throw new NotRunningException((MessageKey)PrCrMsgID.CRS_RELOCATE_NOT_RUNNING_ON_NODE, res.getName(), fromNode);
            }
            if (toNode != null && fromNode.equalsIgnoreCase(toNode)) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_RELOCATE_SAME_NODE, res.getName(), fromNode);
            }
        } else {
            if (runners.length == 0) {
                throw new NotRunningException((MessageKey)PrCrMsgID.CRS_RELOCATE_NOT_RUNNING, res.getName());
            }
            if (runners.length > 1) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_RELOCATE_NOT_SINGLETON, res.getName());
            }
        }
        useId = runners[0];
        Trace.out(true, "relocate RI '%s', fromHost '%s', toHost '%s'", useId, fromNode, toNode);
        return useId;
    }

    public String[] resourceInstanceIds(CRSResource res, String nodeName) throws NotRunningException, CRSException {
        String[] runners = this.internalResInstancesRunning(res, nodeName);
        if (debugEnabled) {
            Trace.out("rsource RIs '%s', onHost '%s'", runners, nodeName);
        }
        return runners;
    }

    public final List<Node> fetchRunningNodes(CRSResourceImpl resource) throws CRSException {
        LinkedList<Node> result = new LinkedList<Node>();
        List<String> nodeNames = null;
        ServerFactoryImpl serverFactoryImpl = null;
        Exception err = null;
        try {
            nodeNames = this.fetchRunningNodeNames(resource);
            serverFactoryImpl = ServerFactoryImpl.getInstance();
            for (String name : nodeNames) {
                result.add(serverFactoryImpl.getNode(name, false));
            }
        }
        catch (CRSException e) {
            err = e;
        }
        catch (ServerException e) {
            err = e;
        }
        catch (NodeException e) {
            err = e;
        }
        if (err != null) {
            throw new CRSException((MessageKey)PrCrMsgID.RES_STAT_FAILED, (Throwable)err, resource.getName());
        }
        return result;
    }

    public final List<String> fetchRunningNodeNames(CRSResource resource) throws CRSException {
        if (debugEnabled) {
            Trace.out("Looking for nodes: resource " + resource.getName());
        }
        LinkedList<String> result = new LinkedList<String>();
        Map<String, Map<String, String>> ris = null;
        try {
            ris = this.searchEntities(CRSEntity.Type.ResourceInstance, false, FilterFactoryImpl.getFilter4ResourceInstances(resource), CRSNative.CRS_LAST_SERVER_ATTR_NAME, CRSNative.CRS_STATE_ATTR_NAME, CRSNative.CRS_ISTATE_ATTR_NAME);
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_STATUS_FAILED, (Throwable)e, resource.getName());
        }
        if (ris.keySet().size() < 1) {
            return result;
        }
        for (String riId : ris.keySet()) {
            Map<String, String> ri = ris.get(riId);
            String state = ri.get(CRSNative.CRS_STATE_ATTR_NAME);
            String iState = ri.get(CRSNative.CRS_ISTATE_ATTR_NAME);
            String nodeName = ri.get(CRSNative.CRS_LAST_SERVER_ATTR_NAME);
            if (iState == null) {
                iState = "STABLE";
            }
            if (!state.equalsIgnoreCase("ONLINE") && !state.equalsIgnoreCase("INTERMEDIATE") || !iState.equalsIgnoreCase("STABLE")) continue;
            result.add(nodeName);
            if (!debugEnabled) continue;
            Trace.out("\triid : %s node: %s, state %s, istate %s", riId, nodeName, state, iState);
        }
        return result;
    }

    public final HashMap<String, String> fetchLastServers(CRSResource resource) throws CRSException {
        if (debugEnabled) {
            Trace.out("Looking for nodes: resource " + resource.getName());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, Map<String, String>> ris = null;
        try {
            ris = this.searchEntities(CRSEntity.Type.ResourceInstance, false, FilterFactoryImpl.getFilter4ResourceInstances(resource), CRSNative.CRS_LAST_SERVER_ATTR_NAME);
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_STATUS_FAILED, (Throwable)e, resource.getName());
        }
        if (ris.keySet().size() < 1) {
            return result;
        }
        for (String riId : ris.keySet()) {
            Map<String, String> ri = ris.get(riId);
            String nodeName = ri.get(CRSNative.CRS_LAST_SERVER_ATTR_NAME);
            result.put(riId, nodeName);
            if (!debugEnabled) continue;
            Trace.out("\triid : %s last_server : %s", riId, nodeName);
        }
        return result;
    }

    public final HashMap<String, String> fetchRunningInstances(CRSResource resource) throws CRSException {
        if (debugEnabled) {
            Trace.out("Looking for nodes: resource " + resource.getName());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, Map<String, String>> ris = null;
        try {
            ris = this.searchEntities(CRSEntity.Type.ResourceInstance, false, FilterFactoryImpl.getFilter4ResourceInstances(resource), CRSNative.CRS_LAST_SERVER_ATTR_NAME, CRSNative.CRS_STATE_ATTR_NAME, CRSNative.CRS_ISTATE_ATTR_NAME);
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_STATUS_FAILED, (Throwable)e, resource.getName());
        }
        if (ris.keySet().size() < 1) {
            return result;
        }
        for (String riId : ris.keySet()) {
            Map<String, String> ri = ris.get(riId);
            String state = ri.get(CRSNative.CRS_STATE_ATTR_NAME);
            String iState = ri.get(CRSNative.CRS_ISTATE_ATTR_NAME);
            String nodeName = ri.get(CRSNative.CRS_LAST_SERVER_ATTR_NAME);
            if (iState == null) {
                iState = "STABLE";
            }
            if (!state.equalsIgnoreCase("ONLINE") && !state.equalsIgnoreCase("INTERMEDIATE") || !iState.equalsIgnoreCase("STABLE")) continue;
            result.put(riId, nodeName);
            if (!debugEnabled) continue;
            Trace.out("\triid : %s last_server : %s", riId, nodeName);
        }
        return result;
    }

    abstract String[] internalCheckResource(CRSResource var1, String var2) throws CRSException;

    abstract List<ResourceAttribute> internalGetStat(int var1, String var2, String var3, String[] var4) throws CRSAttributeNotFoundException, CRSNativeException, CRSException;

    abstract String[] internalResInstancesAll(CRSResource var1) throws CRSException;

    abstract String[] internalResInstancesRunning(CRSResource var1) throws CRSException;

    abstract String[] internalResInstancesRunning(CRSResource var1, String var2) throws CRSException;

    abstract String[] internalResInstancesNotRunning(CRSResource var1) throws CRSException;

    abstract String[] internalResInstancesLastServer(CRSResource var1, String var2) throws CRSException;

    abstract String[] internalResInstances2Stop(CRSResource var1, String var2) throws CRSException;

    abstract boolean internalIsRegistered(CRSEntity var1) throws CRSException;

    public abstract void registerEntity(CRSEntity var1, boolean var2, boolean var3, ResourceAttribute[] var4, Filter var5) throws CRSException;

    public void registerEntity(CRSEntity entity, boolean update, boolean force, ResourceAttribute[] attributes) throws CRSException {
        this.registerEntity(entity, update, force, attributes, null);
    }

    public abstract void registerEntity(CRSEntity var1, ResourceAttribute[] var2, boolean var3, boolean var4, ResourceAttribute[] var5, Filter var6) throws CRSException;

    public void registerEntity(CRSEntity entity, ResourceAttribute[] overrideAttrs, boolean update, boolean force, ResourceAttribute[] attributes) throws CRSException {
        this.registerEntity(entity, overrideAttrs, update, force, attributes, null);
    }

    public abstract void setEnableDisable(CRSResourceImpl var1, boolean var2) throws AlreadyEnabledException, AlreadyDisabledException, CRSException;

    public abstract String[] queryResources(CRSEntity.Type var1, Filter var2) throws CRSException;

    public abstract Map<String, Map<String, String>> searchEntities(CRSEntity.Type var1, boolean var2, Filter var3, String ... var4) throws CRSException;

    public abstract Database getDatabase(CRSEntity var1, String var2) throws NotExistsException, DatabaseException;

    public abstract Service getService(CRSEntity var1, String var2, String var3) throws NotExistsException, ServiceException;

    public abstract ServerPool getServerPool(CRSEntity var1, String var2) throws CRSException;

    public abstract ConfigPolicy getConfigPolicy(CRSEntity var1, String var2) throws CRSException;

    public abstract ConfigPolicySet getConfigPolicySet(CRSEntity var1) throws CRSException;

    public abstract Server getServer(CRSEntity var1, String var2) throws NotExistsException, ServerException;

    static List<ResourceAttribute> stat2Helper(int type, String name, String nodeName, String[] attrNames) throws CRSAttributeNotFoundException, CRSNativeException {
        int len;
        LinkedList<ResourceAttribute> raList = new LinkedList<ResourceAttribute>();
        CRSNativeResult nr = new CRSNativeResult(name, attrNames, null);
        String[] nvList = EntityOperations.doGetStat2(nr, type, nodeName);
        int n = len = nvList != null ? nvList.length / 2 : 0;
        if (len == 0) {
            throw CRSAttributeNotFoundException.getInstance(attrNames);
        }
        for (int i = 0; i < len; ++i) {
            String aName = nvList[i * 2];
            String aValue = nvList[i * 2 + 1].trim();
            ResourceAttribute ra = new ResourceAttribute(aName, aValue);
            raList.add(ra);
        }
        return raList;
    }

    private void purgeHelper(String resName, String[] perXNames) throws CRSException {
        if (perXNames == null || perXNames.length == 0) {
            return;
        }
        int len = perXNames.length;
        Trace.out(true, String.format("About to purge-perx: resource %s", resName));
        for (int i = 0; i < len; ++i) {
            Trace.out(true, String.format("\t %s", perXNames[i]));
        }
        CRSNativeResult nr = new CRSNativeResult(resName, perXNames, null);
        try {
            EntityOperations.doPurgeAttr(nr);
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.PURGE_PERX_FAILED, (Throwable)e, resName, Arrays.toString(perXNames));
        }
    }

    static void registerHelper(int type, ResourceAttribute[] overrideAttrs, boolean update, boolean force, boolean evalOnly, String name, ResourceAttribute[] attributes) throws CRSNativeException {
        EntityOperations.registerHelper(type, overrideAttrs, update, force, evalOnly, name, attributes, null);
    }

    static void registerHelper(int type, ResourceAttribute[] overrideAttrs, boolean update, boolean force, boolean evalOnly, String name, ResourceAttribute[] attributes, Filter filter) throws CRSNativeException {
        int len = attributes.length;
        Trace.out(true, "About to register: name: %s, type: %d, update: %b, force: %b", name, type, update, force);
        String[] attrNames = new String[len];
        String[] attrValues = new String[len];
        for (int i = 0; i < len; ++i) {
            if (attributes[i].getName().trim().equals("ACTIVE_SERVERS")) {
                attrNames[i] = "";
                attrValues[i] = "";
            } else {
                attrNames[i] = attributes[i].getName().trim();
                attrValues[i] = attributes[i].getValue().trim();
            }
            if (!debugEnabled) continue;
            Trace.out("\tName: '%s', Value: '%s'", attrNames[i], attrValues[i]);
        }
        CRSCache.clearEntry(name, attributes);
        CRSNativeResult nr = null;
        if (overrideAttrs != null) {
            int olen = overrideAttrs.length;
            String[] overrideNames = new String[olen];
            String[] overrideValues = new String[olen];
            for (int i = 0; i < olen; ++i) {
                overrideNames[i] = attributes[i].getName().trim();
                overrideValues[i] = attributes[i].getValue().trim();
                if (!debugEnabled) continue;
                Trace.out("\tName: '%s', Value: '%s'", overrideNames[i], overrideValues[i]);
            }
            if (olen > 0) {
                nr = new CRSNativeResult(name, attrNames, attrValues, overrideNames, overrideValues, filter);
            }
        }
        if (nr == null) {
            nr = new CRSNativeResult(name, attrNames, attrValues, filter);
        }
        EntityOperations.doRegister(nr, type, update, force, evalOnly);
    }

    String[] stopHelper(CRSResource resource, Filter filter, boolean force, boolean keepDepTgt, String nodeName, ResourceAttribute[] optionalAttr) throws CRSException, CRSCompositeOperationException, AlreadyStoppedException {
        String resName = resource.getName();
        try {
            this.checkIfActionPermitted("start resource");
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_STOP_FAILED, (Throwable)e, resName);
        }
        if (nodeName == null) {
            if (this.internalResInstances2Stop(resource, nodeName).length == 0) {
                throw new AlreadyStoppedException((MessageKey)PrCrMsgID.RES_ALREADY_STOPPED, resName);
            }
        } else {
            Map<String, Map<String, String>> ris = null;
            try {
                ris = this.searchEntities(CRSEntity.Type.ResourceInstance, false, FilterFactoryImpl.getFilter2StopResource(resource, nodeName), CRSNative.CRS_STATE_ATTR_NAME, CRSNative.CRS_TARGET_ATTR_NAME);
            }
            catch (CRSException e) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_STATUS_FAILED, (Throwable)e, resource.getName());
            }
            if (ris.keySet().size() < 1) {
                Trace.out("No resource instance running");
                throw new CRSException((MessageKey)PrCrMsgID.CRS_NO_RES_RUNNING_ON_NODE, nodeName);
            }
            boolean toStop = false;
            for (String riId : ris.keySet()) {
                Map<String, String> ri = ris.get(riId);
                String state = ri.get(CRSNative.CRS_STATE_ATTR_NAME);
                String target = ri.get(CRSNative.CRS_TARGET_ATTR_NAME);
                if (state.equalsIgnoreCase("OFFLINE") && target.equalsIgnoreCase("OFFLINE")) continue;
                toStop = true;
                break;
            }
            if (!toStop) {
                Trace.out("Already stopped");
                throw new AlreadyStoppedException((MessageKey)PrCrMsgID.RES_ALREADY_STOPPED, resName);
            }
        }
        int len = optionalAttr == null ? 0 : optionalAttr.length;
        String[] optNames = new String[len];
        String[] optValues = new String[len];
        Trace.out(true, "About to stop resource: name %s, force %b, keepDepTgt %b, options %d", resName, force, keepDepTgt, len);
        for (int i = 0; i < len; ++i) {
            optNames[i] = optionalAttr[i].getName().trim();
            optValues[i] = optionalAttr[i].getValue().trim();
            if (!debugEnabled) continue;
            Trace.out("\tName[%d]: '%s', Value: '%s'", i, optNames[i], optValues[i]);
        }
        CRSNativeResult nr = null;
        try {
            Filter theFilter = filter != null ? filter : FilterFactoryImpl.getFilter2StopResource(resource, nodeName);
            nr = new CRSNativeResult(null, optNames, optValues, theFilter);
            CRSNative.doStopResource(nr, force, keepDepTgt);
            return nr.getCmdOutput();
        }
        catch (CRSNativeException e) {
            Trace.out(true, "failed to stop resource %s, msg %s", resName, e.getMessage());
            throw new CRSCompositeOperationException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_STOP_FAILED, (Throwable)e, nr, resName);
        }
    }

    void checkIfActionPermitted(String methodName) throws CRSException {
        switch (this.m_mode) {
            case CRS: {
                return;
            }
            case Local: {
                throw new CRSLocalEntityException((MessageKey)PrCrMsgID.LOCALOBJ_ACTION_REQ, methodName);
            }
            case Snapshot: {
                throw new SnapshotNotSupportedException((MessageKey)PrCrMsgID.SNAPSHOT_ACTION_REQ, methodName);
            }
        }
        throw new IllegalArgumentException("unsupported m_mode: " + (Object)((Object)this.m_mode));
    }

    private String getCommaSepNodenames(Node[] nodes) {
        StringBuilder nNames = new StringBuilder();
        for (Node n : nodes) {
            if (nNames.length() > 0) {
                nNames.append(", ");
            }
            nNames.append(n.toString());
        }
        return nNames.toString();
    }

    static native void doCheckResource(CRSNativeResult var0, int var1, String var2) throws CRSNativeException;

    static native String[] doGetStat2(CRSNativeResult var0, int var1, String var2) throws CRSNativeException;

    private static native void doPurgeAttr(CRSNativeResult var0) throws CRSNativeException;

    private static native void doRegister(CRSNativeResult var0, int var1, boolean var2, boolean var3, boolean var4) throws CRSNativeException;

    private static native boolean doIsRegistered(CRSNativeResult var0, int var1) throws CRSNativeException;

    private static native void doUnregister(CRSNativeResult var0, int var1, boolean var2) throws CRSNativeException;

    private static native void doRelocate(CRSNativeResult var0, String var1, boolean var2) throws CRSNativeException;

    public static enum EntityOpsMode {
        CRS,
        Local,
        Snapshot;

    }
}

