/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.crs.ActionListener;
import oracle.cluster.crs.ActionMessage;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.cops.ActionMessageImpl;
import oracle.cluster.impl.crs.cops.CRSNativeActiveVersionException;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.CRSNativeNotRegisteredException;
import oracle.cluster.impl.crs.cops.CompositeActionResultImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class CRSNativeResult
extends NativeResult {
    private static final String SUCCESS_SIGNATURE = "SUCCESS";
    private String in_entName = null;
    private String[] in_attName = null;
    private String[] in_attrValue = null;
    private String[] override_name = null;
    private String[] override_value = null;
    private long in_filter;
    private boolean m_getServerByCategory = false;
    private boolean isPartial = false;
    private boolean m_isOutputOff = false;
    private static String infostr = "INFO";
    private ProgressListener m_plsnr = null;
    private boolean m_singleNode = false;
    private boolean m_firstmsg = true;
    private Map<String, String> m_resultMap = new LinkedHashMap<String, String>();
    private List<String> out_cmdOutput = new LinkedList<String>();
    private Map<String, Map<String, String>> out_EntDescr = new LinkedHashMap<String, Map<String, String>>();
    private Map<Object, CRSNativeException> out_CompDescr = new LinkedHashMap<Object, CRSNativeException>();
    private Map<String, List<String>> out_CompOutput = new LinkedHashMap<String, List<String>>();
    private ActionListener m_alsnr = null;
    private CompositeActionResultImpl m_compActnRslt = null;
    private Map<String, String> m_crdID2NodeName = null;
    private static boolean debugEnabled = Trace.isCRSNativeDebug();

    CRSNativeResult(String entName, String[] attrName, String[] attrValue, Filter filter, ActionListener alsnr, CompositeActionResultImpl car, Map<String, String> c2n) {
        this(entName, attrName, attrValue, filter);
        this.m_alsnr = alsnr;
        this.m_compActnRslt = car;
        this.m_crdID2NodeName = c2n;
    }

    CRSNativeResult(String entName, String[] attrName, String[] attrValue, Filter filter) {
        this.in_entName = entName;
        this.in_attName = attrName;
        this.in_attrValue = attrValue;
        this.in_filter = filter != null ? filter.getRef() : 0L;
    }

    CRSNativeResult(String entName, String[] attrName, String[] attrValue) {
        this(entName, attrName, attrValue, null);
    }

    CRSNativeResult(String entName, String[] attrName, String[] attrValue, String[] overrideName, String[] overrideValue, Filter filter) {
        this.in_entName = entName;
        this.in_attName = attrName;
        this.in_attrValue = attrValue;
        this.override_name = overrideName;
        this.override_value = overrideValue;
        this.in_filter = filter != null ? filter.getRef() : 0L;
    }

    CRSNativeResult(String entName, String[] attrName, String[] attrValue, String[] overrideName, String[] overrideValue) {
        this(entName, attrName, attrValue, overrideName, overrideValue, null);
    }

    CRSNativeResult(String[] attrName, Filter filter, boolean serverByCategory) {
        this(null, attrName, null, filter);
        this.m_getServerByCategory = serverByCategory;
    }

    public CRSNativeResult() {
    }

    public CRSNativeResult(ProgressListener plsnr) {
        this.m_plsnr = plsnr;
    }

    public CRSNativeResult(ProgressListener plsnr, boolean singleNode) {
        this.m_plsnr = plsnr;
        this.m_singleNode = singleNode;
    }

    String[] getCmdOutput() {
        String[] out = new String[]{};
        out = this.out_cmdOutput.toArray(out);
        return out;
    }

    public void setOutputOff() {
        this.m_isOutputOff = true;
    }

    public Map<Object, CRSNativeException> getCompDescr() {
        return this.out_CompDescr;
    }

    public Map<String, List<String>> getCompOutput() {
        return this.out_CompOutput;
    }

    private void addAdminActionMsg(String msg) {
        String[] msgArray;
        if (debugEnabled) {
            Trace.out((Object)"callback: %s", msg);
        }
        if (msg.trim().length() > 0 && (msgArray = msg.split("::")).length > 1) {
            String nodeName = msgArray[1];
            String line = "";
            if (this.m_resultMap.get(nodeName) != null) {
                line = this.m_resultMap.get(nodeName);
            }
            if (msgArray[0].equals(SUCCESS_SIGNATURE)) {
                List<String> output = this.out_CompOutput.get(nodeName);
                if (output == null) {
                    ArrayList<String> outlist = new ArrayList<String>();
                    outlist.add(line);
                    this.out_CompOutput.put(nodeName, outlist);
                }
            } else {
                line = msgArray[0] + "::" + (msgArray.length > 2 ? msgArray[2] : "");
                CRSNativeException exc = this.out_CompDescr.get(nodeName);
                if (exc == null) {
                    this.out_CompDescr.put(nodeName, new CRSNativeException(line));
                } else {
                    exc.addDetailedMessage(line);
                }
            }
        }
    }

    private void noResourceInstanceAvailable() throws CRSException {
        Trace.out("noResourceInstanceAvailable");
        throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_NO_RES_AVAIL, new Object[0]);
    }

    private void createActionResult(String id, String nodeName, String degree, int status) throws CRSException {
        Trace.out("createActionResult: %s %s %s %d", id, nodeName, degree, status);
        if (null == nodeName) {
            Trace.out("nodeName is null");
            return;
        }
        boolean isNodeName = false;
        try {
            new Integer(nodeName);
        }
        catch (NumberFormatException e) {
            isNodeName = true;
        }
        if (!isNodeName) {
            nodeName = this.m_crdID2NodeName.get(nodeName);
        }
        if (null == nodeName) {
            Trace.out((Object)"Cannot find cardinality ID %s from the map", nodeName);
            return;
        }
        try {
            ServerFactory sf = ServerFactory.getInstance();
            Node node = sf.getNode(nodeName, false);
            this.m_compActnRslt.createActionResultImpl(node);
        }
        catch (ServerException e) {
            throw new CRSException(e);
        }
        catch (NodeException e) {
            throw new CRSException(e);
        }
    }

    private void addActionMsg(int type, String id, String msg, String nodeName) throws CRSException {
        ActionMessage.Type msgType;
        String err;
        String regex;
        Trace.out("callback: %s %d %s %s", id, type, msg, nodeName);
        if (msg == null) {
            Trace.out("Discard null msg");
            return;
        }
        if (msg.trim().length() <= 0) {
            Trace.out("Throw CRSException since msg length is %d", msg.trim().length());
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_CALLBACK_ERROR, new Object[0]);
        }
        boolean isNodeName = false;
        try {
            new Integer(nodeName);
        }
        catch (NumberFormatException e) {
            isNodeName = true;
        }
        if (!isNodeName) {
            nodeName = this.m_crdID2NodeName.get(nodeName);
        }
        if (null == nodeName) {
            Trace.out((Object)"Cannot find cardinality ID %s from the map", nodeName);
            return;
        }
        if (msg.startsWith(nodeName + ':')) {
            String[] msgArray = msg.split(String.valueOf(':'), 2);
            if (msgArray.length < 2) {
                Trace.out("Throw CRSException since msgArray length is %d", msgArray.length);
                throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_CALLBACK_ERROR, new Object[0]);
            }
            msg = msgArray[1];
        }
        if (msg.matches(regex = "#@result\\[\\d\\]: (.*=\\{.*\\}(\\s)*)+") && (err = this.extractError(msg)) != null) {
            msg = err;
        }
        switch (type) {
            case 1: {
                msgType = ActionMessage.Type.ACTION_MESSAGE_ERROR;
                break;
            }
            case 2: {
                msgType = ActionMessage.Type.ACTION_MESSAGE_WARNING;
                break;
            }
            case 3: {
                msgType = ActionMessage.Type.ACTION_MESSAGE_INFO;
                break;
            }
            default: {
                Trace.out("WARNING: Unknown msg type: %d", type);
                throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_CALLBACK_ERROR, new Object[0]);
            }
        }
        try {
            ServerFactory sf = ServerFactory.getInstance();
            Node node = sf.getNode(nodeName, false);
            ActionMessageImpl amsg = new ActionMessageImpl(msgType, msg);
            this.m_compActnRslt.addMessage(node, amsg);
            if (this.m_alsnr != null) {
                Trace.out((Object)"notifying action message of %s", nodeName);
                this.m_alsnr.notifyActionMessage(node, amsg);
                if (msgType == ActionMessage.Type.ACTION_MESSAGE_ERROR) {
                    Trace.out((Object)"notifying action result of %s", nodeName);
                    this.m_alsnr.notifyActionResult(this.m_compActnRslt.getActionResult(node));
                }
            }
        }
        catch (ServerException e) {
            throw new CRSException(e);
        }
        catch (NodeException e) {
            throw new CRSException(e);
        }
    }

    private void setPartialResult(boolean isPartial) {
        this.isPartial = isPartial;
    }

    private void writeMsg(String msg) {
        Trace.out((Object)"Info msg: %s", msg);
        if (msg.trim().length() > 0) {
            String[] msgArray = msg.split("::");
            if (msgArray.length >= 3 && msgArray[0].equals(infostr)) {
                String nodeName = msgArray[1];
                if (msgArray[2].trim().length() > 0) {
                    String tmpStr;
                    String line = msgArray[2].trim();
                    if (line.endsWith("\\n")) {
                        line = line.substring(0, line.length() - "\\n".length());
                    }
                    if ((tmpStr = this.m_resultMap.get(nodeName)) != null) {
                        line = tmpStr.concat(line);
                    }
                    this.m_resultMap.put(nodeName, line);
                    Trace.out("Result placed in map till now for " + nodeName + " : " + line);
                }
                if (this.m_plsnr != null && !this.m_isOutputOff) {
                    if (msgArray[2].trim().length() > 0) {
                        if (this.m_firstmsg && this.m_singleNode) {
                            this.m_plsnr.write("========================================", false);
                            this.m_plsnr.writeHostName();
                            this.m_firstmsg = false;
                        }
                        this.m_plsnr.write(msgArray[2].trim(), !this.m_singleNode);
                    }
                } else {
                    Trace.out("Progress listener not initialized: Following progress message not written:\n " + msgArray[2]);
                }
            } else {
                Trace.out("Incorrect msg format" + msg);
            }
        }
    }

    public boolean isPartialStatus() {
        return this.isPartial;
    }

    private void addLine(boolean isError, String id, String line) {
        if (debugEnabled) {
            Trace.out("callback: %s %b %s", id, isError, line);
        }
        this.out_cmdOutput.add(line);
        if (isError && line.trim().length() > 0) {
            CRSNativeException exc = this.out_CompDescr.get(id);
            if (exc == null) {
                this.out_CompDescr.put(id, new CRSNativeException(line));
            } else {
                exc.addDetailedMessage(line);
            }
        }
    }

    Map<String, Map<String, String>> getRIs() {
        return this.out_EntDescr;
    }

    private void addRIAttr(String riName, String attrName, String attrValue) {
        Map<String, String> ri = this.out_EntDescr.get(riName);
        if (ri == null) {
            ri = new LinkedHashMap<String, String>();
            this.out_EntDescr.put(riName, ri);
        }
        ri.put(attrName, attrValue);
        if (debugEnabled) {
            Trace.out("<'%s', '%s':'%s'>", riName, attrName, attrValue);
        }
    }

    private static void clscrsCB(String msg) {
        if (debugEnabled) {
            Trace.out(1, "clscrs message: '%s'", msg);
        }
    }

    private void addComp(String comp, int rc, String message) {
        if (debugEnabled) {
            Trace.out("add comp: name %s, rc %d, msg %s", comp, rc, message);
        }
        if (rc == 0) {
            if (this.out_CompDescr.get(comp) != null) {
                return;
            }
            this.out_CompDescr.put(comp, null);
            return;
        }
        CRSNativeException exc = this.out_CompDescr.get(comp);
        if (exc == null) {
            this.out_CompDescr.put(comp, new CRSNativeException(comp, rc, message));
        } else {
            exc.setStatusAndMessage(rc, message);
        }
    }

    private CRSNativeException createException(int rc, String genericMessage) {
        if (rc == -559038737) {
            if (debugEnabled) {
                Trace.out("entity not registered");
            }
            return new CRSNativeNotRegisteredException();
        }
        if (rc == -559035650) {
            if (debugEnabled) {
                Trace.out("active version exception");
            }
            return new CRSNativeActiveVersionException(genericMessage);
        }
        CRSNativeException newExc = new CRSNativeException(null, rc, genericMessage);
        CRSNativeException[] allExceptions = new CRSNativeException[this.out_CompDescr.values().size()];
        allExceptions = this.out_CompDescr.values().toArray(allExceptions);
        for (int i = 0; i < allExceptions.length; ++i) {
            if (allExceptions[i] == null) continue;
            newExc.addDetailedMessage(allExceptions[i].toString());
        }
        if (debugEnabled) {
            Trace.out("New exception created:" + newExc.toString());
        }
        return newExc;
    }

    private String extractError(String msg) {
        Pattern pattern = Pattern.compile("error");
        Matcher matcher = pattern.matcher(msg);
        String value = null;
        if (matcher.find()) {
            int close = msg.indexOf("}", matcher.end());
            value = msg.substring(matcher.end() + 2, close);
        }
        return value;
    }
}

