/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.CRSNativeResult;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;

public class CRSCompositeOperationException
extends CompositeOperationException {
    Map<Object, CRSNativeException> m_comDescr;
    CRSException m_crsExc;
    private static final String LSEP = System.getProperty("line.separator");

    CRSCompositeOperationException(MessageKey key, Throwable cause, CRSNativeResult nr, Object ... args) {
        super(key, new HashMap<Object, NativeResult>(), args);
        this.m_comDescr = nr.getCompDescr();
        this.m_crsExc = new CRSException(key, cause, args);
        for (Object id : this.m_comDescr.keySet()) {
            NativeResult result = new NativeResult();
            CRSNativeException exp = this.m_comDescr.get(id);
            if (exp != null) {
                result.setException(exp);
                result.setStringResult(exp.getMessage());
            } else {
                result.setStatus(false);
            }
            this.m_resultMap.put(id, result);
        }
    }

    @Override
    public CompositeOperationException.Status getStatus(Object identifier) throws NoSuchIdentifierException {
        CRSNativeException res = this.getComponent(identifier);
        if (res == null) {
            return CompositeOperationException.Status.SUCCESS;
        }
        return res.getStatus() == 0 ? CompositeOperationException.Status.SUCCESS : CompositeOperationException.Status.EXCEPTION;
    }

    @Override
    public Set<Object> getOperationIdentifier() {
        return this.m_comDescr.keySet();
    }

    @Override
    public String getErrorMessage(Object identifier) throws NoSuchIdentifierException {
        CRSNativeException ex = this.getComponent(identifier);
        return ex != null ? ex.getMessage() : null;
    }

    @Override
    public String[] getErrorMessages(Object identifier) throws NoSuchIdentifierException {
        return new String[]{this.getErrorMessage(identifier)};
    }

    @Override
    public Exception getException(Object identifier) throws NoSuchIdentifierException {
        return this.getComponent(identifier);
    }

    @Override
    public String getCompositeMessages() {
        StringBuilder sb = null;
        for (CRSNativeException ne : this.m_comDescr.values()) {
            if (ne == null || ne.getStatus() == 0) continue;
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(ne.getMessage());
                continue;
            }
            sb.append(LSEP).append(ne.getMessage());
        }
        return sb == null ? null : sb.toString();
    }

    boolean containsString(String what) {
        for (CRSNativeException ne : this.m_comDescr.values()) {
            if (ne == null || ne.getStatus() == 0) {
                return false;
            }
            String msg = ne.getMessage();
            if (msg != null && msg.contains(what)) continue;
            return false;
        }
        return true;
    }

    CRSException getCRSException() {
        return this.m_crsExc;
    }

    private CRSNativeException getComponent(Object id) throws NoSuchIdentifierException {
        CRSNativeException res = null;
        if (id != null) {
            res = this.m_comDescr.get(id);
        }
        if (res == null) {
            throw new NoSuchIdentifierException((MessageKey)PrCcMsgID.NO_SUCH_IDENTIFIER, id);
        }
        return res;
    }
}

