/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSFactory;
import oracle.cluster.crs.CRSNotRegisteredException;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.CRSNativeNotRegisteredException;
import oracle.cluster.impl.crs.cops.EntityOperationsCRS;
import oracle.cluster.resources.PrCrMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CRSCache {
    private static HashMap<String, HashMap<String, String>> s_cache = new HashMap();
    private static final String[] s_attrInCache = new String[]{"DATABASE_TYPE", "CLUSTER_DATABASE", "DB_UNIQUE_NAME", "SERVICE_NAME", "VERSION", "ORACLE_HOME", "NAME"};
    private static boolean s_debugEnabled = Trace.isLevelEnabled(5);
    private static boolean s_useCache = true;

    public static synchronized void clear() {
        s_cache = new HashMap();
    }

    static synchronized void clearEntity(String entityName) {
        if (s_cache.containsKey(entityName)) {
            s_cache.remove(entityName);
            if (s_debugEnabled) {
                Trace.out((Object)"CRS cache: %s removed", entityName);
            }
        }
    }

    static synchronized void clearEntry(String entityName, ResourceAttribute ... attributes) {
        for (ResourceAttribute attr : attributes) {
            String attrName = attr.getName();
            for (String aName : s_attrInCache) {
                if (!attrName.equals(aName)) continue;
                CRSCache.clearEntity(entityName);
                return;
            }
        }
    }

    public static synchronized boolean enable(boolean flag) {
        boolean privValue = s_useCache;
        s_useCache = flag;
        CRSCache.invalidate();
        return privValue;
    }

    static synchronized List<ResourceAttribute> getAttributes(int type, String name, String nodeName, String[] attrNames) throws CRSAttributeNotFoundException, CRSNativeException, CRSException {
        if (CRSCache.shouldBeCached(attrNames)) {
            return CRSCache.getAttributesFromCache(type, name, nodeName, attrNames);
        }
        return CRSCache.getAttributesFromCRS(type, name, nodeName, attrNames);
    }

    public static synchronized void invalidate() {
        s_cache = new HashMap();
    }

    private static List<ResourceAttribute> getAttributesFromCRS(int type, String entityName, String nodeName, String[] attrNames) throws CRSAttributeNotFoundException, CRSNativeException, CRSException {
        if (s_debugEnabled) {
            Trace.out("CRS: name: %s, type %d, node: %s", entityName, type, nodeName);
            Trace.out("attrs: " + (attrNames != null && attrNames.length > 0 ? Arrays.toString(attrNames) : "all"));
        }
        try {
            List<ResourceAttribute> result = EntityOperationsCRS.stat2Helper(type, entityName, nodeName, attrNames);
            if (s_debugEnabled) {
                Trace.out("CRS: " + Arrays.toString(result.toArray()));
            }
            return result;
        }
        catch (CRSNativeNotRegisteredException e) {
            throw new CRSNotRegisteredException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, entityName);
        }
    }

    private static List<ResourceAttribute> getAttributesFromCache(int type, String entityName, String nodeName, String[] attrNames) throws CRSAttributeNotFoundException, CRSNativeException, CRSException {
        if (attrNames == null || nodeName != null) {
            return CRSCache.getAttributesFromCRS(type, entityName, nodeName, attrNames);
        }
        boolean missed = false;
        String value = null;
        List<ResourceAttribute> result = new LinkedList<ResourceAttribute>();
        HashMap<String, String> entity = s_cache.get(entityName);
        if (entity == null) {
            missed = true;
            entity = new HashMap();
            s_cache.put(entityName, entity);
        }
        if (!missed) {
            for (String attrName : attrNames) {
                value = entity.get(attrName);
                if (value == null) {
                    missed = true;
                    break;
                }
                result.add(new ResourceAttribute(attrName, value));
            }
        }
        if (missed) {
            try {
                result = EntityOperationsCRS.stat2Helper(type, entityName, nodeName, attrNames);
            }
            catch (CRSNativeNotRegisteredException e) {
                throw new CRSNotRegisteredException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, entityName);
            }
            value = result.get(0).getValue();
            if (s_debugEnabled) {
                Trace.out("updated: %s %s", entityName, Arrays.toString(result.toArray()));
            }
            for (ResourceAttribute attr : result) {
                entity.put(attr.getName(), attr.getValue());
            }
            return result;
        }
        if (s_debugEnabled) {
            Trace.out("CRS cache: %s %s", entityName, Arrays.toString(result.toArray()));
        }
        return result;
    }

    private static boolean shouldBeCached(String[] attrNames) {
        if (!s_useCache) {
            return false;
        }
        if (attrNames == null || attrNames.length == 0) {
            return false;
        }
        block0: for (String name2compare : attrNames) {
            for (String name : s_attrInCache) {
                if (name.equals(name2compare)) continue block0;
            }
            return false;
        }
        return true;
    }

    static {
        CRSFactory.CRSCacheMode mode = CRSFactory.defaultCRSCacheMode;
        String propertyVal = System.getProperty("SRVMCRSCACHE.DEFAULT");
        if (propertyVal != null) {
            try {
                mode = CRSFactory.CRSCacheMode.Local.getEnumMember(propertyVal);
            }
            catch (EnumConstantNotPresentException enumConstantNotPresentException) {
                // empty catch block
            }
        }
        switch (mode) {
            case None: {
                CRSCache.enable(false);
                break;
            }
            case Local: {
                CRSCache.enable(true);
                break;
            }
            default: {
                Trace.out("unknown mode %s, cache disabled");
                CRSCache.enable(false);
            }
        }
        Trace.out("CRSCache: useCache is %b", s_useCache);
    }
}

