/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.crs.ActionMessage;
import oracle.cluster.crs.ActionResult;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.cops.ActionMessageImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ActionResultImpl
implements ActionResult {
    Node m_node;
    ActionMessage m_finalMessage;
    boolean m_success;
    boolean m_warning;
    List<ActionMessage> m_infoMessages;

    ActionResultImpl(Node node) {
        this.m_node = node;
        this.m_finalMessage = null;
        this.m_infoMessages = new ArrayList<ActionMessage>();
        this.m_success = false;
        this.m_warning = false;
    }

    @Override
    public Node getNode() {
        return this.m_node;
    }

    @Override
    public ActionMessage getFinalMessage() {
        if (this.m_finalMessage == null) {
            Trace.out("no final message received for node " + this.m_node);
            return new ActionMessageImpl(ActionMessage.Type.ACTION_MESSAGE_ERROR, PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_NO_FINAL_MSG, new Object[0]);
        }
        return this.m_finalMessage;
    }

    @Override
    public List<ActionMessage> getInfoMessages() {
        return this.m_infoMessages;
    }

    @Override
    public ActionMessage.Type getStatus() {
        if (this.m_finalMessage == null) {
            Trace.out("no final message received for node " + this.m_node);
            return ActionMessage.Type.ACTION_MESSAGE_ERROR;
        }
        return this.m_finalMessage.getType();
    }

    @Override
    public boolean isSuccess() {
        return this.m_success;
    }

    @Override
    public boolean isWarning() {
        return this.m_warning;
    }

    void addMessage(ActionMessage amsg) throws CRSException {
        if (amsg.getType() == ActionMessage.Type.ACTION_MESSAGE_INFO) {
            this.m_infoMessages.add(amsg);
            this.m_success = true;
        } else {
            if (this.m_finalMessage != null) {
                Trace.out("Had final message " + this.m_finalMessage.getMessage());
                Trace.out("Multiple final messages arrived for " + this.m_node);
                throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_MULTIPLE_FINAL_MSGS, this.m_node);
            }
            this.m_finalMessage = amsg;
            this.m_success = false;
            if (amsg.getType() == ActionMessage.Type.ACTION_MESSAGE_WARNING) {
                this.m_warning = true;
            }
        }
    }
}

