/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.cvu.CVU;
import oracle.cluster.database.CLBGoal;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.FailoverMethod;
import oracle.cluster.database.FailoverRestore;
import oracle.cluster.database.FailoverType;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.RLBGoal;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.ServiceType;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.util.CryptoAlg;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ResourceType {
    private static boolean s_isCluster = Cluster.isCluster();

    public static List<String> getAttributeNames(Class<? extends Enum> clazz) {
        LinkedList<String> list = new LinkedList<String>();
        for (Enum constant : clazz.getEnumConstants()) {
            list.add(constant.name());
        }
        return list;
    }

    public static List<ResourceAttribute> getAttributes(Class<? extends Enum> clazz) {
        LinkedList<ResourceAttribute> list = new LinkedList<ResourceAttribute>();
        for (Enum constant : clazz.getEnumConstants()) {
            list.add(new ResourceAttribute(constant.name(), constant.toString()));
        }
        return list;
    }

    public static ResourceAttribute getAttribute(Class<? extends Enum> clazz, String attrName) {
        for (Enum constant : clazz.getEnumConstants()) {
            if (!constant.name().equals(attrName)) continue;
            return new ResourceAttribute(constant.name(), constant.toString());
        }
        return null;
    }

    public static List<ResourceAttribute> getProfile(Class<? extends Enum> clazz) {
        return ResourceType.getProfile(ResourceType.getAttributes(clazz));
    }

    public static List<ResourceAttribute> getProfile(List<ResourceAttribute> attrList) {
        LinkedList<ResourceAttribute> myList = new LinkedList<ResourceAttribute>();
        for (int i = 0; i < attrList.size(); ++i) {
            ResourceAttribute attr = attrList.get(i);
            if (LocalResource.NAME.name().equalsIgnoreCase(attr.getName()) || ResourceLiterals.TYPE_NAME.name().equalsIgnoreCase(attr.getName())) {
                ResourceAttribute nameAttr = new ResourceAttribute(LocalResource.NAME.name(), null);
                myList.add(nameAttr);
                nameAttr = new ResourceAttribute(ResourceLiterals.TYPE.name(), attr.getValue());
                myList.add(nameAttr);
                continue;
            }
            if (LocalResource.BASE_TYPE.name().equalsIgnoreCase(attr.getName()) || ResourceLiterals.TYPE_ACL.name().equalsIgnoreCase(attr.getName())) continue;
            myList.add(attr);
        }
        return myList;
    }

    public static String getPerXName(String attrName, String nodeName) {
        return attrName + ResourceLiterals.AT.toString() + ResourceLiterals.SERVERNAME.toString() + '(' + nodeName + ')';
    }

    public static String getPerXCardinalityName(String attrName, String cardinalityID) {
        return attrName + ResourceLiterals.AT.toString() + ResourceLiterals.CARDINALITYID.toString() + '(' + cardinalityID + ')';
    }

    public static String getAgentGenEnv(String attrName) {
        String val = System.getenv(ResourceLiterals.AGENT_ENV_PREFIX.toString() + attrName);
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    static String getEvtTemplate(Class<? extends Enum> clazz) {
        if (clazz == Listener.class) {
            return ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.RESOURCE_CLASS.toString() + "=" + ResourceLiterals.LISTENER.toString() + ")" + " " + ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.LISTENER_NAME.toString() + "=" + ResourceLiterals.PARSE.toString() + "(%" + Listener.NAME.name() + "%, ., 2))";
        }
        if (clazz == LocalASM.class || clazz == ClusterASM.class) {
            return ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.RESOURCE_CLASS.toString() + "=" + ResourceLiterals.ASM.toString() + ")" + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + ResourceLiterals.INSTANCE_NAME.toString() + "= %" + LocalASM.GEN_USR_ORA_INST_NAME.name() + "%)";
        }
        if (clazz == ClusterVIP.class) {
            return ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.RESOURCE_CLASS.toString() + "=" + ResourceLiterals.VIP.toString() + ")" + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + ClusterVIP.HOSTING_MEMBERS.name() + "=%" + ClusterVIP.HOSTING_MEMBERS.name() + "%)" + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + ClusterVIP.USR_ORA_VIP.name() + "=%" + ClusterVIP.USR_ORA_VIP.name() + "%)" + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + ClusterVIP.GEN_USR_ORA_VIP.name() + "=%" + ClusterVIP.GEN_USR_ORA_VIP.name() + "%)" + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + Network.ADDRESS_TYPE.name() + "=" + ResourceLiterals.STAT.toString() + "(" + ResourceLiterals.CONCAT.toString() + "(ora," + ResourceLiterals.CONCAT.toString() + "(" + ResourceLiterals.PARSE.toString() + "(" + ResourceLiterals.PARSE.toString() + "(" + "%" + ResourceLiterals.TYPE_ATTR.toString() + "%," + "ora." + ResourceLiterals.CLUSTER_VIP.toString() + "_, 1),.,1)," + ResourceLiterals.NETWORK.toString() + ",.),.)," + Network.ADDRESS_TYPE.name() + "))" + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + ClusterVIP.NETWORK_COUNT.name() + "=" + ResourceLiterals.COUNT_RES.toString() + "(ora.,.net))";
        }
        if (clazz == ScanVIP.class) {
            return ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.RESOURCE_CLASS.toString() + "=" + ResourceLiterals.SCAN_VIP.toString() + ")" + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + ScanVIP.HOSTING_MEMBERS.name() + "=%" + ScanVIP.HOSTING_MEMBERS.name() + "%)";
        }
        if (clazz == GNSVIP.class) {
            return ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.RESOURCE_CLASS.toString() + "=" + ResourceLiterals.GNS_VIP.toString() + ")" + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + GNSVIP.HOSTING_MEMBERS.name() + "=%" + GNSVIP.HOSTING_MEMBERS.name() + "%)";
        }
        if (clazz == HAVIP.class) {
            return ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.RESOURCE_CLASS.toString() + "=" + ResourceLiterals.HAVIP.toString() + ")" + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + HAVIP.HOSTING_MEMBERS.name() + "=%" + HAVIP.HOSTING_MEMBERS.name() + "%)";
        }
        if (clazz == ScanListener.class) {
            return ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.RESOURCE_CLASS.toString() + "=" + ResourceLiterals.SCAN_LISTENER.toString() + ")" + " " + ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.LISTENER_NAME.toString() + "=" + ResourceLiterals.PARSE.toString() + "(%" + ScanListener.NAME.name() + "%, ., 2))";
        }
        if (clazz == Database.class) {
            return ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.RESOURCE_CLASS.toString() + "=" + ResourceLiterals.DATABASE.toString() + ")" + " " + ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.DB_UNIQUE_NAME.toString() + "= " + ResourceLiterals.CONCAT.toString() + "(" + ResourceLiterals.PARSE.toString() + "(%" + Database.NAME.name() + "%, ., 2), " + "%" + Database.USR_ORA_DOMAIN.name() + "%, .))" + " " + ResourceLiterals.ELEMENT_TEMPLATE.toString() + "(" + ResourceLiterals.INSTANCE_NAME.toString() + "= %" + Database.GEN_USR_ORA_INST_NAME.name() + "%)";
        }
        if (clazz == GNS.class) {
            return ResourceLiterals.PROPERTY_TEMPLATE.toString() + "(" + ResourceLiterals.RESOURCE_CLASS.toString() + "=" + ResourceLiterals.GNS.toString() + ")";
        }
        throw new IllegalArgumentException(clazz.toString());
    }

    static int getVIPCheckTimeout() {
        int checkTimeout = 30;
        String osName = DeterminePlatform.getOSName();
        File cluFile = null;
        if (osName.equals("HP-UX")) {
            cluFile = new File("/usr/sbin/cmversion");
        } else if (osName.equals("SunOS") || osName.equals("Solaris")) {
            cluFile = new File("/opt/FJSVhanet/usr/sbin/hanetconfig");
        }
        if (cluFile != null && cluFile.exists()) {
            RuntimeExec runtimeExec = new RuntimeExec(new String[]{cluFile.getAbsolutePath()}, null, null);
            runtimeExec.runCommand();
            if (runtimeExec.getExitValue() == 0) {
                checkTimeout *= 2;
            } else {
                Trace.out("IGNORE: getVIPCheckTimeout: output=" + Utils.getString(runtimeExec.getOutput(), " ") + " error=" + Utils.getString(runtimeExec.getError(), " "));
            }
        }
        return checkTimeout;
    }

    static /* synthetic */ boolean access$000() {
        return s_isCluster;
    }

    public static enum Home {
        NAME(ResourceLiterals.HOME_TYPE.toString()),
        BASE_TYPE(LocalHome.NAME.toString()),
        DESCRIPTION("CRS resource type for Home resource"),
        SERVER_CATEGORY(""),
        SERVER_POOLS(ResourceLiterals.STAR.toString()),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORA_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        START_TIMEOUT(String.valueOf(30)),
        STOP_TIMEOUT(String.valueOf(30)),
        CLEAN_TIMEOUT(String.valueOf(120)),
        CHECK_TIMEOUT(String.valueOf(30)),
        RESTART_ATTEMPTS(String.valueOf(3)),
        CHECK_INTERVAL(String.valueOf(120)),
        CARDINALITY(String.valueOf(1)),
        ORACLE_HOME(""),
        HOME_TYPE(""),
        HOME_SHARED("YES"),
        START_DEPENDENCIES(""),
        STOP_DEPENDENCIES(""),
        AUTO_START("restore");

        private String m_value;

        private Home(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ClusterHome {
        NAME(ResourceLiterals.CLUSTER_HOME_TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString());

        private String m_value;

        private ClusterHome(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum LocalHome {
        NAME(ResourceLiterals.LOCAL_HOME_TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString());

        private String m_value;

        private LocalHome(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum CCMB {
        NAME(ResourceLiterals.CCMB_TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString()),
        DESCRIPTION(ResourceLiterals.CCMB_RES_DESC.toString()),
        SERVER_CATEGORY(""),
        SERVER_POOLS(ResourceLiterals.STAR.toString()),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORA_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        AUTO_START(CRSResource.AutoStart.ALWAYS.toString()),
        ACTION_TIMEOUT(String.valueOf(60)),
        START_TIMEOUT(String.valueOf(240)),
        STOP_TIMEOUT(String.valueOf(240)),
        CLEAN_TIMEOUT(String.valueOf(60)),
        CHECK_TIMEOUT(String.valueOf(30)),
        CHECK_INTERVAL(String.valueOf(15)),
        START_DEPENDENCIES(""),
        STOP_DEPENDENCIES("");

        private String m_value;

        private CCMB(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum VirtualMachine {
        NAME("ora." + ResourceLiterals.VM.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        PLACEMENT("restricted"),
        ENABLED(ResourceLiterals.ENABLED_VALUE.toString()),
        DESCRIPTION("CRS resource type for VM resource"),
        SERVER_CATEGORY(""),
        SERVER_POOLS(ResourceLiterals.STAR.toString()),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORA_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        START_TIMEOUT(String.valueOf(180)),
        STOP_TIMEOUT(String.valueOf(60)),
        CLEAN_TIMEOUT(String.valueOf(180)),
        RESTART_ATTEMPTS(String.valueOf(5)),
        CHECK_INTERVAL(String.valueOf(10)),
        CARDINALITY(String.valueOf(1)),
        START_DEPENDENCIES(""),
        STOP_DEPENDENCIES(""),
        HOSTING_MEMBERS(""),
        OVMM_VM_ID(""),
        OVMM_VM_NAME(""),
        WORKLOAD_CPU(String.valueOf(0)),
        WORKLOAD_MEMORY_TARGET(String.valueOf(0)),
        WORKLOAD_MEMORY_MAX(String.valueOf(0)),
        WORKLOAD_CPU_CAP(String.valueOf(0)),
        VM("");

        private String m_value;

        private VirtualMachine(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum CHAD {
        NAME("ora." + ResourceLiterals.CHAD.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("Resource type for Cluster Health Analysis Service"),
        SERVER_CATEGORY(""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.CHAD_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        ACTIONS(ResourceLiterals.CHAD_ACTIONS.toString()),
        RESTART_ATTEMPTS(String.valueOf(5)),
        START_DEPENDENCIES(""),
        STOP_DEPENDENCIES(""),
        UPTIME_THRESHOLD("1d"),
        CHECK_TIMEOUT(String.valueOf(30)),
        START_TIMEOUT(String.valueOf(300)),
        STOP_TIMEOUT(String.valueOf(180)),
        CHECK_INTERVAL(String.valueOf(60)),
        ACTION_TIMEOUT(String.valueOf(900)),
        ACTION_TYPE(""),
        TARGET_TYPE(""),
        TARGET_NAME(""),
        TARGET_DEFAULT(ResourceLiterals.TARGET_DEFAULT_ATLEASTONE.toString()),
        MODEL_NAME(""),
        MONITORED_DATABASES("");

        private String m_value;

        private CHAD(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum CVU {
        NAME("ora." + ResourceLiterals.CVU.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        PLACEMENT("restricted"),
        DESCRIPTION("CRS resource type for CVU Container"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.CVU_AGENT.toString()),
        CHECK_TIMEOUT(String.valueOf(600)),
        RESTART_ATTEMPTS(String.valueOf(5)),
        SCRIPT_TIMEOUT(String.valueOf(600)),
        RUN_INTERVAL(ResourceLiterals.CVU_RUN_INTERVAL.toString()),
        NEXT_CHECK_TIME(""),
        CHECK_RESULTS(ResourceLiterals.CVU_CHECK_RESULTS.toString()),
        CRSHOME_SPACE_ALERT_STATE(CVU.SpaceAlertState.OFF.toString()),
        CV_DESTLOC(""),
        GEN_NEXT_CHECK_TIME(String.valueOf(0)),
        GEN_RUNNING_NODE("");

        private String m_value;

        private CVU(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum GossipServer {
        NAME("ora." + ResourceLiterals.GOSSIPSERVER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        DESCRIPTION("CRS resource type for Discovery Server"),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.GOSSIPSERVER_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        RESTART_ATTEMPTS(String.valueOf(5)),
        UPTIME_THRESHOLD("1d"),
        PORT(ResourceLiterals.GOSSIPSERVER_PORT.toString()),
        PROPERTIES("");

        private String m_value;

        private GossipServer(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum SuperCluster {
        NAME("ora." + ResourceLiterals.SUPERCLUSTER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        DESCRIPTION("CRS resource type for Super Cluster Representative"),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.SUPERCLUSTER_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        RESTART_ATTEMPTS(String.valueOf(5)),
        UPTIME_THRESHOLD("1d"),
        TIER_NAME(ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_CLUSTER_NAME.toString() + ResourceLiterals.PERCENT.toString() + '.' + ResourceLiterals.DATABASE.toString()),
        CARDINALITY(String.valueOf(2)),
        PORT(ResourceLiterals.SUPERCLUSTER_PORT.toString()),
        DISCOVERY_METHOD(""),
        MCAST_ADDRESS(""),
        MEMBER_LIST(""),
        PROPERTIES("");

        private String m_value;

        private SuperCluster(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum RHPC {
        NAME("ora." + ResourceLiterals.RHPCLIENT.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        DESCRIPTION("CRS resource type for Rapid Home Provisioning Client"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        START_TIMEOUT(String.valueOf(300)),
        STOP_TIMEOUT(String.valueOf(120)),
        RESTART_ATTEMPTS(String.valueOf(1)),
        FAILURE_THRESHOLD(String.valueOf(2)),
        FAILURE_INTERVAL(String.valueOf(3600)),
        UPTIME_THRESHOLD("1d"),
        STORAGE_BASE_PATH(""),
        EMAIL_ADDRESS(""),
        MAIL_SERVER_ADDRESS(""),
        MAIL_SERVER_PORT(""),
        RHPS_CLUSTERNAME(""),
        GNS_DISCOVERY_STRING(""),
        GNS_SUBDOMAIN_STRING(""),
        CRYPTO_ALGORITHM(CryptoAlg.AES.toString()),
        INITIAL_HANDSHAKE(String.valueOf(0)),
        WORKINGCOPY_EXISTS(String.valueOf(false)),
        GIPATCH_INPROGRESS(Boolean.toString(false).toLowerCase()),
        PORT(ResourceLiterals.RHP_RMIPORT.toString()),
        HTTP_PORT(ResourceLiterals.QOSMSERVER_HTTPPORT.toString()),
        TLS_ENABLED(Boolean.toString(false)),
        USR_ORA_ENV(""),
        APPLICATION(ResourceLiterals.RHP_APP.toString());

        private String m_value;

        private RHPC(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum RHPS {
        NAME("ora." + ResourceLiterals.RHPSERVER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        DESCRIPTION("CRS resource type for Rapid Home Provisioning Server"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        START_TIMEOUT(String.valueOf(300)),
        STOP_TIMEOUT(String.valueOf(120)),
        RESTART_ATTEMPTS(String.valueOf(1)),
        FAILURE_THRESHOLD(String.valueOf(2)),
        FAILURE_INTERVAL(String.valueOf(3600)),
        UPTIME_THRESHOLD("1d"),
        STORAGE_BASE_PATH(""),
        CRYPTO_ALGORITHM(CryptoAlg.AES.toString()),
        EMAIL_ADDRESS(""),
        MAIL_SERVER_ADDRESS(""),
        MAIL_SERVER_PORT(""),
        RHPC_EXIST(Boolean.toString(false).toLowerCase()),
        IMAGE_EXIST(Boolean.toString(false).toLowerCase()),
        GIPATCH_INPROGRESS(Boolean.toString(false).toLowerCase()),
        DB_SCHEMA(ResourceLiterals.RHPS_DBSCHEMA.toString()),
        TLS_ENABLED(Boolean.toString(false)),
        PORT(ResourceLiterals.RHP_RMIPORT.toString()),
        HTTP_PORT(ResourceLiterals.QOSMSERVER_HTTPPORT.toString()),
        USR_ORA_ENV(""),
        SWCOPY_METHOD(ResourceLiterals.RHPS_SWCOPY_DIRECT.toString()),
        APPLICATION(ResourceLiterals.RHP_APP.toString());

        private String m_value;

        private RHPS(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum GHC {
        NAME("ora." + ResourceLiterals.GHC.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        DESCRIPTION("CRS resource type for Grid Home Client"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        START_TIMEOUT(String.valueOf(300)),
        STOP_TIMEOUT(String.valueOf(120)),
        RESTART_ATTEMPTS(String.valueOf(1)),
        FAILURE_THRESHOLD(String.valueOf(2)),
        FAILURE_INTERVAL(String.valueOf(3600)),
        UPTIME_THRESHOLD("1d"),
        STORAGE_BASE_PATH(""),
        EMAIL_ADDRESS(""),
        MAIL_SERVER_ADDRESS(""),
        MAIL_SERVER_PORT(""),
        GHS_CLUSTERNAME(""),
        GNS_DISCOVERY_STRING(""),
        GNS_SUBDOMAIN_STRING(""),
        CRYPTO_ALGORITHM(CryptoAlg.AES.toString()),
        INITIAL_HANDSHAKE(String.valueOf(0)),
        GHAPPARGS(""),
        WORKINGCOPY_EXISTS(String.valueOf(false)),
        GIPATCH_INPROGRESS(Boolean.toString(false).toLowerCase()),
        PORT(ResourceLiterals.GH_RMIPORT.toString()),
        USR_ORA_ENV("");

        private String m_value;

        private GHC(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum GHS {
        NAME("ora." + ResourceLiterals.GHS.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        DESCRIPTION("CRS resource type for Grid Home Server"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        START_TIMEOUT(String.valueOf(300)),
        STOP_TIMEOUT(String.valueOf(120)),
        RESTART_ATTEMPTS(String.valueOf(1)),
        FAILURE_THRESHOLD(String.valueOf(2)),
        FAILURE_INTERVAL(String.valueOf(3600)),
        UPTIME_THRESHOLD("1d"),
        STORAGE_BASE_PATH(""),
        CRYPTO_ALGORITHM(CryptoAlg.AES.toString()),
        EMAIL_ADDRESS(""),
        MAIL_SERVER_ADDRESS(""),
        MAIL_SERVER_PORT(""),
        GHC_EXIST(Boolean.toString(false).toLowerCase()),
        IMAGE_EXIST(Boolean.toString(false).toLowerCase()),
        GIPATCH_INPROGRESS(Boolean.toString(false).toLowerCase()),
        DB_SCHEMA(ResourceLiterals.GHS_DBSCHEMA.toString()),
        GHAPPARGS(""),
        PORT(ResourceLiterals.GH_RMIPORT.toString()),
        USR_ORA_ENV("");

        private String m_value;

        private GHS(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum QOSMServer {
        NAME("ora." + ResourceLiterals.QOSMSERVER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        PLACEMENT("restricted"),
        DESCRIPTION("CRS resource type for QOSM Server Container"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        ACTION_SCRIPT(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.QOSMSERVER_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_SCRIPT_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        START_TIMEOUT(String.valueOf(300)),
        STOP_TIMEOUT(String.valueOf(120)),
        RESTART_ATTEMPTS(String.valueOf(1)),
        FAILURE_THRESHOLD(String.valueOf(2)),
        FAILURE_INTERVAL(String.valueOf(3600)),
        UPTIME_THRESHOLD("1d"),
        PORT(ResourceLiterals.QOSMSERVER_RMIPORT.toString()),
        HTTP_PORT(ResourceLiterals.QOSMSERVER_HTTPPORT.toString()),
        TLS_ENABLED(Boolean.toString(false)),
        APPLICATION("qos");

        private String m_value;

        private QOSMServer(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum OC4J {
        NAME("ora." + ResourceLiterals.OC4J.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        PLACEMENT("restricted"),
        DESCRIPTION("CRS resource type for OC4J Container"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        ACTION_SCRIPT(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.OC4J_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_SCRIPT_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        START_TIMEOUT(String.valueOf(300)),
        STOP_TIMEOUT(String.valueOf(120)),
        RESTART_ATTEMPTS(String.valueOf(1)),
        FAILURE_THRESHOLD(String.valueOf(2)),
        FAILURE_INTERVAL(String.valueOf(3600)),
        UPTIME_THRESHOLD("1d"),
        PORT(ResourceLiterals.OC4J_RMIPORT.toString()),
        HTTP_PORT(ResourceLiterals.OC4J_HTTPPORT.toString());

        private String m_value;

        private OC4J(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum EONS {
        NAME("ora." + ResourceLiterals.EONS.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString()),
        DESCRIPTION("CRS resource type for eONS"),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.EONS_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        START_TIMEOUT(String.valueOf(300)),
        STOP_TIMEOUT(String.valueOf(120)),
        CHECK_TIMEOUT(String.valueOf(120)),
        RESTART_ATTEMPTS(String.valueOf(3)),
        AUTO_START(CRSResource.AutoStart.ALWAYS.toString()),
        DISCOVERY_METHOD(""),
        PORT(ResourceLiterals.EONS_PORT.toString()),
        MCAST_ADDRESS(""),
        MEMBER_LIST(""),
        PROPERTIES("");

        private String m_value;

        private EONS(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ServerCategory {
        NAME(""),
        ACTIVE_CSS_ROLE(""),
        EXPRESSION("");

        private String m_value;

        private ServerCategory(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ConfigPolicy {
        NAME(""),
        DESCRIPTION("");

        private String m_value;

        private ConfigPolicy(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ServerPool {
        NAME(""),
        MIN_SIZE(String.valueOf(0)),
        MAX_SIZE(String.valueOf(0)),
        IMPORTANCE(String.valueOf(0)),
        PARENT_POOLS(""),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        SERVER_NAMES(""),
        ACTIVE_SERVERS(""),
        EXCLUSIVE_POOLS("");

        private String m_value;

        private ServerPool(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum Server {
        NAME(""),
        STATE(""),
        ACTIVE_POOLS(""),
        STATE_DETAILS("");

        private String m_value;

        private Server(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum Service {
        NAME(ResourceLiterals.SERVICE_TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        TYPE_VERSION("3.2"),
        PLACEMENT("restricted"),
        DESCRIPTION("CRS resource type definition for Oracle Service"),
        SERVER_CATEGORY(""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.SERVICE_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        USR_ORA_DISCONNECT(Boolean.toString(false)),
        TAF_POLICY(ServiceTAF.NONE.toString()),
        SERVICE_NAME(""),
        SERVICE_TYPE(ServiceType.MAIN.toString()),
        SERVER_POOLS(""),
        SERVICE_NAME_PQ(""),
        RESTART_ATTEMPTS(String.valueOf(ResourceType.access$000() ? 0 : 2)),
        START_TIMEOUT(String.valueOf(600)),
        STOP_TIMEOUT(String.valueOf(600)),
        CHECK_TIMEOUT(String.valueOf(30)),
        CHECK_INTERVAL(String.valueOf(600)),
        USR_ORA_OPI(Boolean.toString(false)),
        MANAGEMENT_POLICY(ManagementPolicy.AUTOMATIC.toString()),
        ROLE(DBRole.PRIMARY.toString()),
        DTP(String.valueOf(0)),
        AQ_HA_NOTIFICATION(String.valueOf(0)),
        FAILOVER_TYPE(FailoverType.NONE.toString()),
        FAILOVER_METHOD(FailoverMethod.NONE.toString()),
        FAILOVER_RETRIES(String.valueOf(0)),
        FAILOVER_DELAY(String.valueOf(0)),
        TAF_FAILOVER_DELAY(""),
        FAILOVER_RESTORE(FailoverRestore.NONE.toString()),
        CLB_GOAL(CLBGoal.LONG.toString()),
        RLB_GOAL(RLBGoal.NONE.toString()),
        GEN_SERVICE_NAME(""),
        DEFAULT_TEMPLATE(""),
        AGENT_PARAMETERS(""),
        EDITION(""),
        GSM_FLAGS(String.valueOf(0)),
        PLUGGABLE_DATABASE(""),
        GLOBAL(Boolean.toString(false)),
        MAX_LAG_TIME("ANY"),
        SQL_TRANSLATION_PROFILE(""),
        COMMIT_OUTCOME(String.valueOf(0)),
        RETENTION(String.valueOf(86400)),
        REPLAY_INITIATION_TIME(String.valueOf(300)),
        SESSION_STATE_CONSISTENCY(""),
        SESSION_NOREPLAY(Boolean.toString(false)),
        DRAIN_TIMEOUT(""),
        DRAIN_ID(""),
        STOP_OPTION(""),
        ACTIONS(""),
        RF_SERVICE("0"),
        RELOCATE_KIND(ResourceLiterals.RELOCATE_KIND_OFFLINE.toString()),
        START_DEPENDENCIES_RTE_INTERNAL(""),
        STOP_DEPENDENCIES_RTE_INTERNAL(""),
        START_DEPENDENCIES_TEMPLATE("<xml><If cond=\"SERVICE_TYPE\" value=\"PQ\"> <Then>hard(global:<Res>{mainService}</Res>)</Then> <Else>weak(type:ora.listener.type)</Else> </If><If cond=\"isCluster\" value=\"True\"> <Then><If cond=\"isCreatePreconnectSrv\" value=\"True\"> <Then>hard(<Res>global:{service}</Res>)hard(<Res>{database}</Res>)exclusion(<Res>{service}</Res>)<If cond=\"ADD_PULLUP_ALWAYS_SVC\" value=\"True\"> <Then>pullup:always(<Res>global:{service}</Res>)</Then> <Else>pullup(<Res>global:{service}</Res>)</Else> </If></Then> <Else>hard(<Res>{database}</Res>)<If cond=\"UPDATE_SERVICE_TYPE\" value=\"False\"> <Then><If cond=\"SERVICE_CARDINALITY\" value=\"1\"> <Then><If cond=\"NET_NUM\" op=\"neq\" value=\"-1\"> <Then>dispersion(type:ora.service.type)</Then> </If></Then> </If></Then> </If><If cond=\"ADD_PULLUP_ALWAYS_DB\" value=\"True\"> <Then>pullup:always(<Res>{database}</Res>) </Then> <Else>pullup(<Res>{database}</Res>) </Else> </If><If cond=\"UPDATE_VIP_TYPE\" value=\"False\"> <Then><If cond=\"DB_MANAGEMENT_POLICY\" op=\"neq\" value=\"NORESTART\"> <Then>pullup(<ResTypeList>{cluster_vip_net}</ResTypeList>)</Then> </If></Then> </If></Else> </If>hard(<ResTypeList>{cluster_vip_net}</ResTypeList>)</Then> <Else>hard(<Res>{database}</Res>)<If cond=\"ADD_PULLUP_ALWAYS_DB\" value=\"True\"> <Then>pullup:always(<Res>{database}</Res>) </Then> <Else>pullup(<Res>{database}</Res>)</Else> </If></Else> </If><If cond=\"UPDATE_VIP_TYPE\" value=\"True\"> <Then><If cond=\"DB_MANAGEMENT_POLICY\" op=\"neq\" value=\"NORESTART\"> <Then>pullup(<ResTypeList>{cluster_vip_net}</ResTypeList>)</Then> </If></Then> </If><If cond=\"UPDATE_SERVICE_TYPE\" value=\"True\"> <Then><If cond=\"SERVICE_CARDINALITY\" value=\"1\"> <Then>dispersion(type:ora.service.type)</Then> </If></Then> </If></xml>"),
        STOP_DEPENDENCIES_TEMPLATE("<xml><If cond=\"isCluster\" value=\"True\"> <Then><If cond=\"isCreatePreconnectSrv\" value=\"True\"> <Then>hard(<Res>global:{service}</Res>)</Then> </If></Then> </If>hard(<Res>intermediate:{database}</Res>)<If cond=\"isCluster\" value=\"True\"> <Then>hard(<ResTypeList>{cluster_vip_net}</ResTypeList>)</Then> </If></xml>"),
        USER_WORKLOAD("yes"),
        USR_ORA_FLAGS(""),
        USR_ORA_OPEN_MODE(""),
        USR_ORA_STOP_MODE(""),
        CSS_CRITICAL(CRSResource.CSSCritical.NO.toString());

        private String m_value;

        private Service(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum Database {
        NAME(ResourceLiterals.DATABASE_TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        TYPE_VERSION("3.3"),
        PLACEMENT("restricted"),
        DESCRIPTION("CRS resource type definition for Oracle Database"),
        SERVER_CATEGORY(""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.DATABASE_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        ORACLE_HOME(""),
        ORACLE_HOME_OLD(""),
        SERVER_POOLS(""),
        SERVER_POOLS_PQ(""),
        SERVER_POOLS_RF(""),
        SERVICE_NAMES(""),
        CLUSTER_DATABASE(Boolean.toString(true).toLowerCase()),
        RESTART_ATTEMPTS(String.valueOf(2)),
        START_TIMEOUT(String.valueOf(600)),
        STOP_TIMEOUT(String.valueOf(600)),
        CHECK_TIMEOUT(String.valueOf(30)),
        CHECK_INTERVAL(String.valueOf(900)),
        FAILURE_INTERVAL(String.valueOf(60)),
        FAILURE_THRESHOLD(String.valueOf(1)),
        INSTANCE_FAILOVER(ResourceLiterals.ENABLED_VALUE.toString()),
        USR_ORA_OPI(Boolean.toString(false)),
        SPFILE(""),
        PWFILE(""),
        ROLE(DBRole.PRIMARY.toString()),
        MANAGEMENT_POLICY(ManagementPolicy.AUTOMATIC.toString()),
        DATABASE_TYPE(""),
        ONLINE_RELOCATION_TIMEOUT(String.valueOf(0)),
        DRAIN_ID(""),
        DRAIN_TIMEOUT(""),
        DB_UNIQUE_NAME(""),
        USR_ORA_DB_NAME(""),
        USR_ORA_DOMAIN(""),
        GEN_AUDIT_FILE_DEST(""),
        USR_ORA_FLAGS(""),
        USR_ORA_OPEN_MODE(StartOptions.OPEN.toString()),
        GEN_START_OPTIONS(""),
        USR_ORA_STOP_MODE(StopOptions.IMMEDIATE.toString()),
        USR_ORA_INST_NAME(""),
        GEN_RESTART(""),
        GEN_USR_ORA_INST_NAME(""),
        USER_WORKLOAD("yes"),
        RANK(String.valueOf(0)),
        RELOCATE_ACTION(String.valueOf(0)),
        START_DEPENDENCIES_RTE_INTERNAL(""),
        STOP_DEPENDENCIES_RTE_INTERNAL(""),
        START_DEPENDENCIES_TEMPLATE("<xml>hard(<If cond=\"ASMClientMode\" op=\"neq\" value=\"True\"><Then><If cond=\"ASMmode\" value=\"remote\"><Then><ResList>uniform:global:{dg}</ResList>,</Then><Else><ResList>{dg}</ResList>,</Else></If></Then></If><ResList>{acfs_or_nfs}</ResList><If cond=\"OHResExist\" value=\"True\"><Then>,<Res>{oraclehome}</Res></Then></If>) weak(<If cond=\"DATABASE_TYPE\" op=\"eql\" value=\"RAC|RACOneNode\"><Then>type:ora.listener.type,global:type:ora.scan_listener.type,uniform:ora.ons,global:ora.gns</Then><Else>type:ora.listener.type,uniform:ora.ons</Else></If>) dispersion(<If cond=\"DATABASE_TYPE\" value=\"RACOneNode\"><Then><If cond=\"DB_CENTRIC\" value=\"False\"><Then>type:ora.database.type</Then></If></Then></If>) pullup(<If cond=\"ASMClientMode\" op=\"neq\" value=\"True\"><Then><If cond=\"MANAGEMENT_POLICY\" op=\"neql\" value=\"MANUAL|NORESTART\"><Then><If cond=\"ASMmode\" value=\"remote\"><Then><ResList>global:{dg}</ResList>,</Then><Else><ResList>{dg}</ResList>,</Else></If></Then></If></Then></If><ResList>{acfs_and_nfs}</ResList><If cond=\"OHResExist\" value=\"True\"><Then>,<Res>{oraclehome}</Res></Then></If>)</xml>"),
        STOP_DEPENDENCIES_TEMPLATE("<xml><If cond=\"ASMClientMode\" op=\"neq\" value=\"True\"><Then><If cond=\"DGExist\" value=\"True\"><Then><If cond=\"ASMmode\" value=\"remote\"> <Then>hard(global:intermediate:ora.asm,<ResList>global:shutdown:{dg}</ResList>)</Then> <Else>hard(intermediate:ora.asm,<ResList>shutdown:{dg}</ResList>)</Else> </If></Then> </If>hard(<Res>{acfs_same_as_oh}</Res>,<ResList>intermediate:{acfs}</ResList>)</Then> <Else>hard(intermediate:<Res>{nfs}</Res>)</Else> </If><If cond=\"OHResExist\" value=\"True\"><Then>hard(intermediate: <Res>{oraclehome}</Res>)</Then></If></xml>"),
        ACTIONS(""),
        TARGET_TYPE(""),
        TARGET_NAME(""),
        ACTION_TIMEOUT(String.valueOf(600)),
        ACTION_START_OPTION(""),
        CSS_CRITICAL(CRSResource.CSSCritical.NO.toString()),
        WORKLOAD_CPU(String.valueOf(0)),
        WORKLOAD_MEMORY_TARGET(String.valueOf(0)),
        WORKLOAD_MEMORY_MAX(String.valueOf(0)),
        DEFAULT_NETNUM(""),
        WORKLOAD_CPU_CAP(String.valueOf(0)),
        JAVA_SERVICES(""),
        PATCH_IN_PROGRESS(Boolean.FALSE.toString()),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(Database.class));

        private String m_value;

        private Database(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum MgmtDatabase {
        NAME(ResourceLiterals.MGMTDB_TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type definition for Mgmt Database"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.DATABASE_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        ORACLE_HOME(ResourceLiterals.CRS_HOME_VALUE.toString()),
        ORACLE_HOME_OLD(""),
        SERVER_POOLS(ResourceLiterals.STAR.toString()),
        CLUSTER_DATABASE(Boolean.toString(false).toLowerCase()),
        RESTART_ATTEMPTS(String.valueOf(2)),
        START_TIMEOUT(String.valueOf(600)),
        STOP_TIMEOUT(String.valueOf(600)),
        CARDINALITY(String.valueOf(1)),
        CHECK_TIMEOUT(String.valueOf(30)),
        CHECK_INTERVAL(String.valueOf(1)),
        FAILURE_INTERVAL(String.valueOf(60)),
        FAILURE_THRESHOLD(String.valueOf(1)),
        INSTANCE_FAILOVER(ResourceLiterals.ENABLED_VALUE.toString()),
        USR_ORA_OPI(Boolean.toString(false)),
        SPFILE(""),
        PWFILE(""),
        ROLE(DBRole.PRIMARY.toString()),
        MANAGEMENT_POLICY(ManagementPolicy.AUTOMATIC.toString()),
        PDB_NAME(""),
        PDB_SERVICE_NAME(""),
        DATABASE_TYPE("MGMTDB"),
        DB_UNIQUE_NAME(ResourceLiterals.MGMTDB_UNIQUE_NAME.toString()),
        USR_ORA_DB_NAME(""),
        USR_ORA_DOMAIN(""),
        GEN_AUDIT_FILE_DEST(""),
        USR_ORA_FLAGS(""),
        USR_ORA_OPEN_MODE(StartOptions.OPEN.toString()),
        GEN_START_OPTIONS(""),
        USR_ORA_STOP_MODE(StopOptions.IMMEDIATE.toString()),
        USR_ORA_INST_NAME(ResourceLiterals.MGMTDB_INST_NAME.toString()),
        GEN_RESTART(""),
        GEN_USR_ORA_INST_NAME(""),
        START_DEPENDENCIES(""),
        STOP_DEPENDENCIES(""),
        START_DEPENDENCIES_RTE_INTERNAL(""),
        STOP_DEPENDENCIES_RTE_INTERNAL(""),
        START_DEPENDENCIES_TEMPLATE("<xml>hard(ora.MGMTLSNR)weak(global:type:ora.scan_listener.type,uniform:ora.ons)pullup(ora.MGMTLSNR)</xml>"),
        STOP_DEPENDENCIES_TEMPLATE("<xml>hard(intermediate:ora.MGMTLSNR)</xml>"),
        ACTIONS(""),
        ACTION_TIMEOUT(String.valueOf(600)),
        ACTION_START_OPTION(""),
        CSS_CRITICAL(CRSResource.CSSCritical.NO.toString()),
        WORKLOAD_CPU(String.valueOf(0)),
        WORKLOAD_MEMORY_TARGET(String.valueOf(0)),
        WORKLOAD_MEMORY_MAX(String.valueOf(0)),
        USER_WORKLOAD("no"),
        DEFAULT_NETNUM(""),
        WORKLOAD_CPU_CAP(String.valueOf(0)),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(Database.class));

        private String m_value;

        private MgmtDatabase(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ScanListener {
        NAME("ora." + ResourceLiterals.SCAN_LISTENER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        PLACEMENT("restricted"),
        TYPE_VERSION("2.2"),
        DESCRIPTION("CRS resource type for the Cluster SCAN Listener"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.SCANLSNR_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        CHECK_TIMEOUT(String.valueOf(120)),
        START_TIMEOUT(String.valueOf(180)),
        RESTART_ATTEMPTS(String.valueOf(5)),
        UPTIME_THRESHOLD("1d"),
        PORT(String.valueOf(1521)),
        NETNUM(String.valueOf(1)),
        ENDPOINTS("TCP:" + ResourceLiterals.DEFAULT_LSNR_TCP_PORT.toString()),
        USR_ORA_OPI(Boolean.toString(false)),
        REGISTRATION_INVITED_NODES(""),
        REGISTRATION_INVITED_SUBNETS(""),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(ScanListener.class));

        private String m_value;

        private ScanListener(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum GNS {
        NAME("ora." + ResourceLiterals.GNS.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        PLACEMENT("restricted"),
        TYPE_VERSION("3.3"),
        DESCRIPTION("CRS resource type definition for Grid Naming Service"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        RESTART_ATTEMPTS(String.valueOf(5)),
        UPTIME_THRESHOLD("1d"),
        CHECK_INTERVAL(60),
        CHECK_TIMEOUT(String.valueOf(60)),
        START_TIMEOUT(600),
        STOP_TIMEOUT(600),
        TRACE_LEVEL(0),
        SUBDOMAIN(""),
        ROLE(""),
        UPGRADE_VERSION(""),
        PROPERTIES(""),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(GNS.class));

        private String m_value;

        private GNS(String value) {
            this.m_value = value;
        }

        private GNS(int integerValue) {
            this(String.valueOf(integerValue));
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum HAVIP {
        NAME("ora." + ResourceLiterals.HAVIP.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterVIP.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type definition for  HAVIP"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        USR_ORA_VIP(""),
        GEN_USR_ORA_VIP(""),
        GEN_USR_ORA_STATIC_VIP(""),
        CHECK_TIMEOUT(String.valueOf(60)),
        CHECK_INTERVAL(String.valueOf(30)),
        HOSTING_MEMBERS(""),
        PLACEMENT("restricted"),
        ACTIVE_PLACEMENT(String.valueOf(0)),
        AUTO_START(CRSResource.AutoStart.ALWAYS.toString()),
        RESTART_ATTEMPTS(String.valueOf(0)),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(HAVIP.class)),
        HAVIP_DESCRIPTION(""),
        HAVIP_ID("");

        private String m_value;

        private HAVIP(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum GNSVIP {
        NAME("ora." + ResourceLiterals.GNS_VIP.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterVIP.NAME.toString()),
        TYPE_VERSION("2.2"),
        DESCRIPTION("CRS resource type definition for Clusterware GNS VIP"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        HOSTING_MEMBERS(""),
        USR_ORA_VIP(""),
        PLACEMENT("restricted"),
        START_TIMEOUT(600),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(GNSVIP.class));

        private String m_value;

        private GNSVIP(String value) {
            this.m_value = value;
        }

        private GNSVIP(int integerValue) {
            this(String.valueOf(integerValue));
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ScanVIP {
        NAME("ora." + ResourceLiterals.SCAN_VIP.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterVIP.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type definition for clusteraware SCAN VIP"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        SCAN_NAME(""),
        NETNUM(String.valueOf(1)),
        HOSTING_MEMBERS(""),
        PLACEMENT("restricted"),
        START_DEPENDENCIES_RTE_INTERNAL(""),
        STOP_DEPENDENCIES_RTE_INTERNAL(""),
        START_DEPENDENCIES_TEMPLATE("<xml>hard(<Res>{network}</Res>)weak(global:ora.gns)dispersion:active(type:ora.scan_vip.type)pullup(global:<Res>{network}</Res>)</xml>"),
        STOP_DEPENDENCIES_TEMPLATE("<xml>hard(<Res>intermediate:{network}</Res>)</xml>"),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(ScanVIP.class));

        private String m_value;

        private ScanVIP(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ClusterVIP {
        NAME("ora." + ResourceLiterals.CLUSTER_VIP.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        TYPE_VERSION("2.2"),
        DESCRIPTION("CRS resource type definition for cluster-aware VIP"),
        SERVER_CATEGORY(""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        ACTIVE_PLACEMENT(String.valueOf(1)),
        USR_ORA_VIP(""),
        GEN_USR_ORA_VIP(""),
        GEN_USR_ORA_STATIC_VIP(""),
        CHECK_TIMEOUT(String.valueOf(120)),
        CHECK_INTERVAL(String.valueOf(1)),
        HOSTING_MEMBERS(""),
        NETWORK_COUNT(""),
        PLACEMENT("favored"),
        START_DEPENDENCIES_RTE_INTERNAL(""),
        STOP_DEPENDENCIES_RTE_INTERNAL(""),
        START_DEPENDENCIES_TEMPLATE("<xml>hard(<Res>{network}</Res>) pullup(<Res>{network}</Res>) weak(global:ora.gns)</xml>"),
        STOP_DEPENDENCIES_TEMPLATE("<xml>hard(<Res>intermediate:{network}</Res>)</xml>"),
        START_TIMEOUT(String.valueOf(120)),
        OPC_NAT_ADDRESS(""),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(ClusterVIP.class));

        private String m_value;

        private ClusterVIP(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }

        public static String getVIPNetTypeName(int netNum) {
            return "ora." + ResourceLiterals.CLUSTER_VIP.toString() + '_' + ResourceLiterals.NET.toString() + String.valueOf(netNum) + '.' + ResourceLiterals.TYPE.toString();
        }

        public static String getNetworkNumber(String vipNetType) {
            String network = null;
            if (vipNetType != null) {
                String[] parts;
                String prefix = ResourceLiterals.CLUSTER_VIP.toString() + '_' + ResourceLiterals.NET.toString();
                for (String part : parts = vipNetType.split(Pattern.quote(String.valueOf('.')))) {
                    if (!part.startsWith(prefix)) continue;
                    network = part.substring(prefix.length());
                }
            }
            Trace.out("Network=" + network);
            return network;
        }

        public static List<ResourceAttribute> getVIPNetType(int netNum) {
            List<ResourceAttribute> attrList = ResourceType.getAttributes(ClusterVIP.class);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(NAME.name())) {
                    attr.setValue(ClusterVIP.getVIPNetTypeName(netNum));
                }
                if (!attr.getName().equalsIgnoreCase(BASE_TYPE.name())) continue;
                attr.setValue(NAME.toString());
            }
            return attrList;
        }
    }

    public static enum ProxyASM {
        NAME("ora." + ResourceLiterals.PROXY_ASM.toString() + '.' + ResourceLiterals.TYPE.toString()),
        ALIAS_NAME(""),
        AUTO_START(CRSResource.AutoStart.ALWAYS.toString()),
        BASE_TYPE(LocalASM.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for the ADVM proxy instance"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        PRESENCE(ResourceLiterals.REMOTE.toString()),
        SPFILE(""),
        USR_ORA_INST_NAME(ResourceType.access$000() ? ResourceLiterals.PLUS.toString() + "APX" + ResourceLiterals.PERCENT.toString() + (Object)((Object)ResourceLiterals.CRS_CSS_NODENUMBER) + ResourceLiterals.PERCENT.toString() : ResourceLiterals.PLUS.toString() + "APX");

        private String m_value;

        private ProxyASM(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum IOServer {
        NAME("ora." + ResourceLiterals.IOSERVER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for the IOServer instance"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ASM_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        RESTART_ATTEMPTS(String.valueOf(3)),
        CHECK_TIMEOUT(String.valueOf(30)),
        AUTO_START(CRSResource.AutoStart.RESTORE.toString()),
        START_TIMEOUT(String.valueOf(900)),
        STOP_TIMEOUT(String.valueOf(600)),
        CHECK_INTERVAL(String.valueOf(ResourceType.access$000() ? 60 : 1)),
        USR_ORA_OPEN_MODE(StartOptions.MOUNT.toString()),
        USR_ORA_STOP_MODE(StopOptions.IMMEDIATE.toString()),
        USR_ORA_OPI(Boolean.toString(false)),
        USR_ORA_INST_NAME(ResourceType.access$000() ? ResourceLiterals.PLUS.toString() + "IOS" + ResourceLiterals.PERCENT.toString() + (Object)((Object)ResourceLiterals.CRS_CSS_NODENUMBER) + ResourceLiterals.PERCENT.toString() : ResourceLiterals.PLUS.toString() + "IOS"),
        GEN_RESTART(""),
        GEN_USR_ORA_INST_NAME(""),
        CARDINALITY(String.valueOf(3)),
        PRESENCE(ResourceLiterals.REMOTE.toString()),
        SPFILE(""),
        ACTIONS(ResourceLiterals.IOS_ACTIONS.toString()),
        TARGET_TYPE(""),
        TARGET_NAME("");

        private String m_value;

        private IOServer(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }

        public static String defaultInstNameNode0Exist() {
            String defaultVal = null;
            Trace.out("Setting USR_ORA_INST_NAME attr to CRS_CSS_NODENUMBER_PLUS1");
            defaultVal = ResourceLiterals.PLUS.toString() + "IOS" + ResourceLiterals.PERCENT.toString() + (Object)((Object)ResourceLiterals.CRS_CSS_NODENUMBER_PLUS1) + ResourceLiterals.PERCENT.toString();
            return defaultVal;
        }
    }

    public static enum ClusterASM {
        NAME("ora." + ResourceLiterals.CLUSTER_ASM.toString() + '.' + ResourceLiterals.TYPE.toString()),
        ALIAS_NAME(ResourceType.access$000() ? "ora." + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_CSS_NODENAME.toString() + ResourceLiterals.PERCENT.toString() + '.' + "ASM" + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_CSS_NODENUMBER.toString() + ResourceLiterals.PERCENT.toString() + ".asm" : ""),
        BASE_TYPE(ClusterResource.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for the Cluster ASM instance"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ASM_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        ACTIONS(ResourceLiterals.ASM_ACTIONS.toString()),
        RESTART_ATTEMPTS(String.valueOf(5)),
        CHECK_TIMEOUT(String.valueOf(30)),
        AUTO_START(ResourceType.access$000() ? CRSResource.AutoStart.NEVER.toString() : CRSResource.AutoStart.RESTORE.toString()),
        START_TIMEOUT(String.valueOf(900)),
        STOP_TIMEOUT(String.valueOf(600)),
        CHECK_INTERVAL(String.valueOf(1)),
        USR_ORA_OPEN_MODE(StartOptions.MOUNT.toString()),
        USR_ORA_STOP_MODE(StopOptions.IMMEDIATE.toString()),
        USR_ORA_OPI(Boolean.toString(false)),
        USR_ORA_INST_NAME(ResourceType.access$000() ? ResourceLiterals.PLUS.toString() + "ASM" + ResourceLiterals.PERCENT.toString() + (Object)((Object)ResourceLiterals.CRS_CSS_NODENUMBER) + ResourceLiterals.PERCENT.toString() : ResourceLiterals.PLUS.toString() + "ASM"),
        GEN_RESTART(""),
        GEN_USR_ORA_INST_NAME(""),
        INSTANCE_FAILOVER(ResourceLiterals.ENABLED_VALUE.toString()),
        CARDINALITY(String.valueOf(3)),
        PWFILE(""),
        PWFILE_BACKUP(""),
        PRESENCE(ResourceLiterals.REMOTE.toString()),
        TARGET_TYPE(""),
        TARGET_NAME(""),
        RELOCATE_BY_DEPENDENCY(String.valueOf(0));

        private String m_value;

        private ClusterASM(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum Volume {
        NAME("ora." + ResourceLiterals.VOLUME.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for ASM Volume Device"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        VOLUME_DEVICE(""),
        CANONICAL_VOLUME_DEVICE(""),
        USR_ORA_OPI(""),
        DEVICE_DETAILS(""),
        OFFLINE_CHECK_INTERVAL(String.valueOf(30)),
        START_TIMEOUT(String.valueOf(60)),
        STOP_TIMEOUT(String.valueOf(30)),
        START_DEPENDENCIES_RTE_INTERNAL(""),
        STOP_DEPENDENCIES_RTE_INTERNAL(""),
        START_DEPENDENCIES_TEMPLATE("<xml><If cond=\"ASMmode\" value=\"flex\"> <Then>hard(<Res>uniform:global:{dg}</Res>, <Res>{proxyASM}</Res>)pullup(<Res>global:{dg}</Res>, <Res>{proxyASM}</Res>)</Then> <Else>hard(<Res>{dg}</Res>)pullup(<Res>{dg}</Res>)</Else> </If></xml>"),
        STOP_DEPENDENCIES_TEMPLATE("<xml><If cond=\"ASMmode\" value=\"flex\"> <Then>hard(<Res>global:intermediate:{dg}</Res>, <Res>{proxyASM}</Res>)</Then> <Else>hard(<Res>intermediate:{dg}</Res>)</Else> </If></xml>"),
        GH_CREATED(String.valueOf(0));

        private String m_value;

        private Volume(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum FS {
        NAME("ora." + ResourceLiterals.FS.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(BaseFileSystem.NAME.toString()),
        TYPE_VERSION("1.1"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        FS_TYPE("");

        private String m_value;

        private FS(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum DBAASFSCluster {
        NAME("ora." + ResourceLiterals.DBAASFS_CLUSTER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ACFSCluster.NAME.toString());

        private String m_value;

        private DBAASFSCluster(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ACFSCluster {
        NAME("ora." + ResourceLiterals.ACFS_CLUSTER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(BaseFileSystem.NAME.toString()),
        TYPE_VERSION("1.2"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        FS_TYPE("ACFS");

        private String m_value;

        private ACFSCluster(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum BaseFileSystem {
        NAME("ora." + ResourceLiterals.BASEFS.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for Oracle File System Cluster Resource"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        HOSTING_MEMBERS(""),
        SERVER_POOLS(ResourceLiterals.STAR.toString()),
        APPLICATION_ID(""),
        MOUNTPOINT_PATH(""),
        VOLUME_DEVICE(""),
        CANONICAL_VOLUME_DEVICE(""),
        INTERNAL_MOUNTPOINT_PATH(""),
        CHECK_INTERVAL(String.valueOf(15)),
        OFFLINE_CHECK_INTERVAL(String.valueOf(30)),
        START_TIMEOUT(String.valueOf(500)),
        STOP_TIMEOUT(String.valueOf(120)),
        CHECK_TIMEOUT(String.valueOf(120)),
        CARDINALITY(String.valueOf(1)),
        FS_TYPE(""),
        FS_OPTIONS(""),
        FS_DESCRIPTION(""),
        AUX_VOLUMES(""),
        GH_CREATED(String.valueOf(0));

        private String m_value;

        private BaseFileSystem(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ClusterResource {
        NAME("ora." + ResourceLiterals.CLUSTER_RESOURCE.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ResourceLiterals.CLUSTER_RESOURCE.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for Oracle Cluster Resource"),
        SERVER_POOLS(ResourceLiterals.STAR.toString()),
        CARDINALITY(String.valueOf(1)),
        START_CONCURRENCY(String.valueOf(0)),
        STOP_CONCURRENCY(String.valueOf(0)),
        ACTIVE_PLACEMENT(String.valueOf(0)),
        RESTART_ATTEMPTS(String.valueOf(0)),
        PLACEMENT("restricted"),
        AUTO_START(CRSResource.AutoStart.RESTORE.toString()),
        VERSION(""),
        NLS_LANG(""),
        USR_ORA_ENV("");

        private String m_value;

        private ClusterResource(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ADMINHELPER {
        NAME("ora." + ResourceLiterals.ADMINHELPER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type definition for Admin Helper resource"),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        KEYWORD(""),
        NARGS(""),
        ARG1(""),
        ARG2(""),
        ARG3(""),
        ARG4(""),
        ARG5(""),
        ARG6(""),
        ARG7(""),
        ARG8(""),
        ARG9(""),
        ARG10(""),
        UNAME(""),
        ACTIONS(ResourceLiterals.ADMINHELPER_ACTIONS.toString() + "," + (Object)((Object)ACL.USER) + ':' + ResourceLiterals.ROOT.toString()),
        CHECK_TIMEOUT(String.valueOf(30)),
        START_TIMEOUT(String.valueOf(900)),
        STOP_TIMEOUT(String.valueOf(180)),
        CHECK_INTERVAL(String.valueOf(300)),
        ACTION_TIMEOUT(String.valueOf(36000)),
        USR_ORA_OPI(Boolean.toString(false)),
        AUTO_START(CRSResource.AutoStart.ALWAYS.toString());

        private String m_value;

        private ADMINHELPER(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum MountFS {
        NAME("ora." + ResourceLiterals.MOUNTFS.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString()),
        DESCRIPTION("CRS resource type for Network File System"),
        SERVER_CATEGORY(""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        MOUNTPOINT_PATH(""),
        EXPORT_PATH(""),
        EXPORT_SERVER(""),
        INTERNAL_MOUNTPOINT_PATH(""),
        CHECK_INTERVAL(String.valueOf(5)),
        OFFLINE_CHECK_INTERVAL(String.valueOf(5)),
        START_TIMEOUT(String.valueOf(500)),
        STOP_TIMEOUT(String.valueOf(120)),
        CHECK_TIMEOUT(String.valueOf(120)),
        MOUNT_TYPE("NFS"),
        FS_OPTIONS(""),
        FS_DESCRIPTION(""),
        GH_CREATED(String.valueOf(0));

        private String m_value;

        private MountFS(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum NetStorageService {
        NAME("ora." + ResourceLiterals.NETSTORAGESRV.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        DESCRIPTION("CRS resource type for Network Storage Service"),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        NSS_TYPE(""),
        STABLE_STORAGE(""),
        CHECK_INTERVAL(String.valueOf(60)),
        OFFLINE_CHECK_INTERVAL(String.valueOf(90)),
        START_TIMEOUT(String.valueOf(120)),
        STOP_TIMEOUT(String.valueOf(300)),
        CHECK_TIMEOUT(String.valueOf(60));

        private String m_value;

        private NetStorageService(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ExportFS {
        NAME("ora." + ResourceLiterals.EXPORTFS.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for Export FS"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        EXPORT_PATH(""),
        EXPORT_CLIENTS(""),
        EXPORT_OPTIONS(""),
        EXPORT_TYPE("NFS"),
        EXPORT_ALIAS(""),
        STOP_TIMEOUT(String.valueOf(120)),
        OFFLINE_CHECK_INTERVAL(String.valueOf(60)),
        START_TIMEOUT(String.valueOf(500)),
        FAILOVER_THRESHOLD(String.valueOf(1)),
        FAILOVER_INTERVAL(String.valueOf(1)),
        CHECK_TIMEOUT(String.valueOf(60)),
        CHECK_INTERVAL(String.valueOf(30)),
        AUTO_START(CRSResource.AutoStart.NEVER.toString()),
        GH_CREATED(String.valueOf(0));

        private String m_value;

        private ExportFS(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }

        public static String getExportTypeName(String id) {
            return "ora." + id.toLowerCase() + '.' + ResourceLiterals.EXPORTFS.toString() + '.' + ResourceLiterals.TYPE.toString();
        }

        public static List<ResourceAttribute> getExportType(String id) {
            List<ResourceAttribute> attrList = ResourceType.getAttributes(ExportFS.class);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(NAME.name())) {
                    attr.setValue(ExportFS.getExportTypeName(id));
                }
                if (!attr.getName().equalsIgnoreCase(BASE_TYPE.name())) continue;
                attr.setValue(NAME.toString());
            }
            return attrList;
        }
    }

    public static enum DBAASFSLocal {
        NAME("ora." + ResourceLiterals.DBAASFS_LOCAL.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(AsmClusterFileSystem.NAME.toString());

        private String m_value;

        private DBAASFSLocal(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum AsmClusterFileSystem {
        NAME("ora." + ResourceLiterals.ACFS.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString()),
        TYPE_VERSION("3.3"),
        DESCRIPTION("CRS resource type for ASM Cluster File Systems"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        IGNORE_TARGET_ON_FAILURE(ResourceLiterals.YES.toString()),
        TARGET_DEFAULT(ResourceLiterals.TARGET_DEFAULT_ATLEASTONE.toString()),
        MOUNTPOINT_PATH(""),
        VOLUME_DEVICE(""),
        INTERNAL_MOUNTPOINT_PATH(""),
        CANONICAL_VOLUME_DEVICE(""),
        CHECK_INTERVAL(String.valueOf(15)),
        OFFLINE_CHECK_INTERVAL(String.valueOf(30)),
        START_TIMEOUT(String.valueOf(500)),
        STOP_TIMEOUT(String.valueOf(120)),
        CHECK_TIMEOUT(String.valueOf(120)),
        FS_TYPE("ACFS"),
        FS_OPTIONS(""),
        FS_DESCRIPTION(""),
        AUX_VOLUMES(""),
        ACFS_INTERNAL_USE(""),
        GH_CREATED(String.valueOf(0));

        private String m_value;

        private AsmClusterFileSystem(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum DiskGroup {
        NAME(ResourceLiterals.DISKGROUP_TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString()),
        TYPE_VERSION("1.2"),
        DESCRIPTION("CRS resource type definition for ASM disk group resource"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.DISKGROUP_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        CHECK_TIMEOUT(String.valueOf(30)),
        START_TIMEOUT(String.valueOf(900)),
        STOP_TIMEOUT(String.valueOf(180)),
        CHECK_INTERVAL(String.valueOf(300)),
        USR_ORA_OPI(Boolean.toString(false)),
        USR_ORA_STOP_MODE(""),
        AUTO_START(CRSResource.AutoStart.NEVER.toString());

        private String m_value;

        private DiskGroup(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }

        public static List<ResourceAttribute> setDepOnASM(List<ResourceAttribute> dgAttrList) throws CRSException {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute asmAttr = crsFactory.create(LocalASM.NAME.name(), ResourceLiterals.ASM_RES_NAME.toString());
            ResourceDependency hardDep = crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            ResourceDependency pullupDep = crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
            dgAttrList.add(crsFactory.create(LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(hardDep, pullupDep)));
            hardDep = crsFactory.createResourceDependency(asmAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            dgAttrList.add(crsFactory.create(LocalResource.STOP_DEPENDENCIES.name(), hardDep.toString()));
            return dgAttrList;
        }
    }

    public static enum LocalASM {
        NAME("ora." + ResourceLiterals.LOCAL_ASM.toString() + '.' + ResourceLiterals.TYPE.toString()),
        ALIAS_NAME(ResourceType.access$000() ? "ora." + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_CSS_NODENAME.toString() + ResourceLiterals.PERCENT.toString() + '.' + "ASM" + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_CSS_NODENUMBER.toString() + ResourceLiterals.PERCENT.toString() + ".asm" : ""),
        BASE_TYPE(LocalResource.NAME.toString()),
        TYPE_VERSION("1.2"),
        DESCRIPTION("CRS resource type for the ASM instance"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ASM_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        RESTART_ATTEMPTS(String.valueOf(5)),
        CHECK_TIMEOUT(String.valueOf(30)),
        AUTO_START(ResourceType.access$000() ? CRSResource.AutoStart.NEVER.toString() : CRSResource.AutoStart.RESTORE.toString()),
        START_TIMEOUT(String.valueOf(900)),
        STOP_TIMEOUT(String.valueOf(600)),
        CHECK_INTERVAL(String.valueOf(ResourceType.access$000() ? 60 : 1)),
        USR_ORA_OPEN_MODE(StartOptions.MOUNT.toString()),
        USR_ORA_STOP_MODE(StopOptions.IMMEDIATE.toString()),
        USR_ORA_OPI(Boolean.toString(false)),
        USR_ORA_INST_NAME(ResourceType.access$000() ? ResourceLiterals.PLUS.toString() + "ASM" + ResourceLiterals.PERCENT.toString() + (Object)((Object)ResourceLiterals.CRS_CSS_NODENUMBER) + ResourceLiterals.PERCENT.toString() : ResourceLiterals.PLUS.toString() + "ASM"),
        GEN_RESTART(""),
        GEN_USR_ORA_INST_NAME(""),
        PRESENCE(ResourceLiterals.LEGACY.toString()),
        PWFILE(""),
        PWFILE_BACKUP(""),
        REGISTERED_TYPE("srvctl"),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(LocalASM.class));

        private String m_value;

        private LocalASM(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }

        public static List<ResourceAttribute> addAttrForSHAsm(List<ResourceAttribute> attrList) {
            Trace.out("Add SPFILE and ASM_DISKSTRING for SIHA ASM");
            attrList.add(new ResourceAttribute(Database.SPFILE.name(), Database.SPFILE.toString()));
            attrList.add(new ResourceAttribute(ResourceLiterals.ASM_DISKSTRING.name(), ResourceLiterals.S_UNSPECIFIED_DISKSTRING.toString()));
            return attrList;
        }

        public static String defaultValNode0Exist(String attrName) {
            String defaultVal = null;
            Trace.out("Modifying attribute values to include PLUS1");
            if (attrName.equalsIgnoreCase(ALIAS_NAME.name())) {
                Trace.out("Setting ALIAS_NAME attr to CRS_CSS_NODENUMBER_PLUS1");
                defaultVal = "ora." + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_CSS_NODENAME.toString() + ResourceLiterals.PERCENT.toString() + '.' + "ASM" + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_CSS_NODENUMBER_PLUS1.toString() + ResourceLiterals.PERCENT.toString() + ".asm";
            } else if (attrName.equalsIgnoreCase(USR_ORA_INST_NAME.name())) {
                Trace.out("Setting USR_ORA_INST_NAME attr to CRS_CSS_NODENUMBER_PLUS1");
                defaultVal = ResourceLiterals.PLUS.toString() + "ASM" + ResourceLiterals.PERCENT.toString() + (Object)((Object)ResourceLiterals.CRS_CSS_NODENUMBER_PLUS1) + ResourceLiterals.PERCENT.toString();
            }
            return defaultVal;
        }

        public static List<ResourceAttribute> modifyAttrForAsmWithNode0(List<ResourceAttribute> attrList) {
            Trace.out("Modifying attribute values to include PLUS1");
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ALIAS_NAME.name())) {
                    Trace.out("Setting ALIAS_NAME attr to CRS_CSS_NODENUMBER_PLUS1");
                    attr.setValue(LocalASM.defaultValNode0Exist(ALIAS_NAME.name()));
                }
                if (!attr.getName().equalsIgnoreCase(USR_ORA_INST_NAME.name())) continue;
                Trace.out("Setting USR_ORA_INST_NAME attr to CRS_CSS_NODENUMBER_PLUS1");
                attr.setValue(LocalASM.defaultValNode0Exist(USR_ORA_INST_NAME.name()));
            }
            return attrList;
        }
    }

    public static enum RIMListener {
        NAME("ora." + ResourceLiterals.RIM_LISTENER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(Listener.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for the LEAF Listener"),
        SERVER_CATEGORY(ResourceLiterals.RIM_CATEGORY.toString()),
        ENDPOINTS("TCP:" + ResourceLiterals.DEFAULT_LSNR_TCP_PORT.toString()),
        AUTO_START(CRSResource.AutoStart.NEVER.toString()),
        SUBNET("");

        private String m_value;

        private RIMListener(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ASMListener {
        NAME("ora." + ResourceLiterals.ASM_LISTENER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(Listener.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for the ASM Listener"),
        CHECK_INTERVAL(String.valueOf(3)),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        IGNORE_TARGET_ON_FAILURE(ResourceLiterals.YES.toString()),
        SUBNET("");

        private String m_value;

        private ASMListener(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum Listener {
        NAME("ora." + ResourceLiterals.LISTENER.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString()),
        TYPE_VERSION("1.2"),
        DESCRIPTION("CRS resource type for the Listener"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.LSNR_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        ACTION_SCRIPT(ResourceType.access$000() ? ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + "racgwrap" + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_SCRIPT_SUFFIX.toString() + ResourceLiterals.PERCENT.toString() : ""),
        ORACLE_HOME(ResourceLiterals.CRS_HOME_VALUE.toString()),
        START_TIMEOUT(String.valueOf(180)),
        CHECK_TIMEOUT(String.valueOf(120)),
        PORT(ResourceLiterals.DEFAULT_LSNR_TCP_PORT.toString()),
        ENDPOINTS("TCP:" + ResourceLiterals.DEFAULT_LSNR_TCP_PORT.toString()),
        USR_ORA_OPI(Boolean.toString(false)),
        LOCAL_REGISTRATION_ADDRESS(""),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(Listener.class));

        private String m_value;

        private Listener(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum MgmtListener {
        NAME(ResourceLiterals.MGMTLSNR_TYPE.toString()),
        BASE_TYPE(ClusterResource.NAME.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for the MgmtListener"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        PLACEMENT("restricted"),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.LSNR_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        ACTION_SCRIPT(ResourceType.access$000() ? ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_SCRIPT_SUFFIX.toString() + ResourceLiterals.PERCENT.toString() : ""),
        ORACLE_HOME(ResourceLiterals.CRS_HOME_VALUE.toString()),
        START_TIMEOUT(String.valueOf(180)),
        CHECK_TIMEOUT(String.valueOf(120)),
        PORT(ResourceLiterals.DEFAULT_MGMTLSNR_TCP_PORT.toString()),
        ENDPOINTS("TCP:" + ResourceLiterals.DEFAULT_MGMTLSNR_TCP_PORT.toString()),
        CARDINALITY(String.valueOf(1)),
        USR_ORA_ENV(""),
        USR_ORA_OPI(Boolean.toString(false)),
        START_DEPENDENCIES_RTE_INTERNAL(""),
        STOP_DEPENDENCIES_RTE_INTERNAL(""),
        START_DEPENDENCIES_TEMPLATE("<xml>hard(<ResType>{cluster_vip_net}</ResType>)pullup(<ResType>{cluster_vip_net}</ResType>)</xml>"),
        STOP_DEPENDENCIES_TEMPLATE("<xml>hard(<ResType>intermediate:{cluster_vip_net}</ResType>)</xml>"),
        DEFAULT_TEMPLATE(ResourceType.getEvtTemplate(Listener.class));

        private String m_value;

        private MgmtListener(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ONS {
        NAME("ora." + ResourceLiterals.ONS.toString() + '.' + ResourceLiterals.TYPE.toString()),
        ALIAS_NAME(ResourceType.access$000() ? "ora." + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_CSS_NODENAME.toString() + ResourceLiterals.PERCENT.toString() + ".ons" : ""),
        BASE_TYPE(LocalResource.NAME.toString()),
        TYPE_VERSION("2.1"),
        DESCRIPTION("CRS resource type for the ONS"),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ONS_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        RESTART_ATTEMPTS(String.valueOf(3)),
        AUTO_START(CRSResource.AutoStart.ALWAYS.toString()),
        LOCAL_PORT(ResourceLiterals.ONS_LOCAL_PORT.toString()),
        REMOTE_PORT(ResourceLiterals.ONS_REMOTE_PORT.toString()),
        REMOTE_HOSTS(ResourceLiterals.ONS_REMOTE_HOSTS.toString()),
        EM_PORT(ResourceLiterals.ONS_EM_PORT.toString()),
        USE_EVM(Boolean.toString(true)),
        LOG_FILE(ResourceLiterals.ONS_LOG_FILE.toString()),
        LOG_COMP(ResourceLiterals.ONS_LOG_COMP.toString()),
        DEBUG_FILE(ResourceLiterals.ONS_DEBUG_FILE.toString()),
        DEBUG_COMP(ResourceLiterals.ONS_DEBUG_COMP.toString()),
        USE_SSL(ResourceLiterals.ONS_SSL_DISABLED_VALUE.toString()),
        MEMBER_ID(String.valueOf(0)),
        GEN_ORACLE_CONFIG_HOME(""),
        ALLOW_UNSECURE_SUBSCRIBER(Boolean.toString(true));

        private String m_value;

        private ONS(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum Network {
        NAME("ora." + ResourceLiterals.NETWORK.toString() + '.' + ResourceLiterals.TYPE.toString()),
        BASE_TYPE(LocalResource.NAME.toString()),
        TYPE_VERSION("3.3"),
        DESCRIPTION("CRS resource type for the local network resource type."),
        SERVER_CATEGORY(ResourceType.access$000() ? ResourceLiterals.HUB_CATEGORY.toString() : ""),
        AGENT_FILENAME(ResourceLiterals.CRS_HOME_VALUE.toString() + ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.ORAROOT_AGENT.toString() + ResourceLiterals.PERCENT.toString() + ResourceLiterals.CRS_EXE_SUFFIX.toString() + ResourceLiterals.PERCENT.toString()),
        USR_ORA_IF(""),
        USR_ORA_NETMASK(""),
        USR_ORA_SUBNET(""),
        ADDRESS_TYPE(IPAddressUtil.IPAddrType.IPv4.toString()),
        USR_ORA_AUTO(DHCPServerType.NONE.toString()),
        PING_TARGET(""),
        CHECK_INTERVAL(String.valueOf(1)),
        OFFLINE_CHECK_INTERVAL(String.valueOf(60));

        private String m_value;

        private Network(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum LocalResource {
        NAME("ora." + ResourceLiterals.LOCAL_RESOURCE.toString() + '.' + ResourceLiterals.TYPE.toString()),
        ALIAS_NAME(""),
        BASE_TYPE(ResourceLiterals.LOCAL_RESOURCE.toString()),
        TYPE_VERSION("1.1"),
        DESCRIPTION("CRS resource type for the Oracle Local Resource"),
        RESTART_ATTEMPTS(String.valueOf(5)),
        UPTIME_THRESHOLD("1d"),
        AUTO_START(CRSResource.AutoStart.RESTORE.toString()),
        ENABLED(ResourceLiterals.ENABLED_VALUE.toString()),
        VERSION(""),
        NLS_LANG(""),
        USR_ORA_ENV(""),
        START_DEPENDENCIES(""),
        STOP_DEPENDENCIES(""),
        START_DEPENDENCIES_RTE_INTERNAL(""),
        STOP_DEPENDENCIES_RTE_INTERNAL("");

        private String m_value;

        private LocalResource(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ACL_PERM {
        READ("r"),
        WRITE("w"),
        EXECUTE("x");

        private String m_value;

        private ACL_PERM(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum ACL_CREATOR {
        ROOT,
        CRS_USER,
        DB_USER;

    }

    public static enum ACL {
        OWNER("owner"),
        PGROUP("pgrp"),
        OTHER("other"),
        USER("user"),
        GROUP("group");

        private String m_value;

        private ACL(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }
}

