/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.trace.Trace;

public class ResourcePermissionsImpl
implements ResourcePermissions {
    boolean m_isPerm4ActionOp = false;
    private AclItem m_owner = new AclItem(ResourceType.ACL.OWNER);
    private AclItem m_pgrp = new AclItem(ResourceType.ACL.PGROUP);
    private AclItem m_others = new AclItem(ResourceType.ACL.OTHER);
    private List<AclItem> m_users = new ArrayList<AclItem>();
    private List<AclItem> m_groups = new ArrayList<AclItem>();
    String m_resName;
    private NativeSystem m_nativeSystem = new SystemFactory().CreateSystem();

    ResourcePermissionsImpl() {
    }

    ResourcePermissionsImpl(String resName, String aclValue) throws CRSException {
        this.m_resName = resName;
        this.permissionsHelper(aclValue);
    }

    ResourcePermissionsImpl(CRSResourceImpl res) throws CRSException {
        this.m_resName = res.getName();
        ResourceAttribute ra = res.getAttribute(ResourceLiterals.ACL_ATTR.toString());
        this.permissionsHelper(ra.getValue());
    }

    private void permissionsHelper(String aclValue) throws CRSException {
        String[] tokens = aclValue.trim().split(String.valueOf(","));
        if (tokens.length < 3) {
            throw new CRSException((MessageKey)PrCrMsgID.RES_GETPERM_FAILED, this.m_resName, aclValue);
        }
        for (String s : tokens) {
            AclItem item = new AclItem(s);
            if (item.m_title.equals(ResourceType.ACL.OWNER.toString())) {
                this.m_owner = item;
                continue;
            }
            if (item.m_title.equals(ResourceType.ACL.PGROUP.toString())) {
                this.m_pgrp = item;
                continue;
            }
            if (item.m_title.equals(ResourceType.ACL.OTHER.toString())) {
                item.m_name = "";
                this.m_others = item;
                continue;
            }
            if (item.m_title.equals(ResourceType.ACL.USER.toString())) {
                this.m_users.add(item);
                continue;
            }
            if (item.m_title.equals(ResourceType.ACL.GROUP.toString())) {
                this.m_groups.add(item);
                continue;
            }
            throw new CRSException((MessageKey)PrCrMsgID.RES_GETPERM_FAILED, this.m_resName, s + item.m_title);
        }
    }

    ResourcePermissionsImpl(ResourceType.ACL_CREATOR creator) throws CRSException, ClusterException, NodeException, UtilException {
        this(creator, false);
    }

    ResourcePermissionsImpl(ResourceType.ACL_CREATOR creator, boolean oinstallGroup) throws CRSException, ClusterException, NodeException, UtilException {
        String ownerGroup;
        String ownerName;
        NodeApps nodeApps = null;
        String userName = null;
        String groupName = null;
        Util utl = new Util();
        Boolean haPriv = utl.hasHAPrivilege();
        String curUserName = utl.getCurrentUser();
        String curUserPGroup = "";
        boolean isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
        String crsHome = utl.getCRSHome();
        String pgroup = "";
        if (isUnixSystem) {
            curUserName = utl.getCurrentUser();
            curUserPGroup = utl.getCurrentUserPrimaryGroup();
            pgroup = utl.getPrimaryGroup(utl.getCRSUser());
            if (Cluster.isCluster()) {
                nodeApps = new NodeApps(Cluster.getLocalNode());
                userName = nodeApps.getUserName();
                groupName = nodeApps.getGroupName();
            } else {
                userName = utl.getOracleUser(crsHome, null);
                groupName = utl.getOracleGroup(crsHome);
            }
        } else {
            try {
                curUserName = userName = utl.getOracleUser(utl.getCRSHome(), null);
            }
            catch (UtilException e) {
                throw new CRSException(e);
            }
            groupName = curUserPGroup;
        }
        this.setPerm(ResourceType.ACL.OTHER, "", ResourceType.ACL_PERM.READ);
        switch (creator) {
            case ROOT: {
                if (!haPriv.booleanValue()) {
                    throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_PERMISSIONS_FAILURE, new Object[0]);
                }
                ownerName = curUserName;
                if (isUnixSystem && oinstallGroup) {
                    ownerGroup = pgroup;
                    break;
                }
                ownerGroup = curUserPGroup;
                break;
            }
            case CRS_USER: {
                if (!haPriv.booleanValue() && !curUserName.equalsIgnoreCase(userName)) {
                    throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_PERMISSIONS_FAILURE, new Object[0]);
                }
                ownerName = userName;
                ownerGroup = groupName;
                break;
            }
            case DB_USER: {
                ownerName = curUserName;
                ownerGroup = curUserPGroup;
                break;
            }
            default: {
                throw new IllegalArgumentException(creator.toString());
            }
        }
        Trace.out("Current user = " + curUserName);
        Trace.out("Current group = " + curUserPGroup);
        Trace.out("CRS owner user = " + ownerName);
        Trace.out("CRS primary group = " + ownerGroup);
        this.setPerm(ResourceType.ACL.OWNER, ownerName, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
        if (isUnixSystem && oinstallGroup) {
            this.setPerm(ResourceType.ACL.PGROUP, ownerGroup, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
        } else if (ResourceType.ACL_CREATOR.DB_USER == creator) {
            this.setPerm(ResourceType.ACL.PGROUP, ownerGroup, ResourceType.ACL_PERM.READ);
        } else {
            this.setPerm(ResourceType.ACL.PGROUP, ownerGroup, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
        }
        if (ResourceType.ACL_CREATOR.ROOT == creator && isUnixSystem) {
            this.setPerm(ResourceType.ACL.USER, userName, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
            this.setPerm(ResourceType.ACL.GROUP, groupName, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
        }
    }

    ResourcePermissionsImpl(List<String> users, List<String> groups) throws InvalidArgsException, CRSException {
        if (users == null || groups == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "Constr4ActionOp-1");
        }
        this.m_isPerm4ActionOp = true;
        this.m_owner = null;
        this.m_pgrp = null;
        this.m_others = null;
        for (String user : users) {
            if (user == null || user.trim().isEmpty()) continue;
            Trace.out((Object)"Adding user %s ...", user);
            this.setPerm(ResourceType.ACL.USER, user, new ResourceType.ACL_PERM[0]);
        }
        for (String group : groups) {
            if (group == null || group.trim().isEmpty()) continue;
            Trace.out((Object)"Adding group %s ...", group);
            this.setPerm(ResourceType.ACL.GROUP, group, new ResourceType.ACL_PERM[0]);
        }
    }

    @Override
    public String getOwner() {
        if (this.m_isPerm4ActionOp) {
            return null;
        }
        String owner = this.m_owner.m_name;
        if (!Cluster.isCluster() && this.m_users.size() > 0) {
            AclItem item = this.m_users.get(0);
            owner = item.m_name;
            Trace.out("owner = " + owner);
        }
        return owner;
    }

    @Override
    public String getGroup() {
        if (this.m_isPerm4ActionOp) {
            return null;
        }
        return this.m_pgrp.m_name;
    }

    @Override
    public List<String> getUsers() throws CRSException {
        ArrayList<String> users = new ArrayList<String>(this.m_users.size());
        for (AclItem item : this.m_users) {
            Trace.out("user name = " + item.m_name);
            users.add(item.m_name);
        }
        return users;
    }

    public List<String> getGroups() throws CRSException {
        ArrayList<String> groups = new ArrayList<String>(this.m_groups.size());
        for (AclItem item : this.m_groups) {
            Trace.out("group name = " + item.m_name);
            groups.add(item.m_name);
        }
        return groups;
    }

    @Override
    public String getOwnerPermissions() {
        if (this.m_isPerm4ActionOp) {
            return null;
        }
        return this.m_owner.m_perm;
    }

    @Override
    public String getGroupPermissions() {
        if (this.m_isPerm4ActionOp) {
            return null;
        }
        return this.m_pgrp.m_perm;
    }

    @Override
    public String getOtherPermissions() {
        if (this.m_isPerm4ActionOp) {
            return null;
        }
        return this.m_others.m_perm;
    }

    @Override
    public void setOwner(String owner) throws CRSException {
        if (this.m_isPerm4ActionOp) {
            throw new CRSException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ResPerm-setPerm-1");
        }
        if (owner == null || owner.trim().length() == 0) {
            throw new CRSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "owner", owner);
        }
        this.setPerm(ResourceType.ACL.OWNER, owner, new ResourceType.ACL_PERM[0]);
    }

    public void setPerm(ResourceType.ACL type, String name, ResourceType.ACL_PERM ... acl_perms) {
        Trace.out("type = " + type.toString() + ", name = " + name);
        if (!this.m_isPerm4ActionOp && acl_perms.length == 0 && ResourceType.ACL.PGROUP != type && ResourceType.ACL.OTHER != type) {
            block0 : switch (type) {
                case USER: {
                    for (AclItem it : this.m_users) {
                        if (!it.m_name.equals(name)) continue;
                        this.m_users.remove(it);
                        break block0;
                    }
                    break;
                }
                case GROUP: {
                    for (AclItem it : this.m_groups) {
                        if (!it.m_name.equals(name)) continue;
                        this.m_groups.remove(it);
                        break block0;
                    }
                    break;
                }
                case OWNER: {
                    this.m_owner.m_name = name;
                    break;
                }
            }
            return;
        }
        AclItem item = null;
        block5 : switch (type) {
            case OWNER: {
                item = this.m_owner;
                item.m_name = name;
                break;
            }
            case PGROUP: {
                item = this.m_pgrp;
                item.m_name = name;
                break;
            }
            case OTHER: {
                item = this.m_others;
                break;
            }
            case USER: {
                for (AclItem it : this.m_users) {
                    if (!it.m_name.equals(name)) continue;
                    item = it;
                    break block5;
                }
                item = new AclItem(type.toString(), name);
                this.m_users.add(item);
                break;
            }
            case GROUP: {
                for (AclItem it : this.m_groups) {
                    if (!it.m_name.equals(name)) continue;
                    item = it;
                    break block5;
                }
                item = new AclItem(type.toString(), name);
                this.m_groups.add(item);
                break;
            }
            default: {
                return;
            }
        }
        String rp = "-";
        String wp = "-";
        String xp = "-";
        block21: for (ResourceType.ACL_PERM p : acl_perms) {
            switch (p) {
                case READ: {
                    rp = ResourceType.ACL_PERM.READ.toString();
                    continue block21;
                }
                case WRITE: {
                    wp = ResourceType.ACL_PERM.WRITE.toString();
                    continue block21;
                }
                case EXECUTE: {
                    xp = ResourceType.ACL_PERM.EXECUTE.toString();
                    continue block21;
                }
            }
        }
        item.m_perm = this.m_isPerm4ActionOp ? null : rp + wp + xp;
    }

    public void ntGrantOraInstallPermissions() throws CRSException {
        if (this.m_isPerm4ActionOp) {
            throw new CRSException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ResPerm-ntGrantOraInstallPermissions-1");
        }
        if (this.m_nativeSystem.isUnixSystem()) {
            return;
        }
        Trace.out("granting ORA_INSTALL group execute permission");
        this.setPerm(ResourceType.ACL.GROUP, "ORA_INSTALL", ResourceType.ACL_PERM.EXECUTE, ResourceType.ACL_PERM.READ);
    }

    public void ntGrantHomeUserPermissions(String oracleHome, Version version, boolean isGrantWritePermission) throws CRSException {
        if (this.m_isPerm4ActionOp) {
            throw new CRSException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ResPerm-ntGrantHomeUserPermissions-1");
        }
        if (this.m_nativeSystem.isUnixSystem()) {
            return;
        }
        Trace.out("windows NT checking if permissions need to be added");
        try {
            WinSecurityFactory wsecFac = WinSecurityFactory.getInstance();
            Home home = wsecFac.getHome(oracleHome, version);
            Credentials creds = home.getServiceUserForHome();
            if (home.isServiceUserVirtualAccount()) {
                this.ntGrantVirtualAccountPermissions(creds, isGrantWritePermission);
                return;
            }
            User user = wsecFac.getUser(creds, version);
            if (user.isBuiltinAccount()) {
                Trace.out("user is builtin user so no ACL adjustment required");
                return;
            }
            Trace.out("resource permissions need to be adjusted");
            if (isGrantWritePermission) {
                this.setPerm(ResourceType.ACL.USER, creds.getUsername(), ResourceType.ACL_PERM.EXECUTE, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE);
            } else {
                this.setPerm(ResourceType.ACL.USER, creds.getUsername(), ResourceType.ACL_PERM.EXECUTE, ResourceType.ACL_PERM.READ);
            }
        }
        catch (WindowsSecurityException e) {
            throw new CRSException(e);
        }
    }

    private void ntGrantVirtualAccountPermissions(Credentials creds, boolean isGrantWritePermission) {
        Trace.out("resource permissions need to be adjusted for virtual account user");
        if (isGrantWritePermission) {
            this.setPerm(ResourceType.ACL.GROUP, creds.getUsername(), ResourceType.ACL_PERM.EXECUTE, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE);
        } else {
            this.setPerm(ResourceType.ACL.GROUP, creds.getUsername(), ResourceType.ACL_PERM.EXECUTE, ResourceType.ACL_PERM.READ);
        }
    }

    public void ntRemoveVirtualUserPermissions(String virtualUserName) {
        this.setPerm(ResourceType.ACL.GROUP, virtualUserName, new ResourceType.ACL_PERM[0]);
        this.setPerm(ResourceType.ACL.OWNER, virtualUserName, new ResourceType.ACL_PERM[0]);
        this.setPerm(ResourceType.ACL.USER, virtualUserName, new ResourceType.ACL_PERM[0]);
    }

    public void ntgrantOraGridLsnrPermissions() throws CRSException {
        if (this.m_isPerm4ActionOp) {
            throw new CRSException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ResPerm-ntgrantOraGridLsnrPermissions-1");
        }
        if (this.m_nativeSystem.isUnixSystem()) {
            return;
        }
        Trace.out("granting ORA_GRID_LISTENERS group execute permissions");
        this.setPerm(ResourceType.ACL.GROUP, "ORA_GRID_LISTENERS", ResourceType.ACL_PERM.EXECUTE, ResourceType.ACL_PERM.READ);
    }

    public String getAclString() {
        StringBuilder sb = new StringBuilder();
        if (!this.m_isPerm4ActionOp) {
            sb.append(this.m_owner.toString() + ",");
            sb.append(this.m_pgrp.toString() + ",");
            sb.append(this.m_others.toString() + ",");
        }
        for (AclItem ac : this.m_groups) {
            sb.append(ac.toString()).append(",");
        }
        for (AclItem ac : this.m_users) {
            sb.append(ac.toString()).append(",");
        }
        if (sb.length() == 0) {
            return sb.toString();
        }
        return sb.lastIndexOf(",") == sb.length() - 1 ? sb.substring(0, sb.length() - 1) : sb.toString();
    }

    public boolean isActionPermission() {
        return this.m_isPerm4ActionOp;
    }

    public static String createActionsAttrValue(Map<String, ResourcePermissionsImpl> perms) throws InvalidArgsException {
        if (perms == null || perms.isEmpty() || perms.containsKey(null) || perms.containsValue(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ResPerm-createActionsAttrValue-1");
        }
        StringBuilder sb = new StringBuilder();
        for (String action : perms.keySet()) {
            Trace.out((Object)"action = %s", action);
            ResourcePermissionsImpl perm = perms.get(action);
            String acl = perm.getAclString().trim();
            Trace.out((Object)"acl = %s", acl);
            if (acl.length() == 0) {
                sb.append(action.trim() + " ");
                continue;
            }
            sb.append(action.trim() + "," + acl + " ");
        }
        Trace.out((Object)"ACTIONS attr val = %s", sb.toString());
        return sb.toString().trim();
    }

    public static Map<String, ResourcePermissionsImpl> getActions(String actionsACL) throws InvalidArgsException, CRSException {
        String[] actions;
        if (actionsACL == null || actionsACL.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ResPerm-getActions-1");
        }
        HashMap<String, ResourcePermissionsImpl> ret = new HashMap<String, ResourcePermissionsImpl>();
        for (String action : actions = actionsACL.split(" ")) {
            Trace.out((Object)"processing %s ...", action);
            ArrayList<String> users = new ArrayList<String>();
            ArrayList<String> groups = new ArrayList<String>();
            String[] vals = action.split(",");
            if (vals.length > 1) {
                for (int i = 1; i < vals.length; ++i) {
                    String aclItem = vals[i];
                    Trace.out((Object)"ACL item : %s", aclItem);
                    if (aclItem == null || aclItem.trim().isEmpty() || !aclItem.contains(String.valueOf(':'))) {
                        throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ResPerm-getActions-2");
                    }
                    String[] aclItemVals = aclItem.split(String.valueOf(':'));
                    String type = aclItemVals[0];
                    String name = aclItemVals[1];
                    if (type == null || !type.equals(ResourceType.ACL.USER.toString()) && !type.equals(ResourceType.ACL.GROUP.toString())) {
                        throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ResPerm-getActions-3");
                    }
                    if (name == null || !name.startsWith("\"") || !name.endsWith("\"")) {
                        throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ResPerm-getActions-4");
                    }
                    name = name.substring(1, name.length() - 1);
                    if (type.equals(ResourceType.ACL.USER.toString())) {
                        Trace.out((Object)"Adding %s to users list", name);
                        users.add(name);
                        continue;
                    }
                    Trace.out((Object)"Adding %s to groups list", name);
                    groups.add(name);
                }
            }
            ret.put(vals[0], new ResourcePermissionsImpl(users, groups));
        }
        return ret;
    }

    private class AclItem {
        String m_title;
        String m_name;
        String m_perm;

        AclItem(String aclLine) throws CRSException {
            String[] items = aclLine.split(String.valueOf(':'));
            if (items.length != 3) {
                throw new CRSException((MessageKey)PrCrMsgID.RES_GETPERM_FAILED, ResourcePermissionsImpl.this.m_resName, aclLine);
            }
            this.m_title = items[0];
            this.m_name = items[1];
            this.m_perm = items[2];
        }

        AclItem(String titel, String name) {
            this.m_title = titel;
            this.m_name = name;
            this.m_perm = "---";
        }

        AclItem(ResourceType.ACL role) {
            this.m_title = role.toString();
            this.m_name = "";
            this.m_perm = "";
        }

        public String toString() {
            return ResourcePermissionsImpl.this.m_isPerm4ActionOp ? this.m_title + ':' + "\"" + this.m_name + "\"" : this.m_title + ':' + this.m_name + ':' + this.m_perm;
        }
    }
}

