/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ResourceDependency {
    private ResourceAttribute m_nameAttr;
    private DepType m_depType;
    private EnumSet m_depModifierSet;

    ResourceDependency(ResourceAttribute nameAttr, DepType depType, DepModifier ... depModifiers) {
        this.m_nameAttr = nameAttr;
        this.m_depType = depType;
        this.m_depModifierSet = EnumSet.noneOf(DepModifier.class);
        for (DepModifier dm : depModifiers) {
            this.m_depModifierSet.add(dm);
        }
    }

    ResourceDependency(DepType depType, String resDep) throws CRSException {
        int index = resDep.lastIndexOf(58);
        String resName = resDep;
        String[] depModifierArr = null;
        if (index >= 0) {
            resName = resDep.substring(index + 1);
            depModifierArr = resDep.substring(0, index).split(String.valueOf(':'));
        }
        this.m_nameAttr = new ResourceAttribute(ResourceType.LocalResource.NAME.name(), resName);
        this.m_depType = depType;
        this.m_depModifierSet = EnumSet.noneOf(DepModifier.class);
        if (depModifierArr != null) {
            for (String dm : depModifierArr) {
                try {
                    this.m_depModifierSet.add(DepModifier.getEnumMember(dm));
                }
                catch (EnumConstantNotPresentException e) {
                    throw new CRSException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)e, new Object[0]);
                }
            }
        }
    }

    ResourceAttribute getNameAttr() {
        return this.m_nameAttr;
    }

    boolean addModifier(DepModifier[] depModifiers) {
        boolean bModified = false;
        for (DepModifier dm : depModifiers) {
            if (dm == null || this.m_depModifierSet.contains((Object)dm)) continue;
            this.m_depModifierSet.add(dm);
            bModified = true;
        }
        return bModified;
    }

    boolean removeModifier(DepModifier[] depModifiers) {
        boolean bModified = false;
        for (DepModifier dm : depModifiers) {
            if (dm == null || !this.m_depModifierSet.contains((Object)dm)) continue;
            this.m_depModifierSet.remove((Object)dm);
            bModified = true;
        }
        return bModified;
    }

    public boolean isHard() {
        return this.m_depType.equals((Object)DepType.HARD_DEP);
    }

    public boolean isAttraction() {
        return this.m_depType.equals((Object)DepType.ATTRACTION_DEP);
    }

    public boolean isWeak() {
        return this.m_depType.equals((Object)DepType.WEAK_DEP);
    }

    public boolean isPullup() {
        return this.m_depType.equals((Object)DepType.PULLUP_DEP);
    }

    public boolean isPullupAlways() {
        return this.m_depType.equals((Object)DepType.PULLUP_ALWAYS_DEP);
    }

    public boolean isDisperse() {
        return this.m_depType.equals((Object)DepType.DISPERSION_DEP);
    }

    public boolean isDisperseActive() {
        return this.m_depType.equals((Object)DepType.DISPERSION_ACTIVE_DEP);
    }

    public boolean isExclusion() {
        return this.m_depType.equals((Object)DepType.EXCLUSION_DEP);
    }

    private String getModifierString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_depModifierSet.contains((Object)DepModifier.UNIFORM_MODIFIER_DEP)) {
            sb.append(DepModifier.UNIFORM_MODIFIER_DEP.toString() + ':');
        }
        if (this.m_depModifierSet.contains((Object)DepModifier.GLOBAL_MODIFIER_DEP)) {
            sb.append(DepModifier.GLOBAL_MODIFIER_DEP.toString() + ':');
        }
        if (this.m_depModifierSet.contains((Object)DepModifier.INTERMEDIATE_MODIFIER_DEP)) {
            sb.append(DepModifier.INTERMEDIATE_MODIFIER_DEP.toString() + ':');
        }
        if (this.m_depModifierSet.contains((Object)DepModifier.STARTFIRST_MODIFIER_DEP)) {
            sb.append(DepModifier.STARTFIRST_MODIFIER_DEP.toString() + ':');
        }
        if (this.m_depModifierSet.contains((Object)DepModifier.STOPFIRST_MODIFIER_DEP)) {
            sb.append(DepModifier.STOPFIRST_MODIFIER_DEP.toString() + ':');
        }
        if (this.m_depModifierSet.contains((Object)DepModifier.CONCURRENT_MODIFIER_DEP)) {
            sb.append(DepModifier.CONCURRENT_MODIFIER_DEP.toString() + ':');
        }
        if (this.m_depModifierSet.contains((Object)DepModifier.SITE_MODIFIER_DEP)) {
            sb.append(DepModifier.SITE_MODIFIER_DEP.toString() + ':');
        }
        if (this.m_depModifierSet.contains((Object)DepModifier.TYPE_MODIFIER_DEP)) {
            sb.append(DepModifier.TYPE_MODIFIER_DEP.toString() + ':');
        }
        if (this.m_depModifierSet.contains((Object)DepModifier.SHUTDOWN_MODIFIER_DEP)) {
            sb.append(DepModifier.SHUTDOWN_MODIFIER_DEP.toString() + ':');
        }
        if (this.m_depModifierSet.contains((Object)DepModifier.PREEMPT_PRE_MODIFIER_DEP)) {
            sb.append(DepModifier.PREEMPT_PRE_MODIFIER_DEP.toString() + ':');
        }
        if (this.m_depModifierSet.contains((Object)DepModifier.PREEMPT_POST_MODIFIER_DEP)) {
            sb.append(DepModifier.PREEMPT_POST_MODIFIER_DEP.toString() + ':');
        }
        sb.append(this.m_nameAttr.getValue());
        return sb.toString();
    }

    public String toString() {
        return this.m_depType.toString() + '(' + this.getModifierString() + ')';
    }

    public static String toString(List<ResourceDependency> dependencies) {
        return ResourceDependency.toString(dependencies.toArray(new ResourceDependency[dependencies.size()]));
    }

    public static String toString(ResourceDependency ... dependencies) {
        StringBuilder hardSb = null;
        StringBuilder attractSb = null;
        StringBuilder weakSb = null;
        StringBuilder pullupSb = null;
        StringBuilder pullupAlwaysSb = null;
        StringBuilder disperseSb = null;
        StringBuilder disperseActiveSb = null;
        StringBuilder exclusionSb = null;
        for (ResourceDependency dep : dependencies) {
            if (dep == null) continue;
            if (dep.isHard()) {
                if (hardSb != null) {
                    hardSb.append("," + dep.getModifierString());
                } else {
                    hardSb = new StringBuilder(dep.getModifierString());
                }
            }
            if (dep.isAttraction()) {
                if (attractSb != null) {
                    attractSb.append("," + dep.getModifierString());
                    continue;
                }
                attractSb = new StringBuilder(dep.getModifierString());
                continue;
            }
            if (dep.isWeak()) {
                if (weakSb != null) {
                    weakSb.append("," + dep.getModifierString());
                    continue;
                }
                weakSb = new StringBuilder(dep.getModifierString());
                continue;
            }
            if (dep.isPullup()) {
                if (pullupSb != null) {
                    pullupSb.append("," + dep.getModifierString());
                    continue;
                }
                pullupSb = new StringBuilder(dep.getModifierString());
                continue;
            }
            if (dep.isPullupAlways()) {
                if (pullupAlwaysSb != null) {
                    pullupAlwaysSb.append("," + dep.getModifierString());
                    continue;
                }
                pullupAlwaysSb = new StringBuilder(dep.getModifierString());
                continue;
            }
            if (dep.isDisperse()) {
                if (disperseSb != null) {
                    disperseSb.append("," + dep.getModifierString());
                    continue;
                }
                disperseSb = new StringBuilder(dep.getModifierString());
                continue;
            }
            if (dep.isDisperseActive()) {
                if (disperseActiveSb != null) {
                    disperseActiveSb.append("," + dep.getModifierString());
                    continue;
                }
                disperseActiveSb = new StringBuilder(dep.getModifierString());
                continue;
            }
            if (!dep.isExclusion()) continue;
            if (exclusionSb != null) {
                exclusionSb.append("," + dep.getModifierString());
                continue;
            }
            exclusionSb = new StringBuilder(dep.getModifierString());
        }
        StringBuilder result = new StringBuilder();
        if (hardSb != null) {
            result.append(DepType.HARD_DEP.toString() + '(' + hardSb.toString() + ')');
        }
        if (weakSb != null) {
            if (result.length() > 0) {
                result.append(" " + DepType.WEAK_DEP.toString() + '(' + weakSb.toString() + ')');
            } else {
                result.append(DepType.WEAK_DEP.toString() + '(' + weakSb.toString() + ')');
            }
        }
        if (attractSb != null) {
            if (result.length() > 0) {
                result.append(" " + DepType.ATTRACTION_DEP.toString() + '(' + attractSb.toString() + ')');
            } else {
                result.append(DepType.ATTRACTION_DEP.toString() + '(' + attractSb.toString() + ')');
            }
        }
        if (disperseSb != null) {
            if (result.length() > 0) {
                result.append(" " + DepType.DISPERSION_DEP.toString() + '(' + disperseSb.toString() + ')');
            } else {
                result.append(DepType.DISPERSION_DEP.toString() + '(' + disperseSb.toString() + ')');
            }
        }
        if (disperseActiveSb != null) {
            if (result.length() > 0) {
                result.append(" " + DepType.DISPERSION_ACTIVE_DEP.toString() + '(' + disperseActiveSb.toString() + ')');
            } else {
                result.append(DepType.DISPERSION_ACTIVE_DEP.toString() + '(' + disperseActiveSb.toString() + ')');
            }
        }
        if (pullupSb != null) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(DepType.PULLUP_DEP.toString()).append('(');
            result.append(pullupSb.toString()).append(')');
        }
        if (pullupAlwaysSb != null) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(DepType.PULLUP_ALWAYS_DEP.toString()).append('(');
            result.append(pullupAlwaysSb.toString()).append(')');
        }
        if (exclusionSb != null) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(DepType.EXCLUSION_DEP.toString()).append('(');
            result.append(exclusionSb.toString()).append(')');
        }
        return result.toString();
    }

    public String[] getResourceNames(DepType depType) {
        return ResourceDependency.getDependentNames(this.toString(), depType, true, false);
    }

    public static String[] getResourceNames(ResourceAttribute attr, DepType depType) {
        return ResourceDependency.getDependentNames(attr.getValue(), depType, true, false);
    }

    public static String[] getResourceTypeNames(ResourceAttribute attr, DepType depType) {
        return ResourceDependency.getDependentNames(attr.getValue(), depType, false, true);
    }

    private static String[] getDependentNames(String depValue, DepType depType, boolean isRes, boolean isType) {
        if (!isRes && !isType) {
            return new String[0];
        }
        int index = depValue.indexOf(depType.toString() + String.valueOf('('));
        if (index < 0) {
            return new String[0];
        }
        String values = depValue.substring(index + depType.toString().length()).trim();
        if (values.startsWith(String.valueOf('(')) && (index = (values = values.substring(String.valueOf('(').length())).indexOf(41)) > 0) {
            values = values.substring(0, index);
        }
        String[] depNames = values.split(String.valueOf(","));
        if (isRes && isType) {
            return depNames;
        }
        ArrayList<String> list = new ArrayList<String>(depNames.length);
        for (int i = 0; i < depNames.length; ++i) {
            String[] parts;
            if (isRes && !isType && depNames[i].indexOf(DepModifier.TYPE_MODIFIER_DEP.toString()) < 0) {
                parts = depNames[i].split(String.valueOf(':'));
                if (parts.length > 0) {
                    list.add(parts[parts.length - 1].trim());
                    continue;
                }
                if (depNames[i].trim().length() <= 0) continue;
                list.add(depNames[i].trim());
                continue;
            }
            if (isRes || !isType || depNames[i].indexOf(DepModifier.TYPE_MODIFIER_DEP.toString()) < 0) continue;
            parts = depNames[i].split(String.valueOf(':'));
            if (parts.length > 0) {
                list.add(parts[parts.length - 1].trim());
                continue;
            }
            if (depNames[i].trim().length() <= 0) continue;
            list.add(depNames[i].trim());
        }
        depNames = new String[list.size()];
        list.toArray(depNames);
        return depNames;
    }

    public static boolean hasDependency(ResourceAttribute startDep, ResourceAttribute depAttr, DepType depType) {
        if (!startDep.getName().equalsIgnoreCase(ResourceType.LocalResource.START_DEPENDENCIES.name())) {
            return false;
        }
        String[] depNames = ResourceDependency.getDependentNames(startDep.getValue(), depType, true, true);
        String targetName = depAttr.getValue();
        for (String res : depNames) {
            if (!targetName.equals(res)) continue;
            return true;
        }
        return false;
    }

    public static boolean setPullupDependency(ResourceAttribute startDep, ResourceAttribute depAttr, boolean always) {
        if (!startDep.getName().equalsIgnoreCase(ResourceType.LocalResource.START_DEPENDENCIES.name())) {
            return false;
        }
        LinkedHashMap<String, String[]> depMap = new LinkedHashMap<String, String[]>();
        for (DepType depType : (DepType[])DepType.class.getEnumConstants()) {
            String[] depTypeValues = ResourceDependency.getDependentNames(startDep.getValue(), depType, true, true);
            if (depTypeValues.length == 0) continue;
            depMap.put(depType.toString(), depTypeValues);
        }
        String targetEntity = depAttr.getValue();
        String[] pullups = (String[])depMap.get(DepType.PULLUP_DEP.toString());
        String[] pullupAlways = (String[])depMap.get(DepType.PULLUP_ALWAYS_DEP.toString());
        ArrayList<String> pullupList = new ArrayList<String>();
        ArrayList<String> pullupAlwaysList = new ArrayList<String>();
        if (pullups != null) {
            for (String pu : pullups) {
                pullupList.add(pu);
            }
        }
        if (pullupAlways != null) {
            for (String pua : pullupAlways) {
                pullupAlwaysList.add(pua);
            }
        }
        if (always) {
            if (pullupAlwaysList.contains(targetEntity)) {
                return true;
            }
            pullupAlwaysList.add(targetEntity);
            pullupAlways = pullupAlwaysList.toArray(new String[pullupAlwaysList.size()]);
            depMap.put(DepType.PULLUP_ALWAYS_DEP.toString(), pullupAlways);
            if (pullupList.contains(targetEntity)) {
                pullupList.remove(targetEntity);
                pullups = pullupList.toArray(new String[pullupList.size()]);
                depMap.put(DepType.PULLUP_DEP.toString(), pullups);
            }
        } else {
            if (pullupList.contains(targetEntity)) {
                return true;
            }
            pullupList.add(targetEntity);
            pullups = pullupList.toArray(new String[pullupList.size()]);
            depMap.put(DepType.PULLUP_DEP.toString(), pullups);
            if (pullupAlwaysList.contains(targetEntity)) {
                pullupAlwaysList.remove(targetEntity);
                pullupAlways = pullupAlwaysList.toArray(new String[pullupAlwaysList.size()]);
                depMap.put(DepType.PULLUP_ALWAYS_DEP.toString(), pullupAlways);
            }
        }
        StringBuilder result = new StringBuilder();
        for (String keyName : depMap.keySet()) {
            String[] keyValue = (String[])depMap.get(keyName);
            if (keyValue == null || keyValue.length == 0) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(keyName).append(String.valueOf('(')).append(Utils.getString(keyValue, ",")).append(String.valueOf(')'));
        }
        startDep.setValue(result.toString());
        return true;
    }

    public static boolean updateDependency(ResourceAttribute startDep, ResourceAttribute depAttr, DepType depType, boolean bAdd) throws CRSException {
        if (!startDep.getName().equalsIgnoreCase(ResourceType.LocalResource.START_DEPENDENCIES.name())) {
            return false;
        }
        return ResourceDependency.updateDependencyAttr(startDep, depAttr, depType, bAdd);
    }

    public static boolean updateDependencyAttr(ResourceAttribute dep1Attr, ResourceAttribute res1Attr, DepType depType, boolean bAdd) throws CRSException {
        return ResourceDependency.updateDependencyAttrModifier(bAdd, dep1Attr, res1Attr, depType, new DepModifier[0]);
    }

    public static boolean updateDependencyAttr(ResourceAttribute dep1Attr, ResourceAttribute res1Attr, DepType depType, DepModifier depMod, boolean bAdd) throws CRSException {
        return ResourceDependency.updateDependencyAttrModifier(bAdd, true, dep1Attr, res1Attr, depType, depMod);
    }

    public static boolean updateDependencyAttrModifier(boolean bAdd, ResourceAttribute dep1Attr, ResourceAttribute res1Attr, DepType depType, DepModifier ... depMod) throws CRSException {
        return ResourceDependency.updateDependencyAttrModifier(bAdd, false, dep1Attr, res1Attr, depType, depMod);
    }

    static boolean updateDependencyAttrModifier(boolean bAdd, boolean bBackComp, ResourceAttribute dep1Attr, ResourceAttribute res1Attr, DepType depType, DepModifier ... depMod) throws CRSException {
        Trace.out("ARGS: depAttr=" + dep1Attr.getName() + "; depAttr-value=" + dep1Attr.getValue() + "; res1Attr=" + res1Attr.getValue());
        if (depType != null) {
            Trace.out("depType=" + depType.toString());
        }
        for (DepModifier dm : depMod) {
            Trace.out("depMod contains " + (Object)((Object)dm));
            if (dm != null) continue;
            Trace.out("Get null ResourceDependency.DepModifier");
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "DepModifier:null");
        }
        if (!dep1Attr.getName().equalsIgnoreCase(ResourceType.LocalResource.START_DEPENDENCIES.name()) && !dep1Attr.getName().equalsIgnoreCase(ResourceType.LocalResource.STOP_DEPENDENCIES.name())) {
            Trace.out("Invalid attribute specified, return false");
            return false;
        }
        LinkedHashMap<String, String[]> depMap = new LinkedHashMap<String, String[]>();
        for (DepType dType : (DepType[])DepType.class.getEnumConstants()) {
            String[] depTypeValues = ResourceDependency.getDependentNames(dep1Attr.getValue(), dType, true, true);
            if (depTypeValues.length == 0) continue;
            depMap.put(dType.toString(), depTypeValues);
        }
        String targetRes = res1Attr.getValue();
        String[] curDepTypeList = (String[])depMap.get(depType.toString());
        ArrayList<String> updatedList = new ArrayList<String>();
        boolean bFoundResAttr = false;
        boolean bModified = false;
        if (curDepTypeList != null) {
            String[] stringArray = curDepTypeList;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                ResourceDependency resDep;
                String cuDep;
                String cuResDep = cuDep = stringArray[i];
                if (!bFoundResAttr && (resDep = new ResourceDependency(depType, cuDep.trim())).getNameAttr().getValue().equals(res1Attr.getValue())) {
                    bFoundResAttr = true;
                    if (bAdd) {
                        bModified = resDep.addModifier(depMod);
                        if (!bModified) break;
                        cuResDep = resDep.getModifierString();
                    } else if (bBackComp && depMod.length == 1) {
                        if (cuDep.equals(depMod[0].toString() + ':' + targetRes)) {
                            cuResDep = null;
                            bModified = true;
                        }
                    } else if (depMod != null && depMod.length > 0) {
                        bModified = resDep.removeModifier(depMod);
                        if (bModified) {
                            cuResDep = resDep.getModifierString();
                        }
                    } else {
                        Trace.out("Remove dependency: " + cuDep);
                        cuResDep = null;
                        bModified = true;
                    }
                }
                if (cuResDep == null) continue;
                updatedList.add(cuResDep);
            }
        }
        if (!bFoundResAttr && bAdd) {
            ResourceDependency resDep = new ResourceDependency(res1Attr, depType, depMod);
            Trace.out("resDep to be added is " + resDep.getModifierString());
            updatedList.add(resDep.getModifierString());
            bModified = true;
        }
        if (!bModified) {
            return true;
        }
        if (updatedList.size() == 0) {
            depMap.remove(depType.toString());
        } else {
            curDepTypeList = updatedList.toArray(new String[updatedList.size()]);
            depMap.put(depType.toString(), curDepTypeList);
        }
        StringBuilder result = new StringBuilder();
        for (String keyName : depMap.keySet()) {
            String[] keyValue = (String[])depMap.get(keyName);
            if (keyValue == null || keyValue.length == 0) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(keyName).append(String.valueOf('(')).append(Utils.getString(keyValue, ",")).append(String.valueOf(')'));
        }
        dep1Attr.setValue(result.toString());
        return true;
    }

    public static enum DepModifier {
        SITE_MODIFIER_DEP("site"),
        TYPE_MODIFIER_DEP("type"),
        UNIFORM_MODIFIER_DEP("uniform"),
        GLOBAL_MODIFIER_DEP("global"),
        INTERMEDIATE_MODIFIER_DEP("intermediate"),
        STARTFIRST_MODIFIER_DEP("startfirst"),
        STOPFIRST_MODIFIER_DEP("stopfirst"),
        CONCURRENT_MODIFIER_DEP("concurrent"),
        SHUTDOWN_MODIFIER_DEP("shutdown"),
        PREEMPT_PRE_MODIFIER_DEP("preempt_pre"),
        PREEMPT_POST_MODIFIER_DEP("preempt_post");

        private String m_value;

        private DepModifier(String value) {
            this.m_value = value;
        }

        static DepModifier getEnumMember(String dmStr) throws EnumConstantNotPresentException {
            for (DepModifier dm : DepModifier.values()) {
                if (!dm.m_value.equalsIgnoreCase(dmStr.trim())) continue;
                return dm;
            }
            Trace.out("Failed to find the enum representation of the DepModifier " + dmStr);
            throw new EnumConstantNotPresentException(DepModifier.class, dmStr);
        }

        public String toString() {
            return this.m_value;
        }
    }

    public static enum DepType {
        HARD_DEP("hard"),
        WEAK_DEP("weak"),
        PULLUP_DEP("pullup"),
        PULLUP_ALWAYS_DEP(PULLUP_DEP.toString() + ":always"),
        ATTRACTION_DEP("attraction"),
        DISPERSION_DEP("dispersion"),
        DISPERSION_ACTIVE_DEP(DISPERSION_DEP.toString() + ":active"),
        EXCLUSION_DEP("exclusion");

        private String m_value;

        private DepType(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }
}

