/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.Relocatable;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;

public class RelocatableImpl
extends CRSResourceImpl
implements Relocatable {
    RelocatableImpl(ResourceAttribute attr) throws CRSException {
        super(attr);
    }

    RelocatableImpl(CRSEntity sibling, ResourceAttribute attr) throws CRSException {
        super(sibling, attr, new Version());
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        this.relocateMe(null, null, null);
    }

    public void relocate(boolean force) throws NotRunningException, RelocateException {
        this.relocateMe(null, null, force, null);
    }

    public void relocate(ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        this.relocateMe(null, null, options);
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        if (srcNode == null) {
            throw new RelocateException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "srcNode");
        }
        try {
            this.relocateMe(srcNode.getName(), null, null);
        }
        catch (NodeException e) {
            throw new RelocateException((MessageKey)PrCrMsgID.RES_RELOCATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        this.relocateTo(tgtNode, true);
    }

    public void relocateTo(Node tgtNode, boolean force) throws NotRunningException, RelocateException {
        if (tgtNode == null) {
            throw new RelocateException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "tgtNode");
        }
        try {
            this.relocateMe(null, tgtNode.getName(), force, null);
        }
        catch (NodeException e) {
            throw new RelocateException((MessageKey)PrCrMsgID.RES_RELOCATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    public void relocate(Node srcNode, ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        if (srcNode == null) {
            throw new RelocateException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "srcNode");
        }
        try {
            this.relocateMe(srcNode.getName(), null, options);
        }
        catch (NodeException e) {
            throw new RelocateException((MessageKey)PrCrMsgID.RES_RELOCATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    public void relocateTo(Node tgtNode, ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        if (tgtNode == null) {
            throw new RelocateException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "tgtNode");
        }
        try {
            this.relocateMe(null, tgtNode.getName(), options);
        }
        catch (NodeException e) {
            throw new RelocateException((MessageKey)PrCrMsgID.RES_RELOCATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        this.relocate(srcNode, tgtNode, (ServiceArgs.RelocateOption[])null);
    }

    public void relocate(Node srcNode, Node tgtNode, ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        if (srcNode == null) {
            throw new RelocateException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "srcNode");
        }
        if (tgtNode == null) {
            throw new RelocateException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "tgtNode");
        }
        if (options != null) {
            for (ServiceArgs.RelocateOption opt : options) {
                if (opt != null) continue;
                throw new RelocateException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "opt");
            }
        }
        try {
            this.relocateMe(srcNode.getName(), tgtNode.getName(), options);
        }
        catch (NodeException e) {
            throw new RelocateException((MessageKey)PrCrMsgID.RES_RELOCATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    private void relocateMe(String srcNode, String tgtNode, ServiceArgs.RelocateOption[] relocOptions) throws NotRunningException, RelocateException {
        this.relocateMe(srcNode, tgtNode, true, relocOptions);
    }

    private void relocateMe(String srcNode, String tgtNode, boolean force, ServiceArgs.RelocateOption[] relocOptions) throws NotRunningException, RelocateException {
        try {
            ResourceAttribute[] options = null;
            if (relocOptions != null) {
                options = new ResourceAttribute[relocOptions.length];
                boolean disconnect = false;
                boolean noreplay = false;
                CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
                int i = 0;
                block6: for (ServiceArgs.RelocateOption opt : relocOptions) {
                    switch (opt) {
                        case DISCONNECT: {
                            disconnect = true;
                            options[i++] = cf.create(ResourceType.Service.USR_ORA_DISCONNECT.name(), Boolean.toString(true));
                            continue block6;
                        }
                        case NOREPLAY: {
                            noreplay = true;
                            options[i++] = cf.create(ResourceType.Service.SESSION_NOREPLAY.name(), Boolean.toString(true));
                            continue block6;
                        }
                        default: {
                            throw new RelocateException((MessageKey)PrCrMsgID.UNSUPPORTED_RELOCATE_OPTION, opt.toString());
                        }
                    }
                }
                if (!disconnect && noreplay) {
                    throw new RelocateException((MessageKey)PrCdMsgID.NOREPLAY_NOT_ALLOWED, new Object[0]);
                }
            }
            this.getOperations().relocate(this, srcNode, tgtNode, force, options);
        }
        catch (CRSException e) {
            if (srcNode == null && tgtNode == null) {
                throw new RelocateException((MessageKey)PrCrMsgID.RES_RELOCATE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
            if (tgtNode == null) {
                throw new RelocateException((MessageKey)PrCrMsgID.RES_RELOCATE_FAILED_FROM_NODE, (Throwable)e, this.m_nameAttr.getValue(), srcNode);
            }
            if (srcNode == null) {
                throw new RelocateException((MessageKey)PrCrMsgID.RES_RELOCATE_FAILED_NODE, (Throwable)e, this.m_nameAttr.getValue(), tgtNode);
            }
            throw new RelocateException((MessageKey)PrCrMsgID.RES_RELOCATE_FAILED_NODE_NODE, (Throwable)e, this.m_nameAttr.getValue(), srcNode, tgtNode);
        }
    }
}

