/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.List;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.LsnodesUtil;
import oracle.cluster.common.Cluster;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.crs.OracleCMCluster;
import oracle.cluster.impl.crs.sSkgxn;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

class OracleCMClusterImpl
implements OracleCMCluster {
    private String m_nodeName;
    private String m_crsHome;

    @Override
    public Cluster cluster() throws NotExistsException, ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public String getOracleCMClusterName() throws ClusterException {
        LsnodesUtil lsnodes = this.getLsUtil();
        try {
            return lsnodes.getClusterName(this.m_nodeName);
        }
        catch (CmdToolUtilException e) {
            throw new ClusterException("lsnodes", e);
        }
    }

    @Override
    public String getVersion() throws NoVersionAvailableException, ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public String[] nodeNames() throws ClusterException {
        LsnodesUtil lsnodes = this.getLsUtil();
        try {
            return lsnodes.getNodeNames();
        }
        catch (CmdToolUtilException e) {
            throw new ClusterException("node names", e);
        }
    }

    @Override
    public List<Node> nodes() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public String[] privateNodeNames() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public void setInstallCRSHome(String crsHome) {
        this.m_crsHome = crsHome;
    }

    static OracleCMCluster getInstance() throws NotExistsException {
        return new OracleCMClusterImpl();
    }

    static OracleCMCluster getInstance(String nodeName) throws NotExistsException {
        return new OracleCMClusterImpl(nodeName);
    }

    private OracleCMClusterImpl() throws NotExistsException {
        this(new sSkgxn());
    }

    private OracleCMClusterImpl(String nodeName) throws NotExistsException {
        this(new sSkgxn(nodeName));
    }

    private OracleCMClusterImpl(sSkgxn skgxn) throws NotExistsException {
        try {
            if (!skgxn.hasOracleCMClusterLib()) {
                throw new NotExistsException((MessageKey)PrCrMsgID.CLU_ORACM_NOT_FOUND, skgxn.nodeName());
            }
        }
        catch (ClusterException e) {
            Trace.out(e);
            throw new NotExistsException((MessageKey)PrCrMsgID.CLU_ORACM_LIB_CHECK_FAILED, skgxn.nodeName());
        }
        this.m_nodeName = skgxn.nodeName();
    }

    private LsnodesUtil getLsUtil() throws ClusterException {
        try {
            return new LsnodesUtil(this.m_crsHome);
        }
        catch (CmdToolUtilException e) {
            throw new ClusterException("node name", e);
        }
    }
}

