/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.List;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CardinalityException;
import oracle.cluster.crs.ClusterResource;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageKey;

public class ClusterResourceImpl
extends RelocatableImpl
implements ClusterResource {
    ClusterResourceImpl(ResourceAttribute attr) throws CRSException {
        super(attr);
    }

    ClusterResourceImpl(CRSEntity sibling, ResourceAttribute attr) throws CRSException {
        super(sibling, attr);
    }

    @Override
    public int getCardinality() throws CardinalityException {
        try {
            return this.fetchRunningNodes().size();
        }
        catch (CRSException e) {
            throw new CardinalityException((MessageKey)PrCrMsgID.RES_GET_CARD_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public int getMaxCardinality() throws CardinalityException {
        String card = "";
        try {
            List<ResourceAttribute> attrList = this.getCurrentAttributes(Cluster.getLocalNode(), ResourceType.ClusterResource.CARDINALITY.name());
            card = attrList.get(0).getValue();
            return Integer.parseInt(card);
        }
        catch (ClusterException e) {
            throw new CardinalityException((MessageKey)PrCrMsgID.RES_GET_CARD_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
        catch (CRSException e) {
            throw new CardinalityException((MessageKey)PrCrMsgID.RES_GET_CARD_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public void setMaxCardinality(int cardinality) throws CardinalityException {
        try {
            this.update(new ResourceAttribute(ResourceType.ClusterResource.CARDINALITY.name(), String.valueOf(cardinality)));
        }
        catch (CRSException e) {
            throw new CardinalityException((MessageKey)PrCrMsgID.RES_SET_CARD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), cardinality);
        }
    }

    @Override
    public void start(int count) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        try {
            this.getOperations().startResource(this, count, null);
        }
        catch (CRSException e) {
            throw new CardinalityException((MessageKey)PrCrMsgID.RES_START_FAILED, (Throwable)e, this.m_nameAttr.getValue(), count);
        }
    }

    public void start(int count, ResourceAttribute[] overrideAttrs) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        if (overrideAttrs == null || overrideAttrs.length == 0) {
            throw new CardinalityException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "overrideAttrs");
        }
        try {
            this.getOperations().startResource(this, count, overrideAttrs);
        }
        catch (CRSException e) {
            throw new CardinalityException((MessageKey)PrCrMsgID.RES_START_FAILED, (Throwable)e, this.m_nameAttr.getValue(), count);
        }
    }

    @Override
    public void stop(int count, boolean force) throws AlreadyStoppedException, CompositeOperationException, CardinalityException {
        try {
            this.getOperations().stopResource((CRSResource)this, count, force, null);
        }
        catch (CRSException e) {
            throw new CardinalityException((MessageKey)PrCrMsgID.RES_STOP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), count);
        }
    }

    @Override
    public void remove(int count, boolean force) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        throw new CardinalityException((MessageKey)PrCrMsgID.RES_REMOVE_FAILED, this.m_nameAttr.getValue(), count, "NOT IMPLEMENTED YET");
    }
}

