/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSCompositeOperationException;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class CRSServerCategoryEntity
extends CRSEntity {
    CRSServerCategoryEntity(String name) throws CRSException {
        super(CRSEntity.Type.ServerCategory, name);
    }

    CRSServerCategoryEntity create(String activecssrole, Filter expression) throws AlreadyExistsException, CRSException {
        List<ResourceAttribute> attrList = ResourceType.getAttributes(ResourceType.ServerCategory.class);
        for (ResourceAttribute attr : attrList) {
            if (attr.getName().equalsIgnoreCase(ResourceType.ServerCategory.NAME.name())) {
                attr.setValue(this.entityName());
            }
            if (!attr.getName().equalsIgnoreCase(ResourceType.ServerCategory.ACTIVE_CSS_ROLE.name())) continue;
            attr.setValue(activecssrole);
        }
        this.register(attrList, expression, false);
        return this;
    }

    public static List<Server> serversByCategory(String category) throws CRSException, NotExistsException {
        try {
            String[] attrNames = new String[]{ResourceLiterals.NAME.toString()};
            Map<String, Map<String, String>> resMap = CRSNative.getServersByCategory(attrNames, category);
            ArrayList<Server> slist = new ArrayList<Server>();
            Trace.out("Size of resMap is =" + resMap.size());
            if (resMap != null && resMap.size() > 0) {
                ServerFactory sf = ServerFactory.getInstance();
                for (String riID : resMap.keySet()) {
                    Map<String, String> attrMap = resMap.get(riID);
                    Trace.out("Size of attrMap is " + attrMap.size());
                    String nodeName = null;
                    for (String attrID : attrMap.keySet()) {
                        Trace.out("<name,value>=" + attrID + " " + attrMap.get(attrID));
                        if (!attrID.equals(ResourceLiterals.NAME.toString())) continue;
                        nodeName = attrMap.get(attrID);
                        Node node = sf.getNode(nodeName);
                        slist.add(sf.getServer(node));
                    }
                    if (nodeName != null) continue;
                    throw new CRSException((MessageKey)PrCrMsgID.RES_ATTR_NOT_EXISTS, ResourceLiterals.NAME.toString());
                }
            }
            return slist;
        }
        catch (CRSCompositeOperationException e) {
            throw new CRSException(e);
        }
        catch (NodeException e) {
            throw new CRSException(e);
        }
        catch (ServerException e) {
            throw new CRSException(e);
        }
    }
}

