/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.crs.ActionAttribute;
import oracle.cluster.crs.ActionListener;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.trace.Trace;

public class CRSResourceImpl
extends CRSEntity
implements CRSResource {
    protected ResourceAttribute m_nameAttr;
    protected Version m_version;
    private static final String BAD_NODE_NAME = "?NODE?";

    CRSResourceImpl(ResourceAttribute attr) throws CRSException {
        this(attr, new Version());
    }

    CRSResourceImpl(ResourceAttribute attr, Version version) throws CRSException {
        this(null, attr, version);
    }

    CRSResourceImpl(CRSEntity sibling, ResourceAttribute attr, Version version) throws CRSException {
        super(sibling, CRSEntity.Type.Resource, attr.getValue());
        this.m_nameAttr = attr;
        this.m_version = version;
    }

    CRSResourceImpl(ResourceAttribute attr, Version version, EntityOperations.EntityOpsMode mode) throws CRSException {
        super(CRSEntity.Type.Resource, attr.getValue(), mode);
        this.m_nameAttr = attr;
        this.m_version = version;
    }

    CRSResourceImpl(ResourceAttribute attr, EntityOperations.EntityOpsMode mode) throws CRSException {
        this(attr, new Version(), mode);
    }

    CRSResourceImpl(ResourceAttribute attr, SnapshotImpl snapshot) throws CRSException {
        super(CRSEntity.Type.Resource, attr.getValue(), snapshot);
        this.m_nameAttr = attr;
        this.m_version = snapshot.getResourceVersion(attr.getValue());
    }

    @Override
    public String getName() throws CRSException {
        return this.m_nameAttr.getValue();
    }

    @Override
    public CRSResource.ResourceStatus getStatus() throws CRSException {
        return CRSNative.getStatus(this);
    }

    @Override
    public Map<String, List<String>> getDetailedState() throws CRSException {
        String lastServer = ResourceLiterals.CRS_LAST_SERVER.toString();
        String stDetails = ResourceLiterals.STATE_DETAILS.toString();
        String intState = ResourceLiterals.INTERNAL_STATE.toString();
        String state = ResourceLiterals.STATE_ATTR_NAME.toString();
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.LocalResource.NAME.name(), this.getName());
        Map<String, Map<String, String>> riData = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, false, nameFilter, lastServer, stDetails, intState, state);
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (String riId : riData.keySet()) {
            Map<String, String> tmp = riData.get(riId);
            String serverName = tmp.get(lastServer);
            String stateDetails = tmp.get(stDetails);
            String internalState = tmp.get(intState);
            String instState = tmp.get(state);
            Trace.out("serverName %s, stDetails %s, internalState %s state %s", serverName, stateDetails, internalState, instState);
            if (serverName == null || serverName.equals("")) continue;
            if (stateDetails == null) {
                stateDetails = "";
            }
            if (internalState == null) {
                internalState = "";
            }
            String string = instState = instState == null ? "" : instState;
            if (result.containsKey(serverName) && (!result.containsKey(serverName) || instState.equalsIgnoreCase("OFFLINE"))) continue;
            ArrayList<String> details = new ArrayList<String>(2);
            details.add(stateDetails);
            details.add(internalState);
            result.put(serverName, details);
        }
        return result;
    }

    @Override
    public Map<String, String> getStateDetails() throws CRSException {
        String lastServer = ResourceLiterals.CRS_LAST_SERVER.toString();
        String stDetails = ResourceLiterals.STATE_DETAILS.toString();
        String state = ResourceLiterals.STATE_ATTR_NAME.toString();
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.LocalResource.NAME.name(), this.getName());
        Map<String, Map<String, String>> riData = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, false, nameFilter, lastServer, stDetails, state);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String riId : riData.keySet()) {
            Map<String, String> tmp = riData.get(riId);
            String serverName = tmp.get(lastServer);
            String stateDetails = tmp.get(stDetails);
            String instState = tmp.get(state);
            Trace.out("serverName %s, stDetails %s, state %s", serverName, stateDetails, instState);
            if (serverName == null || serverName.equals("")) continue;
            if (stateDetails == null) {
                stateDetails = "";
            }
            String string = instState = instState == null ? "" : instState;
            if (result.containsKey(serverName) && (!result.containsKey(serverName) || instState.equalsIgnoreCase("OFFLINE"))) continue;
            result.put(serverName, stateDetails);
        }
        return result;
    }

    public Map<String, String> getInternalState() throws CRSException {
        String lastServer = ResourceLiterals.CRS_LAST_SERVER.toString();
        String intState = ResourceLiterals.INTERNAL_STATE.toString();
        CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
        Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.LocalResource.NAME.name(), this.getName());
        Map<String, Map<String, String>> riData = crsFactory.searchEntities(CRSEntity.Type.ResourceInstance, false, nameFilter, lastServer, intState);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String riId : riData.keySet()) {
            Map<String, String> tmp = riData.get(riId);
            String serverName = tmp.get(lastServer);
            String internalState = tmp.get(intState);
            Trace.out("serverName %s, internalState %s", serverName, internalState);
            if (serverName == null || serverName.equals("")) continue;
            if (internalState == null) {
                internalState = "";
            }
            result.put(serverName, internalState);
        }
        return result;
    }

    @Override
    public ResourcePermissions getPermissions() throws CRSException {
        return new ResourcePermissionsImpl(this);
    }

    @Override
    public ServerCategory.ServerCategoryType getServerCategory() throws CRSException {
        ResourceAttribute attr = this.getAttribute(ResourceLiterals.SERVER_CATEGORY_ATTR_NAME.toString());
        String category = attr.getValue();
        return ServerCategory.ServerCategoryType.getMember(category);
    }

    public boolean isRunning() throws CRSException {
        return this.getOperations().isResourceRunning(this);
    }

    public boolean isRunning(String nodeName) throws CRSException {
        return this.getOperations().isResourceRunning(this, nodeName);
    }

    @Override
    public List<Node> fetchRunningNodes() throws CRSException {
        return this.getOperations().fetchRunningNodes(this);
    }

    public HashMap<String, String> fetchLastServers() throws CRSException {
        return this.getOperations().fetchLastServers(this);
    }

    public HashMap<String, String> fetchRunningInstances() throws CRSException {
        return this.getOperations().fetchRunningInstances(this);
    }

    public String relocateInstanceId(String srcNode, String tgtNode) throws NotRunningException, CRSException {
        return this.getOperations().relocateInstanceId(this, srcNode, tgtNode);
    }

    @Override
    public String[] resourceInstanceIds(String srcNode) throws NotRunningException, CRSException {
        String[] runners = this.getOperations().resourceInstanceIds(this, srcNode);
        if (runners.length == 0) {
            throw new NotRunningException((MessageKey)PrCrMsgID.CRS_RES_NOT_RUNNING_NODE, this.getName(), srcNode);
        }
        return runners;
    }

    @Override
    public Map<Node, CRSResource.ResourceStatusOnNode> fetchStatusByNodes() throws CRSException {
        HashMap<Node, CRSResource.ResourceStatusOnNode> result = new HashMap<Node, CRSResource.ResourceStatusOnNode>();
        Map<String, CRSResource.ResourceStatusOnNode> statusByNodeNames = CRSNative.fetchStatusByNodesName(this);
        ServerFactoryImpl serverFactoryImpl = null;
        try {
            serverFactoryImpl = ServerFactoryImpl.getInstance();
        }
        catch (ServerException e) {
            throw new CRSException(e);
        }
        try {
            for (Map.Entry<String, CRSResource.ResourceStatusOnNode> entry : statusByNodeNames.entrySet()) {
                result.put(serverFactoryImpl.getNode(entry.getKey(), false), entry.getValue());
            }
        }
        catch (NodeException e) {
            throw new CRSException(e);
        }
        return result;
    }

    @Override
    public List<Node> fetchEnabledNodes() throws CRSException {
        return this.getEnabledNodes(true);
    }

    @Override
    public List<Node> fetchDisabledNodes() throws CRSException {
        return this.getEnabledNodes(false);
    }

    @Override
    public void enable() throws AlreadyEnabledException, CRSException {
        try {
            this.setEnableDisable(true);
        }
        catch (AlreadyDisabledException alreadyDisabledException) {
            // empty catch block
        }
    }

    public void enable(Node node) throws AlreadyEnabledException, CRSException, NodeException {
        try {
            this.setEnableDisable(node, true);
        }
        catch (AlreadyDisabledException alreadyDisabledException) {
            // empty catch block
        }
    }

    public void disable(Node node) throws AlreadyDisabledException, CRSException, NodeException {
        try {
            this.setEnableDisable(node, false);
        }
        catch (AlreadyEnabledException alreadyEnabledException) {
            // empty catch block
        }
    }

    void setEnableDisable(Node node, boolean bEnable) throws AlreadyEnabledException, AlreadyDisabledException, CRSException, NodeException {
        String nodeName = node.getName();
        String attrName = ResourceType.getPerXName(ResourceType.LocalResource.ENABLED.name(), nodeName);
        ResourceAttribute attr1 = new ResourceAttribute(attrName, String.valueOf(bEnable ? 1 : 0), false);
        try {
            ResourceAttribute attr2 = this.getAttribute(attrName);
            if (attr1.getValue().equalsIgnoreCase(attr2.getValue())) {
                if (bEnable) {
                    throw new AlreadyEnabledException((MessageKey)PrCrMsgID.RES_ALREADY_ENABLED_ON_NODES, this.m_nameAttr.getValue(), nodeName);
                }
                throw new AlreadyDisabledException((MessageKey)PrCrMsgID.RES_ALREADY_DISABLED_ON_NODES, this.m_nameAttr.getValue(), nodeName);
            }
        }
        catch (CRSAttributeNotFoundException e) {
            Trace.out("CRS RMperX enabled Attribute not found");
        }
        this.update(attr1);
    }

    @Override
    public void enable(int cardinalityID) throws AlreadyEnabledException, CRSException {
        try {
            this.setEnableDisable(cardinalityID, true);
        }
        catch (AlreadyDisabledException alreadyDisabledException) {
            // empty catch block
        }
    }

    @Override
    public void disable(int cardinalityID) throws AlreadyDisabledException, CRSException {
        try {
            this.setEnableDisable(cardinalityID, false);
        }
        catch (AlreadyEnabledException alreadyEnabledException) {
            // empty catch block
        }
    }

    void setEnableDisable(int cardinalityID, boolean bEnable) throws AlreadyEnabledException, AlreadyDisabledException, CRSException {
        ResourceAttribute attr1;
        block8: {
            String attrName = ResourceType.getPerXCardinalityName(ResourceType.LocalResource.ENABLED.name(), String.valueOf(cardinalityID));
            attr1 = new ResourceAttribute(attrName, String.valueOf(bEnable ? 1 : 0), false);
            try {
                ResourceAttribute attr2 = this.getAttribute(attrName);
                if (attr1.getValue().equalsIgnoreCase(attr2.getValue())) {
                    if (bEnable) {
                        throw new AlreadyEnabledException((MessageKey)PrCrMsgID.RES_ALREADY_ENABLED_PERX, String.valueOf(cardinalityID), this.m_nameAttr.getValue());
                    }
                    throw new AlreadyDisabledException((MessageKey)PrCrMsgID.RES_ALREADY_DISABLED_PERX, String.valueOf(cardinalityID), this.m_nameAttr.getValue());
                }
            }
            catch (CRSAttributeNotFoundException e) {
                Trace.out("CRS RMperX enabled Attribute not found");
                if (!bEnable) break block8;
                throw new AlreadyEnabledException((MessageKey)PrCrMsgID.RES_ALREADY_ENABLED_PERX, String.valueOf(cardinalityID), this.m_nameAttr.getValue());
            }
        }
        if (bEnable) {
            try {
                this.purgePerXCardinality(String.valueOf(cardinalityID), ResourceType.LocalResource.ENABLED.name());
            }
            catch (NotExistsException e) {
                throw new AlreadyEnabledException((MessageKey)PrCrMsgID.RES_ALREADY_ENABLED_PERX, String.valueOf(cardinalityID), this.m_nameAttr.getValue());
            }
        } else {
            this.update(attr1);
        }
    }

    @Override
    public void disable() throws AlreadyDisabledException, CRSException {
        try {
            this.setEnableDisable(false);
        }
        catch (AlreadyEnabledException alreadyEnabledException) {
            // empty catch block
        }
    }

    @Override
    public void start() throws AlreadyRunningException, CRSException {
        this.start(true);
    }

    public void start(boolean forceFlag) throws AlreadyRunningException, CRSException {
        this.start(forceFlag, new ResourceAttribute[0]);
    }

    public void start(ResourceAttribute[] startOptions) throws AlreadyRunningException, CRSException {
        this.start(true, startOptions);
    }

    public void start(boolean forceFlag, ResourceAttribute[] startOptions) throws AlreadyRunningException, CRSException {
        try {
            this.getOperations().startResource((CRSResource)this, forceFlag, null, startOptions);
        }
        catch (CRSException crse) {
            String m = crse.getMessage();
            if (m.contains("CRS-5702:") || m.contains("CRS-2552:") || m.contains("CRS-2528:")) {
                throw new AlreadyRunningException((MessageKey)PrCrMsgID.RES_ALREADY_RUNNING, (Throwable)crse, this.m_nameAttr.getValue());
            }
            throw crse;
        }
    }

    public String[] start(Node node) throws AlreadyRunningException, CRSException, NodeException {
        return this.start(node, new ResourceAttribute[0]);
    }

    public String[] start(Node node, ResourceAttribute[] startOptions) throws AlreadyRunningException, CRSException, NodeException {
        return this.start(true, node, startOptions);
    }

    public String[] start(boolean forceFlag, Node node, ResourceAttribute[] startOptions) throws AlreadyRunningException, CRSException, NodeException {
        String nodeName = "";
        try {
            nodeName = node.getName();
            return this.getOperations().startResource((CRSResource)this, forceFlag, nodeName, startOptions);
        }
        catch (CRSException crse) {
            if (crse.getMessage().contains("CRS-5702:") || crse.getMessage().contains("CRS-2552:") && !CRSNative.mayStartRIOnNode(this, node.getName())) {
                throw new AlreadyRunningException((MessageKey)PrCrMsgID.RES_ALREADY_RUNNING, (Throwable)crse, this.m_nameAttr.getValue());
            }
            throw crse;
        }
    }

    public String[] startInstance(int cardinalityID) throws AlreadyRunningException, CRSException {
        try {
            String instanceID = this.getInstanceID(cardinalityID);
            return this.getOperations().startInstance(this, instanceID, new ResourceAttribute[0]);
        }
        catch (CRSException crse) {
            if (crse.getMessage().contains("CRS-5702:") || crse.getMessage().contains("CRS-2552:")) {
                throw new AlreadyRunningException((MessageKey)PrCrMsgID.RES_ALREADY_RUNNING, (Throwable)crse, this.m_nameAttr.getValue());
            }
            throw crse;
        }
        catch (CompositeOperationException e) {
            Trace.out("CompositeOperationException was caught but ignored as it is infeasible");
            throw new CRSException(e);
        }
    }

    public String[] startInstance(int cardinalityID, Node node) throws AlreadyRunningException, CRSException, NodeException {
        try {
            String instanceID = this.getInstanceID(cardinalityID);
            return this.getOperations().startInstance(this, instanceID, node.getName(), new ResourceAttribute[0]);
        }
        catch (CRSException crse) {
            if (crse.getMessage().contains("CRS-5702:") || crse.getMessage().contains("CRS-2552:") && !CRSNative.mayStartRIOnNode(this, node.getName())) {
                throw new AlreadyRunningException((MessageKey)PrCrMsgID.RES_ALREADY_RUNNING, (Throwable)crse, this.m_nameAttr.getValue());
            }
            throw crse;
        }
        catch (CompositeOperationException e) {
            Trace.out("CompositeOperationException was caught but ignored as it is infeasible");
            throw new CRSException(e);
        }
    }

    public String[] stopInstance(int cardinalityID) throws AlreadyStoppedException, CRSException {
        try {
            String instanceID = this.getInstanceID(cardinalityID);
            return this.getOperations().stopInstance(this, instanceID, true, new ResourceAttribute[0]);
        }
        catch (CRSException crse) {
            if (crse.getMessage().contains("CRS-2500:")) {
                throw new AlreadyStoppedException((MessageKey)PrCrMsgID.RES_ALREADY_STOPPED, (Throwable)crse, this.m_nameAttr.getValue());
            }
            throw crse;
        }
        catch (CompositeOperationException e) {
            Trace.out("CompositeOperationException was caught but ignored as it is infeasible");
            throw new CRSException(e);
        }
    }

    @Override
    public void stop(boolean force) throws AlreadyStoppedException, CRSException {
        this.stop(force, true);
    }

    @Override
    public void stop(boolean force, boolean keepDepTgt) throws AlreadyStoppedException, CRSException {
        this.stop(force, keepDepTgt, new ResourceAttribute[0]);
    }

    public void stop(boolean force, ResourceAttribute[] stopOptions) throws AlreadyStoppedException, CRSException {
        this.stop(force, true, stopOptions);
    }

    public void stop(boolean force, boolean keepDepTgt, ResourceAttribute[] stopOptions) throws AlreadyStoppedException, CRSException {
        try {
            this.getOperations().stopResource((CRSResource)this, force, keepDepTgt, stopOptions);
        }
        catch (CRSException crse) {
            if (crse.getMessage().contains("CRS-2500:")) {
                throw new AlreadyStoppedException((MessageKey)PrCrMsgID.RES_ALREADY_STOPPED, (Throwable)crse, this.m_nameAttr.getValue());
            }
            throw crse;
        }
    }

    public void stop(Node node, boolean force) throws AlreadyStoppedException, CRSException, NodeException {
        this.stop(node, force, new ResourceAttribute[0]);
    }

    public void stop(Node node, boolean force, ResourceAttribute[] stopOptions) throws AlreadyStoppedException, CRSException, NodeException {
        this.stop(node, force, false, stopOptions);
    }

    public void stop(Node node, boolean force, boolean keepDepTgt, ResourceAttribute[] stopOptions) throws AlreadyStoppedException, CRSException, NodeException {
        try {
            this.getOperations().stopResource((CRSResource)this, node.getName(), force, keepDepTgt, stopOptions);
        }
        catch (CRSException crse) {
            if (crse.getMessage().contains("CRS-2500:")) {
                throw new AlreadyStoppedException((MessageKey)PrCrMsgID.RES_ALREADY_STOPPED, (Throwable)crse, this.m_nameAttr.getValue());
            }
            throw crse;
        }
    }

    @Override
    public void check() throws CRSException {
        this.getOperations().checkResource(this);
    }

    public void check(Node node) throws NodeException, CRSException {
        String nodeName = node.getName();
        this.getOperations().checkResource(this, nodeName);
    }

    @Override
    public void remove(boolean force) throws CRSException {
        try {
            this.unregister(force);
        }
        catch (CRSException crse) {
            throw new CRSException((MessageKey)PrCrMsgID.RES_REMOVE_FAILED, (Throwable)crse, this.m_nameAttr.getValue());
        }
    }

    @Override
    public void enable(List<Node> nodeList) throws AlreadyEnabledException, CompositeOperationException, CRSException {
        int nodeCnt = nodeList.size();
        ExecutorService pool = Executors.newFixedThreadPool(nodeCnt);
        HashMap<Node, Future<String[]>> nodeMap = new HashMap<Node, Future<String[]>>();
        HashMap<Object, NativeResult> bugMap = new HashMap<Object, NativeResult>();
        for (Node node : nodeList) {
            nodeMap.put(node, pool.submit(new CallabeEnableRequest(this, node)));
        }
        this.checkResult(nodeList, nodeMap, bugMap);
        pool.shutdown();
        if (bugMap.isEmpty()) {
            return;
        }
        StringBuilder nodeNames = new StringBuilder();
        int alreadyEnableCnt = this.countExceptions(bugMap, AlreadyEnabledException.class, nodeNames);
        if (alreadyEnableCnt == nodeList.size()) {
            throw new AlreadyEnabledException((MessageKey)PrCrMsgID.RES_ALREADY_ENABLED, this.m_nameAttr.getValue());
        }
        throw new CompositeOperationException((MessageKey)PrCrMsgID.RES_ENABLE_FAILED, bugMap, this.m_nameAttr.getValue(), nodeNames.toString());
    }

    @Override
    public void disable(List<Node> nodeList) throws AlreadyDisabledException, CompositeOperationException, CRSException {
        int nodeCnt = nodeList.size();
        ExecutorService pool = Executors.newFixedThreadPool(nodeCnt);
        HashMap<Node, Future<String[]>> nodeMap = new HashMap<Node, Future<String[]>>();
        HashMap<Object, NativeResult> bugMap = new HashMap<Object, NativeResult>();
        for (Node node : nodeList) {
            nodeMap.put(node, pool.submit(new CallabeDisableRequest(this, node)));
        }
        this.checkResult(nodeList, nodeMap, bugMap);
        pool.shutdown();
        if (bugMap.isEmpty()) {
            return;
        }
        StringBuilder nodeNames = new StringBuilder();
        int alreadyDisableCnt = this.countExceptions(bugMap, AlreadyDisabledException.class, nodeNames);
        if (alreadyDisableCnt == nodeList.size()) {
            throw new AlreadyDisabledException((MessageKey)PrCrMsgID.RES_ALREADY_DISABLED, this.m_nameAttr.getValue());
        }
        throw new CompositeOperationException((MessageKey)PrCrMsgID.RES_DISABLE_FAILED, bugMap, this.m_nameAttr.getValue(), nodeNames.toString());
    }

    @Override
    public void enableCardinality(List<Integer> cardinalityList) throws AlreadyEnabledException, CompositeOperationException, CRSException {
        HashMap<Object, NativeResult> bugMap = new HashMap<Object, NativeResult>();
        ArrayList attrList = new ArrayList();
        int cardinalityCnt = cardinalityList.size();
        StringBuilder cardinalityIDNames = new StringBuilder();
        ArrayList<String> cardinalityIDList = new ArrayList<String>();
        for (int cardinalityID : cardinalityList) {
            String attrName = ResourceType.getPerXCardinalityName(ResourceType.LocalResource.ENABLED.name(), String.valueOf(cardinalityID));
            try {
                ResourceAttribute attr2 = this.getAttribute(attrName);
                cardinalityIDList.add(String.valueOf(cardinalityID));
            }
            catch (CRSAttributeNotFoundException e) {
                Trace.out("ENABLED@CARDINALITYID(" + cardinalityID + ") does not exist ==> It is already ENABLED.");
                NativeResult nativeResult = new NativeResult();
                nativeResult.setStatus(false);
                nativeResult.setException(new AlreadyEnabledException((MessageKey)PrCrMsgID.RES_ALREADY_ENABLED_PERX, String.valueOf(cardinalityID), this.m_nameAttr.getValue()));
                bugMap.put(cardinalityID, nativeResult);
                if (cardinalityIDNames.length() != 0) {
                    cardinalityIDNames.append(" ");
                }
                cardinalityIDNames.append(cardinalityID);
            }
        }
        Trace.out("List of cardinality ID per-X for ENABLED to be purged: " + cardinalityIDNames.toString());
        if (cardinalityIDList.size() > 0) {
            try {
                this.getOperations().purgeListPerXCardinality(this, cardinalityIDList, ResourceType.LocalResource.ENABLED.name());
            }
            catch (CRSException e) {
                Trace.out("CRSException in purge per-X for ENABLED: " + e.getMessage());
                throw new CRSException((MessageKey)PrCrMsgID.RES_ENABLE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
            catch (NotExistsException e) {
                throw new AlreadyEnabledException((MessageKey)PrCrMsgID.RES_ENABLE_FAILED, this.m_nameAttr.getValue(), cardinalityIDNames.toString());
            }
        }
        if (bugMap.size() > 0 && bugMap.size() == cardinalityList.size()) {
            throw new AlreadyEnabledException((MessageKey)PrCrMsgID.RES_ALREADY_ENABLED_ALL_PERX, this.m_nameAttr.getValue());
        }
        if (bugMap.size() > 0 && bugMap.size() != cardinalityList.size()) {
            throw new CompositeOperationException((MessageKey)PrCrMsgID.RES_ENABLE_FAILED, bugMap, this.m_nameAttr.getValue(), cardinalityIDNames.toString());
        }
    }

    @Override
    public void disableCardinality(List<Integer> cardinalityList) throws AlreadyDisabledException, CompositeOperationException, CRSException {
        String DISABLEZERO = String.valueOf(0);
        HashMap<Object, NativeResult> bugMap = new HashMap<Object, NativeResult>();
        int cardinalityCnt = cardinalityList.size();
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
        StringBuilder cardinalityIDNames = new StringBuilder();
        for (int cardinalityID : cardinalityList) {
            String attrName = ResourceType.getPerXCardinalityName(ResourceType.LocalResource.ENABLED.name(), String.valueOf(cardinalityID));
            ResourceAttribute attr1 = new ResourceAttribute(attrName, DISABLEZERO, false);
            try {
                ResourceAttribute attr2 = this.getAttribute(attrName);
                if (!attr1.getValue().equalsIgnoreCase(attr2.getValue())) continue;
                Trace.out("ENABLED@CARDINALITYID(" + cardinalityID + ") already exists ==> It is already DISABLED.");
                NativeResult nativeResult = new NativeResult();
                nativeResult.setStatus(false);
                nativeResult.setException(new AlreadyDisabledException((MessageKey)PrCrMsgID.RES_ALREADY_DISABLED_PERX, String.valueOf(cardinalityID), this.m_nameAttr.getValue()));
                bugMap.put(cardinalityID, nativeResult);
                if (cardinalityIDNames.length() != 0) {
                    cardinalityIDNames.append(" ");
                }
                cardinalityIDNames.append(cardinalityID);
            }
            catch (CRSAttributeNotFoundException e) {
                attrList.add(attr1);
            }
        }
        if (attrList.size() > 0) {
            try {
                this.update(true, attrList.toArray(new ResourceAttribute[attrList.size()]));
            }
            catch (CRSException e) {
                Trace.out("CRSException in update for setting per-X ENABLED to 0: " + e.getMessage());
                throw new CRSException((MessageKey)PrCrMsgID.RES_DISABLE_FAILED, (Throwable)e, this.m_nameAttr.getValue());
            }
        }
        if (bugMap.size() > 0 && bugMap.size() != cardinalityList.size()) {
            throw new CompositeOperationException((MessageKey)PrCrMsgID.RES_DISABLE_FAILED, bugMap, this.m_nameAttr.getValue(), cardinalityIDNames.toString());
        }
        if (bugMap.size() > 0 && bugMap.size() == cardinalityList.size()) {
            throw new AlreadyDisabledException((MessageKey)PrCrMsgID.RES_ALREADY_DISABLED_ALL_PERX, this.m_nameAttr.getValue());
        }
    }

    @Override
    public void start(List<Node> nodes) throws AlreadyRunningException, CompositeOperationException {
        this.start(true, nodes, new ResourceAttribute[0]);
    }

    public void start(boolean forceFlag, List<Node> nodeList) throws AlreadyRunningException, CompositeOperationException {
        this.start(forceFlag, nodeList, new ResourceAttribute[0]);
    }

    public void start(List<Node> nodeList, ResourceAttribute[] opts) throws AlreadyRunningException, CompositeOperationException {
        this.start(true, nodeList, opts);
    }

    @Override
    public void start(List<ServerPool> serverpools, boolean forceFlag, List<ResourceAttribute> opts) throws InvalidArgsException, AlreadyRunningException, CompositeOperationException, CRSException {
        if (serverpools == null || serverpools.contains(null) || opts == null || opts.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "crsResourceImpl-start in pools");
        }
        try {
            this.validateServerPools(serverpools);
        }
        catch (NotRunningException e) {
            throw new CRSException(e);
        }
        ResourceAttribute[] optsArr = opts.toArray(new ResourceAttribute[opts.size()]);
        this.getOperations().startResource((CRSResource)this, serverpools, forceFlag, optsArr);
    }

    public void start(boolean forceFlag, List<Node> nodeList, ResourceAttribute[] opts) throws AlreadyRunningException, CompositeOperationException {
        int nodeCnt = nodeList.size();
        ExecutorService pool = Executors.newFixedThreadPool(nodeCnt);
        HashMap<Node, Future<String[]>> nodeMap = new HashMap<Node, Future<String[]>>();
        HashMap<Object, NativeResult> bugMap = new HashMap<Object, NativeResult>();
        for (Node node : nodeList) {
            nodeMap.put(node, pool.submit(new CallabeStartRequest(this, forceFlag, node, opts)));
        }
        this.checkResult(nodeList, nodeMap, bugMap);
        pool.shutdown();
        if (bugMap.isEmpty()) {
            return;
        }
        StringBuilder nodeNames = new StringBuilder();
        int alreadyRunningExceptionCnt = this.countExceptions(bugMap, AlreadyRunningException.class, nodeNames);
        if (alreadyRunningExceptionCnt == nodeList.size()) {
            throw new AlreadyRunningException((MessageKey)PrCrMsgID.RES_ALREADY_RUNNING, this.m_nameAttr.getValue());
        }
        throw new CompositeOperationException((MessageKey)PrCrMsgID.RES_START_FAILED, bugMap, this.m_nameAttr.getValue(), nodeNames.toString());
    }

    @Override
    public void stop(List<Node> nodes, boolean force) throws AlreadyStoppedException, CompositeOperationException, CRSException {
        this.stop(nodes, force, new ResourceAttribute[0]);
    }

    public void stop(List<Node> nodes, boolean force, boolean keepDepTgt) throws AlreadyStoppedException, CompositeOperationException, CRSException {
        this.stop(nodes, force, keepDepTgt, new ResourceAttribute[0]);
    }

    public void stop(List<Node> nodeList, boolean forceFlag, ResourceAttribute[] opts) throws AlreadyStoppedException, CompositeOperationException, CRSException {
        this.stop(nodeList, forceFlag, false, opts);
    }

    @Override
    public void stop(List<ServerPool> serverpools, List<ResourceAttribute> opts, boolean force, boolean keepDepTgt) throws InvalidArgsException, AlreadyStoppedException, NotRunningException, CompositeOperationException, CRSException {
        if (serverpools == null || serverpools.contains(null) || opts == null || opts.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "crsResourceImpl-stop in pools");
        }
        this.validateServerPools(serverpools);
        ResourceAttribute[] optsArr = opts.toArray(new ResourceAttribute[opts.size()]);
        this.getOperations().stopResource((CRSResource)this, serverpools, force, keepDepTgt, optsArr);
    }

    public void stop(List<Node> nodeList, boolean forceFlag, boolean keepDepTgt, ResourceAttribute[] opts) throws AlreadyStoppedException, CompositeOperationException, CRSException {
        if (nodeList == null || nodeList.size() == 0) {
            Trace.out("Null or empty nodeList is passed in: " + nodeList);
            throw new CRSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        int nodeCnt = nodeList.size();
        ExecutorService pool = Executors.newFixedThreadPool(nodeCnt);
        HashMap<Node, Future<String[]>> nodeMap = new HashMap<Node, Future<String[]>>();
        HashMap<Object, NativeResult> bugMap = new HashMap<Object, NativeResult>();
        for (Node node : nodeList) {
            nodeMap.put(node, pool.submit(new CallabeStopRequest(this, forceFlag, keepDepTgt, node, opts)));
        }
        this.checkResult(nodeList, nodeMap, bugMap);
        pool.shutdown();
        if (bugMap.isEmpty()) {
            return;
        }
        StringBuilder nodeNames = new StringBuilder();
        int alreadyStoppedExceptionCnt = this.countExceptions(bugMap, AlreadyStoppedException.class, nodeNames);
        if (alreadyStoppedExceptionCnt == nodeList.size()) {
            throw new AlreadyStoppedException((MessageKey)PrCrMsgID.RES_ALREADY_STOPPED, this.m_nameAttr.getValue());
        }
        throw new CompositeOperationException((MessageKey)PrCrMsgID.RES_STOP_FAILED, bugMap, this.m_nameAttr.getValue(), nodeNames.toString());
    }

    public void purgePerX(String nodeName, String ... attrNames) throws NotExistsException, CRSException {
        this.getOperations().purgePerX(this, nodeName, attrNames);
    }

    public void purgePerXCardinality(String cardinalityID, String ... attrNames) throws NotExistsException, CRSException {
        this.getOperations().purgePerXCardinality(this, cardinalityID, attrNames);
    }

    public void purgePerX(String[] attrNames) throws NotExistsException, CRSException {
        this.getOperations().purgePerX((CRSResource)this, attrNames);
    }

    public void purgePerXbyValue(String attrValue, String ... attrNames) throws CRSException {
        this.getOperations().purgePerXbyValue(this, attrValue, attrNames);
    }

    @Override
    public void remove(List<Node> nodes, boolean force) throws NotExistsException, CompositeOperationException, CRSException {
        throw new CRSException((MessageKey)PrCrMsgID.RES_REMOVE_PERX_FAILED, this.m_nameAttr.getValue(), "NOT IMPLEMENTED YET");
    }

    @Override
    public String getEnv(String varName) throws CRSException {
        return this.getEnv().get(varName);
    }

    @Override
    public Map<String, String> getEnv() throws CRSException {
        HashMap<String, String> envMap = new HashMap<String, String>();
        ResourceAttribute attr = this.getAttribute(ResourceType.LocalResource.USR_ORA_ENV.name());
        Trace.out("attr value is " + attr.getValue());
        Matcher matcher = Pattern.compile("((\\w+\\s*)=([^\"]\\S*|\".+?\")\\s*)|(\\w+\\s*)=").matcher(attr.getValue());
        while (matcher.find()) {
            String[] nvPairs = matcher.group(0).split("=", 2);
            if (nvPairs.length == 2) {
                String val = nvPairs[1].trim();
                int len = val.length();
                if (!val.isEmpty() && val.charAt(0) == '\"' && val.charAt(len - 1) == '\"') {
                    val = val.substring(1, len - 1);
                }
                envMap.put(nvPairs[0].trim(), val);
                continue;
            }
            if (nvPairs.length == 1) {
                envMap.put(nvPairs[0].trim(), "");
                continue;
            }
            throw new CRSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, attr.getName(), attr.getValue(), matcher.group(0));
        }
        return envMap;
    }

    @Override
    public void setEnv(Map<String, String> envMap) throws CRSException {
        StringBuilder sb = new StringBuilder();
        for (String key : envMap.keySet()) {
            String value;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if ((value = envMap.get(key).trim()).indexOf(" ") >= 0) {
                sb.append(key.trim() + "=" + "\"" + value + "\"");
                continue;
            }
            sb.append(key.trim() + "=" + value);
        }
        ResourceAttribute attr = new ResourceAttribute(ResourceType.LocalResource.USR_ORA_ENV.name(), sb.toString());
        this.update(attr);
    }

    @Override
    public void setPermissions(ResourcePermissions permissions) throws CRSException {
        this.setPermissions(permissions, false);
    }

    @Override
    public void setPermissions(ResourcePermissions permissions, boolean force) throws CRSException {
        ResourceAttribute attr = new ResourceAttribute(ResourceLiterals.ACL_ATTR.toString(), ((ResourcePermissionsImpl)permissions).getAclString());
        this.update(force, attr);
    }

    public void adjustPermissions() throws CRSException {
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            try {
                boolean setFlag = false;
                NodeApps nodeApps = new NodeApps(Cluster.getLocalNode());
                String userName = nodeApps.getUserName();
                String groupName = nodeApps.getGroupName();
                ResourcePermissionsImpl per = (ResourcePermissionsImpl)this.getPermissions();
                if (!per.getOwner().equals(userName)) {
                    per.setPerm(ResourceType.ACL.USER, userName, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
                    setFlag = true;
                }
                if (!per.getGroup().equals(groupName)) {
                    per.setPerm(ResourceType.ACL.GROUP, groupName, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
                    setFlag = true;
                }
                if (setFlag) {
                    this.setPermissions(per);
                }
            }
            catch (ClusterException ce) {
                throw new CRSException((MessageKey)PrCrMsgID.RES_SETPERM_FAILED, (Throwable)ce, this.getName());
            }
            catch (NodeException ne) {
                throw new CRSException((MessageKey)PrCrMsgID.RES_SETPERM_FAILED, (Throwable)ne, this.getName());
            }
        }
    }

    @Override
    public List<CRSResource> dependentCRSResources() throws CRSException {
        ResourceAttribute stAttr = this.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
        ResourceAttribute spAttr = this.getAttribute(ResourceType.LocalResource.STOP_DEPENDENCIES.name());
        throw new CRSException((MessageKey)PrCrMsgID.RES_ATTR_NOT_EXISTS, this.m_nameAttr.getValue(), "NOT IMPLEMENTED YET");
    }

    void setEnableDisable(boolean bEnable) throws AlreadyEnabledException, AlreadyDisabledException, CRSException {
        this.getOperations().setEnableDisable(this, bEnable);
    }

    public Version version() throws CRSException {
        try {
            if (!this.isRegistered()) {
                return this.m_version;
            }
            ResourceAttribute attr = this.getAttribute(ResourceType.LocalResource.VERSION.name());
            return Version.getVersion(attr.getValue().trim());
        }
        catch (ConfigurationException e) {
            throw new CRSException((MessageKey)PrCrMsgID.RES_GETVERSION_FAILED, (Throwable)e, this.m_nameAttr.getValue());
        }
    }

    @Override
    public ResourceAttribute getAttribute(String attribute) throws CRSException {
        List<ResourceAttribute> ral = this.getOperations().getResourceStat(this, null, attribute);
        if (ral.size() == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.RES_ATTR_NOT_EXISTS, attribute, this.m_nameAttr.getValue());
        }
        return ral.get(0);
    }

    public List<ResourceAttribute> getCurrentAttributes(String nodeName, String ... attrNames) throws CRSAttributeNotFoundException, CRSException {
        return this.getOperations().getProcessedStat(this, nodeName, attrNames);
    }

    @Override
    public void requestAction(String actionName, ActionAttribute[] attrs, Node[] nodes, boolean async, boolean queue, ActionListener lsnr) throws CompositeActionException {
        this.getOperations().requestAction(this, actionName, attrs, nodes, async, queue, lsnr);
    }

    @Override
    public void requestAction(String actionName, ActionAttribute[] attrs) throws CompositeActionException {
        this.requestAction(actionName, attrs, null, false, true, null);
    }

    @Override
    public void requestAction(String actionName, ActionAttribute[] attrs, Node[] nodes) throws CompositeActionException {
        this.requestAction(actionName, attrs, nodes, false, true, null);
    }

    @Override
    public void requestAction(String actionName, ActionAttribute[] attrs, ActionListener lsnr) throws CompositeActionException {
        this.requestAction(actionName, attrs, null, false, true, lsnr);
    }

    @Override
    public void requestAction(String actionName, ActionAttribute[] attrs, Node[] nodes, ActionListener lsnr) throws CompositeActionException {
        this.requestAction(actionName, attrs, nodes, false, true, lsnr);
    }

    List<String> getPerXModifier(String attrName, String attrSuffix, String refValue) throws CRSException {
        LinkedList<String> result = new LinkedList<String>();
        String pattern = attrName + ResourceLiterals.AT.toString() + attrSuffix + '(';
        int index1 = pattern.length() - 1;
        List<ResourceAttribute> list = this.getAttributes(new String[0]);
        Trace.out("pattern: %s, attrLen %d", pattern, list.size());
        for (ResourceAttribute attr : list) {
            int index2;
            String aName = attr.getName();
            String aValue = attr.getValue();
            if (!aName.startsWith(pattern) || (index2 = aName.indexOf(41, index1)) == -1 || refValue != null && !refValue.equalsIgnoreCase(aValue)) continue;
            String modifier = aName.substring(index1 + 1, index2);
            Trace.out("aName %s, aValue %s, modifier %s", aName, aValue, modifier);
            result.add(modifier);
        }
        return result;
    }

    private List<Node> getEnabledNodes(boolean enabled) throws CRSException {
        LinkedList<Node> result = new LinkedList<Node>();
        List<String> nodeNames = this.getPerXModifier(ResourceType.LocalResource.ENABLED.name(), ResourceLiterals.SERVERNAME.name(), String.valueOf(enabled ? 1 : 0));
        try {
            ServerFactoryImpl serverFactoryImpl = ServerFactoryImpl.getInstance();
            for (String name : nodeNames) {
                result.add(serverFactoryImpl.getNode(name, false));
            }
        }
        catch (ServerException e) {
            throw new CRSException(e);
        }
        catch (NodeException e) {
            throw new CRSException(e);
        }
        return result;
    }

    private void checkResultCardinality(List<Integer> cardinalityList, Map<Integer, Future<String[]>> cardinalityMap, Map<Integer, NativeResult> bugMap) {
        Exception ex = null;
        String[] output = null;
        for (int cardinalityID : cardinalityList) {
            ex = null;
            try {
                output = cardinalityMap.get(cardinalityID).get();
            }
            catch (InterruptedException e) {
                ex = e;
            }
            catch (ExecutionException e) {
                ex = (Exception)e.getCause();
            }
            if (ex == null) continue;
            NativeResult nativeResult = new NativeResult();
            nativeResult.setStatus(false);
            nativeResult.setException(ex);
            bugMap.put(cardinalityID, nativeResult);
        }
    }

    private void checkResult(List<Node> nodeList, Map<Node, Future<String[]>> nodeMap, Map<Node, NativeResult> bugMap) {
        Exception ex = null;
        String[] output = null;
        for (Node node : nodeList) {
            ex = null;
            try {
                output = nodeMap.get(node).get();
            }
            catch (InterruptedException e) {
                ex = e;
            }
            catch (ExecutionException e) {
                ex = (Exception)e.getCause();
            }
            if (ex == null) continue;
            NativeResult nativeResult = new NativeResult();
            nativeResult.setStatus(false);
            nativeResult.setException(ex);
            bugMap.put(node, nativeResult);
        }
    }

    private int countExceptions(Map<Node, NativeResult> bugMap, Class exception2check, StringBuilder sb) {
        int exceptionCnt = 0;
        for (Node node : bugMap.keySet()) {
            String nodeName = BAD_NODE_NAME;
            Exception ex = bugMap.get(node).getException();
            if (ex.getClass().isAssignableFrom(exception2check)) {
                ++exceptionCnt;
            }
            try {
                nodeName = node.getName();
            }
            catch (NodeException nodeException) {
                // empty catch block
            }
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(nodeName);
        }
        return exceptionCnt;
    }

    private int countExceptionsCardinality(Map<Integer, NativeResult> bugMap, Class exception2check, StringBuilder sb) {
        int exceptionCnt = 0;
        for (int cardinalityID : bugMap.keySet()) {
            String nodeName = BAD_NODE_NAME;
            Exception ex = bugMap.get(cardinalityID).getException();
            if (ex.getClass().isAssignableFrom(exception2check)) {
                ++exceptionCnt;
            }
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(cardinalityID);
        }
        return exceptionCnt;
    }

    private String getInstanceID(int cardinalityID) {
        return this.m_nameAttr.getValue() + " " + String.valueOf(cardinalityID) + " 1";
    }

    public void validateServerPools(List<ServerPool> spList) throws InvalidArgsException, NotRunningException, CRSException {
        if (spList == null || spList.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "crsResourceImpl-validateServerPools");
        }
        try {
            String[] poolsArr = this.serverPoolsHelper();
            if (poolsArr == null || poolsArr.length == 0) {
                throw new NotRunningException((MessageKey)PrCrMsgID.RES_NOT_HOSTED_BY_SRVPOOL, this.getName(), Utils.list2String(spList, ","));
            }
            List<String> pools = Arrays.asList(poolsArr);
            for (ServerPool sp : spList) {
                if (!pools.contains(sp.getName())) {
                    throw new NotRunningException((MessageKey)PrCrMsgID.RES_NOT_HOSTED_BY_SRVPOOL, this.getName(), sp.getUserAssignedName());
                }
                List<Server> servers = sp.servers();
                if (servers != null && !servers.isEmpty()) continue;
                throw new NotRunningException((MessageKey)PrCdMsgID.NO_ACTIVE_SERVERS_IN_SP, sp.getUserAssignedName());
            }
        }
        catch (ServerGroupException e) {
            throw new CRSException(e);
        }
    }

    protected String[] serverPoolsHelper() throws CRSException {
        String sgNameList = "";
        try {
            ResourceAttribute attr = this.getAttribute(ResourceType.Database.SERVER_POOLS.name());
            sgNameList = attr.getValue().trim();
            Trace.out("list of server pool names =" + sgNameList);
            return sgNameList.split(Pattern.quote(String.valueOf(" ")));
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, sgNameList, this.getName());
        }
    }

    public static class CallabeCardinalityEnableRequest
    extends CallableRequest {
        int m_cardinalityID = 0;

        public CallabeCardinalityEnableRequest(CRSResourceImpl resource, int cardinalityID) {
            super(resource, null);
            this.m_cardinalityID = cardinalityID;
        }

        @Override
        public String[] call() throws CRSException, NodeException, AlreadyEnabledException {
            long startTime = System.currentTimeMillis();
            this.m_resource.enable(this.m_cardinalityID);
            long stopTime = System.currentTimeMillis();
            Trace.out("execution time: " + (stopTime - startTime));
            return this.m_output;
        }
    }

    public static class CallabeCardinalityDisableRequest
    extends CallableRequest {
        int m_cardinalityID = 0;

        public CallabeCardinalityDisableRequest(CRSResourceImpl resource, int cardinalityID) {
            super(resource, null);
            this.m_cardinalityID = cardinalityID;
        }

        @Override
        public String[] call() throws CRSException, NodeException, AlreadyDisabledException {
            long startTime = System.currentTimeMillis();
            this.m_resource.disable(this.m_cardinalityID);
            long stopTime = System.currentTimeMillis();
            Trace.out("execution time: " + (stopTime - startTime));
            return this.m_output;
        }
    }

    public static class CallabeEnableRequest
    extends CallableRequest {
        public CallabeEnableRequest(CRSResourceImpl resource, Node node) {
            super(resource, node);
        }

        @Override
        public String[] call() throws CRSException, NodeException, AlreadyEnabledException {
            long startTime = System.currentTimeMillis();
            this.m_resource.enable(this.m_node);
            long stopTime = System.currentTimeMillis();
            Trace.out("execution time: " + (stopTime - startTime));
            return this.m_output;
        }
    }

    public static class CallabeDisableRequest
    extends CallableRequest {
        public CallabeDisableRequest(CRSResourceImpl resource, Node node) {
            super(resource, node);
        }

        @Override
        public String[] call() throws CRSException, NodeException, AlreadyDisabledException {
            long startTime = System.currentTimeMillis();
            this.m_resource.disable(this.m_node);
            long stopTime = System.currentTimeMillis();
            Trace.out("execution time: " + (stopTime - startTime));
            return this.m_output;
        }
    }

    public static class CallabeStopRequest
    extends CallableRequest {
        private boolean m_forceFlag;
        private boolean m_keepDepTgt;
        private ResourceAttribute[] m_opts;

        public CallabeStopRequest(CRSResourceImpl resource, boolean forceFlag, boolean keepDepTgt, Node node, ResourceAttribute[] opts) {
            super(resource, node);
            this.m_forceFlag = forceFlag;
            this.m_opts = opts;
            this.m_keepDepTgt = keepDepTgt;
        }

        @Override
        public String[] call() throws CRSException, NodeException, AlreadyStoppedException {
            long startTime = System.currentTimeMillis();
            this.m_resource.stop(this.m_node, this.m_forceFlag, this.m_keepDepTgt, this.m_opts);
            long stopTime = System.currentTimeMillis();
            Trace.out("execution time: " + (stopTime - startTime));
            return this.m_output;
        }
    }

    public static class CallabeStartRequest
    extends CallableRequest {
        private boolean m_forceFlag;
        private ResourceAttribute[] m_opts;

        public CallabeStartRequest(CRSResourceImpl resource, boolean forceFlag, Node node, ResourceAttribute[] opts) {
            super(resource, node);
            this.m_forceFlag = forceFlag;
            this.m_opts = opts;
        }

        @Override
        public String[] call() throws CRSException, NodeException, AlreadyRunningException {
            long startTime = System.currentTimeMillis();
            this.m_output = this.m_resource.start(this.m_forceFlag, this.m_node, this.m_opts);
            long stopTime = System.currentTimeMillis();
            Trace.out("execution time: " + (stopTime - startTime));
            return this.m_output;
        }
    }

    public static abstract class CallableRequest
    implements Callable<String[]> {
        Node m_node = null;
        CRSResourceImpl m_resource;
        String[] m_output = new String[0];

        CallableRequest(CRSResourceImpl resource, Node node) {
            this.m_node = node;
            this.m_resource = resource;
        }
    }
}

