/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.ActionAttribute;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSFactory;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.ClusterResource;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.crs.CompositeActionStatus;
import oracle.cluster.crs.OracleCMCluster;
import oracle.cluster.crs.Relocatable;
import oracle.cluster.crs.VendorCluster;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.crs.ActionListenerImpl;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSConfigPolicyEntity;
import oracle.cluster.impl.crs.CRSConfigPolicySetEntity;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.CRSResourceTypeEntity;
import oracle.cluster.impl.crs.CRSServerCategoryEntity;
import oracle.cluster.impl.crs.CRSServerEntity;
import oracle.cluster.impl.crs.CRSServerGroupEntity;
import oracle.cluster.impl.crs.ClusterResourceImpl;
import oracle.cluster.impl.crs.CompositeActionStatusImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.OracleCMClusterImpl;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.ResourceUpgradeAttribute;
import oracle.cluster.impl.crs.VendorClusterImpl;
import oracle.cluster.impl.crs.cops.CRSCache;
import oracle.cluster.impl.crs.cops.CRSCompositeOperationException;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.crs.cops.RTEArg;
import oracle.cluster.impl.crs.cops.RTENativeException;
import oracle.cluster.impl.crs.cops.RTENativeResult;
import oracle.cluster.impl.crs.cops.SimpleFilter;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.scan.ScanFactoryImpl;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class CRSFactoryImpl {
    private static CRSFactoryImpl s_instance;
    private static boolean s_upgradeMode;
    private CRSFactory.CRSCacheMode m_crsCacheMode = CRSFactory.CRSCacheMode.None;
    private NativeSystem m_nativeSystem = new SystemFactory().CreateSystem();
    public static final String[] RUNNING_STATES;

    private CRSFactoryImpl() throws CRSException {
    }

    public static synchronized CRSFactoryImpl getInstance() throws CRSException {
        if (null == s_instance) {
            s_instance = new CRSFactoryImpl();
        }
        return s_instance;
    }

    public ResourcePermissionsImpl getPermissions(String resName, String aclValue) throws CRSException {
        return new ResourcePermissionsImpl(resName, aclValue);
    }

    public ResourcePermissionsImpl createPerm(ResourceType.ACL_CREATOR creator) throws CRSException {
        try {
            return new ResourcePermissionsImpl(creator);
        }
        catch (ClusterException e) {
            throw new CRSException(e);
        }
        catch (NodeException e) {
            throw new CRSException(e);
        }
        catch (UtilException e) {
            throw new CRSException(e);
        }
    }

    public String createActionsAttr(String resName, String acl, String actionsTemp) throws CRSException {
        try {
            Trace.out("Creating ACTIONS attribute for resource " + resName);
            ArrayList<String> users = new ArrayList<String>();
            ArrayList<String> groups = new ArrayList<String>();
            List<String> aclUsers = null;
            List<String> aclGroups = null;
            if (acl != null && acl.trim().length() != 0) {
                Trace.out((Object)"ACL is : %s", acl);
                ResourcePermissionsImpl resPerm = this.getPermissions(resName, acl);
                aclUsers = resPerm.getUsers();
                String owner = resPerm.getOwner();
                if (!aclUsers.contains(owner)) {
                    Trace.out("Add owner to users: " + owner);
                    aclUsers.add(owner);
                }
                aclGroups = resPerm.getGroups();
            }
            Util util = new Util();
            String crsUser = util.getOracleUser(util.getCRSHome(), null);
            String[] actionTempArr = actionsTemp.split(" ");
            HashMap<String, ResourcePermissionsImpl> perms = new HashMap<String, ResourcePermissionsImpl>();
            for (String actionTemp : actionTempArr) {
                Trace.out((Object)"action perm rte: %s", actionTemp);
                String[] actionItems = actionTemp.split(",");
                int actionItemsLen = actionItems.length;
                if (actionItemsLen <= 1) {
                    Trace.out("Invalid Action template : " + actionTemp);
                    throw new CRSException((MessageKey)PrCcMsgID.INVALID_VALUE_FOR_PARAM, "actionsTemp", actionsTemp);
                }
                String actionName = actionItems[0];
                for (int i = 1; i < actionItemsLen; ++i) {
                    if (actionItems[i].equals(ResourceLiterals.ACTION_CRS_USER.toString()) && !users.contains(crsUser)) {
                        users.add(crsUser);
                    }
                    if (actionItems[i].equals(ResourceLiterals.ACTION_ACL_USERS.toString())) {
                        for (String aclUser : aclUsers) {
                            if (users.contains(aclUser)) continue;
                            users.add(aclUser);
                        }
                    }
                    if (!actionItems[i].equals(ResourceLiterals.ACTION_ACL_GROUPS.toString())) continue;
                    for (String aclGroup : aclGroups) {
                        if (groups.contains(aclGroup)) continue;
                        groups.add(aclGroup);
                    }
                }
                ResourcePermissionsImpl actionPerm = this.createPerm4ActionOp(users, groups);
                Trace.out("Created permission object for actions: " + actionPerm.getAclString());
                perms.put(actionName, actionPerm);
            }
            return ResourcePermissionsImpl.createActionsAttrValue(perms);
        }
        catch (UtilException e) {
            Trace.out("UtilException : " + (Object)((Object)e));
            throw new CRSException(e);
        }
        catch (InvalidArgsException e) {
            Trace.out("InvalidArgsException : " + e);
            throw new CRSException(e);
        }
    }

    public ResourcePermissionsImpl createPerm4ActionOp(List<String> users, List<String> groups) throws InvalidArgsException, CRSException {
        return new ResourcePermissionsImpl(users, groups);
    }

    public ResourcePermissionsImpl createPerm(CRSResourceImpl res) throws CRSException {
        return new ResourcePermissionsImpl(res);
    }

    public ResourceAttribute create(String name, String value) throws CRSException {
        return new ResourceAttribute(name, value);
    }

    public ResourceDependency createResourceDependency(ResourceAttribute nameAttr, ResourceDependency.DepType depType, ResourceDependency.DepModifier ... depModifiers) throws CRSException {
        return new ResourceDependency(nameAttr, depType, depModifiers);
    }

    public CRSEntity create(CRSEntity.Type type, List<ResourceAttribute> list) throws AlreadyExistsException, CRSException {
        if (this.m_nativeSystem.isUnixSystem()) {
            return this.createhelper(type, list);
        }
        Trace.out("Create windows resource using NT AUTHORITY\\SYSTEM as owner");
        return this.create(type, list, ResourceType.ACL_CREATOR.DB_USER);
    }

    public CRSEntity create(CRSEntity.Type type, List<ResourceAttribute> list, boolean force) throws AlreadyExistsException, CRSException {
        return this.createhelper(type, list, force);
    }

    public CRSEntity create(CRSEntity.Type type, List<ResourceAttribute> list, ResourceType.ACL_CREATOR creator) throws AlreadyExistsException, CRSException {
        return this.create(type, list, creator, false);
    }

    public CRSEntity create(CRSEntity.Type type, List<ResourceAttribute> list, ResourceType.ACL_CREATOR creator, boolean ntAddOraInstall) throws AlreadyExistsException, CRSException {
        return this.create(type, list, creator, ntAddOraInstall, false);
    }

    public CRSEntity create(CRSEntity.Type type, List<ResourceAttribute> list, ResourceType.ACL_CREATOR creator, boolean ntAddOraInstall, boolean force) throws AlreadyExistsException, CRSException {
        ResourcePermissionsImpl perm = null;
        try {
            perm = new ResourcePermissionsImpl(creator);
            if (ntAddOraInstall) {
                perm.setPerm(ResourceType.ACL.GROUP, "ORA_INSTALL", ResourceType.ACL_PERM.EXECUTE, ResourceType.ACL_PERM.READ);
            }
        }
        catch (ClusterException e) {
            Trace.out(e);
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_REGISTER_ENT_FAILED, (Throwable)e, type.typeAsString(), this.getNameAttrValue(list));
        }
        catch (NodeException e) {
            Trace.out(e);
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_REGISTER_ENT_FAILED, (Throwable)e, type.typeAsString(), this.getNameAttrValue(list));
        }
        catch (UtilException e) {
            Trace.out((Exception)((Object)e));
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_REGISTER_ENT_FAILED, (Throwable)e, type.typeAsString(), this.getNameAttrValue(list));
        }
        catch (CRSException e) {
            Trace.out(e);
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_REGISTER_ENT_FAILED, (Throwable)e, type.typeAsString(), this.getNameAttrValue(list));
        }
        String acl = ResourceLiterals.ACL_ATTR.toString();
        String typeacl = ResourceLiterals.TYPE_ACL.toString();
        ResourceAttribute aclAttr = null;
        ResourceAttribute typeaclAttr = null;
        for (ResourceAttribute attr : list) {
            if (attr.getName().equalsIgnoreCase(acl)) {
                aclAttr = attr;
                aclAttr.setValue(perm.getAclString());
            }
            if (type != CRSEntity.Type.ResourceType || !attr.getName().equalsIgnoreCase(typeacl)) continue;
            typeaclAttr = attr;
            typeaclAttr.setValue(perm.getAclString());
        }
        if (aclAttr == null) {
            aclAttr = new ResourceAttribute(acl, perm.getAclString());
            list.add(aclAttr);
        }
        if (type == CRSEntity.Type.ResourceType && typeaclAttr == null) {
            typeaclAttr = new ResourceAttribute(typeacl, perm.getAclString());
            list.add(typeaclAttr);
        }
        return this.createhelper(type, list, force);
    }

    public CRSEntity ntCreateLsnrType(CRSEntity.Type type, List<ResourceAttribute> list) throws AlreadyExistsException, CRSException {
        boolean oraInstallFlag = true;
        if (this.m_nativeSystem.isUnixSystem()) {
            oraInstallFlag = false;
        }
        return this.create(type, list, ResourceType.ACL_CREATOR.DB_USER, oraInstallFlag);
    }

    public ResourceAttribute createSIHAResourceACL() throws CRSException {
        try {
            String ownerGroup;
            String ownerName;
            ResourcePermissionsImpl perm = new ResourcePermissionsImpl();
            Util utl = new Util();
            String curUserName = utl.getCurrentUser();
            String curUserPGroup = "";
            boolean isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
            if (isUnixSystem) {
                curUserPGroup = utl.getCurrentUserPrimaryGroup();
                String crshome = utl.getCRSHome();
                Trace.out("crshome = " + crshome);
                ownerName = utl.getOracleUser(crshome, null);
                ownerGroup = utl.getOracleGroup(crshome);
            } else {
                try {
                    curUserName = ownerName = utl.getOracleUser(utl.getCRSHome(), null);
                }
                catch (UtilException e) {
                    throw new CRSException(e);
                }
                ownerGroup = curUserPGroup;
            }
            perm.setPerm(ResourceType.ACL.OTHER, "", ResourceType.ACL_PERM.READ);
            perm.setPerm(ResourceType.ACL.OWNER, ownerName, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
            perm.setPerm(ResourceType.ACL.PGROUP, ownerGroup, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
            perm.setPerm(ResourceType.ACL.USER, curUserName, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.WRITE, ResourceType.ACL_PERM.EXECUTE);
            perm.setPerm(ResourceType.ACL.GROUP, curUserPGroup, ResourceType.ACL_PERM.READ, ResourceType.ACL_PERM.EXECUTE);
            ResourceAttribute aclAttr = new ResourceAttribute(ResourceLiterals.ACL_ATTR.toString(), perm.getAclString());
            Trace.out("attr = %s, value = %s", aclAttr.getName(), aclAttr.getValue());
            return aclAttr;
        }
        catch (UtilException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CREATE_RESOURCE_PERM_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public CRSServerCategoryEntity getServerCategory(String name) throws CRSException {
        return new CRSServerCategoryEntity(name);
    }

    public CRSServerCategoryEntity createCategory(String category, String activecssrole, Filter expression) throws AlreadyExistsException, CRSException {
        CRSServerCategoryEntity sc = new CRSServerCategoryEntity(category);
        return sc.create(activecssrole, expression);
    }

    public void createHubRimCategory() throws AlreadyExistsException, CRSException {
        Trace.out("Check hub, leaf category");
        if (!this.isRegistered(ResourceLiterals.HUB_CATEGORY.toString(), CRSEntity.Type.ServerCategory)) {
            Trace.out("Register hub category");
            this.createCategory(ResourceLiterals.HUB_CATEGORY.toString(), "hub", null);
        }
        if (!this.isRegistered(ResourceLiterals.RIM_CATEGORY.toString(), CRSEntity.Type.ServerCategory)) {
            Trace.out("Register leaf category");
            this.createCategory(ResourceLiterals.RIM_CATEGORY.toString(), "leaf", null);
        }
    }

    CRSEntity createhelper(CRSEntity.Type type, List<ResourceAttribute> list) throws AlreadyExistsException, CRSException {
        return this.createhelper(type, list, false);
    }

    CRSEntity createhelper(CRSEntity.Type type, List<ResourceAttribute> list, boolean force) throws AlreadyExistsException, CRSException {
        ResourceAttribute nameAttr = null;
        ArrayList<ResourceAttribute> myList = new ArrayList<ResourceAttribute>(list.size());
        myList.addAll(list);
        for (ResourceAttribute attr : myList) {
            if (!attr.getName().equalsIgnoreCase(ResourceType.LocalResource.NAME.name())) continue;
            nameAttr = new ResourceAttribute(attr.getName(), attr.getValue());
            myList.remove(attr);
            break;
        }
        if (nameAttr == null) {
            throw new CRSException((MessageKey)PrCrMsgID.RES_ATTR_NOT_EXISTS, ResourceType.LocalResource.NAME.name());
        }
        CRSEntity crsEnt = CRSEntity.getInstance(type, nameAttr);
        if (crsEnt.isRegistered()) {
            throw new AlreadyExistsException((MessageKey)PrCrMsgID.CRS_ENT_ALREADY_REGISTERED, crsEnt.typeAsString(), nameAttr.getValue());
        }
        crsEnt.register(myList, force);
        return crsEnt;
    }

    public CRSResource get(ResourceAttribute nameAttr) throws NotExistsException, CRSException {
        CRSResourceImpl crsRes = (CRSResourceImpl)CRSEntity.getInstance(CRSEntity.Type.Resource, nameAttr);
        if (!crsRes.isRegistered()) {
            throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, nameAttr.getValue());
        }
        return crsRes;
    }

    public CRSResource getRegisteredOrNot(ResourceAttribute nameAttr) throws CRSException {
        return (CRSResourceImpl)CRSEntity.getInstance(CRSEntity.Type.Resource, nameAttr);
    }

    public CRSResource getRegisteredOrNot(ResourceAttribute nameAttr, CRSEntity sibling) throws CRSException {
        return new CRSResourceImpl(sibling, nameAttr, new Version());
    }

    public CRSResource getResource(ResourceAttribute nameAttr, EntityOperations.EntityOpsMode mode) throws CRSException {
        return new CRSResourceImpl(nameAttr, mode);
    }

    public CRSResource getSnapshotResource(ResourceAttribute nameAttr, SnapshotImpl snapshot) throws CRSException {
        return new CRSResourceImpl(nameAttr, snapshot);
    }

    public CRSServerGroupEntity getServerPool(String spName, EntityOperations.EntityOpsMode mode) throws CRSException {
        return new CRSServerGroupEntity(spName, mode);
    }

    public CRSServerGroupEntity getSnapshotServerPool(String spName, SnapshotImpl snapshot) throws CRSException {
        return new CRSServerGroupEntity(spName, snapshot);
    }

    public CRSServerEntity getServer(String serverName) throws CRSException {
        return new CRSServerEntity(serverName);
    }

    public CRSServerEntity getSnapshotServer(String serverName, SnapshotImpl snapshot) throws CRSException {
        return new CRSServerEntity(serverName, snapshot);
    }

    public CRSServerEntity getServer(String serverName, EntityOperations.EntityOpsMode mode) throws CRSException {
        return new CRSServerEntity(serverName, mode);
    }

    public ClusterResource getClusterResource(ResourceAttribute resName) throws NotExistsException, CRSException {
        return this.getClusterResource(resName, true);
    }

    public ClusterResource getClusterResource(ResourceAttribute resName, boolean check) throws NotExistsException, CRSException {
        return this.getClusterResource(null, resName, check);
    }

    public ClusterResource getClusterResource(CRSEntity sibling, ResourceAttribute resName, boolean check) throws NotExistsException, CRSException {
        ClusterResourceImpl crsRes = null;
        crsRes = sibling == null ? new ClusterResourceImpl(resName) : new ClusterResourceImpl(sibling, resName);
        if (check && !crsRes.isRegistered()) {
            throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, resName.getValue());
        }
        return crsRes;
    }

    public Relocatable getRelocatable(ResourceAttribute resName) throws NotExistsException, CRSException {
        RelocatableImpl crsRes = new RelocatableImpl(resName);
        if (!crsRes.isRegistered()) {
            throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, resName.getValue());
        }
        return crsRes;
    }

    public CRSServerGroupEntity getServerGroup(String name) throws CRSException {
        return new CRSServerGroupEntity(name);
    }

    public CRSServerGroupEntity getServerGroup(String name, CRSEntity sibling) throws CRSException {
        return new CRSServerGroupEntity(sibling, name);
    }

    public CRSConfigPolicyEntity getConfigPolicy(String name) throws CRSException {
        return new CRSConfigPolicyEntity(name);
    }

    public CRSConfigPolicySetEntity getConfigPolicy() throws CRSException {
        return new CRSConfigPolicySetEntity();
    }

    public CRSConfigPolicyEntity getConfigPolicy(String polName, EntityOperations.EntityOpsMode mode) throws CRSException {
        return new CRSConfigPolicyEntity(polName, mode);
    }

    public CRSResourceTypeEntity getResourceTypeEntity(ResourceAttribute nameAttr) throws CRSException {
        return (CRSResourceTypeEntity)CRSEntity.getInstance(CRSEntity.Type.ResourceType, nameAttr);
    }

    public CRSResourceTypeEntity getResourceTypeEntity(ResourceAttribute nameAttr, CRSEntity sibling) throws CRSException {
        return (CRSResourceTypeEntity)new CRSEntity(sibling, CRSEntity.Type.ResourceType, nameAttr.getValue());
    }

    public boolean isRegistered(String entityName, CRSEntity.Type type) throws CRSException {
        try {
            CRSEntity crsEnt = CRSEntity.getInstance(type, this.create(ResourceType.LocalResource.NAME.name(), entityName));
            return crsEnt.isRegistered();
        }
        catch (CRSException e) {
            Trace.out(e);
            throw e;
        }
    }

    public List<ResourceAttribute> searchResources_matchAll(String[] attrNames, String[] attrValues) throws CRSException {
        return this.searchResources_matchAll(attrNames, attrValues, true);
    }

    public List<ResourceAttribute> searchResources_matchAll(String[] attrNames, String[] attrValues, boolean caseSensitive) throws CRSException {
        return this.searchResources(attrNames, attrValues, Filter.Operator.AND, caseSensitive);
    }

    public List<ResourceAttribute> searchResources_matchAny(String[] attrNames, String[] attrValues) throws CRSException {
        return this.searchResources_matchAny(attrNames, attrValues, true);
    }

    public List<ResourceAttribute> searchResources_matchAny(String[] attrNames, String[] attrValues, boolean caseSensitive) throws CRSException {
        return this.searchResources(attrNames, attrValues, Filter.Operator.OR, caseSensitive);
    }

    private List<ResourceAttribute> searchResources(String[] attrNames, String[] attrValues, Filter.Operator filterLogic, boolean caseSensitive) throws CRSException {
        if (attrNames == null || attrNames.length == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "attrNames");
        }
        if (attrValues == null || attrValues.length == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "attrValues");
        }
        if (attrNames.length != attrValues.length) {
            throw new CRSException((MessageKey)PrCrMsgID.MISMATCH_BETWEEN_ATTR_NAMES_AND_VALUES, attrNames.length, attrValues.length);
        }
        SimpleFilter[] subfilters = new SimpleFilter[attrNames.length];
        Filter cumulativeFilter = null;
        for (int i = 0; i < attrNames.length; ++i) {
            if (attrNames[i] == null || attrNames[i].trim().length() == 0) {
                throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "attrValues[" + i + "]");
            }
            if (attrValues[i] == null) {
                throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "attrValues[" + i + "]");
            }
            subfilters[i] = caseSensitive ? new SimpleFilter(Filter.Comparator.EQ, attrNames[i], attrValues[i]) : new SimpleFilter(Filter.Comparator.EQI, attrNames[i], attrValues[i]);
            cumulativeFilter = i == 0 ? subfilters[0] : FilterFactoryImpl.getExpressionFilter(filterLogic, cumulativeFilter, subfilters[i]);
        }
        return this.buildRAList(CRSEntity.Type.Resource, CRSNative.queryResources(CRSEntity.Type.Resource, cumulativeFilter));
    }

    public List<ResourceAttribute> searchResources(ResourceAttribute attr) throws CRSException {
        Filter filter = this.getFilter(Filter.Comparator.EQ, attr.getName(), attr.getValue());
        String[] resList = CRSNative.queryResources(filter);
        ArrayList<ResourceAttribute> list = new ArrayList<ResourceAttribute>(resList.length);
        for (String res : resList) {
            list.add(this.create(ResourceType.LocalResource.NAME.name(), res));
        }
        return list;
    }

    public List<ResourceAttribute> searchResources(CRSEntity.Type entityType, String attrName, String startsWith, String endsWith) throws CRSException {
        Filter filter1 = this.getFilter(Filter.Comparator.STARTS_WITH, attrName, startsWith);
        Filter filter2 = this.getFilter(Filter.Comparator.ENDS_WITH, attrName, endsWith);
        String[] resList = CRSNative.queryResources(entityType, Filter.Operator.AND, filter1, filter2);
        ArrayList<ResourceAttribute> list = new ArrayList<ResourceAttribute>(resList.length);
        for (String res : resList) {
            list.add(this.create(ResourceType.LocalResource.NAME.name(), res));
        }
        return list;
    }

    public List<ResourceAttribute> searchResources(CRSEntity.Type eType, Filter filter) throws CRSException {
        return this.buildRAList(eType, CRSNative.queryResources(eType, filter));
    }

    public List<ResourceAttribute> searchResources(CRSEntity sibling, CRSEntity.Type eType, Filter filter) throws CRSException {
        return this.buildRAList(eType, sibling.getOperations().queryResources(eType, filter));
    }

    private List<ResourceAttribute> buildRAList(CRSEntity.Type eType, String[] resList) throws CRSException {
        ArrayList<ResourceAttribute> list = new ArrayList<ResourceAttribute>(resList.length);
        for (String res : resList) {
            String resName = eType == CRSEntity.Type.ResourceInstance ? res.split(" ")[0] : res;
            list.add(this.create(ResourceType.LocalResource.NAME.name(), resName));
        }
        return list;
    }

    public Map<String, Map<String, String>> searchEntities(CRSEntity.Type eType, boolean evalFlag, Filter filter, String ... attrList) throws CRSException {
        return CRSNative.searchEntities(eType, evalFlag, filter, attrList);
    }

    public Map<String, Map<String, String>> searchEntities(CRSEntity sibling, CRSEntity.Type eType, boolean evalFlag, Filter filter, String ... attrList) throws CRSException {
        return sibling.getOperations().searchEntities(eType, evalFlag, filter, attrList);
    }

    public static Pattern getEnvPattern() {
        return Pattern.compile("((\\w+\\s*)=([\\S&&[^\"]&&[^=]&&[^,]]+))|((\\w+\\s*)=\\s*\"(([^\"])*)\")|(\\w+\\s*)=");
    }

    public List<ResourceAttribute> searchResources(ResourceAttribute attr, String nodeName) throws CRSException {
        Filter filter = this.getFilter(Filter.Comparator.EQ, attr.getName(), attr.getValue());
        String[] resList = CRSNative.queryResources(filter, nodeName);
        ArrayList<ResourceAttribute> list = new ArrayList<ResourceAttribute>(resList.length);
        for (String res : resList) {
            list.add(this.create(ResourceType.LocalResource.NAME.name(), res));
        }
        return list;
    }

    public OracleCMCluster getOracleCMCluster() throws NotExistsException {
        return OracleCMClusterImpl.getInstance();
    }

    public OracleCMCluster getOracleCMCluster(String nodeName) throws NotExistsException {
        return OracleCMClusterImpl.getInstance(nodeName);
    }

    public VendorCluster getVendorCluster() throws NotExistsException {
        return VendorClusterImpl.getInstance();
    }

    public VendorCluster getVendorCluster(String nodeName) throws NotExistsException {
        return VendorClusterImpl.getInstance(nodeName);
    }

    public Filter getFilter(Filter.Comparator comp, String attr, String value) throws CRSException {
        return FilterFactoryImpl.getSimpleFilter(comp, attr, value);
    }

    public Filter getORFilter(String attributeName, Filter.Comparator comp, String ... values) throws CRSException {
        return FilterFactoryImpl.getORFilter(attributeName, comp, values);
    }

    public boolean hasCrsAdminRole() throws CRSException {
        String user = "";
        try {
            user = new Util().getCurrentUser();
        }
        catch (UtilException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_CRS_ADMIN_FAILED, (Throwable)e, user);
        }
        return this.hasCrsAdminRole(user);
    }

    public boolean hasCrsAdminRole(String user) throws CRSException {
        return CRSNative.hasCrsAdminRole(user);
    }

    public Filter getFilter(Filter.Operator op, Filter f1, Filter f2) throws CRSException {
        return FilterFactoryImpl.getExpressionFilter(op, f1, f2);
    }

    public long getSeqNumber() throws CRSException {
        return CRSNative.getSeqNumber();
    }

    private String getNameAttrValue(List<ResourceAttribute> list) {
        String name = ResourceType.LocalResource.NAME.name();
        for (ResourceAttribute attr : list) {
            if (!attr.getName().equalsIgnoreCase(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public String convertArrToCRSAttrValue(String[] sArray) {
        if (sArray == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (sArray.length > 0) {
            if (sArray[0].contains(" ")) {
                sb.append("\"" + sArray[0] + "\"");
            } else {
                sb.append(sArray[0]);
            }
            for (int i = 1; i < sArray.length; ++i) {
                if (sArray[i].contains(" ")) {
                    sb.append(" \"" + sArray[i] + "\"");
                    continue;
                }
                sb.append(" " + sArray[i]);
            }
        }
        return sb.toString();
    }

    public List<String> convertCRSAttrValueToArr(ResourceAttribute attr) throws CRSException {
        String mString = attr.getValue().trim();
        if (mString == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> sList = new ArrayList<String>();
        int len = mString.length();
        int i = 0;
        int pos = 0;
        int fromIndex = 0;
        Boolean found = false;
        Trace.out("Calling convertCRSAttrValueToArr: " + mString);
        while (i < len) {
            String s;
            found = false;
            if (mString.charAt(i) == '\"') {
                ++fromIndex;
                while (!found.booleanValue()) {
                    pos = mString.indexOf(34, fromIndex);
                    if (pos < 0) {
                        Trace.out("Mismatch of \" in string " + mString);
                        throw new CRSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, attr.getName(), mString);
                    }
                    if (mString.charAt(pos - 1) != '\\') {
                        if (pos == len - 1 || pos < len - 1 && mString.charAt(pos + 1) == ' ') {
                            s = mString.substring(i + 1, pos);
                            sList.add(s);
                            Trace.out("Find token " + s);
                            found = true;
                            i = pos + 2;
                            fromIndex = i + 1;
                            continue;
                        }
                        Trace.out("Missing white space as delim");
                        throw new CRSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, attr.getName(), mString);
                    }
                    fromIndex = pos + 1;
                }
                continue;
            }
            if (mString.charAt(i) == ' ') {
                Trace.out("Find extra white space: mString[" + i + "] = " + mString.charAt(i));
                throw new CRSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, attr.getName(), mString);
            }
            pos = mString.indexOf(32, fromIndex);
            if (pos < 0) {
                s = mString.substring(i);
                found = true;
                Trace.out("Find token: " + s);
                sList.add(s);
                i = len + 1;
                break;
            }
            s = mString.substring(i, pos);
            Trace.out("Find token:: " + s);
            sList.add(s);
            found = true;
            i = pos + 1;
            fromIndex = i + 1;
        }
        return sList;
    }

    public void setUpgradeModeFlags() throws CRSException {
        try {
            CRSNative.setUpgradeFlag();
            s_upgradeMode = true;
        }
        catch (CRSNativeException cne) {
            throw new CRSException((MessageKey)PrCrMsgID.UPGRADE_MODE_FAILED, new Object[0]);
        }
    }

    public boolean upgradeMode() {
        return s_upgradeMode;
    }

    public static void stopResources(Filter stopFilter, boolean forceFlag, boolean keepDepTgt, ResourceAttribute[] optionalAttr) throws AlreadyStoppedException, CRSException, CRSCompositeOperationException {
        CRSNative.stopResources(stopFilter, forceFlag, keepDepTgt, optionalAttr);
    }

    public static void startResources(Filter filter, String nodeName, ResourceAttribute[] optionalAttr) throws CRSException, AlreadyRunningException, CompositeOperationException {
        CRSFactoryImpl.startResources(filter, true, nodeName, optionalAttr);
    }

    public static void stopResources(Filter stopFilter, boolean forceFlag, boolean keepDepTgt, ResourceAttribute[] optionalAttr, Map<String, String> nodeResMap) throws AlreadyStoppedException, CRSException, CRSCompositeOperationException {
        CRSNative.stopResources(stopFilter, forceFlag, keepDepTgt, optionalAttr, nodeResMap);
    }

    public static void startResources(Filter filter, boolean forceFlag, String nodeName, ResourceAttribute[] optionalAttr) throws CRSException, AlreadyRunningException, CompositeOperationException {
        CRSNative.startResources(filter, forceFlag, nodeName, optionalAttr);
    }

    public static void startResources(Filter filter, boolean forceFlag, String nodeName, ResourceAttribute[] optionalAttr, Map<String, String> nodeResMap) throws InvalidArgsException, AlreadyRunningException, CompositeOperationException, CRSException {
        CRSNative.startResources(filter, forceFlag, nodeName, optionalAttr, nodeResMap);
    }

    public static void relocateResources(Filter filter, String toNode, boolean forceFlag, ResourceAttribute[] optionalAttr) throws NotRunningException, CRSException, CompositeOperationException {
        EntityOperations ops = EntityOperations.getInstance(EntityOperations.EntityOpsMode.CRS);
        ops.relocate(filter, toNode, forceFlag, optionalAttr);
    }

    public static void relocateResources(Filter filter, String toNode, boolean forceFlag, ResourceAttribute[] optionalAttr, Map<String, String> nodeResMap) throws NotRunningException, CRSException, CompositeOperationException {
        EntityOperations ops = EntityOperations.getInstance(EntityOperations.EntityOpsMode.CRS);
        ops.relocate(filter, toNode, forceFlag, optionalAttr, nodeResMap);
    }

    public static void relocateResources(CRSResource resource, String fromNode, String toNode, boolean forceFlag, ResourceAttribute[] optionalAttr) throws NotRunningException, CRSException, CompositeOperationException {
        EntityOperations ops = EntityOperations.getInstance(EntityOperations.EntityOpsMode.CRS);
        ops.relocate(resource, fromNode, toNode, forceFlag, optionalAttr);
    }

    public static void relocateResources(CRSResource resource, String fromNode, String toNode, boolean forceFlag, ResourceAttribute[] optionalAttr, Map<String, String> nodeSvcMap) throws NotRunningException, CRSException, CompositeOperationException {
        EntityOperations ops = EntityOperations.getInstance(EntityOperations.EntityOpsMode.CRS);
        ops.relocate(resource, fromNode, toNode, forceFlag, optionalAttr, nodeSvcMap);
    }

    public CompositeActionStatus requestTargetStatus(CRSResource crsRes, String targetType, String targetName) throws CRSException {
        try {
            String actionName = ResourceLiterals.STATUS_TARGET.toString();
            ActionAttribute attrTargetType = new ActionAttribute(ResourceType.IOServer.TARGET_TYPE.name(), targetType);
            ActionAttribute attrTargetName = new ActionAttribute(ResourceType.IOServer.TARGET_NAME.name(), targetName);
            ActionAttribute[] attrs = new ActionAttribute[]{attrTargetType, attrTargetName};
            CompositeActionStatusImpl compActionStatus = new CompositeActionStatusImpl();
            ActionListenerImpl actionLsnr = new ActionListenerImpl(compActionStatus);
            List<Node> runningNodeList = crsRes.fetchRunningNodes();
            if (runningNodeList == null || runningNodeList.size() == 0) {
                return null;
            }
            Node[] nodesArr = new Node[runningNodeList.size()];
            runningNodeList.toArray(nodesArr);
            crsRes.requestAction(actionName, attrs, nodesArr, actionLsnr);
            Trace.out("Request Action completed");
            if (compActionStatus.isSuccess()) {
                return compActionStatus;
            }
            throw new CRSException((MessageKey)PrCcMsgID.ERROR_GET_TARGET_STATUS, crsRes.getName(), compActionStatus.getErrorMessage());
        }
        catch (CompositeActionException e) {
            throw new CRSException(e);
        }
    }

    public void upgradeResourceTypes() throws CRSException, UpgradeException {
        this.createUpgradeResourceTypes(false, true);
    }

    public void createResourceTypes() throws CRSException {
        try {
            try {
                this.createHubRimCategory();
            }
            catch (AlreadyExistsException e) {
                Trace.out("HUB and RIM categories are already created. Not an error.");
            }
            this.createUpgradeResourceTypes(true, false);
        }
        catch (UpgradeException e) {
            throw new CRSException(e);
        }
    }

    public void createUpgradeResourceTypes() throws CRSException, UpgradeException {
        this.createUpgradeResourceTypes(true, true);
    }

    private void createUpgradeResourceTypes(boolean bCreate, boolean bUpgrade) throws CRSException, UpgradeException {
        if (!bCreate && !bUpgrade) {
            return;
        }
        if (bUpgrade) {
            Trace.out("Upgrading resource types ");
            this.upgradeResTypes();
        }
        Class<?>[] resTypeArr = ResourceType.class.getClasses();
        List<String> registeredTypes = this.getRegisteredTypes();
        int size = resTypeArr.length;
        Class<?> resTypeClazz = null;
        block0: for (int i = size - 1; i >= 0; --i) {
            resTypeClazz = resTypeArr[i];
            if (!resTypeClazz.isEnum()) continue;
            Trace.out("Create resource type " + resTypeClazz.getName());
            List<ResourceAttribute> attrList = ResourceType.getAttributes(resTypeClazz);
            for (ResourceAttribute attr : attrList) {
                String typeName;
                if (!attr.getName().equalsIgnoreCase(ResourceType.LocalResource.NAME.name()) || !(typeName = attr.getValue()).endsWith('.' + ResourceLiterals.TYPE.toString()) || typeName == null) continue;
                this.createResourceType(resTypeClazz, typeName, attrList, registeredTypes, bCreate);
                continue block0;
            }
        }
    }

    private List<String> getRegisteredTypes() throws CRSException {
        String endsWith = '.' + ResourceLiterals.TYPE.toString();
        Filter filter = this.getFilter(Filter.Comparator.ENDS_WITH, ResourceLiterals.TYPE_NAME.name(), endsWith);
        ArrayList<String> registTypes = new ArrayList<String>();
        Map<String, Map<String, String>> entities = null;
        entities = this.searchEntities(CRSEntity.Type.ResourceType, false, filter, new String[0]);
        for (Map.Entry<String, Map<String, String>> entry : entities.entrySet()) {
            String tName = entry.getKey();
            Trace.out("Get registered resource type " + tName);
            registTypes.add(tName);
        }
        return registTypes;
    }

    private List getChildTypes(String type) throws CRSException {
        Filter filter = this.getFilter(Filter.Comparator.EQ, ResourceType.LocalResource.BASE_TYPE.name(), type);
        ArrayList<String> childTypes = new ArrayList<String>();
        Map<String, Map<String, String>> entities = null;
        entities = this.searchEntities(CRSEntity.Type.ResourceType, false, filter, new String[0]);
        for (Map.Entry<String, Map<String, String>> entry : entities.entrySet()) {
            String tName = entry.getKey();
            Trace.out("Get child resource type " + tName);
            childTypes.add(tName);
        }
        return childTypes;
    }

    private HashMap<String, Class<? extends Enum>> getTypeClasses() throws CRSException {
        Class<?>[] resTypeArr = ResourceType.class.getClasses();
        HashMap<String, Class<? extends Enum>> resTypeMap = new HashMap<String, Class<? extends Enum>>();
        int size = resTypeArr.length;
        Class<?> resTypeClazz = null;
        String typeName = null;
        boolean isType = true;
        for (int i = size - 1; i >= 0; --i) {
            resTypeClazz = resTypeArr[i];
            if (!resTypeClazz.isEnum()) continue;
            Trace.out("Create resource type " + resTypeClazz.getName());
            isType = true;
            typeName = null;
            List<ResourceAttribute> attrList = ResourceType.getAttributes(resTypeClazz);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.LocalResource.NAME.name()) && !(typeName = attr.getValue()).endsWith('.' + ResourceLiterals.TYPE.toString())) {
                    isType = false;
                }
                if (isType && typeName == null) continue;
                break;
            }
            if (!isType) continue;
            Trace.out("type is " + typeName);
            resTypeMap.put(typeName, resTypeClazz);
        }
        return resTypeMap;
    }

    private String getRootType(String typeName) throws CRSException {
        ResourceAttribute typeAttr = this.create(ResourceType.LocalResource.NAME.name(), typeName);
        CRSResourceTypeEntity resType = this.getResourceTypeEntity(typeAttr);
        ResourceAttribute baseTypeAttr = resType.getAttribute(ResourceType.ClusterResource.BASE_TYPE.name());
        String baseTypeName = baseTypeAttr.getValue();
        Trace.out("base type for type  " + typeName + " is " + baseTypeName);
        if (baseTypeName != null && baseTypeName.endsWith('.' + ResourceLiterals.TYPE.toString())) {
            return this.getRootType(baseTypeName);
        }
        Trace.out("root base type is " + typeName);
        return typeName;
    }

    private void createResourceType(Class<? extends Enum> resTypeClazz, String typeName, List<ResourceAttribute> attrList, List<String> registTypes, boolean bCreate) throws CRSException, UpgradeException {
        Trace.out("Create resource type " + typeName);
        Trace.out("bCreate=" + bCreate);
        if (!bCreate) {
            return;
        }
        if (registTypes.contains(typeName)) {
            Trace.out("Type " + typeName + " is already registered");
            return;
        }
        try {
            Object tmpAttrList;
            if (attrList == null || resTypeClazz == null) {
                Class<?>[] resTypeArr;
                tmpAttrList = null;
                block8: for (Class<?> clazz : resTypeArr = ResourceType.class.getClasses()) {
                    Trace.out("Processing class " + clazz.getName() + "...");
                    if (!clazz.isEnum()) continue;
                    tmpAttrList = ResourceType.getAttributes(clazz);
                    Iterator iterator = tmpAttrList.iterator();
                    while (iterator.hasNext()) {
                        ResourceAttribute attr = (ResourceAttribute)iterator.next();
                        Trace.out("Looking at attribute " + attr.toString());
                        if (!attr.getName().equalsIgnoreCase(ResourceType.LocalResource.NAME.name()) || !typeName.equalsIgnoreCase(attr.getValue())) continue;
                        Trace.out("Get attrList for type" + typeName);
                        attrList = tmpAttrList;
                        continue block8;
                    }
                }
            }
            tmpAttrList = attrList.iterator();
            while (tmpAttrList.hasNext()) {
                String basetype;
                ResourceAttribute attr = tmpAttrList.next();
                if (!attr.getName().equalsIgnoreCase(ResourceType.LocalResource.BASE_TYPE.name()) || !(basetype = attr.getValue()).endsWith('.' + ResourceLiterals.TYPE.toString())) continue;
                this.createResourceType(null, basetype, null, registTypes, true);
                break;
            }
            if (typeName.equals(ResourceLiterals.ASM_LOCAL_TYPE.toString()) || typeName.equals(ResourceLiterals.ASM_CLUSTER_TYPE.toString())) {
                Trace.out("Special handling for ora.*_asm.type ....");
                if (Cluster.isCluster()) {
                    boolean n0Exists = false;
                    try {
                        n0Exists = new ClusterUtil().isNodeNum0Exists();
                        Trace.out("n0Exists = " + n0Exists);
                    }
                    catch (ClusterUtilException ce) {
                        throw new CRSException((MessageKey)PrCrMsgID.NODE_NUM0_CHECK_FAILED, (Throwable)ce, new Object[0]);
                    }
                    if (n0Exists) {
                        attrList = ResourceType.LocalASM.modifyAttrForAsmWithNode0(attrList);
                    }
                } else {
                    attrList = ResourceType.LocalASM.addAttrForSHAsm(attrList);
                }
            }
            if (typeName.equals(ResourceType.DiskGroup.NAME.toString())) {
                attrList = ResourceType.DiskGroup.setDepOnASM(attrList);
            }
            try {
                Util utl = new Util();
                Boolean haPriv = utl.hasHAPrivilege();
                if (haPriv.booleanValue() && (typeName.equals(ResourceType.Database.NAME.toString()) || typeName.equals(ResourceType.Service.NAME.toString()) || typeName.equals(ResourceType.Listener.NAME.toString()))) {
                    String typeacl = ResourceLiterals.TYPE_ACL.toString();
                    ResourcePermissionsImpl perm = null;
                    perm = new ResourcePermissionsImpl(ResourceType.ACL_CREATOR.ROOT, true);
                    ResourceAttribute typeaclAttr = new ResourceAttribute(typeacl, perm.getAclString());
                    attrList.add((ResourceAttribute)typeaclAttr);
                }
            }
            catch (ClusterException ce) {
                Trace.out("ClusterException " + ce);
                throw new CRSException(ce);
            }
            catch (NodeException ne) {
                throw new CRSException(ne);
            }
            catch (UtilException ue) {
                throw new CRSException(ue);
            }
            if (this.m_nativeSystem.isUnixSystem()) {
                this.create(CRSEntity.Type.ResourceType, (List<ResourceAttribute>)attrList);
            } else if (typeName.equals(ResourceType.Listener.NAME.toString()) || typeName.equals(ResourceType.ScanListener.NAME.toString())) {
                this.ntCreateLsnrType(CRSEntity.Type.ResourceType, (List<ResourceAttribute>)attrList);
            } else {
                this.create(CRSEntity.Type.ResourceType, (List<ResourceAttribute>)attrList);
            }
            registTypes.add(typeName);
        }
        catch (AlreadyExistsException e) {
            Trace.out("Got AlreadyExistsException: " + e.getMessage());
        }
    }

    public void upgradeResTypes() throws UpgradeException, CRSException {
        List<String> registeredTypes = this.getRegisteredTypes();
        Trace.out("Resistered types size=" + registeredTypes.size() + "and Types are " + Arrays.toString(registeredTypes.toArray()));
        HashSet<String> typesToUpgrade = new HashSet<String>();
        typesToUpgrade.addAll(registeredTypes);
        Trace.out("types to upgrade size=" + typesToUpgrade.size() + " and Types are " + Arrays.toString(typesToUpgrade.toArray()));
        HashMap<String, Class<? extends Enum>> resTypeMap = this.getTypeClasses();
        Trace.out("Types to upgrade size" + typesToUpgrade.size() + "\t\t Types are " + Arrays.toString(typesToUpgrade.toArray()));
        for (String resType : registeredTypes) {
            if (typesToUpgrade.contains(resType)) {
                Trace.out("Getting root type for the type" + resType);
                String rootType = this.getRootType(resType);
                Trace.out("Upgrading root type" + rootType);
                this.upgradeType(rootType, resTypeMap, typesToUpgrade, null, null);
                Trace.out("types to upgrade size" + typesToUpgrade.size() + "\t\t Types are " + Arrays.toString(typesToUpgrade.toArray()));
            }
            if (typesToUpgrade.size() != 0) continue;
            break;
        }
    }

    public void upgradeType(Class<? extends Enum> clazz) throws UpgradeException {
        String resType = null;
        try {
            Enum[] enumAttrArr;
            Enum nameAttr = null;
            for (Enum enumAttr : enumAttrArr = clazz.getEnumConstants()) {
                if (enumAttr.name().equals(ResourceType.LocalResource.NAME.name())) {
                    nameAttr = enumAttr;
                    Trace.out("resource type name = " + nameAttr.toString());
                    continue;
                }
                if (nameAttr != null) break;
            }
            if (nameAttr == null) {
                throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_GET_TYPE_NAME, clazz.getName());
            }
            resType = nameAttr.toString();
            HashMap<String, Class<? extends Enum>> resTypeMap = this.getTypeClasses();
            HashSet<String> typesToUpgrade = new HashSet<String>();
            typesToUpgrade.add(resType);
            List<String> registeredTypes = this.getRegisteredTypes();
            Trace.out("Getting root type for the type" + resType);
            String rootType = this.getRootType(resType);
            Trace.out("Upgrading root type" + rootType);
            this.upgradeType(rootType, resTypeMap, typesToUpgrade, null, null);
        }
        catch (CRSException e) {
            Trace.out("Upgrade: Got CRSException: " + e.getMessage());
            throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_UPGRADE_TYPE, (Throwable)e, resType);
        }
    }

    public void upgradeType(String typeName, HashMap<String, Class<? extends Enum>> resTypeMap, HashSet<String> typesToUpgrade, List<ResourceAttribute> ralBaseType, List<ResourceUpgradeAttribute> raluBaseType) throws UpgradeException {
        Trace.out("Upgrading type " + typeName);
        try {
            ArrayList<ResourceAttribute> ral = new ArrayList<ResourceAttribute>();
            ArrayList<ResourceUpgradeAttribute> ralu = new ArrayList<ResourceUpgradeAttribute>();
            Class<? extends Enum> clazz = resTypeMap.get(typeName);
            ResourceAttribute typeAttr = this.create(ResourceType.LocalResource.NAME.name(), typeName);
            CRSResourceTypeEntity resType = this.getResourceTypeEntity(typeAttr);
            if (!resType.isRegistered()) {
                Trace.out("Calling upgrade: Resource type " + clazz.getName() + " is not registered");
                return;
            }
            if (clazz != null) {
                Enum[] enumAttrArr = clazz.getEnumConstants();
                boolean found = false;
                boolean ASMn0Exists = false;
                Iterator attrList = resType.getAttributes(new String[0]);
                Trace.out("attrList size is " + attrList.size());
                for (Enum enumAttr : enumAttrArr) {
                    if (enumAttr.name().equals(ResourceType.LocalResource.NAME.name())) {
                        if (!enumAttr.toString().equals(ResourceLiterals.ASM_TYPE.toString())) continue;
                        Trace.out("Check node 0 exists");
                        if (!Cluster.isCluster()) continue;
                        try {
                            ASMn0Exists = new ClusterUtil().isNodeNum0Exists();
                            Trace.out("ASMn0Exists = " + ASMn0Exists);
                            continue;
                        }
                        catch (ClusterUtilException ce) {
                            throw new CRSException((MessageKey)PrCrMsgID.NODE_NUM0_CHECK_FAILED, (Throwable)ce, new Object[0]);
                        }
                    }
                    found = false;
                    String defVal = null;
                    Iterator iterator = attrList.iterator();
                    while (iterator.hasNext()) {
                        ResourceAttribute resourceAttribute = (ResourceAttribute)iterator.next();
                        if (!enumAttr.name().equals(resourceAttribute.getName())) continue;
                        if (ASMn0Exists && resourceAttribute.getName().equals(ResourceType.LocalASM.ALIAS_NAME.name())) {
                            defVal = ResourceType.LocalASM.defaultValNode0Exist(ResourceType.LocalASM.ALIAS_NAME.name());
                            if (resourceAttribute.getValue().equals(defVal)) {
                                found = true;
                                break;
                            }
                            ralu.add(new ResourceUpgradeAttribute(enumAttr.name(), defVal, resourceAttribute.getValue()));
                            continue;
                        }
                        if (ASMn0Exists && resourceAttribute.getName().equals(ResourceType.LocalASM.USR_ORA_INST_NAME.name())) {
                            defVal = ResourceType.LocalASM.defaultValNode0Exist(ResourceType.LocalASM.USR_ORA_INST_NAME.name());
                            if (resourceAttribute.getValue().equals(defVal)) {
                                found = true;
                                break;
                            }
                            ralu.add(new ResourceUpgradeAttribute(enumAttr.name(), defVal, resourceAttribute.getValue()));
                            continue;
                        }
                        if (enumAttr.toString().equals(resourceAttribute.getValue())) {
                            found = true;
                            break;
                        }
                        if (enumAttr.name().equals(ResourceType.CVU.AGENT_FILENAME.name())) {
                            Trace.out("Warning: AGENT_FILENAME is changed. Cannot upgrade resource type " + clazz.getName());
                            return;
                        }
                        ralu.add(new ResourceUpgradeAttribute(enumAttr.name(), enumAttr.toString(), resourceAttribute.getValue()));
                    }
                    if (found) continue;
                    if (enumAttr.name().equals(ResourceType.CVU.AGENT_FILENAME.name())) {
                        Trace.out("Warning: AGENT_FILENAME is changed. Cannot upgrade resource type " + clazz.getName());
                        return;
                    }
                    if (enumAttr.name().equals(ResourceType.ClusterASM.ACTIONS.name())) {
                        ralu.add(new ResourceUpgradeAttribute(enumAttr.name(), enumAttr.toString(), ""));
                    }
                    if (defVal != null) {
                        Trace.out("Add " + enumAttr.name() + " = " + defVal);
                        ral.add(this.create(enumAttr.name(), defVal));
                        continue;
                    }
                    Trace.out("Add " + enumAttr.name() + " = " + enumAttr.toString());
                    ral.add(this.create(enumAttr.name(), enumAttr.toString()));
                }
            }
            Trace.out("Number of added or changed attributes is for this resource type is " + ral.size());
            if (ralBaseType != null && ralBaseType.size() != 0) {
                for (ResourceAttribute baseAttr : ralBaseType) {
                    boolean isOverrided = false;
                    for (ResourceAttribute resourceAttribute : ral) {
                        if (!resourceAttribute.getName().equals(baseAttr.getName())) continue;
                        isOverrided = true;
                        break;
                    }
                    if (isOverrided) continue;
                    ral.add(baseAttr);
                }
            }
            if (raluBaseType != null && raluBaseType.size() != 0) {
                for (ResourceUpgradeAttribute baseAttr : raluBaseType) {
                    boolean isOverrided = false;
                    for (ResourceUpgradeAttribute resourceUpgradeAttribute : ralu) {
                        if (!resourceUpgradeAttribute.getName().equals(baseAttr.getName())) continue;
                        isOverrided = true;
                        break;
                    }
                    if (isOverrided) continue;
                    ralu.add(baseAttr);
                }
            }
            Trace.out("Number of added attributes including base type is " + ral.size());
            Trace.out("Number of changed attributes including base type is " + ralu.size());
            if (typesToUpgrade.contains(typeName)) {
                List<ResourceAttribute> resList;
                if (ral.size() > 0) {
                    resType.update(ral.toArray(new ResourceAttribute[ral.size()]));
                }
                if (ralu.size() > 0 && (resList = this.searchResources(this.create(ResourceLiterals.TYPE.name(), typeName))) != null && resList.size() > 0) {
                    for (ResourceAttribute resAttr : resList) {
                        CRSResourceImpl cRSResourceImpl;
                        try {
                            cRSResourceImpl = (CRSResourceImpl)this.get(resAttr);
                        }
                        catch (NotExistsException e) {
                            Trace.out("We should never get NotExistsException. Continue...");
                            continue;
                        }
                        ArrayList<ResourceAttribute> ralv = new ArrayList<ResourceAttribute>();
                        boolean inclStartDep = false;
                        boolean inclStopDep = false;
                        for (ResourceUpgradeAttribute resourceUpgradeAttribute : ralu) {
                            ResourceAttribute attrInRes = cRSResourceImpl.getAttribute(resourceUpgradeAttribute.getName());
                            Trace.out("attr name is %s, attrInRes.getValue() is ", resourceUpgradeAttribute.getName(), attrInRes.getValue());
                            Trace.out("attr old default value is " + resourceUpgradeAttribute.getOldValue());
                            Trace.out("attr.getValue() is " + resourceUpgradeAttribute.getValue());
                            if (resourceUpgradeAttribute.getName().equals(ResourceType.ClusterASM.ACTIONS.name())) {
                                if (!typeName.equals(ResourceLiterals.ASM_TYPE.toString()) && !typeName.equals(ResourceType.IOServer.NAME.toString())) continue;
                                String actionsVal = this.createActionsAttr(resAttr.getValue(), null, resourceUpgradeAttribute.getValue());
                                Trace.out((Object)"Actions default value is %s", resourceUpgradeAttribute.getValue());
                                Trace.out("Actions for %s is %s", resAttr.getValue(), actionsVal);
                                ralv.add(this.create(resourceUpgradeAttribute.getName(), actionsVal));
                                continue;
                            }
                            if (resourceUpgradeAttribute.getName().equals(ResourceLiterals.START_DEPENDENCIES_TEMPLATE.name()) && !resourceUpgradeAttribute.getValue().trim().equals("")) {
                                Trace.out("Upgrade start dependencies for " + resAttr.getValue());
                                ralv.add(this.create(resourceUpgradeAttribute.getName(), resourceUpgradeAttribute.getValue()));
                                inclStartDep = true;
                                continue;
                            }
                            if (resourceUpgradeAttribute.getName().equals(ResourceLiterals.STOP_DEPENDENCIES_TEMPLATE.name()) && !resourceUpgradeAttribute.getValue().trim().equals("")) {
                                Trace.out("Upgrade stop dependencies for " + resAttr.getValue());
                                ralv.add(this.create(resourceUpgradeAttribute.getName(), resourceUpgradeAttribute.getValue()));
                                inclStopDep = true;
                                continue;
                            }
                            if (!attrInRes.getValue().equals(resourceUpgradeAttribute.getOldValue())) continue;
                            if (resourceUpgradeAttribute.getName().equals(ResourceType.ScanVIP.SCAN_NAME.name()) && resourceUpgradeAttribute.getValue().equals("")) {
                                ralv.add(this.create(resourceUpgradeAttribute.getName(), resourceUpgradeAttribute.getOldValue()));
                                continue;
                            }
                            ralv.add(this.create(resourceUpgradeAttribute.getName(), resourceUpgradeAttribute.getValue()));
                        }
                        if (inclStartDep || inclStopDep) {
                            this.upgradeDepAttrs(typeName, resAttr, ralv, inclStartDep, inclStopDep);
                        }
                        if (ralv.size() <= 0) continue;
                        cRSResourceImpl.update(ralv.toArray(new ResourceAttribute[ralv.size()]));
                    }
                }
            }
            Trace.out("upgrade for type is complete now upgrading child types");
            List childTypes = this.getChildTypes(typeName);
            Trace.out("Child types size = " + childTypes.size() + " and child Types are " + Arrays.toString(childTypes.toArray()));
            for (String ctype : childTypes) {
                this.upgradeType(ctype, resTypeMap, typesToUpgrade, ral, ralu);
            }
            typesToUpgrade.remove(typeName);
            return;
        }
        catch (CRSAttributeNotFoundException e) {
            Trace.out("Upgrade: Cannot find the crs attribute");
            throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_UPGRADE_TYPE, (Throwable)e, typeName);
        }
        catch (CRSException e) {
            Trace.out("Upgrade: Got CRSException: " + e.getMessage());
            throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_UPGRADE_TYPE, (Throwable)e, typeName);
        }
    }

    private void upgradeDepAttrs(String typeName, ResourceAttribute resAttr, List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws UpgradeException {
        block8: {
            try {
                Trace.out("Upgrade dependencies for %s of %s. Include start dependencies %s. Include stop dependencies %s", resAttr.getValue(), typeName, inclStartDep, inclStopDep);
                if (typeName.equals(ResourceType.Volume.NAME.toString())) {
                    ASMFactoryImpl.getInstance().upgradeVolumeDepAttrs(resAttr, attrList, inclStartDep, inclStartDep);
                    break block8;
                }
                if (typeName.equals(ResourceType.MgmtDatabase.NAME.toString())) {
                    DatabaseFactoryImpl.getInstance().upgradeMgmtDBDepAttrs(resAttr, attrList, inclStartDep, inclStartDep);
                    break block8;
                }
                if (typeName.equals(ResourceType.MgmtListener.NAME.toString())) {
                    NodeAppsFactoryImpl.getInstance().upgradeMgmtLsnrDepAttrs(resAttr, attrList, inclStartDep, inclStartDep);
                    break block8;
                }
                if (typeName.equals(ResourceType.ScanVIP.NAME.toString())) {
                    ScanFactoryImpl.getInstance().upgradeScanVIPDepAttrs(resAttr, attrList, inclStartDep, inclStartDep);
                    break block8;
                }
                if (typeName.startsWith("ora." + ResourceLiterals.CLUSTER_VIP.toString() + '_' + ResourceLiterals.NET.toString()) && typeName.endsWith('.' + ResourceLiterals.TYPE.toString())) {
                    NodeAppsFactoryImpl.getInstance().upgradeVIPDepAttrs(resAttr, attrList, inclStartDep, inclStartDep);
                    break block8;
                }
                if (typeName.equals(ResourceType.Database.NAME.toString()) || typeName.equals(ResourceType.Service.NAME.toString())) {
                    Trace.out("Upgrading dependencies for database and server resources is done in database upgrade.");
                    break block8;
                }
                Trace.out((Object)"Failed to upgrade resource %s.Unsupported resource type.", resAttr.getName());
                throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_UPGRADE_DEPENDENCIES, resAttr.getValue());
            }
            catch (SoftwareModuleException e) {
                throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_UPGRADE_DEPENDENCIES, (Throwable)e, resAttr.getValue());
            }
        }
    }

    public CRSFactory.CRSCacheMode crsCacheMode() {
        return this.m_crsCacheMode;
    }

    public void setCrsCacheMode(CRSFactory.CRSCacheMode mode) throws CRSException {
        if (this.m_crsCacheMode == mode) {
            return;
        }
        this.m_crsCacheMode = mode;
        switch (mode) {
            case None: {
                CRSCache.enable(false);
                break;
            }
            case Local: {
                CRSCache.enable(true);
                break;
            }
            default: {
                throw new CRSException((MessageKey)PrCrMsgID.CRSCACHE_WRONG_MODE, mode.toString());
            }
        }
    }

    public void invalidateCrsCache() {
        CRSCache.invalidate();
    }

    public static boolean isRunningState(String state) {
        if (state == null || state.trim().isEmpty()) {
            return false;
        }
        for (String st : RUNNING_STATES) {
            if (!st.equalsIgnoreCase(state)) continue;
            return true;
        }
        return false;
    }

    public RTENativeResult rteEvalAttrValue(String template, Map<String, RTEArg> argMap, String version, Map<String, String> condMap, String resName) throws CRSException {
        int argCount = argMap.size();
        String[] argNames = new String[argCount];
        String[] argValues = new String[argCount];
        int[] argTypes = new int[argCount];
        int condCount = condMap.size();
        String[] condNames = new String[condCount];
        String[] condValues = new String[condCount];
        int i = 0;
        Trace.out("ARGUMENTS FOR EVALATTR BEGIN");
        Trace.out("template=" + template);
        for (String argName : argMap.keySet()) {
            RTEArg arg = argMap.get(argName);
            RTEArg.RTEArgType argType = arg.getType();
            Trace.out("argType = %s", new Object[]{argType});
            String argValue = "";
            if (argType == RTEArg.RTEArgType.ResList || argType == RTEArg.RTEArgType.ResTypeList) {
                List<String> argValueList = arg.getValues();
                for (String v : argValueList) {
                    if (v == null || v.trim().equals("")) continue;
                    if (argValue.equals("")) {
                        argValue = v;
                        continue;
                    }
                    argValue = argValue + "," + v;
                }
            } else if (argType == RTEArg.RTEArgType.Res || argType == RTEArg.RTEArgType.ResType) {
                argValue = arg.getValues().get(0);
            }
            argNames[i] = argName;
            argTypes[i] = argType.getCode();
            argValues[i] = argValue;
            Trace.out("argName=" + argNames[i] + ", argType=" + argTypes[i] + ", argValue=" + argValues[i]);
            ++i;
        }
        i = 0;
        for (String condName : condMap.keySet()) {
            String condValue = condMap.get(condName);
            condNames[i] = condName;
            condValues[i] = condValue;
            Trace.out("condName=" + condNames[i] + ", condValue=" + condValues[i]);
            ++i;
        }
        Trace.out("ARGUMENTS FOR EVALATTR END");
        RTENativeResult result = new RTENativeResult();
        try {
            CRSNative.rteEvalAttrValue(template, argNames, argTypes, argValues, version, condNames, condValues, result);
        }
        catch (RTENativeException e) {
            StringBuilder argNamesSB = new StringBuilder();
            for (String n : argNames) {
                if (argNamesSB.length() > 0) {
                    argNamesSB.append(',');
                }
                argNamesSB.append(n);
            }
            Trace.out("Failed to evaluate attribute value for resource:" + resName + " with arguments:" + argNamesSB.toString());
            throw new CRSException((MessageKey)PrCzMsgID.RTE_EVALATTR_FAIL, (Throwable)e, resName, argNamesSB.toString());
        }
        result.setAttrValue(this.postProcessDependencyString(result.getAttrValue()));
        return result;
    }

    public RTENativeResult rteGetArgList(String template, List<String> argNameList, String attrValue, String attrValueHint, String version, String resName) throws CRSException {
        int argCount = argNameList.size();
        String[] argNames = new String[argCount];
        int i = 0;
        Trace.out("ARGUMENTS FOR GETARGLIST BEGIN");
        Trace.out("template=" + template);
        Trace.out("attrValue=" + attrValue);
        Trace.out("attrValueHint=" + attrValueHint);
        Trace.out("resName=" + resName);
        for (String argName : argNameList) {
            Trace.out("argName=" + argName);
            argNames[i] = argName;
            ++i;
        }
        Trace.out("ARGUMENTS FOR GETARGLIST END");
        RTENativeResult result = new RTENativeResult();
        try {
            CRSNative.rteGetArgList(template, argNames, attrValue, attrValueHint, version, result);
        }
        catch (RTENativeException e) {
            StringBuilder argNamesSB = new StringBuilder();
            for (String n : argNames) {
                if (argNamesSB.length() > 0) {
                    argNamesSB.append(',');
                }
                argNamesSB.append(n);
            }
            Trace.out("Failed to get argument list for resource:" + resName + " with arguments:" + argNamesSB.toString());
            throw new CRSException((MessageKey)PrCzMsgID.RTE_GETARGLIST_FAIL, (Throwable)e, resName, argNamesSB.toString());
        }
        return result;
    }

    private String postProcessDependencyString(String inStr) {
        if (inStr == null) {
            return "";
        }
        String outStr = "";
        inStr = inStr.replaceAll("\\s+", "");
        for (String depType : new String[]{"hard", "weak", "dispersion", "dispersion:active", "pullup", "exclusion", "pullup:always"}) {
            int to;
            int from;
            ArrayList<String> strList = new ArrayList<String>();
            int cur = 0;
            while (cur < inStr.length() && (from = inStr.indexOf(depType + "(", cur)) != -1 && (to = inStr.indexOf(")", from)) != -1) {
                if (to - from > depType.length() + 1) {
                    String[] elements;
                    for (String ele : elements = inStr.substring(from + depType.length() + 1, to).split(",")) {
                        if (ele.endsWith(":")) continue;
                        strList.add(ele);
                    }
                }
                cur = to + 1;
            }
            if (strList.size() <= 0) continue;
            if (outStr.length() > 0) {
                outStr = outStr + " ";
            }
            outStr = outStr + depType + "(";
            for (String e : strList) {
                if (!outStr.endsWith("(")) {
                    outStr = outStr + ",";
                }
                outStr = outStr + e;
            }
            outStr = outStr + ")";
        }
        return outStr;
    }

    static {
        s_upgradeMode = false;
        RUNNING_STATES = new String[]{"ONLINE", "INTERMEDIATE"};
    }
}

