/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.crs.ActionMessage;
import oracle.cluster.crs.ActionStatus;
import oracle.ops.mgmt.trace.Trace;

public class ActionStatusImpl
implements ActionStatus {
    protected Map<String, String> m_keyValMap = null;
    protected List<ActionMessage> m_amList = new ArrayList<ActionMessage>();
    protected Map<Integer, List<String>> m_errorMsg;
    protected List<String> m_warnMsg;
    protected List<String> m_sucMsg;
    protected boolean m_isError = false;
    protected boolean m_isWarning = false;
    protected boolean m_isNOOP = false;

    public ActionStatusImpl() {
        this.m_errorMsg = new HashMap<Integer, List<String>>();
        this.m_warnMsg = new ArrayList<String>();
        this.m_sucMsg = new ArrayList<String>();
    }

    public ActionStatusImpl(ActionMessage am) {
        this.m_amList.add(am);
        this.m_keyValMap = null;
    }

    public void addActionMessage(ActionMessage am) {
        this.m_amList.add(am);
        this.m_keyValMap = null;
    }

    @Override
    public String getActionValue(String actionKey) {
        if (this.m_keyValMap == null) {
            this.parsingMessages();
        }
        return this.m_keyValMap.get(actionKey);
    }

    @Override
    public String getErrorMessage() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuilder failedMsg = new StringBuilder();
        for (int errorID : this.m_errorMsg.keySet()) {
            List<String> errors = this.m_errorMsg.get(errorID);
            if (errors == null || errors.isEmpty()) {
                return "";
            }
            for (String err : errors) {
                Trace.out("Get error: " + err);
                String errStr = err.trim();
                if (errStr.contains("error={")) {
                    int indx = errStr.indexOf("error={");
                    errStr = errStr.substring(indx + 7, errStr.length() - 1);
                }
                failedMsg.append(errStr);
                if (errStr.endsWith(NEWLINE)) continue;
                failedMsg.append(NEWLINE);
            }
        }
        String failedMsgStr = failedMsg.toString();
        return failedMsgStr;
    }

    @Override
    public String getWarningMessage() {
        String warnMsg = "";
        if (this.m_warnMsg.isEmpty()) {
            return "";
        }
        for (String warn : this.m_warnMsg) {
            warnMsg = warnMsg + warn;
        }
        return warnMsg;
    }

    @Override
    public boolean isError() {
        return this.m_isError;
    }

    @Override
    public boolean isWarning() {
        return this.m_isWarning;
    }

    public boolean isNOOP() {
        return this.m_isNOOP;
    }

    private void parsingMessages() {
        if (this.m_keyValMap != null) {
            return;
        }
        this.m_keyValMap = new HashMap<String, String>();
        for (ActionMessage am : this.m_amList) {
            String[] amItems;
            String amMsg = am.getMessage();
            if (!amMsg.startsWith("#@=result[")) continue;
            int indx = amMsg.indexOf("]: ");
            String submsg = amMsg.substring(indx + 3, amMsg.length() - 1);
            Trace.out("submsg is " + submsg);
            for (String amItem : amItems = submsg.split("} ")) {
                Trace.out("amItem is " + amItem);
                int bIndx = amItem.indexOf("={");
                Trace.out("bIndx is " + bIndx);
                int eIndx = amItem.length();
                Trace.out("eIndx is " + eIndx);
                String amKey = amItem.substring(0, bIndx);
                Trace.out("amKey is " + amKey);
                String amValue = amItem.substring(bIndx + 2, eIndx);
                Trace.out("amValue is " + amValue);
                this.m_keyValMap.put(amKey, amValue);
            }
        }
    }
}

