/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.credentials;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.util.NotExistsException;
import oracle.gridnamingservice.CredentialSectionNotFoundException;
import oracle.gridnamingservice.CredentialValidationFailedException;
import oracle.gridnamingservice.GNSCredentialAttributes;
import oracle.gridnamingservice.GNSCredentials;
import oracle.gridnamingservice.GridNamingServiceException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;

public class GNSPropertiesImpl
implements GNSProperties {
    GNSCredentials m_gnsCred;
    private static final String DOT = ".";

    public GNSPropertiesImpl(String gnsCredFile) throws CredentialsException, NotExistsException {
        this.m_gnsCred = new GNSCredentials(gnsCredFile);
        try {
            this.m_gnsCred.validate();
        }
        catch (CredentialValidationFailedException e) {
            Trace.out((Exception)((Object)e));
            throw new CredentialsException(e);
        }
        catch (CredentialSectionNotFoundException e) {
            Trace.out((Exception)((Object)e));
            throw new NotExistsException(e);
        }
        catch (GridNamingServiceException e) {
            Trace.out((Exception)((Object)e));
            throw new CredentialsException(e);
        }
    }

    @Override
    public String getGNSSubDomain() throws CredentialsException {
        try {
            return this.m_gnsCred.getAttribute(GNSCredentialAttributes.SUBDOMAIN);
        }
        catch (GridNamingServiceException e) {
            throw new CredentialsException(e);
        }
    }

    @Override
    public String getGNSSubDomain(String clusterName) throws CredentialsException {
        String subDomain = null;
        try {
            subDomain = this.m_gnsCred.getAttribute(GNSCredentialAttributes.SUBDOMAIN);
            subDomain = clusterName + DOT + subDomain;
        }
        catch (GridNamingServiceException e) {
            throw new CredentialsException(e);
        }
        return subDomain;
    }

    @Override
    public String getGNSDiscoveryAddresses() throws CredentialsException {
        try {
            return this.m_gnsCred.getAttribute(GNSCredentialAttributes.DISCOVERY_ADDRESSES);
        }
        catch (GridNamingServiceException e) {
            throw new CredentialsException(e);
        }
    }

    @Override
    public Map<IPAddressUtil.IPAddrType, InetAddress> getGNSDiscoveryAddressMap() throws CredentialsException {
        String addresses = this.getGNSDiscoveryAddresses();
        HashMap<IPAddressUtil.IPAddrType, InetAddress> inetAddressMap = new HashMap<IPAddressUtil.IPAddrType, InetAddress>();
        try {
            int delimiterIndex = addresses.indexOf(" ");
            if (delimiterIndex != -1) {
                Trace.out((Object)"Discovery Addresses: %s", addresses);
                String ipv4Val = addresses.substring(0, delimiterIndex);
                String ipv6Val = addresses.substring(delimiterIndex + 1);
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, InetAddress.getByName(ipv4Val));
                inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, InetAddress.getByName(ipv6Val));
            } else {
                InetAddress inet = InetAddress.getByName(addresses);
                if (inet instanceof Inet4Address) {
                    Trace.out((Object)"IPv4 Address: %s", inet.getHostAddress());
                    inetAddressMap.put(IPAddressUtil.IPAddrType.IPv4, inet);
                } else {
                    Trace.out((Object)"IPv6 Address: %s", inet.getHostAddress());
                    inetAddressMap.put(IPAddressUtil.IPAddrType.IPv6, inet);
                }
            }
        }
        catch (UnknownHostException uhe) {
            throw new CredentialsException(uhe);
        }
        return inetAddressMap;
    }
}

