/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.credentials;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.credentials.CredDomain;
import oracle.cluster.credentials.Credentials;
import oracle.cluster.credentials.CredentialsACLPerm;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.CredentialsSet;
import oracle.cluster.credentials.CredentialsType;
import oracle.cluster.credentials.KeyPairCredentials;
import oracle.cluster.credentials.SharedKeyCredentials;
import oracle.cluster.credentials.UserPassCredentials;
import oracle.cluster.credentials.WalletCredentials;
import oracle.cluster.impl.credentials.CredDomainImpl;
import oracle.cluster.impl.credentials.CredNative;
import oracle.cluster.impl.credentials.CredentialsAttribute;
import oracle.cluster.impl.credentials.CredentialsImpl;
import oracle.cluster.impl.credentials.CredentialsNativeResult;
import oracle.cluster.impl.credentials.KeyPairCredentialsImpl;
import oracle.cluster.impl.credentials.SharedKeyCredentialsImpl;
import oracle.cluster.impl.credentials.UserPassCredentialsImpl;
import oracle.cluster.impl.credentials.WalletCredentialsImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CredentialsSetImpl
implements CredentialsSet {
    CredentialsType m_credType;
    CredDomain m_domain;

    public CredentialsSetImpl(CredDomain domain, CredentialsType type) {
        this.m_credType = type;
        this.m_domain = domain;
    }

    @Override
    public Credentials getCredentials(int memberID) throws CredentialsException, NotExistsException {
        this.credentialsExist(memberID);
        return this.buildCredentials(memberID);
    }

    @Override
    public WalletCredentials getWalletCredentials(int credID) throws CredentialsException, NotExistsException {
        if (this.m_credType != CredentialsType.WALLET) {
            throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_METHOD_FAILED, CredentialsType.WALLET.name(), this.m_credType.name());
        }
        this.credentialsExist(credID);
        WalletCredentialsImpl wallet = new WalletCredentialsImpl(this);
        wallet.setMemberID(credID);
        return wallet;
    }

    @Override
    public UserPassCredentials getUserPassCredentials(int credID) throws CredentialsException, NotExistsException {
        if (this.m_credType != CredentialsType.USERPASS) {
            throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_METHOD_FAILED, CredentialsType.USERPASS.name(), this.m_credType.name());
        }
        this.credentialsExist(credID);
        UserPassCredentialsImpl userpass = new UserPassCredentialsImpl(this);
        userpass.setMemberID(credID);
        return userpass;
    }

    @Override
    public SharedKeyCredentials getSharedKeyCredentials(int credID) throws CredentialsException, NotExistsException {
        if (this.m_credType != CredentialsType.SHAREDKEY) {
            throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_METHOD_FAILED, CredentialsType.SHAREDKEY.name(), this.m_credType.name());
        }
        this.credentialsExist(credID);
        SharedKeyCredentialsImpl sharedKey = new SharedKeyCredentialsImpl(this);
        sharedKey.setMemberID(credID);
        return sharedKey;
    }

    @Override
    public KeyPairCredentials getKeyPairCredentials(int credID) throws CredentialsException, NotExistsException {
        if (this.m_credType != CredentialsType.KEYPAIR) {
            throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_METHOD_FAILED, CredentialsType.KEYPAIR.name(), this.m_credType.name());
        }
        this.credentialsExist(credID);
        KeyPairCredentialsImpl keyPair = new KeyPairCredentialsImpl(this);
        keyPair.setMemberID(credID);
        return keyPair;
    }

    private void credentialsExist(int credID) throws CredentialsException, NotExistsException {
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        int numCreds = CredNative.doCountCred(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), this.m_domain.isOCR(), credNativeResult);
        Trace.out("There are %s credentials", numCreds);
        if (credID < 0) {
            Trace.out("Invalid credential id");
            throw new CredentialsException((MessageKey)PrCzMsgID.INVALID_CRED_VALUE, new Object[0]);
        }
        if (numCreds < 1 || credID >= numCreds) {
            Trace.out("Credentials do not exist with that ID");
            throw new NotExistsException((MessageKey)PrCzMsgID.CRED_NOT_EXISTS, credID);
        }
    }

    private Credentials buildCredentials(int memberID) throws CredentialsException {
        CredentialsImpl credential = null;
        switch (this.m_credType) {
            case USERPASS: {
                credential = new UserPassCredentialsImpl(this);
                break;
            }
            case SHAREDKEY: {
                credential = new SharedKeyCredentialsImpl(this);
                break;
            }
            case KEYPAIR: {
                credential = new KeyPairCredentialsImpl(this);
                break;
            }
            case WALLET: {
                credential = new WalletCredentialsImpl(this);
            }
        }
        credential.setMemberID(memberID);
        return credential;
    }

    @Override
    public List<Credentials> getAllCredentials() throws CredentialsException {
        ArrayList<Credentials> credentials = new ArrayList<Credentials>();
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        int count = CredNative.doCountCred(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), this.m_domain.isOCR(), credNativeResult);
        for (int i = 0; i < count; ++i) {
            credentials.add(this.buildCredentials(i));
        }
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_COUNT_FAILED, errorString);
            }
        }
        return credentials;
    }

    @Override
    public void importFromWrapFile(String filePath) throws CredentialsException {
        if (filePath == null || filePath.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "filePath");
        }
        File wrapFile = new File(filePath);
        if (wrapFile.exists() && wrapFile.canRead()) {
            throw new CredentialsException((MessageKey)PrCtMsgID.INVALID_FILE_PATH, filePath);
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doCredSetImportWrap(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), filePath, false, this.m_domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_IMPORT_FAILED, errorString);
            }
        }
    }

    @Override
    public void importFromWrapBuffer(String buffer) throws CredentialsException {
        if (buffer == null || buffer.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "buffer");
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doCredSetImportWrap(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), buffer, true, this.m_domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_IMPORT_BUFFER_FAILED, errorString);
            }
        }
    }

    @Override
    public void exportToWrapFile(String filePath) throws CredentialsException {
        this.internalExportToWrapFile(filePath, 0, true);
    }

    @Override
    public void exportToWrapFile(String filePath, int credID) throws CredentialsException {
        this.internalExportToWrapFile(filePath, credID, false);
    }

    private void internalExportToWrapFile(String filePath, int credID, boolean isExportAll) throws CredentialsException {
        if (filePath == null || filePath.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "filePath");
        }
        File fileName = new File(filePath);
        if (fileName.exists()) {
            throw new CredentialsException((MessageKey)PrCzMsgID.FILE_ALREADY_EXISTS, filePath);
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doCredSetExportWrap(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), filePath, credID, false, isExportAll, this.m_domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_EXPORT_FAILED, filePath, errorString);
            }
        }
    }

    @Override
    public String exportToWrapBuffer() throws CredentialsException {
        return this.internalExportToWrapBuffer(0, true);
    }

    @Override
    public String exportToWrapBuffer(int credID) throws CredentialsException {
        return this.internalExportToWrapBuffer(credID, false);
    }

    private String internalExportToWrapBuffer(int credID, boolean isExportAll) throws CredentialsException {
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doCredSetExportWrap(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), null, credID, true, isExportAll, this.m_domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_EXPORT_BUFFER_FAILED, errorString);
            }
        }
        Trace.out("WrapBuffer = " + credNativeResult.getCredential());
        return credNativeResult.getCredential();
    }

    @Override
    public void removeCredentials(int memberID) throws CredentialsException, NotExistsException {
        this.credentialsExist(memberID);
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doRemoveCred(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), memberID, this.m_domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_MEMBER_DELETION_FAILED, memberID, errorString);
            }
        }
    }

    @Override
    public CredentialsType getCredType() {
        return this.m_credType;
    }

    @Override
    public void setAttributes(Map<String, String> attrKeyValue) throws CredentialsException {
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        String[] attrValues = null;
        if (attrKeyValue != null) {
            attrKeys = attrKeyValue.keySet().toArray(new String[0]);
            attrValues = new String[attrKeys.length];
            int i = 0;
            for (String key : attrKeys) {
                attrValues[i] = attrKeyValue.get(key);
                ++i;
            }
        }
        CredNative.doSetCredSetAttrs(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), attrKeys, attrValues, this.m_domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_ATTR_FAILED, errorString);
            }
        }
    }

    @Override
    public Map<String, String> getAttributes(List<String> keyList) throws CredentialsException, NotExistsException {
        if (keyList == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "keyList");
        }
        Map<String, String> attrMap = null;
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        if (keyList != null && !keyList.isEmpty()) {
            attrKeys = keyList.toArray(new String[keyList.size()]);
            CredNative.doGetCredSetAttrs(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), attrKeys, this.m_domain.isOCR(), credNativeResult);
            if (!credNativeResult.getBooleanResult()) {
                Trace.out("result is not successful");
                String errorString = credNativeResult.getOSString();
                Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
                Trace.out("Error message: " + errorString);
                if (credNativeResult.getOSErrCode() == CredNative.NOT_EXISTS) {
                    throw new NotExistsException((MessageKey)PrCzMsgID.CREDSET_GET_ATTR_NOTFOUND, new Object[0]);
                }
                if (errorString != null) {
                    throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_GET_ATTR_FAILED, errorString);
                }
            }
            attrMap = credNativeResult.getAttrMap();
        }
        return attrMap;
    }

    @Override
    public CredDomain getDomain() {
        return this.m_domain;
    }

    public void setDomain(CredDomain domain) {
        this.m_domain = domain;
    }

    @Override
    public UserPassCredentials createUserPassCredentials(String username, String password) throws CredentialsException {
        return this.internalCreateUserPassCredentials(username, password, null);
    }

    @Override
    public UserPassCredentials createUserPassCredentials(String username, String password, Map<String, String> attrKeyValue) throws CredentialsException {
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        return this.internalCreateUserPassCredentials(username, password, attrKeyValue);
    }

    private UserPassCredentials internalCreateUserPassCredentials(String username, String password, Map<String, String> attrKeyValue) throws CredentialsException {
        if (username == null || username.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "username");
        }
        if (password == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "password");
        }
        if (this.m_credType != CredentialsType.USERPASS) {
            throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_METHOD_FAILED, CredentialsType.USERPASS.name(), this.m_credType.name());
        }
        UserPassCredentialsImpl userPassCredential = new UserPassCredentialsImpl(this);
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        String[] attrValues = null;
        if (attrKeyValue != null) {
            attrKeys = attrKeyValue.keySet().toArray(new String[0]);
            attrValues = new String[attrKeys.length];
            int i = 0;
            for (String key : attrKeys) {
                attrValues[i] = attrKeyValue.get(key);
                ++i;
            }
        }
        CredNative.doCreateUserPassCred(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), username, password, attrKeys, attrValues, this.m_domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_ADD_USERPASS_FAILED, username, errorString);
            }
        }
        userPassCredential.setMemberID(credNativeResult.getMemberID());
        return userPassCredential;
    }

    @Override
    public KeyPairCredentials createKeyPairCredentials(String publicKey, String privateKey) throws CredentialsException {
        return this.internalCreateKeyPairCredentials(publicKey, privateKey, null);
    }

    @Override
    public KeyPairCredentials createKeyPairCredentials(String publicKey, String privateKey, Map<String, String> attrKeyValue) throws CredentialsException {
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        return this.internalCreateKeyPairCredentials(publicKey, privateKey, attrKeyValue);
    }

    private KeyPairCredentials internalCreateKeyPairCredentials(String publicKey, String privateKey, Map<String, String> attrKeyValue) throws CredentialsException {
        if (publicKey == null || publicKey.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "publicKey");
        }
        if (privateKey == null || privateKey.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "privateKey");
        }
        if (this.m_credType != CredentialsType.KEYPAIR) {
            throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_METHOD_FAILED, CredentialsType.KEYPAIR.name(), this.m_credType.name());
        }
        KeyPairCredentialsImpl keyPairCredential = new KeyPairCredentialsImpl(this);
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        String[] attrValues = null;
        if (attrKeyValue != null) {
            attrKeys = attrKeyValue.keySet().toArray(new String[0]);
            attrValues = new String[attrKeys.length];
            int i = 0;
            for (String key : attrKeys) {
                attrValues[i] = attrKeyValue.get(key);
                ++i;
            }
        }
        CredNative.doCreateKeyPairCred(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), publicKey, privateKey, attrKeys, attrValues, this.m_domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_KEYPAIR_CREATION_FAILED, errorString);
            }
        }
        keyPairCredential.setMemberID(credNativeResult.getMemberID());
        return keyPairCredential;
    }

    @Override
    public SharedKeyCredentials createSharedKeyCredentials(String sharedKey) throws CredentialsException {
        return this.internalCreateSharedKeyCredentials(sharedKey, null);
    }

    @Override
    public SharedKeyCredentials createSharedKeyCredentials(String sharedKey, Map<String, String> attrKeyValue) throws CredentialsException {
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        return this.internalCreateSharedKeyCredentials(sharedKey, attrKeyValue);
    }

    private SharedKeyCredentials internalCreateSharedKeyCredentials(String sharedKey, Map<String, String> attrKeyValue) throws CredentialsException {
        if (sharedKey == null || sharedKey.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sharedKey");
        }
        if (this.m_credType != CredentialsType.SHAREDKEY) {
            throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_METHOD_FAILED, CredentialsType.SHAREDKEY.name(), this.m_credType.name());
        }
        SharedKeyCredentialsImpl sharedKeyCredential = new SharedKeyCredentialsImpl(this);
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        String[] attrValues = null;
        if (attrKeyValue != null) {
            attrKeys = attrKeyValue.keySet().toArray(new String[0]);
            attrValues = new String[attrKeys.length];
            int i = 0;
            for (String key : attrKeys) {
                attrValues[i] = attrKeyValue.get(key);
                ++i;
            }
        }
        CredNative.doCreateSharedKeyCred(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), sharedKey, attrKeys, attrValues, this.m_domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_SHAREDKEY_CREATION_FAILED, errorString);
            }
        }
        sharedKeyCredential.setMemberID(credNativeResult.getMemberID());
        return sharedKeyCredential;
    }

    @Override
    public WalletCredentials createWalletCredentials(String wallet) throws CredentialsException {
        return this.internalCreateWallet(wallet, null, null);
    }

    @Override
    public WalletCredentials createWalletCredentials(String wallet, Map<String, String> attrKeyValue) throws CredentialsException {
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        return this.internalCreateWallet(wallet, null, attrKeyValue);
    }

    @Override
    public WalletCredentials createWalletCredentials(String walletPath, String password) throws CredentialsException {
        if (password == null || password.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "password");
        }
        return this.internalCreateWallet(walletPath, password, null);
    }

    @Override
    public WalletCredentials createWalletCredentials(String walletPath, String password, Map<String, String> attrKeyValue) throws CredentialsException {
        if (password == null || password.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "password");
        }
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        return this.internalCreateWallet(walletPath, password, null);
    }

    private WalletCredentials internalCreateWallet(String wallet, String password, Map<String, String> attrKeyValue) throws CredentialsException {
        if (wallet == null || wallet.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "wallet");
        }
        if (this.m_credType != CredentialsType.WALLET) {
            throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_METHOD_FAILED, CredentialsType.WALLET.name(), this.m_credType.name());
        }
        WalletCredentialsImpl walletCredential = new WalletCredentialsImpl(this);
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        String[] attrValues = null;
        if (attrKeyValue != null) {
            attrKeys = attrKeyValue.keySet().toArray(new String[0]);
            attrValues = new String[attrKeys.length];
            int i = 0;
            for (String key : attrKeys) {
                attrValues[i] = attrKeyValue.get(key);
                ++i;
            }
        }
        CredNative.doCreateWalletCred(((CredDomainImpl)this.m_domain).getId(), this.m_credType.getValue(), wallet, password, attrKeys, attrValues, this.m_domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_WALLET_CREATION_FAILED, errorString);
            }
        }
        walletCredential.setMemberID(credNativeResult.getMemberID());
        return walletCredential;
    }

    @Override
    public void setPGroup(String group) throws CredentialsException {
        if (group == null || group.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "group");
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put(CredentialsAttribute.GROUP.getValue(), group);
        this.setAttributes(attr);
    }

    @Override
    public String getPGroup() throws CredentialsException, NotExistsException {
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.GROUP.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        return attr.get(CredentialsAttribute.GROUP.getValue());
    }

    @Override
    public void setOwner(String owner) throws CredentialsException {
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put(CredentialsAttribute.OWNER.getValue(), owner);
        this.setAttributes(attr);
    }

    @Override
    public String getOwner() throws CredentialsException, NotExistsException {
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.OWNER.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        return attr.get(CredentialsAttribute.OWNER.getValue());
    }

    @Override
    public void setOwnerPerms(CredentialsACLPerm ... aclPerms) throws CredentialsException {
        try {
            String perms = CredentialsFactory.formatOwnerACLString(this.getOwner(), aclPerms);
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put(CredentialsAttribute.OWNER_PERMS.getValue(), perms);
            this.setAttributes(attr);
        }
        catch (NotExistsException nee) {
            throw new CredentialsException(nee);
        }
    }

    @Override
    public String getOwnerPerms() throws CredentialsException, NotExistsException {
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.OWNER_PERMS.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        return attr.get(CredentialsAttribute.OWNER_PERMS.getValue());
    }

    @Override
    public void setPGroupPerms(CredentialsACLPerm ... aclPerms) throws CredentialsException {
        try {
            String perms = CredentialsFactory.formatGroupACLString(this.getPGroup(), aclPerms);
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put(CredentialsAttribute.GROUP_PERMS.getValue(), perms);
            this.setAttributes(attr);
        }
        catch (NotExistsException nee) {
            throw new CredentialsException(nee);
        }
    }

    @Override
    public String getPGroupPerms() throws CredentialsException, NotExistsException {
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.GROUP_PERMS.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        return attr.get(CredentialsAttribute.GROUP_PERMS.getValue());
    }

    @Override
    public void setOtherPerms(CredentialsACLPerm ... aclPerms) throws CredentialsException {
        String perms = CredentialsFactory.formatOtherACLString(aclPerms);
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put(CredentialsAttribute.OTHER_PERMS.getValue(), perms);
        this.setAttributes(attr);
    }

    @Override
    public String getOtherPerms() throws CredentialsException, NotExistsException {
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.OTHER_PERMS.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        return attr.get(CredentialsAttribute.OTHER_PERMS.getValue());
    }
}

