/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.credentials;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.ASMProperties;
import oracle.cluster.credentials.CredDomain;
import oracle.cluster.credentials.CredFileDomain;
import oracle.cluster.credentials.CredentialsACLPerm;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsSet;
import oracle.cluster.credentials.CredentialsType;
import oracle.cluster.credentials.GIMRProperties;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.credentials.MGMTDBProperties;
import oracle.cluster.credentials.UserPassCredentials;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.GIMRComponent;
import oracle.cluster.deployment.ClientClusterComponent;
import oracle.cluster.gridhome.GridHomeFactory;
import oracle.cluster.impl.credentials.ASMPropertiesImpl;
import oracle.cluster.impl.credentials.CredDomainImpl;
import oracle.cluster.impl.credentials.CredFileDomainImpl;
import oracle.cluster.impl.credentials.CredNative;
import oracle.cluster.impl.credentials.CredentialsNativeResult;
import oracle.cluster.impl.credentials.GIMRPropertiesImpl;
import oracle.cluster.impl.credentials.GNSPropertiesImpl;
import oracle.cluster.impl.credentials.MGMTDBPropertiesImpl;
import oracle.cluster.impl.credentials.WrapNative;
import oracle.cluster.impl.credentials.WrapNativeException;
import oracle.cluster.impl.credentials.WrapNativeResult;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CredentialsFactoryImpl {
    private static CredentialsFactoryImpl s_instance;

    private CredentialsFactoryImpl() throws CredentialsException {
    }

    public static synchronized CredentialsFactoryImpl getInstance() throws CredentialsException {
        if (null == s_instance) {
            s_instance = new CredentialsFactoryImpl();
        }
        return s_instance;
    }

    public ASMProperties getAndValidateASMProperties(HashMap<String, String> propmap) throws CredentialsException {
        return new ASMPropertiesImpl(propmap, true);
    }

    public ASMProperties getASMProperties(HashMap<String, String> propmap) throws CredentialsException {
        return new ASMPropertiesImpl(propmap, false);
    }

    public HashMap<String, String> getCredentialProperties(String credFile, String sectionName) throws CredentialsException {
        try {
            return (HashMap)this.internalGetCredProperties(credFile, sectionName);
        }
        catch (NotExistsException nee) {
            throw new CredentialsException(nee);
        }
    }

    public Map<String, String> getCredProperties(String credFile, String sectionName) throws CredentialsException, NotExistsException {
        return this.internalGetCredProperties(credFile, sectionName);
    }

    private Map<String, String> internalGetCredProperties(String credFile, String sectionName) throws CredentialsException, NotExistsException {
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            if (!m_system.isCredLibraryLoaded()) {
                m_system.loadSRVMCREDNativeLibrary();
            }
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        WrapNativeResult result = new WrapNativeResult();
        Trace.out("Get credential properties of section " + sectionName + " from file " + credFile);
        try {
            WrapNative.getProperties(result, credFile, sectionName);
        }
        catch (WrapNativeException e) {
            throw new CredentialsException(e);
        }
        if (!result.getStatus()) {
            String retErr = result.getOSString();
            Trace.out("Error code is....." + retErr);
            if (retErr.equalsIgnoreCase("CLSXERR_WRAP_NOT_FOUND")) {
                throw new NotExistsException((MessageKey)PrCzMsgID.CRED_SECTION_NOT_EXISTS, sectionName, credFile);
            }
            throw new CredentialsException((MessageKey)PrCgMsgID.BAD_XMLFILE, credFile);
        }
        return result.getPropertyMap();
    }

    public String getCredentialProperty(String credFile, String sectionName, String propertyName) throws CredentialsException {
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            m_system.loadSRVMCREDNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        WrapNativeResult result = new WrapNativeResult();
        Trace.out("Get credential property " + propertyName + " of section " + sectionName + " from file " + credFile);
        String propval = null;
        try {
            propval = WrapNative.getProperty(result, credFile, sectionName, propertyName);
            if (!result.getStatus()) {
                Trace.out("Error code is....." + result.getOSString());
                throw new CredentialsException((MessageKey)PrCgMsgID.BAD_XMLFILE, credFile);
            }
            if (propval == null) {
                Trace.out("Attribute " + propertyName + " does not exist in credentail file");
                throw new CredentialsException((MessageKey)PrCgMsgID.ATTRIBUTE_NOT_EXISTS, propertyName, credFile);
            }
        }
        catch (WrapNativeException e) {
            throw new CredentialsException(e);
        }
        return propval;
    }

    public ASMProperties getASMProperties(String asmCredFile) throws CredentialsException {
        return new ASMPropertiesImpl(this.getCredentialProperties(asmCredFile, "ASM_attributes"));
    }

    public GNSProperties getGNSProperties(String gnsCredFile) throws CredentialsException {
        try {
            return new GNSPropertiesImpl(gnsCredFile);
        }
        catch (NotExistsException e) {
            throw new CredentialsException(e);
        }
    }

    public GNSProperties getGNSPropertiesFromManifest(String manifestFile) throws CredentialsException, NotExistsException {
        return new GNSPropertiesImpl(manifestFile);
    }

    public MGMTDBProperties getMGMTDBProperties() throws CredentialsException {
        try {
            DatabaseFactory df = DatabaseFactory.getInstance();
            df.getMgmtDatabase();
            throw new CredentialsException((MessageKey)PrCtMsgID.MGMTDB_GETCRED_INFO_SERVER, new Object[0]);
        }
        catch (NotExistsException ne) {
            try {
                String clientCluster = new ClusterUtil().getClusterName();
                GIMRProperties gimr = this.internalGetGIMRProperties(clientCluster, null);
                return new MGMTDBPropertiesImpl(gimr.getServerClusterName(), gimr.getScanName(), gimr.getScanPort(), gimr.getServiceName());
            }
            catch (NotExistsException nee) {
                throw new CredentialsException(nee);
            }
            catch (ClusterUtilException e) {
                throw new CredentialsException(e);
            }
        }
        catch (SoftwareModuleException e) {
            throw new CredentialsException(e);
        }
    }

    public GIMRProperties getGIMRProperties() throws CredentialsException, NotExistsException {
        try {
            String clusterGUID = new ClusterUtil().getClusterGUID();
            return this.internalGetGIMRProperties(clusterGUID, null);
        }
        catch (ClusterUtilException e) {
            throw new CredentialsException(e);
        }
    }

    public GIMRProperties getGIMRProperties(String credFile) throws CredentialsException, NotExistsException {
        if (credFile == null || credFile.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "credFile");
        }
        return this.internalGetGIMRProperties(null, credFile);
    }

    public GIMRProperties getGIMRProperties(String clientCluster, String credFile) throws CredentialsException, NotExistsException {
        if (clientCluster == null || clientCluster.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "clientCluster");
        }
        if (credFile == null || credFile.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "credFile");
        }
        return this.internalGetGIMRProperties(clientCluster, credFile);
    }

    private void validateGIMRClientClusterGUID(String clusterGUID) throws CredentialsException, NotExistsException {
        try {
            if (clusterGUID == null || clusterGUID.isEmpty()) {
                throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "clusterGUID");
            }
            DatabaseFactory.getInstance().getMgmtDatabase();
            Trace.out("Getting properties from GIMR Server");
        }
        catch (NotExistsException nee) {
            String currentCluster = "";
            try {
                currentCluster = new ClusterUtil().getClusterGUID();
                if (!clusterGUID.equalsIgnoreCase(currentCluster)) {
                    Trace.out("Client GIMR environment, cannot retrieve other client cluster credentials");
                    throw new CredentialsException((MessageKey)PrCcMsgID.GIMR_INVALID_CLIENT_CLUSTER_QUERY, clusterGUID);
                }
            }
            catch (ClusterUtilException cue) {
                throw new CredentialsException(cue);
            }
        }
        catch (DatabaseException e) {
            throw new CredentialsException(e);
        }
        catch (SoftwareModuleException e) {
            throw new CredentialsException(e);
        }
    }

    private GIMRProperties internalGetGIMRProperties(String clusterGUID, String credFile) throws CredentialsException, NotExistsException {
        try {
            GIMRPropertiesImpl properties = null;
            Map<String, String> map = null;
            if (credFile == null) {
                CredDomain clientDomain = null;
                ArrayList<String> attributes = new ArrayList<String>();
                String serverClusterGUID = null;
                Trace.out("Getting GIMR properties from credStore");
                CredDomain domain = this.getDomainByPath("GIMR/SELF", true);
                attributes.add("SERVER_CLUSTER_GUID");
                serverClusterGUID = domain.getAttributes(attributes).get("SERVER_CLUSTER_GUID");
                if (serverClusterGUID == null) {
                    throw new CredentialsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "GIMR-prop-error_1");
                }
                clientDomain = this.getDomainByPath(serverClusterGUID + "/" + clusterGUID, domain);
                attributes = new ArrayList();
                attributes.add("DOMAIN_CLUSTER_NAME");
                attributes.add("SCAN_NAME");
                attributes.add("SCAN_PORT");
                attributes.add("SERVICE_NAME");
                attributes.add("MEMBER_CLUSTER_NAME");
                attributes.add("CLUSTER_GUID");
                attributes.add("PDB_NAME");
                map = clientDomain.getAttributes(attributes);
            } else {
                Trace.out("Getting properties from GIMR section");
                map = this.getCredProperties(credFile, "GIMR");
            }
            String domainCluster = map.get("DOMAIN_CLUSTER_NAME");
            String scanName = map.get("SCAN_NAME");
            String scanPort = map.get("SCAN_PORT");
            String serviceName = map.get("SERVICE_NAME");
            String pdbName = map.get("PDB_NAME");
            String memberCluster = map.get("MEMBER_CLUSTER_NAME");
            if (clusterGUID == null) {
                clusterGUID = map.get("CLUSTER_GUID");
            }
            properties = new GIMRPropertiesImpl(domainCluster, scanName, scanPort, serviceName, pdbName, memberCluster, clusterGUID);
            Trace.out("Domain cluster name = " + domainCluster);
            Trace.out("Scan name = " + scanName);
            Trace.out("Scan port = " + scanPort);
            Trace.out("Service name = " + serviceName);
            Trace.out("Service name = " + pdbName);
            Trace.out("Member cluster name = " + memberCluster);
            Trace.out("Cluster GUID = " + clusterGUID);
            return properties;
        }
        catch (NotExistsException nee) {
            throw new NotExistsException((MessageKey)PrCzMsgID.GIMR_CLIENT_NOT_EXISTS, (Throwable)nee, clusterGUID);
        }
    }

    public UserPassCredentials getGIMRComponentCredentials(GIMRComponent comp) throws CredentialsException, NotExistsException {
        String currentCluster = "";
        try {
            currentCluster = new ClusterUtil().getClusterGUID();
        }
        catch (ClusterUtilException cue) {
            throw new CredentialsException(cue);
        }
        return this.internalGetGIMRComponentCredentials(comp, currentCluster);
    }

    public UserPassCredentials getGIMRComponentCredentials(GIMRComponent comp, String clientCluster) throws CredentialsException, NotExistsException {
        if (clientCluster == null || clientCluster.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "clientCluster");
        }
        try {
            DatabaseFactory.getInstance().getMgmtDatabase();
            Trace.out("Local GIMR environment");
        }
        catch (NotExistsException nee) {
            String currentCluster = "";
            try {
                currentCluster = new ClusterUtil().getClusterGUID();
                if (!clientCluster.equalsIgnoreCase(currentCluster)) {
                    Trace.out("Client GIMR environment, cannot retrieve other client cluster credentials");
                    throw new CredentialsException((MessageKey)PrCcMsgID.GIMR_INVALID_CLIENT_CLUSTER_QUERY, clientCluster);
                }
            }
            catch (ClusterUtilException cue) {
                throw new CredentialsException(cue);
            }
        }
        catch (SoftwareModuleException sme) {
            throw new CredentialsException(sme);
        }
        return this.internalGetGIMRComponentCredentials(comp, clientCluster);
    }

    public UserPassCredentials getGIMRComponentCredFromClusterGUID(GIMRComponent comp, String clusterGUID) throws CredentialsException, NotExistsException {
        this.validateGIMRClientClusterGUID(clusterGUID);
        return this.internalGetGIMRComponentCredentials(comp, clusterGUID);
    }

    private UserPassCredentials internalGetGIMRComponentCredentials(GIMRComponent comp, String clientCluster) throws CredentialsException, NotExistsException {
        if (comp == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "GIMR component");
        }
        String component = comp == GIMRComponent.RHP ? GridHomeFactory.getRHPSSchemaName() : comp.toString();
        Trace.out("Getting base GIMR domain");
        CredDomain domain = this.getDomainByPath("GIMR/SELF", true);
        CredDomainImpl clientDomain = null;
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("SERVER_CLUSTER_GUID");
        Map<String, String> mgmtdbAttr = domain.getAttributes(attributes);
        String serverClusterGUID = mgmtdbAttr.get("SERVER_CLUSTER_GUID");
        Trace.out("Server cluster GUID: " + serverClusterGUID);
        if (serverClusterGUID == null) {
            throw new CredentialsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "GIMR-comp-error_1");
        }
        clientDomain = (CredDomainImpl)this.getDomainByPath(serverClusterGUID + "/" + clientCluster + "/" + component, (CredDomainImpl)domain);
        CredentialsSet uspass = clientDomain.getCredentialsSet(CredentialsType.USERPASS);
        return uspass.getUserPassCredentials(0);
    }

    private boolean isValidClientDataFile(String fileName) {
        File clientDataFile = new File(fileName);
        return clientDataFile.exists() && clientDataFile.canRead();
    }

    public int importWalletFromFile(String clientData, String target) throws CredentialsException {
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        if (!this.isValidClientDataFile(clientData)) {
            throw new CredentialsException((MessageKey)PrCtMsgID.INVALID_FILE_PATH, clientData);
        }
        return CredNative.importWalletFile(clientData, target);
    }

    public int importWalletFromFile(String clientData, String target, String domain) throws CredentialsException {
        try {
            Util util = new Util();
            String user = util.getCRSUser();
            String pgroup = null;
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                pgroup = util.getPrimaryGroup(user);
            }
            return this.importWalletFromFile(clientData, target, domain, user, pgroup);
        }
        catch (UtilException e) {
            throw new CredentialsException(e);
        }
    }

    public int importWalletFromFile(String clientData, String target, String domain, String owner, String pgroup) throws CredentialsException {
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        if (!this.isValidClientDataFile(clientData)) {
            throw new CredentialsException((MessageKey)PrCtMsgID.INVALID_FILE_PATH, clientData);
        }
        return CredNative.importWalletFileToTarget(clientData, target, domain, owner, pgroup);
    }

    public void deleteWallet(String domain, int memberId) throws CredentialsException {
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredNative.deleteWallet(domain, memberId);
    }

    public void storeUserpassCredentials(String username, String password, HashMap<String, String> attributes, String target, String domain, String owner) throws CredentialsException {
        String[] attrNames = attributes.keySet().toArray(new String[0]);
        String[] attrValues = new String[attrNames.length];
        int i = 0;
        for (String key : attrNames) {
            String value = attributes.get(key);
            attrValues[i++] = value;
        }
        CredNative.storeUserpassCredentials(username, password, attrNames, attrValues, target, domain, owner);
    }

    public void storeWalletCredentials(String walletPath, HashMap<String, String> attributes, String target, String domain, String owner) throws CredentialsException {
        String[] attrNames = attributes.keySet().toArray(new String[0]);
        String[] attrValues = new String[attrNames.length];
        int i = 0;
        for (String key : attrNames) {
            String value = attributes.get(key);
            attrValues[i++] = value;
        }
        CredNative.storeWalletCredentials(walletPath, attrNames, attrValues, target, domain, owner);
    }

    public void storeUserpassAndWalletCredentials(String username, String password, String walletPath, String walletPassword, HashMap<String, String> attributes, String target, String domain, String owner) throws CredentialsException {
        String[] attrNames = attributes.keySet().toArray(new String[0]);
        String[] attrValues = new String[attrNames.length];
        int i = 0;
        for (String key : attrNames) {
            String value = attributes.get(key);
            attrValues[i++] = value;
        }
        CredNative.storeUserpassAndWalletCredentials(username, password, walletPath, walletPassword, attrNames, attrValues, target, domain, owner);
    }

    public void deleteCredentials(String target, String domain) throws NotExistsException, CredentialsException {
        CredNative.deleteCredentials(target, domain);
    }

    public HashMap<String, String> getAttributes(String target, String domain, String[] attrNames) throws NotExistsException, CredentialsException {
        String[] attrValues = CredNative.getAttrValues(target, domain, attrNames);
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < attrNames.length; ++i) {
            attributes.put(attrNames[i], attrValues[i]);
        }
        return attributes;
    }

    public String getUsername(String target, String domain) throws NotExistsException, CredentialsException {
        return CredNative.getUsername(target, domain);
    }

    public CredDomain createDomain(String path, boolean isOCR) throws AlreadyExistsException, CredentialsException {
        return this.internalCreateDomain(path, null, null, isOCR, null);
    }

    public CredDomain createDomain(String path, String target, boolean isOCR) throws AlreadyExistsException, CredentialsException {
        if (target == null || target.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "target");
        }
        return this.internalCreateDomain(path, target, null, isOCR, null);
    }

    public CredDomain createDomain(String path, String target, Map<String, String> attrKeyValue, boolean isOCR) throws AlreadyExistsException, CredentialsException {
        if (target == null || target.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "target");
        }
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        return this.internalCreateDomain(path, target, attrKeyValue, isOCR, null);
    }

    public CredDomain createDomain(String path, Map<String, String> attrKeyValue, boolean isOCR) throws AlreadyExistsException, CredentialsException {
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        return this.internalCreateDomain(path, null, attrKeyValue, isOCR, null);
    }

    public CredDomain createDomain(String path, CredDomain baseDomain) throws AlreadyExistsException, CredentialsException {
        if (baseDomain == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "baseDomain");
        }
        return this.internalCreateDomain(path, null, null, baseDomain.isOCR(), baseDomain);
    }

    public CredDomain createDomain(String path, CredDomain baseDomain, Map<String, String> attrKeyValue) throws AlreadyExistsException, CredentialsException {
        if (baseDomain == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "baseDomain");
        }
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        return this.internalCreateDomain(path, null, attrKeyValue, baseDomain.isOCR(), baseDomain);
    }

    private CredDomain internalCreateDomain(String path, String target, Map<String, String> attributes, boolean isOCR, CredDomain baseDomain) throws AlreadyExistsException, CredentialsException {
        if (path == null || path.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "path");
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredDomainImpl domain = baseDomain == null ? new CredDomainImpl(isOCR) : new CredDomainImpl(baseDomain);
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        String[] attrValues = null;
        domain.setPath(path);
        if (attributes != null) {
            attrKeys = attributes.keySet().toArray(new String[0]);
            attrValues = new String[attrKeys.length];
            int i = 0;
            for (String key : attrKeys) {
                attrValues[i] = attributes.get(key);
                ++i;
            }
        }
        String parent = domain.getParentDomain() == null ? null : ((CredDomainImpl)domain.getParentDomain()).getId();
        CredNative.doCreateDomain(parent, path, target, attrKeys, attrValues, domain.isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                if (credNativeResult.getOSErrCode() == CredNative.ALREADY_EXISTS) {
                    if (baseDomain == null) {
                        throw new AlreadyExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_ALREADY_EXISTS_UNDER_ROOT, path, errorString);
                    }
                    throw new AlreadyExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_ALREADY_EXISTS, path, ((CredDomainImpl)baseDomain).getPath() != null ? ((CredDomainImpl)baseDomain).getPath() : ((CredDomainImpl)baseDomain).getInternalTarget(), errorString);
                }
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_FOUND, path, errorString);
            }
        }
        return domain;
    }

    public CredDomain getDomainByPath(String path, boolean isOCR) throws NotExistsException, CredentialsException {
        return this.internalGetDomainByPath(path, false, isOCR, null);
    }

    public CredFileDomain getDomainByPath(String path, String credFile) throws NotExistsException, CredentialsException {
        if (credFile == null || credFile.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "credFile");
        }
        return this.internalGetDomainByPathFromFile(path, null, credFile, null);
    }

    public CredFileDomain getDomainByPath(String path, String credFile, String section) throws NotExistsException, CredentialsException {
        if (credFile == null || credFile.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "credFile");
        }
        if (section == null || section.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "section");
        }
        return this.internalGetDomainByPathFromFile(path, null, credFile, section);
    }

    public CredFileDomain getDomainByPath(String path, CredFileDomain baseDomain) throws NotExistsException, CredentialsException {
        if (baseDomain == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "baseDomain");
        }
        return this.internalGetDomainByPathFromFile(path, baseDomain, null, null);
    }

    public CredDomain getDomainByPath(String path, boolean skipPermErrs, boolean isOCR) throws NotExistsException, CredentialsException {
        return this.internalGetDomainByPath(path, skipPermErrs, isOCR, null);
    }

    public CredDomain getDomainByPath(String path, CredDomain baseDomain) throws NotExistsException, CredentialsException {
        if (baseDomain == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "baseDomain");
        }
        return this.internalGetDomainByPath(path, false, baseDomain.isOCR(), baseDomain);
    }

    public CredDomain getDomainByPath(String path, CredDomain baseDomain, boolean skipPermErrs) throws NotExistsException, CredentialsException {
        if (baseDomain == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "baseDomain");
        }
        return this.internalGetDomainByPath(path, false, baseDomain.isOCR(), baseDomain);
    }

    private CredDomain internalGetDomainByPath(String path, boolean skipPermErrs, boolean isOCR, CredDomain baseDomain) throws NotExistsException, CredentialsException {
        if (path == null || path.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "path");
        }
        CredDomainImpl domain = baseDomain == null ? new CredDomainImpl(isOCR) : new CredDomainImpl(baseDomain);
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        domain.setPath(path);
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doGetDomain(domain.getId(), domain.isOCR(), skipPermErrs, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                if (credNativeResult.getOSErrCode() == CredNative.NOT_EXISTS) {
                    if (baseDomain == null) {
                        throw new NotExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_EXISTS_UNDER_ROOT, path, errorString);
                    }
                    throw new NotExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_EXISTS, path, ((CredDomainImpl)baseDomain).getPath() != null ? ((CredDomainImpl)baseDomain).getPath() : ((CredDomainImpl)baseDomain).getInternalTarget(), errorString);
                }
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_FOUND, path, errorString);
            }
        }
        return domain;
    }

    private CredFileDomain internalGetDomainByPathFromFile(String path, CredFileDomain baseDomain, String credFile, String section) throws NotExistsException, CredentialsException {
        if (path == null || path.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "path");
        }
        CredFileDomainImpl domain = credFile != null ? (section != null ? new CredFileDomainImpl(credFile, section) : new CredFileDomainImpl(credFile)) : new CredFileDomainImpl(baseDomain);
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        domain.setPath(path);
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doGetDomainFile(domain.getId(), domain.getCredFile(), domain.getSection(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                if (credNativeResult.getOSErrCode() == CredNative.NOT_EXISTS) {
                    if (baseDomain == null) {
                        throw new NotExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_EXISTS_UNDER_ROOT, path, errorString);
                    }
                    throw new NotExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_EXISTS, path, ((CredFileDomainImpl)baseDomain).getPath() != null ? ((CredFileDomainImpl)baseDomain).getPath() : ((CredFileDomainImpl)baseDomain).getInternalTarget(), errorString);
                }
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_FOUND, path, errorString);
            }
        }
        return domain;
    }

    public CredDomain getDomainByTarget(String target, boolean isOCR) throws NotExistsException, CredentialsException {
        return this.internalGetDomainByTarget(target, isOCR, null);
    }

    public CredDomain getDomainByTarget(String target, CredDomain baseDomain) throws NotExistsException, CredentialsException {
        if (baseDomain == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "baseDomain");
        }
        return this.internalGetDomainByTarget(target, baseDomain.isOCR(), baseDomain);
    }

    private CredDomain internalGetDomainByTarget(String target, boolean isOCR, CredDomain baseDomain) throws NotExistsException, CredentialsException {
        if (target == null || target.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "target");
        }
        CredDomainImpl domain = baseDomain == null ? new CredDomainImpl(isOCR) : new CredDomainImpl(baseDomain);
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        domain.setTarget(target);
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doGetDomain(domain.getId(), domain.isOCR(), false, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                if (credNativeResult.getOSErrCode() == CredNative.NOT_EXISTS) {
                    if (baseDomain == null) {
                        throw new NotExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_EXISTS_UNDER_ROOT, target, errorString);
                    }
                    throw new NotExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_EXISTS, target, ((CredDomainImpl)baseDomain).getPath() != null ? ((CredDomainImpl)baseDomain).getPath() : ((CredDomainImpl)baseDomain).getInternalTarget(), errorString);
                }
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_FOUND, target, errorString);
            }
        }
        return domain;
    }

    public static String formatOwnerACLString(String user, CredentialsACLPerm ... aclPerms) throws CredentialsException {
        return "user:" + user + ':' + CredentialsACLPerm.getStringPerms(aclPerms);
    }

    public static String formatGroupACLString(String group, CredentialsACLPerm ... aclPerms) throws CredentialsException {
        return "group:" + group + ':' + CredentialsACLPerm.getStringPerms(aclPerms);
    }

    public static String formatOtherACLString(CredentialsACLPerm ... aclPerms) throws CredentialsException {
        return "other::" + CredentialsACLPerm.getStringPerms(aclPerms);
    }

    public List<ClientClusterComponent> getClusterServices(String credFile) throws CredentialsException {
        if (credFile == null || credFile.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "credFile");
        }
        ArrayList<ClientClusterComponent> clientList = new ArrayList<ClientClusterComponent>();
        for (ClientClusterComponent ccc : ClientClusterComponent.values()) {
            try {
                this.getCredProperties(credFile, ccc.toString());
                clientList.add(ccc);
            }
            catch (NotExistsException notExistsException) {
                // empty catch block
            }
        }
        return clientList;
    }
}

