/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.credentials;

import java.util.List;
import java.util.Map;
import oracle.cluster.credentials.CredFileDomain;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.impl.credentials.BaseCredDomainImpl;
import oracle.cluster.impl.credentials.CredNative;
import oracle.cluster.impl.credentials.CredentialsNativeResult;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CredFileDomainImpl
extends BaseCredDomainImpl
implements CredFileDomain {
    private String m_credFile;
    private String m_section;

    public CredFileDomainImpl(String credFile) {
        this.m_credFile = credFile;
    }

    public CredFileDomainImpl(String credFile, String section) {
        this.m_credFile = credFile;
        this.m_section = section;
    }

    public CredFileDomainImpl(CredFileDomain parentDomain) throws CredentialsException, NotExistsException {
        this.m_parentDomain = parentDomain;
        this.m_credFile = parentDomain.getCredFile();
        this.m_section = parentDomain.getSection();
    }

    @Override
    public String getCredFile() throws CredentialsException, NotExistsException {
        return this.m_credFile;
    }

    @Override
    public String getSection() throws CredentialsException, NotExistsException {
        return this.m_section;
    }

    @Override
    public Map<String, String> getAttributes(List<String> keyList) throws CredentialsException, NotExistsException {
        if (keyList == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "keyList");
        }
        Map<String, String> attrMap = null;
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        if (keyList != null && !keyList.isEmpty()) {
            attrKeys = keyList.toArray(new String[keyList.size()]);
            CredNative.doGetDomainAttrsFile(this.m_id, attrKeys, this.m_credFile, this.m_section, credNativeResult);
            if (!credNativeResult.getBooleanResult()) {
                Trace.out("result is not successful");
                String errorString = credNativeResult.getOSString();
                Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
                Trace.out("Error message: " + errorString);
                if (credNativeResult.getOSErrCode() == CredNative.NOT_EXISTS) {
                    throw new NotExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_GET_ATTR_NOTFOUND, this.m_path != null ? this.m_path : this.m_target);
                }
                if (errorString != null) {
                    throw new CredentialsException((MessageKey)PrCzMsgID.CRED_DOMAIN_GET_ATTR_FAILED, this.m_path != null ? this.m_path : this.m_target, errorString);
                }
            }
            attrMap = credNativeResult.getAttrMap();
        }
        return attrMap;
    }
}

