/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.credentials;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.credentials.CredDomain;
import oracle.cluster.credentials.CredentialsACLPerm;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.CredentialsSet;
import oracle.cluster.credentials.CredentialsType;
import oracle.cluster.impl.credentials.BaseCredDomainImpl;
import oracle.cluster.impl.credentials.CredNative;
import oracle.cluster.impl.credentials.CredentialsAttribute;
import oracle.cluster.impl.credentials.CredentialsNativeResult;
import oracle.cluster.impl.credentials.CredentialsSetImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CredDomainImpl
extends BaseCredDomainImpl
implements CredDomain {
    private boolean m_isOCR;

    public CredDomainImpl() {
        this(true);
    }

    public CredDomainImpl(boolean isOCR) {
        this.m_isOCR = isOCR;
    }

    public CredDomainImpl(CredDomain parentDomain) {
        this.m_parentDomain = parentDomain;
        this.m_isOCR = parentDomain.isOCR();
    }

    @Override
    public CredentialsSet createCredentialSet(CredentialsType type) throws AlreadyExistsException, CredentialsException {
        return this.internalCreateCredentialSet(type, null);
    }

    @Override
    public CredentialsSet createCredentialSet(CredentialsType type, Map<String, String> attrKeyValue) throws AlreadyExistsException, CredentialsException {
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        return this.internalCreateCredentialSet(type, attrKeyValue);
    }

    private CredentialsSet internalCreateCredentialSet(CredentialsType type, Map<String, String> attrKeyValue) throws AlreadyExistsException, CredentialsException {
        if (type == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "type");
        }
        CredentialsSetImpl credSet = new CredentialsSetImpl(this, type);
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        String[] attrValues = null;
        if (attrKeyValue != null) {
            attrKeys = attrKeyValue.keySet().toArray(new String[0]);
            attrValues = new String[attrKeys.length];
            int i = 0;
            for (String key : attrKeys) {
                attrValues[i] = attrKeyValue.get(key);
                ++i;
            }
        }
        CredNative.doCreateCredSet(this.m_id, type.getValue(), attrKeys, attrValues, this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                if (credNativeResult.getOSErrCode() == CredNative.ALREADY_EXISTS) {
                    throw new AlreadyExistsException((MessageKey)PrCzMsgID.CREDSET_ALREADY_EXISTS, type.name(), this.m_path != null ? this.m_path : this.m_target, errorString);
                }
                throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_CREATION_FAILED, errorString);
            }
        }
        return credSet;
    }

    @Override
    public void createTarget(String path, String target) throws AlreadyExistsException, CredentialsException {
        if (target == null || target.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "target");
        }
        if (path == null || path.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "path");
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doCreateTarget(this.m_id, path, target, this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                if (credNativeResult.getOSErrCode() == CredNative.ALREADY_EXISTS) {
                    throw new AlreadyExistsException((MessageKey)PrCzMsgID.TARGET_ALREADY_EXISTS, target, this.m_path != null ? this.m_path : this.m_target, errorString);
                }
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_TARGET_CREATION_FAILED, target, path, errorString);
            }
        }
    }

    @Override
    public List<String> getTargets() throws CredentialsException {
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doGetTargets(this.m_id, this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_TARGET_FAILED, this.m_path != null ? this.m_path : this.m_target, errorString);
            }
        }
        return credNativeResult.getList();
    }

    @Override
    public void remove() throws NotExistsException, CredentialsException {
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doRemoveDomain(this.m_id, this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                if (credNativeResult.getOSErrCode() == CredNative.NOT_EXISTS) {
                    throw new NotExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_EXISTS_UNDER_ROOT, this.m_path != null ? this.m_path : this.m_target, errorString);
                }
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_DOMAIN_NOT_FOUND, this.m_path != null ? this.m_path : this.m_target, errorString);
            }
        }
    }

    @Override
    public CredDomain getParentDomain() throws CredentialsException {
        return (CredDomain)this.m_parentDomain;
    }

    @Override
    public CredDomain getRootDomain() throws CredentialsException {
        CredDomainImpl rootDomain = new CredDomainImpl(this.m_isOCR);
        rootDomain.setPath("/");
        return rootDomain;
    }

    @Override
    public CredentialsSet getCredentialsSet(CredentialsType type) throws NotExistsException, CredentialsException {
        if (type == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "type");
        }
        CredentialsSetImpl credSet = new CredentialsSetImpl(this, type);
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doGetCredSet(this.m_id, type.getValue(), this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful ");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                if (credNativeResult.getOSErrCode() == CredNative.NOT_EXISTS) {
                    throw new NotExistsException((MessageKey)PrCzMsgID.CREDSET_NOT_EXISTS, type.name(), this.m_path != null ? this.m_path : this.m_target, errorString);
                }
                throw new CredentialsException((MessageKey)PrCzMsgID.CREDSET_NOT_FOUND, this.m_path != null ? this.m_path : this.m_target, errorString);
            }
        }
        return credSet;
    }

    @Override
    public List<CredentialsSet> getAllCredSets() throws CredentialsException {
        ArrayList<CredentialsSet> credentialSetList = new ArrayList<CredentialsSet>();
        CredentialsSet credSet = null;
        for (CredentialsType type : CredentialsType.values()) {
            try {
                credSet = this.getCredentialsSet(type);
            }
            catch (NotExistsException ne) {
                continue;
            }
            credentialSetList.add(credSet);
        }
        return credentialSetList;
    }

    @Override
    public void importFromWrapFile(String filePath) throws CredentialsException {
        this.internalImportFromWrapFile(filePath, false, null);
    }

    @Override
    public void importFromWrapFile(String filePath, String sectionName) throws CredentialsException {
        if (sectionName == null || sectionName.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sectionName");
        }
        this.internalImportFromWrapFile(filePath, false, sectionName);
    }

    @Override
    public void importFromWrapFile(String filePath, boolean skipPermErrs) throws CredentialsException {
        this.internalImportFromWrapFile(filePath, skipPermErrs, null);
    }

    @Override
    public void importFromWrapFile(String filePath, String sectionName, boolean skipPermErrs) throws CredentialsException {
        if (sectionName == null || sectionName.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sectionName");
        }
        this.internalImportFromWrapFile(filePath, skipPermErrs, sectionName);
    }

    private void internalImportFromWrapFile(String filePath, boolean skipPermErrs, String sectionName) throws CredentialsException {
        if (filePath == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "filePath");
        }
        if (!this.isValidWrapFile(filePath)) {
            throw new CredentialsException((MessageKey)PrCtMsgID.INVALID_FILE_PATH, filePath);
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doImportWrap(this.m_id, filePath, skipPermErrs, sectionName, false, this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_IMPORT_FAILED, filePath, errorString);
            }
        }
    }

    @Override
    public void exportToWrapFile(String filePath) throws CredentialsException {
        this.internalExportToWrapFile(filePath, false, null);
    }

    @Override
    public void exportToWrapFile(String filePath, String sectionName) throws CredentialsException {
        if (sectionName == null || sectionName.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sectionName");
        }
        this.internalExportToWrapFile(filePath, false, sectionName);
    }

    @Override
    public void exportToWrapFile(String filePath, boolean skipPermErrs) throws CredentialsException {
        this.internalExportToWrapFile(filePath, skipPermErrs, null);
    }

    @Override
    public void exportToWrapFile(String filePath, String sectionName, boolean skipPermErrs) throws CredentialsException {
        if (sectionName == null || sectionName.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sectionName");
        }
        this.internalExportToWrapFile(filePath, skipPermErrs, sectionName);
    }

    private void internalExportToWrapFile(String filePath, boolean skipPermErrs, String sectionName) throws CredentialsException {
        if (filePath == null || filePath.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "filePath");
        }
        File fileName = new File(filePath);
        if (fileName.exists()) {
            throw new CredentialsException((MessageKey)PrCzMsgID.FILE_ALREADY_EXISTS, filePath);
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doExportWrap(this.m_id, filePath, skipPermErrs, sectionName, false, this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_EXPORT_FAILED, filePath, errorString);
            }
        }
    }

    @Override
    public void importFromWrapBuffer(String buffer) throws CredentialsException {
        this.importFromWrapBuffer(buffer, false);
    }

    @Override
    public void importFromWrapBuffer(String buffer, boolean skipPermErrs) throws CredentialsException {
        if (buffer == null || buffer.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "buffer");
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doImportWrap(this.m_id, buffer, skipPermErrs, null, true, this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_IMPORT_BUFFER_FAILED, errorString);
            }
        }
    }

    @Override
    public String exportToWrapBuffer() throws CredentialsException {
        return this.exportToWrapBuffer(false);
    }

    @Override
    public String exportToWrapBuffer(boolean skipPermErrs) throws CredentialsException {
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doExportWrap(this.m_id, null, skipPermErrs, null, true, this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_EXPORT_BUFFER_FAILED, errorString);
            }
        }
        return credNativeResult.getCredential();
    }

    @Override
    public void removeCredSet(CredentialsType type) throws NotExistsException, CredentialsException {
        if (type == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "type");
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doRemoveCredSet(this.m_id, type.getValue(), this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                if (credNativeResult.getOSErrCode() == CredNative.NOT_EXISTS) {
                    throw new NotExistsException((MessageKey)PrCzMsgID.CREDSET_NOT_EXISTS, type.name(), this.m_path != null ? this.m_path : this.m_target, errorString);
                }
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_DELETION_FAILED, errorString);
            }
        }
    }

    @Override
    public void setAttributes(Map<String, String> attrKeyValue) throws CredentialsException {
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = attrKeyValue.keySet().toArray(new String[0]);
        String[] attrValues = new String[attrKeys.length];
        int i = 0;
        for (String key : attrKeys) {
            attrValues[i] = attrKeyValue.get(key);
            ++i;
        }
        CredNative.doSetDomainAttrs(this.m_id, attrKeys, attrValues, this.m_isOCR, credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_DOMAIN_SET_ATTR_FAILED, this.m_path != null ? this.m_path : this.m_target, errorString);
            }
        }
    }

    @Override
    public Map<String, String> getAttributes(List<String> keyList) throws CredentialsException, NotExistsException {
        if (keyList == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "keyList");
        }
        Map<String, String> attrMap = null;
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        if (keyList != null && !keyList.isEmpty()) {
            attrKeys = keyList.toArray(new String[keyList.size()]);
            CredNative.doGetDomainAttrs(this.m_id, attrKeys, this.m_isOCR, credNativeResult);
            if (!credNativeResult.getBooleanResult()) {
                Trace.out("result is not successful");
                String errorString = credNativeResult.getOSString();
                Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
                Trace.out("Error message: " + errorString);
                if (credNativeResult.getOSErrCode() == CredNative.NOT_EXISTS) {
                    throw new NotExistsException((MessageKey)PrCzMsgID.CRED_DOMAIN_GET_ATTR_NOTFOUND, this.m_path != null ? this.m_path : this.m_target);
                }
                if (errorString != null) {
                    throw new CredentialsException((MessageKey)PrCzMsgID.CRED_DOMAIN_GET_ATTR_FAILED, this.m_path != null ? this.m_path : this.m_target, errorString);
                }
            }
            attrMap = credNativeResult.getAttrMap();
        }
        return attrMap;
    }

    @Override
    public boolean isOCR() {
        return this.m_isOCR;
    }

    @Override
    public boolean isOLR() {
        return !this.m_isOCR;
    }

    @Override
    public void setPGroup(String group) throws CredentialsException {
        if (group == null || group.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "group");
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put(CredentialsAttribute.GROUP.getValue(), group);
        this.setAttributes(attr);
    }

    @Override
    public void setOwner(String owner) throws CredentialsException {
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put(CredentialsAttribute.OWNER.getValue(), owner);
        this.setAttributes(attr);
    }

    @Override
    public void setOwnerPerms(CredentialsACLPerm ... aclPerms) throws CredentialsException {
        try {
            String perms = CredentialsFactory.formatOwnerACLString(this.getOwner(), aclPerms);
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put(CredentialsAttribute.OWNER_PERMS.getValue(), perms);
            this.setAttributes(attr);
        }
        catch (NotExistsException nee) {
            throw new CredentialsException(nee);
        }
    }

    @Override
    public void setPGroupPerms(CredentialsACLPerm ... aclPerms) throws CredentialsException {
        try {
            String perms = CredentialsFactory.formatGroupACLString(this.getPGroup(), aclPerms);
            HashMap<String, String> attr = new HashMap<String, String>();
            attr.put(CredentialsAttribute.GROUP_PERMS.getValue(), perms);
            this.setAttributes(attr);
        }
        catch (NotExistsException nee) {
            throw new CredentialsException(nee);
        }
    }

    @Override
    public void setOtherPerms(CredentialsACLPerm ... aclPerms) throws CredentialsException {
        String perms = CredentialsFactory.formatOtherACLString(aclPerms);
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put(CredentialsAttribute.OTHER_PERMS.getValue(), perms);
        this.setAttributes(attr);
    }

    private boolean isValidWrapFile(String fileName) {
        File wrapFile = new File(fileName);
        return wrapFile.exists() && wrapFile.canRead();
    }
}

