/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.credentials;

import java.util.ArrayList;
import java.util.Map;
import oracle.cluster.credentials.BaseCredDomain;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.impl.credentials.CredentialsAttribute;
import oracle.cluster.util.NotExistsException;

public abstract class BaseCredDomainImpl
implements BaseCredDomain {
    BaseCredDomain m_parentDomain;
    String m_path;
    String m_target;
    String m_id;
    public static final String TARGET_PREFIX = "GjKcHeqwS-";

    public void setPath(String path) {
        if (path != null) {
            if ((path = path.trim()).length() > 1 && path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            this.m_path = path;
        }
        this.setId();
    }

    public void setId() {
        if (this.m_parentDomain != null) {
            this.m_id = ((BaseCredDomainImpl)this.m_parentDomain).getId() + "/";
        }
        this.m_id = this.m_path != null ? (this.m_id != null ? this.m_id + this.m_path : this.m_path) : (this.m_id != null ? this.m_id + TARGET_PREFIX + this.m_target : TARGET_PREFIX + this.m_target);
    }

    public String getId() {
        return this.m_id;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setTarget(String target) {
        this.m_target = target;
        this.setId();
    }

    public String getInternalTarget() {
        return this.m_target;
    }

    @Override
    public String getPGroup() throws CredentialsException, NotExistsException {
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.GROUP.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        return attr.get(CredentialsAttribute.GROUP.getValue());
    }

    @Override
    public String getOwner() throws CredentialsException, NotExistsException {
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.OWNER.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        return attr.get(CredentialsAttribute.OWNER.getValue());
    }

    @Override
    public String getOwnerPerms() throws CredentialsException, NotExistsException {
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.OWNER_PERMS.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        return attr.get(CredentialsAttribute.OWNER_PERMS.getValue());
    }

    @Override
    public String getPGroupPerms() throws CredentialsException, NotExistsException {
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.GROUP_PERMS.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        return attr.get(CredentialsAttribute.GROUP_PERMS.getValue());
    }

    @Override
    public String getOtherPerms() throws CredentialsException, NotExistsException {
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.OTHER_PERMS.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        return attr.get(CredentialsAttribute.OTHER_PERMS.getValue());
    }
}

