/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.credentials;

import java.util.HashMap;
import oracle.cluster.credentials.ASMProperties;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ASMPropertiesImpl
implements ASMProperties {
    private HashMap<String, String> m_propmap = null;

    public ASMPropertiesImpl(HashMap<String, String> propmap) throws CredentialsException {
        this(propmap, false);
    }

    protected ASMPropertiesImpl(HashMap<String, String> propmap, boolean validate) throws CredentialsException {
        this.m_propmap = propmap;
        Trace.out("Calling ASMPropertiesImpl()");
        if (!validate) {
            return;
        }
        String pval = null;
        StringBuilder missingAttrs = new StringBuilder();
        boolean firstMissing = true;
        for (ASMProperties.ASMPropName v : ASMProperties.ASMPropName.values()) {
            pval = this.m_propmap.get(v.toString());
            if (pval != null || v == ASMProperties.ASMPropName.ASM_DISCOVERY_ADDRESS || v == ASMProperties.ASMPropName.ASM_ACCESS_MODE) continue;
            if (!firstMissing) {
                missingAttrs.append(",");
            }
            missingAttrs.append(v.toString());
            firstMissing = false;
        }
        if (missingAttrs.length() > 0) {
            throw new CredentialsException((MessageKey)PrCcMsgID.MISSING_ASM_PROPERTIES, missingAttrs.toString());
        }
        Trace.out("Got ASMPropertiesImpl");
    }

    public static ASMProperties getAndValidateASMProperties(HashMap<String, String> propmap) throws CredentialsException {
        return new ASMPropertiesImpl(propmap, true);
    }

    public static ASMProperties getASMProperties(HashMap<String, String> propmap) throws CredentialsException {
        return new ASMPropertiesImpl(propmap, false);
    }

    @Override
    public String getASMClusterName() throws CredentialsException {
        String pval = null;
        if (this.m_propmap != null) {
            pval = this.m_propmap.get(ASMProperties.ASMPropName.ASM_CLUSTER_NAME.toString());
        }
        Trace.out("getASMClusterNames returns " + pval);
        return pval;
    }

    @Override
    public String getClientClusterNames() throws CredentialsException {
        String pval = null;
        if (this.m_propmap != null) {
            pval = this.m_propmap.get(ASMProperties.ASMPropName.CLUSTER_NAMES.toString());
        }
        Trace.out("getClientClusterNames returns " + pval);
        return pval;
    }

    @Override
    public String getClusterGUID() throws CredentialsException {
        String pval = null;
        if (this.m_propmap != null) {
            pval = this.m_propmap.get(ASMProperties.ASMPropName.CLUSTER_GUID.toString());
        }
        Trace.out("getClusterGUID returns " + pval);
        return pval;
    }

    @Override
    public String getASMClusterGUID() throws CredentialsException {
        String pval = null;
        if (this.m_propmap != null) {
            pval = this.m_propmap.get(ASMProperties.ASMPropName.ASM_CLUSTER_GUID.toString());
        }
        Trace.out("getASMClusterGUID returns " + pval);
        return pval;
    }
}

