/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.impl.common.ManageableEntityImpl;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.CRSResourceTypeEntity;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.install.InstallGroup;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public abstract class SoftwareModuleImpl
extends ManageableEntityImpl
implements SoftwareModule {
    protected CRSResourceImpl m_crsResource;
    protected Version m_version;

    @Override
    public InstallGroup installGroup() throws SoftwareModuleException {
        throw new SoftwareModuleException((MessageKey)PrCcMsgID.GET_INSTALL_GROUP_FAILED, "NOT IMPLEMENTED YET");
    }

    @Override
    public void setInstallGroup(InstallGroup install) throws SoftwareModuleException {
        throw new SoftwareModuleException((MessageKey)PrCcMsgID.SET_INSTALL_GROUP_FAILED, "NOT IMPLEMENTED YET");
    }

    @Override
    public boolean isInstalled() throws SoftwareModuleException {
        return true;
    }

    @Override
    public boolean isConfigured() throws SoftwareModuleException {
        try {
            return this.m_crsResource != null && this.m_crsResource.isRegistered();
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public boolean isRunning() throws SoftwareModuleException {
        this.assertCRSResource();
        try {
            return this.m_crsResource.isRunning();
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public boolean isRunning(Node node) throws SoftwareModuleException {
        this.assertCRSResource();
        try {
            return this.m_crsResource.isRunning(node.getName());
        }
        catch (NodeException ne) {
            throw new SoftwareModuleException(ne);
        }
        catch (CRSException ce) {
            throw new SoftwareModuleException(ce);
        }
    }

    @Override
    public boolean isEnabled() throws SoftwareModuleException {
        this.assertCRSResource();
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.LocalResource.ENABLED.name());
            Trace.out("Enabled is " + attr.getValue());
            if (attr.getValue().equals(String.valueOf(1))) {
                return true;
            }
            if (attr.getValue().equals(String.valueOf(0))) {
                return false;
            }
            throw new CRSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, attr.getName(), attr.getValue());
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public boolean isEnabled(Node node) throws SoftwareModuleException {
        try {
            return this.isEnabled(node.getName());
        }
        catch (NodeException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public boolean isEnabled(String nodeName) throws SoftwareModuleException {
        this.assertCRSResource();
        try {
            String enableName = ResourceType.LocalResource.ENABLED.name();
            ResourceAttribute attr = null;
            String attrName = ResourceType.getPerXName(enableName, nodeName);
            try {
                attr = this.m_crsResource.getAttribute(attrName);
            }
            catch (CRSAttributeNotFoundException e) {
                Trace.out("Looking for non perx attr");
                attr = this.m_crsResource.getAttribute(enableName);
            }
            Trace.out("Attr %s: enabled is %s", attr.getName(), attr.getValue());
            if (attr.getValue().equals(String.valueOf(1))) {
                return true;
            }
            if (attr.getValue().equals(String.valueOf(0))) {
                return false;
            }
            throw new CRSException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, attr.getName(), attr.getValue());
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public List<Node> getDisabledNodes() throws ClusterException, SoftwareModuleException {
        ArrayList<Node> disabledNodes = new ArrayList<Node>();
        try {
            ServerFactory sf = ServerFactory.getInstance();
            for (String nodeName : Cluster.getNodes()) {
                if (this.isEnabled(nodeName)) {
                    Trace.out("GHS enabled on node " + nodeName);
                    continue;
                }
                Trace.out("GHS disabled on node " + nodeName);
                disabledNodes.add(sf.getNode(nodeName));
            }
        }
        catch (NodeException e) {
            throw new SoftwareModuleException(e);
        }
        catch (ServerException e) {
            throw new SoftwareModuleException(e);
        }
        return disabledNodes;
    }

    @Override
    public void enable() throws AlreadyEnabledException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.enable();
        }
        catch (AlreadyEnabledException e) {
            throw new AlreadyEnabledException((MessageKey)PrCcMsgID.ALREADY_ENABLED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public void disable() throws AlreadyDisabledException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.disable();
        }
        catch (AlreadyDisabledException e) {
            throw new AlreadyDisabledException((MessageKey)PrCcMsgID.ALREADY_DISABLED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public void enable(List<Node> nodes) throws AlreadyEnabledException, CompositeOperationException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.enable(nodes);
        }
        catch (AlreadyEnabledException e) {
            throw new AlreadyEnabledException((MessageKey)PrCcMsgID.ALREADY_ENABLED_PERX, (Throwable)e, this.getUserAssignedName(), this.getNodeNames(nodes));
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public void disable(List<Node> nodes) throws AlreadyDisabledException, CompositeOperationException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.disable(nodes);
        }
        catch (AlreadyDisabledException e) {
            throw new AlreadyDisabledException((MessageKey)PrCcMsgID.ALREADY_DISABLED_PERX, (Throwable)e, this.getUserAssignedName(), this.getNodeNames(nodes));
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public String getEnv(String varName) throws SoftwareModuleException {
        if (varName == null || varName.trim().length() == 0) {
            throw new SoftwareModuleException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "varName", varName);
        }
        this.assertCRSResource();
        try {
            return this.m_crsResource.getEnv(varName);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public Map<String, String> getEnv() throws SoftwareModuleException {
        this.assertCRSResource();
        try {
            return this.m_crsResource.getEnv();
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public void setEnv(Map<String, String> envMap) throws SoftwareModuleException {
        HashMap<Object, Object> myMap = null == envMap || envMap.isEmpty() ? new HashMap(0) : new HashMap<String, String>(envMap);
        this.assertCRSResource();
        try {
            this.m_crsResource.setEnv(myMap);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public void start() throws AlreadyRunningException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.start();
        }
        catch (AlreadyRunningException e) {
            throw new AlreadyRunningException((MessageKey)PrCcMsgID.ALREADY_RUNNING, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public void start(ResourceAttribute[] resourceAttributes) throws AlreadyRunningException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.start(resourceAttributes);
        }
        catch (AlreadyRunningException e) {
            throw new AlreadyRunningException((MessageKey)PrCcMsgID.ALREADY_RUNNING, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public void start(Node node) throws AlreadyRunningException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.start(node);
        }
        catch (AlreadyRunningException e) {
            throw new AlreadyRunningException((MessageKey)PrCcMsgID.ALREADY_RUNNING_PERX, (Throwable)e, this.getUserAssignedName(), this.getNodeName(node));
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
        catch (NodeException e) {
            Trace.out("Calling start, encountered NodeException");
            throw new SoftwareModuleException(e);
        }
    }

    public void start(Node node, ResourceAttribute[] resourceAttributes) throws AlreadyRunningException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.start(node, resourceAttributes);
        }
        catch (AlreadyRunningException e) {
            throw new AlreadyRunningException((MessageKey)PrCcMsgID.ALREADY_RUNNING_PERX, (Throwable)e, this.getUserAssignedName(), this.getNodeName(node));
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
        catch (NodeException e) {
            Trace.out("Calling start, encountered NodeException");
            throw new SoftwareModuleException(e);
        }
    }

    public void start(List<Node> nodes) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.start(nodes);
        }
        catch (AlreadyRunningException e) {
            throw new AlreadyRunningException((MessageKey)PrCcMsgID.ALREADY_RUNNING_PERX, (Throwable)e, this.getUserAssignedName(), this.getNodeNames(nodes));
        }
    }

    public void start(List<Node> nodes, ResourceAttribute[] resourceAttributes) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.start(nodes, resourceAttributes);
        }
        catch (AlreadyRunningException e) {
            throw new AlreadyRunningException((MessageKey)PrCcMsgID.ALREADY_RUNNING_PERX, (Throwable)e, this.getUserAssignedName(), this.getNodeNames(nodes));
        }
    }

    @Override
    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.stop(force);
        }
        catch (AlreadyStoppedException e) {
            throw new AlreadyStoppedException((MessageKey)PrCcMsgID.ALREADY_STOPPED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public void stop(Node node, boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.stop(node, force);
        }
        catch (AlreadyStoppedException e) {
            throw new AlreadyStoppedException((MessageKey)PrCcMsgID.ALREADY_STOPPED_PERX, (Throwable)e, this.getUserAssignedName(), this.getNodeName(node));
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
        catch (NodeException e) {
            Trace.out("Calling stop, encountered NodeException");
            throw new SoftwareModuleException(e);
        }
    }

    public void stop(List<Node> nodes, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        this.stop(nodes, force, false);
    }

    public void stop(List<Node> nodes, boolean force, boolean keepDepTgt) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.stop(nodes, force, keepDepTgt);
        }
        catch (AlreadyStoppedException e) {
            throw new AlreadyStoppedException((MessageKey)PrCcMsgID.ALREADY_STOPPED_PERX, (Throwable)e, this.getUserAssignedName(), this.getNodeNames(nodes));
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public Version version() throws NoVersionAvailableException, SoftwareModuleException {
        try {
            if (this.m_crsResource != null) {
                return this.m_crsResource.version();
            }
            throw new NoVersionAvailableException((MessageKey)PrCcMsgID.VERSION_NOT_AVAILABLE, this.getName());
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public CRSResource crsResource() throws NotExistsException, SoftwareModuleException {
        try {
            if (this.m_crsResource == null || !this.m_crsResource.isRegistered()) {
                throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, this.m_crsResource != null ? this.m_crsResource.getName() : this.getName());
            }
            return this.m_crsResource;
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public void remove(boolean force) throws AlreadyRunningException, SoftwareModuleException {
        try {
            this.assertCRSResource();
            if (!force && this.isRunning()) {
                throw new AlreadyRunningException((MessageKey)PrCrMsgID.RES_STILL_RUNNING, this.m_name, this.m_displayName);
            }
            this.m_crsResource.remove(force);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public void check() throws SoftwareModuleException {
        this.assertCRSResource();
        try {
            this.m_crsResource.check();
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    protected boolean isTypeUpgradeNeeded(Class<? extends Enum> clazz) throws SoftwareModuleException {
        try {
            Enum name = null;
            Enum typeVersion = null;
            for (Enum constant : clazz.getEnumConstants()) {
                if (constant.name().equals(ResourceType.LocalResource.NAME.name())) {
                    name = constant;
                    Trace.out("name = " + name.toString());
                    continue;
                }
                if (!constant.name().equals(ResourceType.LocalResource.TYPE_VERSION.name())) continue;
                typeVersion = constant;
                Trace.out("type version = " + typeVersion.toString());
            }
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ResourceAttribute typeAttr = cf.create(ResourceType.LocalResource.NAME.name(), name.toString());
            CRSResourceTypeEntity resType = cf.getResourceTypeEntity(typeAttr);
            boolean typeUpgradeNeeded = false;
            try {
                List<ResourceAttribute> attrList = resType.getAttributes(ResourceType.LocalResource.TYPE_VERSION.name());
                String currTypeVerValue = attrList.get(0).getValue();
                double typeVer = new Double(typeVersion.toString());
                double currTypeVer = new Double(currTypeVerValue);
                Trace.out("type version = " + typeVer + ", current type version = " + currTypeVer);
                if (currTypeVer < typeVer) {
                    typeUpgradeNeeded = true;
                }
            }
            catch (CRSAttributeNotFoundException e) {
                Trace.out("Cannot find the crs attribute, so upgraded is needed");
                typeUpgradeNeeded = true;
            }
            return typeUpgradeNeeded;
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    private String getNodeNames(List<Node> nodeList) throws SoftwareModuleException {
        StringBuilder sb = null;
        try {
            if (nodeList.size() == 1) {
                return nodeList.get(0).getName();
            }
            sb = new StringBuilder();
            for (Node node : nodeList) {
                if (sb.length() > 0) {
                    sb.append("," + node.getName());
                    continue;
                }
                sb.append(node.getName());
            }
        }
        catch (NodeException e) {
            throw new SoftwareModuleException(e);
        }
        return sb.toString();
    }

    private String getNodeName(Node node) throws SoftwareModuleException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        return this.getNodeNames(nodeList);
    }

    private final void assertCRSResource() throws SoftwareModuleException {
        if (this.m_crsResource == null) {
            throw new SoftwareModuleException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, this.m_name);
        }
    }
}

