/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.common.ProgressListenerException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ProgressListenerImpl
extends Thread
implements ProgressListener {
    private String m_hostName;
    private int m_port;
    private boolean m_listen;
    private ServerSocket m_ss;
    private boolean m_isInternal;
    private StringBuffer m_buffer = new StringBuffer();

    public ProgressListenerImpl() throws ProgressListenerException {
        this(false);
    }

    public ProgressListenerImpl(boolean internal) throws ProgressListenerException {
        try {
            this.m_hostName = InetAddress.getLocalHost().getCanonicalHostName();
            this.m_ss = new ServerSocket(0);
            this.m_ss.setSoTimeout(60000);
            this.m_port = this.m_ss.getLocalPort();
            this.m_listen = true;
            this.m_isInternal = internal;
            Trace.out("m_internal value is " + this.m_isInternal);
            Trace.out("Instantiating progress listener: Host=" + this.m_hostName + " ;Port=" + this.m_port);
        }
        catch (UnknownHostException uhe) {
            throw new ProgressListenerException(uhe);
        }
        catch (IOException ioe) {
            throw new ProgressListenerException(ioe);
        }
    }

    public ProgressListenerImpl(String host, int port) {
        Trace.out("Instantiating progress listener client: Host=" + host + " ;Port=" + port);
        this.m_hostName = host;
        this.m_port = port;
    }

    public ProgressListenerImpl(String hostAndPort) throws ProgressListenerException {
        Trace.out("Instantiating progress listener client: host:port -> " + hostAndPort);
        String[] afterSplit = hostAndPort.split(":");
        if (afterSplit.length != 2) {
            throw new ProgressListenerException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "progress-listener-hp1");
        }
        this.m_hostName = afterSplit[0];
        this.m_port = Integer.parseInt(afterSplit[1]);
        Trace.out("Host=" + this.m_hostName + " ;Port=" + this.m_port);
    }

    public ProgressListenerImpl(String hostAndPort, boolean isInternal) throws ProgressListenerException {
        Trace.out("Instantiating progress listener client: host:port -> " + hostAndPort);
        String[] afterSplit = hostAndPort.split(":");
        if (afterSplit.length != 2) {
            throw new ProgressListenerException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "progress-listener-hp1");
        }
        this.m_hostName = afterSplit[0];
        this.m_port = Integer.parseInt(afterSplit[1]);
        this.m_isInternal = isInternal;
        Trace.out("Host=" + this.m_hostName + " ;Port=" + this.m_port);
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public String getListenerHost() {
        return this.m_hostName;
    }

    @Override
    public int getListenerPort() {
        return this.m_port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Trace.out("Starting progress listener...");
        block5: while (true) {
            try {
                while (true) {
                    Trace.out("m_internal value in run is " + this.m_isInternal);
                    Socket s = this.m_ss.accept();
                    DataInputStream dis = new DataInputStream(s.getInputStream());
                    String report = dis.readUTF();
                    if (this.m_isInternal) {
                        Trace.out("Inside the internal plsnr run logic.");
                        Trace.out("report is " + report);
                        if (report == null) continue;
                        ProgressListenerImpl progressListenerImpl = this;
                        synchronized (progressListenerImpl) {
                            this.m_buffer.append(report + ":");
                            continue block5;
                        }
                    }
                    String ghdiag = System.getenv("GRIDHOME_TIMESTAMP");
                    if (ghdiag != null) {
                        String tim = new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
                        System.out.println("(" + tim + "): " + report);
                        continue;
                    }
                    System.out.println(report);
                }
            }
            catch (IOException e) {
                Trace.out("IOException encountered in progress listener thread");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMsgString() {
        Trace.out("Starting progress listener...");
        String msg = null;
        ProgressListenerImpl progressListenerImpl = this;
        synchronized (progressListenerImpl) {
            msg = this.m_buffer.toString();
            if (this.m_isInternal) {
                Trace.out("flushing buffer ...");
                this.m_buffer.delete(0, this.m_buffer.length());
                Trace.out("flushed buffer");
            }
        }
        return msg;
    }

    @Override
    public void write(String msg) {
        this.write(msg, true);
    }

    @Override
    public void write(String msg, boolean displayHost) {
        this.write(null, msg, displayHost);
    }

    @Override
    public void write(String nodeName, String msg, boolean displayHost) {
        if (!this.m_listen) {
            try {
                Trace.out("Writing to progress listener: " + msg);
                Socket clientSocket = new Socket(this.m_hostName, this.m_port);
                DataOutputStream outToServer = new DataOutputStream(clientSocket.getOutputStream());
                if (displayHost) {
                    if (nodeName == null || nodeName.isEmpty()) {
                        nodeName = InetAddress.getLocalHost().getCanonicalHostName();
                    }
                    outToServer.writeUTF(nodeName + ": " + msg);
                } else {
                    outToServer.writeUTF(msg);
                }
                clientSocket.close();
            }
            catch (Exception e) {
                Trace.out("Failed to write msg to listener: " + msg);
            }
        }
    }

    @Override
    public void writeHostName() {
        if (!this.m_listen) {
            try {
                String hname = InetAddress.getLocalHost().getCanonicalHostName();
                Trace.out("Writing to progress listener: HostName " + hname);
                Socket clientSocket = new Socket(this.m_hostName, this.m_port);
                DataOutputStream outToServer = new DataOutputStream(clientSocket.getOutputStream());
                outToServer.writeUTF(hname + ":");
                clientSocket.close();
            }
            catch (Exception e) {
                Trace.out("Failed to write hostname to listener ");
            }
        }
    }

    @Override
    public String toString() {
        return this.m_hostName + ":" + this.m_port;
    }
}

