/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.Cluster;
import oracle.cluster.common.ClusterException;
import oracle.cluster.common.ResultSet;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.common.SoftwareVersion;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.OCR;
import oracle.cluster.crs.VendorCluster;
import oracle.cluster.database.Database;
import oracle.cluster.impl.common.ManageableEntityImpl;
import oracle.cluster.impl.common.cnative.ClusterNative;
import oracle.cluster.impl.common.cnative.ClusterNativeException;
import oracle.cluster.impl.common.cnative.ClusterNativeResult;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.install.InstallGroup;
import oracle.cluster.network.NetworkAdapter;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.nodeapps.ONS;
import oracle.cluster.nodeapps.VIP;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerPool;
import oracle.cluster.storage.Storage;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ClusterImpl
extends ManageableEntityImpl
implements Cluster {
    ClusterImpl() throws ClusterException {
        try {
            this.m_displayName = this.m_name = new ClusterUtil().getClusterName();
        }
        catch (ClusterUtilException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public List<SoftwareModule> softwareModules() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<Node> nodes() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<ServerGroup> fetchServerGroups() throws NotExistsException, ClusterException {
        try {
            ServerFactoryImpl fact = ServerFactoryImpl.getInstance();
            return fact.getServerGroups();
        }
        catch (ServerException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public List<ServerPool> fetchServerPools() throws NotExistsException, ClusterException {
        try {
            ServerFactoryImpl fact = ServerFactoryImpl.getInstance();
            return fact.getServerPools();
        }
        catch (ServerException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public Database fetchDatabase(String dbUniqueName, String dbDomain) throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<Database> fetchDatabases() throws NotExistsException, ClusterException {
        try {
            DatabaseFactoryImpl fact = DatabaseFactoryImpl.getInstance();
            return fact.getDatabases();
        }
        catch (SoftwareModuleException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public SoftwareVersion getVersion() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<InstallGroup> fetchDatabaseInstallGroups() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<Listener> fetchListeners() throws NotExistsException, ClusterException {
        try {
            NodeAppsFactoryImpl fact = NodeAppsFactoryImpl.getInstance();
            return fact.getListeners();
        }
        catch (SoftwareModuleException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public List<ONS> fetchONSs() throws NotExistsException, ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<VIP> fetchVIPs(int netNum) throws NotExistsException, ClusterException {
        try {
            NodeAppsFactoryImpl fact = NodeAppsFactoryImpl.getInstance();
            return fact.getVIPs(netNum);
        }
        catch (SoftwareModuleException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public List<VIP> fetchVIPs() throws NotExistsException, ClusterException {
        try {
            return this.fetchVIPs(NodeAppsFactory.getInstance().getDefaultNetworkNumber());
        }
        catch (SoftwareModuleException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public Node fetchNode(String nodeName) throws NotExistsException, ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public String fetchNodeName(String hostName) throws NotExistsException, ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public Node getLocalNode() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public ASM fetchASM() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<ASMInstance> fetchASMInstances() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<Storage> fetchSharedStorage() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<Network> fetchNetworks() throws NotExistsException, ClusterException {
        try {
            NodeAppsFactoryImpl fact = NodeAppsFactoryImpl.getInstance();
            return fact.getNetworks();
        }
        catch (SoftwareModuleException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public List<NetworkAdapter> fetchNetworkAdapters() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<NetworkAdapter> fetchNetworkAdaptersByNode(String node) throws NotExistsException, ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<NetworkAdapter> fetchNetworkAdaptersByName(String networkAdapterName) throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<String> getPrivateAddresses() throws ClusterException {
        try {
            String crsHome = new Util().getCRSHome();
            ClusterInfo clusterInfo = new ClusterInfo(crsHome);
            String hostName = clusterInfo.getLocalNodeName();
            String interconnects = clusterInfo.getOraclePrivateName(hostName);
            String[] icArray = interconnects.split(",");
            ArrayList<String> result = new ArrayList<String>(icArray.length);
            for (String ic : icArray) {
                result.add(ic);
            }
            if (result.isEmpty()) {
                throw new ClusterException((MessageKey)PrCcMsgID.GET_PRIVATE_NODE_ADDRESS_FAIL, hostName);
            }
            return result;
        }
        catch (UtilException e) {
            throw new ClusterException(e);
        }
        catch (ClusterInfoException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public ResultSet verifyClusterIntegrity() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public ResultSet verifyNodeAppsIntegrity() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public boolean isVendorCluster() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public VendorCluster fetchVendorCluster() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public OCR ocr() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public List<String> votingDiskPaths() throws ClusterException {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    @Override
    public boolean hasCRSAdminRole() throws CRSException {
        return CRSFactoryImpl.getInstance().hasCrsAdminRole();
    }

    @Override
    public CSSMode getCSSMode() throws ClusterException {
        try {
            ClusterUtil util = new ClusterUtil();
            return util.getCSSMode();
        }
        catch (ClusterUtilException e) {
            throw new ClusterException(e);
        }
    }

    @Override
    public String getPatchLevelForNode(String nodeName) throws ClusterException {
        Trace.out("Checking node: " + nodeName);
        if (nodeName == null || nodeName.trim().length() == 0) {
            throw new ClusterException((MessageKey)PrCcMsgID.NODE_VALIDATION_ERROR, nodeName);
        }
        try {
            new ClusterUtil().getHostName(nodeName);
        }
        catch (ClusterUtilException cue) {
            throw new ClusterException((MessageKey)PrCcMsgID.NODE_VALIDATION_ERROR, nodeName);
        }
        long plno = 0L;
        ClusterNativeResult result = new ClusterNativeResult();
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            Trace.out("Loading SRVM HAS native library");
            m_system.loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new ClusterException(ne);
        }
        try {
            Trace.out("Before calling native getpatchlevel api");
            plno = ClusterNative.getPatchLevel(result, nodeName);
            Trace.out("After calling native getpatchlevel api");
        }
        catch (ClusterNativeException cne) {
            throw new ClusterException(cne);
        }
        return Long.toString(plno);
    }

    @Override
    public String getCRSBaseLoc() throws ClusterException {
        Trace.out("METHOD:: getCRSBaseLoc");
        String crsBaseLoc = null;
        ClusterNativeResult result = new ClusterNativeResult();
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            Trace.out("Loading SRVM HAS native library");
            m_system.loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new ClusterException(ne);
        }
        try {
            Trace.out("Before calling native getCRSBaseLoc");
            crsBaseLoc = ClusterNative.getCRSBaseLoc(result);
            Trace.out("After calling native getCRSBaseLoc");
        }
        catch (ClusterNativeException cne) {
            throw new ClusterException(cne);
        }
        return crsBaseLoc;
    }

    @Override
    public HashMap<String, String> getPatchLevel() throws ClusterException {
        HashMap<String, String> patchmap = new HashMap<String, String>();
        String[] nodelist = null;
        String patchlvl = null;
        try {
            nodelist = new ClusterUtil().getNodeNames();
        }
        catch (ClusterUtilException e) {
            throw new ClusterException(e);
        }
        for (String nodename : nodelist) {
            patchlvl = this.getPatchLevelForNode(nodename);
            Trace.out("nodename is " + nodename);
            Trace.out("patch level " + patchlvl);
            patchmap.put(nodename, patchlvl);
        }
        return patchmap;
    }

    @Override
    public int getTargetHubSize() throws ClusterException {
        Trace.out("Getting Target Hub Size");
        int hubsize = 0;
        try {
            Util util = new Util();
            hubsize = util.getTargetHubSize();
        }
        catch (UtilException e) {
            throw new ClusterException(e);
        }
        return hubsize;
    }
}

