/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import oracle.cluster.checkpoints.CheckPoint;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.checkpoints.RemoteCheckPointSession;
import oracle.cluster.impl.checkpoints.CheckPointReader;
import oracle.cluster.impl.checkpoints.CheckPointUtil;
import oracle.cluster.impl.checkpoints.RemoteCheckPointIndexSessionImpl;
import oracle.ops.mgmt.trace.Trace;

public class RemoteCheckPointSessionImpl
implements RemoteCheckPointSession {
    public String checkPointXMLLoc = null;
    public Vector checkPoints = null;
    private Vector failedCheckPoints = null;
    private HashMap failedCheckpointFiles = null;
    private String remoteNode = null;
    private boolean fileSet = true;
    private static RemoteCheckPointIndexSessionImpl oicsIndexSess;
    private String checkpointFileNameOnLocalNode = "";

    public RemoteCheckPointSessionImpl(String remoteNode, String checkPointXMLLoc) {
        CheckPointUtil util = new CheckPointUtil();
        this.checkpointFileNameOnLocalNode = checkPointXMLLoc + "." + remoteNode;
        if (util.fileExists(this.checkpointFileNameOnLocalNode)) {
            this.checkPointXMLLoc = checkPointXMLLoc;
            this.remoteNode = remoteNode;
            CheckPointReader checkpointReader = new CheckPointReader(this.checkpointFileNameOnLocalNode);
            try {
                checkpointReader.buildCheckpoints();
            }
            catch (CheckPointException e) {
                Trace.out("Checkpoint:" + e.getMessage());
            }
            this.checkPoints = checkpointReader.getCheckPoints();
            for (CheckPoint oics : this.checkPoints) {
                if (oics.getCheckPointState() != 2) continue;
                if (this.failedCheckPoints == null) {
                    this.failedCheckPoints = new Vector();
                }
                if (this.fileSet) {
                    if (this.failedCheckpointFiles == null) {
                        this.failedCheckpointFiles = new HashMap();
                    }
                    this.failedCheckpointFiles.put(checkPointXMLLoc, remoteNode);
                    this.fileSet = false;
                }
                this.failedCheckPoints.add(oics);
            }
        } else {
            Trace.out("Checkpoint:CheckpointFile :" + checkPointXMLLoc + " not found,creating one for this session");
        }
    }

    public CheckPoint getCheckPoint(String checkPointName) {
        boolean checkPointFound = false;
        if (this.checkPoints != null) {
            int sizeofList = this.checkPoints.size();
            for (int k = 0; k < sizeofList; ++k) {
                CheckPoint obj = (CheckPoint)this.checkPoints.get(k);
                if (!obj.getCheckPointName().equalsIgnoreCase(checkPointName)) continue;
                checkPointFound = true;
                return obj;
            }
        }
        return null;
    }

    public List getAllCheckPoints() {
        if (this.checkPoints != null) {
            return this.checkPoints;
        }
        return null;
    }

    @Override
    public List getAllFailedCheckPoints() {
        if (this.failedCheckPoints != null) {
            return this.failedCheckPoints;
        }
        return null;
    }

    @Override
    public CheckPoint getLastFailedCheckPoint() {
        if (this.failedCheckPoints != null) {
            return (CheckPoint)this.failedCheckPoints.lastElement();
        }
        return null;
    }

    public HashMap getFailedCheckPointFiles() {
        if (this.failedCheckpointFiles != null) {
            return this.failedCheckpointFiles;
        }
        return null;
    }

    public void setIndexSessionObject(RemoteCheckPointIndexSessionImpl oicsIndexSessref) {
        oicsIndexSess = oicsIndexSessref;
    }

    @Override
    public String getRemoteNode() {
        if (this.remoteNode != null) {
            return this.remoteNode;
        }
        return null;
    }
}

