/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.io.File;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.impl.checkpoints.CheckPointIndexSessionImpl;
import oracle.cluster.impl.checkpoints.CheckPointTcpClient;
import oracle.cluster.resources.PrCbMsgID;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.ClusterUtil;
import oracle.ops.util.Utils;

public class CheckPointUtil {
    private ClusterCmd m_clusterCmd = new ClusterCmd();
    private static MessageBundle s_msgbBundle = MessageBundle.getMessageBundle(PrCbMsgID.facility);

    public boolean fileExists(String sFileName) {
        File fMaster;
        boolean bResult = false;
        if (null != sFileName && (fMaster = new File(sFileName)).exists()) {
            bResult = true;
        }
        return bResult;
    }

    public void removeFile(String sFileName) {
        File file = new File(sFileName);
        if (file.exists()) {
            if (file.delete()) {
                System.err.println("File " + sFileName + " deleted");
            } else {
                System.err.println("File " + sFileName + " could not be deleted");
            }
        } else {
            System.err.println("File " + sFileName + " does not exist.");
        }
    }

    public void removeIndexSessionFiles(CheckPointIndexSessionImpl ckptIndexSession) throws CheckPointException {
        HashMap<String, String[]> ckptFiles = ckptIndexSession.getAllCheckPointFiles();
        HashSet<String> allNodes = new HashSet<String>();
        for (Map.Entry<String, String[]> ckptFile : ckptFiles.entrySet()) {
            String[] nodeList = ckptFile.getValue();
            if (nodeList == null) continue;
            for (String node : nodeList) {
                allNodes.add(node);
            }
        }
        try {
            allNodes.add(Cluster.getLocalNode());
            String[] nodeList = allNodes.toArray(new String[0]);
            this.getClusterCmd().removeDirectory(nodeList, ckptIndexSession.getIndexDir(), true);
        }
        catch (ClusterException e) {
            Trace.out("Checkpoint:" + e.getErrorMessage());
            throw new CheckPointException(e.getMessage());
        }
        if (!ckptIndexSession.isForGlobalCkpts()) {
            for (Map.Entry<String, String[]> ckptFile : ckptFiles.entrySet()) {
                File file = new File(ckptFile.getKey());
                String[] nodeList = ckptFile.getValue();
                if (nodeList == null) continue;
                try {
                    this.getClusterCmd().removeDirectory(nodeList, file.getParent(), true);
                }
                catch (ClusterException e) {
                    Trace.out("Checkpoint:" + e.getErrorMessage());
                    throw new CheckPointException(e.getMessage());
                }
            }
        }
    }

    public void transferGlobalCkptToNodes(String[] nodeList, String ckptFilePath, String indexFilePath) throws CheckPointException {
        if (nodeList != null && nodeList.length != 0) {
            String[] remoteNodes = CheckPointUtil.getRemoteNodes(nodeList);
            String[] aliveNodes = ClusterUtil.findLiveNodes(remoteNodes);
            if (aliveNodes != null && aliveNodes.length != 0) {
                if (remoteNodes.length != aliveNodes.length) {
                    int downNodesCount = remoteNodes.length - aliveNodes.length;
                    String[] downNodes = new String[downNodesCount];
                    int j = 0;
                    for (int i = 0; i < remoteNodes.length; ++i) {
                        boolean isAlive = false;
                        for (int k = 0; k < aliveNodes.length; ++k) {
                            if (!remoteNodes[i].equals(aliveNodes[k])) continue;
                            isAlive = true;
                            break;
                        }
                        if (isAlive) continue;
                        downNodes[j++] = remoteNodes[i];
                    }
                    Trace.out("Could not transfer global checkpoint to down nodes: " + Utils.getString(downNodes, ","));
                }
                this.transferFiles(aliveNodes, ckptFilePath, indexFilePath);
            } else {
                Trace.out("Could not transfer checkpoint to remote nodes, all nodes are down");
            }
        } else {
            Trace.out("Could not transfer checkpoint to remote nodes, node list is empty");
        }
    }

    private void assertFile(String[] nodeList, String filePath) throws CheckPointException {
        File file = new File(filePath);
        if (!file.exists()) {
            Trace.out("Could not find file: " + filePath);
            Object[] args = new Object[]{filePath, Utils.getString(nodeList, ",")};
            String message = MessageBundle.getMessage(PrCbMsgID.CANNOT_TRANSFER_CKPT_FILE_TO_REMOTE_NODES, true, args);
            throw new CheckPointException(message);
        }
    }

    private void transferFiles(String[] nodeList, String ckptFilePath, String indexFilePath) throws CheckPointException {
        boolean retryUsingTcp = false;
        String globalCkptDir = new File(ckptFilePath).getParent();
        this.assertFile(nodeList, ckptFilePath);
        this.assertFile(nodeList, indexFilePath);
        try {
            this.getClusterCmd().createDirWithPermissionsOnNodes(nodeList, globalCkptDir, "700");
            this.getClusterCmd().copyFileToNodes(ckptFilePath, nodeList);
            this.getClusterCmd().copyFileToNodes(indexFilePath, nodeList);
        }
        catch (ClusterException e) {
            Trace.out("ClusterException:" + e.getMessage());
            if (!new SystemFactory().CreateSystem().isUnixSystem()) {
                retryUsingTcp = true;
            }
            throw new CheckPointException(e.getMessage(), e);
        }
        if (retryUsingTcp) {
            try {
                String[] endpointArray;
                String ckpt_endpoint = System.getenv("CKPTSVC") == null ? System.getenv("CKPTSVC") : System.getenv("CKPTSVC").trim();
                String endpointAddress = null;
                int endpointTcpPort = -1;
                Trace.out("Ckpt TCP variable CKPTSVC is " + ckpt_endpoint);
                if (ckpt_endpoint != null && !ckpt_endpoint.equals("") && (endpointArray = ckpt_endpoint.split("_")) != null && endpointArray.length == 2) {
                    endpointAddress = endpointArray[0];
                    endpointTcpPort = Integer.parseInt(endpointArray[1]);
                }
                if (endpointAddress == null || endpointAddress.equals("") || endpointTcpPort <= 0) {
                    String msg = "Failed to get a valid endpoint from env: " + endpointAddress + ":" + endpointTcpPort;
                    throw new CheckPointException(msg);
                }
                CheckPointTcpClient tcpClient = new CheckPointTcpClient();
                Trace.out("Sending to " + endpointAddress + " on port " + endpointTcpPort + " checkpoint file " + ckptFilePath);
                tcpClient.send(endpointAddress, endpointTcpPort, ckptFilePath, nodeList);
                Trace.out("Sending to " + endpointAddress + " on port " + endpointTcpPort + " index file " + indexFilePath);
                tcpClient.send(endpointAddress, endpointTcpPort, indexFilePath, nodeList);
            }
            catch (CheckPointException cpe) {
                Trace.out("CheckPointException:" + cpe.getMessage());
                throw new CheckPointException(cpe.getMessage(), cpe);
            }
        }
    }

    private ClusterCmd getClusterCmd() {
        return this.m_clusterCmd;
    }

    private static String[] getRemoteNodes(String[] nodes) throws CheckPointException {
        Vector<String> remoteNodes = new Vector<String>();
        String localNode = null;
        try {
            localNode = Utils.getLocalNodeName();
        }
        catch (UnknownHostException e) {
            throw new CheckPointException(e.getMessage(), e);
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (localNode.equals(nodes[i])) continue;
            remoteNodes.add(nodes[i]);
        }
        return remoteNodes.toArray(new String[0]);
    }

    private boolean isShared(String dir, String[] nodes) throws CheckPointException {
        try {
            Trace.out("Verifying shareness of dir " + dir + " among nodes " + Utils.getString(nodes, ","));
            return Cluster.isSharedPath(dir, nodes, Utils.getLocalNodeName());
        }
        catch (InvalidNodeListException e) {
            throw new CheckPointException(e.getMessage(), e);
        }
        catch (SharedDeviceException e) {
            throw new CheckPointException(e.getMessage(), e);
        }
        catch (UnknownHostException e) {
            throw new CheckPointException(e.getMessage(), e);
        }
    }

    public static String concatPath(String path1, String path2) {
        if (path1 == null) {
            return path2;
        }
        if (path2 == null) {
            path2 = "";
        }
        if (path1.length() > 0 && path1.charAt(path1.length() - 1) == File.separatorChar) {
            path1 = path1.substring(0, path1.length() - 1);
        }
        if (path2.length() > 0 && path2.charAt(0) == File.separatorChar) {
            path2 = path2.substring(1);
        }
        return path1 + File.separator + path2;
    }
}

