/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.cluster.checkpoints.CheckPoint;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.checkpoints.CheckPointSession;
import oracle.cluster.impl.checkpoints.CheckPointFaultInjectionDesign;
import oracle.cluster.impl.checkpoints.CheckPointImpl;
import oracle.cluster.impl.checkpoints.CheckPointIndexSessionImpl;
import oracle.cluster.impl.checkpoints.CheckPointIndexWriter;
import oracle.cluster.impl.checkpoints.CheckPointReader;
import oracle.cluster.impl.checkpoints.CheckPointUtil;
import oracle.cluster.impl.checkpoints.CheckPointWriter;
import oracle.ops.mgmt.trace.Trace;

public class CheckPointSessionImpl
implements CheckPointSession {
    private String m_ckptsFileLocation = null;
    private Vector m_checkPoints = null;
    private String[] m_nodeList = null;
    private CheckPointIndexSessionImpl m_indexSession;
    private HashMap faultInjectionCheckPointsList = null;
    private boolean isFault = false;

    public CheckPointSessionImpl(String ckptFileLocation) {
        this.m_ckptsFileLocation = ckptFileLocation;
        this.m_checkPoints = new Vector();
        CheckPointUtil util = new CheckPointUtil();
        if (!util.fileExists(this.m_ckptsFileLocation)) {
            Trace.out("Checkpoint:checkpointfile :" + this.m_ckptsFileLocation + " not found, one will be created for this session");
            return;
        }
        try {
            CheckPointReader checkPointReader = new CheckPointReader(this.m_ckptsFileLocation);
            checkPointReader.buildCheckpoints();
            this.m_checkPoints = checkPointReader.getCheckPoints();
        }
        catch (CheckPointException e) {
            Trace.out("Checkpoint:" + e.getMessage());
        }
    }

    @Override
    public void saveCheckPointSession() {
        try {
            CheckPointWriter checkPointWriter = new CheckPointWriter(this.m_ckptsFileLocation);
            checkPointWriter.updateObjects(this.m_checkPoints);
        }
        catch (CheckPointException e) {
            Trace.out("Checkpoint:" + e.getMessage());
        }
        try {
            new CheckPointIndexWriter(this.m_indexSession);
        }
        catch (CheckPointException e) {
            Trace.out("Checkpoint:" + e.getMessage());
        }
        Trace.out("Checkpoint:Index file written and updated");
    }

    @Override
    public void closeCheckPointSession() throws CheckPointException {
        try {
            new CheckPointIndexWriter(this.m_indexSession);
        }
        catch (CheckPointException e) {
            Trace.out("Checkpoint:" + e.getMessage());
            throw e;
        }
        this.testForFaultOccurrence("POSTCOMMIT");
        if (this.getNodeList() == null || this.getNodeList().length == 0) {
            return;
        }
        try {
            Trace.out("Sending checkpoint files to remote nodes");
            CheckPointUtil util = new CheckPointUtil();
            util.transferGlobalCkptToNodes(this.getNodeList(), this.m_ckptsFileLocation, this.m_indexSession.getIndexLocation());
        }
        catch (CheckPointException e) {
            Trace.out("Checkpoint:" + e.getMessage());
            throw e;
        }
        this.testForFaultOccurrence("POSTTRANSFER");
    }

    @Override
    public CheckPoint getCheckPoint(String checkPointName) {
        int sizeofList = this.m_checkPoints.size();
        for (int k = 0; k < sizeofList; ++k) {
            CheckPoint obj = (CheckPoint)this.m_checkPoints.get(k);
            if (!obj.getCheckPointName().equalsIgnoreCase(checkPointName)) continue;
            return obj;
        }
        return null;
    }

    @Override
    public void addCheckPoint(CheckPoint checkPoint) {
        if (this.getFaultMap() != null && checkPoint != null) {
            CheckPointFaultInjectionDesign oicsFault = new CheckPointFaultInjectionDesign();
            oicsFault.checkFaultInjectionScenario(checkPoint, this.getFaultMap(), "BEFORE");
        }
        if (this.m_checkPoints.contains(checkPoint)) {
            int indexOfCheckPoint = this.m_checkPoints.indexOf(checkPoint);
            this.m_checkPoints.removeElementAt(indexOfCheckPoint);
            this.m_checkPoints.add(indexOfCheckPoint, checkPoint);
        } else {
            this.m_checkPoints.add(checkPoint);
        }
        if (this.getFaultMap() != null && checkPoint != null) {
            CheckPointFaultInjectionDesign oicsFault = new CheckPointFaultInjectionDesign();
            oicsFault.checkFaultInjectionScenario(checkPoint, this.getFaultMap(), "POST");
        }
    }

    @Override
    public List getAllCheckPoints() {
        return new Vector(this.m_checkPoints);
    }

    @Override
    public List getAllFailedCheckPoints() {
        Vector<CheckPointImpl> failedCheckPoints = new Vector<CheckPointImpl>();
        for (Object ckpt : this.m_checkPoints) {
            CheckPointImpl checkPoint = (CheckPointImpl)ckpt;
            if (checkPoint.getCheckPointState() != 2) continue;
            failedCheckPoints.add(checkPoint);
        }
        if (!failedCheckPoints.isEmpty()) {
            Trace.out("Checkpoint:Failed Checkpoint found returning it for getAllFailedCheckPoints.");
        }
        return failedCheckPoints;
    }

    @Override
    public CheckPoint getLastFailedCheckPoint() {
        List failedCheckPoints = this.getAllFailedCheckPoints();
        if (failedCheckPoints.isEmpty()) {
            return null;
        }
        int lastFailedCkpt = failedCheckPoints.size() - 1;
        return (CheckPoint)failedCheckPoints.get(lastFailedCkpt);
    }

    @Override
    public String[] getNodeList() {
        if (this.m_nodeList != null) {
            return Arrays.copyOf(this.m_nodeList, this.m_nodeList.length);
        }
        return null;
    }

    public String getFileLocation() {
        return this.m_ckptsFileLocation;
    }

    public void setNodeList(String listOfNodes) {
        this.m_nodeList = listOfNodes != null ? listOfNodes.split(",") : null;
    }

    public void setNodeList(String[] nodes) {
        this.m_nodeList = nodes;
    }

    public boolean hasFailedCheckPoints() {
        return !this.getAllFailedCheckPoints().isEmpty();
    }

    public void setIndexSession(CheckPointIndexSessionImpl indexSession) {
        this.m_indexSession = indexSession;
    }

    @Override
    public void registerFaultInjectionFile(String faultInjectionFileName) throws CheckPointException {
        this.setFaultFlag(true);
        CheckPointUtil util = new CheckPointUtil();
        if (util.fileExists(faultInjectionFileName)) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(faultInjectionFileName));
            }
            catch (IOException io) {
                Trace.out("Checkpoint:" + io.getMessage());
                throw new CheckPointException(io.getMessage());
            }
            CheckPointFaultInjectionDesign oicsFault = new CheckPointFaultInjectionDesign();
            HashMap setOfValsFromPropFile = new HashMap(oicsFault.HashMapFromPropFile(prop));
            this.faultInjectionCheckPointsList = new HashMap(setOfValsFromPropFile);
        } else {
            Trace.out("Checkpoint:File:" + faultInjectionFileName + " not found,not setting faults hashmap.");
            this.setFaultFlag(false);
        }
    }

    @Override
    public void registerFault(String checkPointName, int FaultToOccurAt) {
        this.setFaultFlag(true);
        CheckPointFaultInjectionDesign oicsFault = new CheckPointFaultInjectionDesign();
        String faultAt = oicsFault.getStringEquivalent(FaultToOccurAt);
        if (this.faultInjectionCheckPointsList != null) {
            this.faultInjectionCheckPointsList.put(checkPointName, faultAt);
        } else {
            this.faultInjectionCheckPointsList = new HashMap();
            this.faultInjectionCheckPointsList.put(checkPointName, faultAt);
        }
    }

    private void setFaultFlag(boolean FlagVal) {
        this.isFault = FlagVal;
    }

    @Override
    public HashMap getFaultMap() {
        if (this.faultInjectionCheckPointsList != null) {
            return this.faultInjectionCheckPointsList;
        }
        return null;
    }

    private void testForFaultOccurrence(String state) {
        int count_checkpoints = this.m_checkPoints.size();
        for (int i = 0; i < count_checkpoints; ++i) {
            if (this.m_checkPoints.get(i) == null) continue;
            CheckPoint oicsChkPoint = (CheckPoint)this.m_checkPoints.get(i);
            if (this.getFaultMap() == null || oicsChkPoint == null) continue;
            CheckPointFaultInjectionDesign oicsFault = new CheckPointFaultInjectionDesign();
            oicsFault.checkFaultInjectionScenario(oicsChkPoint, this.getFaultMap(), state);
        }
    }
}

