/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.impl.checkpoints.CheckPointIndexSessionImpl;
import oracle.cluster.impl.checkpoints.CheckPointSessionImpl;
import oracle.cluster.impl.checkpoints.CheckPointUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class CheckPointIndexWriter {
    private String m_fileName = "";
    private CheckPointIndexSessionImpl m_ckptIndexSession = null;

    public CheckPointIndexWriter(CheckPointIndexSessionImpl ckptIndexSession) throws CheckPointException {
        this.m_ckptIndexSession = ckptIndexSession;
        try {
            this.updateObjects();
        }
        catch (IOException io) {
            Trace.out("Checkpoint:" + io.getMessage());
        }
    }

    private void updateObjects() throws IOException, CheckPointException {
        if (this.m_ckptIndexSession == null) {
            Trace.out("Checkpoint:No Index Session Found");
            return;
        }
        Vector<CheckPointSessionImpl> checkPointSessions = this.m_ckptIndexSession.getAllCheckPointSessions();
        int size = checkPointSessions.size();
        this.m_fileName = this.m_ckptIndexSession.getIndexLocation();
        File oOutputFile = new File(this.m_fileName);
        File outputDir = oOutputFile.getParentFile();
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        FileOutputStream fWriter = new FileOutputStream(this.m_fileName);
        OutputStreamWriter oWriter = new OutputStreamWriter((OutputStream)fWriter, "UTF-8");
        BufferedWriter bWriter = new BufferedWriter(oWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        pWriter.println(OixsXMLOps.createXMLDirective((boolean)true));
        pWriter.println(OixsXMLOps.getStandardHeader());
        XMLElement elemCheckPoints = new XMLElement("INDEX");
        if (checkPointSessions.size() > 0) {
            elemCheckPoints = this.generateCheckPointIndexNode(elemCheckPoints);
            elemCheckPoints.print(pWriter);
            try {
                pWriter.close();
                bWriter.close();
                oWriter.close();
                fWriter.close();
            }
            catch (IOException e) {
                Trace.out("Checkpoint:" + e.getMessage());
                throw new CheckPointException(e.getMessage());
            }
        } else {
            CheckPointUtil util = new CheckPointUtil();
            util.removeFile(this.m_fileName);
        }
    }

    private XMLElement generateCheckPointIndexNode(XMLElement elemCheckPoints) {
        String xmlLoc = null;
        String[] nodeList = null;
        Vector<CheckPointSessionImpl> checkPointSessions = this.m_ckptIndexSession.getAllCheckPointSessions();
        int count_checkpoints = checkPointSessions.size();
        for (int i = 0; i < count_checkpoints; ++i) {
            CheckPointSessionImpl checkPointSession = null;
            nodeList = null;
            if (checkPointSessions.get(i) == null) continue;
            XMLElement CHECKPOINTSESSIONElement = new XMLElement("CHECKPOINT_SESSION");
            checkPointSession = checkPointSessions.get(i);
            xmlLoc = checkPointSession.getFileLocation();
            if (checkPointSession.getNodeList() != null) {
                nodeList = checkPointSession.getNodeList();
            }
            if (nodeList != null) {
                CHECKPOINTSESSIONElement.appendChild((Node)this.generatePropertiesNode(xmlLoc, nodeList, checkPointSession));
            } else {
                CHECKPOINTSESSIONElement.appendChild((Node)this.generatePropertiesNode(xmlLoc, checkPointSession));
            }
            elemCheckPoints.appendChild((Node)CHECKPOINTSESSIONElement);
        }
        return elemCheckPoints;
    }

    private XMLElement generatePropertiesNode(String xmlFile, CheckPointSessionImpl checkPointSession) {
        XMLElement CHECKPOINTSESSIONElement = new XMLElement("PROPERTY_LIST");
        XMLElement elemProperty = new XMLElement("PROPERTY");
        elemProperty.setAttribute("NAME", "CHECKPOINT_FILE_LOCATION");
        elemProperty.setAttribute("VAL", xmlFile);
        if (checkPointSession.getLastFailedCheckPoint() != null) {
            elemProperty.setAttribute("STATUS", "FAIL");
        } else {
            elemProperty.setAttribute("STATUS", "SUCCESS");
        }
        CHECKPOINTSESSIONElement.appendChild((Node)elemProperty);
        return CHECKPOINTSESSIONElement;
    }

    private XMLElement generatePropertiesNode(String xmlFile, String[] nodes, CheckPointSessionImpl checkPointSession) {
        XMLElement CHECKPOINTSESSIONElement = new XMLElement("PROPERTY_LIST");
        XMLElement elemProperty = new XMLElement("PROPERTY");
        elemProperty.setAttribute("NAME", "CHECKPOINT_FILE_LOCATION");
        elemProperty.setAttribute("VAL", xmlFile);
        if (checkPointSession.getLastFailedCheckPoint() != null) {
            elemProperty.setAttribute("STATUS", "FAIL");
            Trace.out("Checkpoint:Setting status in index file as failed,as last checkpoint failed is available.");
        } else {
            elemProperty.setAttribute("STATUS", "SUCCESS");
            Trace.out("Checkpoint:Setting status in index file as passed,as no last failed checkpoint is available.");
        }
        XMLElement elemProperty1 = new XMLElement("PROPERTY");
        elemProperty1.setAttribute("NAME", "NODE_LIST");
        if (nodes.length > 1) {
            elemProperty1.setAttribute("TYPE", "STRINGLIST");
        } else {
            elemProperty1.setAttribute("TYPE", "STRING");
        }
        String nodeList = Utils.getString(nodes, ",");
        elemProperty1.setAttribute("VAL", nodeList);
        CHECKPOINTSESSIONElement.appendChild((Node)elemProperty);
        CHECKPOINTSESSIONElement.appendChild((Node)elemProperty1);
        return CHECKPOINTSESSIONElement;
    }
}

