/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.checkpoints.CheckPointIndexSession;
import oracle.cluster.checkpoints.CheckPointSession;
import oracle.cluster.impl.checkpoints.CheckPointIndexReader;
import oracle.cluster.impl.checkpoints.CheckPointSessionImpl;
import oracle.cluster.impl.checkpoints.CheckPointUtil;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;

public class CheckPointIndexSessionImpl
implements CheckPointIndexSession {
    private String m_component;
    private String m_oracleBase;
    private HashMap<String, CheckPointSessionImpl> m_checkPointSessions;
    private boolean m_forGlobalCkpts;
    private final String CRSDATA_DIR_NAME = "crsdata";
    private final String GLOBAL_DIR_NAME = "@global";

    public CheckPointIndexSessionImpl(String oracleBase, String component, boolean forGlobalCkpts) {
        this.m_oracleBase = oracleBase;
        this.m_component = component;
        this.m_forGlobalCkpts = forGlobalCkpts;
        this.m_checkPointSessions = new HashMap();
        if (!this.isIndexFileExists()) {
            Trace.out("Checkpoint:Index file :" + this.getIndexLocation() + " not found.");
            return;
        }
        Trace.out("Checkpoint:Index file :" + this.getIndexLocation() + " found.");
        CheckPointIndexReader checkPointIndexReader = new CheckPointIndexReader(this.getIndexLocation());
        try {
            checkPointIndexReader.buildIndex();
        }
        catch (CheckPointException e) {
            Trace.out("Checkpoint:" + e.getMessage());
        }
        HashMap checkPointFiles = checkPointIndexReader.getCheckPointsFiles();
        if (checkPointFiles.isEmpty()) {
            Trace.out("Checkpoint:No checkpoint file written .");
            return;
        }
        for (Map.Entry entry : checkPointFiles.entrySet()) {
            String checkPointFile = (String)entry.getKey();
            String[] nodes = (String[])entry.getValue();
            CheckPointSessionImpl checkPointSession = new CheckPointSessionImpl(checkPointFile);
            checkPointSession.setIndexSession(this);
            checkPointSession.setNodeList(nodes);
            this.m_checkPointSessions.put(checkPointFile, checkPointSession);
        }
    }

    @Override
    public CheckPointSession initCheckPointSession(String checkPointFileLocation) {
        return this.initCheckPointSession(checkPointFileLocation, null);
    }

    @Override
    public void cleanCheckPointSession(String checkPointFileLocation) {
        this.m_checkPointSessions.remove(checkPointFileLocation);
    }

    @Override
    public CheckPointSession initCheckPointSession(String checkPointFileLocation, String[] nodeList) {
        CheckPointSessionImpl checkPointSession;
        if (nodeList != null) {
            try {
                ClusterCmd clusterCmd = new ClusterCmd();
                clusterCmd.createDirInNodes(nodeList, this.getIndexDir());
            }
            catch (ClusterException e) {
                Trace.out("Checkpoint:" + e.getMessage());
            }
        }
        if ((checkPointSession = this.m_checkPointSessions.get(checkPointFileLocation)) == null) {
            checkPointSession = new CheckPointSessionImpl(checkPointFileLocation);
            checkPointSession.setIndexSession(this);
            this.m_checkPointSessions.put(checkPointFileLocation, checkPointSession);
        }
        checkPointSession.setNodeList(nodeList);
        return checkPointSession;
    }

    @Override
    public CheckPointSession getCheckPointSession(String checkPointFileLocation) {
        return this.m_checkPointSessions.get(checkPointFileLocation);
    }

    @Override
    public boolean isIndexFileExists() {
        CheckPointUtil util = new CheckPointUtil();
        return util.fileExists(this.getIndexLocation());
    }

    public boolean isForGlobalCkpts() {
        return this.m_forGlobalCkpts;
    }

    @Override
    public HashMap<String, String[]> getFailedCheckPointFiles() {
        HashMap<String, String[]> failedCheckPointFiles = new HashMap<String, String[]>();
        for (Map.Entry<String, CheckPointSessionImpl> entry : this.m_checkPointSessions.entrySet()) {
            String ckptFileLocation = entry.getKey();
            CheckPointSessionImpl checkPointSession = entry.getValue();
            if (!checkPointSession.hasFailedCheckPoints()) continue;
            failedCheckPointFiles.put(ckptFileLocation, checkPointSession.getNodeList());
        }
        return failedCheckPointFiles;
    }

    @Override
    public HashMap<String, String[]> getAllCheckPointFiles() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Map.Entry<String, CheckPointSessionImpl> entry : this.m_checkPointSessions.entrySet()) {
            String ckptFileLocation = entry.getKey();
            CheckPointSessionImpl checkPointSession = entry.getValue();
            result.put(ckptFileLocation, checkPointSession.getNodeList());
        }
        return result;
    }

    public Vector<CheckPointSessionImpl> getAllCheckPointSessions() {
        return new Vector<CheckPointSessionImpl>(this.m_checkPointSessions.values());
    }

    public String getOracleBase() {
        return this.m_oracleBase;
    }

    public String getIndexDir() {
        String dir = this.m_oracleBase;
        if (this.m_forGlobalCkpts) {
            dir = CheckPointUtil.concatPath(dir, "crsdata");
            dir = CheckPointUtil.concatPath(dir, "@global");
        } else {
            dir = CheckPointUtil.concatPath(dir, "checkpoints");
        }
        dir = CheckPointUtil.concatPath(dir, this.m_component);
        return dir;
    }

    public String getIndexLocation() {
        String location = this.getIndexDir();
        location = CheckPointUtil.concatPath(location, "index.xml");
        return location;
    }

    @Override
    public void closeCheckPointIndexSession() throws CheckPointException {
        if (!this.isIndexFileExists()) {
            Trace.out("Checkpoint:No Index File Written in this session.");
            return;
        }
        Trace.out("Checkpoint:Index file :" + this.getIndexLocation() + " written in this session, found.");
        CheckPointIndexReader checkPointIndexReader = new CheckPointIndexReader(this.getIndexLocation());
        try {
            checkPointIndexReader.buildIndex();
        }
        catch (CheckPointException e) {
            Trace.out("Checkpoint:" + e.getMessage());
            return;
        }
        if (!checkPointIndexReader.HasFailedCheckPoints()) {
            CheckPointUtil util = new CheckPointUtil();
            util.removeIndexSessionFiles(this);
        }
    }
}

