/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.resources.PrCbMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.oix.oixd.OixdDOMReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CheckPointIndexReaderFailedChecks {
    public static Vector checkPoints;
    public static String m_IndexXMLLoc;
    public static HashMap m_allCheckPointFiles;
    private static boolean state;
    private static MessageBundle s_msgbBundle;

    public CheckPointIndexReaderFailedChecks(String indexXMLLoc) {
        m_IndexXMLLoc = indexXMLLoc;
    }

    public boolean getIndexState() throws CheckPointException {
        try {
            Document oDoc = OixdDOMReader.getDocument((String)m_IndexXMLLoc);
            this.build(oDoc, m_IndexXMLLoc);
        }
        catch (IOException e) {
            Trace.out("Checkpoint:" + e.getMessage());
            String[] args = new String[]{m_IndexXMLLoc, e.getMessage()};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.CANNOT_BUILD_KNOWLEDGE_SOURCE_IO, true, args));
        }
        catch (SAXException e) {
            Trace.out("Checkpoint:" + e.getMessage());
            String[] args = new String[]{m_IndexXMLLoc, e.getMessage()};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.CANNOT_BUILD_KNOWLEDGE_SOURCE_SAX, true, args));
        }
        catch (ParserConfigurationException e) {
            Trace.out("Checkpoint:" + e.getMessage());
            String[] args = new String[]{m_IndexXMLLoc, e.getMessage()};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.CANNOT_BUILD_KNOWLEDGE_SOURCE_PARSER, true, args));
        }
        return state;
    }

    private void build(Document oDoc, String sFileName) throws CheckPointException {
        if (oDoc != null) {
            Element root = oDoc.getDocumentElement();
            if (!root.getTagName().equalsIgnoreCase("INDEX")) {
                Trace.out("Checkpoint:Invalid index.xml format of file:" + sFileName);
                String[] args = new String[]{sFileName};
                throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.INVALID_CHECK_POINT_DOCUMENT, true, args));
            }
            NodeList oCheckpointSessionDetailNodes = root.getChildNodes();
            if (oCheckpointSessionDetailNodes != null) {
                int nCheckpointSessionDetailNodes = oCheckpointSessionDetailNodes.getLength();
                for (int i = 0; i < nCheckpointSessionDetailNodes; ++i) {
                    NodeList oPropertyListNodes;
                    Node oCheckpointSessionDetailNode = oCheckpointSessionDetailNodes.item(i);
                    if (oCheckpointSessionDetailNode.getNodeType() != 1 || oCheckpointSessionDetailNode == null || !oCheckpointSessionDetailNode.getNodeName().equalsIgnoreCase("CHECKPOINT_SESSION") || (oPropertyListNodes = oCheckpointSessionDetailNode.getChildNodes()) == null) continue;
                    int nPropertyListNodes = oPropertyListNodes.getLength();
                    for (int j = 0; j < nPropertyListNodes; ++j) {
                        Node oPropertyNodes = oPropertyListNodes.item(j);
                        if (oPropertyNodes == null || oPropertyNodes.getNodeType() != 1 || oPropertyNodes == null || !oPropertyNodes.getNodeName().equalsIgnoreCase("PROPERTY_LIST")) continue;
                        this.constructPropertyList(oPropertyNodes);
                    }
                }
            }
        }
    }

    private void constructPropertyList(Node oPropertyNodes1) throws CheckPointException {
        Node oAttrib = null;
        NodeList oPropertyNodes = oPropertyNodes1.getChildNodes();
        NamedNodeMap oPropertyNodeAttribs = null;
        int nPropertyNodes = oPropertyNodes.getLength();
        String attrName = "";
        String attrValue = "";
        String attrValueStatus = "";
        boolean setname = false;
        for (int k = 0; k < nPropertyNodes; ++k) {
            Node oPropertyNode = oPropertyNodes.item(k);
            if (oPropertyNode == null || (oPropertyNodeAttribs = oPropertyNode.getAttributes()) == null) continue;
            oAttrib = oPropertyNodeAttribs.getNamedItem("NAME");
            if (oAttrib != null) {
                attrName = oAttrib.getNodeValue();
            }
            if ((oAttrib = oPropertyNodeAttribs.getNamedItem("STATUS")) == null) continue;
            attrValue = oAttrib.getNodeValue();
            if (!attrName.equalsIgnoreCase("CHECKPOINT_FILE_LOCATION")) continue;
            setname = true;
            attrValueStatus = attrValue;
            if (attrValueStatus.equalsIgnoreCase("SUCCESS")) continue;
            state = false;
            break;
        }
    }

    static {
        m_allCheckPointFiles = null;
        state = true;
        s_msgbBundle = MessageBundle.getMessageBundle(PrCbMsgID.facility);
    }
}

