/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.resources.PrCbMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.oix.oixd.OixdDOMReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CheckPointIndexReader {
    private HashMap<String, String[]> m_checkPointsFiles = new HashMap();
    private String m_indexFileLocation;
    private boolean m_hasFailedCheckPoints;
    private static MessageBundle s_msgbBundle = MessageBundle.getMessageBundle(PrCbMsgID.facility);

    public CheckPointIndexReader(String indexFileLocation) {
        this.m_indexFileLocation = indexFileLocation;
    }

    public void buildIndex() throws CheckPointException {
        try {
            Document document = OixdDOMReader.getDocument((String)this.m_indexFileLocation);
            this.build(document);
        }
        catch (IOException e) {
            Trace.out(e.getMessage());
            String[] args = new String[]{this.m_indexFileLocation, e.getMessage()};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.CANNOT_BUILD_KNOWLEDGE_SOURCE_IO, true, args));
        }
        catch (SAXException e) {
            Trace.out(e.getMessage());
            String[] args = new String[]{this.m_indexFileLocation, e.getMessage()};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.CANNOT_BUILD_KNOWLEDGE_SOURCE_SAX, true, args));
        }
        catch (ParserConfigurationException e) {
            Trace.out(e.getMessage());
            String[] args = new String[]{this.m_indexFileLocation, e.getMessage()};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.CANNOT_BUILD_KNOWLEDGE_SOURCE_PARSER, true, args));
        }
    }

    public HashMap getCheckPointsFiles() {
        return new HashMap<String, String[]>(this.m_checkPointsFiles);
    }

    public boolean HasFailedCheckPoints() {
        return this.m_hasFailedCheckPoints;
    }

    private void build(Document document) throws CheckPointException {
        if (document == null) {
            return;
        }
        Element root = document.getDocumentElement();
        if (!root.getTagName().equalsIgnoreCase("INDEX")) {
            Trace.out("Invalid index.xml format of file:" + this.m_indexFileLocation);
            String[] args = new String[]{this.m_indexFileLocation};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.INVALID_CHECK_POINT_DOCUMENT, true, args));
        }
        this.readCheckPointsSessions(root.getChildNodes());
    }

    private void readCheckPointsSessions(NodeList checkPointSessions) {
        int ckptSessionsCount = checkPointSessions.getLength();
        for (int i = 0; i < ckptSessionsCount; ++i) {
            Node checkPointSession = checkPointSessions.item(i);
            if (checkPointSession.getNodeType() != 1 || !checkPointSession.getNodeName().equalsIgnoreCase("CHECKPOINT_SESSION")) continue;
            this.readPropertyLists(checkPointSession.getChildNodes());
        }
    }

    private void readPropertyLists(NodeList propertyLists) {
        int listsCount = propertyLists.getLength();
        for (int i = 0; i < listsCount; ++i) {
            Node propertyList = propertyLists.item(i);
            if (propertyList.getNodeType() != 1 || !propertyList.getNodeName().equalsIgnoreCase("PROPERTY_LIST")) continue;
            this.readPropertyList(propertyList.getChildNodes());
        }
    }

    private void readPropertyList(NodeList propertyList) {
        String fileLocation = "";
        String[] nodes = null;
        int propertiesCount = propertyList.getLength();
        for (int i = 0; i < propertiesCount; ++i) {
            NamedNodeMap attributes;
            Node property = propertyList.item(i);
            if (property.getNodeType() != 1 || !property.getNodeName().equalsIgnoreCase("PROPERTY") || (attributes = property.getAttributes()) == null) continue;
            String propertyName = "";
            Node attribute = attributes.getNamedItem("NAME");
            if (attribute != null) {
                propertyName = attribute.getNodeValue();
            }
            if (propertyName.equalsIgnoreCase("CHECKPOINT_FILE_LOCATION")) {
                attribute = attributes.getNamedItem("VAL");
                if (attribute != null) {
                    fileLocation = attribute.getNodeValue();
                }
                if ((attribute = attributes.getNamedItem("STATUS")) == null) continue;
                String status = attribute.getNodeValue();
                this.m_hasFailedCheckPoints |= !status.equalsIgnoreCase("SUCCESS");
                continue;
            }
            if (!propertyName.equalsIgnoreCase("NODE_LIST") || (attribute = attributes.getNamedItem("VAL")) == null) continue;
            String nodeList = attribute.getNodeValue();
            nodes = nodeList.split(",");
        }
        this.m_checkPointsFiles.put(fileLocation, nodes);
    }
}

