/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.cha;

import java.util.HashMap;
import java.util.Map;
import oracle.cluster.cha.CHAStatus;
import oracle.cluster.cha.CompositeCHAStatus;
import oracle.cluster.impl.cha.CHAStatusImpl;
import oracle.cluster.impl.crs.CompositeActionStatusImpl;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class CompositeCHAStatusImpl
extends CompositeActionStatusImpl
implements CompositeCHAStatus {
    private static final String LSEP = System.getProperty("line.separator");
    Map<Node, CHAStatus> m_statMap = new HashMap<Node, CHAStatus>();

    CompositeCHAStatusImpl() {
    }

    CompositeCHAStatusImpl(Node[] nodes) {
        this.setNodes(nodes);
    }

    public void setNodes(Node[] nodes) {
        if (null != nodes) {
            for (Node node : nodes) {
                this.m_statMap.put(node, new CHAStatusImpl());
            }
        }
    }

    @Override
    public CHAStatus getCHAStatus(Node node) {
        return this.m_statMap.get(node);
    }

    @Override
    public Map<Node, CHAStatus> getAllCHAStatus() {
        return this.m_statMap;
    }

    void addCHAStatusImpl(Node node, CHAStatusImpl stat) {
        this.m_statMap.put(node, stat);
    }

    @Override
    public boolean isError() {
        for (Node node : this.m_statMap.keySet()) {
            CHAStatus cs = this.getCHAStatus(node);
            if (!cs.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuccess() {
        boolean anySuccess = false;
        boolean anyError = false;
        for (Node node : this.m_statMap.keySet()) {
            CHAStatusImpl cs = (CHAStatusImpl)this.getCHAStatus(node);
            if (!(cs.isWarning() || cs.isError() || cs.isNOOP())) {
                anySuccess = true;
                continue;
            }
            if (!cs.isError()) continue;
            anyError = true;
        }
        return !anyError && anySuccess;
    }

    @Override
    public boolean isWarning() {
        boolean warningFound = false;
        for (Node node : this.m_statMap.keySet()) {
            CHAStatusImpl cs = (CHAStatusImpl)this.getCHAStatus(node);
            if (cs.isError()) {
                return false;
            }
            if (cs.isWarning()) {
                warningFound = true;
                continue;
            }
            if (cs.isNOOP()) continue;
            return false;
        }
        return warningFound;
    }

    @Override
    public String getErrorMessage() {
        StringBuilder failedMsg = new StringBuilder();
        for (Node node : this.m_statMap.keySet()) {
            try {
                CHAStatus cs = this.getCHAStatus(node);
                if (!cs.isError() && !cs.isWarning()) continue;
                String nodeName = node.getName();
                failedMsg.append(nodeName);
                failedMsg.append(":");
                failedMsg.append(cs.getErrorMessage());
                failedMsg.append(LSEP);
            }
            catch (NodeException e) {
                Trace.out("WARNING: node name could not be found.");
            }
        }
        return failedMsg.toString();
    }
}

