/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.cha;

import oracle.cluster.cha.CHA;
import oracle.cluster.cha.CHADBConnection;
import oracle.cluster.cha.CHAException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.DBConnectionException;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.impl.cha.CHADBConnectionImpl;
import oracle.cluster.impl.cha.CHAImpl;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrClMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageKey;

public class CHAFactoryImpl {
    private static CHAFactoryImpl s_instance;
    private static String m_crsHome;

    private CHAFactoryImpl() throws SoftwareModuleException {
        try {
            m_crsHome = new Util().getCRSHome();
        }
        catch (UtilException e) {
            throw new SoftwareModuleException(e);
        }
    }

    public static synchronized CHAFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new CHAFactoryImpl();
        }
        return s_instance;
    }

    public CHA createCHA(Version version, boolean isForce) throws AlreadyExistsException, CHAException {
        if (null == version) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version", version);
        }
        try {
            CHAImpl chaImpl = new CHAImpl(CRSFactoryImpl.getInstance().create(ResourceType.CHAD.NAME.name(), CHAImpl.getResourceName()));
            chaImpl.create(version, isForce);
            return chaImpl;
        }
        catch (CRSException e) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_CREATE_FAILED, (Throwable)e, version.toString());
        }
    }

    public CHA getCHA() throws NotExistsException, CHAException {
        try {
            CHAImpl chaImpl = new CHAImpl(CRSFactoryImpl.getInstance().create(ResourceType.CHAD.NAME.name(), CHAImpl.getResourceName()));
            CRSResource crsRes = chaImpl.crsResource();
            return chaImpl;
        }
        catch (CRSException e) {
            throw new CHAException(e);
        }
        catch (SoftwareModuleException e) {
            throw new CHAException(e);
        }
    }

    public CHADBConnection createDBConnection() throws CHAException, DBConnectionException, DatabaseException {
        CHADBConnectionImpl chadbcon = new CHADBConnectionImpl();
        return chadbcon;
    }
}

