/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.adminhelper;

import oracle.cluster.adminhelper.AdminHelper;
import oracle.cluster.adminhelper.AdminHelperException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.impl.adminhelper.AdminHelperImpl;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class AdminHelperFactoryImpl {
    private static AdminHelperFactoryImpl s_instance;

    private AdminHelperFactoryImpl() throws SoftwareModuleException {
    }

    public static synchronized AdminHelperFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new AdminHelperFactoryImpl();
        }
        return s_instance;
    }

    public AdminHelper createAdminHelper(Version version) throws AlreadyExistsException, AdminHelperException {
        if (version == null) {
            throw new AdminHelperException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        String resourceName = "";
        try {
            resourceName = AdminHelperImpl.getDefaultResourceName();
            AdminHelperImpl admsImpl = new AdminHelperImpl(CRSFactoryImpl.getInstance().create(ResourceType.ADMINHELPER.NAME.name(), resourceName));
            admsImpl.create(version);
            return admsImpl;
        }
        catch (CRSException e) {
            throw new AdminHelperException((MessageKey)PrCcMsgID.CREATE_ADMHELPER_FAILED, resourceName, e);
        }
    }

    public AdminHelper createAdminHelper(String resourceName, Version version) throws AlreadyExistsException, AdminHelperException {
        if (version == null) {
            throw new AdminHelperException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        try {
            AdminHelperImpl admsImpl = new AdminHelperImpl(CRSFactoryImpl.getInstance().create(ResourceType.ADMINHELPER.NAME.name(), resourceName));
            admsImpl.create(version);
            return admsImpl;
        }
        catch (CRSException e) {
            throw new AdminHelperException((MessageKey)PrCcMsgID.CREATE_ADMHELPER_FAILED, resourceName, e);
        }
    }

    public AdminHelper getAdminHelper() throws NotExistsException, AdminHelperException {
        try {
            AdminHelperImpl admsImpl = new AdminHelperImpl(CRSFactoryImpl.getInstance().create(ResourceType.ADMINHELPER.NAME.name(), AdminHelperImpl.getDefaultResourceName()));
            Trace.out("adminHelper m_nameAttr.getValue() : " + admsImpl.getAdminHelperResourceName());
            CRSResource crsRes = admsImpl.crsResource();
            return admsImpl;
        }
        catch (CRSException e) {
            throw new AdminHelperException(e);
        }
        catch (SoftwareModuleException e) {
            throw new AdminHelperException(e);
        }
    }

    public AdminHelper getAdminHelper(String resourceName) throws NotExistsException, AdminHelperException {
        try {
            Trace.out("resourceName :  " + resourceName);
            AdminHelperImpl admsImpl = new AdminHelperImpl(CRSFactoryImpl.getInstance().create(ResourceType.ADMINHELPER.NAME.name(), resourceName));
            Trace.out("adminHelper m_nameAttr.getValue() : " + admsImpl.getAdminHelperResourceName());
            CRSResource crsRes = admsImpl.crsResource();
            return admsImpl;
        }
        catch (CRSException e) {
            throw new AdminHelperException(e);
        }
        catch (SoftwareModuleException e) {
            throw new AdminHelperException(e);
        }
    }
}

