/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.home;

import java.util.List;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.Database;
import oracle.cluster.home.HomeArgs;
import oracle.cluster.home.HomeException;
import oracle.cluster.home.HomeType;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;

public interface OracleHome
extends SoftwareModule {
    public CRSResource crsResource() throws NotExistsException, SoftwareModuleException;

    public String getHomeName() throws HomeException;

    public String getPath() throws HomeException;

    public HomeType getHomeType() throws HomeException;

    public List<Node> getNodes() throws HomeException;

    public boolean isSharedHome() throws HomeException;

    public List<Database> getDatabases() throws HomeException;

    public List<Listener> getListeners() throws HomeException;

    public String getOracleBase() throws HomeException;

    public void start(List<Node> var1) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException;

    public void stop(List<Node> var1, boolean var2) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException;

    public void remove(boolean var1) throws AlreadyRunningException, SoftwareModuleException;

    public void enable(List<Node> var1) throws AlreadyEnabledException, CompositeOperationException, SoftwareModuleException;

    public void disable(List<Node> var1) throws AlreadyDisabledException, CompositeOperationException, SoftwareModuleException;

    public void modify(HomeArgs var1) throws HomeException;
}

